/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampObjectInspector;

public class LazyTimestamp
extends LazyPrimitive<LazyTimestampObjectInspector, TimestampWritableV2> {
    public LazyTimestamp(LazyTimestampObjectInspector oi) {
        super(oi);
        this.data = new TimestampWritableV2();
    }

    public LazyTimestamp(LazyTimestamp copy) {
        super(copy);
        this.data = new TimestampWritableV2((TimestampWritableV2)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        if (!LazyUtils.isDateMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        String s2 = new String(bytes.getData(), start, length, StandardCharsets.US_ASCII);
        Timestamp t = ((LazyTimestampObjectInspector)this.oi).getTimestampParser().parseTimestamp(s2);
        if (t == null) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "TIMESTAMP");
        } else {
            this.isNull = false;
        }
        ((TimestampWritableV2)this.data).set(t);
    }

    public static void writeUTF8(OutputStream out, TimestampWritableV2 i) throws IOException {
        byte[] b = TimestampWritableV2.nullBytes;
        if (i != null) {
            b = i.toString().getBytes(StandardCharsets.US_ASCII);
        }
        out.write(b);
    }

    @Override
    public TimestampWritableV2 getWritableObject() {
        return (TimestampWritableV2)this.data;
    }
}

