/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;

public class DelegationTokenSecretManager
extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
    public DelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
        super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
    }

    @Override
    public DelegationTokenIdentifier createIdentifier() {
        return new DelegationTokenIdentifier();
    }

    public synchronized String verifyDelegationToken(String tokenStrForm) throws IOException {
        Token<DelegationTokenIdentifier> t = new Token<DelegationTokenIdentifier>();
        t.decodeFromUrlString(tokenStrForm);
        DelegationTokenIdentifier id = this.getTokenIdentifier(t);
        this.verifyToken(id, t.getPassword());
        return id.getUser().getShortUserName();
    }

    protected DelegationTokenIdentifier getTokenIdentifier(Token<DelegationTokenIdentifier> token) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        DelegationTokenIdentifier id = this.createIdentifier();
        id.readFields(in);
        return id;
    }

    public synchronized void cancelDelegationToken(String tokenStrForm) throws IOException {
        Token t = new Token();
        t.decodeFromUrlString(tokenStrForm);
        String user = UserGroupInformation.getCurrentUser().getUserName();
        this.cancelToken(t, user);
    }

    public synchronized long renewDelegationToken(String tokenStrForm) throws IOException {
        Token t = new Token();
        t.decodeFromUrlString(tokenStrForm);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        return this.renewToken(t, user);
    }

    public synchronized String getDelegationToken(String ownerStr, String renewer) throws IOException {
        if (ownerStr == null) {
            throw new RuntimeException("Delegation token owner is null");
        }
        Text owner = new Text(ownerStr);
        Text realUser = null;
        UserGroupInformation currentUgi = UserGroupInformation.getCurrentUser();
        if (currentUgi.getUserName() != null) {
            realUser = new Text(currentUgi.getUserName());
        }
        DelegationTokenIdentifier ident = new DelegationTokenIdentifier(owner, new Text(renewer), realUser);
        Token<DelegationTokenIdentifier> t = new Token<DelegationTokenIdentifier>(ident, this);
        return t.encodeToUrlString();
    }

    public String getUserFromToken(String tokenStr) throws IOException {
        Token delegationToken = new Token();
        delegationToken.decodeFromUrlString(tokenStr);
        ByteArrayInputStream buf = new ByteArrayInputStream(delegationToken.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        DelegationTokenIdentifier id = this.createIdentifier();
        id.readFields(in);
        return id.getUser().getShortUserName();
    }
}

