/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SoftCache<K, V> {
    private static final int CACHE_CAPACITY = 64;
    private static final float LOAD_FACTOR = 0.75f;
    private final boolean synchro;
    private final int capacity;
    private final float loadFactor;
    private SoftReference<Map<K, V>> ref = null;

    public SoftCache() {
        this(64);
    }

    public SoftCache(int theCapacity) {
        this(theCapacity, 0.75f, false);
    }

    public SoftCache(int theCapacity, float theLoadFactor, boolean synchronizd) {
        this.capacity = theCapacity;
        this.loadFactor = theLoadFactor;
        this.synchro = synchronizd;
    }

    public int capacity() {
        return this.capacity;
    }

    public int size() {
        Map<K, V> map = this.ref != null ? this.ref.get() : null;
        return map != null ? map.size() : 0;
    }

    public void clear() {
        this.ref = null;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        Map<K, V> map = this.ref != null ? this.ref.get() : null;
        return map != null ? map.entrySet() : Collections.emptySet();
    }

    public Collection<V> values() {
        Map<K, V> map = this.ref != null ? this.ref.get() : null;
        return map != null ? map.values() : Collections.emptyList();
    }

    public boolean containsKey(K key) {
        Map<K, V> map = this.ref != null ? this.ref.get() : null;
        return map != null && map.containsKey(key);
    }

    public V get(K key) {
        Map<K, V> map = this.ref != null ? this.ref.get() : null;
        return map != null ? (V)map.get(key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, V> map() {
        Map<K, V> map;
        Map<K, V> map2 = map = this.ref != null ? this.ref.get() : null;
        if (map == null) {
            SoftCache softCache = this;
            synchronized (softCache) {
                Map<K, V> map3 = map = this.ref != null ? this.ref.get() : null;
                if (map == null) {
                    map = this.createCache(this.capacity, this.loadFactor, this.synchro);
                    this.ref = new SoftReference<Map<K, V>>(map);
                }
            }
        }
        return map;
    }

    public V put(K key, V value) {
        return this.map().put(key, value);
    }

    public V putIfAbsent(K key, V value) {
        return this.map().putIfAbsent(key, value);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.map().computeIfAbsent((K)key, mappingFunction);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map().compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    public V remove(K key) {
        Map<K, V> map;
        if (this.ref != null && (map = this.ref.get()) != null) {
            return map.remove(key);
        }
        return null;
    }

    protected Map<K, V> createCache(int capacity, float loadFactor, boolean synchro) {
        CacheMap cache = new CacheMap(capacity, loadFactor);
        if (synchro) {
            return Collections.synchronizedMap(cache);
        }
        return cache;
    }

    private static class CacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 202304041726L;
        private final int capacity;

        public CacheMap(int capacity, float loadFactor) {
            super(capacity, loadFactor, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.capacity;
        }
    }
}

