/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.DefaultHiveMetaHook;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.MetaStorePlainSaslHelper;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableIterable;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AbortCompactResponse;
import org.apache.hadoop.hive.metastore.api.AbortCompactionRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddCheckConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDefaultConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AddForeignKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddNotNullConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddPackageRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsResult;
import org.apache.hadoop.hive.metastore.api.AddPrimaryKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddUniqueConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.AlterCatalogRequest;
import org.apache.hadoop.hive.metastore.api.AlterDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.AlterDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.AlterISchemaRequest;
import org.apache.hadoop.hive.metastore.api.AlterPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AlterTableRequest;
import org.apache.hadoop.hive.metastore.api.AppendPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.ClientCapabilities;
import org.apache.hadoop.hive.metastore.api.ClientCapability;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleResponse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CommitTxnKeyValue;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.CompactionMetricsDataRequest;
import org.apache.hadoop.hive.metastore.api.CompactionMetricsDataStruct;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CreateCatalogRequest;
import org.apache.hadoop.hive.metastore.api.CreateDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.CreateDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.DropCatalogRequest;
import org.apache.hadoop.hive.metastore.api.DropConstraintRequest;
import org.apache.hadoop.hive.metastore.api.DropDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.DropDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.DropPackageRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsExpr;
import org.apache.hadoop.hive.metastore.api.DropPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.DropTableRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.ExtendedTableInfo;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsResp;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsRqst;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.ForeignKeysResponse;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetAllWriteEventInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetCatalogRequest;
import org.apache.hadoop.hive.metastore.api.GetCatalogResponse;
import org.apache.hadoop.hive.metastore.api.GetCatalogsResponse;
import org.apache.hadoop.hive.metastore.api.GetDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.GetDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.GetFieldsRequest;
import org.apache.hadoop.hive.metastore.api.GetFieldsResponse;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprResult;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsRequest;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetPackageRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByFilterRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.GetReplicationMetricsRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.GetRuntimeStatsRequest;
import org.apache.hadoop.hive.metastore.api.GetSchemaRequest;
import org.apache.hadoop.hive.metastore.api.GetSchemaResponse;
import org.apache.hadoop.hive.metastore.api.GetSerdeRequest;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetTableResult;
import org.apache.hadoop.hive.metastore.api.GetTablesExtRequest;
import org.apache.hadoop.hive.metastore.api.GetTablesRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeType;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.ISchemaName;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.ListPackageRequest;
import org.apache.hadoop.hive.metastore.api.ListStoredProcedureRequest;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MapSchemaVersionToSerdeRequest;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MaxAllocatedTableWriteIdRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.OptionalCompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.Package;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsSpecByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PropertyGetRequest;
import org.apache.hadoop.hive.metastore.api.PropertyGetResponse;
import org.apache.hadoop.hive.metastore.api.PropertySetRequest;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.RenamePartitionRequest;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.api.ReplicationMetricList;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLAllTableConstraints;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.ScheduledQuery;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollResponse;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryProgressInfo;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionDescriptor;
import org.apache.hadoop.hive.metastore.api.SchemaVersionState;
import org.apache.hadoop.hive.metastore.api.SeedTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.SeedTxnIdRequest;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.SetSchemaVersionStateRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.StoredProcedure;
import org.apache.hadoop.hive.metastore.api.StoredProcedureRequest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableStatsResult;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.TruncateTableRequest;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.api.UpdateTransactionalStatsRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMAlterTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrDropTriggerToPoolMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrUpdateMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreatePoolRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMDropMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMDropPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMDropResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMDropTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMGetActiveResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetAllResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetTriggersForResourePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogBatchRequest;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.hooks.URIResolverHook;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.utils.FilterUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.org.apache.commons.lang3.tuple.Pair;
import org.apache.hive.org.apache.http.HttpException;
import org.apache.hive.org.apache.http.HttpRequest;
import org.apache.hive.org.apache.http.HttpRequestInterceptor;
import org.apache.hive.org.apache.http.impl.client.HttpClientBuilder;
import org.apache.hive.org.apache.http.protocol.HttpContext;
import org.apache.hive.org.apache.thrift.TApplicationException;
import org.apache.hive.org.apache.thrift.TConfiguration;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.hive.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hive.org.apache.thrift.protocol.TProtocol;
import org.apache.hive.org.apache.thrift.transport.THttpClient;
import org.apache.hive.org.apache.thrift.transport.TSocket;
import org.apache.hive.org.apache.thrift.transport.TTransport;
import org.apache.hive.org.apache.thrift.transport.TTransportException;
import org.apache.hive.org.apache.thrift.transport.layered.TFramedTransport;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HiveMetaStoreClient
implements IMetaStoreClient,
AutoCloseable {
    private final String CLASS_NAME = HiveMetaStoreClient.class.getName();
    public static final String MANUALLY_INITIATED_COMPACTION = "manual";
    public static final String TRUNCATE_SKIP_DATA_DELETION = "truncateSkipDataDeletion";
    public static final String SKIP_DROP_PARTITION = "dropPartitionSkip";
    public static final String SNAPSHOT_REF = "snapshot_ref";
    public static final String RENAME_PARTITION_MAKE_COPY = "renamePartitionMakeCopy";
    public static final ClientCapabilities VERSION = new ClientCapabilities(Lists.newArrayList(ClientCapability.INSERT_ONLY_TABLES));
    public static final ClientCapabilities TEST_VERSION = new ClientCapabilities(Lists.newArrayList(ClientCapability.INSERT_ONLY_TABLES, ClientCapability.TEST_CAPABILITY));
    private static final String HIVE_METASTORE_CLASS = "org.apache.hadoop.hive.metastore.HiveMetaStore";
    private static final String HIVE_METASTORE_CREATE_HANDLER_METHOD = "newHMSHandler";
    ThriftHiveMetastore.Iface client = null;
    private TTransport transport = null;
    private boolean isConnected = false;
    private URI[] metastoreUris;
    private final HiveMetaHookLoader hookLoader;
    protected final Configuration conf;
    private String tokenStrForm;
    private final boolean localMetaStore;
    private final MetaStoreFilterHook filterHook;
    private final boolean isClientFilterEnabled;
    private final URIResolverHook uriResolverHook;
    private final int fileMetadataBatchSize;
    private Map<String, String> currentMetaVars;
    private static final AtomicInteger connCount = new AtomicInteger(0);
    private int retries = 5;
    private long retryDelaySeconds = 0L;
    private final ClientCapabilities version;
    private static String[] processorCapabilities;
    private static String processorIdentifier;
    private static final String REPL_EVENTS_MISSING_IN_METASTORE = "Notification events are missing in the meta store.";
    private static final String REPL_EVENTS_WITH_DUPLICATE_ID_IN_METASTORE = "Notification events with duplicate event ids in the meta store.";
    protected static final Logger LOG;

    public HiveMetaStoreClient(Configuration conf) throws MetaException {
        this(conf, null, true);
    }

    public HiveMetaStoreClient(Configuration conf, HiveMetaHookLoader hookLoader) throws MetaException {
        this(conf, hookLoader, true);
    }

    public HiveMetaStoreClient(Configuration conf, HiveMetaHookLoader hookLoader, Boolean allowEmbedded) throws MetaException {
        this.hookLoader = hookLoader;
        this.conf = conf == null ? (conf = MetastoreConf.newMetastoreConf()) : new Configuration(conf);
        this.version = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.HIVE_IN_TEST) ? TEST_VERSION : VERSION;
        this.filterHook = this.loadFilterHooks();
        this.isClientFilterEnabled = this.getIfClientFilterEnabled();
        this.uriResolverHook = this.loadUriResolverHook();
        this.fileMetadataBatchSize = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.BATCH_RETRIEVE_OBJECTS_MAX);
        if (MetastoreConf.get(conf, "hive.metastore.client.capabilities") != null) {
            String[] capabilities = MetastoreConf.get(conf, "hive.metastore.client.capabilities").split(",");
            HiveMetaStoreClient.setProcessorCapabilities(capabilities);
            String hostName = "unknown";
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            HiveMetaStoreClient.setProcessorIdentifier("HMSClient-@" + hostName);
        }
        String msUri = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_URIS);
        this.localMetaStore = MetastoreConf.isEmbeddedMetaStore(msUri);
        if (this.localMetaStore) {
            if (!allowEmbedded.booleanValue()) {
                throw new MetaException("Embedded metastore is not allowed here. Please configure " + MetastoreConf.ConfVars.THRIFT_URIS.toString() + "; it is currently set to [" + msUri + "]");
            }
            this.client = HiveMetaStoreClient.callEmbeddedMetastore(this.conf);
            this.isConnected = true;
            this.snapshotActiveConf();
            return;
        }
        this.retries = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES);
        this.retryDelaySeconds = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.CLIENT_CONNECT_RETRY_DELAY, TimeUnit.SECONDS);
        if (MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_URIS) == null) {
            LOG.error("NOT getting uris from conf");
            throw new MetaException("MetaStoreURIs not found in conf file");
        }
        this.resolveUris();
        String HADOOP_PROXY_USER = "HADOOP_PROXY_USER";
        String proxyUser = System.getenv(HADOOP_PROXY_USER);
        if (proxyUser == null) {
            proxyUser = System.getProperty(HADOOP_PROXY_USER);
        }
        if (proxyUser != null) {
            LOG.info(HADOOP_PROXY_USER + " is set. Using delegation token for HiveMetaStore connection.");
            try {
                UserGroupInformation.getLoginUser().getRealUser().doAs(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        HiveMetaStoreClient.this.open();
                        return null;
                    }
                });
                String delegationTokenPropString = "DelegationTokenForHiveMetaStoreServer";
                String delegationTokenStr = this.getDelegationToken(proxyUser, proxyUser);
                SecurityUtils.setTokenStr(UserGroupInformation.getCurrentUser(), delegationTokenStr, delegationTokenPropString);
                MetastoreConf.setVar(this.conf, MetastoreConf.ConfVars.TOKEN_SIGNATURE, delegationTokenPropString);
                this.close();
            }
            catch (Exception e) {
                LOG.error("Error while setting delegation token for " + proxyUser, e);
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                throw new MetaException(e.getMessage());
            }
        }
        this.open();
    }

    static ThriftHiveMetastore.Iface callEmbeddedMetastore(Configuration conf) throws MetaException {
        try {
            Class<?> clazz = Class.forName(HIVE_METASTORE_CLASS);
            Method method = clazz.getDeclaredMethod(HIVE_METASTORE_CREATE_HANDLER_METHOD, Configuration.class);
            method.setAccessible(true);
            return (ThriftHiveMetastore.Iface)method.invoke(null, conf);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                MetaStoreUtils.throwMetaException((Exception)e.getCause());
            }
            MetaStoreUtils.throwMetaException(e);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            MetaStoreUtils.throwMetaException(e);
        }
        return null;
    }

    private boolean getIfClientFilterEnabled() {
        boolean isEnabled = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_FILTER_ENABLED);
        LOG.info("HMS client filtering is " + (isEnabled ? "enabled." : "disabled."));
        return isEnabled;
    }

    /*
     * WARNING - void declaration
     */
    private void resolveUris() throws MetaException {
        List<String> metastoreUrisString;
        String serviceDiscoveryMode;
        block14: {
            String thriftUris = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_URIS);
            serviceDiscoveryMode = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_SERVICE_DISCOVERY_MODE);
            metastoreUrisString = null;
            try {
                if (serviceDiscoveryMode == null || serviceDiscoveryMode.trim().isEmpty()) {
                    metastoreUrisString = Arrays.asList(thriftUris.split(","));
                    break block14;
                }
                if (serviceDiscoveryMode.equalsIgnoreCase("zookeeper")) {
                    metastoreUrisString = new ArrayList<String>();
                    for (String string : MetastoreConf.getZKConfig(this.conf).getServerUris()) {
                        metastoreUrisString.add("thrift://" + string);
                    }
                    break block14;
                }
                throw new IllegalArgumentException("Invalid metastore dynamic service discovery mode " + serviceDiscoveryMode);
            }
            catch (Exception e) {
                MetaStoreUtils.throwMetaException(e);
            }
        }
        if (metastoreUrisString.isEmpty() && "zookeeper".equalsIgnoreCase(serviceDiscoveryMode)) {
            throw new MetaException("No metastore service discovered in ZooKeeper. Please ensure that at least one metastore server is online");
        }
        LOG.info("Resolved metastore uris: {}", (Object)metastoreUrisString);
        ArrayList<URI> metastoreURIArray = new ArrayList<URI>();
        try {
            void var5_9;
            for (String s3 : metastoreUrisString) {
                URI tmpUri = new URI(s3);
                if (tmpUri.getScheme() == null) {
                    throw new IllegalArgumentException("URI: " + s3 + " does not have a scheme");
                }
                if (this.uriResolverHook != null) {
                    metastoreURIArray.addAll(this.uriResolverHook.resolveURI(tmpUri));
                    continue;
                }
                metastoreURIArray.add(tmpUri);
            }
            this.metastoreUris = new URI[metastoreURIArray.size()];
            boolean bl = false;
            while (var5_9 < metastoreURIArray.size()) {
                this.metastoreUris[var5_9] = (URI)metastoreURIArray.get((int)var5_9);
                ++var5_9;
            }
            if (MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_URI_SELECTION).equalsIgnoreCase("RANDOM")) {
                List<URI> list = Arrays.asList(this.metastoreUris);
                Collections.shuffle(list);
                this.metastoreUris = list.toArray(new URI[list.size()]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            MetaStoreUtils.throwMetaException(exception);
        }
    }

    private MetaStoreFilterHook loadFilterHooks() throws IllegalStateException {
        Class<MetaStoreFilterHook> authProviderClass = MetastoreConf.getClass(this.conf, MetastoreConf.ConfVars.FILTER_HOOK, DefaultMetaStoreFilterHookImpl.class, MetaStoreFilterHook.class);
        String msg = "Unable to create instance of " + authProviderClass.getName() + ": ";
        try {
            Constructor<MetaStoreFilterHook> constructor = authProviderClass.getConstructor(Configuration.class);
            return constructor.newInstance(this.conf);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
    }

    private synchronized URIResolverHook loadUriResolverHook() throws IllegalStateException {
        String uriResolverClassName = MetastoreConf.getAsString(this.conf, MetastoreConf.ConfVars.URI_RESOLVER);
        if (uriResolverClassName.equals("")) {
            return null;
        }
        LOG.info("Loading uri resolver : " + uriResolverClassName);
        try {
            Class<?> uriResolverClass = Class.forName(uriResolverClassName, true, JavaUtils.getClassLoader());
            return (URIResolverHook)ReflectionUtils.newInstance(uriResolverClass, null);
        }
        catch (Exception e) {
            LOG.error("Exception loading uri resolver hook", e);
            return null;
        }
    }

    private void promoteRandomMetaStoreURI() {
        if (this.metastoreUris.length <= 1) {
            return;
        }
        Random rng = new Random();
        int index = rng.nextInt(this.metastoreUris.length - 1) + 1;
        URI tmp = this.metastoreUris[0];
        this.metastoreUris[0] = this.metastoreUris[index];
        this.metastoreUris[index] = tmp;
    }

    @VisibleForTesting
    public TTransport getTTransport() {
        return this.transport;
    }

    @VisibleForTesting
    public static AtomicInteger getConnCount() {
        return connCount;
    }

    @Override
    public boolean isLocalMetaStore() {
        return this.localMetaStore;
    }

    @Override
    public boolean isCompatibleWith(Configuration conf) {
        Map<String, String> currentMetaVarsCopy = this.currentMetaVars;
        if (currentMetaVarsCopy == null) {
            return false;
        }
        boolean compatible = true;
        for (MetastoreConf.ConfVars oneVar : MetastoreConf.metaVars) {
            String oldVar = currentMetaVarsCopy.get(oneVar.getVarname());
            String newVar = MetastoreConf.getAsString(conf, oneVar);
            if (oldVar != null && !(oneVar.isCaseSensitive() ? !oldVar.equals(newVar) : !oldVar.equalsIgnoreCase(newVar))) continue;
            LOG.info("Mestastore configuration {} changed from {} to {}", new Object[]{oneVar, oldVar, newVar});
            compatible = false;
        }
        return compatible;
    }

    @Override
    public void setHiveAddedJars(String addedJars) {
        MetastoreConf.setVar(this.conf, MetastoreConf.ConfVars.ADDED_JARS, addedJars);
    }

    @Override
    public void reconnect() throws MetaException {
        if (this.localMetaStore) {
            throw new MetaException("Retries for direct MetaStore DB connections are not supported by this client");
        }
        this.close();
        if (this.uriResolverHook != null) {
            this.resolveUris();
        }
        if (MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_URI_SELECTION).equalsIgnoreCase("RANDOM")) {
            this.promoteRandomMetaStoreURI();
        }
        this.open();
    }

    @Override
    public void alter_table(String dbname, String tbl_name, Table new_tbl) throws TException {
        this.alter_table_with_environmentContext(dbname, tbl_name, new_tbl, null);
    }

    @Override
    public void alter_table(String defaultDatabaseName, String tblName, Table table, boolean cascade) throws TException {
        EnvironmentContext environmentContext = new EnvironmentContext();
        if (cascade) {
            environmentContext.putToProperties("CASCADE", "true");
        }
        this.alter_table_with_environmentContext(defaultDatabaseName, tblName, table, environmentContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter_table_with_environmentContext(String dbname, String tbl_name, Table new_tbl, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        HiveMetaHook hook = this.getHook(new_tbl);
        if (hook != null) {
            hook.preAlterTable(new_tbl, envContext);
        }
        AlterTableRequest req = new AlterTableRequest(dbname, tbl_name, new_tbl);
        req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        req.setEnvironmentContext(envContext);
        if (processorCapabilities != null) {
            req.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
            req.setProcessorIdentifier(processorIdentifier);
        }
        boolean success = false;
        try {
            this.client.alter_table_req(req);
            if (hook != null) {
                hook.commitAlterTable(new_tbl, envContext);
            }
            success = true;
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackAlterTable(new_tbl, envContext);
            }
        }
    }

    @Override
    public void alter_table(String catName, String dbName, String tblName, Table newTable, EnvironmentContext envContext) throws TException {
        AlterTableRequest req = new AlterTableRequest(dbName, tblName, newTable);
        req.setCatName(catName);
        req.setEnvironmentContext(envContext);
        if (processorCapabilities != null) {
            req.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
            req.setProcessorIdentifier(processorIdentifier);
        }
        this.client.alter_table_req(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter_table(String catName, String dbName, String tbl_name, Table new_tbl, EnvironmentContext envContext, String validWriteIds) throws InvalidOperationException, MetaException, TException {
        HiveMetaHook hook = this.getHook(new_tbl);
        if (hook != null) {
            hook.preAlterTable(new_tbl, envContext);
        }
        boolean success = false;
        try {
            boolean skipAlter;
            boolean bl = skipAlter = envContext != null && envContext.getProperties() != null && Boolean.valueOf(envContext.getProperties().getOrDefault("skip_metastore_alter", "false")) != false;
            if (!skipAlter) {
                AlterTableRequest req = new AlterTableRequest(dbName, tbl_name, new_tbl);
                req.setCatName(catName);
                req.setValidWriteIdList(validWriteIds);
                req.setEnvironmentContext(envContext);
                if (processorCapabilities != null) {
                    req.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
                    req.setProcessorIdentifier(processorIdentifier);
                }
                this.client.alter_table_req(req);
            }
            if (hook != null) {
                hook.commitAlterTable(new_tbl, envContext);
            }
            success = true;
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackAlterTable(new_tbl, envContext);
            }
        }
    }

    @Override
    @Deprecated
    public void renamePartition(String dbname, String tableName, List<String> part_vals, Partition newPart) throws TException {
        this.renamePartition(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, tableName, part_vals, newPart, null);
    }

    @Override
    public void renamePartition(String catName, String dbname, String tableName, List<String> part_vals, Partition newPart, String validWriteIds, long txnId, boolean makeCopy) throws TException {
        RenamePartitionRequest req = new RenamePartitionRequest(dbname, tableName, part_vals, newPart);
        req.setCatName(catName);
        req.setValidWriteIdList(validWriteIds);
        req.setTxnId(txnId);
        req.setClonePart(makeCopy);
        this.client.rename_partition_req(req);
    }

    private <T extends TTransport> T configureThriftMaxMessageSize(T transport) {
        int maxThriftMessageSize = (int)MetastoreConf.getSizeVar(this.conf, MetastoreConf.ConfVars.THRIFT_METASTORE_CLIENT_MAX_MESSAGE_SIZE);
        if (maxThriftMessageSize > 0) {
            if (transport.getConfiguration() == null) {
                LOG.warn("TTransport {} is returning a null Configuration, Thrift max message size is not getting configured", (Object)transport.getClass().getName());
                return transport;
            }
            transport.getConfiguration().setMaxMessageSize(maxThriftMessageSize);
        }
        return transport;
    }

    private Map<String, String> getAdditionalHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String keyValuePairs = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_ADDITIONAL_HEADERS);
        try {
            String[] headerKeyValues;
            for (String header : headerKeyValues = keyValuePairs.split(",")) {
                String[] parts = header.split("=");
                headers.put(parts[0].trim(), parts[1].trim());
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not parse the headers provided in " + (Object)((Object)MetastoreConf.ConfVars.METASTORE_CLIENT_ADDITIONAL_HEADERS), ex);
        }
        return headers;
    }

    private THttpClient createHttpClient(URI store, boolean useSSL) throws MetaException, TTransportException {
        THttpClient tHttpClient;
        String path = MetaStoreUtils.getHttpPath(MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_HTTP_PATH));
        String urlScheme = useSSL || Objects.equals(store.getScheme(), "https") ? "https://" : "http://";
        String httpUrl = urlScheme + store.getHost() + ":" + store.getPort() + path;
        HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder();
        try {
            if (useSSL) {
                String trustStorePath = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH).trim();
                if (trustStorePath.isEmpty()) {
                    throw new IllegalArgumentException((Object)((Object)MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH) + " Not configured for SSL connection");
                }
                String trustStorePassword = MetastoreConf.getPassword(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_PASSWORD);
                String trustStoreType = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_TYPE).trim();
                String trustStoreAlgorithm = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTMANAGERFACTORY_ALGORITHM).trim();
                tHttpClient = SecurityUtils.getThriftHttpsClient(httpUrl, trustStorePath, trustStorePassword, trustStoreAlgorithm, trustStoreType, httpClientBuilder);
            } else {
                tHttpClient = new THttpClient(httpUrl, httpClientBuilder.build());
            }
        }
        catch (Exception e) {
            if (e instanceof TTransportException) {
                throw (TTransportException)e;
            }
            throw new MetaException("Failed to create http transport client to url: " + httpUrl + ". Error:" + e);
        }
        LOG.debug("Created thrift http client for URL: " + httpUrl);
        return this.configureThriftMaxMessageSize(tHttpClient);
    }

    @VisibleForTesting
    protected HttpClientBuilder createHttpClientBuilder() throws MetaException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        String authType = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_AUTH_MODE);
        final Map<String, String> additionalHeaders = this.getAdditionalHeaders();
        if (authType.equalsIgnoreCase("jwt")) {
            final String jwtToken = System.getenv("HMS_JWT");
            if (jwtToken == null || jwtToken.isEmpty()) {
                LOG.debug("No jwt token set in environment variable: HMS_JWT");
                throw new MetaException("For auth mode JWT, valid signed jwt token must be provided in the environment variable HMS_JWT");
            }
            httpClientBuilder.addInterceptorFirst(new HttpRequestInterceptor(){

                @Override
                public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
                    httpRequest.addHeader("Authorization", "Bearer " + jwtToken);
                    for (Map.Entry entry : additionalHeaders.entrySet()) {
                        httpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            });
        } else {
            String user = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_PLAIN_USERNAME);
            if (user == null || user.equals("")) {
                try {
                    user = UserGroupInformation.getCurrentUser().getShortUserName();
                }
                catch (IOException e) {
                    throw new MetaException("Failed to get client username from UGI");
                }
            }
            final String httpUser = user;
            httpClientBuilder.addInterceptorFirst(new HttpRequestInterceptor(){

                @Override
                public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
                    httpRequest.addHeader("x-actor-username", httpUser);
                    for (Map.Entry entry : additionalHeaders.entrySet()) {
                        httpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            });
        }
        return httpClientBuilder;
    }

    private TTransport createBinaryClient(URI store, boolean useSSL) throws TTransportException, MetaException {
        TTransport binaryTransport = null;
        try {
            int clientSocketTimeout = (int)MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT, TimeUnit.MILLISECONDS);
            int connectionTimeout = (int)MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.CLIENT_CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
            if (useSSL) {
                String trustStorePath = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH).trim();
                if (trustStorePath.isEmpty()) {
                    throw new IllegalArgumentException((Object)((Object)MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH) + " Not configured for SSL connection");
                }
                String trustStorePassword = MetastoreConf.getPassword(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_PASSWORD);
                String trustStoreType = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTSTORE_TYPE).trim();
                String trustStoreAlgorithm = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.SSL_TRUSTMANAGERFACTORY_ALGORITHM).trim();
                binaryTransport = SecurityUtils.getSSLSocket(store.getHost(), store.getPort(), clientSocketTimeout, connectionTimeout, trustStorePath, trustStorePassword, trustStoreType, trustStoreAlgorithm);
            } else {
                binaryTransport = new TSocket(new TConfiguration(), store.getHost(), store.getPort(), clientSocketTimeout, connectionTimeout);
            }
            binaryTransport = this.createAuthBinaryTransport(store, binaryTransport);
        }
        catch (Exception e) {
            if (e instanceof TTransportException) {
                throw (TTransportException)e;
            }
            throw new MetaException("Failed to create binary transport client to url: " + store + ". Error: " + e);
        }
        LOG.debug("Created thrift binary client for URI: " + store);
        return this.configureThriftMaxMessageSize(binaryTransport);
    }

    private void open() throws MetaException {
        this.isConnected = false;
        TTransportException tte = null;
        MetaException recentME = null;
        boolean useSSL = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_SSL);
        boolean useSasl = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_THRIFT_SASL);
        String clientAuthMode = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_AUTH_MODE);
        boolean usePasswordAuth = false;
        boolean useCompactProtocol = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_THRIFT_COMPACT_PROTOCOL);
        String transportMode = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_THRIFT_TRANSPORT_MODE);
        boolean isHttpTransportMode = transportMode.equalsIgnoreCase("http");
        if (clientAuthMode != null) {
            usePasswordAuth = "PLAIN".equalsIgnoreCase(clientAuthMode);
        }
        for (int attempt = 0; !this.isConnected && attempt < this.retries; ++attempt) {
            for (URI store : this.metastoreUris) {
                LOG.info("Trying to connect to metastore with URI ({}) in {} transport mode", (Object)store, (Object)transportMode);
                try {
                    try {
                        this.transport = isHttpTransportMode ? this.createHttpClient(store, useSSL) : this.createBinaryClient(store, useSSL);
                    }
                    catch (TTransportException te) {
                        tte = te;
                        throw new MetaException(te.toString());
                    }
                    TProtocol protocol = useCompactProtocol ? new TCompactProtocol(this.transport) : new TBinaryProtocol(this.transport);
                    this.client = new ThriftHiveMetastore.Client(protocol);
                    try {
                        if (!this.transport.isOpen()) {
                            this.transport.open();
                            int newCount = connCount.incrementAndGet();
                            if (useSSL) {
                                LOG.info("Opened an SSL connection to metastore, current connections: {}", (Object)newCount);
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("METASTORE SSL CONNECTION TRACE - open [{}]", (Object)System.identityHashCode(this), (Object)new Exception());
                                }
                            } else {
                                LOG.info("Opened a connection to metastore, URI ({}) current connections: {}", (Object)store, (Object)newCount);
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("METASTORE CONNECTION TRACE - open [{}]", (Object)System.identityHashCode(this), (Object)new Exception());
                                }
                            }
                        }
                        this.isConnected = true;
                    }
                    catch (TTransportException e) {
                        tte = e;
                        String errMsg = String.format("Failed to connect to the MetaStore Server URI (%s) in %s transport mode", store, transportMode);
                        LOG.warn(errMsg);
                        LOG.debug(errMsg, e);
                    }
                    if (this.isConnected && !useSasl && !usePasswordAuth && !isHttpTransportMode && MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.EXECUTE_SET_UGI)) {
                        try {
                            UserGroupInformation ugi = SecurityUtils.getUGI();
                            this.client.set_ugi(ugi.getUserName(), Arrays.asList(ugi.getGroupNames()));
                        }
                        catch (LoginException e) {
                            LOG.warn("Failed to do login. set_ugi() is not successful, Continuing without it.", e);
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to find ugi of client set_ugi() is not successful, Continuing without it.", e);
                        }
                        catch (TException e) {
                            LOG.warn("set_ugi() not successful, Likely cause: new client talking to old server. Continuing without it.", e);
                        }
                    }
                }
                catch (MetaException e) {
                    recentME = e;
                    String errMsg = "Failed to connect to metastore with URI (" + store + ") transport mode:" + transportMode + " in attempt " + attempt;
                    LOG.error(errMsg, e);
                }
                if (this.isConnected) break;
            }
            if (this.isConnected || this.retryDelaySeconds <= 0L) continue;
            try {
                LOG.info("Waiting " + this.retryDelaySeconds + " seconds before next connection attempt.");
                Thread.sleep(this.retryDelaySeconds * 1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isConnected) {
            String exceptionString = "Unknown exception";
            if (tte != null) {
                exceptionString = StringUtils.stringifyException(tte);
            } else if (recentME != null) {
                exceptionString = StringUtils.stringifyException(recentME);
            }
            throw new MetaException("Could not connect to meta store using any of the URIs provided. Most recent failure: " + exceptionString);
        }
        this.snapshotActiveConf();
    }

    private TTransport createAuthBinaryTransport(URI store, TTransport underlyingTransport) throws MetaException {
        boolean isHttpTransportMode = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_THRIFT_TRANSPORT_MODE).equalsIgnoreCase("http");
        Preconditions.checkArgument(!isHttpTransportMode);
        Preconditions.checkNotNull(underlyingTransport, "Underlying transport should not be null");
        TTransport transport = underlyingTransport;
        boolean useFramedTransport = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_THRIFT_FRAMED_TRANSPORT);
        boolean useSSL = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_SSL);
        boolean useSasl = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_THRIFT_SASL);
        String clientAuthMode = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_AUTH_MODE);
        boolean usePasswordAuth = false;
        if (clientAuthMode != null) {
            usePasswordAuth = "PLAIN".equalsIgnoreCase(clientAuthMode);
        }
        if (usePasswordAuth) {
            LOG.debug("HMSC::open(): Creating plain authentication thrift connection.");
            String userName = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_PLAIN_USERNAME);
            if (null == userName || userName.isEmpty()) {
                throw new MetaException("No user specified for plain transport.");
            }
            try {
                String passwd = null;
                char[] pwdCharArray = this.conf.getPassword(userName);
                if (null != pwdCharArray) {
                    passwd = new String(pwdCharArray);
                }
                if (null == passwd) {
                    throw new MetaException("No password found for user " + userName);
                }
                transport = MetaStorePlainSaslHelper.getPlainTransport(userName, passwd, underlyingTransport);
            }
            catch (IOException | TTransportException sasle) {
                LOG.error("Could not create client transport", sasle);
                throw new MetaException(sasle.toString());
            }
        }
        if (useSasl) {
            try {
                HadoopThriftAuthBridge.Client authBridge = HadoopThriftAuthBridge.getBridge().createClient();
                String tokenSig = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.TOKEN_SIGNATURE);
                this.tokenStrForm = SecurityUtils.getTokenStrForm(tokenSig);
                if (this.tokenStrForm != null) {
                    LOG.debug("HMSC::open(): Found delegation token. Creating DIGEST-based thrift connection.");
                    transport = authBridge.createClientTransport(null, store.getHost(), "DIGEST", this.tokenStrForm, underlyingTransport, MetaStoreUtils.getMetaStoreSaslProperties(this.conf, useSSL));
                }
                LOG.debug("HMSC::open(): Could not find delegation token. Creating KERBEROS-based thrift connection.");
                String principalConfig = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.KERBEROS_PRINCIPAL);
                transport = authBridge.createClientTransport(principalConfig, store.getHost(), "KERBEROS", null, underlyingTransport, MetaStoreUtils.getMetaStoreSaslProperties(this.conf, useSSL));
            }
            catch (IOException ioe) {
                LOG.error("Failed to create client transport", ioe);
                throw new MetaException(ioe.toString());
            }
        } else if (useFramedTransport) {
            try {
                transport = new TFramedTransport(transport);
            }
            catch (TTransportException e) {
                LOG.error("Failed to create client transport", e);
                throw new MetaException(e.toString());
            }
        }
        return transport;
    }

    private void snapshotActiveConf() {
        this.currentMetaVars = new HashMap<String, String>(MetastoreConf.metaVars.length);
        for (MetastoreConf.ConfVars oneVar : MetastoreConf.metaVars) {
            this.currentMetaVars.put(oneVar.getVarname(), MetastoreConf.getAsString(this.conf, oneVar));
        }
    }

    @Override
    public String getTokenStrForm() throws IOException {
        return this.tokenStrForm;
    }

    @Override
    public void close() {
        this.isConnected = false;
        this.currentMetaVars = null;
        try {
            if (null != this.client) {
                this.client.shutdown();
            }
        }
        catch (TException e) {
            LOG.debug("Unable to shutdown metastore client. Will try closing transport directly.", e);
        }
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
            int newCount = connCount.decrementAndGet();
            LOG.info("Closed a connection to metastore, current connections: {}", (Object)newCount);
            if (LOG.isTraceEnabled()) {
                LOG.trace("METASTORE CONNECTION TRACE - close [{}]", (Object)System.identityHashCode(this), (Object)new Exception());
            }
        }
    }

    public static void setProcessorCapabilities(String[] capabilities) {
        processorCapabilities = capabilities != null ? Arrays.copyOf(capabilities, capabilities.length) : null;
    }

    public static void setProcessorIdentifier(String id) {
        processorIdentifier = id;
    }

    public static String[] getProcessorCapabilities() {
        return processorCapabilities != null ? Arrays.copyOf(processorCapabilities, processorCapabilities.length) : null;
    }

    public static String getProcessorIdentifier() {
        return processorIdentifier;
    }

    @Override
    public void setMetaConf(String key, String value) throws TException {
        this.client.setMetaConf(key, value);
    }

    @Override
    public String getMetaConf(String key) throws TException {
        return this.client.getMetaConf(key);
    }

    @Override
    public void createCatalog(Catalog catalog) throws TException {
        this.client.create_catalog(new CreateCatalogRequest(catalog));
    }

    @Override
    public void alterCatalog(String catalogName, Catalog newCatalog) throws TException {
        this.client.alter_catalog(new AlterCatalogRequest(catalogName, newCatalog));
    }

    @Override
    public Catalog getCatalog(String catName) throws TException {
        GetCatalogResponse rsp = this.client.get_catalog(new GetCatalogRequest(catName));
        return rsp == null ? null : FilterUtils.filterCatalogIfEnabled(this.isClientFilterEnabled, this.filterHook, rsp.getCatalog());
    }

    @Override
    public List<String> getCatalogs() throws TException {
        GetCatalogsResponse rsp = this.client.get_catalogs();
        return rsp == null ? null : FilterUtils.filterCatalogNamesIfEnabled(this.isClientFilterEnabled, this.filterHook, rsp.getNames());
    }

    @Override
    public void dropCatalog(String catName) throws TException {
        this.client.drop_catalog(new DropCatalogRequest(catName));
    }

    @Override
    public Partition add_partition(Partition new_part) throws TException {
        return this.add_partition(new_part, null);
    }

    public Partition add_partition(Partition new_part, EnvironmentContext envContext) throws TException {
        if (new_part == null || new_part.getDbName() == null) {
            throw new MetaException("Partition/DB name cannot be null.");
        }
        if (!new_part.isSetCatName()) {
            new_part.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        AddPartitionsRequest addPartitionsReq = new AddPartitionsRequest(new_part.getDbName(), new_part.getTableName(), new ArrayList<Partition>(Arrays.asList(new_part)), false);
        addPartitionsReq.setCatName(new_part.getCatName());
        addPartitionsReq.setEnvironmentContext(envContext);
        Partition p = this.client.add_partitions_req(addPartitionsReq).getPartitions().get(0);
        return this.deepCopy(p);
    }

    @Override
    public int add_partitions(List<Partition> new_parts) throws TException {
        if (new_parts == null || new_parts.contains(null)) {
            throw new MetaException("Partitions cannot be null.");
        }
        if (new_parts.isEmpty()) {
            return 0;
        }
        if (!new_parts.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            new_parts.forEach(p -> p.setCatName(defaultCat));
        }
        AddPartitionsRequest addPartitionsReq = new AddPartitionsRequest(new_parts.get(0).getDbName(), new_parts.get(0).getTableName(), new_parts, false);
        addPartitionsReq.setCatName(new_parts.get(0).getCatName());
        return this.client.add_partitions_req(addPartitionsReq).getPartitions().size();
    }

    @Override
    public List<Partition> add_partitions(List<Partition> parts, boolean ifNotExists, boolean needResults) throws TException {
        if (parts == null || parts.contains(null)) {
            throw new MetaException("Partitions cannot be null.");
        }
        if (parts.isEmpty()) {
            return needResults ? new ArrayList() : null;
        }
        Partition part = parts.get(0);
        String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
        AddPartitionsRequest req = new AddPartitionsRequest();
        req.setDbName(part.getDbName());
        req.setTblName(part.getTableName());
        req.setParts(parts);
        req.setIfNotExists(ifNotExists);
        boolean skipColumnSchemaForPartition = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_FIELD_SCHEMA_FOR_PARTITIONS);
        if (!part.isSetCatName() && part.getSd() != null && part.getSd().getCols() != null && skipColumnSchemaForPartition) {
            for (Partition p2 : parts) {
                p2.setCatName(defaultCat);
                p2.getSd().getCols().clear();
                StatsSetupConst.clearColumnStatsState(p2.getParameters());
            }
        } else if (!part.isSetCatName()) {
            parts.forEach(p -> p.setCatName(defaultCat));
        } else if (part.getSd() != null && part.getSd().getCols() != null && skipColumnSchemaForPartition) {
            parts.forEach(p -> {
                p.getSd().getCols().clear();
                StatsSetupConst.clearColumnStatsState(p.getParameters());
            });
        }
        req.setParts(parts);
        req.setCatName(part.isSetCatName() ? part.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf));
        req.setNeedResult(needResults);
        req.setSkipColumnSchemaForPartition(skipColumnSchemaForPartition);
        AddPartitionsResult result = this.client.add_partitions_req(req);
        if (needResults) {
            List<Partition> new_parts = FilterUtils.filterPartitionsIfEnabled(this.isClientFilterEnabled, this.filterHook, result.getPartitions());
            if (skipColumnSchemaForPartition) {
                new_parts.forEach(partition -> partition.getSd().setCols(result.getPartitionColSchema()));
            }
            return new_parts;
        }
        return null;
    }

    @Override
    public int add_partitions_pspec(PartitionSpecProxy partitionSpec) throws TException {
        if (partitionSpec == null) {
            throw new MetaException("PartitionSpec cannot be null.");
        }
        if (partitionSpec.getCatName() == null) {
            partitionSpec.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.add_partitions_pspec(partitionSpec.toPartitionSpec());
    }

    @Override
    public Partition appendPartition(String db_name, String table_name, List<String> part_vals) throws TException {
        return this.appendPartition(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, table_name, part_vals);
    }

    @Override
    public Partition appendPartition(String dbName, String tableName, String partName) throws TException {
        return this.appendPartition(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partName);
    }

    @Override
    public Partition appendPartition(String catName, String dbName, String tableName, String name) throws TException {
        if (dbName == null || tableName == null || name == null) {
            throw new MetaException("Db name/Table name/Partition name cannot be null.");
        }
        AppendPartitionsRequest appendPartitionRequest = new AppendPartitionsRequest(dbName, tableName);
        appendPartitionRequest.setName(name);
        appendPartitionRequest.setCatalogName(catName);
        Partition p = this.client.append_partition_req(appendPartitionRequest);
        return this.deepCopy(p);
    }

    @Override
    public Partition appendPartition(String catName, String dbName, String tableName, List<String> partVals) throws TException {
        if (dbName == null || tableName == null) {
            throw new MetaException("Database name/Table name cannot be null");
        }
        AppendPartitionsRequest appendPartitionsReq = new AppendPartitionsRequest(dbName, tableName);
        appendPartitionsReq.setPartVals(partVals);
        appendPartitionsReq.setCatalogName(catName);
        Partition p = this.client.append_partition_req(appendPartitionsReq);
        return this.deepCopy(p);
    }

    @Deprecated
    public Partition appendPartition(String dbName, String tableName, List<String> partVals, EnvironmentContext ec) throws TException {
        if (dbName == null || tableName == null) {
            throw new MetaException("Database name/Table name cannot be null");
        }
        AppendPartitionsRequest appendPartitionsReq = new AppendPartitionsRequest(dbName, tableName);
        appendPartitionsReq.setPartVals(partVals);
        appendPartitionsReq.setCatalogName(MetaStoreUtils.getDefaultCatalog(this.conf));
        appendPartitionsReq.setEnvironmentContext(ec);
        return this.client.append_partition_req(appendPartitionsReq).deepCopy();
    }

    @Override
    public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws TException {
        return this.exchange_partition(partitionSpecs, MetaStoreUtils.getDefaultCatalog(this.conf), sourceDb, sourceTable, MetaStoreUtils.getDefaultCatalog(this.conf), destDb, destinationTableName);
    }

    @Override
    public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceCat, String sourceDb, String sourceTable, String destCat, String destDb, String destTableName) throws TException {
        return this.client.exchange_partition(partitionSpecs, MetaStoreUtils.prependCatalogToDbName(sourceCat, sourceDb, this.conf), sourceTable, MetaStoreUtils.prependCatalogToDbName(destCat, destDb, this.conf), destTableName);
    }

    @Override
    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws TException {
        return this.exchange_partitions(partitionSpecs, MetaStoreUtils.getDefaultCatalog(this.conf), sourceDb, sourceTable, MetaStoreUtils.getDefaultCatalog(this.conf), destDb, destinationTableName);
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, String validWriteIdList) throws NoSuchObjectException, MetaException, TException {
        return this.getPartitionColumnStatistics(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partNames, colNames, engine, validWriteIdList);
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, String validWriteIdList) throws NoSuchObjectException, MetaException, TException {
        PartitionsStatsRequest rqst = new PartitionsStatsRequest(dbName, tableName, colNames, partNames == null ? new ArrayList() : partNames);
        rqst.setEngine(engine);
        rqst.setCatName(catName);
        rqst.setValidWriteIdList(validWriteIdList);
        return this.client.get_partitions_statistics_req(rqst).getPartStats();
    }

    @Override
    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partNames, String engine, String writeIdList) throws NoSuchObjectException, MetaException, TException {
        return this.getAggrColStatsFor(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, colNames, partNames, engine, writeIdList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggrStats getAggrColStatsFor(String catName, String dbName, String tblName, List<String> colNames, List<String> partNames, String engine, String writeIdList) throws NoSuchObjectException, MetaException, TException {
        long t1;
        block6: {
            AggrStats aggrStats;
            t1 = System.currentTimeMillis();
            try {
                if (!colNames.isEmpty() && !partNames.isEmpty()) break block6;
                LOG.debug("Columns is empty or partNames is empty : Short-circuiting stats eval on client side.");
                aggrStats = new AggrStats(new ArrayList<ColumnStatisticsObj>(), 0L);
            }
            catch (Throwable throwable) {
                long diff = System.currentTimeMillis() - t1;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getAggrColStatsFor", diff, "HMS client");
                }
                throw throwable;
            }
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getAggrColStatsFor", diff, "HMS client");
            }
            return aggrStats;
        }
        PartitionsStatsRequest req = new PartitionsStatsRequest(dbName, tblName, colNames, partNames);
        req.setEngine(engine);
        req.setCatName(catName);
        req.setValidWriteIdList(writeIdList);
        AggrStats aggrStats = this.getAggrStatsForInternal(req);
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getAggrColStatsFor", diff, "HMS client");
        }
        return aggrStats;
    }

    protected AggrStats getAggrStatsForInternal(PartitionsStatsRequest req) throws TException {
        return this.client.get_aggr_stats_for(req);
    }

    @Override
    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceCat, String sourceDb, String sourceTable, String destCat, String destDb, String destTableName) throws TException {
        return this.client.exchange_partitions(partitionSpecs, MetaStoreUtils.prependCatalogToDbName(sourceCat, sourceDb, this.conf), sourceTable, MetaStoreUtils.prependCatalogToDbName(destCat, destDb, this.conf), destTableName);
    }

    @Override
    public void validatePartitionNameCharacters(List<String> partVals) throws TException, MetaException {
        this.client.partition_name_has_valid_characters(partVals, true);
    }

    @Override
    public void createDatabase(Database db) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        if (!db.isSetCatalogName()) {
            db.setCatalogName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        if (db.getName() == null) {
            throw new MetaException("DbName cannot be null");
        }
        CreateDatabaseRequest req = new CreateDatabaseRequest(db.getName());
        if (db.isSetDescription()) {
            req.setDescription(db.getDescription());
        }
        if (db.isSetLocationUri()) {
            req.setLocationUri(db.getLocationUri());
        }
        if (db.isSetParameters()) {
            req.setParameters(db.getParameters());
        }
        if (db.isSetPrivileges()) {
            req.setPrivileges(db.getPrivileges());
        }
        if (db.isSetOwnerName()) {
            req.setOwnerName(db.getOwnerName());
        }
        if (db.isSetOwnerType()) {
            req.setOwnerType(db.getOwnerType());
        }
        req.setCatalogName(db.getCatalogName());
        if (db.isSetCreateTime()) {
            req.setCreateTime(db.getCreateTime());
        }
        if (db.isSetManagedLocationUri()) {
            req.setManagedLocationUri(db.getManagedLocationUri());
        }
        if (db.isSetType()) {
            req.setType(db.getType());
        }
        if (db.isSetConnector_name()) {
            req.setDataConnectorName(db.getConnector_name());
        }
        if (db.isSetRemote_dbname()) {
            req.setRemote_dbname(db.getRemote_dbname());
        }
        this.client.create_database_req(req);
        db.setLocationUri(req.getLocationUri());
        db.setManagedLocationUri(req.getManagedLocationUri());
    }

    @Override
    public void createDataConnector(DataConnector connector) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        CreateDataConnectorRequest connectorReq = new CreateDataConnectorRequest(connector);
        this.client.create_dataconnector_req(connectorReq);
    }

    @Override
    public void dropDataConnector(String name, boolean ifNotExists, boolean checkReferences) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        DropDataConnectorRequest dropDcReq = new DropDataConnectorRequest(name);
        dropDcReq.setIfNotExists(ifNotExists);
        dropDcReq.setCheckReferences(checkReferences);
        this.client.drop_dataconnector_req(dropDcReq);
    }

    @Override
    public void alterDataConnector(String name, DataConnector connector) throws NoSuchObjectException, MetaException, TException {
        AlterDataConnectorRequest alterReq = new AlterDataConnectorRequest(name, connector);
        this.client.alter_dataconnector_req(alterReq);
    }

    @Override
    public DataConnector getDataConnector(String name) throws MetaException, TException {
        GetDataConnectorRequest request = new GetDataConnectorRequest(name);
        return this.client.get_dataconnector_req(request);
    }

    @Override
    public List<String> getAllDataConnectorNames() throws MetaException, TException {
        List<String> connectorNames = this.client.get_dataconnectors();
        return FilterUtils.filterDataConnectorsIfEnabled(this.isClientFilterEnabled, this.filterHook, connectorNames);
    }

    @Override
    public Table getTranslateTableDryrun(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        CreateTableRequest request = new CreateTableRequest(tbl);
        if (processorCapabilities != null) {
            request.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
            request.setProcessorIdentifier(processorIdentifier);
        }
        return this.client.translate_table_dryrun(request);
    }

    @Override
    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.createTable(tbl, null);
    }

    public void createTable(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        CreateTableRequest request = new CreateTableRequest(tbl);
        if (envContext != null) {
            request.setEnvContext(envContext);
        }
        this.createTable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(CreateTableRequest request) throws InvalidObjectException, MetaException, NoSuchObjectException, TException {
        HiveMetaHook hook;
        Table tbl = request.getTable();
        if (!tbl.isSetCatName()) {
            tbl.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        if (processorCapabilities != null) {
            request.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
            request.setProcessorIdentifier(processorIdentifier);
        }
        if ((hook = this.getHook(tbl)) != null) {
            hook.preCreateTable(request);
        }
        boolean success = false;
        try {
            if (hook == null || !hook.createHMSTableInHook()) {
                this.create_table(request);
            }
            if (hook != null) {
                hook.commitCreateTable(tbl);
            }
            success = true;
        }
        finally {
            if (!success && hook != null) {
                try {
                    hook.rollbackCreateTable(tbl);
                }
                catch (Exception e) {
                    LOG.error("Create rollback failed with", e);
                }
            }
        }
    }

    @Override
    public void createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        CreateTableRequest createTableRequest = new CreateTableRequest(tbl);
        if (!tbl.isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            tbl.setCatName(defaultCat);
            if (primaryKeys != null) {
                primaryKeys.forEach(pk -> pk.setCatName(defaultCat));
            }
            if (foreignKeys != null) {
                foreignKeys.forEach(fk -> fk.setCatName(defaultCat));
            }
            if (uniqueConstraints != null) {
                uniqueConstraints.forEach(uc -> uc.setCatName(defaultCat));
                createTableRequest.setUniqueConstraints(uniqueConstraints);
            }
            if (notNullConstraints != null) {
                notNullConstraints.forEach(nn -> nn.setCatName(defaultCat));
            }
            if (defaultConstraints != null) {
                defaultConstraints.forEach(def -> def.setCatName(defaultCat));
            }
            if (checkConstraints != null) {
                checkConstraints.forEach(cc -> cc.setCatName(defaultCat));
            }
        }
        if (primaryKeys != null) {
            createTableRequest.setPrimaryKeys(primaryKeys);
        }
        if (foreignKeys != null) {
            createTableRequest.setForeignKeys(foreignKeys);
        }
        if (uniqueConstraints != null) {
            createTableRequest.setUniqueConstraints(uniqueConstraints);
        }
        if (notNullConstraints != null) {
            createTableRequest.setNotNullConstraints(notNullConstraints);
        }
        if (defaultConstraints != null) {
            createTableRequest.setDefaultConstraints(defaultConstraints);
        }
        if (checkConstraints != null) {
            createTableRequest.setCheckConstraints(checkConstraints);
        }
        this.createTable(createTableRequest);
    }

    @Override
    public void dropConstraint(String dbName, String tableName, String constraintName) throws TException {
        this.dropConstraint(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, constraintName);
    }

    @Override
    public void dropConstraint(String catName, String dbName, String tableName, String constraintName) throws TException {
        DropConstraintRequest rqst = new DropConstraintRequest(dbName, tableName, constraintName);
        rqst.setCatName(catName);
        this.client.drop_constraint(rqst);
    }

    @Override
    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws TException {
        if (!primaryKeyCols.isEmpty() && !primaryKeyCols.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            primaryKeyCols.forEach(pk -> pk.setCatName(defaultCat));
        }
        this.client.add_primary_key(new AddPrimaryKeyRequest(primaryKeyCols));
    }

    @Override
    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws TException {
        if (!foreignKeyCols.isEmpty() && !foreignKeyCols.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            foreignKeyCols.forEach(fk -> fk.setCatName(defaultCat));
        }
        this.client.add_foreign_key(new AddForeignKeyRequest(foreignKeyCols));
    }

    @Override
    public void addUniqueConstraint(List<SQLUniqueConstraint> uniqueConstraintCols) throws NoSuchObjectException, MetaException, TException {
        if (!uniqueConstraintCols.isEmpty() && !uniqueConstraintCols.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            uniqueConstraintCols.forEach(uc -> uc.setCatName(defaultCat));
        }
        this.client.add_unique_constraint(new AddUniqueConstraintRequest(uniqueConstraintCols));
    }

    @Override
    public void addNotNullConstraint(List<SQLNotNullConstraint> notNullConstraintCols) throws NoSuchObjectException, MetaException, TException {
        if (!notNullConstraintCols.isEmpty() && !notNullConstraintCols.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            notNullConstraintCols.forEach(nn -> nn.setCatName(defaultCat));
        }
        this.client.add_not_null_constraint(new AddNotNullConstraintRequest(notNullConstraintCols));
    }

    @Override
    public void addDefaultConstraint(List<SQLDefaultConstraint> defaultConstraints) throws NoSuchObjectException, MetaException, TException {
        if (!defaultConstraints.isEmpty() && !defaultConstraints.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            defaultConstraints.forEach(def -> def.setCatName(defaultCat));
        }
        this.client.add_default_constraint(new AddDefaultConstraintRequest(defaultConstraints));
    }

    @Override
    public void addCheckConstraint(List<SQLCheckConstraint> checkConstraints) throws NoSuchObjectException, MetaException, TException {
        if (!checkConstraints.isEmpty() && !checkConstraints.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            checkConstraints.forEach(cc -> cc.setCatName(defaultCat));
        }
        this.client.add_check_constraint(new AddCheckConstraintRequest(checkConstraints));
    }

    public boolean createType(Type type) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        return this.client.create_type(type);
    }

    @Override
    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), name, true, false, false);
    }

    @Override
    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws TException {
        this.dropDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), name, deleteData, ignoreUnknownDb, false);
    }

    @Override
    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws TException {
        this.dropDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), name, deleteData, ignoreUnknownDb, cascade);
    }

    @Override
    public void dropDatabase(DropDatabaseRequest req) throws TException {
        try {
            this.getDatabase(req.getCatalogName(), req.getName());
        }
        catch (NoSuchObjectException e) {
            if (!req.isIgnoreUnknownDb()) {
                throw e;
            }
            return;
        }
        if (req.isCascade()) {
            List<String> materializedViews = this.getTables(req.getName(), ".*", TableType.MATERIALIZED_VIEW);
            for (String table : materializedViews) {
                Table materializedView = this.getTable(MetaStoreUtils.getDefaultCatalog(this.conf), req.getName(), table);
                boolean isSoftDelete = req.isSoftDelete() && Boolean.parseBoolean(materializedView.getParameters().get("soft_delete"));
                materializedView.setTxnId(req.getTxnId());
                this.dropTable(materializedView, req.isDeleteData() && !isSoftDelete, true, false);
            }
            List<String> tableNameList = this.getAllTables(req.getName());
            int tableCount = tableNameList.size();
            int maxBatchSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
            LOG.debug("Selecting dropDatabase method for " + req.getName() + " (" + tableCount + " tables), " + MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX.getVarname() + "=" + maxBatchSize);
            if (tableCount > maxBatchSize) {
                LOG.debug("Dropping database in a per table batch manner.");
                this.dropDatabaseCascadePerTable(req, tableNameList, maxBatchSize);
            } else {
                LOG.debug("Dropping database in a per DB manner.");
                this.dropDatabaseCascadePerDb(req, tableNameList);
            }
        } else {
            this.client.drop_database_req(req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDatabaseCascadePerTable(DropDatabaseRequest req, List<String> tableList, int maxBatchSize) throws TException {
        for (Table table : new TableIterable(this, req.getCatalogName(), req.getName(), tableList, maxBatchSize)) {
            boolean success = false;
            HiveMetaHook hook = this.getHook(table);
            try {
                if (hook != null) {
                    hook.preDropTable(table);
                }
                boolean isSoftDelete = req.isSoftDelete() && Boolean.parseBoolean(table.getParameters().get("soft_delete"));
                EnvironmentContext context = null;
                if (req.isSetTxnId()) {
                    context = new EnvironmentContext();
                    context.putToProperties("txnId", String.valueOf(req.getTxnId()));
                    req.setDeleteManagedDir(false);
                }
                DropTableRequest dropTableReq = new DropTableRequest(req.getName(), table.getTableName());
                dropTableReq.setDeleteData(req.isDeleteData() && !isSoftDelete);
                dropTableReq.setCatalogName(req.getCatalogName());
                dropTableReq.setDropPartitions(true);
                dropTableReq.setEnvContext(context);
                this.client.drop_table_req(dropTableReq);
                if (hook != null) {
                    hook.commitDropTable(table, req.isDeleteData());
                }
                success = true;
            }
            finally {
                if (success || hook == null) continue;
                hook.rollbackDropTable(table);
            }
        }
        this.client.drop_database_req(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDatabaseCascadePerDb(DropDatabaseRequest req, List<String> tableList) throws TException {
        HiveMetaHook hook;
        List<Table> tables = this.getTableObjectsByName(req.getCatalogName(), req.getName(), tableList);
        boolean success = false;
        try {
            for (Table table : tables) {
                hook = this.getHook(table);
                if (hook == null) continue;
                hook.preDropTable(table);
            }
            this.client.drop_database_req(req);
            for (Table table : tables) {
                hook = this.getHook(table);
                if (hook == null) continue;
                hook.commitDropTable(table, req.isDeleteData());
            }
            success = true;
        }
        finally {
            if (!success) {
                for (Table table : tables) {
                    hook = this.getHook(table);
                    if (hook == null) continue;
                    hook.rollbackDropTable(table);
                }
            }
        }
    }

    @Override
    public boolean dropPartition(String dbName, String tableName, String partName, boolean deleteData) throws TException {
        return this.dropPartition(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partName, deleteData);
    }

    @Override
    public boolean dropPartition(String catName, String db_name, String tbl_name, String name, boolean deleteData) throws TException {
        if (db_name == null || tbl_name == null) {
            throw new MetaException("Database name/Table name cannot be null");
        }
        DropPartitionRequest dropPartitionReq = new DropPartitionRequest(db_name, tbl_name);
        dropPartitionReq.setCatName(catName);
        dropPartitionReq.setPartName(name);
        dropPartitionReq.setDeleteData(deleteData);
        return this.client.drop_partition_req(dropPartitionReq);
    }

    private static EnvironmentContext getEnvironmentContextWithIfPurgeSet() {
        HashMap<String, String> warehouseOptions = new HashMap<String, String>();
        warehouseOptions.put("ifPurge", "TRUE");
        return new EnvironmentContext(warehouseOptions);
    }

    @Deprecated
    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, EnvironmentContext env_context) throws TException {
        if (db_name == null || tbl_name == null) {
            throw new MetaException("Database name/Table name cannot be null");
        }
        DropPartitionRequest dropPartitionReq = new DropPartitionRequest(db_name, tbl_name);
        dropPartitionReq.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        dropPartitionReq.setPartVals(part_vals);
        dropPartitionReq.setDeleteData(true);
        dropPartitionReq.setEnvironmentContext(env_context);
        return this.client.drop_partition_req(dropPartitionReq);
    }

    @Deprecated
    public boolean dropPartition(String dbName, String tableName, String partName, boolean dropData, EnvironmentContext ec) throws TException {
        if (dbName == null || tableName == null) {
            throw new MetaException("Database name/Table name cannot be null");
        }
        DropPartitionRequest dropPartitionReq = new DropPartitionRequest(dbName, tableName);
        dropPartitionReq.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        dropPartitionReq.setPartName(partName);
        dropPartitionReq.setDeleteData(dropData);
        dropPartitionReq.setEnvironmentContext(ec);
        return this.client.drop_partition_req(dropPartitionReq);
    }

    @Deprecated
    public boolean dropPartition(String dbName, String tableName, List<String> partVals) throws TException {
        EnvironmentContext context = null;
        return this.dropPartition(dbName, tableName, partVals, context);
    }

    @Override
    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws TException {
        return this.dropPartition(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, PartitionDropOptions.instance().deleteData(deleteData));
    }

    @Override
    public boolean dropPartition(String catName, String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws TException {
        return this.dropPartition(catName, db_name, tbl_name, part_vals, PartitionDropOptions.instance().deleteData(deleteData));
    }

    @Override
    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, PartitionDropOptions options) throws TException {
        return this.dropPartition(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, options);
    }

    @Override
    public boolean dropPartition(String catName, String db_name, String tbl_name, List<String> part_vals, PartitionDropOptions options) throws TException {
        if (options == null) {
            options = PartitionDropOptions.instance();
        }
        if (db_name == null || tbl_name == null) {
            throw new MetaException("Database name/Table name cannot be null");
        }
        if (part_vals != null) {
            for (String partVal : part_vals) {
                if (partVal != null) continue;
                throw new MetaException("The partition value must not be null.");
            }
        }
        DropPartitionRequest dropPartitionReq = new DropPartitionRequest(db_name, tbl_name);
        dropPartitionReq.setCatName(catName);
        dropPartitionReq.setPartVals(part_vals);
        dropPartitionReq.setDeleteData(options.deleteData);
        dropPartitionReq.setEnvironmentContext(options.purgeData ? HiveMetaStoreClient.getEnvironmentContextWithIfPurgeSet() : null);
        return this.client.drop_partition_req(dropPartitionReq);
    }

    @Override
    public List<Partition> dropPartitions(String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        return this.dropPartitions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, partExprs, options);
    }

    @Override
    public List<Partition> dropPartitions(String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResult) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists).returnResults(needResult));
    }

    @Override
    public List<Partition> dropPartitions(String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists));
    }

    @Override
    public List<Partition> dropPartitions(String catName, String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        RequestPartsSpec rps = new RequestPartsSpec();
        ArrayList<DropPartitionsExpr> exprs = new ArrayList<DropPartitionsExpr>(partExprs.size());
        Table table = this.getTable(catName, dbName, tblName);
        HiveMetaHook hook = this.getHook(table);
        EnvironmentContext context = new EnvironmentContext();
        if (hook != null) {
            hook.preDropPartitions(table, context, partExprs);
        }
        if (context.getProperties() != null && Boolean.parseBoolean(context.getProperties().get(SKIP_DROP_PARTITION))) {
            return Lists.newArrayList();
        }
        for (Pair<Integer, byte[]> partExpr : partExprs) {
            DropPartitionsExpr dpe = new DropPartitionsExpr();
            dpe.setExpr(partExpr.getRight());
            dpe.setPartArchiveLevel(partExpr.getLeft());
            exprs.add(dpe);
        }
        rps.setExprs(exprs);
        DropPartitionsRequest req = new DropPartitionsRequest(dbName, tblName, rps);
        req.setCatName(catName);
        req.setDeleteData(options.deleteData);
        req.setNeedResult(options.returnResults);
        req.setIfExists(options.ifExists);
        if (options.purgeData) {
            LOG.info("Dropped partitions will be purged!");
            context.putToProperties("ifPurge", "true");
        }
        if (options.writeId != null) {
            context = Optional.ofNullable(context).orElse(new EnvironmentContext());
            context.putToProperties("writeId", options.writeId.toString());
        }
        if (options.txnId != null) {
            context = Optional.ofNullable(context).orElse(new EnvironmentContext());
            context.putToProperties("txnId", options.txnId.toString());
        }
        req.setEnvironmentContext(context);
        boolean skipColumnSchemaForPartition = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_FIELD_SCHEMA_FOR_PARTITIONS);
        req.setSkipColumnSchemaForPartition(skipColumnSchemaForPartition);
        return this.client.drop_partitions_req(req).getPartitions();
    }

    @Override
    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUnknownTab) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        this.dropTable(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, name, deleteData, ignoreUnknownTab, null);
    }

    @Override
    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws TException {
        this.dropTable(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, name, deleteData, ignoreUnknownTab, ifPurge);
    }

    @Override
    public void dropTable(Table tbl, boolean deleteData, boolean ignoreUnknownTbl, boolean ifPurge) throws TException {
        EnvironmentContext context = null;
        if (ifPurge) {
            context = HiveMetaStoreClient.getEnvironmentContextWithIfPurgeSet();
        }
        if (tbl.isSetTxnId()) {
            context = Optional.ofNullable(context).orElse(new EnvironmentContext());
            context.putToProperties("txnId", String.valueOf(tbl.getTxnId()));
        }
        String catName = Optional.ofNullable(tbl.getCatName()).orElse(MetaStoreUtils.getDefaultCatalog(this.conf));
        this.dropTable(catName, tbl.getDbName(), tbl.getTableName(), deleteData, ignoreUnknownTbl, context);
    }

    @Override
    public void dropTable(String dbname, String name) throws TException {
        this.dropTable(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, name, true, true, null);
    }

    @Override
    public void dropTable(String catName, String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTable, boolean ifPurge) throws TException {
        EnvironmentContext envContext = null;
        if (ifPurge) {
            HashMap<String, String> warehouseOptions = new HashMap<String, String>();
            warehouseOptions.put("ifPurge", "TRUE");
            envContext = new EnvironmentContext(warehouseOptions);
        }
        this.dropTable(catName, dbName, tableName, deleteData, ignoreUnknownTable, envContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String catName, String dbname, String name, boolean deleteData, boolean ignoreUnknownTab, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        Table tbl;
        try {
            tbl = this.getTable(catName, dbname, name);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw e;
            }
            return;
        }
        HiveMetaHook hook = this.getHook(tbl);
        if (hook != null) {
            hook.preDropTable(tbl, deleteData || envContext != null && "TRUE".equals(envContext.getProperties().get("ifPurge")));
        }
        boolean success = false;
        try {
            this.drop_table_with_environment_context(catName, dbname, name, deleteData, envContext);
            if (hook != null) {
                hook.commitDropTable(tbl, deleteData || envContext != null && "TRUE".equals(envContext.getProperties().get("ifPurge")));
            }
            success = true;
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw e;
            }
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackDropTable(tbl);
            }
        }
    }

    @Override
    public void truncateTable(String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId, boolean deleteData) throws TException {
        this.truncateTableInternal(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, null, partNames, validWriteIds, writeId, deleteData);
    }

    @Override
    public void truncateTable(String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId) throws TException {
        this.truncateTable(dbName, tableName, partNames, validWriteIds, writeId, true);
    }

    @Override
    public void truncateTable(String dbName, String tableName, List<String> partNames) throws TException {
        this.truncateTable(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partNames);
    }

    @Override
    public void truncateTable(TableName table, List<String> partNames) throws TException {
        this.truncateTableInternal(table.getCat(), table.getDb(), table.getTable(), table.getTableMetaRef(), partNames, null, -1L, true);
    }

    @Override
    public void truncateTable(String catName, String dbName, String tableName, List<String> partNames) throws TException {
        this.truncateTable(TableName.fromString(tableName, catName, dbName), partNames);
    }

    private void truncateTableInternal(String catName, String dbName, String tableName, String ref, List<String> partNames, String validWriteIds, long writeId, boolean deleteData) throws TException {
        Table table = this.getTable(catName, dbName, tableName);
        HiveMetaHook hook = this.getHook(table);
        EnvironmentContext context = new EnvironmentContext();
        if (ref != null) {
            context.putToProperties(SNAPSHOT_REF, ref);
        }
        context.putToProperties(TRUNCATE_SKIP_DATA_DELETION, Boolean.toString(!deleteData));
        if (hook != null) {
            hook.preTruncateTable(table, context, partNames);
        }
        TruncateTableRequest req = new TruncateTableRequest(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName);
        req.setPartNames(partNames);
        req.setValidWriteIdList(validWriteIds);
        req.setWriteId(writeId);
        req.setEnvironmentContext(context);
        this.client.truncate_table_req(req);
    }

    @Override
    public CmRecycleResponse recycleDirToCmPath(CmRecycleRequest request) throws MetaException, TException {
        return this.client.cm_recycle(request);
    }

    public boolean dropType(String type) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_type(type);
    }

    public Map<String, Type> getTypeAll(String name) throws MetaException, TException {
        LinkedHashMap<String, Type> result = null;
        Map<String, Type> fromClient = this.client.get_type_all(name);
        if (fromClient != null) {
            result = new LinkedHashMap<String, Type>();
            for (Map.Entry<String, Type> entry : fromClient.entrySet()) {
                result.put(entry.getKey(), this.deepCopy(entry.getValue()));
            }
        }
        return result;
    }

    @Override
    public List<String> getDatabases(String databasePattern) throws TException {
        return this.getDatabases(MetaStoreUtils.getDefaultCatalog(this.conf), databasePattern);
    }

    @Override
    public List<String> getDatabases(String catName, String databasePattern) throws TException {
        List<String> databases = this.client.get_databases(MetaStoreUtils.prependCatalogToDbName(catName, databasePattern, this.conf));
        return FilterUtils.filterDbNamesIfEnabled(this.isClientFilterEnabled, this.filterHook, databases);
    }

    @Override
    public List<String> getAllDatabases() throws TException {
        return this.getAllDatabases(MetaStoreUtils.getDefaultCatalog(this.conf));
    }

    @Override
    public List<String> getAllDatabases(String catName) throws TException {
        List<String> databases = this.client.get_databases(MetaStoreUtils.prependCatalogToDbName(catName, null, this.conf));
        return FilterUtils.filterDbNamesIfEnabled(this.isClientFilterEnabled, this.filterHook, databases);
    }

    @Override
    public List<Partition> listPartitions(String db_name, String tbl_name, short max_parts) throws TException {
        return this.listPartitions(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, (int)max_parts);
    }

    @Override
    public List<Partition> listPartitions(String catName, String db_name, String tbl_name, int max_parts) throws TException {
        if (db_name == null || tbl_name == null) {
            throw new MetaException("Database name/Table name should not be null");
        }
        PartitionsRequest req = MetaStoreUtils.createThriftPartitionsReq(PartitionsRequest.class, this.conf, new PartitionsRequest[0]);
        req.setDbName(db_name);
        req.setTblName(tbl_name);
        req.setCatName(catName);
        req.setMaxParts(this.shrinkMaxtoShort(max_parts));
        List<Partition> parts = this.client.get_partitions_req(req).getPartitions();
        return this.deepCopyPartitions(FilterUtils.filterPartitionsIfEnabled(this.isClientFilterEnabled, this.filterHook, parts));
    }

    @Override
    public PartitionSpecProxy listPartitionSpecs(String dbName, String tableName, int maxParts) throws TException {
        return this.listPartitionSpecs(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, maxParts);
    }

    @Override
    public PartitionSpecProxy listPartitionSpecs(String catName, String dbName, String tableName, int maxParts) throws TException {
        List<PartitionSpec> partitionSpecs = this.client.get_partitions_pspec(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, maxParts);
        partitionSpecs = FilterUtils.filterPartitionSpecsIfEnabled(this.isClientFilterEnabled, this.filterHook, partitionSpecs);
        return PartitionSpecProxy.Factory.get(partitionSpecs);
    }

    @Override
    public List<Partition> listPartitions(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws TException {
        return this.listPartitions(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, max_parts);
    }

    @Override
    public List<Partition> listPartitions(String catName, String db_name, String tbl_name, List<String> part_vals, int max_parts) throws TException {
        if (db_name == null || tbl_name == null || part_vals == null) {
            throw new MetaException("Database name/Table name/partition values should not be null");
        }
        GetPartitionsPsWithAuthRequest req = MetaStoreUtils.createThriftPartitionsReq(GetPartitionsPsWithAuthRequest.class, this.conf, new GetPartitionsPsWithAuthRequest[0]);
        req.setDbName(db_name);
        req.setTblName(tbl_name);
        req.setCatName(catName);
        req.setPartVals(part_vals);
        req.setMaxParts(this.shrinkMaxtoShort(max_parts));
        List<Partition> parts = this.client.get_partitions_ps_with_auth_req(req).getPartitions();
        return this.deepCopyPartitions(FilterUtils.filterPartitionsIfEnabled(this.isClientFilterEnabled, this.filterHook, parts));
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String db_name, String tbl_name, short max_parts, String user_name, List<String> group_names) throws TException {
        return this.listPartitionsWithAuthInfo(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, (int)max_parts, user_name, group_names);
    }

    @Override
    public GetPartitionsPsWithAuthResponse listPartitionsWithAuthInfoRequest(GetPartitionsPsWithAuthRequest req) throws MetaException, TException, NoSuchObjectException {
        if (req.getValidWriteIdList() == null) {
            req.setValidWriteIdList(this.getValidWriteIdList(req.getDbName(), req.getTblName()));
        }
        if (req.getCatName() == null) {
            req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        req.setMaxParts(this.shrinkMaxtoShort(req.getMaxParts()));
        GetPartitionsPsWithAuthResponse res = this.listPartitionsWithAuthInfoRequestInternal(req);
        List<Partition> parts = this.deepCopyPartitions(FilterUtils.filterPartitionsIfEnabled(this.isClientFilterEnabled, this.filterHook, res.getPartitions()));
        res.setPartitions(parts);
        return res;
    }

    protected GetPartitionsPsWithAuthResponse listPartitionsWithAuthInfoRequestInternal(GetPartitionsPsWithAuthRequest req) throws TException {
        return this.client.get_partitions_ps_with_auth_req(MetaStoreUtils.createThriftPartitionsReq(GetPartitionsPsWithAuthRequest.class, this.conf, req));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, int maxParts, String userName, List<String> groupNames) throws TException {
        List<Partition> list;
        long t1 = System.currentTimeMillis();
        try {
            List<Partition> parts = this.listPartitionsWithAuthInfoInternal(catName, dbName, tableName, maxParts, userName, groupNames);
            list = this.deepCopyPartitions(FilterUtils.filterPartitionsIfEnabled(this.isClientFilterEnabled, this.filterHook, parts));
        }
        catch (Throwable throwable) {
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "listPartitionsWithAuthInfo", diff, "HMS client");
            }
            throw throwable;
        }
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "listPartitionsWithAuthInfo", diff, "HMS client");
        }
        return list;
    }

    protected List<Partition> listPartitionsWithAuthInfoInternal(String catName, String dbName, String tableName, int maxParts, String userName, List<String> groupNames) throws TException {
        if (dbName == null || tableName == null) {
            throw new MetaException("Database name/Table name should not be null");
        }
        GetPartitionsPsWithAuthRequest req = MetaStoreUtils.createThriftPartitionsReq(GetPartitionsPsWithAuthRequest.class, this.conf, new GetPartitionsPsWithAuthRequest[0]);
        req.setTblName(tableName);
        req.setDbName(dbName);
        req.setCatName(catName);
        req.setMaxParts(this.shrinkMaxtoShort(maxParts));
        req.setUserName(userName);
        req.setGroupNames(groupNames);
        List<Partition> partsList = this.client.get_partitions_ps_with_auth_req(req).getPartitions();
        return partsList;
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String db_name, String tbl_name, List<String> part_vals, short max_parts, String user_name, List<String> group_names) throws TException {
        return this.listPartitionsWithAuthInfo(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, max_parts, user_name, group_names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, List<String> partialPvals, int maxParts, String userName, List<String> groupNames) throws TException {
        List<Partition> list;
        long t1 = System.currentTimeMillis();
        try {
            List<Partition> parts = this.listPartitionsWithAuthInfoInternal(catName, dbName, tableName, partialPvals, maxParts, userName, groupNames);
            list = this.deepCopyPartitions(FilterUtils.filterPartitionsIfEnabled(this.isClientFilterEnabled, this.filterHook, parts));
        }
        catch (Throwable throwable) {
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "listPartitionsWithAuthInfo", diff, "HMS client");
            }
            throw throwable;
        }
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "listPartitionsWithAuthInfo", diff, "HMS client");
        }
        return list;
    }

    protected List<Partition> listPartitionsWithAuthInfoInternal(String catName, String dbName, String tableName, List<String> partialPvals, int maxParts, String userName, List<String> groupNames) throws TException {
        if (dbName == null || tableName == null || partialPvals == null) {
            throw new MetaException("Database name/Table name/partition values should not be null");
        }
        GetPartitionsPsWithAuthRequest req = MetaStoreUtils.createThriftPartitionsReq(GetPartitionsPsWithAuthRequest.class, this.conf, new GetPartitionsPsWithAuthRequest[0]);
        req.setTblName(tableName);
        req.setDbName(dbName);
        req.setCatName(catName);
        req.setPartVals(partialPvals);
        req.setMaxParts(this.shrinkMaxtoShort(maxParts));
        req.setUserName(userName);
        req.setGroupNames(groupNames);
        return this.client.get_partitions_ps_with_auth_req(req).getPartitions();
    }

    @Override
    public List<Partition> listPartitionsByFilter(String db_name, String tbl_name, String filter, short max_parts) throws TException {
        return this.listPartitionsByFilter(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, filter, max_parts);
    }

    @Override
    public List<Partition> listPartitionsByFilter(String catName, String db_name, String tbl_name, String filter, int max_parts) throws TException {
        GetPartitionsByFilterRequest req = MetaStoreUtils.createThriftPartitionsReq(GetPartitionsByFilterRequest.class, this.conf, new GetPartitionsByFilterRequest[0]);
        req.setTblName(tbl_name);
        req.setDbName(db_name);
        req.setCatName(catName);
        req.setFilter(filter);
        req.setMaxParts(this.shrinkMaxtoShort(max_parts));
        List<Partition> parts = this.client.get_partitions_by_filter_req(req);
        return this.deepCopyPartitions(FilterUtils.filterPartitionsIfEnabled(this.isClientFilterEnabled, this.filterHook, parts));
    }

    @Override
    public PartitionSpecProxy listPartitionSpecsByFilter(String db_name, String tbl_name, String filter, int max_parts) throws TException {
        return this.listPartitionSpecsByFilter(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, filter, max_parts);
    }

    @Override
    public PartitionSpecProxy listPartitionSpecsByFilter(String catName, String db_name, String tbl_name, String filter, int max_parts) throws TException {
        List<PartitionSpec> partitionSpecs = this.client.get_part_specs_by_filter(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, filter, max_parts);
        return PartitionSpecProxy.Factory.get(FilterUtils.filterPartitionSpecsIfEnabled(this.isClientFilterEnabled, this.filterHook, partitionSpecs));
    }

    @Override
    public boolean listPartitionsByExpr(String db_name, String tbl_name, byte[] expr, String default_partition_name, short max_parts, List<Partition> result) throws TException {
        return this.listPartitionsByExpr(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, expr, default_partition_name, max_parts, result);
    }

    protected PartitionsByExprRequest buildPartitionsByExprRequest(String catName, String db_name, String tbl_name, byte[] expr, String default_partition_name, int max_parts) {
        PartitionsByExprRequest req = new PartitionsByExprRequest(db_name, tbl_name, ByteBuffer.wrap(expr));
        if (catName == null) {
            req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        } else {
            req.setCatName(catName);
        }
        if (default_partition_name != null) {
            req.setDefaultPartitionName(default_partition_name);
        }
        if (max_parts >= 0) {
            req.setMaxParts(this.shrinkMaxtoShort(max_parts));
        }
        req.setValidWriteIdList(this.getValidWriteIdList(db_name, tbl_name));
        return req;
    }

    protected PartitionsByExprResult getPartitionsByExprInternal(PartitionsByExprRequest req) throws TException {
        return this.client.get_partitions_by_expr(MetaStoreUtils.createThriftPartitionsReq(PartitionsByExprRequest.class, this.conf, req));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean listPartitionsByExpr(String catName, String db_name, String tbl_name, byte[] expr, String default_partition_name, int max_parts, List<Partition> result) throws TException {
        boolean bl;
        long t1 = System.currentTimeMillis();
        try {
            assert (result != null);
            PartitionsByExprRequest req = this.buildPartitionsByExprRequest(catName, db_name, tbl_name, expr, default_partition_name, max_parts);
            PartitionsByExprResult r = null;
            try {
                r = this.getPartitionsByExprInternal(req);
            }
            catch (TApplicationException te) {
                this.rethrowException(te);
            }
            assert (r != null);
            r.setPartitions(FilterUtils.filterPartitionsIfEnabled(this.isClientFilterEnabled, this.filterHook, r.getPartitions()));
            result.addAll(r.getPartitions());
            bl = !r.isSetHasUnknownPartitions() || r.isHasUnknownPartitions();
        }
        catch (Throwable throwable) {
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "listPartitionsByExpr", diff, "HMS client");
            }
            throw throwable;
        }
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "listPartitionsByExpr", diff, "HMS client");
        }
        return bl;
    }

    private void rethrowException(TApplicationException te) throws TException {
        if (te.getType() != 1 && te.getType() != 3) {
            throw te;
        }
        throw new IMetaStoreClient.IncompatibleMetastoreException("Metastore doesn't support listPartitionsByExpr: " + te.getMessage());
    }

    protected PartitionsSpecByExprResult getPartitionsSpecByExprInternal(PartitionsByExprRequest req) throws TException {
        return this.client.get_partitions_spec_by_expr(MetaStoreUtils.createThriftPartitionsReq(PartitionsByExprRequest.class, this.conf, req));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean listPartitionsSpecByExpr(PartitionsByExprRequest req, List<PartitionSpec> result) throws TException {
        boolean bl;
        long t1 = System.currentTimeMillis();
        try {
            assert (result != null);
            PartitionsSpecByExprResult r = null;
            try {
                r = this.getPartitionsSpecByExprInternal(req);
            }
            catch (TApplicationException te) {
                this.rethrowException(te);
            }
            assert (r != null);
            r.setPartitionsSpec(FilterUtils.filterPartitionSpecsIfEnabled(this.isClientFilterEnabled, this.filterHook, r.getPartitionsSpec()));
            result.addAll(r.getPartitionsSpec());
            bl = !r.isSetHasUnknownPartitions() || r.isHasUnknownPartitions();
        }
        catch (Throwable throwable) {
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "listPartitionsSpecByExpr", diff, "HMS client");
            }
            throw throwable;
        }
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "listPartitionsSpecByExpr", diff, "HMS client");
        }
        return bl;
    }

    @Override
    public Database getDatabase(String name) throws TException {
        return this.getDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Database getDatabase(String catalogName, String databaseName) throws TException {
        Database database;
        long t1 = System.currentTimeMillis();
        try {
            GetDatabaseRequest request = new GetDatabaseRequest();
            if (databaseName != null) {
                request.setName(databaseName);
            }
            if (catalogName != null) {
                request.setCatalogName(catalogName);
            }
            if (processorCapabilities != null) {
                request.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
            }
            if (processorIdentifier != null) {
                request.setProcessorIdentifier(processorIdentifier);
            }
            Database d = this.getDatabaseInternal(request);
            database = this.deepCopy(FilterUtils.filterDbIfEnabled(this.isClientFilterEnabled, this.filterHook, d));
        }
        catch (Throwable throwable) {
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getDatabase", diff, "HMS client");
            }
            throw throwable;
        }
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getDatabase", diff, "HMS client");
        }
        return database;
    }

    protected Database getDatabaseInternal(GetDatabaseRequest request) throws TException {
        return this.client.get_database_req(request);
    }

    @Override
    public Partition getPartition(String db_name, String tbl_name, List<String> part_vals) throws TException {
        return this.getPartition(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals);
    }

    @Override
    public GetPartitionResponse getPartitionRequest(GetPartitionRequest req) throws NoSuchObjectException, MetaException, TException {
        if (req.getValidWriteIdList() == null) {
            req.setValidWriteIdList(this.getValidWriteIdList(req.getDbName(), req.getTblName()));
        }
        GetPartitionResponse res = this.client.get_partition_req(req);
        res.setPartition(this.deepCopy(FilterUtils.filterPartitionIfEnabled(this.isClientFilterEnabled, this.filterHook, res.getPartition())));
        return res;
    }

    @Override
    public Partition getPartition(String catName, String dbName, String tblName, List<String> partVals) throws TException {
        if (dbName == null || tblName == null || partVals == null) {
            throw new MetaException("DbName/TableName/PartitionValues cannot be null");
        }
        GetPartitionRequest getPartitionRequest = new GetPartitionRequest(dbName, tblName, partVals);
        getPartitionRequest.setCatName(catName);
        GetPartitionResponse res = this.client.get_partition_req(getPartitionRequest);
        return this.deepCopy(FilterUtils.filterPartitionIfEnabled(this.isClientFilterEnabled, this.filterHook, res.getPartition()));
    }

    @Override
    public List<Partition> getPartitionsByNames(String db_name, String tbl_name, List<String> part_names) throws TException {
        return this.getPartitionsByNames(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_names);
    }

    @Override
    public PartitionsResponse getPartitionsRequest(PartitionsRequest req) throws NoSuchObjectException, MetaException, TException {
        if (req.getValidWriteIdList() == null) {
            req.setValidWriteIdList(this.getValidWriteIdList(req.getDbName(), req.getTblName()));
        }
        PartitionsResponse res = this.client.get_partitions_req(MetaStoreUtils.createThriftPartitionsReq(PartitionsRequest.class, this.conf, req));
        List<Partition> parts = this.deepCopyPartitions(FilterUtils.filterPartitionsIfEnabled(this.isClientFilterEnabled, this.filterHook, res.getPartitions()));
        res.setPartitions(parts);
        return res;
    }

    @Override
    @Deprecated
    public List<Partition> getPartitionsByNames(String catName, String db_name, String tbl_name, List<String> part_names) throws TException {
        GetPartitionsByNamesRequest req = MetaStoreUtils.convertToGetPartitionsByNamesRequest(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, part_names);
        return this.getPartitionsByNames(req).getPartitions();
    }

    @Override
    public GetPartitionsByNamesResult getPartitionsByNames(GetPartitionsByNamesRequest req) throws NoSuchObjectException, MetaException, TException {
        this.checkDbAndTableFilters(MetaStoreUtils.getDefaultCatalog(this.conf), req.getDb_name(), req.getTbl_name());
        if (processorCapabilities != null) {
            req.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
        }
        if (processorIdentifier != null) {
            req.setProcessorIdentifier(processorIdentifier);
        }
        List<Partition> parts = this.getPartitionsByNamesInternal(req).getPartitions();
        GetPartitionsByNamesResult res = new GetPartitionsByNamesResult();
        res.setPartitions(this.deepCopyPartitions(FilterUtils.filterPartitionsIfEnabled(this.isClientFilterEnabled, this.filterHook, parts)));
        return res;
    }

    protected GetPartitionsByNamesResult getPartitionsByNamesInternal(GetPartitionsByNamesRequest gpbnr) throws TException {
        return this.client.get_partitions_by_names_req(MetaStoreUtils.createThriftPartitionsReq(GetPartitionsByNamesRequest.class, this.conf, gpbnr));
    }

    @Override
    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest request) throws MetaException, TException, NoSuchObjectException {
        if (!request.isSetCatName()) {
            request.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        String catName = request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
        String dbName = request.getDbName();
        String tblName = request.getTblName();
        this.checkDbAndTableFilters(catName, dbName, tblName);
        return this.client.get_partition_values(request);
    }

    @Override
    public Partition getPartitionWithAuthInfo(String db_name, String tbl_name, List<String> part_vals, String user_name, List<String> group_names) throws TException {
        return this.getPartitionWithAuthInfo(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, user_name, group_names);
    }

    @Override
    public Partition getPartitionWithAuthInfo(String catName, String dbName, String tableName, List<String> pvals, String userName, List<String> groupNames) throws TException {
        Partition p = this.client.get_partition_with_auth(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, pvals, userName, groupNames);
        return this.deepCopy(FilterUtils.filterPartitionIfEnabled(this.isClientFilterEnabled, this.filterHook, p));
    }

    @Override
    @Deprecated
    public Table getTable(String dbname, String name) throws TException {
        GetTableRequest req = new GetTableRequest(dbname, name);
        req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        return this.getTable(req);
    }

    @Override
    @Deprecated
    public Table getTable(String dbname, String name, boolean getColumnStats, String engine) throws TException {
        GetTableRequest req = new GetTableRequest(dbname, name);
        req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        req.setGetColumnStats(getColumnStats);
        if (getColumnStats) {
            req.setEngine(engine);
        }
        return this.getTable(req);
    }

    @Override
    @Deprecated
    public Table getTable(String catName, String dbName, String tableName) throws TException {
        GetTableRequest req = new GetTableRequest(dbName, tableName);
        req.setCatName(catName);
        return this.getTable(req);
    }

    @Deprecated
    public Table getTable(String catName, String dbName, String tableName, boolean getColumnStats, String engine) throws TException {
        GetTableRequest req = new GetTableRequest(dbName, tableName);
        req.setCatName(catName);
        req.setGetColumnStats(getColumnStats);
        if (getColumnStats) {
            req.setEngine(engine);
        }
        return this.getTable(req);
    }

    protected GetTableResult getTableInternal(GetTableRequest req) throws TException {
        return this.client.get_table_req(req);
    }

    @Override
    @Deprecated
    public Table getTable(String catName, String dbName, String tableName, String validWriteIdList) throws TException {
        GetTableRequest req = new GetTableRequest(dbName, tableName);
        req.setCatName(catName);
        req.setValidWriteIdList(validWriteIdList);
        return this.getTable(req);
    }

    @Override
    @Deprecated
    public Table getTable(String catName, String dbName, String tableName, String validWriteIdList, boolean getColumnStats, String engine) throws TException {
        GetTableRequest req = new GetTableRequest(dbName, tableName);
        req.setCatName(catName);
        req.setValidWriteIdList(validWriteIdList);
        req.setGetColumnStats(getColumnStats);
        if (getColumnStats) {
            req.setEngine(engine);
        }
        return this.getTable(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table getTable(GetTableRequest getTableRequest) throws MetaException, TException, NoSuchObjectException {
        Table table;
        long t1 = System.currentTimeMillis();
        try {
            getTableRequest.setCapabilities(this.version);
            if (processorCapabilities != null) {
                getTableRequest.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
            }
            if (processorIdentifier != null) {
                getTableRequest.setProcessorIdentifier(processorIdentifier);
            }
            Table t = this.getTableInternal(getTableRequest).getTable();
            this.executePostGetTableHook(t);
            table = this.deepCopy(FilterUtils.filterTableIfEnabled(this.isClientFilterEnabled, this.filterHook, t));
        }
        catch (Throwable throwable) {
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getTable", diff, "HMS client");
            }
            throw throwable;
        }
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getTable", diff, "HMS client");
        }
        return table;
    }

    private void executePostGetTableHook(Table t) throws MetaException {
        HiveMetaHook hook = this.getHook(t);
        if (hook != null) {
            hook.postGetTable(t);
        }
    }

    @Override
    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws TException {
        return this.getTables(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableNames, null);
    }

    @Override
    public List<Table> getTableObjectsByName(String catName, String dbName, List<String> tableNames) throws TException {
        return this.getTables(catName, dbName, tableNames, null);
    }

    @Override
    public List<Table> getTables(String catName, String dbName, List<String> tableNames, GetProjectionsSpec projectionsSpec) throws TException {
        GetTablesRequest req = new GetTablesRequest(dbName);
        req.setCatName(catName);
        req.setTblNames(tableNames);
        req.setCapabilities(this.version);
        if (processorCapabilities != null) {
            req.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
        }
        req.setProjectionSpec(projectionsSpec);
        List<Table> tabs = this.client.get_table_objects_by_name_req(req).getTables();
        for (Table tbl : tabs) {
            this.executePostGetTableHook(tbl);
        }
        return this.deepCopyTables(FilterUtils.filterTablesIfEnabled(this.isClientFilterEnabled, this.filterHook, tabs));
    }

    @Override
    public Materialization getMaterializationInvalidationInfo(CreationMetadata cm, String validTxnList) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        return this.client.get_materialization_invalidation_info(cm, validTxnList);
    }

    @Override
    public void updateCreationMetadata(String dbName, String tableName, CreationMetadata cm) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        this.client.update_creation_metadata(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, cm);
    }

    @Override
    public void updateCreationMetadata(String catName, String dbName, String tableName, CreationMetadata cm) throws MetaException, TException {
        this.client.update_creation_metadata(catName, dbName, tableName, cm);
    }

    @Override
    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws TException {
        return this.listTableNamesByFilter(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, filter, maxTables);
    }

    @Override
    public List<String> listTableNamesByFilter(String catName, String dbName, String filter, int maxTables) throws TException {
        List<String> tableNames = this.client.get_table_names_by_filter(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), filter, this.shrinkMaxtoShort(maxTables));
        return FilterUtils.filterTableNamesIfEnabled(this.isClientFilterEnabled, this.filterHook, catName, dbName, tableNames);
    }

    public Type getType(String name) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopy(this.client.get_type(name));
    }

    @Override
    public List<String> getTables(String dbname, String tablePattern) throws MetaException {
        try {
            return this.getTables(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, tablePattern);
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getTables(String catName, String dbName, String tablePattern) throws TException {
        ArrayList<String> tables = new ArrayList<String>();
        GetProjectionsSpec projectionsSpec = new GetProjectionsSpec();
        projectionsSpec.setFieldList(Arrays.asList("dbName", "tableName", "owner", "ownerType"));
        GetTablesRequest req = new GetTablesRequest(dbName);
        req.setCatName(catName);
        req.setCapabilities(this.version);
        req.setTblNames(null);
        if (tablePattern == null) {
            tablePattern = ".*";
        }
        req.setTablesPattern(tablePattern);
        if (processorCapabilities != null) {
            req.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
        }
        if (processorIdentifier != null) {
            req.setProcessorIdentifier(processorIdentifier);
        }
        req.setProjectionSpec(projectionsSpec);
        List<Table> tableObjects = this.client.get_table_objects_by_name_req(req).getTables();
        tableObjects = this.deepCopyTables(FilterUtils.filterTablesIfEnabled(this.isClientFilterEnabled, this.filterHook, tableObjects));
        for (Table tbl : tableObjects) {
            tables.add(tbl.getTableName());
        }
        return tables;
    }

    @Override
    public List<String> getTables(String dbname, String tablePattern, TableType tableType) throws MetaException {
        try {
            return this.getTables(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, tablePattern, tableType);
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getTables(String catName, String dbName, String tablePattern, TableType tableType) throws TException {
        List<String> tables = this.client.get_tables_by_type(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tablePattern, tableType.toString());
        return FilterUtils.filterTableNamesIfEnabled(this.isClientFilterEnabled, this.filterHook, catName, dbName, tables);
    }

    @Override
    public List<ExtendedTableInfo> getTablesExt(String catName, String dbName, String tablePattern, int requestedFields, int limit) throws MetaException, TException {
        if (catName == null) {
            catName = MetaStoreUtils.getDefaultCatalog(this.conf);
        }
        GetTablesExtRequest req = new GetTablesExtRequest(catName, dbName, tablePattern, requestedFields);
        req.setLimit(limit);
        if (processorIdentifier != null) {
            req.setProcessorIdentifier(processorIdentifier);
        }
        if (processorCapabilities != null) {
            req.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
        }
        return this.client.get_tables_ext(req);
    }

    @Override
    public List<Table> getAllMaterializedViewObjectsForRewriting() throws TException {
        try {
            List<Table> views = this.client.get_all_materialized_view_objects_for_rewriting();
            return FilterUtils.filterTablesIfEnabled(this.isClientFilterEnabled, this.filterHook, views);
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getMaterializedViewsForRewriting(String dbName) throws TException {
        return this.getMaterializedViewsForRewriting(MetaStoreUtils.getDefaultCatalog(this.conf), dbName);
    }

    @Override
    public List<String> getMaterializedViewsForRewriting(String catName, String dbname) throws MetaException {
        try {
            List<String> views = this.client.get_materialized_views_for_rewriting(MetaStoreUtils.prependCatalogToDbName(catName, dbname, this.conf));
            return FilterUtils.filterTableNamesIfEnabled(this.isClientFilterEnabled, this.filterHook, catName, dbname, views);
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException(e);
            return null;
        }
    }

    @Override
    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException {
        try {
            return this.getTableMeta(MetaStoreUtils.getDefaultCatalog(this.conf), dbPatterns, tablePatterns, tableTypes);
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException(e);
            return null;
        }
    }

    @Override
    public List<TableMeta> getTableMeta(String catName, String dbPatterns, String tablePatterns, List<String> tableTypes) throws TException {
        List<TableMeta> tableMetas = this.client.get_table_meta(MetaStoreUtils.prependCatalogToDbName(catName, dbPatterns, this.conf), tablePatterns, tableTypes);
        return FilterUtils.filterTableMetasIfEnabled(this.isClientFilterEnabled, this.filterHook, tableMetas);
    }

    @Override
    public List<String> getAllTables(String dbname) throws MetaException {
        try {
            return this.getAllTables(MetaStoreUtils.getDefaultCatalog(this.conf), dbname);
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getAllTables(String catName, String dbName) throws TException {
        List<String> tableNames = this.client.get_all_tables(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf));
        return FilterUtils.filterTableNamesIfEnabled(this.isClientFilterEnabled, this.filterHook, catName, dbName, tableNames);
    }

    @Override
    public boolean tableExists(String databaseName, String tableName) throws TException {
        return this.tableExists(MetaStoreUtils.getDefaultCatalog(this.conf), databaseName, tableName);
    }

    @Override
    public boolean tableExists(String catName, String dbName, String tableName) throws TException {
        try {
            GetTableRequest req = new GetTableRequest(dbName, tableName);
            req.setCatName(catName);
            req.setCapabilities(this.version);
            Table table = this.getTableInternal(req).getTable();
            return FilterUtils.filterTableIfEnabled(this.isClientFilterEnabled, this.filterHook, table) != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    public List<String> listPartitionNames(String dbName, String tblName, short max) throws NoSuchObjectException, MetaException, TException {
        return this.listPartitionNames(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, (int)max);
    }

    @Override
    public GetPartitionNamesPsResponse listPartitionNamesRequest(GetPartitionNamesPsRequest req) throws NoSuchObjectException, MetaException, TException {
        if (req.getValidWriteIdList() == null) {
            req.setValidWriteIdList(this.getValidWriteIdList(req.getDbName(), req.getTblName()));
        }
        if (req.getCatName() == null) {
            req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        GetPartitionNamesPsResponse res = this.listPartitionNamesRequestInternal(req);
        List<String> partNames = FilterUtils.filterPartitionNamesIfEnabled(this.isClientFilterEnabled, this.filterHook, MetaStoreUtils.getDefaultCatalog(this.conf), req.getDbName(), req.getTblName(), res.getNames());
        res.setNames(partNames);
        return res;
    }

    protected GetPartitionNamesPsResponse listPartitionNamesRequestInternal(GetPartitionNamesPsRequest req) throws TException {
        return this.client.get_partition_names_ps_req(req);
    }

    @Override
    public List<String> listPartitionNames(String catName, String dbName, String tableName, int maxParts) throws TException {
        List<String> partNames = this.listPartitionNamesInternal(catName, dbName, tableName, maxParts);
        return FilterUtils.filterPartitionNamesIfEnabled(this.isClientFilterEnabled, this.filterHook, catName, dbName, tableName, partNames);
    }

    protected List<String> listPartitionNamesInternal(String catName, String dbName, String tableName, int maxParts) throws TException {
        if (dbName == null || tableName == null) {
            throw new MetaException("DbName/TableName cannot be null");
        }
        PartitionsRequest partitionReq = new PartitionsRequest(dbName, tableName);
        partitionReq.setCatName(catName);
        partitionReq.setMaxParts(this.shrinkMaxtoShort(maxParts));
        return this.client.fetch_partition_names_req(partitionReq);
    }

    @Override
    public List<String> listPartitionNames(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws TException {
        return this.listPartitionNames(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, max_parts);
    }

    @Override
    public List<String> listPartitionNames(String catName, String db_name, String tbl_name, List<String> part_vals, int max_parts) throws TException {
        List<String> partNames = this.listPartitionNamesInternal(catName, db_name, tbl_name, part_vals, max_parts);
        return FilterUtils.filterPartitionNamesIfEnabled(this.isClientFilterEnabled, this.filterHook, catName, db_name, tbl_name, partNames);
    }

    protected List<String> listPartitionNamesInternal(String catName, String db_name, String tbl_name, List<String> part_vals, int max_parts) throws MetaException, TException, NoSuchObjectException {
        if (db_name == null || tbl_name == null) {
            throw new MetaException("DbName/TableName cannot be null");
        }
        GetPartitionNamesPsRequest getPartitionNamesPsRequest = new GetPartitionNamesPsRequest(db_name, tbl_name);
        getPartitionNamesPsRequest.setCatName(catName);
        getPartitionNamesPsRequest.setPartValues(part_vals);
        getPartitionNamesPsRequest.setMaxParts(this.shrinkMaxtoShort(max_parts));
        GetPartitionNamesPsResponse resp = this.client.get_partition_names_ps_req(getPartitionNamesPsRequest);
        return resp.getNames();
    }

    @Override
    public List<String> listPartitionNames(PartitionsByExprRequest req) throws MetaException, TException, NoSuchObjectException {
        return FilterUtils.filterPartitionNamesIfEnabled(this.isClientFilterEnabled, this.filterHook, req.getCatName(), req.getDbName(), req.getTblName(), this.client.get_partition_names_req(req));
    }

    @Override
    public int getNumPartitionsByFilter(String db_name, String tbl_name, String filter) throws TException {
        return this.getNumPartitionsByFilter(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, filter);
    }

    @Override
    public int getNumPartitionsByFilter(String catName, String dbName, String tableName, String filter) throws TException {
        return this.client.get_num_partitions_by_filter(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, filter);
    }

    @Override
    public void alter_partition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.alter_partition(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, newPart, null);
    }

    @Override
    public void alter_partition(String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.alter_partition(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, newPart, environmentContext);
    }

    @Override
    public void alter_partition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws TException {
        AlterPartitionsRequest req = new AlterPartitionsRequest(dbName, tblName, Lists.newArrayList(newPart));
        req.setCatName(catName);
        req.setEnvironmentContext(environmentContext);
        this.client.alter_partitions_req(req);
    }

    @Override
    public void alter_partition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext, String writeIdList) throws InvalidOperationException, MetaException, TException {
        AlterPartitionsRequest req = new AlterPartitionsRequest(dbName, tblName, Lists.newArrayList(newPart));
        req.setCatName(catName);
        req.setEnvironmentContext(environmentContext);
        req.setValidWriteIdList(writeIdList);
        this.client.alter_partitions_req(req);
    }

    @Override
    @Deprecated
    public void alter_partitions(String dbName, String tblName, List<Partition> newParts) throws TException {
        this.alter_partitions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, newParts, new EnvironmentContext(), null, -1L);
    }

    @Override
    public void alter_partitions(String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext) throws TException {
        this.alter_partitions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, newParts, environmentContext, null, -1L);
    }

    @Override
    public void alter_partitions(String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext, String writeIdList, long writeId) throws InvalidOperationException, MetaException, TException {
        this.alter_partitions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, newParts, environmentContext, writeIdList, writeId);
    }

    @Override
    public void alter_partitions(String catName, String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext, String writeIdList, long writeId) throws TException {
        AlterPartitionsRequest req = new AlterPartitionsRequest();
        req.setCatName(catName);
        req.setDbName(dbName);
        req.setTableName(tblName);
        boolean skipColumnSchemaForPartition = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.METASTORE_CLIENT_FIELD_SCHEMA_FOR_PARTITIONS);
        if (newParts != null && !newParts.isEmpty() && newParts.get(0).getSd() != null && newParts.get(0).getSd().getCols() != null && skipColumnSchemaForPartition) {
            newParts.forEach(p -> p.getSd().getCols().clear());
        }
        req.setPartitions(newParts);
        req.setSkipColumnSchemaForPartition(skipColumnSchemaForPartition);
        req.setEnvironmentContext(environmentContext);
        req.setValidWriteIdList(writeIdList);
        req.setWriteId(writeId);
        this.client.alter_partitions_req(req);
    }

    @Override
    public void alterDatabase(String dbName, Database db) throws TException {
        this.alterDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, db);
    }

    @Override
    public void alterDatabase(String catName, String dbName, Database newDb) throws TException {
        AlterDatabaseRequest alterDbReq = new AlterDatabaseRequest(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), newDb);
        this.client.alter_database_req(alterDbReq);
    }

    @Override
    public List<FieldSchema> getFields(String db, String tableName) throws TException {
        return this.getFields(MetaStoreUtils.getDefaultCatalog(this.conf), db, tableName);
    }

    @Override
    public List<FieldSchema> getFields(String catName, String db, String tableName) throws TException {
        List<FieldSchema> fields = this.client.get_fields(MetaStoreUtils.prependCatalogToDbName(catName, db, this.conf), tableName);
        return this.deepCopyFieldSchemas(fields);
    }

    @Override
    public GetFieldsResponse getFieldsRequest(GetFieldsRequest req) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.client.get_fields_req(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest req) throws TException {
        List<SQLPrimaryKey> list;
        long t1 = System.currentTimeMillis();
        try {
            if (!req.isSetCatName()) {
                req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
            }
            list = this.getPrimaryKeysInternal(req).getPrimaryKeys();
        }
        catch (Throwable throwable) {
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getPrimaryKeys", diff, "HMS client");
            }
            throw throwable;
        }
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getPrimaryKeys", diff, "HMS client");
        }
        return list;
    }

    protected PrimaryKeysResponse getPrimaryKeysInternal(PrimaryKeysRequest req) throws TException {
        return this.client.get_primary_keys(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest req) throws MetaException, NoSuchObjectException, TException {
        List<SQLForeignKey> list;
        long t1 = System.currentTimeMillis();
        try {
            if (!req.isSetCatName()) {
                req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
            }
            list = this.getForeignKeysInternal(req).getForeignKeys();
        }
        catch (Throwable throwable) {
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getForeignKeys", diff, "HMS client");
            }
            throw throwable;
        }
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getForeignKeys", diff, "HMS client");
        }
        return list;
    }

    protected ForeignKeysResponse getForeignKeysInternal(ForeignKeysRequest req) throws TException {
        return this.client.get_foreign_keys(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SQLUniqueConstraint> getUniqueConstraints(UniqueConstraintsRequest req) throws MetaException, NoSuchObjectException, TException {
        List<SQLUniqueConstraint> list;
        long t1 = System.currentTimeMillis();
        try {
            if (!req.isSetCatName()) {
                req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
            }
            list = this.getUniqueConstraintsInternal(req).getUniqueConstraints();
        }
        catch (Throwable throwable) {
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getUniqueConstraints", diff, "HMS client");
            }
            throw throwable;
        }
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getUniqueConstraints", diff, "HMS client");
        }
        return list;
    }

    protected UniqueConstraintsResponse getUniqueConstraintsInternal(UniqueConstraintsRequest req) throws TException {
        return this.client.get_unique_constraints(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SQLNotNullConstraint> getNotNullConstraints(NotNullConstraintsRequest req) throws MetaException, NoSuchObjectException, TException {
        List<SQLNotNullConstraint> list;
        long t1 = System.currentTimeMillis();
        try {
            if (!req.isSetCatName()) {
                req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
            }
            list = this.getNotNullConstraintsInternal(req).getNotNullConstraints();
        }
        catch (Throwable throwable) {
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getNotNullConstraints", diff, "HMS client");
            }
            throw throwable;
        }
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getNotNullConstraints", diff, "HMS client");
        }
        return list;
    }

    protected NotNullConstraintsResponse getNotNullConstraintsInternal(NotNullConstraintsRequest req) throws TException {
        return this.client.get_not_null_constraints(req);
    }

    @Override
    public List<SQLDefaultConstraint> getDefaultConstraints(DefaultConstraintsRequest req) throws MetaException, NoSuchObjectException, TException {
        if (!req.isSetCatName()) {
            req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_default_constraints(req).getDefaultConstraints();
    }

    @Override
    public List<SQLCheckConstraint> getCheckConstraints(CheckConstraintsRequest req) throws MetaException, NoSuchObjectException, TException {
        if (!req.isSetCatName()) {
            req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_check_constraints(req).getCheckConstraints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLAllTableConstraints getAllTableConstraints(AllTableConstraintsRequest req) throws MetaException, TException {
        SQLAllTableConstraints sQLAllTableConstraints;
        block4: {
            long t1 = 0L;
            if (LOG.isDebugEnabled()) {
                t1 = System.currentTimeMillis();
            }
            try {
                sQLAllTableConstraints = this.client.get_all_table_constraints(req).getAllTableConstraints();
                if (!LOG.isDebugEnabled()) break block4;
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getAllTableConstraints", System.currentTimeMillis() - t1, "HMS client");
                }
                throw throwable;
            }
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getAllTableConstraints", System.currentTimeMillis() - t1, "HMS client");
        }
        return sQLAllTableConstraints;
    }

    @Override
    public boolean updateTableColumnStatistics(ColumnStatistics statsObj) throws TException {
        if (!statsObj.getStatsDesc().isSetCatName()) {
            statsObj.getStatsDesc().setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        SetPartitionsStatsRequest req = new SetPartitionsStatsRequest();
        req.addToColStats(statsObj);
        req.setEngine(statsObj.getEngine());
        req.setNeedMerge(false);
        return this.client.update_table_column_statistics_req(req).isResult();
    }

    @Override
    public boolean updatePartitionColumnStatistics(ColumnStatistics statsObj) throws TException {
        if (!statsObj.getStatsDesc().isSetCatName()) {
            statsObj.getStatsDesc().setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        SetPartitionsStatsRequest req = new SetPartitionsStatsRequest();
        req.addToColStats(statsObj);
        req.setEngine(statsObj.getEngine());
        req.setNeedMerge(false);
        return this.client.update_partition_column_statistics_req(req).isResult();
    }

    @Override
    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws TException {
        String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
        for (ColumnStatistics stats : request.getColStats()) {
            if (stats.getStatsDesc().isSetCatName()) continue;
            stats.getStatsDesc().setCatName(defaultCat);
        }
        return this.client.set_aggr_stats_for(request);
    }

    @Override
    public void flushCache() {
        try {
            this.client.flushCache();
        }
        catch (TException e) {
            LOG.warn("Got error flushing the cache", e);
        }
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames, String engine) throws TException {
        return this.getTableColumnStatistics(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, colNames, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames, String engine) throws TException {
        long t1;
        block6: {
            List<ColumnStatisticsObj> list;
            t1 = System.currentTimeMillis();
            try {
                if (!colNames.isEmpty()) break block6;
                list = Collections.emptyList();
            }
            catch (Throwable throwable) {
                long diff = System.currentTimeMillis() - t1;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getTableColumnStatistics", diff, "HMS client");
                }
                throw throwable;
            }
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getTableColumnStatistics", diff, "HMS client");
            }
            return list;
        }
        TableStatsRequest rqst = new TableStatsRequest(dbName, tableName, colNames);
        rqst.setEngine(engine);
        rqst.setCatName(catName);
        rqst.setEngine(engine);
        List<ColumnStatisticsObj> list = this.getTableColumnStatisticsInternal(rqst).getTableStats();
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getTableColumnStatistics", diff, "HMS client");
        }
        return list;
    }

    protected TableStatsResult getTableColumnStatisticsInternal(TableStatsRequest rqst) throws TException {
        return this.client.get_table_statistics_req(rqst);
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames, String engine, String validWriteIdList) throws TException {
        return this.getTableColumnStatistics(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, colNames, engine, validWriteIdList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames, String engine, String validWriteIdList) throws TException {
        long t1;
        block6: {
            List<ColumnStatisticsObj> list;
            t1 = System.currentTimeMillis();
            try {
                if (!colNames.isEmpty()) break block6;
                list = Collections.emptyList();
            }
            catch (Throwable throwable) {
                long diff = System.currentTimeMillis() - t1;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getTableColumnStatistics", diff, "HMS client");
                }
                throw throwable;
            }
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getTableColumnStatistics", diff, "HMS client");
            }
            return list;
        }
        TableStatsRequest rqst = new TableStatsRequest(dbName, tableName, colNames);
        rqst.setEngine(engine);
        rqst.setCatName(catName);
        rqst.setValidWriteIdList(validWriteIdList);
        List<ColumnStatisticsObj> list = this.getTableColumnStatisticsInternal(rqst).getTableStats();
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getTableColumnStatistics", diff, "HMS client");
        }
        return list;
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames, String engine) throws TException {
        return this.getPartitionColumnStatistics(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partNames, colNames, engine);
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine) throws TException {
        PartitionsStatsRequest rqst = new PartitionsStatsRequest(dbName, tableName, colNames, partNames);
        rqst.setEngine(engine);
        rqst.setCatName(catName);
        rqst.setValidWriteIdList(this.getValidWriteIdList(dbName, tableName));
        return this.client.get_partitions_statistics_req(rqst).getPartStats();
    }

    @Override
    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName, String engine) throws TException {
        return this.deletePartitionColumnStatistics(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partName, colName, engine);
    }

    @Override
    public boolean deletePartitionColumnStatistics(String catName, String dbName, String tableName, String partName, String colName, String engine) throws TException {
        return this.client.delete_partition_column_statistics(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, partName, colName, engine);
    }

    @Override
    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName, String engine) throws TException {
        return this.deleteTableColumnStatistics(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, colName, engine);
    }

    @Override
    public boolean deleteTableColumnStatistics(String catName, String dbName, String tableName, String colName, String engine) throws TException {
        return this.client.delete_table_column_statistics(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, colName, engine);
    }

    @Override
    public void updateTransactionalStatistics(UpdateTransactionalStatsRequest req) throws TException {
        this.client.update_transaction_statistics(req);
    }

    @Override
    public List<FieldSchema> getSchema(String db, String tableName) throws TException {
        return this.getSchema(MetaStoreUtils.getDefaultCatalog(this.conf), db, tableName);
    }

    @Override
    public List<FieldSchema> getSchema(String catName, String db, String tableName) throws TException {
        EnvironmentContext envCxt = null;
        String addedJars = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.ADDED_JARS);
        if (org.apache.hive.org.apache.commons.lang3.StringUtils.isNotBlank(addedJars)) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("hive.added.jars.path", addedJars);
            envCxt = new EnvironmentContext(props);
        }
        List<FieldSchema> fields = this.client.get_schema_with_environment_context(MetaStoreUtils.prependCatalogToDbName(catName, db, this.conf), tableName, envCxt);
        return this.deepCopyFieldSchemas(fields);
    }

    @Override
    public GetSchemaResponse getSchemaRequest(GetSchemaRequest req) throws MetaException, TException, UnknownTableException, UnknownDBException {
        EnvironmentContext envCxt = null;
        String addedJars = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.ADDED_JARS);
        if (org.apache.hive.org.apache.commons.lang3.StringUtils.isNotBlank(addedJars)) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("hive.added.jars.path", addedJars);
            envCxt = new EnvironmentContext(props);
            req.setEnvContext(envCxt);
        }
        return this.client.get_schema_req(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        String string;
        long t1 = System.currentTimeMillis();
        try {
            string = this.getConfigValueInternal(name, defaultValue);
        }
        catch (Throwable throwable) {
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getConfigValue", diff, "HMS client");
            }
            throw throwable;
        }
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getConfigValue", diff, "HMS client");
        }
        return string;
    }

    protected String getConfigValueInternal(String name, String defaultValue) throws TException, ConfigValSecurityException {
        return this.client.get_config_value(name, defaultValue);
    }

    @Override
    public Partition getPartition(String db, String tableName, String partName) throws TException {
        return this.getPartition(MetaStoreUtils.getDefaultCatalog(this.conf), db, tableName, partName);
    }

    @Override
    public Partition getPartition(String catName, String dbName, String tblName, String name) throws TException {
        Partition p = this.client.get_partition_by_name(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tblName, name);
        return this.deepCopy(FilterUtils.filterPartitionIfEnabled(this.isClientFilterEnabled, this.filterHook, p));
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.appendPartitionByName(dbName, tableName, partName, null);
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName, EnvironmentContext envContext) throws TException {
        if (dbName == null || tableName == null) {
            throw new MetaException("Database name/Table name cannot be null");
        }
        AppendPartitionsRequest appendPartitionRequest = new AppendPartitionsRequest(dbName, tableName);
        appendPartitionRequest.setName(partName);
        appendPartitionRequest.setCatalogName(MetaStoreUtils.getDefaultCatalog(this.conf));
        appendPartitionRequest.setEnvironmentContext(envContext);
        Partition p = this.client.append_partition_req(appendPartitionRequest);
        return this.deepCopy(p);
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitionByName(dbName, tableName, partName, deleteData, null);
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData, EnvironmentContext envContext) throws TException {
        if (dbName == null || tableName == null) {
            throw new MetaException("Database name/Table name cannot be null");
        }
        DropPartitionRequest dropPartitionReq = new DropPartitionRequest(dbName, tableName);
        dropPartitionReq.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        dropPartitionReq.setPartName(partName);
        dropPartitionReq.setDeleteData(deleteData);
        dropPartitionReq.setEnvironmentContext(envContext);
        return this.client.drop_partition_req(dropPartitionReq);
    }

    private HiveMetaHook getHook(Table tbl) throws MetaException {
        if (this.hookLoader == null) {
            return null;
        }
        return this.hookLoader.getHook(tbl);
    }

    private void checkDbAndTableFilters(String catName, String dbName, String tblName) throws NoSuchObjectException, MetaException {
        FilterUtils.checkDbAndTableFilters(false, this.filterHook, catName, dbName, tblName);
    }

    @Override
    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        return this.client.partition_name_to_vals(name);
    }

    @Override
    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        return this.client.partition_name_to_spec(name);
    }

    protected Partition deepCopy(Partition partition) {
        Partition copy = null;
        if (partition != null) {
            copy = new Partition(partition);
        }
        return copy;
    }

    private Database deepCopy(Database database) {
        Database copy = null;
        if (database != null) {
            copy = new Database(database);
        }
        return copy;
    }

    protected Table deepCopy(Table table) {
        Table copy = null;
        if (table != null) {
            copy = new Table(table);
        }
        return copy;
    }

    private Type deepCopy(Type type) {
        Type copy = null;
        if (type != null) {
            copy = new Type(type);
        }
        return copy;
    }

    private FieldSchema deepCopy(FieldSchema schema) {
        FieldSchema copy = null;
        if (schema != null) {
            copy = new FieldSchema(schema);
        }
        return copy;
    }

    private Function deepCopy(Function func) {
        Function copy = null;
        if (func != null) {
            copy = new Function(func);
        }
        return copy;
    }

    protected PrincipalPrivilegeSet deepCopy(PrincipalPrivilegeSet pps) {
        PrincipalPrivilegeSet copy = null;
        if (pps != null) {
            copy = new PrincipalPrivilegeSet(pps);
        }
        return copy;
    }

    protected List<Partition> deepCopyPartitions(List<Partition> partitions) {
        return this.deepCopyPartitions(partitions, null);
    }

    private List<Partition> deepCopyPartitions(Collection<Partition> src, List<Partition> dest) {
        if (src == null) {
            return dest;
        }
        if (dest == null) {
            dest = new ArrayList<Partition>(src.size());
        }
        for (Partition part : src) {
            dest.add(this.deepCopy(part));
        }
        return dest;
    }

    private List<Table> deepCopyTables(List<Table> tables) {
        ArrayList<Table> copy = null;
        if (tables != null) {
            copy = new ArrayList<Table>();
            for (Table tab : tables) {
                copy.add(this.deepCopy(tab));
            }
        }
        return copy;
    }

    protected List<FieldSchema> deepCopyFieldSchemas(List<FieldSchema> schemas) {
        ArrayList<FieldSchema> copy = null;
        if (schemas != null) {
            copy = new ArrayList<FieldSchema>();
            for (FieldSchema schema : schemas) {
                copy.add(this.deepCopy(schema));
            }
        }
        return copy;
    }

    @Override
    public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        GrantRevokeRoleRequest req = new GrantRevokeRoleRequest();
        req.setRequestType(GrantRevokeType.GRANT);
        req.setRoleName(roleName);
        req.setPrincipalName(userName);
        req.setPrincipalType(principalType);
        req.setGrantor(grantor);
        req.setGrantorType(grantorType);
        req.setGrantOption(grantOption);
        GrantRevokeRoleResponse res = this.client.grant_revoke_role(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public boolean create_role(Role role) throws MetaException, TException {
        return this.client.create_role(role);
    }

    @Override
    public boolean drop_role(String roleName) throws MetaException, TException {
        return this.client.drop_role(roleName);
    }

    @Override
    public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        return this.client.list_roles(principalName, principalType);
    }

    @Override
    public List<String> listRoleNames() throws MetaException, TException {
        return this.client.get_role_names();
    }

    @Override
    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest req) throws MetaException, TException {
        return this.client.get_principals_in_role(req);
    }

    @Override
    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest getRolePrincReq) throws MetaException, TException {
        return this.client.get_role_grants_for_principal(getRolePrincReq);
    }

    @Override
    public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
        for (HiveObjectPrivilege priv : privileges.getPrivileges()) {
            if (priv.getHiveObject().isSetCatName()) continue;
            priv.getHiveObject().setCatName(defaultCat);
        }
        GrantRevokePrivilegeRequest req = new GrantRevokePrivilegeRequest();
        req.setRequestType(GrantRevokeType.GRANT);
        req.setPrivileges(privileges);
        GrantRevokePrivilegeResponse res = this.client.grant_revoke_privileges(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokePrivilegeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
        GrantRevokeRoleRequest req = new GrantRevokeRoleRequest();
        req.setRequestType(GrantRevokeType.REVOKE);
        req.setRoleName(roleName);
        req.setPrincipalName(userName);
        req.setPrincipalType(principalType);
        req.setGrantOption(grantOption);
        GrantRevokeRoleResponse res = this.client.grant_revoke_role(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
        String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
        for (HiveObjectPrivilege priv : privileges.getPrivileges()) {
            if (priv.getHiveObject().isSetCatName()) continue;
            priv.getHiveObject().setCatName(defaultCat);
        }
        GrantRevokePrivilegeRequest req = new GrantRevokePrivilegeRequest();
        req.setRequestType(GrantRevokeType.REVOKE);
        req.setPrivileges(privileges);
        req.setRevokeGrantOption(grantOption);
        GrantRevokePrivilegeResponse res = this.client.grant_revoke_privileges(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokePrivilegeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public boolean refresh_privileges(HiveObjectRef objToRefresh, String authorizer, PrivilegeBag grantPrivileges) throws MetaException, TException {
        String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
        objToRefresh.setCatName(defaultCat);
        if (grantPrivileges.getPrivileges() != null) {
            for (HiveObjectPrivilege priv : grantPrivileges.getPrivileges()) {
                if (priv.getHiveObject().isSetCatName()) continue;
                priv.getHiveObject().setCatName(defaultCat);
            }
        }
        GrantRevokePrivilegeRequest grantReq = new GrantRevokePrivilegeRequest();
        grantReq.setRequestType(GrantRevokeType.GRANT);
        grantReq.setPrivileges(grantPrivileges);
        GrantRevokePrivilegeResponse res = this.client.refresh_privileges(objToRefresh, authorizer, grantReq);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokePrivilegeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
        if (!hiveObject.isSetCatName()) {
            hiveObject.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_privilege_set(hiveObject, userName, groupNames);
    }

    @Override
    public List<HiveObjectPrivilege> list_privileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObject) throws MetaException, TException {
        if (!hiveObject.isSetCatName()) {
            hiveObject.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.list_privileges(principalName, principalType, hiveObject);
    }

    public String getDelegationToken(String renewerKerberosPrincipalName) throws MetaException, TException, IOException {
        String owner = SecurityUtils.getUser();
        return this.getDelegationToken(owner, renewerKerberosPrincipalName);
    }

    @Override
    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        if (this.localMetaStore) {
            return null;
        }
        return this.client.get_delegation_token(owner, renewerKerberosPrincipalName);
    }

    @Override
    public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        if (this.localMetaStore) {
            return 0L;
        }
        return this.client.renew_delegation_token(tokenStrForm);
    }

    @Override
    public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        if (this.localMetaStore) {
            return;
        }
        this.client.cancel_delegation_token(tokenStrForm);
    }

    @Override
    public boolean addToken(String tokenIdentifier, String delegationToken) throws TException {
        return this.client.add_token(tokenIdentifier, delegationToken);
    }

    @Override
    public boolean removeToken(String tokenIdentifier) throws TException {
        return this.client.remove_token(tokenIdentifier);
    }

    @Override
    public String getToken(String tokenIdentifier) throws TException {
        return this.client.get_token(tokenIdentifier);
    }

    @Override
    public List<String> getAllTokenIdentifiers() throws TException {
        return this.client.get_all_token_identifiers();
    }

    @Override
    public int addMasterKey(String key) throws MetaException, TException {
        return this.client.add_master_key(key);
    }

    @Override
    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException, TException {
        this.client.update_master_key(seqNo, key);
    }

    @Override
    public boolean removeMasterKey(Integer keySeq) throws TException {
        return this.client.remove_master_key(keySeq);
    }

    @Override
    public String[] getMasterKeys() throws TException {
        List<String> keyList = this.client.get_master_keys();
        return keyList.toArray(new String[keyList.size()]);
    }

    @Override
    public GetOpenTxnsResponse getOpenTxns() throws TException {
        GetOpenTxnsRequest getOpenTxnsRequest = new GetOpenTxnsRequest();
        getOpenTxnsRequest.setExcludeTxnTypes(Arrays.asList(TxnType.READ_ONLY));
        return this.client.get_open_txns_req(getOpenTxnsRequest);
    }

    @Override
    public ValidTxnList getValidTxns() throws TException {
        GetOpenTxnsRequest getOpenTxnsRequest = new GetOpenTxnsRequest();
        getOpenTxnsRequest.setExcludeTxnTypes(Arrays.asList(TxnType.READ_ONLY));
        return TxnCommonUtils.createValidReadTxnList(this.client.get_open_txns_req(getOpenTxnsRequest), 0L);
    }

    @Override
    public ValidTxnList getValidTxns(long currentTxn) throws TException {
        GetOpenTxnsRequest getOpenTxnsRequest = new GetOpenTxnsRequest();
        getOpenTxnsRequest.setExcludeTxnTypes(Arrays.asList(TxnType.READ_ONLY));
        return TxnCommonUtils.createValidReadTxnList(this.client.get_open_txns_req(getOpenTxnsRequest), currentTxn);
    }

    @Override
    public ValidTxnList getValidTxns(long currentTxn, List<TxnType> excludeTxnTypes) throws TException {
        GetOpenTxnsRequest getOpenTxnsRequest = new GetOpenTxnsRequest();
        getOpenTxnsRequest.setExcludeTxnTypes(excludeTxnTypes);
        return TxnCommonUtils.createValidReadTxnList(this.client.get_open_txns_req(getOpenTxnsRequest), currentTxn);
    }

    @Override
    public ValidWriteIdList getValidWriteIds(String fullTableName) throws TException {
        GetValidWriteIdsRequest rqst = new GetValidWriteIdsRequest(Collections.singletonList(fullTableName));
        GetValidWriteIdsResponse validWriteIds = this.getValidWriteIdsInternal(rqst);
        return TxnCommonUtils.createValidReaderWriteIdList(validWriteIds.getTblValidWriteIds().get(0));
    }

    @Override
    public ValidWriteIdList getValidWriteIds(String fullTableName, Long writeId) throws TException {
        GetValidWriteIdsRequest rqst = new GetValidWriteIdsRequest(Collections.singletonList(fullTableName));
        rqst.setWriteId(writeId);
        GetValidWriteIdsResponse validWriteIds = this.getValidWriteIdsInternal(rqst);
        return TxnCommonUtils.createValidReaderWriteIdList(validWriteIds.getTblValidWriteIds().get(0));
    }

    @Override
    public List<TableValidWriteIds> getValidWriteIds(List<String> tablesList, String validTxnList) throws TException {
        GetValidWriteIdsRequest rqst = new GetValidWriteIdsRequest(tablesList);
        rqst.setValidTxnList(validTxnList);
        return this.getValidWriteIdsInternal(rqst).getTblValidWriteIds();
    }

    protected GetValidWriteIdsResponse getValidWriteIdsInternal(GetValidWriteIdsRequest rqst) throws TException {
        return this.client.get_valid_write_ids(rqst);
    }

    @Override
    public void addWriteIdsToMinHistory(long txnId, Map<String, Long> writeIds) throws TException {
        this.client.add_write_ids_to_min_history(txnId, writeIds);
    }

    @Override
    public long openTxn(String user) throws TException {
        OpenTxnsResponse txns = this.openTxnsIntr(user, 1, null, null, null);
        return txns.getTxn_ids().get(0);
    }

    @Override
    public long openTxn(String user, TxnType txnType) throws TException {
        OpenTxnsResponse txns = this.openTxnsIntr(user, 1, null, null, txnType);
        return txns.getTxn_ids().get(0);
    }

    @Override
    public List<Long> replOpenTxn(String replPolicy, List<Long> srcTxnIds, String user, TxnType txnType) throws TException {
        OpenTxnsResponse txns = this.openTxnsIntr(user, srcTxnIds != null ? srcTxnIds.size() : 1, replPolicy, srcTxnIds, txnType);
        return txns.getTxn_ids();
    }

    @Override
    public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        return this.openTxnsIntr(user, numTxns, null, null, null);
    }

    private OpenTxnsResponse openTxnsIntr(String user, int numTxns, String replPolicy, List<Long> srcTxnIds, TxnType txnType) throws TException {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
        OpenTxnRequest rqst = new OpenTxnRequest(numTxns, user, hostname);
        if (replPolicy != null) {
            rqst.setReplPolicy(replPolicy);
            if (txnType == TxnType.REPL_CREATED) {
                assert (srcTxnIds != null);
                assert (numTxns == srcTxnIds.size());
                rqst.setReplSrcTxnIds(srcTxnIds);
            }
        } else assert (srcTxnIds == null);
        if (txnType != null) {
            rqst.setTxn_type(txnType);
        }
        return this.client.open_txns(rqst);
    }

    @Override
    public void rollbackTxn(long txnid) throws NoSuchTxnException, TException {
        this.client.abort_txn(new AbortTxnRequest(txnid));
    }

    @Override
    public void rollbackTxn(AbortTxnRequest abortTxnRequest) throws NoSuchTxnException, TException {
        this.client.abort_txn(abortTxnRequest);
    }

    @Override
    public void replRollbackTxn(long srcTxnId, String replPolicy, TxnType txnType) throws NoSuchTxnException, TException {
        AbortTxnRequest rqst = new AbortTxnRequest(srcTxnId);
        rqst.setReplPolicy(replPolicy);
        rqst.setTxn_type(txnType);
        this.client.abort_txn(rqst);
    }

    @Override
    public void commitTxn(long txnid) throws NoSuchTxnException, TxnAbortedException, TException {
        this.client.commit_txn(new CommitTxnRequest(txnid));
    }

    @Override
    public void commitTxnWithKeyValue(long txnid, long tableId, String key, String value) throws NoSuchTxnException, TxnAbortedException, TException {
        CommitTxnRequest ctr = new CommitTxnRequest(txnid);
        Preconditions.checkNotNull(key, "The key to commit together with the transaction can't be null");
        Preconditions.checkNotNull(value, "The value to commit together with the transaction can't be null");
        ctr.setKeyValue(new CommitTxnKeyValue(tableId, key, value));
        this.client.commit_txn(ctr);
    }

    @Override
    public void commitTxn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, TException {
        this.client.commit_txn(rqst);
    }

    @Override
    public GetOpenTxnsInfoResponse showTxns() throws TException {
        return this.client.get_open_txns_info();
    }

    @Override
    public void abortTxns(List<Long> txnids) throws NoSuchTxnException, TException {
        this.client.abort_txns(new AbortTxnsRequest(txnids));
    }

    @Override
    public void abortTxns(AbortTxnsRequest abortTxnsRequest) throws NoSuchTxnException, TException {
        this.client.abort_txns(abortTxnsRequest);
    }

    @Override
    public void replTableWriteIdState(String validWriteIdList, String dbName, String tableName, List<String> partNames) throws TException {
        String hostName;
        String user;
        try {
            user = UserGroupInformation.getCurrentUser().getUserName();
        }
        catch (IOException e) {
            LOG.error("Unable to resolve current user name " + e.getMessage());
            throw new RuntimeException(e);
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
        ReplTblWriteIdStateRequest rqst = new ReplTblWriteIdStateRequest(validWriteIdList, user, hostName, dbName, tableName);
        if (partNames != null) {
            rqst.setPartNames(partNames);
        }
        this.client.repl_tbl_writeid_state(rqst);
    }

    @Override
    public long allocateTableWriteId(long txnId, String dbName, String tableName) throws TException {
        return this.allocateTableWriteId(txnId, dbName, tableName, false);
    }

    @Override
    public long allocateTableWriteId(long txnId, String dbName, String tableName, boolean shouldRealloc) throws TException {
        return this.allocateTableWriteIdsBatch(Collections.singletonList(txnId), dbName, tableName, shouldRealloc).get(0).getWriteId();
    }

    @Override
    public List<TxnToWriteId> allocateTableWriteIdsBatch(List<Long> txnIds, String dbName, String tableName) throws TException {
        return this.allocateTableWriteIdsBatch(txnIds, dbName, tableName, false);
    }

    private List<TxnToWriteId> allocateTableWriteIdsBatch(List<Long> txnIds, String dbName, String tableName, boolean shouldRealloc) throws TException {
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest(dbName, tableName);
        rqst.setTxnIds(txnIds);
        rqst.setReallocate(shouldRealloc);
        return this.allocateTableWriteIdsBatchIntr(rqst);
    }

    @Override
    public List<TxnToWriteId> replAllocateTableWriteIdsBatch(String dbName, String tableName, String replPolicy, List<TxnToWriteId> srcTxnToWriteIdList) throws TException {
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest(dbName, tableName);
        rqst.setReplPolicy(replPolicy);
        rqst.setSrcTxnToWriteIdList(srcTxnToWriteIdList);
        return this.allocateTableWriteIdsBatchIntr(rqst);
    }

    private List<TxnToWriteId> allocateTableWriteIdsBatchIntr(AllocateTableWriteIdsRequest rqst) throws TException {
        return this.client.allocate_table_write_ids(rqst).getTxnToWriteIds();
    }

    @Override
    public long getMaxAllocatedWriteId(String dbName, String tableName) throws TException {
        return this.client.get_max_allocated_table_write_id(new MaxAllocatedTableWriteIdRequest(dbName, tableName)).getMaxWriteId();
    }

    @Override
    public void seedWriteId(String dbName, String tableName, long seedWriteId) throws TException {
        this.client.seed_write_id(new SeedTableWriteIdsRequest(dbName, tableName, seedWriteId));
    }

    @Override
    public void seedTxnId(long seedTxnId) throws TException {
        this.client.seed_txn_id(new SeedTxnIdRequest(seedTxnId));
    }

    @Override
    public LockResponse lock(LockRequest request) throws NoSuchTxnException, TxnAbortedException, TException {
        return this.client.lock(request);
    }

    @Override
    public LockResponse checkLock(long lockid) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        return this.client.check_lock(new CheckLockRequest(lockid));
    }

    @Override
    public void unlock(long lockid) throws NoSuchLockException, TxnOpenException, TException {
        this.client.unlock(new UnlockRequest(lockid));
    }

    @Override
    @Deprecated
    public ShowLocksResponse showLocks() throws TException {
        return this.client.show_locks(new ShowLocksRequest());
    }

    @Override
    public ShowLocksResponse showLocks(ShowLocksRequest request) throws TException {
        return this.client.show_locks(request);
    }

    @Override
    public void heartbeat(long txnid, long lockid) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        HeartbeatRequest hb = new HeartbeatRequest();
        hb.setLockid(lockid);
        hb.setTxnid(txnid);
        this.client.heartbeat(hb);
    }

    @Override
    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min2, long max) throws NoSuchTxnException, TxnAbortedException, TException {
        HeartbeatTxnRangeRequest rqst = new HeartbeatTxnRangeRequest(min2, max);
        return this.client.heartbeat_txn_range(rqst);
    }

    @Override
    @Deprecated
    public void compact(String dbname, String tableName, String partitionName, CompactionType type) throws TException {
        CompactionRequest cr = new CompactionRequest();
        if (dbname == null) {
            cr.setDbname("default");
        } else {
            cr.setDbname(dbname);
        }
        cr.setTablename(tableName);
        if (partitionName != null) {
            cr.setPartitionname(partitionName);
        }
        cr.setType(type);
        this.client.compact(cr);
    }

    @Override
    @Deprecated
    public void compact(String dbname, String tableName, String partitionName, CompactionType type, Map<String, String> tblproperties) throws TException {
        this.compact2(dbname, tableName, partitionName, type, tblproperties);
    }

    @Override
    public CompactionResponse compact2(String dbname, String tableName, String partitionName, CompactionType type, Map<String, String> tblproperties) throws TException {
        CompactionRequest cr = new CompactionRequest();
        if (dbname == null) {
            cr.setDbname("default");
        } else {
            cr.setDbname(dbname);
        }
        cr.setTablename(tableName);
        if (partitionName != null) {
            cr.setPartitionname(partitionName);
        }
        cr.setType(type);
        cr.setProperties(tblproperties);
        cr.setInitiatorId(JavaUtils.hostname() + "-" + MANUALLY_INITIATED_COMPACTION);
        cr.setInitiatorVersion(HiveMetaStoreClient.class.getPackage().getImplementationVersion());
        return this.client.compact2(cr);
    }

    @Override
    public CompactionResponse compact2(CompactionRequest request) throws TException {
        return this.client.compact2(request);
    }

    @Override
    public ShowCompactResponse showCompactions() throws TException {
        ShowCompactResponse response = this.client.show_compact(new ShowCompactRequest());
        response.setCompacts(FilterUtils.filterCompactionsIfEnabled(this.isClientFilterEnabled, this.filterHook, MetaStoreUtils.getDefaultCatalog(this.conf), response.getCompacts()));
        return response;
    }

    @Override
    public ShowCompactResponse showCompactions(ShowCompactRequest request) throws TException {
        ShowCompactResponse response = this.client.show_compact(request);
        response.setCompacts(FilterUtils.filterCompactionsIfEnabled(this.isClientFilterEnabled, this.filterHook, MetaStoreUtils.getDefaultCatalog(this.conf), response.getCompacts()));
        return response;
    }

    @Override
    public boolean submitForCleanup(CompactionRequest rqst, long highestWriteId, long txnId) throws TException {
        return this.client.submit_for_cleanup(rqst, highestWriteId, txnId);
    }

    @Override
    public GetLatestCommittedCompactionInfoResponse getLatestCommittedCompactionInfo(GetLatestCommittedCompactionInfoRequest request) throws TException {
        GetLatestCommittedCompactionInfoResponse response = this.client.get_latest_committed_compaction_info(request);
        return FilterUtils.filterCommittedCompactionInfoStructIfEnabled(this.isClientFilterEnabled, this.filterHook, MetaStoreUtils.getDefaultCatalog(this.conf), request.getDbname(), request.getTablename(), response);
    }

    @Override
    @Deprecated
    public void addDynamicPartitions(long txnId, long writeId, String dbName, String tableName, List<String> partNames) throws TException {
        this.client.add_dynamic_partitions(new AddDynamicPartitions(txnId, writeId, dbName, tableName, partNames));
    }

    @Override
    public void addDynamicPartitions(long txnId, long writeId, String dbName, String tableName, List<String> partNames, DataOperationType operationType) throws TException {
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId, writeId, dbName, tableName, partNames);
        adp.setOperationType(operationType);
        this.client.add_dynamic_partitions(adp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTable(Table table, boolean overwrite) throws MetaException {
        boolean failed = true;
        HiveMetaHook hook = this.getHook(table);
        if (hook == null || !(hook instanceof DefaultHiveMetaHook)) {
            return;
        }
        DefaultHiveMetaHook hiveMetaHook = (DefaultHiveMetaHook)hook;
        try {
            hiveMetaHook.commitInsertTable(table, overwrite);
            failed = false;
        }
        finally {
            if (failed) {
                hiveMetaHook.rollbackInsertTable(table, overwrite);
            }
        }
    }

    @Override
    public long getLatestTxnIdInConflict(long txnId) throws TException {
        return this.client.get_latest_txnid_in_conflict(txnId);
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter filter) throws TException {
        NotificationEventRequest rqst = new NotificationEventRequest(lastEventId);
        rqst.setMaxEvents(maxEvents);
        return this.getNextNotificationsInternal(rqst, false, filter);
    }

    @Override
    public NotificationEventResponse getNextNotification(NotificationEventRequest request, boolean allowGapsInEventIds, IMetaStoreClient.NotificationFilter filter) throws TException {
        return this.getNextNotificationsInternal(request, allowGapsInEventIds, filter);
    }

    @Nullable
    private NotificationEventResponse getNextNotificationsInternal(NotificationEventRequest rqst, boolean allowGapsInEventIds, IMetaStoreClient.NotificationFilter filter) throws TException {
        long lastEventId = rqst.getLastEvent();
        NotificationEventResponse rsp = this.client.get_next_notification(rqst);
        LOG.debug("Got back {} events", (Object)(rsp != null ? rsp.getEventsSize() : 0));
        NotificationEventResponse filtered = new NotificationEventResponse();
        if (rsp != null && rsp.getEvents() != null) {
            long nextEventId = lastEventId + 1L;
            long prevEventId = lastEventId;
            for (NotificationEvent e : rsp.getEvents()) {
                LOG.debug("Got event with id : {}", (Object)e.getEventId());
                if (!allowGapsInEventIds && e.getEventId() != nextEventId) {
                    if (e.getEventId() == prevEventId) {
                        LOG.error("NOTIFICATION_LOG table has multiple events with the same event Id {}. Something went wrong when inserting notification events.  Bootstrap the system again to get back teh consistent replicated state.", (Object)prevEventId);
                        throw new IllegalStateException(REPL_EVENTS_WITH_DUPLICATE_ID_IN_METASTORE);
                    }
                    LOG.error("Requested events are found missing in NOTIFICATION_LOG table. Expected: {}, Actual: {}. Probably, cleaner would've cleaned it up. Try setting higher value for hive.metastore.event.db.listener.timetolive. Also, bootstrap the system again to get back the consistent replicated state.", (Object)nextEventId, (Object)e.getEventId());
                    throw new IllegalStateException(REPL_EVENTS_MISSING_IN_METASTORE);
                }
                if (filter != null && filter.accept(e)) {
                    filtered.addToEvents(e);
                }
                prevEventId = nextEventId++;
            }
        }
        return filter != null ? filtered : rsp;
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        return this.client.get_current_notificationEventId();
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public NotificationEventsCountResponse getNotificationEventsCount(NotificationEventsCountRequest rqst) throws TException {
        if (!rqst.isSetCatName()) {
            rqst.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_notification_events_count(rqst);
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    public FireEventResponse fireListenerEvent(FireEventRequest rqst) throws TException {
        if (!rqst.isSetCatName()) {
            rqst.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.fire_listener_event(rqst);
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    public void addWriteNotificationLog(WriteNotificationLogRequest rqst) throws TException {
        this.client.add_write_notification_log(rqst);
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    public void addWriteNotificationLogInBatch(WriteNotificationLogBatchRequest rqst) throws TException {
        this.client.add_write_notification_log_in_batch(rqst);
    }

    public static IMetaStoreClient newSynchronizedClient(IMetaStoreClient client) {
        return (IMetaStoreClient)Proxy.newProxyInstance(HiveMetaStoreClient.class.getClassLoader(), new Class[]{IMetaStoreClient.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    @Override
    public void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws TException {
        this.markPartitionForEvent(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, partKVs, eventType);
    }

    @Override
    public void markPartitionForEvent(String catName, String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws TException {
        this.client.markPartitionForEvent(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, partKVs, eventType);
    }

    @Override
    public boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws TException {
        return this.isPartitionMarkedForEvent(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, partKVs, eventType);
    }

    @Override
    public boolean isPartitionMarkedForEvent(String catName, String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws TException {
        return this.client.isPartitionMarkedForEvent(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, partKVs, eventType);
    }

    @Override
    public void createFunction(Function func) throws TException {
        if (func == null) {
            throw new MetaException("Function cannot be null.");
        }
        if (!func.isSetCatName()) {
            func.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        this.client.create_function(func);
    }

    @Override
    public void alterFunction(String dbName, String funcName, Function newFunction) throws TException {
        this.alterFunction(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, funcName, newFunction);
    }

    @Override
    public void alterFunction(String catName, String dbName, String funcName, Function newFunction) throws TException {
        this.client.alter_function(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), funcName, newFunction);
    }

    @Override
    public void dropFunction(String dbName, String funcName) throws TException {
        this.dropFunction(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, funcName);
    }

    @Override
    public void dropFunction(String catName, String dbName, String funcName) throws TException {
        this.client.drop_function(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), funcName);
    }

    @Override
    public Function getFunction(String dbName, String funcName) throws TException {
        return this.getFunction(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, funcName);
    }

    @Override
    public Function getFunction(String catName, String dbName, String funcName) throws TException {
        return this.deepCopy(this.client.get_function(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), funcName));
    }

    @Override
    public List<String> getFunctions(String dbName, String pattern) throws TException {
        return this.getFunctions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, pattern);
    }

    @Override
    public List<String> getFunctions(String catName, String dbName, String pattern) throws TException {
        return this.client.get_functions(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), pattern);
    }

    @Override
    public GetAllFunctionsResponse getAllFunctions() throws TException {
        return this.client.get_all_functions();
    }

    protected void create_table(CreateTableRequest request) throws InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.client.create_table_req(request);
    }

    protected void drop_table_with_environment_context(String catName, String dbname, String name, boolean deleteData, EnvironmentContext envContext) throws TException {
        DropTableRequest dropTableReq = new DropTableRequest(dbname, name);
        dropTableReq.setDeleteData(deleteData);
        dropTableReq.setCatalogName(catName);
        dropTableReq.setDropPartitions(true);
        dropTableReq.setEnvContext(envContext);
        this.client.drop_table_req(dropTableReq);
    }

    @Override
    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partNames, String engine) throws NoSuchObjectException, MetaException, TException {
        return this.getAggrColStatsFor(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, colNames, partNames, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggrStats getAggrColStatsFor(String catName, String dbName, String tblName, List<String> colNames, List<String> partNames, String engine) throws TException {
        long t1;
        block6: {
            AggrStats aggrStats;
            t1 = System.currentTimeMillis();
            try {
                if (!colNames.isEmpty() && !partNames.isEmpty()) break block6;
                LOG.debug("Columns is empty or partNames is empty : Short-circuiting stats eval on client side.");
                aggrStats = new AggrStats(new ArrayList<ColumnStatisticsObj>(), 0L);
            }
            catch (Throwable throwable) {
                long diff = System.currentTimeMillis() - t1;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getAggrColStatsFor", diff, "HMS client");
                }
                throw throwable;
            }
            long diff = System.currentTimeMillis() - t1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getAggrColStatsFor", diff, "HMS client");
            }
            return aggrStats;
        }
        PartitionsStatsRequest req = new PartitionsStatsRequest(dbName, tblName, colNames, partNames);
        req.setEngine(engine);
        req.setCatName(catName);
        req.setValidWriteIdList(this.getValidWriteIdList(dbName, tblName));
        AggrStats aggrStats = this.getAggrStatsForInternal(req);
        long diff = System.currentTimeMillis() - t1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("class={}, method={}, duration={}, comments={}", this.CLASS_NAME, "getAggrColStatsFor", diff, "HMS client");
        }
        return aggrStats;
    }

    @Override
    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(final List<Long> fileIds) throws TException {
        return new MetastoreMapIterable<Long, ByteBuffer>(){
            private int listIndex = 0;

            @Override
            protected Map<Long, ByteBuffer> fetchNextBatch() throws TException {
                if (this.listIndex == fileIds.size()) {
                    return null;
                }
                int endIndex = Math.min(this.listIndex + HiveMetaStoreClient.this.fileMetadataBatchSize, fileIds.size());
                List subList = fileIds.subList(this.listIndex, endIndex);
                GetFileMetadataResult resp = HiveMetaStoreClient.this.sendGetFileMetadataReq(subList);
                if (!resp.isIsSupported()) {
                    return null;
                }
                this.listIndex = endIndex;
                return resp.getMetadata();
            }
        };
    }

    private GetFileMetadataResult sendGetFileMetadataReq(List<Long> fileIds) throws TException {
        return this.client.get_file_metadata(new GetFileMetadataRequest(fileIds));
    }

    @Override
    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(final List<Long> fileIds, final ByteBuffer sarg, final boolean doGetFooters) throws TException {
        return new MetastoreMapIterable<Long, MetadataPpdResult>(){
            private int listIndex = 0;

            @Override
            protected Map<Long, MetadataPpdResult> fetchNextBatch() throws TException {
                if (this.listIndex == fileIds.size()) {
                    return null;
                }
                int endIndex = Math.min(this.listIndex + HiveMetaStoreClient.this.fileMetadataBatchSize, fileIds.size());
                List subList = fileIds.subList(this.listIndex, endIndex);
                GetFileMetadataByExprResult resp = HiveMetaStoreClient.this.sendGetFileMetadataBySargReq(sarg, subList, doGetFooters);
                if (!resp.isIsSupported()) {
                    return null;
                }
                this.listIndex = endIndex;
                return resp.getMetadata();
            }
        };
    }

    private GetFileMetadataByExprResult sendGetFileMetadataBySargReq(ByteBuffer sarg, List<Long> fileIds, boolean doGetFooters) throws TException {
        GetFileMetadataByExprRequest req = new GetFileMetadataByExprRequest(fileIds, sarg);
        req.setDoGetFooters(doGetFooters);
        return this.client.get_file_metadata_by_expr(req);
    }

    @Override
    public void clearFileMetadata(List<Long> fileIds) throws TException {
        ClearFileMetadataRequest req = new ClearFileMetadataRequest();
        req.setFileIds(fileIds);
        this.client.clear_file_metadata(req);
    }

    @Override
    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws TException {
        PutFileMetadataRequest req = new PutFileMetadataRequest();
        req.setFileIds(fileIds);
        req.setMetadata(metadata);
        this.client.put_file_metadata(req);
    }

    @Override
    public boolean isSameConfObj(Configuration c) {
        return this.conf == c;
    }

    @Override
    public boolean cacheFileMetadata(String dbName, String tableName, String partName, boolean allParts) throws TException {
        CacheFileMetadataRequest req = new CacheFileMetadataRequest();
        req.setDbName(dbName);
        req.setTblName(tableName);
        if (partName != null) {
            req.setPartName(partName);
        } else {
            req.setIsAllParts(allParts);
        }
        CacheFileMetadataResult result = this.client.cache_file_metadata(req);
        return result.isIsSupported();
    }

    @Override
    public String getMetastoreDbUuid() throws TException {
        return this.client.get_metastore_db_uuid();
    }

    @Override
    public void createResourcePlan(WMResourcePlan resourcePlan, String copyFromName) throws InvalidObjectException, MetaException, TException {
        WMCreateResourcePlanRequest request = new WMCreateResourcePlanRequest();
        request.setResourcePlan(resourcePlan);
        request.setCopyFrom(copyFromName);
        this.client.create_resource_plan(request);
    }

    @Override
    public WMFullResourcePlan getResourcePlan(String resourcePlanName, String ns) throws NoSuchObjectException, MetaException, TException {
        WMGetResourcePlanRequest request = new WMGetResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setNs(ns);
        return this.client.get_resource_plan(request).getResourcePlan();
    }

    @Override
    public List<WMResourcePlan> getAllResourcePlans(String ns) throws NoSuchObjectException, MetaException, TException {
        WMGetAllResourcePlanRequest request = new WMGetAllResourcePlanRequest();
        request.setNs(ns);
        return this.client.get_all_resource_plans(request).getResourcePlans();
    }

    @Override
    public void dropResourcePlan(String resourcePlanName, String ns) throws NoSuchObjectException, MetaException, TException {
        WMDropResourcePlanRequest request = new WMDropResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setNs(ns);
        this.client.drop_resource_plan(request);
    }

    @Override
    public WMFullResourcePlan alterResourcePlan(String resourcePlanName, String ns, WMNullableResourcePlan resourcePlan, boolean canActivateDisabled, boolean isForceDeactivate, boolean isReplace) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMAlterResourcePlanRequest request = new WMAlterResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setNs(ns);
        request.setResourcePlan(resourcePlan);
        request.setIsEnableAndActivate(canActivateDisabled);
        request.setIsForceDeactivate(isForceDeactivate);
        request.setIsReplace(isReplace);
        WMAlterResourcePlanResponse resp = this.client.alter_resource_plan(request);
        return resp.isSetFullResourcePlan() ? resp.getFullResourcePlan() : null;
    }

    @Override
    public WMFullResourcePlan getActiveResourcePlan(String ns) throws MetaException, TException {
        WMGetActiveResourcePlanRequest request = new WMGetActiveResourcePlanRequest();
        request.setNs(ns);
        return this.client.get_active_resource_plan(request).getResourcePlan();
    }

    @Override
    public WMValidateResourcePlanResponse validateResourcePlan(String resourcePlanName, String ns) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMValidateResourcePlanRequest request = new WMValidateResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setNs(ns);
        return this.client.validate_resource_plan(request);
    }

    @Override
    public void createWMTrigger(WMTrigger trigger) throws InvalidObjectException, MetaException, TException {
        WMCreateTriggerRequest request = new WMCreateTriggerRequest();
        request.setTrigger(trigger);
        this.client.create_wm_trigger(request);
    }

    @Override
    public void alterWMTrigger(WMTrigger trigger) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMAlterTriggerRequest request = new WMAlterTriggerRequest();
        request.setTrigger(trigger);
        this.client.alter_wm_trigger(request);
    }

    @Override
    public void dropWMTrigger(String resourcePlanName, String triggerName, String ns) throws NoSuchObjectException, MetaException, TException {
        WMDropTriggerRequest request = new WMDropTriggerRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setTriggerName(triggerName);
        request.setNs(ns);
        this.client.drop_wm_trigger(request);
    }

    @Override
    public List<WMTrigger> getTriggersForResourcePlan(String resourcePlan, String ns) throws NoSuchObjectException, MetaException, TException {
        WMGetTriggersForResourePlanRequest request = new WMGetTriggersForResourePlanRequest();
        request.setResourcePlanName(resourcePlan);
        request.setNs(ns);
        return this.client.get_triggers_for_resourceplan(request).getTriggers();
    }

    @Override
    public void createWMPool(WMPool pool) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMCreatePoolRequest request = new WMCreatePoolRequest();
        request.setPool(pool);
        this.client.create_wm_pool(request);
    }

    @Override
    public void alterWMPool(WMNullablePool pool, String poolPath) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMAlterPoolRequest request = new WMAlterPoolRequest();
        request.setPool(pool);
        request.setPoolPath(poolPath);
        this.client.alter_wm_pool(request);
    }

    @Override
    public void dropWMPool(String resourcePlanName, String poolPath, String ns) throws NoSuchObjectException, MetaException, TException {
        WMDropPoolRequest request = new WMDropPoolRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setPoolPath(poolPath);
        request.setNs(ns);
        this.client.drop_wm_pool(request);
    }

    @Override
    public void createOrUpdateWMMapping(WMMapping mapping, boolean isUpdate) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMCreateOrUpdateMappingRequest request = new WMCreateOrUpdateMappingRequest();
        request.setMapping(mapping);
        request.setUpdate(isUpdate);
        this.client.create_or_update_wm_mapping(request);
    }

    @Override
    public void dropWMMapping(WMMapping mapping) throws NoSuchObjectException, MetaException, TException {
        WMDropMappingRequest request = new WMDropMappingRequest();
        request.setMapping(mapping);
        this.client.drop_wm_mapping(request);
    }

    @Override
    public void createOrDropTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath, boolean shouldDrop, String ns) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMCreateOrDropTriggerToPoolMappingRequest request = new WMCreateOrDropTriggerToPoolMappingRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setTriggerName(triggerName);
        request.setPoolPath(poolPath);
        request.setDrop(shouldDrop);
        request.setNs(ns);
        this.client.create_or_drop_wm_trigger_to_pool_mapping(request);
    }

    @Override
    public void createISchema(ISchema schema) throws TException {
        if (!schema.isSetCatName()) {
            schema.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        this.client.create_ischema(schema);
    }

    @Override
    public void alterISchema(String catName, String dbName, String schemaName, ISchema newSchema) throws TException {
        this.client.alter_ischema(new AlterISchemaRequest(new ISchemaName(catName, dbName, schemaName), newSchema));
    }

    @Override
    public ISchema getISchema(String catName, String dbName, String name) throws TException {
        return this.client.get_ischema(new ISchemaName(catName, dbName, name));
    }

    @Override
    public void dropISchema(String catName, String dbName, String name) throws TException {
        this.client.drop_ischema(new ISchemaName(catName, dbName, name));
    }

    @Override
    public void addSchemaVersion(SchemaVersion schemaVersion) throws TException {
        if (!schemaVersion.getSchema().isSetCatName()) {
            schemaVersion.getSchema().setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        this.client.add_schema_version(schemaVersion);
    }

    @Override
    public SchemaVersion getSchemaVersion(String catName, String dbName, String schemaName, int version) throws TException {
        return this.client.get_schema_version(new SchemaVersionDescriptor(new ISchemaName(catName, dbName, schemaName), version));
    }

    @Override
    public SchemaVersion getSchemaLatestVersion(String catName, String dbName, String schemaName) throws TException {
        return this.client.get_schema_latest_version(new ISchemaName(catName, dbName, schemaName));
    }

    @Override
    public List<SchemaVersion> getSchemaAllVersions(String catName, String dbName, String schemaName) throws TException {
        return this.client.get_schema_all_versions(new ISchemaName(catName, dbName, schemaName));
    }

    @Override
    public void dropSchemaVersion(String catName, String dbName, String schemaName, int version) throws TException {
        this.client.drop_schema_version(new SchemaVersionDescriptor(new ISchemaName(catName, dbName, schemaName), version));
    }

    @Override
    public FindSchemasByColsResp getSchemaByCols(FindSchemasByColsRqst rqst) throws TException {
        return this.client.get_schemas_by_cols(rqst);
    }

    @Override
    public void mapSchemaVersionToSerde(String catName, String dbName, String schemaName, int version, String serdeName) throws TException {
        this.client.map_schema_version_to_serde(new MapSchemaVersionToSerdeRequest(new SchemaVersionDescriptor(new ISchemaName(catName, dbName, schemaName), version), serdeName));
    }

    @Override
    public void setSchemaVersionState(String catName, String dbName, String schemaName, int version, SchemaVersionState state) throws TException {
        this.client.set_schema_version_state(new SetSchemaVersionStateRequest(new SchemaVersionDescriptor(new ISchemaName(catName, dbName, schemaName), version), state));
    }

    @Override
    public void addSerDe(SerDeInfo serDeInfo) throws TException {
        this.client.add_serde(serDeInfo);
    }

    @Override
    public SerDeInfo getSerDe(String serDeName) throws TException {
        return this.client.get_serde(new GetSerdeRequest(serDeName));
    }

    protected String getValidWriteIdList(String dbName, String tblName) {
        if (this.conf.get("hive.txn.tables.valid.writeids") == null) {
            return null;
        }
        ValidTxnWriteIdList validTxnWriteIdList = new ValidTxnWriteIdList(this.conf.get("hive.txn.tables.valid.writeids"));
        ValidWriteIdList writeIdList = validTxnWriteIdList.getTableValidWriteIdList(TableName.getDbTable(dbName, tblName));
        return writeIdList != null ? writeIdList.toString() : null;
    }

    private short shrinkMaxtoShort(int max) {
        if (max < 0) {
            return -1;
        }
        if (max <= Short.MAX_VALUE) {
            return (short)max;
        }
        return Short.MAX_VALUE;
    }

    @Override
    public LockResponse lockMaterializationRebuild(String dbName, String tableName, long txnId) throws TException {
        return this.client.get_lock_materialization_rebuild(dbName, tableName, txnId);
    }

    @Override
    public boolean heartbeatLockMaterializationRebuild(String dbName, String tableName, long txnId) throws TException {
        return this.client.heartbeat_lock_materialization_rebuild(dbName, tableName, txnId);
    }

    @Override
    public void addRuntimeStat(RuntimeStat stat) throws TException {
        this.client.add_runtime_stats(stat);
    }

    @Override
    public List<RuntimeStat> getRuntimeStats(int maxWeight, int maxCreateTime) throws TException {
        GetRuntimeStatsRequest req = new GetRuntimeStatsRequest();
        req.setMaxWeight(maxWeight);
        req.setMaxCreateTime(maxCreateTime);
        return this.client.get_runtime_stats(req);
    }

    @Override
    public GetPartitionsResponse getPartitionsWithSpecs(GetPartitionsRequest request) throws TException {
        if (processorCapabilities != null) {
            request.setProcessorCapabilities(new ArrayList<String>(Arrays.asList(processorCapabilities)));
        }
        if (processorIdentifier != null) {
            request.setProcessorIdentifier(processorIdentifier);
        }
        if (request.isSetProjectionSpec()) {
            if (!request.getProjectionSpec().isSetExcludeParamKeyPattern()) {
                request.getProjectionSpec().setExcludeParamKeyPattern(MetastoreConf.getAsString(this.conf, MetastoreConf.ConfVars.METASTORE_PARTITIONS_PARAMETERS_EXCLUDE_PATTERN));
            }
            if (!request.getProjectionSpec().isSetIncludeParamKeyPattern()) {
                request.getProjectionSpec().setIncludeParamKeyPattern(MetastoreConf.getAsString(this.conf, MetastoreConf.ConfVars.METASTORE_PARTITIONS_PARAMETERS_INCLUDE_PATTERN));
            }
        }
        return this.client.get_partitions_with_specs(request);
    }

    @Override
    @Deprecated
    public OptionalCompactionInfoStruct findNextCompact(String workerId) throws TException {
        return this.client.find_next_compact(workerId);
    }

    @Override
    public OptionalCompactionInfoStruct findNextCompact(FindNextCompactRequest rqst) throws TException {
        return this.client.find_next_compact2(rqst);
    }

    @Override
    public void updateCompactorState(CompactionInfoStruct cr, long txnId) throws TException {
        this.client.update_compactor_state(cr, txnId);
    }

    @Override
    public List<String> findColumnsWithStats(CompactionInfoStruct cr) throws TException {
        return this.client.find_columns_with_stats(cr);
    }

    @Override
    public void markCleaned(CompactionInfoStruct cr) throws MetaException, TException {
        this.client.mark_cleaned(cr);
    }

    @Override
    public void markCompacted(CompactionInfoStruct cr) throws MetaException, TException {
        this.client.mark_compacted(cr);
    }

    @Override
    public void markFailed(CompactionInfoStruct cr) throws MetaException, TException {
        this.client.mark_failed(cr);
    }

    @Override
    public void markRefused(CompactionInfoStruct cr) throws MetaException, TException {
        this.client.mark_refused(cr);
    }

    @Override
    public boolean updateCompactionMetricsData(CompactionMetricsDataStruct struct) throws MetaException, TException {
        return this.client.update_compaction_metrics_data(struct);
    }

    @Override
    public void removeCompactionMetricsData(CompactionMetricsDataRequest request) throws MetaException, TException {
        this.client.remove_compaction_metrics_data(request);
    }

    @Override
    public void setHadoopJobid(String jobId, long cqId) throws MetaException, TException {
        this.client.set_hadoop_jobid(jobId, cqId);
    }

    @Override
    public String getServerVersion() throws TException {
        return this.client.getVersion();
    }

    @Override
    public ScheduledQuery getScheduledQuery(ScheduledQueryKey scheduleKey) throws TException {
        return this.client.get_scheduled_query(scheduleKey);
    }

    @Override
    public void scheduledQueryProgress(ScheduledQueryProgressInfo info) throws TException {
        this.client.scheduled_query_progress(info);
    }

    @Override
    public ScheduledQueryPollResponse scheduledQueryPoll(ScheduledQueryPollRequest request) throws MetaException, TException {
        return this.client.scheduled_query_poll(request);
    }

    @Override
    public void scheduledQueryMaintenance(ScheduledQueryMaintenanceRequest request) throws MetaException, TException {
        this.client.scheduled_query_maintenance(request);
    }

    @Override
    public void addReplicationMetrics(ReplicationMetricList replicationMetricList) throws MetaException, TException {
        this.client.add_replication_metrics(replicationMetricList);
    }

    @Override
    public ReplicationMetricList getReplicationMetrics(GetReplicationMetricsRequest replicationMetricsRequest) throws MetaException, TException {
        return this.client.get_replication_metrics(replicationMetricsRequest);
    }

    @Override
    public void createStoredProcedure(StoredProcedure proc) throws NoSuchObjectException, MetaException, TException {
        this.client.create_stored_procedure(proc);
    }

    @Override
    public StoredProcedure getStoredProcedure(StoredProcedureRequest request) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_stored_procedure(request);
    }

    @Override
    public void dropStoredProcedure(StoredProcedureRequest request) throws MetaException, NoSuchObjectException, TException {
        this.client.drop_stored_procedure(request);
    }

    @Override
    public List<String> getAllStoredProcedures(ListStoredProcedureRequest request) throws MetaException, TException {
        return this.client.get_all_stored_procedures(request);
    }

    @Override
    public void addPackage(AddPackageRequest request) throws NoSuchObjectException, MetaException, TException {
        this.client.add_package(request);
    }

    @Override
    public Package findPackage(GetPackageRequest request) throws TException {
        return this.client.find_package(request);
    }

    @Override
    public List<String> listPackages(ListPackageRequest request) throws TException {
        return this.client.get_all_packages(request);
    }

    @Override
    public void dropPackage(DropPackageRequest request) throws TException {
        this.client.drop_package(request);
    }

    @Override
    public List<WriteEventInfo> getAllWriteEventInfo(GetAllWriteEventInfoRequest request) throws TException {
        return this.client.get_all_write_event_info(request);
    }

    @Override
    public AbortCompactResponse abortCompactions(AbortCompactionRequest request) throws TException {
        return this.client.abort_Compactions(request);
    }

    @Override
    public boolean setProperties(String nameSpace, Map<String, String> properties) throws TException {
        PropertySetRequest psr = new PropertySetRequest();
        psr.setNameSpace(nameSpace);
        psr.setPropertyMap(properties);
        return this.client.set_properties(psr);
    }

    @Override
    public Map<String, Map<String, String>> getProperties(String nameSpace, String mapPrefix, String mapPredicate, String ... selection) throws TException {
        PropertyGetRequest request = new PropertyGetRequest();
        request.setNameSpace(nameSpace);
        request.setMapPrefix(mapPrefix);
        request.setMapPredicate(mapPredicate);
        if (selection != null && selection.length > 0) {
            request.setMapSelection(Arrays.asList(selection));
        }
        PropertyGetResponse response = this.client.get_properties(request);
        return response.getProperties();
    }

    static {
        LOG = LoggerFactory.getLogger(HiveMetaStoreClient.class);
    }

    public static abstract class MetastoreMapIterable<K, V>
    implements Iterable<Map.Entry<K, V>>,
    Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, V>> currentIter;

        protected abstract Map<K, V> fetchNextBatch() throws TException;

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            this.ensureCurrentBatch();
            return this.currentIter != null;
        }

        private void ensureCurrentBatch() {
            Map<K, V> currentBatch;
            if (this.currentIter != null && this.currentIter.hasNext()) {
                return;
            }
            this.currentIter = null;
            do {
                try {
                    currentBatch = this.fetchNextBatch();
                }
                catch (TException ex) {
                    throw new RuntimeException(ex);
                }
                if (currentBatch != null) continue;
                return;
            } while (currentBatch.isEmpty());
            this.currentIter = currentBatch.entrySet().iterator();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.ensureCurrentBatch();
            if (this.currentIter == null) {
                throw new NoSuchElementException();
            }
            return this.currentIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final IMetaStoreClient client;

        SynchronizedHandler(IMetaStoreClient client) {
            this.client = client;
        }

        @Override
        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.client, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

