/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobFilter;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathExistsException;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.common.DataCopyStatistics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.hive.common.util.SuppressFBWarnings;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOG;
    private static final Random random;
    public static final int IO_ERROR_SLEEP_TIME = 100;
    public static final PathFilter HIDDEN_FILES_PATH_FILTER;
    public static final PathFilter STAGING_DIR_PATH_FILTER;
    static BitSet charToEscape;
    private static final char[] HEX_UPPER_CHARS;

    public static Path makeQualified(Path path, Configuration conf) throws IOException {
        if (!path.isAbsolute()) {
            return path.makeQualified(FileSystem.get(conf));
        }
        URI fsUri = FileSystem.getDefaultUri(conf);
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme == null) {
            scheme = fsUri.getScheme();
            authority = fsUri.getAuthority();
            if (authority == null) {
                authority = "";
            }
        } else if (authority == null) {
            authority = scheme.equals(fsUri.getScheme()) && fsUri.getAuthority() != null ? fsUri.getAuthority() : "";
        }
        return new Path(scheme, authority, pathUri.getPath());
    }

    private FileUtils() {
    }

    public static String makePartName(List<String> partCols, List<String> vals) {
        return FileUtils.makePartName(partCols, vals, null);
    }

    public static String makePartName(List<String> partCols, List<String> vals, String defaultStr) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < partCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(partCols.get(i).toLowerCase(), defaultStr));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i), defaultStr));
        }
        return name.toString();
    }

    public static String makeDefaultListBucketingDirName(List<String> skewedCols, String name) {
        String defaultDir = FileUtils.escapePathName(name);
        StringBuilder defaultDirPath = new StringBuilder();
        for (int i = 0; i < skewedCols.size(); ++i) {
            if (i > 0) {
                defaultDirPath.append("/");
            }
            defaultDirPath.append(defaultDir);
        }
        String lbDirName = defaultDirPath.toString();
        return lbDirName;
    }

    public static String makeListBucketingDirName(List<String> lbCols, List<String> vals) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < lbCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(lbCols.get(i).toLowerCase()));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i)));
        }
        return name.toString();
    }

    static boolean needsEscaping(char c) {
        return c < charToEscape.size() && charToEscape.get(c);
    }

    public static String escapePathName(String path) {
        return FileUtils.escapePathName(path, null);
    }

    public static String escapePathName(String path, String defaultPath) {
        if (path == null || path.length() == 0) {
            if (defaultPath == null) {
                return "__HIVE_DEFAULT_PARTITION__";
            }
            return defaultPath;
        }
        int firstEscapeIndex = -1;
        for (int i = 0; i < path.length(); ++i) {
            if (!FileUtils.needsEscaping(path.charAt(i))) continue;
            firstEscapeIndex = i;
            break;
        }
        if (firstEscapeIndex == -1) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        if (firstEscapeIndex > 0) {
            sb.append(path, 0, firstEscapeIndex);
        }
        for (int i = firstEscapeIndex; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (FileUtils.needsEscaping(c)) {
                sb.append('%').append(HEX_UPPER_CHARS[(0xF0 & c) >>> 4]).append(HEX_UPPER_CHARS[0xF & c]);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapePathName(String path) {
        int firstUnescapeIndex = path.indexOf(37);
        if (firstUnescapeIndex == -1) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        if (firstUnescapeIndex > 0) {
            sb.append(path, 0, firstUnescapeIndex);
        }
        for (int i = firstUnescapeIndex; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.parseInt(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, List<FileStatus> results) throws IOException {
        if (FileUtils.isS3a(fs)) {
            FileUtils.listS3FilesRecursive(fileStatus, fs, results);
        } else {
            FileUtils.generalListStatusRecursively(fs, fileStatus, results);
        }
    }

    private static void generalListStatusRecursively(FileSystem fs, FileStatus fileStatus, List<FileStatus> results) throws IOException {
        if (fileStatus.isDirectory()) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath(), HIDDEN_FILES_PATH_FILTER)) {
                FileUtils.generalListStatusRecursively(fs, stat, results);
            }
        } else {
            results.add(fileStatus);
        }
    }

    private static void listS3FilesRecursive(FileStatus base, FileSystem fs, List<FileStatus> results) throws IOException {
        if (!base.isDirectory()) {
            results.add(base);
            return;
        }
        RemoteIterator<LocatedFileStatus> remoteIterator = fs.listFiles(base.getPath(), true);
        while (remoteIterator.hasNext()) {
            LocatedFileStatus each = remoteIterator.next();
            Path relativePath = FileUtils.makeRelative(base.getPath(), each.getPath());
            if (!FileUtils.RemoteIteratorWithFilter.HIDDEN_FILES_FULL_PATH_FILTER.accept(relativePath)) continue;
            results.add(each);
        }
    }

    public static Path makeRelative(Path parentPath, Path childPath) {
        String parentString = parentPath.toString().endsWith("/") ? parentPath.toString() : parentPath.toString() + "/";
        String childString = childPath.toString().endsWith("/") ? childPath.toString() : childPath.toString() + "/";
        return new Path(childString.replaceFirst(parentString, ""));
    }

    public static boolean isS3a(FileSystem fs) {
        try {
            return "s3a".equalsIgnoreCase(fs.getScheme());
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    public static FileStatus getPathOrParentThatExists(FileSystem fs, Path path) throws IOException {
        FileStatus stat = FileUtils.getFileStatusOrNull(fs, path);
        if (stat != null) {
            return stat;
        }
        Path parentPath = path.getParent();
        return FileUtils.getPathOrParentThatExists(fs, parentPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkFileAccessWithImpersonation(FileSystem fs, FileStatus stat, FsAction action, String user) throws Exception {
        UserGroupInformation proxyUser = null;
        try {
            proxyUser = FileUtils.getProxyUser(user);
            FileSystem fsAsUser = FileUtils.getFsAsUser(fs, proxyUser);
            FileUtils.checkFileAccessWithImpersonation(fs, stat, action, user, null, fsAsUser);
        }
        finally {
            FileUtils.closeFs(proxyUser);
        }
    }

    public static void checkFileAccessWithImpersonation(FileSystem fs, final FileStatus stat, final FsAction action, String user, final List<FileStatus> children, final FileSystem fsAsUser) throws IOException, AccessControlException, InterruptedException, Exception {
        UserGroupInformation ugi = Utils.getUGI();
        String currentUser = ugi.getShortUserName();
        if (user == null || currentUser.equals(user)) {
            ShimLoader.getHadoopShims().checkFileAccess(fs, stat, action);
            FileUtils.addChildren(fs, stat.getPath(), children);
            return;
        }
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser(user, UserGroupInformation.getLoginUser());
        proxyUser.doAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                ShimLoader.getHadoopShims().checkFileAccess(fsAsUser, stat, action);
                FileUtils.addChildren(fsAsUser, stat.getPath(), children);
                return null;
            }
        });
    }

    private static void addChildren(FileSystem fsAsUser, Path path, List<FileStatus> children) throws IOException {
        if (children != null) {
            FileStatus[] listStatus;
            try {
                listStatus = fsAsUser.listStatus(path);
            }
            catch (IOException e) {
                LOG.warn("Unable to list files under " + path + " : " + e);
                throw e;
            }
            children.addAll(Arrays.asList(listStatus));
        }
    }

    public static UserGroupInformation getProxyUser(String user) throws LoginException, IOException {
        UserGroupInformation ugi = Utils.getUGI();
        String currentUser = ugi.getShortUserName();
        UserGroupInformation proxyUser = null;
        if (user != null && !user.equals(currentUser)) {
            proxyUser = UserGroupInformation.createProxyUser(user, UserGroupInformation.getLoginUser());
        }
        return proxyUser;
    }

    public static void closeFs(UserGroupInformation proxyUser) throws IOException {
        if (proxyUser != null) {
            FileSystem.closeAllForUGI(proxyUser);
        }
    }

    public static FileSystem getFsAsUser(final FileSystem fs, UserGroupInformation proxyUser) throws IOException, InterruptedException {
        if (proxyUser == null) {
            return null;
        }
        FileSystem fsAsUser = proxyUser.doAs(new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get(fs.getUri(), fs.getConf());
            }
        });
        return fsAsUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActionPermittedForFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, FsAction action) throws Exception {
        UserGroupInformation proxyUser = null;
        boolean isPermitted = false;
        try {
            proxyUser = FileUtils.getProxyUser(userName);
            FileSystem fsAsUser = FileUtils.getFsAsUser(fs, proxyUser);
            isPermitted = FileUtils.isActionPermittedForFileHierarchy(fs, fileStatus, userName, action, true, fsAsUser);
        }
        finally {
            FileUtils.closeFs(proxyUser);
        }
        return isPermitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActionPermittedForFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, FsAction action, boolean recurse) throws Exception {
        boolean isPermitted;
        UserGroupInformation proxyUser = null;
        try {
            proxyUser = FileUtils.getProxyUser(userName);
            FileSystem fsAsUser = FileUtils.getFsAsUser(fs, proxyUser);
            isPermitted = FileUtils.isActionPermittedForFileHierarchy(fs, fileStatus, userName, action, recurse, fsAsUser);
        }
        finally {
            FileUtils.closeFs(proxyUser);
        }
        return isPermitted;
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Intended, dir privilege all-around bug")
    public static boolean isActionPermittedForFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, FsAction action, boolean recurse, FileSystem fsAsUser) throws Exception {
        boolean isDir = fileStatus.isDirectory();
        FsAction dirActionNeeded = isDir ? action.and(FsAction.EXECUTE) : action;
        ArrayList<FileStatus> subDirsToCheck = null;
        if (isDir && recurse) {
            subDirsToCheck = new ArrayList<FileStatus>();
        }
        try {
            FileUtils.checkFileAccessWithImpersonation(fs, fileStatus, action, userName, subDirsToCheck, fsAsUser);
        }
        catch (AccessControlException err) {
            LOG.warn("Action " + action + " denied on " + fileStatus.getPath() + " for user " + userName);
            return false;
        }
        if (subDirsToCheck == null || subDirsToCheck.isEmpty()) {
            return true;
        }
        for (FileStatus childStatus : subDirsToCheck) {
            if (FileUtils.isActionPermittedForFileHierarchy(fs, childStatus, userName, action, true, fsAsUser)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLocalFile(HiveConf conf, String fileName) {
        try {
            return FileUtils.isLocalFile(conf, new URI(fileName));
        }
        catch (URISyntaxException e) {
            LOG.warn("Unable to create URI from " + fileName, e);
            return false;
        }
    }

    public static boolean isLocalFile(HiveConf conf, URI fileUri) {
        try {
            FileSystem fsForFile = FileSystem.get(fileUri, conf);
            return LocalFileSystem.class.isInstance(fsForFile);
        }
        catch (IOException e) {
            LOG.warn("Unable to get FileSystem for " + fileUri, e);
            return false;
        }
    }

    public static boolean isOwnerOfFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName) throws IOException, InterruptedException {
        return FileUtils.isOwnerOfFileHierarchy(fs, fileStatus, userName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOwnerOfFileHierarchy(final FileSystem fs, final FileStatus fileStatus, final String userName, final boolean recurse) throws IOException, InterruptedException {
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser(userName, UserGroupInformation.getLoginUser());
        try {
            boolean isOwner;
            boolean bl = isOwner = proxyUser.doAs(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    FileSystem fsAsUser = FileSystem.get(fs.getUri(), fs.getConf());
                    return FileUtils.checkIsOwnerOfFileHierarchy(fsAsUser, fileStatus, userName, recurse);
                }
            }).booleanValue();
            return bl;
        }
        finally {
            FileSystem.closeAllForUGI(proxyUser);
        }
    }

    public static boolean checkIsOwnerOfFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, boolean recurse) throws IOException {
        if (!fileStatus.getOwner().equals(userName)) {
            return false;
        }
        if (!fileStatus.isDirectory() || !recurse) {
            return true;
        }
        FileStatus[] childStatuses = null;
        try {
            childStatuses = fs.listStatus(fileStatus.getPath());
        }
        catch (FileNotFoundException fe) {
            LOG.debug("Skipping child access check since the directory is already removed");
            return true;
        }
        for (FileStatus childStatus : childStatuses) {
            if (FileUtils.checkIsOwnerOfFileHierarchy(fs, childStatus, userName, true)) continue;
            return false;
        }
        return true;
    }

    public static boolean mkdir(FileSystem fs, Path f, Configuration conf) throws IOException {
        LOG.info("Creating directory if it doesn't exist: " + f);
        return fs.mkdirs(f);
    }

    public static Path makeAbsolute(FileSystem fileSystem, Path path) throws IOException {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(fileSystem.getWorkingDirectory(), path);
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, HiveConf conf, DataCopyStatistics copyStatistics) throws IOException {
        return FileUtils.copy(srcFS, src, dstFS, dst, deleteSource, overwrite, conf, ShimLoader.getHadoopShims(), copyStatistics);
    }

    @VisibleForTesting
    static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, HiveConf conf, HadoopShims shims, DataCopyStatistics copyStatistics) throws IOException {
        ContentSummary srcContentSummary;
        boolean copied = false;
        boolean triedDistcp = false;
        if (srcFS.getUri().getScheme().equals("hdfs") && (srcContentSummary = srcFS.getContentSummary(src)).getFileCount() > conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXNUMFILES) && srcContentSummary.getLength() > conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXSIZE)) {
            LOG.info("Source is " + srcContentSummary.getLength() + " bytes. (MAX: " + conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXSIZE) + ")");
            LOG.info("Source is " + srcContentSummary.getFileCount() + " files. (MAX: " + conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXNUMFILES) + ")");
            LOG.info("Launch distributed copy (distcp) job.");
            triedDistcp = true;
            copied = FileUtils.distCp(srcFS, Collections.singletonList(src), dst, deleteSource, null, conf, shims);
            copyStatistics.incrementBytesCopiedCounter(srcContentSummary.getLength());
        }
        if (!triedDistcp) {
            copied = FileUtils.doIOUtilsCopyBytes(srcFS, srcFS.getFileStatus(src), dstFS, dst, deleteSource, overwrite, FileUtils.shouldPreserveXAttrs(conf, srcFS, dstFS, src), conf, copyStatistics);
        }
        return copied;
    }

    public static boolean doIOUtilsCopyBytes(FileSystem srcFS, FileStatus srcStatus, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, boolean preserveXAttrs, Configuration conf, DataCopyStatistics copyStatistics) throws IOException {
        Path src = srcStatus.getPath();
        dst = FileUtils.checkDest(src.getName(), dstFS, dst, overwrite);
        if (srcStatus.isDirectory()) {
            FileStatus[] fileStatus;
            FileUtils.checkDependencies(srcFS, src, dstFS, dst);
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            for (FileStatus file : fileStatus = srcFS.listStatus(src)) {
                FileUtils.doIOUtilsCopyBytes(srcFS, file, dstFS, new Path(dst, file.getPath().getName()), deleteSource, overwrite, preserveXAttrs, conf, copyStatistics);
            }
            if (preserveXAttrs) {
                FileUtils.preserveXAttr(srcFS, src, dstFS, dst);
            }
        } else {
            FSDataInputStream in = null;
            FSDataOutputStream out = null;
            try {
                in = srcFS.open(src);
                out = dstFS.create(dst, overwrite);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, conf, true);
                if (preserveXAttrs) {
                    FileUtils.preserveXAttr(srcFS, src, dstFS, dst);
                }
                long bytesCopied = srcFS.getFileStatus(src).getLen();
                copyStatistics.incrementBytesCopiedCounter(bytesCopied);
            }
            catch (IOException var11) {
                IOUtils.closeStream(in);
                IOUtils.closeStream(out);
                throw var11;
            }
        }
        return deleteSource ? srcFS.delete(src, true) : true;
    }

    public static boolean copy(FileSystem srcFS, Path[] srcs, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, boolean preserveXAttr, Configuration conf, DataCopyStatistics copyStatistics) throws IOException {
        boolean gotException = false;
        boolean returnVal = true;
        StringBuilder exceptions = new StringBuilder();
        if (srcs.length == 1) {
            return FileUtils.doIOUtilsCopyBytes(srcFS, srcFS.getFileStatus(srcs[0]), dstFS, dst, deleteSource, overwrite, preserveXAttr, conf, copyStatistics);
        }
        try {
            FileStatus sdst = dstFS.getFileStatus(dst);
            if (!sdst.isDirectory()) {
                throw new IOException("copying multiple files, but last argument `" + dst + "' is not a directory");
            }
        }
        catch (FileNotFoundException var16) {
            throw new IOException("`" + dst + "': specified destination directory does not exist", var16);
        }
        Path[] var17 = srcs;
        int var11 = srcs.length;
        for (int var12 = 0; var12 < var11; ++var12) {
            Path src = var17[var12];
            try {
                if (FileUtils.doIOUtilsCopyBytes(srcFS, srcFS.getFileStatus(src), dstFS, dst, deleteSource, overwrite, preserveXAttr, conf, copyStatistics)) continue;
                returnVal = false;
                continue;
            }
            catch (IOException var15) {
                gotException = true;
                exceptions.append(var15.getMessage());
                exceptions.append("\n");
            }
        }
        if (gotException) {
            throw new IOException(exceptions.toString());
        }
        return returnVal;
    }

    private static void preserveXAttr(FileSystem srcFS, Path src, FileSystem dstFS, Path dst) throws IOException {
        for (Map.Entry<String, byte[]> attr : srcFS.getXAttrs(src).entrySet()) {
            dstFS.setXAttr(dst, attr.getKey(), attr.getValue());
        }
    }

    private static Path checkDest(String srcName, FileSystem dstFS, Path dst, boolean overwrite) throws IOException {
        FileStatus sdst;
        try {
            sdst = dstFS.getFileStatus(dst);
        }
        catch (FileNotFoundException var6) {
            sdst = null;
        }
        if (null != sdst) {
            if (sdst.isDirectory()) {
                if (null == srcName) {
                    throw new PathIsDirectoryException(dst.toString());
                }
                return FileUtils.checkDest(null, dstFS, new Path(dst, srcName), overwrite);
            }
            if (!overwrite) {
                throw new PathExistsException(dst.toString(), "Target " + dst + " already exists");
            }
        }
        return dst;
    }

    private static void checkDependencies(FileSystem srcFS, Path src, FileSystem dstFS, Path dst) throws IOException {
        if (srcFS == dstFS) {
            String srcq = srcFS.makeQualified(src).toString() + "/";
            String dstq = dstFS.makeQualified(dst).toString() + "/";
            if (dstq.startsWith(srcq)) {
                throw new IOException(srcq.length() == dstq.length() ? "Cannot copy " + src + " to itself." : "Cannot copy " + src + " to its subdirectory " + dst);
            }
        }
    }

    public static boolean shouldPreserveXAttrs(HiveConf conf, FileSystem srcFS, FileSystem dstFS, Path path) throws IOException {
        Preconditions.checkNotNull(path);
        if (conf.getBoolVar(HiveConf.ConfVars.DFS_XATTR_ONLY_SUPPORTED_ON_RESERVED_NAMESPACE) ? !path.toUri().getPath().startsWith("/.reserved/raw/") || !Utils.checkFileSystemXAttrSupport(srcFS, new Path("/.reserved/raw/")) || !Utils.checkFileSystemXAttrSupport(dstFS, new Path("/.reserved/raw/")) : !Utils.checkFileSystemXAttrSupport(srcFS) || !Utils.checkFileSystemXAttrSupport(dstFS)) {
            return false;
        }
        for (Map.Entry<String, String> entry : conf.getPropsWithPrefix("distcp.options.").entrySet()) {
            String distCpOption = entry.getKey();
            if (!distCpOption.startsWith("p")) continue;
            return distCpOption.contains("x");
        }
        return true;
    }

    public static boolean distCp(FileSystem srcFS, List<Path> srcPaths, Path dst, boolean deleteSource, UserGroupInformation proxyUser, HiveConf conf, HadoopShims shims) throws IOException {
        LOG.debug("copying srcPaths : {}, to DestPath :{} ,with doAs: {}", org.apache.hadoop.util.StringUtils.join((CharSequence)",", srcPaths), dst.toString(), proxyUser);
        boolean copied = false;
        copied = proxyUser == null ? shims.runDistCp(srcPaths, dst, conf) : shims.runDistCpAs(srcPaths, dst, conf, proxyUser);
        if (copied && deleteSource) {
            if (proxyUser != null) {
                throw new IOException("Distcp is called with doAsUser and delete source set as true");
            }
            for (Path path : srcPaths) {
                srcFS.delete(path, true);
            }
        }
        return copied;
    }

    public static boolean distCpWithSnapshot(String oldSnapshot, String newSnapshot, List<Path> srcPaths, Path dst, boolean overwriteTarget, HiveConf conf, HadoopShims shims, UserGroupInformation proxyUser) {
        boolean copied = false;
        try {
            copied = proxyUser == null ? shims.runDistCpWithSnapshots(oldSnapshot, newSnapshot, srcPaths, dst, overwriteTarget, conf) : shims.runDistCpWithSnapshotsAs(oldSnapshot, newSnapshot, srcPaths, dst, overwriteTarget, proxyUser, conf);
            if (copied) {
                LOG.info("Successfully copied using snapshots source {} and dest {} using snapshots {} and {}", srcPaths, dst, oldSnapshot, newSnapshot);
            }
        }
        catch (IOException e) {
            LOG.error("Can not copy using snapshot from source: {}, target: {}", (Object)srcPaths, (Object)dst);
        }
        return copied;
    }

    public static boolean moveToTrash(FileSystem fs, Path f, Configuration conf, boolean purge) throws IOException {
        LOG.debug("deleting  " + f);
        boolean result = false;
        try {
            if (purge) {
                LOG.debug("purge is set to true. Not moving to Trash " + f);
            } else {
                result = Trash.moveToAppropriateTrash(fs, f, conf);
                if (result) {
                    LOG.trace("Moved to trash: " + f);
                    return true;
                }
            }
        }
        catch (IOException ioe) {
            LOG.warn(ioe.getMessage() + "; Force to delete it.");
        }
        result = fs.delete(f, true);
        if (!result) {
            LOG.error("Failed to delete " + f);
        }
        return result;
    }

    public static boolean rename(FileSystem fs, Path sourcePath, Path destPath, Configuration conf) throws IOException {
        LOG.info("Renaming " + sourcePath + " to " + destPath);
        if (fs.exists(destPath)) {
            throw new IOException("Cannot rename the source path. The destination path already exists.");
        }
        return fs.rename(sourcePath, destPath);
    }

    public static boolean equalsFileSystem(FileSystem fs1, FileSystem fs2) {
        return fs1.getUri().equals(fs2.getUri());
    }

    public static void checkDeletePermission(Path path, Configuration conf, String user) throws AccessControlException, InterruptedException, Exception {
        if (path == null) {
            return;
        }
        FileSystem fs = path.getFileSystem(conf);
        FileStatus stat = null;
        try {
            stat = fs.getFileStatus(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (stat == null) {
            return;
        }
        FileUtils.checkFileAccessWithImpersonation(fs, stat, FsAction.WRITE, user);
        HadoopShims shims = ShimLoader.getHadoopShims();
        if (!shims.supportStickyBit()) {
            return;
        }
        FileStatus parStatus = fs.getFileStatus(path.getParent());
        if (!shims.hasStickyBit(parStatus.getPermission())) {
            return;
        }
        if (parStatus.getOwner().equals(user)) {
            return;
        }
        FileStatus childStatus = fs.getFileStatus(path);
        if (childStatus.getOwner().equals(user)) {
            return;
        }
        String msg = String.format("Permission Denied: User %s can't delete %s because sticky bit is set on the parent dir and user does not own this file or its parent", user, path);
        throw new IOException(msg);
    }

    public static FileStatus getFileStatusOrNull(FileSystem fs, Path path) throws IOException {
        try {
            return fs.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static void deleteDirectory(File directory) throws IOException {
        org.apache.hive.org.apache.commons.io.FileUtils.deleteDirectory((File)directory);
    }

    public static File createTempFile(String lScratchDir, String prefix, String suffix) throws IOException {
        File tmpDir;
        File file = tmpDir = lScratchDir == null ? null : new File(lScratchDir);
        if (!(tmpDir == null || tmpDir.exists() || tmpDir.mkdirs() || tmpDir.exists())) {
            throw new RuntimeException("Unable to create temp directory " + lScratchDir);
        }
        File tmpFile = File.createTempFile(prefix, suffix, tmpDir);
        ShutdownHookManager.deleteOnExit(tmpFile);
        return tmpFile;
    }

    public static File createLocalDirsTempFile(String localDirList, String prefix, String suffix, boolean isDirectory) throws IOException {
        if (localDirList == null || localDirList.isEmpty()) {
            return FileUtils.createFileInTmp(prefix, suffix, "Local directories not specified", isDirectory);
        }
        String[] localDirs = org.apache.hadoop.util.StringUtils.getTrimmedStrings(localDirList);
        if (localDirs.length == 0) {
            return FileUtils.createFileInTmp(prefix, suffix, "Local directories not specified", isDirectory);
        }
        String path = localDirs[random.nextInt(localDirs.length)];
        if (path == null || path.isEmpty()) {
            return FileUtils.createFileInTmp(prefix, suffix, "Empty path for one of the local dirs", isDirectory);
        }
        File targetDir = new File(path);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            return FileUtils.createFileInTmp(prefix, suffix, "Cannot access or create " + targetDir, isDirectory);
        }
        try {
            File file = File.createTempFile(prefix, suffix, targetDir);
            if (!(!isDirectory || file.delete() && file.mkdirs())) {
                return FileUtils.createFileInTmp(prefix, suffix, "Cannot recreate " + file + " as directory", isDirectory);
            }
            file.deleteOnExit();
            return file;
        }
        catch (IOException ex) {
            LOG.error("Error creating a file in " + targetDir, ex);
            return FileUtils.createFileInTmp(prefix, suffix, "Cannot create a file in " + targetDir, isDirectory);
        }
    }

    private static File createFileInTmp(String prefix, String suffix, String reason, boolean isDirectory) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        if (!(!isDirectory || file.delete() && file.mkdirs())) {
            throw new IOException("Cannot recreate " + file + " as directory");
        }
        file.deleteOnExit();
        LOG.info(reason + "; created a tmp file: " + file.getAbsolutePath());
        return file;
    }

    public static File createLocalDirsTempFile(Configuration conf, String prefix, String suffix, boolean isDirectory) throws IOException {
        return FileUtils.createLocalDirsTempFile(conf.get("yarn.nodemanager.local-dirs"), prefix, suffix, isDirectory);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Intended")
    public static boolean deleteTmpFile(File tempFile) {
        if (tempFile != null) {
            tempFile.delete();
            ShutdownHookManager.cancelDeleteOnExit(tempFile);
            return true;
        }
        return false;
    }

    public static boolean pathsContainNoScheme(Collection<Path> paths) {
        for (Path path : paths) {
            if (path.toUri().getScheme() == null) continue;
            return false;
        }
        return true;
    }

    public static Path getParentRegardlessOfScheme(Path path, Collection<Path> candidates) {
        for (Path schemalessPath = Path.getPathWithoutSchemeAndAuthority(path); path != null && schemalessPath != null; path = path.getParent(), schemalessPath = schemalessPath.getParent()) {
            if (candidates.contains(path)) {
                return path;
            }
            if (!candidates.contains(schemalessPath)) continue;
            return schemalessPath;
        }
        return null;
    }

    public static boolean isPathWithinSubtree(Path path, Path subtree) {
        return FileUtils.isPathWithinSubtree(path, subtree, subtree.depth());
    }

    private static boolean isPathWithinSubtree(Path path, Path subtree, int subtreeDepth) {
        while (path != null) {
            if (subtreeDepth > path.depth()) {
                return false;
            }
            if (subtree.equals(path)) {
                return true;
            }
            path = path.getParent();
        }
        return false;
    }

    public static void populateParentPaths(Set<Path> parents, Path path) {
        if (parents == null) {
            return;
        }
        while (path != null) {
            parents.add(path);
            path = path.getParent();
        }
    }

    public static URI getURI(String path) throws URISyntaxException {
        if (path == null) {
            return null;
        }
        URI uri = new URI(path);
        if (uri.getScheme() == null) {
            uri = new File(path).toURI();
        }
        return uri;
    }

    public static Set<String> getJarFilesByPath(String pathString, Configuration conf) {
        String[] paths;
        if (StringUtils.isBlank(pathString)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String path : paths = pathString.split(",")) {
            try {
                Path p = new Path(FileUtils.getURI(path));
                FileSystem fs = p.getFileSystem(conf);
                FileStatus fileStatus = fs.getFileStatus(p);
                if (fileStatus.isDirectory()) {
                    FileStatus[] files;
                    for (FileStatus file : files = fs.listStatus(p, (PathFilter)new GlobFilter("*.jar"))) {
                        result.add(file.getPath().toUri().toString());
                    }
                    continue;
                }
                result.add(p.toUri().toString());
            }
            catch (FileNotFoundException fnfe) {
                LOG.error("The jar file path {} does not exist", (Object)path);
            }
            catch (IOException | URISyntaxException e) {
                LOG.error("Invalid file path {}", (Object)path, (Object)e);
            }
        }
        return result;
    }

    public static void readFully(InputStream stream, int length, ByteBuffer bb) throws IOException {
        byte[] b = null;
        int offset = 0;
        if (bb.hasArray()) {
            b = bb.array();
            offset = bb.arrayOffset() + bb.position();
        } else {
            b = new byte[bb.remaining()];
        }
        int fullLen = length;
        while (length > 0) {
            int result = stream.read(b, offset, length);
            if (result < 0) {
                throw new EOFException("Reading " + fullLen + " bytes");
            }
            offset += result;
            length -= result;
        }
        if (!bb.hasArray()) {
            bb.put(b);
        } else {
            bb.position(bb.position() + fullLen);
        }
    }

    public static int getSleepTime(int repeatNum) {
        return 100 * (int)Math.pow(2.0, repeatNum);
    }

    public static void deleteIfExists(FileSystem fs, Path path) {
        try {
            fs.delete(path, true);
        }
        catch (IOException e) {
            LOG.debug("Unable to delete {}", (Object)path, (Object)e);
        }
    }

    public static RemoteIterator<FileStatus> listStatusIterator(FileSystem fs, Path path, PathFilter filter) throws IOException {
        return RemoteIterators.filteringRemoteIterator(fs.listStatusIterator(path), status -> filter.accept(status.getPath()));
    }

    public static RemoteIterator<LocatedFileStatus> listFiles(FileSystem fs, Path path, boolean recursive, PathFilter filter) throws IOException {
        return RemoteIterators.filteringRemoteIterator(fs.listFiles(path, recursive), status -> filter.accept(status.getPath()));
    }

    public static Path resolveSymlinks(Path path, Configuration conf) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Cannot resolve symlink for a null Path");
        }
        URI uri = path.toUri();
        String scheme = uri.getScheme();
        if (scheme != null && !"file".equalsIgnoreCase(scheme)) {
            LOG.debug("scheme '{}' is not supported for resolving symlinks", (Object)scheme);
            return path;
        }
        if (scheme == null) {
            try {
                uri = new URI("file", uri.getAuthority(), uri.toString(), null, null);
            }
            catch (URISyntaxException e) {
                LOG.debug("URISyntaxException while creating uri from path without scheme {}", (Object)path, (Object)e);
                return path;
            }
        }
        try {
            java.nio.file.Path srcPath = Paths.get(uri);
            URI targetUri = srcPath.toRealPath(new LinkOption[0]).toUri();
            return new Path(scheme, targetUri.getAuthority(), Path.getPathWithoutSchemeAndAuthority(new Path(targetUri)).toString());
        }
        catch (Exception e) {
            LOG.debug("Exception while calling toRealPath of {}", (Object)path, (Object)e);
            return path;
        }
    }

    public static boolean isEqualFileSystemAndSameOzoneBucket(FileSystem srcFs, FileSystem destFs, Path src, Path dest) {
        if (!FileUtils.equalsFileSystem(srcFs, destFs)) {
            return false;
        }
        if (srcFs.getScheme().equalsIgnoreCase("ofs") || srcFs.getScheme().equalsIgnoreCase("o3fs")) {
            return FileUtils.isSameOzoneBucket(src, dest);
        }
        return true;
    }

    public static boolean isSameOzoneBucket(Path src, Path dst) {
        String[] src1 = FileUtils.getVolumeAndBucket(src);
        String[] dst1 = FileUtils.getVolumeAndBucket(dst);
        return (src1[0] == null && dst1[0] == null || src1[0] != null && src1[0].equalsIgnoreCase(dst1[0])) && (src1[1] == null && dst1[1] == null || src1[1] != null && src1[1].equalsIgnoreCase(dst1[1]));
    }

    private static String[] getVolumeAndBucket(Path path) {
        URI uri = path.toUri();
        String pathStr = uri.getPath();
        StringTokenizer token = new StringTokenizer(pathStr, "/");
        int numToken = token.countTokens();
        if (numToken >= 2) {
            return new String[]{token.nextToken(), token.nextToken()};
        }
        if (numToken == 1) {
            return new String[]{token.nextToken(), null};
        }
        return new String[]{null, null};
    }

    static {
        char[] clist;
        LOG = LoggerFactory.getLogger(FileUtils.class.getName());
        random = new Random();
        HIDDEN_FILES_PATH_FILTER = new PathFilter(){

            @Override
            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        };
        STAGING_DIR_PATH_FILTER = new PathFilter(){

            @Override
            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith(".");
            }
        };
        charToEscape = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            charToEscape.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            charToEscape.set(c);
        }
        HEX_UPPER_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    public static class AdaptingIterator<T>
    implements Iterator<T> {
        private final RemoteIterator<T> iterator;

        @Override
        public boolean hasNext() {
            try {
                return this.iterator.hasNext();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public T next() {
            try {
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                throw new NoSuchElementException();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public AdaptingIterator(RemoteIterator<T> iterator) {
            this.iterator = iterator;
        }
    }
}

