/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.service;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableRunnable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidHouseKeeperService
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(AcidHouseKeeperService.class);
    private Configuration conf;
    protected TxnStore txnHandler;
    protected String serviceName = this.getClass().getSimpleName();
    protected Map<FailableRunnable<MetaException>, String> tasks;

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
        this.initTasks();
    }

    protected void initTasks() {
        this.tasks = ImmutableMap.builder().put(this.txnHandler::performTimeOuts, (Object)"Cleaning timed out txns and locks").put(this.txnHandler::performWriteSetGC, (Object)"Cleaning obsolete write set entries").put(this.txnHandler::cleanTxnToWriteIdTable, (Object)"Cleaning obsolete TXN_TO_WRITE_ID entries").build();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ACID_HOUSEKEEPER_SERVICE_INTERVAL, (TimeUnit)unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TxnStore.MutexAPI.LockHandle handle = null;
        try {
            handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.HouseKeeper.name());
            LOG.info("Starting to run {}", (Object)this.serviceName);
            long start = System.currentTimeMillis();
            this.cleanTheHouse();
            LOG.debug("Total time {} took: {} seconds.", (Object)this.serviceName, (Object)this.elapsedSince(start));
        }
        catch (Exception e) {
            LOG.error("Unexpected exception in thread: {}, message: {}", new Object[]{Thread.currentThread().getName(), e.getMessage(), e});
        }
        finally {
            if (handle != null) {
                handle.releaseLocks();
            }
        }
    }

    private void cleanTheHouse() {
        this.tasks.forEach(this::performTask);
    }

    private void performTask(FailableRunnable<MetaException> task, String description) {
        long start = System.currentTimeMillis();
        Failable.run(task);
        LOG.debug("{} took {} seconds.", (Object)description, (Object)this.elapsedSince(start));
    }

    private long elapsedSince(long start) {
        return (System.currentTimeMillis() - start) / 1000L;
    }
}

