/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class MinUncommittedTxnIdHandler
implements QueryHandler<Long> {
    private static String minHistoryLevelSql = "SELECT MIN(\"RES\".\"ID\") AS \"ID\" FROM ( SELECT MAX(\"TXN_ID\") + 1 AS \"ID\" FROM \"TXNS\"   UNION SELECT MIN(\"TXN_ID\") AS \"ID\" FROM \"TXNS\" WHERE \"TXN_STATE\" = :abortedState) \"RES\"";
    private static String noMinHistoryLevelSql = "SELECT MIN(\"RES\".\"ID\") AS \"ID\" FROM ( SELECT MAX(\"TXN_ID\") + 1 AS \"ID\" FROM \"TXNS\"   UNION SELECT MIN(\"WS_TXNID\") AS \"ID\" FROM \"WRITE_SET\"   UNION SELECT MIN(\"TXN_ID\") AS \"ID\" FROM \"TXNS\" WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.ABORTED) + "   OR \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN) + " ) \"RES\"";
    private final boolean useMinHistoryLevel;

    public MinUncommittedTxnIdHandler(boolean useMinHistoryLevel) {
        this.useMinHistoryLevel = useMinHistoryLevel;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return this.useMinHistoryLevel ? minHistoryLevelSql : noMinHistoryLevelSql;
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("abortedState", (Object)TxnStatus.ABORTED.getSqlConst(), 1);
        if (!this.useMinHistoryLevel) {
            params.addValue("openState", (Object)TxnStatus.OPEN.getSqlConst(), 1);
        }
        return params;
    }

    public Long extractData(ResultSet rs) throws SQLException, DataAccessException {
        if (rs.next()) {
            return rs.getLong(1);
        }
        return null;
    }
}

