/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.AbortTxnsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.CompactFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.OpenTxnsFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ReplTableWriteIdStateFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplTableWriteIdStateFunction.class);
    private final ReplTblWriteIdStateRequest rqst;
    private final TxnStore.MutexAPI mutexAPI;
    private final List<TransactionalMetaStoreEventListener> transactionalListeners;

    public ReplTableWriteIdStateFunction(ReplTblWriteIdStateRequest rqst, TxnStore.MutexAPI mutexAPI, List<TransactionalMetaStoreEventListener> transactionalListeners) {
        this.rqst = rqst;
        this.mutexAPI = mutexAPI;
        this.transactionalListeners = transactionalListeners;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        long openTxnTimeOutMillis = MetastoreConf.getTimeVar((Configuration)jdbcResource.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_OPENTXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        String dbName = this.rqst.getDbName().toLowerCase();
        String tblName = this.rqst.getTableName().toLowerCase();
        ValidReaderWriteIdList validWriteIdList = new ValidReaderWriteIdList(this.rqst.getValidWriteIdlist());
        NamedParameterJdbcTemplate npjdbcTemplate = jdbcResource.getJdbcTemplate();
        boolean found = Boolean.TRUE.equals(npjdbcTemplate.query("SELECT \"NWI_NEXT\" FROM \"NEXT_WRITE_ID\" WHERE \"NWI_DATABASE\" = :dbName AND \"NWI_TABLE\" = :tableName", (SqlParameterSource)new MapSqlParameterSource().addValue("dbName", (Object)dbName).addValue("tableName", (Object)tblName), ResultSet::next));
        if (found) {
            LOG.info("Idempotent flow: WriteId state <{}> is already applied for the table: {}.{}", new Object[]{validWriteIdList, dbName, tblName});
            return null;
        }
        List<Long> abortedWriteIds = this.getAbortedWriteIds((ValidWriteIdList)validWriteIdList);
        int numAbortedWrites = abortedWriteIds.size();
        if (numAbortedWrites > 0) {
            Object txnIds = new OpenTxnsFunction(new OpenTxnRequest(numAbortedWrites, this.rqst.getUser(), this.rqst.getHostName()), openTxnTimeOutMillis, this.transactionalListeners).execute(jdbcResource);
            assert (numAbortedWrites == txnIds.size());
            ArrayList<Object[]> params = new ArrayList<Object[]>(txnIds.size());
            for (int i = 0; i < txnIds.size(); ++i) {
                params.add(new Object[]{txnIds.get(i), dbName, tblName, abortedWriteIds.get(i)});
                LOG.info("Allocated writeID: {} for txnId: {}", (Object)abortedWriteIds.get(i), txnIds.get(i));
            }
            int maxBatchSize = MetastoreConf.getIntVar((Configuration)jdbcResource.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.JDBC_MAX_BATCH_SIZE);
            jdbcResource.getJdbcTemplate().getJdbcTemplate().batchUpdate("INSERT INTO \"TXN_TO_WRITE_ID\" (\"T2W_TXNID\", \"T2W_DATABASE\", \"T2W_TABLE\", \"T2W_WRITEID\") VALUES (?, ?, ?, ?)", params, maxBatchSize, (ps, statementParams) -> {
                ps.setLong(1, (Long)statementParams[0]);
                ps.setString(2, statementParams[1].toString());
                ps.setString(3, statementParams[2].toString());
                ps.setLong(4, (Long)statementParams[3]);
            });
            int numAborts = new AbortTxnsFunction((List<Long>)txnIds, false, false, false, TxnErrorMsg.ABORT_REPL_WRITEID_TXN).execute(jdbcResource);
            assert (numAborts == numAbortedWrites);
        }
        long nextWriteId = validWriteIdList.getHighWatermark() + 1L;
        npjdbcTemplate.update("INSERT INTO \"NEXT_WRITE_ID\" (\"NWI_DATABASE\", \"NWI_TABLE\", \"NWI_NEXT\") VALUES (:dbName, :tableName, :nextWriteId)", (SqlParameterSource)new MapSqlParameterSource().addValue("dbName", (Object)dbName).addValue("tableName", (Object)tblName).addValue("nextWriteId", (Object)nextWriteId));
        LOG.info("WriteId state <{}> is applied for the table: {}.{}", new Object[]{validWriteIdList, dbName, tblName});
        if (numAbortedWrites > 0) {
            CompactionRequest compactRqst = new CompactionRequest(this.rqst.getDbName(), this.rqst.getTableName(), CompactionType.MAJOR);
            if (this.rqst.isSetPartNames()) {
                for (String partName : this.rqst.getPartNames()) {
                    compactRqst.setPartitionname(partName);
                    new CompactFunction(compactRqst, openTxnTimeOutMillis, this.mutexAPI).execute(jdbcResource);
                }
            } else {
                new CompactFunction(compactRqst, openTxnTimeOutMillis, this.mutexAPI).execute(jdbcResource);
            }
        }
        return null;
    }

    private List<Long> getAbortedWriteIds(ValidWriteIdList validWriteIdList) {
        return Arrays.stream(validWriteIdList.getInvalidWriteIds()).filter(arg_0 -> ((ValidWriteIdList)validWriteIdList).isWriteIdAborted(arg_0)).boxed().collect(Collectors.toList());
    }
}

