/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.sql.ResultSet;
import java.time.Instant;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class LockMaterializationRebuildFunction
implements TransactionalFunction<LockResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(LockMaterializationRebuildFunction.class);
    private final String dbName;
    private final String tableName;
    private final long txnId;
    private final TxnStore.MutexAPI mutexAPI;

    public LockMaterializationRebuildFunction(String dbName, String tableName, long txnId, TxnStore.MutexAPI mutexAPI) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.txnId = txnId;
        this.mutexAPI = mutexAPI;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LockResponse execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquiring lock for materialization rebuild with {} for {}", (Object)JavaUtils.txnIdToString((long)this.txnId), (Object)TableName.getDbTable((String)this.dbName, (String)this.tableName));
        }
        try (TxnStore.MutexAPI.LockHandle ignored = this.mutexAPI.acquireLock(TxnStore.MUTEX_KEY.MaterializationRebuild.name());){
            boolean found;
            MapSqlParameterSource params = new MapSqlParameterSource().addValue("dbName", (Object)this.dbName).addValue("tableName", (Object)this.tableName);
            String selectQ = "SELECT \"MRL_TXN_ID\" FROM \"MATERIALIZATION_REBUILD_LOCKS\" WHERE \"MRL_DB_NAME\" = :dbName AND \"MRL_TBL_NAME\" = :tableName";
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query {}", (Object)selectQ);
            }
            if (found = Boolean.TRUE.equals(jdbcResource.getJdbcTemplate().query(selectQ, (SqlParameterSource)params, ResultSet::next))) {
                LOG.info("Ignoring request to rebuild {}/{} since it is already being rebuilt", (Object)this.dbName, (Object)this.tableName);
                LockResponse lockResponse = new LockResponse(this.txnId, LockState.NOT_ACQUIRED);
                return lockResponse;
            }
            String insertQ = "INSERT INTO \"MATERIALIZATION_REBUILD_LOCKS\" (\"MRL_TXN_ID\", \"MRL_DB_NAME\", \"MRL_TBL_NAME\", \"MRL_LAST_HEARTBEAT\") VALUES (:txnId, :dbName, :tableName, " + Instant.now().toEpochMilli() + ")";
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute update {}", (Object)insertQ);
            }
            jdbcResource.getJdbcTemplate().update(insertQ, (SqlParameterSource)params.addValue("txnId", (Object)this.txnId));
            LockResponse lockResponse = new LockResponse(this.txnId, LockState.ACQUIRED);
            return lockResponse;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

