/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.GetValidWriteIdsForTableFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetOpenTxnsListHandler;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetValidWriteIdsFunction
implements TransactionalFunction<GetValidWriteIdsResponse> {
    private final GetValidWriteIdsRequest rqst;
    private final long openTxnTimeOutMillis;

    public GetValidWriteIdsFunction(GetValidWriteIdsRequest rqst, long openTxnTimeOutMillis) {
        this.rqst = rqst;
        this.openTxnTimeOutMillis = openTxnTimeOutMillis;
    }

    @Override
    public GetValidWriteIdsResponse execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        ValidReadTxnList validTxnList;
        if (this.rqst.isSetValidTxnList()) {
            assert (!this.rqst.isSetWriteId());
            validTxnList = new ValidReadTxnList(this.rqst.getValidTxnList());
        } else {
            validTxnList = this.rqst.isSetWriteId() ? TxnCommonUtils.createValidReadTxnList((GetOpenTxnsResponse)this.getOpenTxns(jdbcResource), (long)this.getTxnId(jdbcResource, (String)this.rqst.getFullTableNames().get(0), this.rqst.getWriteId())) : TxnCommonUtils.createValidReadTxnList((GetOpenTxnsResponse)this.getOpenTxns(jdbcResource), (long)0L);
        }
        ArrayList<TableValidWriteIds> tblValidWriteIdsList = new ArrayList<TableValidWriteIds>();
        for (String fullTableName : this.rqst.getFullTableNames()) {
            tblValidWriteIdsList.add(new GetValidWriteIdsForTableFunction((ValidTxnList)validTxnList, fullTableName).execute(jdbcResource));
        }
        return new GetValidWriteIdsResponse(tblValidWriteIdsList);
    }

    private long getTxnId(MultiDataSourceJdbcResource jdbcResource, String fullTableName, Long writeId) throws MetaException {
        String[] names = TxnUtils.getDbTableName(fullTableName);
        assert (names.length == 2);
        Long txnId = (Long)jdbcResource.getJdbcTemplate().query("SELECT \"T2W_TXNID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = :db AND \"T2W_TABLE\" = :table AND \"T2W_WRITEID\" = :writeId", (SqlParameterSource)new MapSqlParameterSource().addValue("db", (Object)names[0]).addValue("table", (Object)names[1]).addValue("writeId", (Object)writeId), rs -> {
            if (rs.next()) {
                long id = rs.getLong(1);
                return rs.wasNull() ? null : Long.valueOf(id);
            }
            return null;
        });
        if (txnId == null) {
            throw new MetaException("invalid write id " + writeId + " for table " + fullTableName);
        }
        return txnId;
    }

    private GetOpenTxnsResponse getOpenTxns(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        return jdbcResource.execute(new GetOpenTxnsListHandler(false, this.openTxnTimeOutMillis)).toOpenTxnsResponse(Collections.singletonList(TxnType.READ_ONLY));
    }
}

