/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.Objects;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.InsertHiveLocksCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.InsertTxnComponentsCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.EnsureValidTxnFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetOpenTxnTypeAndLockHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetWriteIdsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class EnqueueLockFunction
implements TransactionalFunction<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(EnqueueLockFunction.class);
    private static final String INCREMENT_NEXT_LOCK_ID_QUERY = "UPDATE \"NEXT_LOCK_ID\" SET \"NL_NEXT\" = %s";
    private static final String UPDATE_HIVE_LOCKS_EXT_ID_QUERY = "UPDATE \"HIVE_LOCKS\" SET \"HL_LOCK_EXT_ID\" = %s WHERE \"HL_LOCK_EXT_ID\" = %s";
    private final LockRequest lockRequest;

    public EnqueueLockFunction(LockRequest lockRequest) {
        this.lockRequest = lockRequest;
    }

    @Override
    public Long execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException, TxnAbortedException, NoSuchTxnException {
        TxnType txnType;
        long txnid = this.lockRequest.getTxnid();
        if (TxnUtils.isValidTxn(txnid) && (txnType = jdbcResource.execute(new GetOpenTxnTypeAndLockHandler(jdbcResource.getSqlGenerator(), txnid))) == null) {
            new EnsureValidTxnFunction(txnid).execute(jdbcResource);
        }
        if (txnid > 0L) {
            jdbcResource.execute(new InsertTxnComponentsCommand(this.lockRequest, jdbcResource.execute(new GetWriteIdsHandler(this.lockRequest))));
        }
        long tempExtLockId = TxnUtils.generateTemporaryId();
        jdbcResource.execute(new InsertHiveLocksCommand(this.lockRequest, tempExtLockId));
        long extLockId = this.getNextLockIdForUpdate(jdbcResource);
        this.incrementLockIdAndUpdateHiveLocks(jdbcResource.getJdbcTemplate().getJdbcTemplate(), extLockId, tempExtLockId);
        jdbcResource.getTransactionManager().getActiveTransaction().createSavepoint();
        return extLockId;
    }

    private long getNextLockIdForUpdate(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        String s = jdbcResource.getSqlGenerator().addForUpdateClause("SELECT \"NL_NEXT\" FROM \"NEXT_LOCK_ID\"");
        LOG.debug("Going to execute query <{}>", (Object)s);
        try {
            return (Long)Objects.requireNonNull(jdbcResource.getJdbcTemplate().queryForObject(s, (SqlParameterSource)new MapSqlParameterSource(), Long.class), "This never should be null, it's just to suppress warnings");
        }
        catch (EmptyResultDataAccessException e) {
            LOG.error("Failure to get next lock ID for update! SELECT query returned empty ResultSet.");
            throw new MetaException("Transaction tables not properly initialized, no record found in next_lock_id");
        }
    }

    private void incrementLockIdAndUpdateHiveLocks(JdbcTemplate jdbcTemplate, long extLockId, long tempId) {
        String incrCmd = String.format(INCREMENT_NEXT_LOCK_ID_QUERY, extLockId + 1L);
        String updateLocksCmd = String.format(UPDATE_HIVE_LOCKS_EXT_ID_QUERY, extLockId, tempId);
        LOG.debug("Going to execute updates in batch: <{}>, and <{}>", (Object)incrCmd, (Object)updateLocksCmd);
        jdbcTemplate.batchUpdate(new String[]{incrCmd, updateLocksCmd});
    }
}

