/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc;

import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionContext;
import org.apache.hadoop.hive.metastore.utils.StackThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionContextManager {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionContextManager.class);
    private final PlatformTransactionManager realTransactionManager;
    private final StackThreadLocal<TransactionContext> contexts = new StackThreadLocal();

    TransactionContextManager(PlatformTransactionManager realTransactionManager) {
        this.realTransactionManager = realTransactionManager;
    }

    public TransactionContext getNewTransaction(int propagation) {
        TransactionContext context = new TransactionContext(this.realTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(propagation)), this);
        this.contexts.set(context);
        return context;
    }

    public TransactionContext getActiveTransaction() {
        return this.contexts.get();
    }

    public void commit(TransactionContext context) {
        TransactionContext storedContext = this.contexts.get();
        if (!storedContext.equals(context)) {
            throw new IllegalStateException();
        }
        try {
            this.realTransactionManager.commit(context.getTransactionStatus());
        }
        finally {
            this.contexts.unset();
        }
    }

    public void rollback(TransactionContext context) {
        TransactionContext storedContext = this.contexts.get();
        if (!storedContext.equals(context)) {
            throw new IllegalStateException();
        }
        try {
            this.realTransactionManager.rollback(context.getTransactionStatus());
        }
        finally {
            this.contexts.unset();
        }
    }

    void rollbackIfNotCommitted(TransactionContext context) {
        if (!context.isCompleted()) {
            LOG.debug("The transaction is not committed and we are leaving the try-with-resources block. Going to rollback: {}", (Object)context);
            this.rollback(context);
        }
    }
}

