/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.entities;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CompactionState {
    INITIATED('i', "initiated"),
    WORKING('w', "working"),
    READY_FOR_CLEANING('r', "ready for cleaning"),
    FAILED('f', "failed"),
    SUCCEEDED('s', "succeeded"),
    DID_NOT_INITIATE('a', "did not initiate"),
    REFUSED('c', "refused"),
    ABORTED('x', "aborted");

    private final String message;
    private final char sqlConst;
    private static final Map<String, CompactionState> LOOKUP;

    private CompactionState(char sqlConst, String message) {
        this.sqlConst = sqlConst;
        this.message = message;
    }

    public String toString() {
        return this.name().toLowerCase().replace("_", " ");
    }

    public String getSqlConst() {
        return Character.toString(this.sqlConst);
    }

    public static CompactionState fromSqlConst(char sqlConst) {
        return CompactionState.fromSqlConst(sqlConst + "");
    }

    public static CompactionState fromSqlConst(String sqlConst) {
        return Optional.of(LOOKUP.get(sqlConst)).orElseThrow(IllegalArgumentException::new);
    }

    public static CompactionState fromString(String inputValue) {
        return CompactionState.valueOf(inputValue.toUpperCase().replace(" ", "_"));
    }

    static {
        LOOKUP = Arrays.stream(CompactionState.values()).collect(Collectors.toMap(CompactionState::getSqlConst, Function.identity()));
    }
}

