/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.entities;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OptionalCompactionInfoStruct;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.StringableMap;

public class CompactionInfo
implements Comparable<CompactionInfo> {
    public long id;
    public String dbname;
    public String tableName;
    public String partName;
    public char state;
    public CompactionType type;
    public String workerId;
    public String workerVersion;
    public String initiatorId;
    public String initiatorVersion;
    public long enqueueTime;
    public long start;
    public String runAs;
    public String properties;
    public boolean tooManyAborts = false;
    public boolean hasOldAbort = false;
    public long retryRetention = 0L;
    public long nextTxnId = 0L;
    public long minOpenWriteId = -1L;
    public long txnId = 0L;
    public long commitTime = 0L;
    public String poolName;
    public int numberOfBuckets = 0;
    public String orderByClause;
    public long minOpenWriteTxnId = 0L;
    public long highestWriteId;
    public Set<Long> writeIds;
    public boolean hasUncompactedAborts;
    public byte[] metaInfo;
    public String hadoopJobId;
    public String errorMessage;
    private String fullPartitionName = null;
    private String fullTableName = null;
    private StringableMap propertiesMap;

    public CompactionInfo(String dbname, String tableName, String partName, CompactionType type) {
        this.dbname = dbname;
        this.tableName = tableName;
        this.partName = partName;
        this.type = type;
    }

    public CompactionInfo(long id, String dbname, String tableName, String partName, char state) {
        this(dbname, tableName, partName, null);
        this.id = id;
        this.state = state;
    }

    public CompactionInfo() {
    }

    public String getProperty(String key) {
        if (this.propertiesMap == null) {
            this.propertiesMap = new StringableMap(this.properties);
        }
        return (String)this.propertiesMap.get(key);
    }

    public void setProperty(String key, String value) {
        if (this.propertiesMap == null) {
            this.propertiesMap = new StringableMap(this.properties);
        }
        this.propertiesMap.put(key, value);
        this.properties = this.propertiesMap.toString();
    }

    public String getFullPartitionName() {
        if (this.fullPartitionName == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.dbname);
            buf.append('.');
            buf.append(this.tableName);
            if (this.partName != null) {
                buf.append('.');
                buf.append(this.partName);
            }
            this.fullPartitionName = buf.toString();
        }
        return this.fullPartitionName;
    }

    public String getFullTableName() {
        if (this.fullTableName == null) {
            StringBuilder buf = new StringBuilder(this.dbname);
            buf.append('.');
            buf.append(this.tableName);
            this.fullTableName = buf.toString();
        }
        return this.fullTableName;
    }

    public boolean isMajorCompaction() {
        return CompactionType.MAJOR == this.type;
    }

    public boolean isRebalanceCompaction() {
        return CompactionType.REBALANCE == this.type;
    }

    @Override
    public int compareTo(CompactionInfo o) {
        return this.getFullPartitionName().compareTo(o.getFullPartitionName());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("dbname", (Object)this.dbname).append("tableName", (Object)this.tableName).append("partName", (Object)this.partName).append("state", this.state).append("type", (Object)this.type).append("enqueueTime", this.enqueueTime).append("commitTime", this.commitTime).append("start", this.start).append("properties", (Object)this.properties).append("runAs", (Object)this.runAs).append("tooManyAborts", this.tooManyAborts).append("hasOldAbort", this.hasOldAbort).append("highestWriteId", this.highestWriteId).append("errorMessage", (Object)this.errorMessage).append("workerId", (Object)this.workerId).append("workerVersion", (Object)this.workerVersion).append("initiatorId", (Object)this.initiatorId).append("initiatorVersion", (Object)this.initiatorVersion).append("retryRetention", this.retryRetention).append("txnId", this.txnId).append("nextTxnId", this.nextTxnId).append("poolName", (Object)this.poolName).append("numberOfBuckets", this.numberOfBuckets).append("orderByClause", (Object)this.orderByClause).append("minOpenWriteTxnId", this.minOpenWriteTxnId).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getFullPartitionName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompactionInfo)) {
            return false;
        }
        CompactionInfo info = (CompactionInfo)obj;
        return this.compareTo(info) == 0;
    }

    public static CompactionInfo loadFullFromCompactionQueue(ResultSet rs) throws SQLException {
        CompactionInfo fullCi = new CompactionInfo();
        fullCi.id = rs.getLong(1);
        fullCi.dbname = rs.getString(2);
        fullCi.tableName = rs.getString(3);
        fullCi.partName = rs.getString(4);
        fullCi.state = rs.getString(5).charAt(0);
        fullCi.type = TxnUtils.dbCompactionType2ThriftType(rs.getString(6).charAt(0));
        fullCi.properties = rs.getString(7);
        fullCi.workerId = rs.getString(8);
        fullCi.start = rs.getLong(9);
        fullCi.runAs = rs.getString(10);
        fullCi.highestWriteId = rs.getLong(11);
        fullCi.metaInfo = rs.getBytes(12);
        fullCi.hadoopJobId = rs.getString(13);
        fullCi.errorMessage = rs.getString(14);
        fullCi.enqueueTime = rs.getLong(15);
        fullCi.workerVersion = rs.getString(16);
        fullCi.initiatorId = rs.getString(17);
        fullCi.initiatorVersion = rs.getString(18);
        fullCi.retryRetention = rs.getLong(19);
        fullCi.nextTxnId = rs.getLong(20);
        fullCi.txnId = rs.getLong(21);
        fullCi.commitTime = rs.getLong(22);
        fullCi.poolName = rs.getString(23);
        fullCi.numberOfBuckets = rs.getInt(24);
        fullCi.orderByClause = rs.getString(25);
        return fullCi;
    }

    static void insertIntoCompletedCompactions(PreparedStatement pStmt, CompactionInfo ci, long endTime) throws SQLException, MetaException {
        pStmt.setLong(1, ci.id);
        pStmt.setString(2, ci.dbname);
        pStmt.setString(3, ci.tableName);
        pStmt.setString(4, ci.partName);
        pStmt.setString(5, Character.toString(ci.state));
        pStmt.setString(6, Character.toString(TxnUtils.thriftCompactionType2DbType(ci.type).charValue()));
        pStmt.setString(7, ci.properties);
        pStmt.setString(8, ci.workerId);
        pStmt.setLong(9, ci.start);
        pStmt.setLong(10, endTime);
        pStmt.setString(11, ci.runAs);
        pStmt.setLong(12, ci.highestWriteId);
        pStmt.setBytes(13, ci.metaInfo);
        pStmt.setString(14, ci.hadoopJobId);
        pStmt.setString(15, ci.errorMessage);
        pStmt.setLong(16, ci.enqueueTime);
        pStmt.setString(17, ci.workerVersion);
        pStmt.setString(18, ci.initiatorId);
        pStmt.setString(19, ci.initiatorVersion);
        pStmt.setLong(20, ci.nextTxnId);
        pStmt.setLong(21, ci.txnId);
        pStmt.setLong(22, ci.commitTime);
        pStmt.setString(23, ci.poolName);
        pStmt.setInt(24, ci.numberOfBuckets);
        pStmt.setString(25, ci.orderByClause);
    }

    public static CompactionInfo compactionStructToInfo(CompactionInfoStruct cr) {
        if (cr == null) {
            return null;
        }
        CompactionInfo ci = new CompactionInfo(cr.getDbname(), cr.getTablename(), cr.getPartitionname(), cr.getType());
        ci.id = cr.getId();
        ci.runAs = cr.getRunas();
        ci.properties = cr.getProperties();
        if (cr.isSetToomanyaborts()) {
            ci.tooManyAborts = cr.isToomanyaborts();
        }
        if (cr.isSetHasoldabort()) {
            ci.hasOldAbort = cr.isHasoldabort();
        }
        if (cr.isSetState() && cr.getState().length() != 1) {
            throw new IllegalStateException("State should only be one character but it was set to " + cr.getState());
        }
        if (cr.isSetState()) {
            ci.state = cr.getState().charAt(0);
        }
        ci.workerId = cr.getWorkerId();
        if (cr.isSetStart()) {
            ci.start = cr.getStart();
        }
        if (cr.isSetHighestWriteId()) {
            ci.highestWriteId = cr.getHighestWriteId();
        }
        if (cr.isSetErrorMessage()) {
            ci.errorMessage = cr.getErrorMessage();
        }
        if (cr.isSetEnqueueTime()) {
            ci.enqueueTime = cr.getEnqueueTime();
        }
        if (cr.isSetRetryRetention()) {
            ci.retryRetention = cr.getRetryRetention();
        }
        if (cr.isSetPoolname()) {
            ci.poolName = cr.getPoolname();
        }
        if (cr.isSetNumberOfBuckets()) {
            ci.numberOfBuckets = cr.getNumberOfBuckets();
        }
        if (cr.isSetOrderByClause()) {
            ci.orderByClause = cr.getOrderByClause();
        }
        return ci;
    }

    public static CompactionInfoStruct compactionInfoToStruct(CompactionInfo ci) {
        if (ci == null) {
            return null;
        }
        CompactionInfoStruct cr = new CompactionInfoStruct(ci.id, ci.dbname, ci.tableName, ci.type);
        cr.setPartitionname(ci.partName);
        cr.setRunas(ci.runAs);
        cr.setProperties(ci.properties);
        cr.setToomanyaborts(ci.tooManyAborts);
        cr.setHasoldabort(ci.hasOldAbort);
        cr.setStart(ci.start);
        cr.setState(Character.toString(ci.state));
        cr.setWorkerId(ci.workerId);
        cr.setHighestWriteId(ci.highestWriteId);
        cr.setErrorMessage(ci.errorMessage);
        cr.setEnqueueTime(ci.enqueueTime);
        cr.setRetryRetention(ci.retryRetention);
        cr.setPoolname(ci.poolName);
        cr.setNumberOfBuckets(ci.numberOfBuckets);
        cr.setOrderByClause(ci.orderByClause);
        return cr;
    }

    public static OptionalCompactionInfoStruct compactionInfoToOptionalStruct(CompactionInfo ci) {
        CompactionInfoStruct cis = CompactionInfo.compactionInfoToStruct(ci);
        OptionalCompactionInfoStruct ocis = new OptionalCompactionInfoStruct();
        if (cis != null) {
            ocis.setCi(cis);
        }
        return ocis;
    }

    public static CompactionInfo optionalCompactionInfoStructToInfo(OptionalCompactionInfoStruct ocis) {
        if (ocis.isSetCi()) {
            return CompactionInfo.compactionStructToInfo(ocis.getCi());
        }
        return null;
    }

    public void setWriteIds(boolean hasUncompactedAborts, Set<Long> writeIds) {
        this.hasUncompactedAborts = hasUncompactedAborts;
        this.writeIds = writeIds;
    }

    public boolean isAbortedTxnCleanup() {
        return this.type == CompactionType.ABORT_TXN_CLEANUP;
    }
}

