/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionContext;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetryHandler;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class TxnStoreMutex
implements TxnStore.MutexAPI {
    private static final Logger LOG = LoggerFactory.getLogger(TxnStoreMutex.class);
    private static final ConcurrentHashMap<String, Semaphore> derbyKey2Lock = new ConcurrentHashMap();
    private final SQLGenerator sqlGenerator;
    private final MultiDataSourceJdbcResource jdbcResource;

    public TxnStoreMutex(SQLGenerator sqlGenerator, MultiDataSourceJdbcResource jdbcResource) {
        this.sqlGenerator = sqlGenerator;
        this.jdbcResource = jdbcResource;
    }

    @Override
    public TxnStore.MutexAPI.LockHandle acquireLock(String key) throws MetaException {
        TransactionContext context = null;
        try {
            this.jdbcResource.bindDataSource("mutex");
            context = this.jdbcResource.getTransactionManager().getNewTransaction(0);
            MapSqlParameterSource paramSource = new MapSqlParameterSource().addValue("key", (Object)key);
            String sqlStmt = this.sqlGenerator.addForUpdateClause("SELECT \"MT_COMMENT\", \"MT_KEY2\" FROM \"AUX_TABLE\" WHERE \"MT_KEY1\" = :key");
            LOG.debug("About to execute SQL: {}", (Object)sqlStmt);
            Long lastUpdateTime = (Long)this.jdbcResource.getJdbcTemplate().query(sqlStmt, (SqlParameterSource)paramSource, rs -> rs.next() ? Long.valueOf(rs.getLong("MT_KEY2")) : null);
            if (lastUpdateTime == null) {
                try {
                    this.jdbcResource.getJdbcTemplate().update("INSERT INTO \"AUX_TABLE\" (\"MT_KEY1\", \"MT_KEY2\") VALUES(:key, 0)", (SqlParameterSource)paramSource);
                    context.createSavepoint();
                }
                catch (DataAccessException e) {
                    if (!this.jdbcResource.getDatabaseProduct().isDuplicateKeyError(e)) {
                        throw new RuntimeException("Unable to lock " + key + " due to: " + SqlRetryHandler.getMessage((Exception)((Object)e)), e);
                    }
                    try {
                        this.jdbcResource.getConnection().rollback();
                    }
                    catch (SQLException ex) {
                        throw new MetaException("Unable to lock " + key + " due to: " + SqlRetryHandler.getMessage(ex) + "; " + StringUtils.stringifyException((Throwable)ex));
                    }
                }
                lastUpdateTime = (Long)this.jdbcResource.getJdbcTemplate().query(sqlStmt, (SqlParameterSource)paramSource, rs -> rs.next() ? Long.valueOf(rs.getLong("MT_KEY2")) : null);
                if (lastUpdateTime == null) {
                    throw new IllegalStateException("Unable to lock " + key + ".  Expected row in AUX_TABLE is missing.");
                }
            }
            Semaphore derbySemaphore = null;
            if (this.jdbcResource.getDatabaseProduct().isDERBY()) {
                derbyKey2Lock.putIfAbsent(key, new Semaphore(1));
                derbySemaphore = derbyKey2Lock.get(key);
                derbySemaphore.acquire();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} locked by {}", (Object)key, (Object)JavaUtils.hostname());
            }
            LockHandleImpl lockHandleImpl = new LockHandleImpl(this.jdbcResource, context, key, lastUpdateTime, derbySemaphore);
            return lockHandleImpl;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            if (context != null) {
                this.jdbcResource.getTransactionManager().rollback(context);
            }
            throw new MetaException("Unable to lock " + key + " due to: " + ex.getMessage() + StringUtils.stringifyException((Throwable)ex));
        }
        catch (Throwable e) {
            if (context != null) {
                this.jdbcResource.getTransactionManager().rollback(context);
            }
            throw e;
        }
        finally {
            this.jdbcResource.unbindDataSource();
        }
    }

    @Override
    public void acquireLock(String key, TxnStore.MutexAPI.LockHandle handle) throws MetaException {
        throw new NotImplementedException("acquireLock(String, LockHandle) is not implemented");
    }

    public static final class LockHandleImpl
    implements TxnStore.MutexAPI.LockHandle {
        private static final Logger LOG = LoggerFactory.getLogger(LockHandleImpl.class);
        private static final String HOSTNAME = JavaUtils.hostname();
        private final MultiDataSourceJdbcResource jdbcResource;
        private final TransactionContext context;
        private final Semaphore derbySemaphore;
        private final String key;
        private final Long lastUpdateTime;

        public LockHandleImpl(MultiDataSourceJdbcResource jdbcResource, TransactionContext context, String key, Long lastUpdateTime, Semaphore derbySemaphore) {
            assert (derbySemaphore == null || derbySemaphore.availablePermits() == 0) : "Expected locked Semaphore";
            this.jdbcResource = jdbcResource;
            this.context = context;
            this.derbySemaphore = derbySemaphore;
            this.key = key;
            this.lastUpdateTime = lastUpdateTime == null ? -1L : lastUpdateTime;
        }

        @Override
        public void releaseLocks() {
            try {
                this.jdbcResource.bindDataSource("mutex");
                this.jdbcResource.getTransactionManager().rollback(this.context);
                if (this.derbySemaphore != null) {
                    this.derbySemaphore.release();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} unlocked by {}", (Object)this.key, (Object)HOSTNAME);
                }
            }
            finally {
                this.jdbcResource.unbindDataSource();
            }
        }

        @Override
        public Long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public void releaseLocks(Long timestamp) {
            try {
                this.jdbcResource.bindDataSource("mutex");
                try {
                    this.jdbcResource.getJdbcTemplate().update("UPDATE \"AUX_TABLE\" SET \"MT_KEY2\" = :time WHERE \"MT_KEY1\"= :key", (SqlParameterSource)new MapSqlParameterSource().addValue("time", (Object)timestamp).addValue("key", (Object)this.key));
                    this.jdbcResource.getTransactionManager().commit(this.context);
                }
                catch (DataAccessException ex) {
                    LOG.warn("Unable to update MT_KEY2 value for MT_KEY1=" + this.key, (Throwable)ex);
                }
                if (this.derbySemaphore != null) {
                    this.derbySemaphore.release();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} unlocked by {}", (Object)this.key, (Object)HOSTNAME);
                }
            }
            finally {
                this.jdbcResource.unbindDataSource();
            }
        }

        @Override
        public void close() {
            this.releaseLocks();
        }
    }
}

