/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.google.common.annotations.VisibleForTesting;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.metastore.api.AbortCompactResponse;
import org.apache.hadoop.hive.metastore.api.AbortCompactionRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MaxAllocatedTableWriteIdRequest;
import org.apache.hadoop.hive.metastore.api.MaxAllocatedTableWriteIdResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchCompactionException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.api.SeedTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.SeedTxnIdRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.api.UpdateTransactionalStatsRequest;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionMetricsData;
import org.apache.hadoop.hive.metastore.txn.entities.MetricsInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetry;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetryException;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetryHandler;
import org.springframework.transaction.annotation.Transactional;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface TxnStore
extends Configurable {
    public static final String TXN_KEY_START = "_meta";
    public static final String INITIATED_RESPONSE = "initiated";
    public static final String WORKING_RESPONSE = "working";
    public static final String CLEANING_RESPONSE = "ready for cleaning";
    public static final String FAILED_RESPONSE = "failed";
    public static final String SUCCEEDED_RESPONSE = "succeeded";
    public static final String DID_NOT_INITIATE_RESPONSE = "did not initiate";
    public static final String REFUSED_RESPONSE = "refused";
    public static final String ABORTED_RESPONSE = "aborted";
    public static final char INITIATED_STATE = 'i';
    public static final char WORKING_STATE = 'w';
    public static final char READY_FOR_CLEANING = 'r';
    public static final char FAILED_STATE = 'f';
    public static final char SUCCEEDED_STATE = 's';
    public static final char DID_NOT_INITIATE = 'a';
    public static final char REFUSED_STATE = 'c';
    public static final char ABORTED_STATE = 'x';
    public static final char MAJOR_TYPE = 'a';
    public static final char MINOR_TYPE = 'i';
    public static final char REBALANCE_TYPE = 'r';
    public static final char ABORT_TXN_CLEANUP_TYPE = 'c';
    public static final String[] COMPACTION_STATES = new String[]{"initiated", "working", "ready for cleaning", "failed", "succeeded", "did not initiate", "refused"};
    public static final int TIMED_OUT_TXN_ABORT_BATCH_SIZE = 50000;
    public static final String POOL_TX = "txnhandler";
    public static final String POOL_MUTEX = "mutex";
    public static final String POOL_COMPACTOR = "compactor";

    public SqlRetryHandler getRetryHandler();

    public MultiDataSourceJdbcResource getJdbcResourceHolder();

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.ReadOnly
    public GetOpenTxnsInfoResponse getOpenTxnsInfo() throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.ReadOnly
    public GetOpenTxnsResponse getOpenTxns() throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.ReadOnly
    public GetOpenTxnsResponse getOpenTxns(List<TxnType> var1) throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.ReadOnly
    public void countOpenTxns() throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler", noRollbackFor={SqlRetryException.class})
    @RetrySemantics.Idempotent
    public OpenTxnsResponse openTxns(OpenTxnRequest var1) throws MetaException;

    @SqlRetry(lockInternally=true)
    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    public long getTargetTxnId(String var1, long var2) throws MetaException;

    @SqlRetry(lockInternally=true)
    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    public void abortTxn(AbortTxnRequest var1) throws NoSuchTxnException, MetaException, TxnAbortedException;

    @SqlRetry(lockInternally=true)
    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    public void abortTxns(AbortTxnsRequest var1) throws NoSuchTxnException, MetaException;

    @SqlRetry(lockInternally=true)
    @Transactional(value="txnhandler", noRollbackFor={TxnAbortedException.class})
    @RetrySemantics.Idempotent(value={"No-op if already committed"})
    public void commitTxn(CommitTxnRequest var1) throws NoSuchTxnException, TxnAbortedException, MetaException;

    @SqlRetry(lockInternally=true)
    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent(value={"No-op if already replicated the writeid state"})
    public void replTableWriteIdState(ReplTblWriteIdStateRequest var1) throws MetaException;

    @Transactional(value="txnhandler")
    public void updateTransactionStatistics(UpdateTransactionalStatsRequest var1) throws MetaException;

    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    public Materialization getMaterializationInvalidationInfo(CreationMetadata var1, String var2) throws MetaException;

    @RetrySemantics.ReadOnly
    public long getTxnIdForWriteId(String var1, String var2, long var3) throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.ReadOnly
    public long getLatestTxnIdInConflict(long var1) throws MetaException;

    @SqlRetry(lockInternally=true)
    @Transactional(value="txnhandler")
    public LockResponse lockMaterializationRebuild(String var1, String var2, long var3) throws MetaException;

    @SqlRetry(lockInternally=true)
    @Transactional(value="txnhandler")
    public boolean heartbeatLockMaterializationRebuild(String var1, String var2, long var3) throws MetaException;

    @SqlRetry(lockInternally=true)
    @Transactional(value="txnhandler")
    public long cleanupMaterializationRebuildLocks(ValidTxnList var1, long var2) throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.ReadOnly
    public GetValidWriteIdsResponse getValidWriteIds(GetValidWriteIdsRequest var1) throws NoSuchTxnException, MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.SafeToRetry
    public void addWriteIdsToMinHistory(long var1, Map<String, Long> var3) throws MetaException;

    @SqlRetry(lockInternally=true, retryOnDuplicateKey=true)
    @Transactional(value="txnhandler")
    public AllocateTableWriteIdsResponse allocateTableWriteIds(AllocateTableWriteIdsRequest var1) throws NoSuchTxnException, TxnAbortedException, MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    public MaxAllocatedTableWriteIdResponse getMaxAllocatedTableWrited(MaxAllocatedTableWriteIdRequest var1) throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    public void seedWriteId(SeedTableWriteIdsRequest var1) throws MetaException;

    @SqlRetry(lockInternally=true)
    @Transactional(value="txnhandler")
    public void seedTxnId(SeedTxnIdRequest var1) throws MetaException;

    @RetrySemantics.CannotRetry
    public LockResponse lock(LockRequest var1) throws NoSuchTxnException, TxnAbortedException, MetaException;

    @Transactional(value="txnhandler")
    @RetrySemantics.SafeToRetry
    public LockResponse checkLock(CheckLockRequest var1) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException;

    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    public void unlock(UnlockRequest var1) throws NoSuchLockException, TxnOpenException, MetaException;

    @Transactional(value="txnhandler")
    @RetrySemantics.ReadOnly
    public ShowLocksResponse showLocks(ShowLocksRequest var1) throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.SafeToRetry
    public void heartbeat(HeartbeatRequest var1) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.SafeToRetry
    public HeartbeatTxnRangeResponse heartbeatTxnRange(HeartbeatTxnRangeRequest var1) throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    public CompactionResponse compact(CompactionRequest var1) throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.SafeToRetry
    public boolean submitForCleanup(CompactionRequest var1, long var2, long var4) throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.ReadOnly
    public ShowCompactResponse showCompact(ShowCompactRequest var1) throws MetaException;

    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    public AbortCompactResponse abortCompactions(AbortCompactionRequest var1) throws NoSuchCompactionException, MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.ReadOnly
    public GetLatestCommittedCompactionInfoResponse getLatestCommittedCompactionInfo(GetLatestCommittedCompactionInfoRequest var1) throws MetaException;

    @SqlRetry(lockInternally=true)
    @Transactional(value="txnhandler")
    @RetrySemantics.SafeToRetry
    public void addDynamicPartitions(AddDynamicPartitions var1) throws NoSuchTxnException, TxnAbortedException, MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    default public void cleanupRecords(HiveObjectType type, Database db, Table table, Iterator<Partition> partitionIterator) throws MetaException {
        this.cleanupRecords(type, db, table, partitionIterator, false);
    }

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    public void cleanupRecords(HiveObjectType var1, Database var2, Table var3, Iterator<Partition> var4, boolean var5) throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    public void cleanupRecords(HiveObjectType var1, Database var2, Table var3, Iterator<Partition> var4, long var5) throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    public void onRename(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws MetaException;

    @Transactional(value="txnhandler")
    @RetrySemantics.Idempotent
    public void performTimeOuts();

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.ReadOnly
    public Set<CompactionInfo> findPotentialCompactions(int var1, long var2) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.ReadOnly
    public Set<CompactionInfo> findPotentialCompactions(int var1, long var2, long var4) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.Idempotent
    public void updateCompactorState(CompactionInfo var1, long var2) throws MetaException;

    @Deprecated
    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.ReadOnly
    public CompactionInfo findNextToCompact(String var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.ReadOnly
    public CompactionInfo findNextToCompact(FindNextCompactRequest var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.SafeToRetry
    public void markCompacted(CompactionInfo var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.ReadOnly
    public List<CompactionInfo> findReadyToClean(long var1, long var3) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.ReadOnly
    public List<CompactionInfo> findReadyToCleanAborts(long var1, int var3) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.CannotRetry
    public void markCleanerStart(CompactionInfo var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.CannotRetry
    public void clearCleanerStart(CompactionInfo var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.CannotRetry
    public void markCleaned(CompactionInfo var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.CannotRetry
    public void markFailed(CompactionInfo var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    public void markRefused(CompactionInfo var1) throws MetaException;

    @SqlRetry(lockInternally=true)
    @Transactional(value="compactor")
    @RetrySemantics.CannotRetry
    public void setCleanerRetryRetentionTimeOnError(CompactionInfo var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.SafeToRetry
    public void cleanTxnToWriteIdTable() throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.SafeToRetry
    public void removeDuplicateCompletedTxnComponents() throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.SafeToRetry
    public void cleanEmptyAbortedAndCommittedTxns() throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.Idempotent
    public void revokeFromLocalWorkers(String var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.Idempotent
    public void revokeTimedoutWorkers(long var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.ReadOnly
    public List<String> findColumnsWithStats(CompactionInfo var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.SafeToRetry
    public void purgeCompactionHistory() throws MetaException;

    @Transactional(value="txnhandler")
    @RetrySemantics.SafeToRetry
    public void performWriteSetGC() throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.ReadOnly
    public boolean checkFailedCompactions(CompactionInfo var1) throws MetaException;

    @Transactional(value="txnhandler")
    @VisibleForTesting
    public int getNumLocks() throws SQLException, MetaException;

    @VisibleForTesting
    public long setTimeout(long var1);

    @VisibleForTesting
    public long getOpenTxnTimeOutMillis();

    @VisibleForTesting
    public void setOpenTxnTimeOutMillis(long var1);

    @RetrySemantics.Idempotent
    public MutexAPI getMutexAPI();

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.Idempotent
    public void setHadoopJobId(String var1, long var2) throws MetaException;

    @SqlRetry(lockInternally=true, retryOnDuplicateKey=true)
    @Transactional(value="compactor")
    @RetrySemantics.Idempotent
    public void addWriteNotificationLog(ListenerEvent var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.Idempotent
    public long findMinOpenTxnIdForCleaner() throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.ReadOnly
    public Optional<CompactionInfo> getCompactionByTxnId(long var1) throws MetaException;

    @RetrySemantics.ReadOnly
    @SqlRetry
    @Transactional(value="compactor")
    @Deprecated
    public long findMinTxnIdSeenOpen() throws MetaException;

    @SqlRetry
    @Transactional(value="txnhandler")
    @RetrySemantics.ReadOnly
    public MetricsInfo getMetricsInfo() throws MetaException;

    @RetrySemantics.ReadOnly
    @SqlRetry
    @Transactional(value="compactor")
    public CompactionMetricsData getCompactionMetricsData(String var1, String var2, String var3, CompactionMetricsData.MetricType var4) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.SafeToRetry
    public void removeCompactionMetricsData(String var1, String var2, String var3, CompactionMetricsData.MetricType var4) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.ReadOnly
    public List<CompactionMetricsData> getTopCompactionMetricsDataPerType(int var1) throws MetaException;

    @SqlRetry
    @Transactional(value="compactor")
    @RetrySemantics.Idempotent
    public boolean updateCompactionMetricsData(CompactionMetricsData var1) throws MetaException;

    public static interface MutexAPI {
        @SqlRetry(lockInternally=true)
        public LockHandle acquireLock(String var1) throws MetaException;

        public void acquireLock(String var1, LockHandle var2) throws MetaException;

        public static interface LockHandle
        extends AutoCloseable {
            public void releaseLocks();

            public Long getLastUpdateTime();

            public void releaseLocks(Long var1);
        }
    }

    public static enum MUTEX_KEY {
        Initiator,
        Cleaner,
        HouseKeeper,
        TxnCleaner,
        CompactionScheduler,
        MaterializationRebuild;

    }
}

