/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionMetricsData;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionState;
import org.apache.hadoop.hive.metastore.txn.entities.OperationType;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.InsertCompactionInfoCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.RemoveCompactionMetricsDataCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.RemoveDuplicateCompleteTxnComponentsCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.CleanTxnToWriteIdTableFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.FindPotentialCompactionsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.GenerateCompactionQueueIdFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.MarkCleanedFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.MinOpenTxnIdWaterMarkFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.NextCompactionFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.PurgeCompactionHistoryFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.TopCompactionMetricsDataPerTypeFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.UpdateCompactionMetricsDataFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.CheckFailedCompactionsHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.CompactionMetricsDataHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.FindColumnsWithStatsHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetCompactionInfoHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.OpenTxnTimeoutLowBoundaryTxnIdHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.ReadyToCleanAbortHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.ReadyToCleanHandler;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

class CompactionTxnHandler
extends TxnHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)CompactionTxnHandler.class.getName());

    @Override
    @RetrySemantics.ReadOnly
    public Set<CompactionInfo> findPotentialCompactions(int abortedThreshold, long abortedTimeThreshold) throws MetaException {
        return this.findPotentialCompactions(abortedThreshold, abortedTimeThreshold, -1L);
    }

    @Override
    @RetrySemantics.ReadOnly
    public Set<CompactionInfo> findPotentialCompactions(int abortedThreshold, long abortedTimeThreshold, long lastChecked) throws MetaException {
        return new FindPotentialCompactionsFunction(this.conf, abortedThreshold, abortedTimeThreshold, lastChecked).execute(this.jdbcResource);
    }

    @Override
    @Deprecated
    @RetrySemantics.SafeToRetry
    public CompactionInfo findNextToCompact(String workerId) throws MetaException {
        FindNextCompactRequest findNextCompactRequest = new FindNextCompactRequest();
        findNextCompactRequest.setWorkerId(workerId);
        return this.findNextToCompact(findNextCompactRequest);
    }

    @Override
    @RetrySemantics.SafeToRetry
    public CompactionInfo findNextToCompact(FindNextCompactRequest rqst) throws MetaException {
        if (rqst == null) {
            throw new MetaException("FindNextCompactRequest is null");
        }
        long poolTimeout = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_WORKER_POOL_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        return new NextCompactionFunction(rqst, this.getDbTime(), poolTimeout).execute(this.jdbcResource);
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void markCompacted(CompactionInfo info) throws MetaException {
        this.jdbcResource.execute("UPDATE \"COMPACTION_QUEUE\" SET \"CQ_STATE\" = :state, \"CQ_WORKER_ID\" = NULL WHERE \"CQ_ID\" = :id", (SqlParameterSource)new MapSqlParameterSource().addValue("state", (Object)Character.toString('r'), 1).addValue("id", (Object)info.id), ParameterizedCommand.EXACTLY_ONE_ROW);
    }

    @Override
    @RetrySemantics.ReadOnly
    public List<CompactionInfo> findReadyToClean(long minOpenTxnWaterMark, long retentionTime) throws MetaException {
        return this.jdbcResource.execute(new ReadyToCleanHandler(this.conf, minOpenTxnWaterMark, retentionTime));
    }

    @Override
    @RetrySemantics.ReadOnly
    public List<CompactionInfo> findReadyToCleanAborts(long abortedTimeThreshold, int abortedThreshold) throws MetaException {
        return this.jdbcResource.execute(new ReadyToCleanAbortHandler(this.conf, abortedTimeThreshold, abortedThreshold));
    }

    @Override
    @RetrySemantics.ReadOnly
    public void markCleanerStart(CompactionInfo info) throws MetaException {
        LOG.debug("Running markCleanerStart with CompactionInfo: {}", (Object)info);
        this.setCleanerStart(info, this.getDbTime().getTime());
    }

    @Override
    @RetrySemantics.ReadOnly
    public void clearCleanerStart(CompactionInfo info) throws MetaException {
        LOG.debug("Running clearCleanerStart with CompactionInfo: {}", (Object)info);
        this.setCleanerStart(info, -1L);
    }

    private void setCleanerStart(CompactionInfo info, Long timestamp) throws MetaException {
        this.jdbcResource.execute(" UPDATE \"COMPACTION_QUEUE\"  SET \"CQ_CLEANER_START\" = :timeStamp WHERE \"CQ_ID\" = :id AND \"CQ_STATE\"= :state", (SqlParameterSource)new MapSqlParameterSource().addValue("timeStamp", (Object)timestamp).addValue("state", (Object)Character.toString('r'), 1).addValue("id", (Object)info.id), ParameterizedCommand.EXACTLY_ONE_ROW);
    }

    @Override
    @RetrySemantics.CannotRetry
    public void markCleaned(CompactionInfo info) throws MetaException {
        LOG.debug("Running markCleaned with CompactionInfo: {}", (Object)info);
        new MarkCleanedFunction(info).execute(this.jdbcResource);
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void cleanTxnToWriteIdTable() throws MetaException {
        new CleanTxnToWriteIdTableFunction(this.findMinTxnIdSeenOpen()).execute(this.jdbcResource);
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void removeDuplicateCompletedTxnComponents() throws MetaException {
        this.jdbcResource.execute(RemoveDuplicateCompleteTxnComponentsCommand.INSTANCE);
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void cleanEmptyAbortedAndCommittedTxns() throws MetaException {
        LOG.info("Start to clean empty aborted or committed TXNS");
        try {
            long lowWaterMark = this.jdbcResource.execute(new OpenTxnTimeoutLowBoundaryTxnIdHandler(openTxnTimeOutMillis));
            this.jdbcResource.execute("DELETE FROM \"TXNS\" WHERE \"TXN_ID\" NOT IN (SELECT \"TC_TXNID\" FROM \"TXN_COMPONENTS\") AND (\"TXN_STATE\" = :abortedState OR \"TXN_STATE\" = :committedState) AND \"TXN_ID\" < :txnId", (SqlParameterSource)new MapSqlParameterSource().addValue("txnId", (Object)lowWaterMark).addValue("abortedState", (Object)TxnStatus.ABORTED.getSqlConst(), 1).addValue("committedState", (Object)TxnStatus.COMMITTED.getSqlConst(), 1), null);
        }
        catch (DataAccessException e) {
            throw new MetaException("Unable to get the txn id: " + SqlRetryHandler.getMessage((Exception)((Object)e)));
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void revokeFromLocalWorkers(String hostname) throws MetaException {
        this.jdbcResource.execute("UPDATE \"COMPACTION_QUEUE\" SET \"CQ_WORKER_ID\" = NULL, \"CQ_START\" = NULL, \"CQ_STATE\" = :initiatedState WHERE \"CQ_STATE\" = :workingState AND \"CQ_WORKER_ID\" LIKE :hostname", (SqlParameterSource)new MapSqlParameterSource().addValue("initiatedState", (Object)Character.toString('i'), 1).addValue("workingState", (Object)Character.toString('w'), 1).addValue("hostname", (Object)(hostname + "%")), null);
    }

    @Override
    @RetrySemantics.Idempotent
    public void revokeTimedoutWorkers(long timeout) throws MetaException {
        long latestValidStart = this.getDbTime().getTime() - timeout;
        this.jdbcResource.execute("UPDATE \"COMPACTION_QUEUE\" SET \"CQ_WORKER_ID\" = NULL, \"CQ_START\" = NULL, \"CQ_STATE\" = :initiatedState WHERE \"CQ_STATE\" = :workingState AND \"CQ_START\" < :timeout", (SqlParameterSource)new MapSqlParameterSource().addValue("initiatedState", (Object)Character.toString('i'), 1).addValue("workingState", (Object)Character.toString('w'), 1).addValue("timeout", (Object)latestValidStart), null);
    }

    @Override
    @RetrySemantics.ReadOnly
    public List<String> findColumnsWithStats(CompactionInfo ci) throws MetaException {
        return this.jdbcResource.execute(new FindColumnsWithStatsHandler(ci));
    }

    @Override
    public void updateCompactorState(CompactionInfo ci, long compactionTxnId) throws MetaException {
        this.jdbcResource.execute("UPDATE \"COMPACTION_QUEUE\" SET \"CQ_HIGHEST_WRITE_ID\" = :highestWriteId, \"CQ_RUN_AS\" = :runAs, \"CQ_TXN_ID\" = :txnId WHERE \"CQ_ID\" = :id", (SqlParameterSource)new MapSqlParameterSource().addValue("highestWriteId", (Object)ci.highestWriteId).addValue("runAs", (Object)ci.runAs).addValue("txnId", (Object)compactionTxnId).addValue("id", (Object)ci.id), ParameterizedCommand.EXACTLY_ONE_ROW);
        MapSqlParameterSource parameterSource = new MapSqlParameterSource().addValue("txnId", (Object)compactionTxnId).addValue("dbName", (Object)ci.dbname).addValue("tableName", (Object)ci.tableName).addValue("partName", (Object)ci.partName, 12).addValue("highestWriteId", (Object)ci.highestWriteId).addValue("operationType", (Object)OperationType.COMPACT.getSqlConst());
        if (ci.partName != null) {
            parameterSource.addValue("partName", (Object)ci.partName);
        }
        this.jdbcResource.execute("INSERT INTO \"TXN_COMPONENTS\"(\"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_WRITEID\", \"TC_OPERATION_TYPE\") VALUES(:txnId, :dbName, :tableName, :partName, :highestWriteId, :operationType)", (SqlParameterSource)parameterSource, ParameterizedCommand.EXACTLY_ONE_ROW);
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void purgeCompactionHistory() throws MetaException {
        new PurgeCompactionHistoryFunction().execute(this.jdbcResource);
    }

    @Override
    @RetrySemantics.ReadOnly
    public boolean checkFailedCompactions(CompactionInfo ci) throws MetaException {
        return this.jdbcResource.execute(new CheckFailedCompactionsHandler(this.conf, ci));
    }

    private void updateStatus(CompactionInfo ci) throws MetaException {
        String strState = CompactionState.fromSqlConst(ci.state).toString();
        LOG.debug("Marking as {}: CompactionInfo: {}", (Object)strState, (Object)ci);
        CompactionInfo ciActual = this.jdbcResource.execute(new GetCompactionInfoHandler(ci.id, false));
        long endTime = this.getDbTime().getTime();
        if (ciActual != null) {
            ciActual.errorMessage = ci.errorMessage;
            ciActual.state = ci.state;
            this.jdbcResource.execute("DELETE FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = :id", (SqlParameterSource)new MapSqlParameterSource("id", (Object)ci.id), null);
        } else {
            if (ci.id > 0L) {
                throw new IllegalStateException("No record with CQ_ID=" + ci.id + " found in COMPACTION_QUEUE");
            }
            ciActual = ci;
        }
        if (ciActual.id == 0L) {
            ciActual.id = new GenerateCompactionQueueIdFunction().execute(this.jdbcResource);
            if (ciActual.type == null) {
                ciActual.type = CompactionType.MINOR;
            }
            ciActual.start = endTime;
            LOG.debug("The failure occurred before we even made an entry in COMPACTION_QUEUE. Generated ID so that we can make an entry in COMPLETED_COMPACTIONS. New Id: {}", (Object)ciActual.id);
        }
        this.jdbcResource.execute(new InsertCompactionInfoCommand(ciActual, endTime));
    }

    @Override
    @RetrySemantics.CannotRetry
    public void markFailed(CompactionInfo ci) throws MetaException {
        ci.state = (char)(ci.id == 0L ? 97 : 102);
        this.updateStatus(ci);
    }

    @Override
    @RetrySemantics.CannotRetry
    public void markRefused(CompactionInfo info) throws MetaException {
        info.state = (char)99;
        this.updateStatus(info);
    }

    @Override
    @RetrySemantics.CannotRetry
    public void setCleanerRetryRetentionTimeOnError(CompactionInfo info) throws MetaException {
        block16: {
            if (info.isAbortedTxnCleanup() && info.id == 0L) {
                try (TxnStore.MutexAPI.LockHandle ignored = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.CompactionScheduler.name());){
                    long id = new GenerateCompactionQueueIdFunction().execute(this.jdbcResource);
                    int updCnt = this.jdbcResource.execute("INSERT INTO \"COMPACTION_QUEUE\" (\"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\",  \"CQ_TYPE\", \"CQ_STATE\", \"CQ_RETRY_RETENTION\", \"CQ_ERROR_MESSAGE\", \"CQ_COMMIT_TIME\")  VALUES (:id, :db, :table, :partition, :type, :state, :retention, :msg, " + TxnUtils.getEpochFn(dbProduct) + ")", (SqlParameterSource)new MapSqlParameterSource().addValue("id", (Object)id).addValue("db", (Object)info.dbname).addValue("table", (Object)info.tableName).addValue("partition", (Object)info.partName, 12).addValue("type", (Object)Character.toString(TxnUtils.thriftCompactionType2DbType(info.type).charValue())).addValue("state", (Object)Character.toString(info.state)).addValue("retention", (Object)info.retryRetention).addValue("msg", (Object)info.errorMessage), null);
                    if (updCnt == 0) {
                        LOG.error("Unable to update/insert compaction queue record: {}. updCnt={}", (Object)info, (Object)updCnt);
                        throw new MetaException("Unable to insert abort retry entry into COMPACTION QUEUE:  CQ_DATABASE=" + info.dbname + ", CQ_TABLE=" + info.tableName + ", CQ_PARTITION" + info.partName);
                    }
                    break block16;
                }
                catch (Exception e) {
                    throw new MetaException("Failed to set retry retention time for compaction item: " + info + " Error: " + e);
                }
            }
            this.jdbcResource.execute("UPDATE \"COMPACTION_QUEUE\" SET \"CQ_RETRY_RETENTION\" = :retention, \"CQ_ERROR_MESSAGE\"= :msg WHERE \"CQ_ID\" = :id", (SqlParameterSource)new MapSqlParameterSource().addValue("retention", (Object)info.retryRetention).addValue("msg", (Object)info.errorMessage).addValue("id", (Object)info.id), ParameterizedCommand.EXACTLY_ONE_ROW);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void setHadoopJobId(String hadoopJobId, long id) throws MetaException {
        this.jdbcResource.execute("UPDATE \"COMPACTION_QUEUE\" SET \"CQ_HADOOP_JOB_ID\" = :hadoopJobId WHERE \"CQ_ID\" = :id", (SqlParameterSource)new MapSqlParameterSource().addValue("id", (Object)id).addValue("hadoopJobId", (Object)hadoopJobId), ParameterizedCommand.EXACTLY_ONE_ROW);
    }

    @Override
    @RetrySemantics.Idempotent
    public long findMinOpenTxnIdForCleaner() throws MetaException {
        if (ConfVars.useMinHistoryWriteId()) {
            return Long.MAX_VALUE;
        }
        return new MinOpenTxnIdWaterMarkFunction(openTxnTimeOutMillis).execute(this.jdbcResource);
    }

    @Override
    @RetrySemantics.Idempotent
    @Deprecated
    public long findMinTxnIdSeenOpen() {
        if (!ConfVars.useMinHistoryLevel() || ConfVars.useMinHistoryWriteId()) {
            return Long.MAX_VALUE;
        }
        try {
            Long minId = (Long)this.jdbcResource.getJdbcTemplate().queryForObject("SELECT MIN(\"MHL_MIN_OPEN_TXNID\") FROM \"MIN_HISTORY_LEVEL\"", (SqlParameterSource)new MapSqlParameterSource(), Long.class);
            return minId == null ? Long.MAX_VALUE : minId;
        }
        catch (DataAccessException e) {
            if (dbProduct.isTableNotExistsError(e)) {
                ConfVars.setUseMinHistoryLevel(false);
                return Long.MAX_VALUE;
            }
            LOG.error("Unable to execute findMinTxnIdSeenOpen", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Optional<CompactionInfo> getCompactionByTxnId(long txnId) throws MetaException {
        return Optional.ofNullable(this.jdbcResource.execute(new GetCompactionInfoHandler(txnId, true)));
    }

    @Override
    public boolean updateCompactionMetricsData(CompactionMetricsData data) throws MetaException {
        return new UpdateCompactionMetricsDataFunction(data).execute(this.jdbcResource);
    }

    @Override
    public List<CompactionMetricsData> getTopCompactionMetricsDataPerType(int limit) throws MetaException {
        return new TopCompactionMetricsDataPerTypeFunction(limit).execute(this.jdbcResource);
    }

    @Override
    public CompactionMetricsData getCompactionMetricsData(String dbName, String tblName, String partitionName, CompactionMetricsData.MetricType type) throws MetaException {
        return this.jdbcResource.execute(new CompactionMetricsDataHandler(dbName, tblName, partitionName, type));
    }

    @Override
    public void removeCompactionMetricsData(String dbName, String tblName, String partitionName, CompactionMetricsData.MetricType type) throws MetaException {
        this.jdbcResource.execute(new RemoveCompactionMetricsDataCommand(dbName, tblName, partitionName, type));
    }
}

