/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaToolTaskMoveTable
extends SchemaToolTask {
    private static final Logger LOG = LoggerFactory.getLogger((String)SchemaToolTaskMoveTable.class.getName());
    private String fromCat;
    private String toCat;
    private String fromDb;
    private String toDb;
    private String tableName;
    private static final String UPDATE_TABLE_ID_STMT = "update <q>TBLS<q>    set <q>DB_ID<q> = %d  where <q>DB_ID<q> = %d    and <q>TBL_NAME<q> = '%s'";
    private static final String DB_ID_QUERY = "select <q>DB_ID<q>   from <q>DBS<q>  where <q>NAME<q> = '%s'    and <q>CTLG_NAME<q> = '%s'";
    private static final String UPDATE_DB_NAME_STMT = "update <q>%s<q>    set <q>CAT_NAME<q> = '%s',        <q>DB_NAME<q> = '%s'  where <q>CAT_NAME<q> = '%s'    and <q>DB_NAME<q> = '%s'    and <q>%s<q> = '%s'";

    SchemaToolTaskMoveTable() {
    }

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cl) {
        this.fromCat = StringUtils.normalizeIdentifier((String)cl.getOptionValue("fromCatalog"));
        this.toCat = StringUtils.normalizeIdentifier((String)cl.getOptionValue("toCatalog"));
        this.fromDb = StringUtils.normalizeIdentifier((String)cl.getOptionValue("fromDatabase"));
        this.toDb = StringUtils.normalizeIdentifier((String)cl.getOptionValue("toDatabase"));
        this.tableName = StringUtils.normalizeIdentifier((String)cl.getOptionValue("moveTable"));
    }

    @Override
    void execute() throws HiveMetaException {
        Connection conn = this.schemaTool.getConnectionToMetastore(true);
        boolean success = false;
        try {
            conn.setAutoCommit(false);
            try (Statement stmt = conn.createStatement();){
                this.updateTableId(stmt);
                this.updateDbNameForTable(stmt, "TAB_COL_STATS", "TABLE_NAME", this.fromCat, this.toCat, this.fromDb, this.toDb, this.tableName);
                this.updateDbNameForTable(stmt, "PART_COL_STATS", "TABLE_NAME", this.fromCat, this.toCat, this.fromDb, this.toDb, this.tableName);
                this.updateDbNameForTable(stmt, "PARTITION_EVENTS", "TBL_NAME", this.fromCat, this.toCat, this.fromDb, this.toDb, this.tableName);
                this.updateDbNameForTable(stmt, "NOTIFICATION_LOG", "TBL_NAME", this.fromCat, this.toCat, this.fromDb, this.toDb, this.tableName);
                conn.commit();
                success = true;
            }
        }
        catch (SQLException se) {
            throw new HiveMetaException("Failed to move table", (Throwable)se);
        }
        finally {
            try {
                if (!success) {
                    conn.rollback();
                }
            }
            catch (SQLException e) {
                LOG.error("Failed to rollback, everything will probably go bad from here.");
            }
        }
    }

    private void updateTableId(Statement stmt) throws SQLException, HiveMetaException {
        long oldDbId = this.getDbId(stmt, this.fromDb, this.fromCat);
        long newDbId = this.getDbId(stmt, this.toDb, this.toCat);
        String update = String.format(this.schemaTool.quote(UPDATE_TABLE_ID_STMT), newDbId, oldDbId, this.tableName);
        LOG.debug("Going to run " + update);
        int numUpdated = stmt.executeUpdate(update);
        if (numUpdated != 1) {
            throw new HiveMetaException("Failed to properly update TBLS table.  Expected to update 1 row but instead updated " + numUpdated);
        }
    }

    private long getDbId(Statement stmt, String db, String catalog) throws SQLException, HiveMetaException {
        String query = String.format(this.schemaTool.quote(DB_ID_QUERY), db, catalog);
        LOG.debug("Going to run " + query);
        try (ResultSet rs = stmt.executeQuery(query);){
            if (!rs.next()) {
                throw new HiveMetaException("Unable to find database " + this.fromDb);
            }
            long l = rs.getLong(1);
            return l;
        }
    }

    private void updateDbNameForTable(Statement stmt, String tableName, String tableColumnName, String fromCat, String toCat, String fromDb, String toDb, String hiveTblName) throws HiveMetaException, SQLException {
        String update = String.format(this.schemaTool.quote(UPDATE_DB_NAME_STMT), tableName, toCat, toDb, fromCat, fromDb, tableColumnName, hiveTblName);
        LOG.debug("Going to run " + update);
        int numUpdated = stmt.executeUpdate(update);
        if (numUpdated > 1 || numUpdated < 0) {
            throw new HiveMetaException("Failed to properly update the " + tableName + " table.  Expected to update 1 row but instead updated " + numUpdated);
        }
    }
}

