/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaToolTaskMoveDatabase
extends SchemaToolTask {
    private static final Logger LOG = LoggerFactory.getLogger((String)SchemaToolTaskMoveDatabase.class.getName());
    private String fromCatName;
    private String toCatName;
    private String dbName;
    private static final String UPDATE_CATALOG_NAME_STMT = "update <q>%s<q>    set <q>%s<q> = '%s'  where <q>%s<q> = '%s'    and <q>%s<q> = '%s'";

    SchemaToolTaskMoveDatabase() {
    }

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cl) {
        this.fromCatName = StringUtils.normalizeIdentifier((String)cl.getOptionValue("fromCatalog"));
        this.toCatName = StringUtils.normalizeIdentifier((String)cl.getOptionValue("toCatalog"));
        this.dbName = StringUtils.normalizeIdentifier((String)cl.getOptionValue("moveDatabase"));
    }

    @Override
    void execute() throws HiveMetaException {
        System.out.println(String.format("Moving database %s from catalog %s to catalog %s", this.dbName, this.fromCatName, this.toCatName));
        Connection conn = this.schemaTool.getConnectionToMetastore(true);
        boolean success = false;
        try {
            conn.setAutoCommit(false);
            try (Statement stmt = conn.createStatement();){
                this.updateCatalogNameInTable(stmt, "DBS", "CTLG_NAME", "NAME", this.fromCatName, this.toCatName, this.dbName, false);
                this.updateCatalogNameInTable(stmt, "TAB_COL_STATS", "CAT_NAME", "DB_NAME", this.fromCatName, this.toCatName, this.dbName, true);
                this.updateCatalogNameInTable(stmt, "PART_COL_STATS", "CAT_NAME", "DB_NAME", this.fromCatName, this.toCatName, this.dbName, true);
                this.updateCatalogNameInTable(stmt, "PARTITION_EVENTS", "CAT_NAME", "DB_NAME", this.fromCatName, this.toCatName, this.dbName, true);
                this.updateCatalogNameInTable(stmt, "NOTIFICATION_LOG", "CAT_NAME", "DB_NAME", this.fromCatName, this.toCatName, this.dbName, true);
                conn.commit();
                success = true;
            }
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to move database", (Throwable)e);
        }
        finally {
            try {
                if (!success) {
                    conn.rollback();
                }
            }
            catch (SQLException e) {
                LOG.error("Failed to rollback, everything will probably go bad from here.");
            }
        }
    }

    private void updateCatalogNameInTable(Statement stmt, String tableName, String catColName, String dbColName, String fromCatName, String toCatName, String dbName, boolean zeroUpdatesOk) throws HiveMetaException, SQLException {
        String update = String.format(this.schemaTool.quote(UPDATE_CATALOG_NAME_STMT), tableName, catColName, toCatName, catColName, fromCatName, dbColName, dbName);
        LOG.debug("Going to run " + update);
        int numUpdated = stmt.executeUpdate(update);
        if (!(numUpdated == 1 || zeroUpdatesOk && numUpdated == 0)) {
            throw new HiveMetaException("Failed to properly update the " + tableName + " table.  Expected to update 1 row but instead updated " + numUpdated);
        }
    }
}

