/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaToolTaskUpdateLocation
extends MetaToolTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MetaToolTaskUpdateLocation.class.getName());

    MetaToolTaskUpdateLocation() {
    }

    @Override
    void execute() {
        String[] loc = this.getCl().getUpddateLocationParams();
        Path newPath = new Path(loc[0]);
        Path oldPath = new Path(loc[1]);
        URI oldURI = oldPath.toUri();
        URI newURI = newPath.toUri();
        if (oldURI.getHost() == null || newURI.getHost() == null) {
            throw new IllegalStateException("HiveMetaTool:A valid host is required in both old-loc and new-loc");
        }
        if (oldURI.getScheme() == null || newURI.getScheme() == null) {
            throw new IllegalStateException("HiveMetaTool:A valid scheme is required in both old-loc and new-loc");
        }
        this.updateFSRootLocation(oldURI, newURI, this.getCl().getSerdePropKey(), this.getCl().getTablePropKey(), this.getCl().isDryRun());
    }

    private void updateFSRootLocation(URI oldURI, URI newURI, String serdePropKey, String tablePropKey, boolean isDryRun) {
        this.updateMDatabaseURI(oldURI, newURI, isDryRun);
        this.updateMStorageDescriptorTblURI(oldURI, newURI, isDryRun);
        this.updateTablePropURI(oldURI, newURI, tablePropKey, isDryRun);
        this.upateSerdeURI(oldURI, newURI, serdePropKey, isDryRun);
    }

    private void updateMDatabaseURI(URI oldURI, URI newURI, boolean isDryRun) {
        System.out.println("Looking for LOCATION_URI field in DBS table to update..");
        ObjectStore.UpdateMDatabaseURIRetVal retVal = this.getObjectStore().updateMDatabaseURI(oldURI, newURI, isDryRun);
        if (retVal == null) {
            System.err.println("Encountered error while executing updateMDatabaseURI - commit of JDO transaction failed. Failed to update FSRoot locations in LOCATION_URI field in DBS table.");
        } else {
            this.printUpdateLocations(retVal.getUpdateLocations(), isDryRun, "DBS");
            this.printBadRecords(retVal.getBadRecords(), "DBS", "LOCATION_URI");
        }
    }

    private void updateMStorageDescriptorTblURI(URI oldURI, URI newURI, boolean isDryRun) {
        System.out.println("Looking for LOCATION field in SDS table to update..");
        ObjectStore.UpdateMStorageDescriptorTblURIRetVal retVal = this.getObjectStore().updateMStorageDescriptorTblURI(oldURI, newURI, isDryRun);
        if (retVal == null) {
            System.err.println("Encountered error while executing updateMStorageDescriptorTblURI - commit of JDO transaction failed. Failed to update FSRoot locations in LOCATION field in SDS table.");
        } else {
            this.printUpdateLocations(retVal.getUpdateLocations(), isDryRun, "SDS");
            this.printBadRecords(retVal.getBadRecords(), "SDS", "LOCATION");
            int numNullRecords = retVal.getNumNullRecords();
            if (numNullRecords != 0) {
                LOGGER.debug("Number of NULL location URI: " + numNullRecords + ". This can happen for View or Index.");
            }
        }
    }

    private void updateTablePropURI(URI oldURI, URI newURI, String tablePropKey, boolean isDryRun) {
        if (tablePropKey != null) {
            System.out.println("Looking for value of " + tablePropKey + " key in TABLE_PARAMS table to update..");
            ObjectStore.UpdatePropURIRetVal updateTblPropURIRetVal = this.getObjectStore().updateTblPropURI(oldURI, newURI, tablePropKey, isDryRun);
            this.printPropURIUpdateSummary(updateTblPropURIRetVal, tablePropKey, isDryRun, "TABLE_PARAMS", "updateTblPropURI");
            System.out.println("Looking for value of " + tablePropKey + " key in SD_PARAMS table to update..");
            ObjectStore.UpdatePropURIRetVal updatePropURIRetVal = this.getObjectStore().updateMStorageDescriptorTblPropURI(oldURI, newURI, tablePropKey, isDryRun);
            this.printPropURIUpdateSummary(updatePropURIRetVal, tablePropKey, isDryRun, "SD_PARAMS", "updateMStorageDescriptorTblPropURI");
        }
    }

    private void printPropURIUpdateSummary(ObjectStore.UpdatePropURIRetVal retVal, String tablePropKey, boolean isDryRun, String tblName, String methodName) {
        if (retVal == null) {
            System.err.println("Encountered error while executing " + methodName + " - commit of JDO transaction failed. Failed to update FSRoot locations in value field corresponding to" + tablePropKey + " in " + tblName + " table.");
        } else {
            this.printUpdateLocations(retVal.getUpdateLocations(), isDryRun, tblName);
            this.printBadRecords(retVal.getBadRecords(), tblName, tablePropKey + " key");
        }
    }

    private void upateSerdeURI(URI oldURI, URI newURI, String serdePropKey, boolean isDryRun) {
        if (serdePropKey != null) {
            System.out.println("Looking for value of " + serdePropKey + " key in SERDE_PARAMS table to update..");
            ObjectStore.UpdateSerdeURIRetVal retVal = this.getObjectStore().updateSerdeURI(oldURI, newURI, serdePropKey, isDryRun);
            if (retVal == null) {
                System.err.println("Encountered error while executing updateSerdeURI - commit of JDO transaction failed. Failed to update FSRoot locations in value field corresponding to " + serdePropKey + " in SERDE_PARAMS table.");
            } else {
                this.printUpdateLocations(retVal.getUpdateLocations(), isDryRun, "SERDE_PARAMS");
                this.printBadRecords(retVal.getBadRecords(), "SERDE_PARAMS", serdePropKey + " key");
            }
        }
    }

    private void printUpdateLocations(Map<String, String> updateLocations, boolean isDryRun, String tableName) {
        System.out.println(isDryRun ? "Dry Run of updateLocation on table " + tableName + ".." : "Successfully updated the following locations..");
        for (Map.Entry<String, String> e : updateLocations.entrySet()) {
            System.out.println("old location: " + e.getKey() + " new location: " + e.getValue());
        }
        System.out.println(isDryRun ? "Found " + updateLocations.size() + " records in " + tableName + " table to update" : "Updated " + updateLocations.size() + " records in " + tableName + " table");
    }

    private void printBadRecords(List<String> badRecords, String tableName, String field) {
        if (!badRecords.isEmpty()) {
            System.err.println("Warning: Found records with bad " + field + " in " + tableName + " table.. ");
            for (String badRecord : badRecords) {
                System.err.println("bad location URI: " + badRecord);
            }
        }
    }
}

