/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.metatool.IcebergReflector;
import org.apache.hadoop.hive.metastore.tools.metatool.MetadataTableSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergTableMetadataHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)IcebergTableMetadataHandler.class.getName());
    private static final String CATALOG_NAME_IN_ICEBERG = "hive";
    private static final String CATALOG_CLASS = "org.apache.iceberg.hive.HiveCatalog";
    private final String mgdWarehouse;
    private final String extWarehouse;
    private final String uris;
    private final Configuration conf;
    private boolean isEnabled = false;
    private static final IcebergReflector IR;

    public IcebergTableMetadataHandler(Configuration config) {
        this.conf = config;
        this.mgdWarehouse = MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE);
        this.extWarehouse = MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE_EXTERNAL);
        this.uris = MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS);
    }

    public boolean isEnabled() {
        if (!this.isEnabled) {
            this.isEnabled = IR != null;
        }
        return this.isEnabled;
    }

    public Map<String, MetadataTableSummary> getIcebergTables() {
        HashMap<String, MetadataTableSummary> metadataSummaryMap = new HashMap<String, MetadataTableSummary>();
        if (!this.isEnabled()) {
            return metadataSummaryMap;
        }
        try {
            IcebergReflector.CatalogHandle catalog = IR.newCatalog();
            catalog.setConf(this.conf);
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            LOG.info("Initializing iceberg handler with properties: warehouse:{} external warehouse:{} thrift uris:{}", new Object[]{this.mgdWarehouse, this.extWarehouse, this.uris});
            propertiesMap.put("warehouse", this.mgdWarehouse);
            propertiesMap.put("externalwarehouse", this.extWarehouse);
            propertiesMap.put("uri", this.uris);
            catalog.initialize(CATALOG_NAME_IN_ICEBERG, propertiesMap);
            Collection<?> listOfNamespaces = catalog.listNamespaces();
            for (Object namespace : listOfNamespaces) {
                Collection<?> identifierList = catalog.listTables(namespace);
                if (identifierList.isEmpty()) continue;
                for (Object tblId : identifierList) {
                    Object tbl = catalog.loadTable(tblId);
                    MetadataTableSummary metadataTableSummary = catalog.collectMetadata(tbl);
                    String tableName = metadataTableSummary.getTblName();
                    metadataSummaryMap.putIfAbsent(tableName, metadataTableSummary);
                    LOG.debug("Adding table: {} {}", (Object)tableName, (Object)metadataTableSummary);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.isEnabled = false;
            LOG.warn("Could not find or instantiate class org.apache.iceberg.hive.HiveCatalog, cannot retrieve stats for iceberg tables.");
        }
        return metadataSummaryMap;
    }

    static {
        IcebergReflector ir = null;
        try {
            ir = new IcebergReflector();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            LOG.warn("Could not find or instantiate class org.apache.iceberg.hive.HiveCatalog, cannot retrieve stats for iceberg tables.", (Throwable)e);
        }
        IR = ir;
    }
}

