/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.tools.metatool.MetadataTableSummary;

public class IcebergReflector {
    private static final String CATALOG_CLASS = "org.apache.iceberg.hive.HiveCatalog";
    private final Class<?> catalogClass = Class.forName("org.apache.iceberg.hive.HiveCatalog");
    private final Constructor<?> constructor = this.catalogClass.getConstructor(new Class[0]);
    private final Method setConf = this.catalogClass.getMethod("setConf", Configuration.class);
    private final Method initialize = this.catalogClass.getMethod("initialize", String.class, Map.class);
    private final Method listNamespaces = this.catalogClass.getMethod("listNamespaces", new Class[0]);
    private volatile Method listTablesMethod;
    private volatile Method loadTableMethod;
    private volatile Method operationsMethod;
    private volatile Method currentMethod;
    private volatile Method schemaMethod;
    private volatile Method columnsMethod;
    private volatile Method specMethod;
    private volatile Method fieldsMethod;
    private volatile Method currentSnapshotMethod;
    private volatile Method summaryMethod;

    IcebergReflector() throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException {
    }

    CatalogHandle newCatalog() {
        try {
            Object catalog = this.constructor.newInstance(new Object[0]);
            return new CatalogHandle(catalog);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    class CatalogHandle {
        private final Object catalog;

        CatalogHandle(Object catalog) {
            this.catalog = catalog;
        }

        void setConf(Configuration conf) throws InvocationTargetException, IllegalAccessException {
            IcebergReflector.this.setConf.invoke(this.catalog, conf);
        }

        void initialize(String name, Map<String, String> properties) throws InvocationTargetException, IllegalAccessException {
            IcebergReflector.this.initialize.invoke(this.catalog, name, properties);
        }

        Collection<?> listNamespaces() throws InvocationTargetException, IllegalAccessException {
            return (Collection)IcebergReflector.this.listNamespaces.invoke(this.catalog, new Object[0]);
        }

        Collection<?> listTables(Object namespace) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
            if (IcebergReflector.this.listTablesMethod == null) {
                Class<?> namespaceClazz = namespace.getClass();
                IcebergReflector.this.listTablesMethod = IcebergReflector.this.catalogClass.getMethod("listTables", namespaceClazz);
            }
            return (Collection)IcebergReflector.this.listTablesMethod.invoke(namespace, new Object[0]);
        }

        Object loadTable(Object tableIdentifier) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
            if (IcebergReflector.this.loadTableMethod == null) {
                Class<?> identifierClazz = tableIdentifier.getClass();
                IcebergReflector.this.loadTableMethod = IcebergReflector.this.catalogClass.getMethod("loadTable", identifierClazz);
            }
            return IcebergReflector.this.loadTableMethod.invoke(tableIdentifier, new Object[0]);
        }

        MetadataTableSummary collectMetadata(Object table) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            Method nameMethod = table.getClass().getMethod("name", new Class[0]);
            String tableFullName = (String)nameMethod.invoke(table, new Object[0]);
            String[] paths = tableFullName.split("\\.");
            String catalogName = paths[0];
            String databaseName = paths[1];
            String tableName = paths[2];
            if (IcebergReflector.this.operationsMethod == null) {
                IcebergReflector.this.operationsMethod = table.getClass().getMethod("operations", new Class[0]);
            }
            Object operations = IcebergReflector.this.operationsMethod.invoke(table, new Object[0]);
            if (IcebergReflector.this.currentMethod == null) {
                IcebergReflector.this.currentMethod = operations.getClass().getMethod("current", new Class[0]);
            }
            Object meta = IcebergReflector.this.currentMethod.invoke(operations, new Object[0]);
            if (IcebergReflector.this.schemaMethod == null) {
                IcebergReflector.this.schemaMethod = meta.getClass().getMethod("schema", new Class[0]);
            }
            Object schema = IcebergReflector.this.schemaMethod.invoke(meta, new Object[0]);
            if (IcebergReflector.this.columnsMethod == null) {
                IcebergReflector.this.columnsMethod = schema.getClass().getMethod("columns", new Class[0]);
            }
            Collection columns = (Collection)IcebergReflector.this.columnsMethod.invoke(schema, new Object[0]);
            if (IcebergReflector.this.specMethod == null) {
                IcebergReflector.this.specMethod = meta.getClass().getMethod("spec", new Class[0]);
            }
            Object spec = IcebergReflector.this.specMethod.invoke(meta, new Object[0]);
            if (IcebergReflector.this.fieldsMethod == null) {
                IcebergReflector.this.fieldsMethod = spec.getClass().getMethod("fields", new Class[0]);
            }
            Collection fields = (Collection)IcebergReflector.this.fieldsMethod.invoke(spec, new Object[0]);
            int columnCount = columns.size();
            int partitionColumnCount = fields.size();
            if (IcebergReflector.this.currentSnapshotMethod == null) {
                IcebergReflector.this.currentSnapshotMethod = meta.getClass().getMethod("currentSnapshot", new Class[0]);
            }
            Object snapshot = IcebergReflector.this.currentSnapshotMethod.invoke(meta, new Object[0]);
            MetadataTableSummary metadataTableSummary = new MetadataTableSummary();
            if (snapshot != null) {
                if (IcebergReflector.this.summaryMethod == null) {
                    IcebergReflector.this.summaryMethod = snapshot.getClass().getDeclaredMethod("summary", new Class[0]);
                }
                Map summaryMap = (Map)IcebergReflector.this.summaryMethod.invoke(snapshot, new Object[0]);
                BigInteger totalSizeBytes = new BigInteger((String)summaryMap.get("total-files-size"));
                BigInteger totalRowsCount = new BigInteger((String)summaryMap.get("total-records"));
                BigInteger totalFilesCount = new BigInteger((String)summaryMap.get("total-data-files"));
                metadataTableSummary.setTotalSize(totalSizeBytes);
                metadataTableSummary.setSizeNumRows(totalRowsCount);
                metadataTableSummary.setSizeNumFiles(totalFilesCount);
            }
            metadataTableSummary.setCtlgName(catalogName);
            metadataTableSummary.setDbName(databaseName);
            metadataTableSummary.setTblName(tableName);
            metadataTableSummary.setColCount(columnCount);
            metadataTableSummary.setPartitionCount(partitionColumnCount);
            return metadataTableSummary;
        }
    }
}

