/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ZooKeeperHiveHelper;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.hadoop.hive.metastore.security.DelegationTokenStore;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.security.TokenStoreDelegationTokenSecretManager;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.MetastoreDelegationTokenSupport;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperTokenStore
implements DelegationTokenStore {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ZooKeeperTokenStore.class.getName());
    protected static final String ZK_SEQ_FORMAT = "%010d";
    private static final String NODE_KEYS = "/keys";
    private static final String NODE_TOKENS = "/tokens";
    private static final String WHEN_ZK_DSTORE_MSG = "when zookeeper based delegation token storage is enabled(hive.cluster.delegation.token.store.class=" + ZooKeeperTokenStore.class.getName() + ")";
    private String rootNode = "";
    private volatile CuratorFramework zkSession;
    private String zkConnectString;
    private String zkConnectPort;
    private int connectTimeoutMillis;
    private boolean sslEnabled;
    private String keyStoreLocation;
    private String keyStorePassword;
    private String keyStoreType;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String trustStoreType;
    private List<ACL> newNodeAcl;
    private Configuration conf;
    private HadoopThriftAuthBridge.Server.ServerMode serverMode;
    private final ACLProvider aclDefaultProvider = new ACLProvider(){

        public List<ACL> getDefaultAcl() {
            return ZooKeeperTokenStore.this.newNodeAcl;
        }

        public List<ACL> getAclForPath(String path) {
            return this.getDefaultAcl();
        }
    };

    private List<ACL> getDefaultAcl(Configuration conf) {
        ArrayList<ACL> nodeAcls = new ArrayList<ACL>();
        if (this.isKerberosEnabled(conf)) {
            nodeAcls.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
        } else {
            nodeAcls.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
        }
        return nodeAcls;
    }

    private boolean isKerberosEnabled(Configuration conf) {
        try {
            return UserGroupInformation.getLoginUser().isFromKeytab() && MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_ZOOKEEPER_USE_KERBEROS);
        }
        catch (IOException e) {
            return false;
        }
    }

    protected ZooKeeperTokenStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CuratorFramework getSession() {
        if (this.zkSession == null || this.zkSession.getState() == CuratorFrameworkState.STOPPED) {
            ZooKeeperTokenStore zooKeeperTokenStore = this;
            synchronized (zooKeeperTokenStore) {
                if (this.zkSession == null || this.zkSession.getState() == CuratorFrameworkState.STOPPED) {
                    ZooKeeperHiveHelper zkHelper = ZooKeeperHiveHelper.builder().quorum(this.zkConnectString).clientPort(this.zkConnectPort).connectionTimeout(this.connectTimeoutMillis).maxRetries(3).baseSleepTime(1000).sslEnabled(this.sslEnabled).keyStoreLocation(this.keyStoreLocation).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).trustStoreLocation(this.trustStoreLocation).trustStorePassword(this.trustStorePassword).trustStoreType(this.trustStoreType).build();
                    this.zkSession = zkHelper.getNewZookeeperClient(this.aclDefaultProvider);
                    this.zkSession.start();
                }
            }
        }
        return this.zkSession;
    }

    private void setupJAASConfig(Configuration conf) throws IOException {
        String keytab;
        String principal;
        if (!this.isKerberosEnabled(conf)) {
            LOGGER.warn("Login is not from keytab");
            return;
        }
        switch (this.serverMode) {
            case METASTORE: {
                principal = this.getNonEmptyConfVar(conf, "hive.metastore.kerberos.principal");
                keytab = this.getNonEmptyConfVar(conf, "hive.metastore.kerberos.keytab.file");
                break;
            }
            case HIVESERVER2: {
                principal = this.getNonEmptyConfVar(conf, "hive.server2.authentication.kerberos.principal");
                keytab = this.getNonEmptyConfVar(conf, "hive.server2.authentication.kerberos.keytab");
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected server mode " + this.serverMode));
            }
        }
        SecurityUtils.setZookeeperClientKerberosJaasConfig((String)principal, (String)keytab);
    }

    private String getNonEmptyConfVar(Configuration conf, String param) throws IOException {
        String val = conf.get(param);
        if (val == null || val.trim().isEmpty()) {
            throw new IOException("Configuration parameter " + param + " should be set, " + WHEN_ZK_DSTORE_MSG);
        }
        return val;
    }

    public void ensurePath(String path, List<ACL> acl) throws DelegationTokenStore.TokenStoreException {
        try {
            CuratorFramework zk = this.getSession();
            String node = (String)((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)zk.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).withACL(acl)).forPath(path);
            LOGGER.info("Created path: {} ", (Object)node);
        }
        catch (KeeperException.NodeExistsException zk) {
        }
        catch (Exception e) {
            throw new DelegationTokenStore.TokenStoreException("Error creating path " + path, e);
        }
    }

    public static int getPermFromString(String permString) {
        int perm = 0;
        block7: for (int i = 0; i < permString.length(); ++i) {
            switch (permString.charAt(i)) {
                case 'r': {
                    perm |= 1;
                    continue block7;
                }
                case 'w': {
                    perm |= 2;
                    continue block7;
                }
                case 'c': {
                    perm |= 4;
                    continue block7;
                }
                case 'd': {
                    perm |= 8;
                    continue block7;
                }
                case 'a': {
                    perm |= 0x10;
                    continue block7;
                }
                default: {
                    LOGGER.error("Unknown perm type: " + permString.charAt(i));
                }
            }
        }
        return perm;
    }

    public static List<ACL> parseACLs(String aclString) {
        String[] aclComps = StringUtils.splitByWholeSeparator((String)aclString, (String)",");
        ArrayList<ACL> acl = new ArrayList<ACL>(aclComps.length);
        for (String a : aclComps) {
            if (StringUtils.isBlank((CharSequence)a)) continue;
            a = a.trim();
            int firstColon = a.indexOf(58);
            int lastColon = a.lastIndexOf(58);
            if (firstColon == -1 || lastColon == -1 || firstColon == lastColon) {
                LOGGER.error(a + " does not have the form scheme:id:perm");
                continue;
            }
            ACL newAcl = new ACL();
            newAcl.setId(new Id(a.substring(0, firstColon), a.substring(firstColon + 1, lastColon)));
            newAcl.setPerms(ZooKeeperTokenStore.getPermFromString(a.substring(lastColon + 1)));
            acl.add(newAcl);
        }
        return acl;
    }

    private void initClientAndPaths() {
        if (this.zkSession != null) {
            this.zkSession.close();
        }
        this.ensurePath(this.rootNode + NODE_KEYS, this.newNodeAcl);
        this.ensurePath(this.rootNode + NODE_TOKENS, this.newNodeAcl);
    }

    public void setConf(Configuration conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf is null");
        }
        this.conf = conf;
    }

    public Configuration getConf() {
        return null;
    }

    private Map<Integer, byte[]> getAllKeys() throws KeeperException, InterruptedException {
        String masterKeyNode = this.rootNode + NODE_KEYS;
        List<String> nodes = this.zkGetChildren(masterKeyNode);
        HashMap<Integer, byte[]> result = new HashMap<Integer, byte[]>();
        for (String node : nodes) {
            String nodePath = masterKeyNode + "/" + node;
            byte[] data = this.zkGetData(nodePath);
            if (data == null) continue;
            result.put(this.getSeq(node), data);
        }
        return result;
    }

    private List<String> zkGetChildren(String path) {
        CuratorFramework zk = this.getSession();
        try {
            return (List)zk.getChildren().forPath(path);
        }
        catch (Exception e) {
            throw new DelegationTokenStore.TokenStoreException("Error getting children for " + path, e);
        }
    }

    private byte[] zkGetData(String nodePath) {
        CuratorFramework zk = this.getSession();
        try {
            return (byte[])zk.getData().forPath(nodePath);
        }
        catch (KeeperException.NoNodeException ex) {
            return null;
        }
        catch (Exception e) {
            throw new DelegationTokenStore.TokenStoreException("Error reading " + nodePath, e);
        }
    }

    private int getSeq(String path) {
        String[] pathComps = path.split("/");
        return Integer.parseInt(pathComps[pathComps.length - 1]);
    }

    @Override
    public int addMasterKey(String s) {
        String newNode;
        String keysPath = this.rootNode + NODE_KEYS + "/";
        CuratorFramework zk = this.getSession();
        try {
            newNode = (String)((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)zk.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).withACL(this.newNodeAcl)).forPath(keysPath, s.getBytes());
        }
        catch (Exception e) {
            throw new DelegationTokenStore.TokenStoreException("Error creating new node with path " + keysPath, e);
        }
        LOGGER.info("Added key {}", (Object)newNode);
        return this.getSeq(newNode);
    }

    @Override
    public void updateMasterKey(int keySeq, String s) {
        CuratorFramework zk = this.getSession();
        String keyPath = this.rootNode + NODE_KEYS + "/" + String.format(ZK_SEQ_FORMAT, keySeq);
        try {
            zk.setData().forPath(keyPath, s.getBytes());
        }
        catch (Exception e) {
            throw new DelegationTokenStore.TokenStoreException("Error setting data in " + keyPath, e);
        }
    }

    @Override
    public boolean removeMasterKey(int keySeq) {
        String keyPath = this.rootNode + NODE_KEYS + "/" + String.format(ZK_SEQ_FORMAT, keySeq);
        this.zkDelete(keyPath);
        return true;
    }

    private void zkDelete(String path) {
        CuratorFramework zk = this.getSession();
        try {
            zk.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new DelegationTokenStore.TokenStoreException("Error deleting " + path, e);
        }
    }

    @Override
    public String[] getMasterKeys() {
        try {
            Map<Integer, byte[]> allKeys = this.getAllKeys();
            String[] result = new String[allKeys.size()];
            int resultIdx = 0;
            for (byte[] keyBytes : allKeys.values()) {
                result[resultIdx++] = new String(keyBytes);
            }
            return result;
        }
        catch (KeeperException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
        catch (InterruptedException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
    }

    private String getTokenPath(DelegationTokenIdentifier tokenIdentifier) {
        try {
            return this.rootNode + NODE_TOKENS + "/" + TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)tokenIdentifier);
        }
        catch (IOException ex) {
            throw new DelegationTokenStore.TokenStoreException("Failed to encode token identifier", ex);
        }
    }

    @Override
    public boolean addToken(DelegationTokenIdentifier tokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation token) {
        String newNode;
        byte[] tokenBytes = MetastoreDelegationTokenSupport.encodeDelegationTokenInformation((AbstractDelegationTokenSecretManager.DelegationTokenInformation)token);
        String tokenPath = this.getTokenPath(tokenIdentifier);
        CuratorFramework zk = this.getSession();
        try {
            newNode = (String)((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)zk.create().withMode(CreateMode.PERSISTENT)).withACL(this.newNodeAcl)).forPath(tokenPath, tokenBytes);
        }
        catch (Exception e) {
            throw new DelegationTokenStore.TokenStoreException("Error creating new node with path " + tokenPath, e);
        }
        LOGGER.info("Added token: {}", (Object)newNode);
        return true;
    }

    @Override
    public boolean removeToken(DelegationTokenIdentifier tokenIdentifier) {
        String tokenPath = this.getTokenPath(tokenIdentifier);
        this.zkDelete(tokenPath);
        LOGGER.info("Removed token: {}", (Object)tokenPath);
        return true;
    }

    @Override
    public AbstractDelegationTokenSecretManager.DelegationTokenInformation getToken(DelegationTokenIdentifier tokenIdentifier) {
        String tokenPath = this.getTokenPath(tokenIdentifier);
        byte[] tokenBytes = this.zkGetData(tokenPath);
        if (tokenBytes == null) {
            LOGGER.info("Could not get data from {}", (Object)tokenPath);
            return null;
        }
        try {
            return MetastoreDelegationTokenSupport.decodeDelegationTokenInformation((byte[])tokenBytes);
        }
        catch (Exception ex) {
            throw new DelegationTokenStore.TokenStoreException("Failed to decode token", ex);
        }
    }

    @Override
    public List<DelegationTokenIdentifier> getAllDelegationTokenIdentifiers() {
        String containerNode = this.rootNode + NODE_TOKENS;
        List<String> nodes = this.zkGetChildren(containerNode);
        ArrayList<DelegationTokenIdentifier> result = new ArrayList<DelegationTokenIdentifier>(nodes.size());
        for (String node : nodes) {
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            try {
                TokenStoreDelegationTokenSecretManager.decodeWritable((Writable)id, node);
                result.add(id);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to decode token '{}'", (Object)node);
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.zkSession != null) {
            this.zkSession.close();
        }
    }

    @Override
    public void init(Object hmsHandler, HadoopThriftAuthBridge.Server.ServerMode sMode) {
        String aclStr;
        this.serverMode = sMode;
        this.zkConnectString = this.conf.get("hive.cluster.delegation.token.store.zookeeper.connectString", null);
        if (this.zkConnectString == null || this.zkConnectString.trim().isEmpty()) {
            this.zkConnectString = this.conf.get("hive.zookeeper.quorum", null);
            if (this.zkConnectString == null || this.zkConnectString.trim().isEmpty()) {
                throw new IllegalArgumentException("Zookeeper connect string has to be specified through either hive.cluster.delegation.token.store.zookeeper.connectString or hive.zookeeper.quorum" + WHEN_ZK_DSTORE_MSG);
            }
            this.zkConnectPort = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_ZOOKEEPER_CLIENT_PORT);
            this.connectTimeoutMillis = (int)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_ZOOKEEPER_CONNECTION_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
            this.sslEnabled = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_ZOOKEEPER_SSL_ENABLE);
            if (this.sslEnabled) {
                try {
                    this.keyStoreLocation = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_ZOOKEEPER_SSL_KEYSTORE_LOCATION);
                    this.keyStorePassword = MetastoreConf.getPassword((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_ZOOKEEPER_SSL_KEYSTORE_PASSWORD);
                    this.keyStoreType = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_ZOOKEEPER_SSL_KEYSTORE_TYPE);
                    this.trustStoreLocation = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_ZOOKEEPER_SSL_TRUSTSTORE_LOCATION);
                    this.trustStorePassword = MetastoreConf.getPassword((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_ZOOKEEPER_SSL_TRUSTSTORE_PASSWORD);
                    this.trustStoreType = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_ZOOKEEPER_SSL_TRUSTSTORE_TYPE);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to read zookeeper configuration passwords", ex);
                }
            }
        } else {
            this.connectTimeoutMillis = this.conf.getInt("hive.cluster.delegation.token.store.zookeeper.connectTimeoutMillis", CuratorFrameworkFactory.builder().getConnectionTimeoutMs());
            this.sslEnabled = this.conf.getBoolean("hive.cluster.delegation.token.store.zookeeper.ssl.client.enable", false);
            if (this.sslEnabled) {
                try {
                    this.keyStoreLocation = this.conf.get("hive.cluster.delegation.token.store.zookeeper.keystore.location", "");
                    char[] pwd = this.conf.getPassword("hive.cluster.delegation.token.store.zookeeper.keystore.password");
                    this.keyStorePassword = pwd == null ? null : new String(pwd);
                    this.keyStoreType = this.conf.get("hive.cluster.delegation.token.store.zookeeper.keystore.type", "");
                    this.trustStoreLocation = this.conf.get("hive.cluster.delegation.token.store.zookeeper.truststore.location", "");
                    pwd = this.conf.getPassword("hive.cluster.delegation.token.store.zookeeper.truststore.password");
                    this.trustStorePassword = pwd == null ? null : new String(pwd);
                    this.trustStoreType = this.conf.get("hive.cluster.delegation.token.store.zookeeper.truststore.type", "");
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to read zookeeper configuration passwords", ex);
                }
            }
        }
        this.newNodeAcl = StringUtils.isNotBlank((CharSequence)(aclStr = this.conf.get("hive.cluster.delegation.token.store.zookeeper.acl", null))) ? ZooKeeperTokenStore.parseACLs(aclStr) : this.getDefaultAcl(this.conf);
        this.rootNode = this.conf.get("hive.cluster.delegation.token.store.zookeeper.znode", "/hivedelegation") + this.serverMode;
        try {
            this.setupJAASConfig(this.conf);
        }
        catch (IOException e) {
            throw new DelegationTokenStore.TokenStoreException("Error setting up JAAS configuration for zookeeper client " + e.getMessage(), e);
        }
        this.initClientAndPaths();
    }
}

