/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.parser;

import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.parser.PartitionFilterBaseVisitor;
import org.apache.hadoop.hive.metastore.parser.PartitionFilterParser;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

public class PartFilterVisitor
extends PartitionFilterBaseVisitor<Object> {
    public Object visitChildren(RuleNode node) {
        if (node.getChildCount() == 1) {
            return node.getChild(0).accept((ParseTreeVisitor)this);
        }
        return null;
    }

    @Override
    public ExpressionTree visitFilter(PartitionFilterParser.FilterContext ctx) {
        ExpressionTree tree = new ExpressionTree();
        ExpressionTree.TreeNode treeNode = (ExpressionTree.TreeNode)this.visit((ParseTree)ctx.orExpression());
        tree.setRoot(treeNode);
        return tree;
    }

    @Override
    public ExpressionTree.TreeNode visitOrExpression(PartitionFilterParser.OrExpressionContext ctx) {
        List nodes = ctx.andExprs.stream().map(this::visitAndExpression).collect(Collectors.toList());
        return this.buildTreeFromNodes(nodes, ExpressionTree.LogicalOperator.OR);
    }

    @Override
    public ExpressionTree.TreeNode visitAndExpression(PartitionFilterParser.AndExpressionContext ctx) {
        List nodes = ctx.exprs.stream().map(this::visitExpression).collect(Collectors.toList());
        return this.buildTreeFromNodes(nodes, ExpressionTree.LogicalOperator.AND);
    }

    private ExpressionTree.TreeNode buildTreeFromNodes(List<? extends ExpressionTree.TreeNode> nodes, ExpressionTree.LogicalOperator operator) {
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        ExpressionTree.TreeNode root = new ExpressionTree.TreeNode(nodes.get(0), operator, nodes.get(1));
        for (int i = 2; i < nodes.size(); ++i) {
            ExpressionTree.TreeNode tmp;
            root = tmp = new ExpressionTree.TreeNode(root, operator, nodes.get(i));
        }
        return root;
    }

    @Override
    public ExpressionTree.TreeNode visitExpression(PartitionFilterParser.ExpressionContext ctx) {
        if (ctx.orExpression() != null) {
            return this.visitOrExpression(ctx.orExpression());
        }
        return (ExpressionTree.TreeNode)this.visit((ParseTree)ctx.conditionExpression());
    }

    @Override
    public ExpressionTree.TreeNode visitComparison(PartitionFilterParser.ComparisonContext ctx) {
        ExpressionTree.LeafNode leafNode = new ExpressionTree.LeafNode();
        leafNode.keyName = (String)this.visit((ParseTree)ctx.key);
        leafNode.value = this.visit((ParseTree)ctx.value);
        leafNode.operator = this.visitComparisonOperator(ctx.comparisonOperator());
        return leafNode;
    }

    @Override
    public Object visitReverseComparison(PartitionFilterParser.ReverseComparisonContext ctx) {
        ExpressionTree.LeafNode leafNode = new ExpressionTree.LeafNode();
        leafNode.keyName = (String)this.visit((ParseTree)ctx.key);
        leafNode.value = this.visit((ParseTree)ctx.value);
        leafNode.operator = this.visitComparisonOperator(ctx.comparisonOperator());
        leafNode.isReverseOrder = true;
        return leafNode;
    }

    @Override
    public ExpressionTree.TreeNode visitBetweenCondition(PartitionFilterParser.BetweenConditionContext ctx) {
        ExpressionTree.LeafNode left = new ExpressionTree.LeafNode();
        ExpressionTree.LeafNode right = new ExpressionTree.LeafNode();
        left.keyName = right.keyName = (String)this.visit((ParseTree)ctx.key);
        left.value = this.visit((ParseTree)ctx.lower);
        right.value = this.visit((ParseTree)ctx.upper);
        boolean isPositive = ctx.NOT() == null;
        left.operator = isPositive ? ExpressionTree.Operator.GREATERTHANOREQUALTO : ExpressionTree.Operator.LESSTHAN;
        right.operator = isPositive ? ExpressionTree.Operator.LESSTHANOREQUALTO : ExpressionTree.Operator.GREATERTHAN;
        ExpressionTree.LogicalOperator rootOperator = isPositive ? ExpressionTree.LogicalOperator.AND : ExpressionTree.LogicalOperator.OR;
        ExpressionTree.TreeNode treeNode = new ExpressionTree.TreeNode(left, rootOperator, right);
        return treeNode;
    }

    @Override
    public ExpressionTree.TreeNode visitInCondition(PartitionFilterParser.InConditionContext ctx) {
        Object values = this.visitConstantSeq(ctx.constantSeq());
        boolean isPositive = ctx.NOT() == null;
        String keyName = (String)this.visit((ParseTree)ctx.key);
        List nodes = values.stream().map(value -> {
            ExpressionTree.LeafNode leafNode = new ExpressionTree.LeafNode();
            leafNode.keyName = keyName;
            leafNode.value = value;
            leafNode.operator = isPositive ? ExpressionTree.Operator.EQUALS : ExpressionTree.Operator.NOTEQUALS2;
            return leafNode;
        }).collect(Collectors.toList());
        return this.buildTreeFromNodes(nodes, isPositive ? ExpressionTree.LogicalOperator.OR : ExpressionTree.LogicalOperator.AND);
    }

    @Override
    public ExpressionTree.TreeNode visitMultiColInExpression(PartitionFilterParser.MultiColInExpressionContext ctx) {
        Object keyNames = this.visitIdentifierList(ctx.identifierList());
        Object structs = this.visitConstStructList(ctx.constStructList());
        boolean isPositive = ctx.NOT() == null;
        ArrayList<ExpressionTree.TreeNode> treeNodes = new ArrayList<ExpressionTree.TreeNode>(structs.size());
        for (int i = 0; i < structs.size(); ++i) {
            List struct = (List)structs.get(i);
            if (keyNames.size() != struct.size()) {
                throw new ParseCancellationException("Struct key " + keyNames + " and value " + struct + " sizes do not match.");
            }
            ArrayList<ExpressionTree.LeafNode> nodes = new ArrayList<ExpressionTree.LeafNode>(struct.size());
            for (int j = 0; j < struct.size(); ++j) {
                ExpressionTree.LeafNode leafNode = new ExpressionTree.LeafNode();
                leafNode.keyName = (String)keyNames.get(j);
                leafNode.value = struct.get(j);
                leafNode.operator = isPositive ? ExpressionTree.Operator.EQUALS : ExpressionTree.Operator.NOTEQUALS2;
                nodes.add(leafNode);
            }
            treeNodes.add(this.buildTreeFromNodes(nodes, isPositive ? ExpressionTree.LogicalOperator.AND : ExpressionTree.LogicalOperator.OR));
        }
        return this.buildTreeFromNodes(treeNodes, isPositive ? ExpressionTree.LogicalOperator.OR : ExpressionTree.LogicalOperator.AND);
    }

    @Override
    public ExpressionTree.Operator visitComparisonOperator(PartitionFilterParser.ComparisonOperatorContext ctx) {
        TerminalNode node = (TerminalNode)ctx.getChild(0);
        switch (node.getSymbol().getType()) {
            case 14: {
                return ExpressionTree.Operator.EQUALS;
            }
            case 16: {
                return ExpressionTree.Operator.NOTEQUALS;
            }
            case 17: {
                return ExpressionTree.Operator.NOTEQUALS2;
            }
            case 18: {
                return ExpressionTree.Operator.LESSTHAN;
            }
            case 19: {
                return ExpressionTree.Operator.LESSTHANOREQUALTO;
            }
            case 20: {
                return ExpressionTree.Operator.GREATERTHAN;
            }
            case 21: {
                return ExpressionTree.Operator.GREATERTHANOREQUALTO;
            }
            case 22: {
                return ExpressionTree.Operator.LIKE;
            }
        }
        throw new ParseCancellationException("Unsupported comparison operator: " + node.getSymbol().getText());
    }

    @Override
    public List<Object> visitConstantSeq(PartitionFilterParser.ConstantSeqContext ctx) {
        return ctx.values.stream().map(arg_0 -> ((PartFilterVisitor)this).visit(arg_0)).collect(Collectors.toList());
    }

    @Override
    public List<Object> visitConstStruct(PartitionFilterParser.ConstStructContext ctx) {
        return this.visitConstantSeq(ctx.constantSeq());
    }

    @Override
    public List<List<Object>> visitConstStructList(PartitionFilterParser.ConstStructListContext ctx) {
        return ctx.structs.stream().map(constStructContext -> this.visitConstStruct((PartitionFilterParser.ConstStructContext)((Object)constStructContext))).collect(Collectors.toList());
    }

    @Override
    public List<String> visitIdentifierList(PartitionFilterParser.IdentifierListContext ctx) {
        return ctx.ident.stream().map(i -> i.getText()).collect(Collectors.toList());
    }

    @Override
    public String visitStringLiteral(PartitionFilterParser.StringLiteralContext ctx) {
        return this.unquoteString(ctx.getText());
    }

    private String unquoteString(String string) {
        if (string.length() > 1 && (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'' || string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"')) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    @Override
    public Long visitIntegerLiteral(PartitionFilterParser.IntegerLiteralContext ctx) {
        return Long.parseLong(ctx.getText());
    }

    @Override
    public String visitDateLiteral(PartitionFilterParser.DateLiteralContext ctx) {
        PartitionFilterParser.DateContext date = ctx.date();
        String dateValue = this.unquoteString(date.value.getText());
        try {
            MetaStoreUtils.convertStringToDate((String)dateValue);
        }
        catch (DateTimeParseException e) {
            throw new ParseCancellationException(e.getMessage());
        }
        return dateValue;
    }

    @Override
    public String visitTimestampLiteral(PartitionFilterParser.TimestampLiteralContext ctx) {
        PartitionFilterParser.TimestampContext timestamp = ctx.timestamp();
        String timestampValue = this.unquoteString(timestamp.value.getText());
        try {
            MetaStoreUtils.convertStringToTimestamp((String)timestampValue);
        }
        catch (DateTimeParseException e) {
            throw new ParseCancellationException(e.getMessage());
        }
        return timestampValue;
    }

    @Override
    public String visitUnquotedIdentifer(PartitionFilterParser.UnquotedIdentiferContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitQuotedIdentifier(PartitionFilterParser.QuotedIdentifierContext ctx) {
        return StringUtils.replace((String)ctx.getText().substring(1, ctx.getText().length() - 1), (String)"``", (String)"`");
    }
}

