/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

final class CompactionMetricData {
    private static final Long OLDEST_TIME_NO_VALUE = Long.MAX_VALUE;
    private final List<ShowCompactResponseElement> compacts;
    private long oldestEnqueueTime;
    private long oldestWorkingTime;
    private long oldestCleaningTime;
    private Map<String, Long> stateCount;
    private Map<String, Integer> initiatedCountPerPool;
    private Map<String, Integer> workingCountPerPool;
    private Map<String, Integer> longestEnqueueDurationPerPool;
    private Map<String, Integer> longestWorkingDurationPerPool;
    private Double failedCompactionPercentage;
    private long initiatorsCount;
    private long initiatorVersionsCount;
    private long workersCount;
    private long workerVersionsCount;

    private CompactionMetricData(List<ShowCompactResponseElement> compacts) {
        this.compacts = compacts;
    }

    static CompactionMetricData of(List<ShowCompactResponseElement> compacts) {
        CompactionMetricData data = new CompactionMetricData(Optional.ofNullable(compacts).orElseGet(ImmutableList::of));
        data.init();
        return data;
    }

    private void init() {
        HashMap<String, ShowCompactResponseElement> lastElements = new HashMap<String, ShowCompactResponseElement>();
        this.initiatedCountPerPool = new HashMap<String, Integer>();
        this.workingCountPerPool = new HashMap<String, Integer>();
        this.longestEnqueueDurationPerPool = new HashMap<String, Integer>();
        this.longestWorkingDurationPerPool = new HashMap<String, Integer>();
        this.oldestEnqueueTime = OLDEST_TIME_NO_VALUE;
        this.oldestWorkingTime = OLDEST_TIME_NO_VALUE;
        this.oldestCleaningTime = OLDEST_TIME_NO_VALUE;
        long currentTime = System.currentTimeMillis();
        for (ShowCompactResponseElement element : this.compacts) {
            String key = element.getDbname() + "/" + element.getTablename() + (element.getPartitionname() != null ? "/" + element.getPartitionname() : "");
            lastElements.compute(key, (k, old) -> old == null ? element : (element.getId() > old.getId() ? element : old));
            String state = element.getState();
            if ("initiated".equals(state)) {
                int enqueueSeconds = (int)((currentTime - element.getEnqueueTime()) / 1000L);
                this.longestEnqueueDurationPerPool.compute(element.getPoolName(), (k, old) -> old == null ? enqueueSeconds : Math.max(enqueueSeconds, old));
                this.initiatedCountPerPool.compute(element.getPoolName(), (k, old) -> old == null ? 1 : old + 1);
                if (this.oldestEnqueueTime > element.getEnqueueTime()) {
                    this.oldestEnqueueTime = element.getEnqueueTime();
                }
            }
            if (element.isSetStart() && "working".equals(state)) {
                int startSeconds = (int)((currentTime - element.getStart()) / 1000L);
                this.longestWorkingDurationPerPool.compute(element.getPoolName(), (k, old) -> old == null ? startSeconds : Math.max(startSeconds, old));
                this.workingCountPerPool.compute(element.getPoolName(), (k, old) -> old == null ? 1 : old + 1);
                if (this.oldestWorkingTime > element.getStart()) {
                    this.oldestWorkingTime = element.getStart();
                }
            }
            if (!element.isSetCleanerStart() || !"ready for cleaning".equals(state) || this.oldestCleaningTime <= element.getCleanerStart()) continue;
            this.oldestCleaningTime = element.getCleanerStart();
        }
        this.stateCount = lastElements.values().stream().collect(Collectors.groupingBy(ShowCompactResponseElement::getState, Collectors.counting()));
        this.failedCompactionPercentage = CompactionMetricData.calculateFailedPercentage(this.stateCount);
        this.initiatorsCount = lastElements.values().stream().filter(e -> !"manual".equals(MetaStoreUtils.getThreadIdFromId((String)e.getInitiatorId()))).map(e -> MetaStoreUtils.getHostFromId((String)e.getInitiatorId())).filter(e -> !" --- ".equals(e)).distinct().count();
        this.initiatorVersionsCount = lastElements.values().stream().map(ShowCompactResponseElement::getInitiatorVersion).filter(Objects::nonNull).distinct().count();
        this.workersCount = lastElements.values().stream().map(e -> MetaStoreUtils.getHostFromId((String)e.getWorkerid())).filter(e -> !" --- ".equals(e)).distinct().count();
        this.workerVersionsCount = lastElements.values().stream().map(ShowCompactResponseElement::getWorkerVersion).filter(Objects::nonNull).distinct().count();
    }

    List<String> allWorkerVersionsSince(long since) {
        return this.compacts.stream().filter(comp -> comp.isSetEnqueueTime() && comp.getEnqueueTime() >= since || comp.isSetStart() && comp.getStart() >= since || comp.isSetEndTime() && comp.getEndTime() >= since).filter(comp -> !"did not initiate".equals(comp.getState())).map(ShowCompactResponseElement::getWorkerVersion).filter(Objects::nonNull).distinct().sorted().collect(Collectors.toList());
    }

    Map<String, Long> getStateCount() {
        return Collections.unmodifiableMap(this.stateCount);
    }

    public Map<String, Integer> getInitiatedCountPerPool() {
        return Collections.unmodifiableMap(this.initiatedCountPerPool);
    }

    public Map<String, Integer> getWorkingCountPerPool() {
        return Collections.unmodifiableMap(this.workingCountPerPool);
    }

    public Map<String, Integer> getLongestEnqueueDurationPerPool() {
        return Collections.unmodifiableMap(this.longestEnqueueDurationPerPool);
    }

    public Map<String, Integer> getLongestWorkingDurationPerPool() {
        return Collections.unmodifiableMap(this.longestWorkingDurationPerPool);
    }

    Long getOldestEnqueueTime() {
        return CompactionMetricData.nullIfNotSet(this.oldestEnqueueTime);
    }

    Long getOldestWorkingTime() {
        return CompactionMetricData.nullIfNotSet(this.oldestWorkingTime);
    }

    Long getOldestCleaningTime() {
        return CompactionMetricData.nullIfNotSet(this.oldestCleaningTime);
    }

    Double getFailedCompactionPercentage() {
        return this.failedCompactionPercentage;
    }

    long getInitiatorsCount() {
        return this.initiatorsCount;
    }

    long getInitiatorVersionsCount() {
        return this.initiatorVersionsCount;
    }

    long getWorkersCount() {
        return this.workersCount;
    }

    long getWorkerVersionsCount() {
        return this.workerVersionsCount;
    }

    private static Long nullIfNotSet(long value) {
        if (value == OLDEST_TIME_NO_VALUE) {
            return null;
        }
        return value;
    }

    private static Double calculateFailedPercentage(Map<String, Long> stateCount) {
        long failed = CompactionMetricData.unwrapToPrimitive(stateCount.get("failed"));
        long notInitiated = CompactionMetricData.unwrapToPrimitive(stateCount.get("did not initiate"));
        long succeeded = CompactionMetricData.unwrapToPrimitive(stateCount.get("succeeded"));
        long refused = CompactionMetricData.unwrapToPrimitive(stateCount.get("refused"));
        long denominator = failed + notInitiated + refused + succeeded;
        if (denominator > 0L) {
            long numerator = failed + notInitiated + refused;
            return Long.valueOf(numerator).doubleValue() / Long.valueOf(denominator).doubleValue();
        }
        return null;
    }

    private static long unwrapToPrimitive(Long value) {
        if (value == null) {
            return 0L;
        }
        return value;
    }
}

