/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.AcidMetricService;
import org.apache.hadoop.hive.metastore.metrics.CompactionMetricData;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionMetricsData;
import org.apache.hadoop.hive.metastore.txn.entities.MetricsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidMetricLogger
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(AcidMetricLogger.class);
    private Configuration conf;
    private TxnStore txnHandler;
    private int maxCacheSize;

    public long runFrequency(TimeUnit timeUnit) {
        return MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_ACID_METRICS_LOGGER_FREQUENCY, (TimeUnit)timeUnit);
    }

    public void run() {
        try {
            this.logDbMetrics();
            this.logMetrics();
        }
        catch (MetaException e) {
            LOG.warn("Caught exception while trying to log acid metrics data.", (Throwable)e);
        }
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
        this.maxCacheSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_DELTAMETRICS_MAX_CACHE_SIZE);
    }

    public Configuration getConf() {
        return this.conf;
    }

    private void logMetrics() throws MetaException {
        ShowCompactResponse response = this.txnHandler.showCompact(new ShowCompactRequest());
        CompactionMetricData metricData = CompactionMetricData.of(response.getCompacts());
        this.logMultipleWorkerVersions(metricData);
        this.logFailedCompactionsPercentage(metricData);
        this.logOldestInitiatorAge(metricData);
        this.logDeltaMetrics();
    }

    private void logDeltaMetrics() throws MetaException {
        List<CompactionMetricsData> deltas = this.txnHandler.getTopCompactionMetricsDataPerType(this.maxCacheSize);
        deltas.stream().filter(d -> d.getMetricType() == CompactionMetricsData.MetricType.NUM_DELTAS).forEach(d -> LOG.warn(String.format("Directory %s contains %d active delta directories. This can cause performance degradation.", AcidMetricService.getDeltaCountKey(d.getDbName(), d.getTblName(), d.getPartitionName()), d.getMetricValue())));
        deltas.stream().filter(d -> d.getMetricType() == CompactionMetricsData.MetricType.NUM_SMALL_DELTAS).forEach(d -> LOG.warn(String.format("Directory %s contains %d small delta directories. This can indicate performance degradation and there might be a problem with your streaming setup.", AcidMetricService.getDeltaCountKey(d.getDbName(), d.getTblName(), d.getPartitionName()), d.getMetricValue())));
        deltas.stream().filter(d -> d.getMetricType() == CompactionMetricsData.MetricType.NUM_OBSOLETE_DELTAS).forEach(d -> LOG.warn(String.format("Directory %s contains %d obsolete delta directories. This can indicate compaction cleaner issues.", AcidMetricService.getDeltaCountKey(d.getDbName(), d.getTblName(), d.getPartitionName()), d.getMetricValue())));
    }

    private void logOldestInitiatorAge(CompactionMetricData metricData) {
        int oldestInitiatorAge = (int)((System.currentTimeMillis() - metricData.getOldestEnqueueTime()) / 1000L);
        String oldestInitiatorMessage = "Found compaction entry in compaction queue with an age of {} seconds. Consider increasing the number of worker threads.";
        long oldestInitiatedWarningThreshold = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_INITIATED_COMPACTION_TIME_THRESHOLD_WARNING, (TimeUnit)TimeUnit.SECONDS);
        long oldestInitiatedErrorThreshold = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_INITIATED_COMPACTION_TIME_THRESHOLD_ERROR, (TimeUnit)TimeUnit.SECONDS);
        if ((long)oldestInitiatorAge >= oldestInitiatedErrorThreshold) {
            LOG.error(oldestInitiatorMessage, (Object)oldestInitiatorAge);
        } else if ((long)oldestInitiatorAge >= oldestInitiatedWarningThreshold) {
            LOG.warn(oldestInitiatorMessage, (Object)oldestInitiatorAge);
        }
    }

    private void logMultipleWorkerVersions(CompactionMetricData metricData) {
        long workerVersionThresholdInMillis = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_WORKER_DETECT_MULTIPLE_VERSION_THRESHOLD, (TimeUnit)TimeUnit.MILLISECONDS);
        List<String> versions = metricData.allWorkerVersionsSince(System.currentTimeMillis() - workerVersionThresholdInMillis);
        if (versions.size() > 1) {
            LOG.warn("Multiple Compaction Worker versions detected: {}", versions);
        }
    }

    private void logFailedCompactionsPercentage(CompactionMetricData metricData) {
        Double failedCompactionPercentage = metricData.getFailedCompactionPercentage();
        if (failedCompactionPercentage != null && failedCompactionPercentage >= MetastoreConf.getDoubleVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_FAILED_COMPACTION_RATIO_THRESHOLD)) {
            LOG.warn("Many compactions are failing. Check root cause of failed/not initiated compactions.");
        }
    }

    private void logDbMetrics() throws MetaException {
        MetricsInfo metrics = this.txnHandler.getMetricsInfo();
        if (metrics.getTxnToWriteIdCount() >= MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_TXN_TO_WRITEID_RECORD_THRESHOLD_WARNING) && metrics.getTxnToWriteIdCount() < MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_TXN_TO_WRITEID_RECORD_THRESHOLD_ERROR)) {
            LOG.warn("An excessive amount of (" + metrics.getTxnToWriteIdCount() + ") Hive ACID metadata found in TXN_TO_WRITEID table, which can cause serious performance degradation.");
        } else if (metrics.getTxnToWriteIdCount() >= MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_TXN_TO_WRITEID_RECORD_THRESHOLD_ERROR)) {
            LOG.error("An excessive amount of (" + metrics.getTxnToWriteIdCount() + ") Hive ACID metadata found in TXN_TO_WRITEID table, which can cause serious performance degradation.");
        }
        if (metrics.getCompletedTxnsCount() >= MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_COMPLETED_TXN_COMPONENTS_RECORD_THRESHOLD_WARNING) && metrics.getCompletedTxnsCount() < MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_COMPLETED_TXN_COMPONENTS_RECORD_THRESHOLD_ERROR)) {
            LOG.warn("An excessive amount of (" + metrics.getCompletedTxnsCount() + ") Hive ACID metadata found in COMPLETED_TXN_COMPONENTS table, which can cause serious performance degradation.");
        } else if (metrics.getCompletedTxnsCount() >= MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_COMPLETED_TXN_COMPONENTS_RECORD_THRESHOLD_ERROR)) {
            LOG.error("An excessive amount of (" + metrics.getCompletedTxnsCount() + ") Hive ACID metadata found in COMPLETED_TXN_COMPONENTS table, which can cause serious performance degradation.");
        }
        if ((long)metrics.getOldestOpenReplTxnAge() >= MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_REPLICATION_OPENTXN_THRESHOLD_WARNING, (TimeUnit)TimeUnit.SECONDS) && (long)metrics.getOldestOpenReplTxnAge() < MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_REPLICATION_OPENTXN_THRESHOLD_ERROR, (TimeUnit)TimeUnit.SECONDS)) {
            LOG.warn("A replication transaction with ID " + metrics.getOldestOpenReplTxnId() + " has been open for " + metrics.getOldestOpenReplTxnAge() + " seconds. Before you abort a transaction that was created by replication, and which has been open a long time, make sure that the hive.repl.txn.timeout threshold has expired.");
        } else if ((long)metrics.getOldestOpenReplTxnAge() >= MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_REPLICATION_OPENTXN_THRESHOLD_ERROR, (TimeUnit)TimeUnit.SECONDS)) {
            LOG.error("A replication transaction with ID " + metrics.getOldestOpenReplTxnId() + " has been open for " + metrics.getOldestOpenReplTxnAge() + " seconds. Before you abort a transaction that was created by replication, and which has been open a long time, make sure that the hive.repl.txn.timeout threshold has expired.");
        }
        if ((long)metrics.getOldestOpenNonReplTxnAge() >= MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_OPENTXN_THRESHOLD_WARNING, (TimeUnit)TimeUnit.SECONDS) && (long)metrics.getOldestOpenNonReplTxnAge() < MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_OPENTXN_THRESHOLD_ERROR, (TimeUnit)TimeUnit.SECONDS)) {
            LOG.warn("A non-replication transaction with ID " + metrics.getOldestOpenNonReplTxnId() + " has been open for " + metrics.getOldestOpenNonReplTxnAge() + " seconds.");
        } else if ((long)metrics.getOldestOpenNonReplTxnAge() >= MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_OPENTXN_THRESHOLD_ERROR, (TimeUnit)TimeUnit.SECONDS)) {
            LOG.error("A non-replication transaction with ID " + metrics.getOldestOpenNonReplTxnId() + " has been open for " + metrics.getOldestOpenNonReplTxnAge() + " seconds.");
        }
        if ((long)metrics.getOldestAbortedTxnAge() >= MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_UNCLEANED_ABORTEDTXN_TIME_THRESHOLD_WARNING, (TimeUnit)TimeUnit.SECONDS) && (long)metrics.getOldestAbortedTxnAge() < MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_UNCLEANED_ABORTEDTXN_TIME_THRESHOLD_ERROR, (TimeUnit)TimeUnit.SECONDS)) {
            LOG.warn("Found an aborted transaction with an ID " + metrics.getOldestAbortedTxnId() + " and age of " + metrics.getOldestAbortedTxnAge() + " seconds.");
        } else if ((long)metrics.getOldestAbortedTxnAge() >= MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_UNCLEANED_ABORTEDTXN_TIME_THRESHOLD_ERROR, (TimeUnit)TimeUnit.SECONDS)) {
            LOG.warn("Found an aborted transaction with an ID " + metrics.getOldestAbortedTxnId() + " and age of " + metrics.getOldestAbortedTxnAge() + " seconds.");
        }
        if (metrics.getTablesWithXAbortedTxnsCount() > MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_TABLES_WITH_ABORTEDTXN_THRESHOLD)) {
            LOG.error("Found " + metrics.getTablesWithXAbortedTxnsCount() + " tables/partitions with more than " + MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_TABLES_WITH_ABORTED_TXNS_THRESHOLD) + " aborts. Name of the tables/partitions are: " + metrics.getTablesWithXAbortedTxns());
        }
        if ((long)metrics.getOldestReadyForCleaningAge() > MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_OLDEST_UNCLEANED_COMPACTION_TIME_THRESHOLD, (TimeUnit)TimeUnit.SECONDS)) {
            LOG.warn("Found entry in compaction queue in ready for cleaning state with age of " + metrics.getOldestReadyForCleaningAge() + " seconds.");
        }
    }
}

