/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.leader;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;
import org.apache.hadoop.hive.metastore.leader.LeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticLeaderElection
implements LeaderElection<String> {
    private static final Logger LOG = LoggerFactory.getLogger(StaticLeaderElection.class);
    private volatile boolean isLeader;
    private String name;
    private List<LeaderElection.LeadershipStateListener> listeners = new ArrayList<LeaderElection.LeadershipStateListener>();

    @Override
    public void tryBeLeader(Configuration conf, String hostName) throws LeaderException {
        String leaderHost = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_HOSTNAME);
        if (leaderHost == null || leaderHost.isEmpty()) {
            LOG.info(MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_HOSTNAME + " is empty. Start all the housekeeping threads.");
            this.isLeader = true;
        } else {
            LOG.info(MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_HOSTNAME + " is set to " + leaderHost);
            this.isLeader = leaderHost.trim().equals(hostName);
        }
        if (this.isLeader) {
            this.listeners.forEach(listener -> {
                try {
                    listener.takeLeadership(this);
                }
                catch (Exception e) {
                    LOG.warn("Error while notifying the listener: " + listener, (Throwable)e);
                }
            });
        }
    }

    @Override
    public boolean isLeader() {
        return this.isLeader;
    }

    @Override
    public void addStateListener(LeaderElection.LeadershipStateListener listener) {
        Objects.requireNonNull(listener, "listener is null");
        this.listeners.add(listener);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        if (this.isLeader) {
            this.isLeader = false;
            this.listeners.forEach(listener -> {
                try {
                    listener.lossLeadership(this);
                }
                catch (Exception e) {
                    LOG.warn("Error while notifying the listener: " + listener, (Throwable)e);
                }
            });
        }
    }
}

