/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dataconnector.jdbc;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.dataconnector.AbstractDataConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDBCConnectorProvider
extends AbstractDataConnectorProvider {
    private static Logger LOG = LoggerFactory.getLogger(AbstractJDBCConnectorProvider.class);
    protected static Warehouse warehouse = null;
    public static final String JDBC_HIVE_STORAGE_HANDLER_ID = "org.apache.hive.storage.jdbc.JdbcStorageHandler";
    public static final String JDBC_CONFIG_PREFIX = "hive.sql";
    public static final String JDBC_CATALOG = "hive.sql.catalog";
    public static final String JDBC_SCHEMA = "hive.sql.schema";
    public static final String JDBC_TABLE = "hive.sql.table";
    public static final String JDBC_DATABASE_TYPE = "hive.sql.database.type";
    public static final String JDBC_URL = "hive.sql.jdbc.url";
    public static final String JDBC_DRIVER = "hive.sql.jdbc.driver";
    public static final String JDBC_USERNAME = "hive.sql.dbcp.username";
    public static final String JDBC_PASSWORD = "hive.sql.dbcp.password";
    public static final String JDBC_KEYSTORE = "hive.sql.dbcp.password.keystore";
    public static final String JDBC_KEY = "hive.sql.dbcp.password.key";
    public static final String JDBC_QUERY = "hive.sql.query";
    public static final String JDBC_QUERY_FIELD_NAMES = "hive.sql.query.fieldNames";
    public static final String JDBC_QUERY_FIELD_TYPES = "hive.sql.query.fieldTypes";
    public static final String JDBC_SPLIT_QUERY = "hive.sql.query.split";
    public static final String JDBC_PARTITION_COLUMN = "hive.sql.partitionColumn";
    public static final String JDBC_NUM_PARTITIONS = "hive.sql.numPartitions";
    public static final String JDBC_LOW_BOUND = "hive.sql.lowerBound";
    public static final String JDBC_UPPER_BOUND = "hive.sql.upperBound";
    public static final String JDBC_CONNECTOR_PREFIX = "hive.connector.";
    private static final String JDBC_INPUTFORMAT_CLASS = "org.apache.hive.storage.jdbc.JdbcInputFormat".intern();
    private static final String JDBC_OUTPUTFORMAT_CLASS = "org.apache.hive.storage.jdbc.JdbcOutputFormat".intern();
    String type = null;
    String jdbcUrl = null;
    String username = null;
    String password = null;
    Map<String, String> connectorPropMap = new HashMap<String, String>();

    public AbstractJDBCConnectorProvider(String dbName, DataConnector dataConn, String driverClass) {
        super(dbName, dataConn, driverClass);
        this.type = this.connector.getType().toUpperCase();
        this.jdbcUrl = this.connector.getUrl();
        this.username = (String)this.connector.getParameters().get(JDBC_USERNAME);
        this.password = (String)this.connector.getParameters().get(JDBC_PASSWORD);
        this.connector.getParameters().forEach((k, v) -> {
            if (k.startsWith(JDBC_CONNECTOR_PREFIX)) {
                this.connectorPropMap.put(k.substring(15), (String)v);
            }
        });
        if (this.password == null) {
            String keystore = (String)this.connector.getParameters().get(JDBC_KEYSTORE);
            String key = (String)this.connector.getParameters().get(JDBC_KEY);
            try {
                char[] keyValue = MetastoreConf.getValueFromKeystore((String)keystore, (String)key);
                if (keyValue != null) {
                    this.password = new String(keyValue);
                }
            }
            catch (IOException i) {
                LOG.warn("Could not read key value from keystore");
            }
        }
        try {
            warehouse = new Warehouse(MetastoreConf.newMetastoreConf());
        }
        catch (MetaException keystore) {
            // empty catch block
        }
        try {
            Class.forName(this.driverClassName);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.warn("Driver class not found in classpath: {}" + this.driverClassName);
            throw new RuntimeException("Driver class not found:" + driverClass.getClass().getName(), cnfe);
        }
    }

    @Override
    public void open() throws ConnectException {
        try {
            this.close();
            this.handle = DriverManager.getDriver(this.jdbcUrl).connect(this.jdbcUrl, this.getConnectionProperties());
        }
        catch (SQLException sqle) {
            LOG.warn("Could not connect to remote data source at {}", (Object)this.jdbcUrl);
            throw new ConnectException("Could not connect to remote datasource at " + this.jdbcUrl + ",cause:" + sqle.getMessage());
        }
    }

    protected Connection getConnection() {
        try {
            if (!this.isOpen()) {
                this.open();
            }
        }
        catch (ConnectException ce) {
            throw new RuntimeException(ce.getMessage(), ce);
        }
        if (this.handle instanceof Connection) {
            return (Connection)this.handle;
        }
        throw new RuntimeException("unexpected type for connection handle");
    }

    protected boolean isOpen() {
        try {
            if (this.handle instanceof Connection) {
                return ((Connection)this.handle).isValid(3);
            }
        }
        catch (SQLException e) {
            LOG.warn("Could not validate jdbc connection to " + this.jdbcUrl, (Throwable)e);
        }
        return false;
    }

    protected boolean isClosed() {
        try {
            if (this.handle instanceof Connection) {
                return ((Connection)this.handle).isClosed();
            }
        }
        catch (SQLException e) {
            LOG.warn("Could not determine whether jdbc connection, to {}, is closed or not: {} ", (Object)this.jdbcUrl, (Object)e);
        }
        return true;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            try {
                ((Connection)this.handle).close();
            }
            catch (SQLException sqle) {
                LOG.warn("Could not close jdbc connection to {}: {}", (Object)this.jdbcUrl, (Object)sqle);
                throw new RuntimeException(sqle);
            }
        }
    }

    @Override
    public List<Table> getTables(String regex) throws MetaException {
        ResultSet rs = null;
        try {
            rs = this.fetchTablesViaDBMetaData(regex);
            if (rs != null) {
                ArrayList<Table> tables = new ArrayList<Table>();
                while (rs.next()) {
                    try {
                        tables.add(this.getTable(rs.getString(3)));
                    }
                    catch (MetaException metaException) {}
                }
                ArrayList<Table> arrayList = tables;
                return arrayList;
            }
        }
        catch (SQLException sqle) {
            LOG.warn("Could not retrieve tables from remote datasource, cause: {}", (Object)sqle.getMessage());
            throw new MetaException("Error retrieving remote table:" + sqle);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public List<String> getTableNames() throws MetaException {
        ResultSet rs = null;
        try {
            rs = this.fetchTablesViaDBMetaData(null);
            if (rs != null) {
                ArrayList<String> tables = new ArrayList<String>();
                while (rs.next()) {
                    tables.add(rs.getString(3));
                }
                ArrayList<String> arrayList = tables;
                return arrayList;
            }
        }
        catch (SQLException sqle) {
            LOG.warn("Could not retrieve table names from remote datasource, cause: {}", (Object)sqle.getMessage());
            throw new MetaException("Error retrieving remote table:" + sqle);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected ResultSet fetchTableMetadata(String tableName) throws MetaException {
        ResultSet rs = null;
        try {
            rs = this.getConnection().getMetaData().getTables(this.getCatalogName(), this.getDatabaseName(), null, new String[]{"TABLE"});
        }
        catch (SQLException sqle) {
            LOG.warn("Could not retrieve table names from remote datasource, cause: {}", (Object)sqle.getMessage());
            throw new MetaException("Could not retrieve table names from remote datasource, cause:" + sqle.getMessage());
        }
        return rs;
    }

    protected ResultSet fetchTableNames() throws MetaException {
        ResultSet rs = null;
        try {
            rs = this.getConnection().getMetaData().getTables(this.getCatalogName(), this.getDatabaseName(), null, new String[]{"TABLE"});
        }
        catch (SQLException sqle) {
            LOG.warn("Could not retrieve table names from remote datasource, cause: {}", (Object)sqle.getMessage());
            throw new MetaException("Could not retrieve table names from remote datasource, cause:" + sqle);
        }
        return rs;
    }

    protected abstract String getCatalogName();

    protected abstract String getDatabaseName();

    @Override
    public Table getTable(String tableName) throws MetaException {
        Table table;
        ResultSet rs = null;
        Table table2 = null;
        try {
            String typename;
            rs = this.fetchColumnsViaDBMetaData(tableName);
            ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
            while (rs.next()) {
                typename = rs.getString("TYPE_NAME");
                FieldSchema fs = new FieldSchema();
                fs.setName(rs.getString("COLUMN_NAME"));
                fs.setType(this.getDataType(rs.getString("TYPE_NAME"), rs.getInt("COLUMN_SIZE")));
                fs.setComment("inferred column type");
                cols.add(fs);
            }
            if (cols.size() == 0) {
                typename = null;
                return typename;
            }
            table2 = this.buildTableFromColsList(tableName, cols);
            table2.getParameters().put(JDBC_DATABASE_TYPE, this.getDatasourceType());
            table2.getParameters().put(JDBC_DRIVER, this.driverClassName);
            table2.getParameters().put(JDBC_TABLE, tableName);
            table2.getParameters().put(JDBC_SCHEMA, this.scoped_db);
            table2.getParameters().put(JDBC_URL, this.jdbcUrl);
            table2.getParameters().put("storage_handler", JDBC_HIVE_STORAGE_HANDLER_ID);
            table2.getParameters().put("EXTERNAL", "TRUE");
            Map connectorParams = this.connector.getParameters();
            for (String param : connectorParams.keySet()) {
                if (!param.startsWith(JDBC_CONFIG_PREFIX)) continue;
                table2.getParameters().put(param, connectorParams.get(param));
            }
            table = table2;
        }
        catch (Exception e) {
            LOG.warn("Exception retrieving remote table {}.{} via data connector {}", new Object[]{this.scoped_db, tableName, this.connector.getName()});
            throw new MetaException("Error retrieving remote table:" + e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
        return table;
    }

    private ResultSet fetchTablesViaDBMetaData(String regex) throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.getConnection().getMetaData().getTables(this.getCatalogName(), this.getDatabaseName(), regex, new String[]{"TABLE"});
        }
        catch (SQLException sqle) {
            LOG.warn("Could not retrieve tables from JDBC table, cause: {}", (Object)sqle.getMessage());
            throw sqle;
        }
        return rs;
    }

    private ResultSet fetchColumnsViaDBMetaData(String tableName) throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.getConnection().getMetaData().getColumns(this.getCatalogName(), this.getDatabaseName(), tableName, null);
        }
        catch (SQLException sqle) {
            LOG.warn("Could not retrieve columns from JDBC table, cause: {}", (Object)sqle.getMessage());
            throw sqle;
        }
        return rs;
    }

    protected String wrapSize(int size) {
        return "(" + size + ")";
    }

    protected String getDataType(String mySqlType, int size) {
        switch (mySqlType.toLowerCase()) {
            case "char": {
                return "char" + this.wrapSize(size);
            }
            case "varchar": 
            case "tinytext": {
                return "varchar" + this.wrapSize(size);
            }
            case "text": 
            case "mediumtext": 
            case "enum": 
            case "set": 
            case "tsvector": 
            case "tsquery": 
            case "uuid": 
            case "json": {
                return "string";
            }
            case "blob": 
            case "mediumblob": 
            case "longblob": 
            case "bytea": 
            case "binary": 
            case "varbinary": 
            case "binary varying": {
                return "binary";
            }
            case "tinyint": {
                return "tinyint";
            }
            case "smallint": 
            case "smallserial": {
                return "smallint";
            }
            case "mediumint": 
            case "int": 
            case "serial": {
                return "int";
            }
            case "bigint": 
            case "bigserial": 
            case "money": {
                return "bigint";
            }
            case "float": 
            case "real": {
                return "float";
            }
            case "double": 
            case "double precision": {
                return "double";
            }
            case "decimal": 
            case "numeric": {
                return "decimal";
            }
            case "date": {
                return "date";
            }
            case "datetime": {
                return "datetime";
            }
            case "timestamp": 
            case "time": 
            case "interval": {
                return "timestamp";
            }
            case "timestampz": 
            case "timez": {
                return "timestamp with time zone";
            }
            case "bool": 
            case "boolean": {
                return "boolean";
            }
        }
        return "void";
    }

    @Override
    protected String getInputClass() {
        return JDBC_INPUTFORMAT_CLASS;
    }

    @Override
    protected String getOutputClass() {
        return JDBC_OUTPUTFORMAT_CLASS;
    }

    @Override
    protected String getTableLocation(String tableName) {
        if (warehouse != null) {
            try {
                return warehouse.getDefaultTablePath(this.scoped_db, tableName, true).toString();
            }
            catch (MetaException e) {
                LOG.info("Error determining default table path, cause: {}", (Object)e.getMessage());
            }
        }
        return "some_dummy_path";
    }

    protected Properties getConnectionProperties() {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("user", this.username);
        connectionProperties.setProperty("password", this.password);
        this.connectorPropMap.forEach((k, v) -> connectionProperties.put(k, v));
        return connectionProperties;
    }

    @Override
    protected String getDatasourceType() {
        return this.type;
    }
}

