/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth.jwt;

import com.google.common.base.Preconditions;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.auth.jwt.URLBasedJWKSProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTValidator {
    private static final Logger LOG = LoggerFactory.getLogger((String)JWTValidator.class.getName());
    private static final DefaultJWSVerifierFactory JWS_VERIFIER_FACTORY = new DefaultJWSVerifierFactory();
    private final URLBasedJWKSProvider jwksProvider;

    public JWTValidator(Configuration conf) throws IOException, ParseException {
        this.jwksProvider = new URLBasedJWKSProvider(conf);
    }

    public String validateJWTAndExtractUser(String signedJwt) throws ParseException, AuthenticationException {
        Date now;
        Preconditions.checkNotNull((Object)this.jwksProvider);
        Preconditions.checkNotNull((Object)signedJwt, (Object)"No token found");
        SignedJWT parsedJwt = SignedJWT.parse((String)signedJwt);
        List<JWK> matchedJWKS = this.jwksProvider.getJWKs(parsedJwt.getHeader());
        if (matchedJWKS.isEmpty()) {
            throw new AuthenticationException("Failed to find matched JWKs with the JWT header: " + parsedJwt.getHeader());
        }
        Exception lastException = null;
        for (JWK matchedJWK : matchedJWKS) {
            String keyID = matchedJWK.getKeyID() == null ? "null" : matchedJWK.getKeyID();
            try {
                JWSVerifier verifier = JWTValidator.getVerifier(parsedJwt.getHeader(), matchedJWK);
                if (!parsedJwt.verify(verifier)) continue;
                LOG.debug("Verified JWT {} by JWK {}", (Object)parsedJwt.getPayload(), (Object)keyID);
                break;
            }
            catch (Exception e) {
                lastException = e;
                LOG.warn("Failed to verify JWT {} by JWK {}", new Object[]{parsedJwt.getPayload(), keyID, e});
            }
        }
        int startIndex = Math.max(0, signedJwt.length() - 7);
        String lastSevenChars = signedJwt.substring(startIndex);
        if (parsedJwt.getState() != JWSObject.State.VERIFIED) {
            throw new AuthenticationException("Failed to verify the JWT signature (ends with " + lastSevenChars + ")", lastException);
        }
        JWTClaimsSet claimsSet = parsedJwt.getJWTClaimsSet();
        Date expirationTime = claimsSet.getExpirationTime();
        if (expirationTime != null && (now = new Date()).after(expirationTime)) {
            LOG.warn("Rejecting an expired JWT: {}", (Object)parsedJwt.getPayload());
            throw new AuthenticationException("JWT (ends with " + lastSevenChars + ") has been expired");
        }
        return claimsSet.getSubject();
    }

    private static JWSVerifier getVerifier(JWSHeader header, JWK jwk) throws JOSEException {
        Preconditions.checkArgument((boolean)(jwk instanceof AsymmetricJWK), (Object)"JWT signature verification with symmetric key is not allowed.");
        PublicKey key = ((AsymmetricJWK)jwk).toPublicKey();
        return JWS_VERIFIER_FACTORY.createJWSVerifier(header, (Key)key);
    }
}

