/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.MetastoreDirectSqlUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionProjectionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionProjectionEvaluator.class);
    private final boolean convertMapNullsToEmptyStrings;
    private final boolean isView;
    private final String includeParamKeyPattern;
    private final String excludeParamKeyPattern;
    private Set<String> projectionFields;
    private final ImmutableMap<String, MutivaluedFieldSetter> multiValuedFieldSetters = new ImmutableMap.Builder().put((Object)"values", (Object)new PartitionValuesSetter()).put((Object)"parameters", (Object)new PartitionParametersSetter()).put((Object)"sd.cols", (Object)new PartitionSDColsSetter()).put((Object)"sd.bucketCols", (Object)new PartitionSDBucketColsSetter()).put((Object)"sd.sortCols", (Object)new PartitionSortColsSetter()).put((Object)"sd.parameters", (Object)new PartitionSDParametersSetter()).put((Object)"sd.serdeInfo.parameters", (Object)new PartitionSerdeInfoParametersSetter()).put((Object)"sd.skewedInfo.skewedColNames", (Object)new PartitionSkewedColsNamesSetter()).put((Object)"sd.skewedInfo.skewedColValues", (Object)new PartitionSkewedColsValuesSetter()).put((Object)"sd.skewedInfo.skewedColValueLocationMaps", (Object)new PartitionSkewedColValLocationMapSetter()).build();
    private static final String PART_ID = "PART_ID";
    private static final String SD_ID = "SD_ID";
    private static final String SERDE_ID = "SERDE_ID";
    private static final String CD_ID = "CD_ID";
    private static final PartitionFieldNode partIdNode = new PartitionFieldNode("PART_ID");
    private static final PartitionFieldNode sdIdNode = new PartitionFieldNode("SD_ID");
    private static final PartitionFieldNode serdeIdNode = new PartitionFieldNode("SERDE_ID");
    private static final PartitionFieldNode cdIdNode = new PartitionFieldNode("CD_ID");
    private final ImmutableMap<String, String> fieldNameToTableName;
    private final Set<PartitionFieldNode> roots;
    private final String PARTITIONS;
    private final String SDS;
    private final String SERDES;
    private final String PARTITION_PARAMS;
    private final PersistenceManager pm;
    @VisibleForTesting
    static final String SD_PATTERN = "sd|sd\\.";
    @VisibleForTesting
    static final String SERDE_PATTERN = "sd\\.serdeInfo|sd\\.serdeInfo\\.";
    @VisibleForTesting
    static final String CD_PATTERN = "sd\\.cols|sd\\.cols\\.";
    private static final int SD_INDEX = 0;
    private static final int CD_INDEX = 1;
    private static final int SERDE_INDEX = 2;
    private static final int PART_INDEX = 3;
    private static final ImmutableMap<String, String> allPartitionSingleValuedFields = new ImmutableMap.Builder().put((Object)"dbName", (Object)"table.database.name").put((Object)"tableName", (Object)"table.tableName").put((Object)"createTime", (Object)"createTime").put((Object)"lastAccessTime", (Object)"lastAccessTime").put((Object)"sd.location", (Object)"sd.location").put((Object)"sd.inputFormat", (Object)"sd.inputFormat").put((Object)"sd.outputFormat", (Object)"sd.outputFormat").put((Object)"sd.compressed", (Object)"sd.isCompressed").put((Object)"sd.numBuckets", (Object)"sd.numBuckets").put((Object)"sd.serdeInfo.name", (Object)"sd.serDeInfo.name").put((Object)"sd.serdeInfo.serializationLib", (Object)"sd.serDeInfo.serializationLib").put((Object)"sd.serdeInfo.description", (Object)"sd.serDeInfo.description").put((Object)"sd.serdeInfo.serializerClass", (Object)"sd.serDeInfo.serializerClass").put((Object)"sd.serdeInfo.deserializerClass", (Object)"sd.serDeInfo.deserializerClass").put((Object)"sd.serdeInfo.serdeType", (Object)"sd.serDeInfo.serdeType").put((Object)"catName", (Object)"table.database.catalogName").put((Object)"writeId", (Object)"writeId").build();
    private static final ImmutableSet<String> allPartitionMultiValuedFields = new ImmutableSet.Builder().add((Object)"values").add((Object)"sd.cols.name").add((Object)"sd.cols.type").add((Object)"sd.cols.comment").add((Object)"sd.serdeInfo.parameters").add((Object)"sd.bucketCols").add((Object)"sd.sortCols.col").add((Object)"sd.sortCols.order").add((Object)"sd.parameters").add((Object)"sd.skewedInfo.skewedColNames").add((Object)"sd.skewedInfo.skewedColValues").add((Object)"sd.skewedInfo.skewedColValueLocationMaps").add((Object)"parameters").add((Object)"privileges.userPrivileges").add((Object)"privileges.groupPrivileges").add((Object)"privileges.rolePrivileges").build();
    private static final ImmutableSet<String> allPartitionFields = new ImmutableSet.Builder().addAll((Iterable)allPartitionSingleValuedFields.keySet()).addAll(allPartitionMultiValuedFields).build();
    private static final String SPACE = " ";

    public PartitionProjectionEvaluator(PersistenceManager pm, ImmutableMap<String, String> fieldNameToTableName, List<String> projectionFields, boolean convertMapNullsToEmptyStrings, boolean isView, String includeParamKeyPattern, String excludeParamKeyPattern) throws MetaException {
        this.pm = pm;
        this.fieldNameToTableName = fieldNameToTableName;
        this.convertMapNullsToEmptyStrings = convertMapNullsToEmptyStrings;
        this.isView = isView;
        this.includeParamKeyPattern = includeParamKeyPattern;
        this.excludeParamKeyPattern = excludeParamKeyPattern;
        this.PARTITIONS = fieldNameToTableName.containsKey((Object)"PARTITIONS_TABLE_NAME") ? (String)fieldNameToTableName.get((Object)"PARTITIONS_TABLE_NAME") : "\"PARTITIONS\"";
        this.SDS = fieldNameToTableName.containsKey((Object)"SDS_TABLE_NAME") ? (String)fieldNameToTableName.get((Object)"SDS_TABLE_NAME") : "\"SDS\"";
        this.SERDES = fieldNameToTableName.containsKey((Object)"SERDES_TABLE_NAME") ? (String)fieldNameToTableName.get((Object)"SERDES_TABLE_NAME") : "\"SERDES\"";
        this.PARTITION_PARAMS = fieldNameToTableName.containsKey((Object)"PARTITION_PARAMS") ? (String)fieldNameToTableName.get((Object)"PARTITION_PARAMS") : "\"PARTITION_PARAMS\"";
        this.roots = this.parse(projectionFields);
        this.roots.add(partIdNode);
        if (this.find(SD_PATTERN)) {
            this.roots.add(sdIdNode);
        }
        if (this.find(SERDE_PATTERN)) {
            this.roots.add(serdeIdNode);
        }
        if (this.find(CD_PATTERN)) {
            this.roots.add(cdIdNode);
        }
    }

    @VisibleForTesting
    boolean find(String searchField) {
        Pattern p = Pattern.compile(searchField);
        for (PartitionFieldNode node : this.roots) {
            if (!PartitionProjectionEvaluator.find(node, p)) continue;
            return true;
        }
        return false;
    }

    private static boolean find(PartitionFieldNode root, Pattern p) {
        if (root == null) {
            return false;
        }
        if (p.matcher(root.fieldName).matches()) {
            return true;
        }
        for (PartitionFieldNode child : root.children) {
            if (!PartitionProjectionEvaluator.find(child, p)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> expand(Collection<String> projectionList) throws MetaException {
        HashSet<String> result = new HashSet<String>();
        for (String projectedField : projectionList) {
            if (allPartitionFields.contains((Object)projectedField)) {
                result.add(projectedField);
                continue;
            }
            boolean found = false;
            for (String partitionField : allPartitionFields) {
                if (!partitionField.startsWith(projectedField)) continue;
                LOG.debug("Found " + partitionField + " included within given projection field " + projectedField);
                result.add(partitionField);
                found = true;
            }
            if (found) continue;
            throw new MetaException("Invalid field name " + projectedField);
        }
        return result;
    }

    @VisibleForTesting
    Set<PartitionFieldNode> getRoots() {
        return this.roots;
    }

    private static void validate(Collection<String> projectionFields) throws MetaException {
        HashSet<String> verify = new HashSet<String>(projectionFields);
        verify.removeAll((Collection<?>)allPartitionFields);
        if (verify.size() > 0) {
            throw new MetaException("Invalid partition fields in the projection spec" + Arrays.toString(verify.toArray(new String[verify.size()])));
        }
    }

    private Set<PartitionFieldNode> parse(List<String> inputProjectionFields) throws MetaException {
        this.projectionFields = new HashSet<String>(inputProjectionFields);
        this.projectionFields.remove("dbName");
        this.projectionFields.remove("tableName");
        this.projectionFields.remove("catName");
        if (this.isView) {
            this.projectionFields.removeIf(s -> s.matches(SD_PATTERN) || s.matches(SERDE_PATTERN) || s.matches(CD_PATTERN));
        }
        this.projectionFields = PartitionProjectionEvaluator.expand(this.projectionFields);
        this.removeUnsupportedFields();
        PartitionProjectionEvaluator.validate(this.projectionFields);
        HashMap<String, PartitionFieldNode> nestedNodes = new HashMap<String, PartitionFieldNode>();
        HashSet<PartitionFieldNode> rootNodes = new HashSet<PartitionFieldNode>();
        for (String projectedField : this.projectionFields) {
            String[] fields = projectedField.split("\\.");
            if (fields.length == 0) {
                LOG.warn("Invalid projected field {}. Ignoring ..", (Object)projectedField);
                continue;
            }
            StringBuilder fieldNameBuilder = new StringBuilder(fields[0]);
            PartitionFieldNode currentNode = this.createIfNotExists(nestedNodes, fieldNameBuilder.toString());
            rootNodes.add(currentNode);
            for (int level = 1; level < fields.length; ++level) {
                String name = fieldNameBuilder.append(".").append(fields[level]).toString();
                PartitionFieldNode childNode = this.createIfNotExists(nestedNodes, name);
                if (currentNode.isMultiValued) {
                    childNode.setMultiValued();
                }
                currentNode.addChild(childNode);
                currentNode = childNode;
            }
        }
        return rootNodes;
    }

    private void removeUnsupportedFields() {
        List<String> unsupportedFields = Arrays.asList("sd.serdeInfo.serializerClass", "sd.serdeInfo.deserializerClass", "sd.serdeInfo.serdeType", "sd.serdeInfo.description");
        for (String unsupportedField : unsupportedFields) {
            if (!this.projectionFields.contains(unsupportedField)) continue;
            LOG.warn("DirectSQL does not return partitions with the optional field" + unsupportedField + " set. Removing it from the projection list");
            this.projectionFields.remove(unsupportedField);
        }
    }

    private PartitionFieldNode createIfNotExists(Map<String, PartitionFieldNode> nestedNodes, String fieldName) {
        PartitionFieldNode currentNode = nestedNodes.computeIfAbsent(fieldName, k -> {
            if (this.multiValuedFieldSetters.containsKey((Object)fieldName)) {
                return new PartitionFieldNode(fieldName, true);
            }
            return new PartitionFieldNode(fieldName);
        });
        return currentNode;
    }

    public List<Partition> getPartitionsUsingProjectionList(List<Long> partitionIds) throws MetaException {
        TreeMap<Long, StorageDescriptor> sds = new TreeMap<Long, StorageDescriptor>();
        TreeMap<Long, List<FieldSchema>> cds = new TreeMap<Long, List<FieldSchema>>();
        TreeMap<Long, SerDeInfo> serdes = new TreeMap<Long, SerDeInfo>();
        TreeMap<Long, Partition> partitions = new TreeMap<Long, Partition>();
        List<Partition> results = this.setSingleValuedFields(partitionIds, partitions, sds, serdes, cds);
        this.setMultivaluedFields(partitions, sds, serdes, cds);
        return results;
    }

    private List<Partition> setSingleValuedFields(List<Long> partitionIds, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sdIds, TreeMap<Long, SerDeInfo> serdeIds, TreeMap<Long, List<FieldSchema>> cdIds) throws MetaException {
        StringBuilder queryTextBuilder = new StringBuilder();
        int numColumns = this.buildQueryForSingleValuedFields(partitionIds, queryTextBuilder);
        String queryText = queryTextBuilder.toString();
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        try {
            long start = LOG.isDebugEnabled() ? System.nanoTime() : 0L;
            List sqlResult = (List)MetastoreDirectSqlUtils.executeWithArray(query, null, queryText);
            long queryTime = LOG.isDebugEnabled() ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(LOG.isDebugEnabled(), queryText, start, queryTime);
            Deadline.checkTimeout();
            final Long[] ids = new Long[4];
            Object[] rowVals = new Object[1];
            ArrayList<Partition> orderedResult = new ArrayList<Partition>(partitionIds.size());
            for (Object row : sqlResult) {
                if (numColumns > 1) {
                    rowVals = (Object[])row;
                } else {
                    rowVals[0] = row;
                }
                Partition part = new Partition();
                for (PartitionFieldNode root : this.roots) {
                    this.traverseAndSetValues(part, root, rowVals, new PartitionFieldValueSetter(){

                        public void setValue(Object partition, PartitionFieldNode node, Object value) throws MetaException {
                            if (!node.isMultiValued) {
                                if (node.equals(sdIdNode)) {
                                    ids[0] = MetastoreDirectSqlUtils.extractSqlLong(value);
                                } else if (node.equals(serdeIdNode)) {
                                    ids[2] = MetastoreDirectSqlUtils.extractSqlLong(value);
                                } else if (node.equals(cdIdNode)) {
                                    ids[1] = MetastoreDirectSqlUtils.extractSqlLong(value);
                                } else if (node.equals(partIdNode)) {
                                    ids[3] = MetastoreDirectSqlUtils.extractSqlLong(value);
                                } else {
                                    if (node.fieldName.equals("sd.compressed") || node.fieldName.equals("sd.storedAsSubDirectories")) {
                                        value = MetastoreDirectSqlUtils.extractSqlBoolean(value);
                                    } else if (node.fieldName.equals("lastAccessTime") || node.fieldName.equals("createTime")) {
                                        value = MetastoreDirectSqlUtils.extractSqlInt(value);
                                    }
                                    MetaStoreServerUtils.setNestedProperty(partition, node.fieldName, value, true);
                                }
                            }
                        }
                    });
                }
                if (ids[3] == null) {
                    throw new MetaException("Could not find PART_ID for partition " + part);
                }
                partitions.put(ids[3], part);
                orderedResult.add(part);
                ids[3] = null;
                if (ids[0] != null) {
                    if (part.getSd() == null) {
                        part.setSd(new StorageDescriptor());
                    }
                    sdIds.put(ids[0], part.getSd());
                    ids[0] = null;
                }
                if (ids[2] != null) {
                    if (part.getSd().getSerdeInfo() == null) {
                        part.getSd().setSerdeInfo(new SerDeInfo());
                    }
                    serdeIds.put(ids[2], part.getSd().getSerdeInfo());
                    ids[2] = null;
                }
                if (ids[1] != null) {
                    cdIds.putIfAbsent(ids[1], new ArrayList(5));
                    if (part.getSd().getCols() == null) {
                        part.getSd().setCols(cdIds.get(ids[1]));
                    }
                    ids[1] = null;
                }
                Deadline.checkTimeout();
            }
            ArrayList<Partition> arrayList = orderedResult;
            return arrayList;
        }
        catch (Exception e) {
            LOG.error("Exception received while getting partitions using projected fields", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        finally {
            query.closeAll();
        }
    }

    private void setMultivaluedFields(TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
        for (PartitionFieldNode root : this.roots) {
            this.traverseAndSetMultiValuedFields(root, partitions, sds, serdes, cds);
        }
    }

    private void traverseAndSetMultiValuedFields(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
        if (root == null) {
            return;
        }
        if (root.isMultiValued) {
            MutivaluedFieldSetter multiValuedFieldSetter = (MutivaluedFieldSetter)this.multiValuedFieldSetters.get((Object)root.fieldName);
            if (multiValuedFieldSetter == null) {
                throw new MetaException("Cannot find multi-valued field setter for field " + root.fieldName);
            }
            multiValuedFieldSetter.setValue(root, partitions, sds, serdes, cds);
        } else {
            for (PartitionFieldNode child : root.children) {
                this.traverseAndSetMultiValuedFields(child, partitions, sds, serdes, cds);
            }
        }
    }

    private void traverseAndSetValues(Partition part, PartitionFieldNode root, Object[] row, PartitionFieldValueSetter valueSetter) throws MetaException {
        if (root == null || root.isMultiValued()) {
            return;
        }
        if (root.isLeafNode()) {
            valueSetter.setValue(part, root, row[root.fieldIndex]);
            return;
        }
        for (PartitionFieldNode child : root.children) {
            this.traverseAndSetValues(part, child, row, valueSetter);
        }
    }

    private int buildQueryForSingleValuedFields(List<Long> partitionIds, StringBuilder queryTextBuilder) {
        queryTextBuilder.append("select ");
        List<String> columnList = this.getSingleValuedColumnNames(this.roots);
        queryTextBuilder.append(Joiner.on((char)',').join(columnList));
        queryTextBuilder.append(SPACE);
        queryTextBuilder.append("from " + this.PARTITIONS);
        boolean foundSD = false;
        if (this.find(SD_PATTERN)) {
            queryTextBuilder.append(SPACE);
            queryTextBuilder.append("left outer join " + this.SDS + " on " + this.PARTITIONS + ".\"SD_ID\" = " + this.SDS + ".\"SD_ID\"");
            foundSD = true;
        }
        if (foundSD || this.find(SERDE_PATTERN)) {
            queryTextBuilder.append(SPACE);
            queryTextBuilder.append("  left outer join " + this.SERDES + " on " + this.SDS + ".\"SERDE_ID\" = " + this.SERDES + ".\"SERDE_ID\"");
        }
        queryTextBuilder.append(SPACE);
        queryTextBuilder.append("where \"PART_ID\" in (" + Joiner.on((char)',').join(partitionIds) + ") order by \"PART_NAME\" asc");
        return columnList.size();
    }

    private int getSingleValuedColumnName(PartitionFieldNode root, int fieldId, List<String> columnNames) {
        if (root == null) {
            return fieldId;
        }
        if (root.isLeafNode() && !root.isMultiValued) {
            if (this.fieldNameToTableName.containsKey((Object)root.fieldName)) {
                columnNames.add((String)this.fieldNameToTableName.get((Object)root.fieldName));
                root.setFieldIndex(fieldId++);
                return fieldId;
            }
            throw new RuntimeException("No column name mapping found for partition field " + root.fieldName);
        }
        for (PartitionFieldNode child : root.children) {
            fieldId = this.getSingleValuedColumnName(child, fieldId, columnNames);
        }
        return fieldId;
    }

    private List<String> getSingleValuedColumnNames(Set<PartitionFieldNode> roots) {
        ArrayList<String> columnNames = new ArrayList<String>();
        int fieldIndex = 0;
        for (PartitionFieldNode node : roots) {
            fieldIndex = this.getSingleValuedColumnName(node, fieldIndex, columnNames);
        }
        return columnNames;
    }

    private static void getNestedFieldName(JsonNode jsonNode, String fieldName, Collection<String> results) {
        if (jsonNode instanceof ArrayNode) {
            Iterator elements = ((ArrayNode)jsonNode).elements();
            if (!elements.hasNext()) {
                results.add(fieldName);
                return;
            }
            while (elements.hasNext()) {
                JsonNode element = (JsonNode)elements.next();
                PartitionProjectionEvaluator.getNestedFieldName(element, fieldName, results);
            }
        } else {
            Iterator fields = jsonNode.fields();
            if (!fields.hasNext()) {
                results.add(fieldName);
                return;
            }
            while (fields.hasNext()) {
                Map.Entry fieldKV = (Map.Entry)fields.next();
                String key = (String)fieldKV.getKey();
                PartitionProjectionEvaluator.getNestedFieldName((JsonNode)fieldKV.getValue(), fieldName.length() == 0 ? key : fieldName + "." + key, results);
            }
        }
    }

    private List<String> getChildrenFieldNames(PartitionFieldNode root) throws MetaException {
        ArrayList<String> childFields = new ArrayList<String>(3);
        for (PartitionFieldNode child : root.getChildren()) {
            if (child.getFieldName().lastIndexOf(".") < 0) {
                throw new MetaException("Error parsing multi-valued field name " + child.getFieldName());
            }
            childFields.add(child.getFieldName().substring(child.getFieldName().lastIndexOf(".") + 1));
        }
        return childFields;
    }

    public static List<String> getMPartitionFieldNames(List<String> partitionFields) throws MetaException {
        if (partitionFields == null || partitionFields.isEmpty()) {
            return null;
        }
        PartitionProjectionEvaluator.validate(partitionFields);
        if (!allPartitionSingleValuedFields.keySet().containsAll(partitionFields)) {
            return null;
        }
        ArrayList<String> jdoFields = new ArrayList<String>(partitionFields.size());
        for (String partitionField : partitionFields) {
            jdoFields.add((String)allPartitionSingleValuedFields.get((Object)partitionField));
        }
        return jdoFields;
    }

    private class PartitionSkewedColValLocationMapSetter
    implements MutivaluedFieldSetter {
        private PartitionSkewedColValLocationMapSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String skewedStringListVals = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey((Object)"SKEWED_STRING_LIST_VALUES") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get((Object)"SKEWED_STRING_LIST_VALUES") : "\"SKEWED_STRING_LIST_VALUES\"";
            String skewedColValLocMap = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey((Object)"SKEWED_COL_VALUE_LOC_MAP") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get((Object)"SKEWED_COL_VALUE_LOC_MAP") : "\"SKEWED_COL_VALUE_LOC_MAP\"";
            MetastoreDirectSqlUtils.setSkewedColLocationMaps(skewedColValLocMap, skewedStringListVals, PartitionProjectionEvaluator.this.pm, sds, Joiner.on((char)',').join(sds.keySet()));
        }
    }

    private class PartitionSkewedColsValuesSetter
    implements MutivaluedFieldSetter {
        private PartitionSkewedColsValuesSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String skewedStringListVals = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey((Object)"SKEWED_STRING_LIST_VALUES") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get((Object)"SKEWED_STRING_LIST_VALUES") : "\"SKEWED_STRING_LIST_VALUES\"";
            String skewedVals = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey((Object)"SKEWED_VALUES") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get((Object)"SKEWED_VALUES") : "\"SKEWED_VALUES\"";
            MetastoreDirectSqlUtils.setSkewedColValues(skewedStringListVals, skewedVals, PartitionProjectionEvaluator.this.pm, sds, Joiner.on((char)',').join(sds.keySet()));
        }
    }

    private class PartitionSkewedColsNamesSetter
    implements MutivaluedFieldSetter {
        private PartitionSkewedColsNamesSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey((Object)"SKEWED_COL_NAMES") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get((Object)"SKEWED_COL_NAMES") : "\"SKEWED_COL_NAMES\"";
            MetastoreDirectSqlUtils.setSkewedColNames(tableName, PartitionProjectionEvaluator.this.pm, sds, Joiner.on((char)',').join(sds.keySet()));
        }
    }

    private class PartitionSerdeInfoParametersSetter
    implements MutivaluedFieldSetter {
        private PartitionSerdeInfoParametersSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey((Object)"SERDE_PARAMS") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get((Object)"SERDE_PARAMS") : "\"SERDE_PARAMS\"";
            MetastoreDirectSqlUtils.setSerdeParams(tableName, PartitionProjectionEvaluator.this.convertMapNullsToEmptyStrings, PartitionProjectionEvaluator.this.pm, serdes, Joiner.on((char)',').join(serdes.keySet()));
        }
    }

    private class PartitionSDParametersSetter
    implements MutivaluedFieldSetter {
        private PartitionSDParametersSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey((Object)"SD_PARAMS") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get((Object)"SD_PARAMS") : "\"SD_PARAMS\"";
            MetastoreDirectSqlUtils.setSDParameters(tableName, PartitionProjectionEvaluator.this.convertMapNullsToEmptyStrings, PartitionProjectionEvaluator.this.pm, sds, Joiner.on((char)',').join(sds.keySet()));
        }
    }

    private class PartitionSortColsSetter
    implements MutivaluedFieldSetter {
        private PartitionSortColsSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            List childFieldNames = PartitionProjectionEvaluator.this.getChildrenFieldNames(root);
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey((Object)"SORT_COLS") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get((Object)"SORT_COLS") : "\"SORT_COLS\"";
            MetastoreDirectSqlUtils.setSDSortCols(tableName, childFieldNames, PartitionProjectionEvaluator.this.pm, sds, Joiner.on((char)',').join(sds.keySet()));
        }
    }

    private class PartitionSDBucketColsSetter
    implements MutivaluedFieldSetter {
        private PartitionSDBucketColsSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey((Object)"BUCKETING_COLS") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get((Object)"BUCKETING_COLS") : "\"BUCKETING_COLS\"";
            MetastoreDirectSqlUtils.setSDBucketCols(tableName, PartitionProjectionEvaluator.this.pm, sds, Joiner.on((char)',').join(sds.keySet()));
        }
    }

    private class PartitionSDColsSetter
    implements MutivaluedFieldSetter {
        private PartitionSDColsSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            List childFields = PartitionProjectionEvaluator.this.getChildrenFieldNames(root);
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey((Object)"COLUMNS_V2") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get((Object)"COLUMNS_V2") : "\"COLUMNS_V2\"";
            MetastoreDirectSqlUtils.setSDCols(tableName, childFields, PartitionProjectionEvaluator.this.pm, cds, Joiner.on((char)',').join(cds.keySet()));
        }
    }

    private class PartitionParametersSetter
    implements MutivaluedFieldSetter {
        private PartitionParametersSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            MetastoreDirectSqlUtils.setPartitionParametersWithFilter(PartitionProjectionEvaluator.this.PARTITION_PARAMS, PartitionProjectionEvaluator.this.convertMapNullsToEmptyStrings, PartitionProjectionEvaluator.this.pm, Joiner.on((char)',').join(partitions.keySet()), partitions, PartitionProjectionEvaluator.this.includeParamKeyPattern, PartitionProjectionEvaluator.this.excludeParamKeyPattern);
        }
    }

    private class PartitionValuesSetter
    implements MutivaluedFieldSetter {
        private PartitionValuesSetter() {
        }

        @Override
        public void setValue(PartitionFieldNode root, TreeMap<Long, Partition> partitions, TreeMap<Long, StorageDescriptor> sds, TreeMap<Long, SerDeInfo> serdes, TreeMap<Long, List<FieldSchema>> cds) throws MetaException {
            String tableName = PartitionProjectionEvaluator.this.fieldNameToTableName.containsKey((Object)"PARTITION_KEY_VALS") ? (String)PartitionProjectionEvaluator.this.fieldNameToTableName.get((Object)"PARTITION_KEY_VALS") : "\"PARTITION_KEY_VALS\"";
            MetastoreDirectSqlUtils.setPartitionValues(tableName, PartitionProjectionEvaluator.this.pm, Joiner.on((char)',').join(partitions.keySet()), partitions);
        }
    }

    private static interface MutivaluedFieldSetter {
        public void setValue(PartitionFieldNode var1, TreeMap<Long, Partition> var2, TreeMap<Long, StorageDescriptor> var3, TreeMap<Long, SerDeInfo> var4, TreeMap<Long, List<FieldSchema>> var5) throws MetaException;
    }

    static class PartitionFieldNode {
        private String fieldName;
        private Set<PartitionFieldNode> children = new HashSet<PartitionFieldNode>(4);
        private boolean isMultiValued;
        private int fieldIndex;

        PartitionFieldNode(String fieldName) {
            this.fieldName = fieldName;
            this.isMultiValued = false;
        }

        PartitionFieldNode(String fieldName, boolean isMultiValued) {
            this.fieldName = fieldName;
            this.isMultiValued = isMultiValued;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionFieldNode that = (PartitionFieldNode)o;
            return Objects.equals(this.fieldName, that.fieldName);
        }

        boolean isLeafNode() {
            return this.children == null || this.children.isEmpty();
        }

        void setFieldIndex(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        @VisibleForTesting
        void addChild(PartitionFieldNode child) {
            this.children.add(child);
        }

        @VisibleForTesting
        String getFieldName() {
            return this.fieldName;
        }

        @VisibleForTesting
        Set<PartitionFieldNode> getChildren() {
            return new HashSet<PartitionFieldNode>(this.children);
        }

        @VisibleForTesting
        boolean isMultiValued() {
            return this.isMultiValued;
        }

        public String toString() {
            return this.fieldName;
        }

        public int hashCode() {
            return Objects.hash(this.fieldName);
        }

        void setMultiValued() {
            this.isMultiValued = true;
        }
    }

    static interface PartitionFieldValueSetter<T> {
        public void setValue(T var1, PartitionFieldNode var2, Object var3) throws MetaException;
    }
}

