/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.ServletSecurity;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet;

public class HmsThriftHttpServlet
extends TServlet {
    private final ServletSecurity security;

    public HmsThriftHttpServlet(TProcessor processor, TProtocolFactory protocolFactory, Configuration conf) {
        super(processor, protocolFactory);
        boolean jwt = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION).equalsIgnoreCase("jwt");
        this.security = new ServletSecurity(conf, jwt);
    }

    public void init() throws ServletException {
        super.init();
        this.security.init();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.security.execute(request, response, (q, a) -> super.doPost(q, a));
    }
}

