/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.apache.commons.cli.OptionBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ZKDeRegisterWatcher;
import org.apache.hadoop.hive.common.ZooKeeperHiveHelper;
import org.apache.hadoop.hive.metastore.AuthFactory;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.HMSHandlerProxyFactory;
import org.apache.hadoop.hive.metastore.HmsThriftHttpServlet;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.PropertyServlet;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.ServletSecurity;
import org.apache.hadoop.hive.metastore.TServerSocketKeepAlive;
import org.apache.hadoop.hive.metastore.TSetIpAddressProcessor;
import org.apache.hadoop.hive.metastore.TUGIBasedProcessor;
import org.apache.hadoop.hive.metastore.ThreadPool;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.CMClearer;
import org.apache.hadoop.hive.metastore.leader.CompactorPMF;
import org.apache.hadoop.hive.metastore.leader.CompactorTasks;
import org.apache.hadoop.hive.metastore.leader.HouseKeepingTasks;
import org.apache.hadoop.hive.metastore.leader.LeaderElectionContext;
import org.apache.hadoop.hive.metastore.leader.StatsUpdaterTask;
import org.apache.hadoop.hive.metastore.metrics.JvmPauseMonitor;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.security.MetastoreDelegationTokenManager;
import org.apache.hadoop.hive.metastore.utils.CommonCliOptions;
import org.apache.hadoop.hive.metastore.utils.LogUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.MetastoreVersionInfo;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStore
extends ThriftHiveMetastore {
    public static final Logger LOG = LoggerFactory.getLogger(HiveMetaStore.class);
    private static boolean isMetaStoreRemote = false;
    private static ShutdownHookManager shutdownHookMgr;
    public static final char MM_WRITE_OPEN = 'o';
    public static final char MM_WRITE_COMMITTED = 'c';
    public static final char MM_WRITE_ABORTED = 'a';
    static HadoopThriftAuthBridge.Server saslServer;
    private static MetastoreDelegationTokenManager delegationTokenManager;
    static boolean useSasl;
    private static ZooKeeperHiveHelper zooKeeperHelper;
    private static String msHost;
    private static ThriftServer thriftServer;
    private static Server propertyServer;

    public static Server getPropertyServer() {
        return propertyServer;
    }

    public static boolean isRenameAllowed(Database srcDB, Database destDB) {
        return srcDB.getName().equalsIgnoreCase(destDB.getName()) || !ReplChangeManager.isSourceOfReplication((Database)srcDB) && !ReplChangeManager.isSourceOfReplication((Database)destDB);
    }

    static ThriftHiveMetastore.Iface newHMSHandler(Configuration conf) throws MetaException {
        HMSHandler baseHandler = new HMSHandler("hive client", conf);
        return HMSHandlerProxyFactory.getProxy(conf, baseHandler, true);
    }

    public static void cancelDelegationToken(String tokenStrForm) throws IOException {
        delegationTokenManager.cancelDelegationToken(tokenStrForm);
    }

    public static String getDelegationToken(String owner, String renewer, String remoteAddr) throws IOException, InterruptedException {
        return delegationTokenManager.getDelegationToken(owner, renewer, remoteAddr);
    }

    public static boolean isMetaStoreRemote() {
        return isMetaStoreRemote;
    }

    public static long renewDelegationToken(String tokenStrForm) throws IOException {
        return delegationTokenManager.renewDelegationToken(tokenStrForm);
    }

    public static void main(String[] args) throws Throwable {
        Configuration conf = MetastoreConf.newMetastoreConf();
        shutdownHookMgr = ShutdownHookManager.get();
        HiveMetastoreCli cli = new HiveMetastoreCli(conf);
        cli.parse(args);
        boolean isCliVerbose = cli.isVerbose();
        Properties hiveconf = cli.addHiveconfToSystemProperties();
        try {
            if (System.getProperty("log4j.configurationFile") == null) {
                LogUtils.initHiveLog4j(conf);
            } else {
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.reconfigure();
            }
        }
        catch (LogUtils.LogInitializationException e) {
            LOG.warn(e.getMessage());
        }
        HiveMetaStore.startupShutdownMessage(HiveMetaStore.class, args, LOG);
        try {
            String msg = "Starting hive metastore on port " + cli.port;
            LOG.info(msg);
            if (cli.isVerbose()) {
                System.err.println(msg);
            }
            for (Map.Entry<Object, Object> item : hiveconf.entrySet()) {
                conf.set((String)item.getKey(), (String)item.getValue());
            }
            conf.set(MetastoreConf.ConfVars.THRIFT_URIS.getHiveName(), "");
            shutdownHookMgr.addShutdownHook(() -> {
                String shutdownMsg = "Shutting down hive metastore at " + HiveMetaStore.getHostname();
                LOG.info(shutdownMsg);
                if (isCliVerbose) {
                    System.err.println(shutdownMsg);
                }
                if (MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED)) {
                    try {
                        Metrics.shutdown();
                    }
                    catch (Exception e) {
                        LOG.error("error in Metrics deinit: " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    if (MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_SERVICE_DISCOVERY_MODE).equalsIgnoreCase("zookeeper")) {
                        zooKeeperHelper.removeServerInstanceFromZooKeeper();
                    }
                }
                catch (Exception e) {
                    LOG.error("Error removing znode for this metastore instance from ZooKeeper.", (Throwable)e);
                }
                ThreadPool.shutdown();
            }, 10);
            if (MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED)) {
                try {
                    Metrics.initialize(conf);
                }
                catch (Exception e) {
                    LOG.error("error in Metrics init: " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
                }
            }
            HiveMetaStore.startMetaStore(cli.getPort(), HadoopThriftAuthBridge.getBridge(), conf, true, null);
        }
        catch (Throwable t) {
            LOG.error("Metastore Thrift Server threw an exception...", t);
            throw t;
        }
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge) throws Throwable {
        HiveMetaStore.startMetaStore(port, bridge, MetastoreConf.newMetastoreConf(), false, null);
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge, Configuration conf) throws Throwable {
        HiveMetaStore.startMetaStore(port, bridge, conf, false, null);
    }

    private static ThriftServer startHttpMetastore(final int port, Configuration conf) throws Exception {
        LOG.info("Attempting to start http metastore server on port: {}", (Object)port);
        ServletSecurity.loginServerPincipal(conf);
        long maxMessageSize = MetastoreConf.getLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERVER_MAX_MESSAGE_SIZE);
        final int minWorkerThreads = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERVER_MIN_THREADS);
        final int maxWorkerThreads = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERVER_MAX_THREADS);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(minWorkerThreads, maxWorkerThreads, 60L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("Metastore-HttpHandler-Pool: Thread-" + thread.getId());
            return thread;
        }){

            @Override
            public void setThreadFactory(ThreadFactory threadFactory) {
                LOG.warn("Ignore setting the thread factory as the pool has already provided his own: {}", (Object)this.getThreadFactory());
            }
        };
        ExecutorThreadPool threadPool = new ExecutorThreadPool(executorService);
        final Server server = new Server((org.eclipse.jetty.util.thread.ThreadPool)threadPool);
        server.setStopAtShutdown(true);
        HttpConfiguration httpServerConf = new HttpConfiguration();
        httpServerConf.setRequestHeaderSize(MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_THRIFT_HTTP_REQUEST_HEADER_SIZE));
        httpServerConf.setResponseHeaderSize(MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_THRIFT_HTTP_RESPONSE_HEADER_SIZE));
        HttpConnectionFactory http = new HttpConnectionFactory(httpServerConf);
        final SslContextFactory sslContextFactory = ServletSecurity.createSslContextFactory(conf);
        ServerConnector connector = sslContextFactory != null ? new ServerConnector(server, sslContextFactory, new ConnectionFactory[]{http}) : new ServerConnector(server, new ConnectionFactory[]{http});
        connector.setPort(port);
        connector.setReuseAddress(true);
        long maxIdleTimeout = MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_THRIFT_HTTP_MAX_IDLE_TIME, (TimeUnit)TimeUnit.MILLISECONDS);
        connector.setIdleTimeout(maxIdleTimeout);
        connector.setAcceptQueueSize(maxWorkerThreads);
        server.addConnector((Connector)connector);
        boolean useCompactProtocol = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_THRIFT_COMPACT_PROTOCOL);
        Object protocolFactory = useCompactProtocol ? new TCompactProtocol.Factory() : new TBinaryProtocol.Factory();
        HMSHandler baseHandler = new HMSHandler("new db based metaserver", conf);
        final IHMSHandler handler = HMSHandlerProxyFactory.getProxy(conf, baseHandler, false);
        ThriftHiveMetastore.Processor processor = new ThriftHiveMetastore.Processor((ThriftHiveMetastore.Iface)handler);
        LOG.info("Starting DB backed MetaStore Server with generic processor");
        HmsThriftHttpServlet thriftHttpServlet = new HmsThriftHttpServlet((TProcessor)processor, (TProtocolFactory)protocolFactory, conf);
        boolean directSqlEnabled = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL);
        HMSHandler.LOG.info("Direct SQL optimization = {}", (Object)directSqlEnabled);
        String httpPath = MetaStoreUtils.getHttpPath((String)MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_THRIFT_HTTP_PATH));
        ServletContextHandler context = new ServletContextHandler(0);
        HiveMetaStore.constraintHttpMethods(context, false);
        context.addServlet(new ServletHolder((Servlet)thriftHttpServlet), httpPath);
        context.addEventListener((EventListener)new ServletRequestListener(){

            public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
                Request baseRequest = Request.getBaseRequest((ServletRequest)servletRequestEvent.getServletRequest());
                HttpChannel channel = baseRequest.getHttpChannel();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("request: " + baseRequest + " destroyed , http channel: " + channel);
                }
                HMSHandler.cleanupHandlerContext();
            }

            public void requestInitialized(ServletRequestEvent servletRequestEvent) {
                Request baseRequest = Request.getBaseRequest((ServletRequest)servletRequestEvent.getServletRequest());
                HttpChannel channel = baseRequest.getHttpChannel();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("request: " + baseRequest + " initialized , http channel: " + channel);
                }
            }
        });
        server.setHandler((Handler)context);
        return new ThriftServer(){

            @Override
            public void start() throws Throwable {
                HMSHandler.LOG.debug("Starting HTTPServer for HMS");
                server.setStopAtShutdown(true);
                server.start();
                HMSHandler.LOG.info("Started the new HTTPServer for metastore on port [{}]...", (Object)port);
                HMSHandler.LOG.info("Options.minWorkerThreads = {}", (Object)minWorkerThreads);
                HMSHandler.LOG.info("Options.maxWorkerThreads = {}", (Object)maxWorkerThreads);
                HMSHandler.LOG.info("Enable SSL = {}", (Object)(sslContextFactory != null ? 1 : 0));
                server.join();
            }

            @Override
            public boolean isRunning() {
                return server != null && server.isRunning();
            }

            @Override
            public IHMSHandler getHandler() {
                return handler;
            }
        };
    }

    private static ThriftServer startBinaryMetastore(final int port, HadoopThriftAuthBridge bridge, Configuration conf) throws Throwable {
        TServerSocket serverSocket;
        Object processor;
        TCompactProtocol.Factory inputProtoFactory;
        TCompactProtocol.Factory protocolFactory;
        long maxMessageSize = MetastoreConf.getLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERVER_MAX_MESSAGE_SIZE);
        final int minWorkerThreads = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERVER_MIN_THREADS);
        final int maxWorkerThreads = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERVER_MAX_THREADS);
        final boolean tcpKeepAlive = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TCP_KEEP_ALIVE);
        boolean useCompactProtocol = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_THRIFT_COMPACT_PROTOCOL);
        final boolean useSSL = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_SSL);
        HMSHandler baseHandler = new HMSHandler("new db based metaserver", conf);
        AuthFactory authFactory = new AuthFactory(bridge, conf, baseHandler);
        useSasl = authFactory.isSASLWithKerberizedHadoop();
        if (useSasl) {
            String kerberosName = SecurityUtil.getServerPrincipal((String)MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.KERBEROS_PRINCIPAL), (String)"0.0.0.0");
            String keyTabFile = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.KERBEROS_KEYTAB_FILE);
            UserGroupInformation.loginUserFromKeytab((String)kerberosName, (String)keyTabFile);
            saslServer = authFactory.getSaslServer();
            delegationTokenManager = authFactory.getDelegationTokenManager();
        }
        TTransportFactory transFactory = authFactory.getAuthTransFactory(useSSL, conf);
        if (useCompactProtocol) {
            protocolFactory = new TCompactProtocol.Factory();
            inputProtoFactory = new TCompactProtocol.Factory(maxMessageSize, maxMessageSize);
        } else {
            protocolFactory = new TBinaryProtocol.Factory();
            inputProtoFactory = new TBinaryProtocol.Factory(true, true, maxMessageSize, maxMessageSize);
        }
        msHost = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_BIND_HOST);
        if (msHost != null && !msHost.trim().isEmpty()) {
            LOG.info("Binding host " + msHost + " for metastore server");
        }
        IHMSHandler handler = HMSHandlerProxyFactory.getProxy(conf, baseHandler, false);
        if (useSasl) {
            processor = saslServer.wrapProcessor((TProcessor)new ThriftHiveMetastore.Processor((ThriftHiveMetastore.Iface)handler));
            LOG.info("Starting DB backed MetaStore Server in Secure Mode");
        } else if (MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXECUTE_SET_UGI)) {
            processor = new TUGIBasedProcessor<IHMSHandler>(handler);
            LOG.info("Starting DB backed MetaStore Server with SetUGI enabled");
        } else {
            processor = new TSetIpAddressProcessor<IHMSHandler>(handler);
            LOG.info("Starting DB backed MetaStore Server");
        }
        if (!useSSL) {
            serverSocket = SecurityUtils.getServerSocket((String)msHost, (int)port);
        } else {
            String keyStorePath = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_KEYSTORE_PATH).trim();
            if (keyStorePath.isEmpty()) {
                throw new IllegalArgumentException(MetastoreConf.ConfVars.SSL_KEYSTORE_PATH.toString() + " Not configured for SSL connection");
            }
            String keyStorePassword = MetastoreConf.getPassword((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_KEYSTORE_PASSWORD);
            String keyStoreType = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_KEYSTORE_TYPE).trim();
            String keyStoreAlgorithm = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_KEYMANAGERFACTORY_ALGORITHM).trim();
            ArrayList<String> sslVersionBlacklist = new ArrayList<String>();
            for (String sslVersion : MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_PROTOCOL_BLACKLIST).split(",")) {
                sslVersionBlacklist.add(sslVersion);
            }
            serverSocket = SecurityUtils.getServerSSLSocket((String)msHost, (int)port, (String)keyStorePath, (String)keyStorePassword, (String)keyStoreType, (String)keyStoreAlgorithm, sslVersionBlacklist);
        }
        if (tcpKeepAlive) {
            serverSocket = new TServerSocketKeepAlive(serverSocket);
        }
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(minWorkerThreads, maxWorkerThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("Metastore-Handler-Pool: Thread-" + thread.getId());
            return thread;
        });
        TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverSocket).processor(processor)).transportFactory(transFactory)).protocolFactory((TProtocolFactory)protocolFactory)).inputProtocolFactory((TProtocolFactory)inputProtoFactory)).executorService((ExecutorService)executorService);
        TThreadPoolServer tServer = new TThreadPoolServer(args);
        TServerEventHandler tServerEventHandler = new TServerEventHandler(){

            public void preServe() {
            }

            public ServerContext createContext(TProtocol tProtocol, TProtocol tProtocol1) {
                Metrics.getOpenConnectionsCounter().inc();
                return null;
            }

            public void deleteContext(ServerContext serverContext, TProtocol tProtocol, TProtocol tProtocol1) {
                Metrics.getOpenConnectionsCounter().dec();
                HMSHandler.cleanupHandlerContext();
            }

            public void processContext(ServerContext serverContext, TTransport tTransport, TTransport tTransport1) {
            }
        };
        tServer.setServerEventHandler(tServerEventHandler);
        return new ThriftServer((TServer)tServer, handler){
            final /* synthetic */ TServer val$tServer;
            final /* synthetic */ IHMSHandler val$handler;
            {
                this.val$tServer = tServer;
                this.val$handler = iHMSHandler;
            }

            @Override
            public void start() throws Throwable {
                HMSHandler.LOG.info("Started the new metaserver on port [{}]...", (Object)port);
                HMSHandler.LOG.info("Options.minWorkerThreads = {}", (Object)minWorkerThreads);
                HMSHandler.LOG.info("Options.maxWorkerThreads = {}", (Object)maxWorkerThreads);
                HMSHandler.LOG.info("TCP keepalive = {}", (Object)tcpKeepAlive);
                HMSHandler.LOG.info("Enable SSL = {}", (Object)useSSL);
                this.val$tServer.serve();
            }

            @Override
            public boolean isRunning() {
                return this.val$tServer != null && this.val$tServer.isServing();
            }

            @Override
            public IHMSHandler getHandler() {
                return this.val$handler;
            }
        };
    }

    private static void constraintHttpMethods(ServletContextHandler ctxHandler, boolean allowOptionsMethod) {
        Constraint c = new Constraint();
        c.setAuthenticate(true);
        ConstraintMapping cmt = new ConstraintMapping();
        cmt.setConstraint(c);
        cmt.setMethod("TRACE");
        cmt.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        if (!allowOptionsMethod) {
            ConstraintMapping cmo = new ConstraintMapping();
            cmo.setConstraint(c);
            cmo.setMethod("OPTIONS");
            cmo.setPathSpec("/*");
            securityHandler.setConstraintMappings(new ConstraintMapping[]{cmt, cmo});
        } else {
            securityHandler.setConstraintMappings(new ConstraintMapping[]{cmt});
        }
        ctxHandler.setSecurityHandler((SecurityHandler)securityHandler);
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge, Configuration conf, boolean startMetaStoreThreads, AtomicBoolean startedBackgroundThreads) throws Throwable {
        isMetaStoreRemote = true;
        String transportMode = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_TRANSPORT_MODE, (String)"binary");
        boolean isHttpTransport = transportMode.equalsIgnoreCase("http");
        thriftServer = isHttpTransport ? HiveMetaStore.startHttpMetastore(port, conf) : HiveMetaStore.startBinaryMetastore(port, bridge, conf);
        boolean directSqlEnabled = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL);
        LOG.info("Direct SQL optimization = {}", (Object)directSqlEnabled);
        if (startMetaStoreThreads) {
            ReentrantLock metaStoreThreadsLock = new ReentrantLock();
            Condition startCondition = metaStoreThreadsLock.newCondition();
            AtomicBoolean startedServing = new AtomicBoolean();
            HiveMetaStore.startMetaStoreThreads(conf, metaStoreThreadsLock, startCondition, startedServing, startedBackgroundThreads);
            HiveMetaStore.signalOtherThreadsToStart(thriftServer, metaStoreThreadsLock, startCondition, startedServing);
        }
        if (MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_SERVICE_DISCOVERY_MODE).equalsIgnoreCase("zookeeper")) {
            try {
                zooKeeperHelper = MetastoreConf.getZKConfig((Configuration)conf);
                String serverInstanceURI = HiveMetaStore.getServerInstanceURI(port);
                zooKeeperHelper.addServerInstanceToZooKeeper(serverInstanceURI, serverInstanceURI, null, new ZKDeRegisterWatcher(zooKeeperHelper));
                LOG.info("Metastore server instance with URL " + serverInstanceURI + " added to the zookeeper");
            }
            catch (Exception e) {
                LOG.error("Error adding this metastore instance to ZooKeeper: ", (Throwable)e);
                throw e;
            }
        }
        propertyServer = PropertyServlet.startServer(conf);
        thriftServer.start();
    }

    private static String getServerInstanceURI(int port) throws Exception {
        return HiveMetaStore.getServerHostName() + ":" + port;
    }

    static String getServerHostName() throws Exception {
        if (msHost != null && !msHost.trim().isEmpty()) {
            return msHost.trim();
        }
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    private static void signalOtherThreadsToStart(final ThriftServer thriftServer, final Lock startLock, final Condition startCondition, final AtomicBoolean startedServing) {
        Thread t = new Thread(){

            @Override
            public void run() {
                do {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Signalling thread was interrupted: " + e.getMessage());
                    }
                } while (!thriftServer.isRunning());
                startLock.lock();
                try {
                    startedServing.set(true);
                    startCondition.signalAll();
                }
                finally {
                    startLock.unlock();
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private static void startMetaStoreThreads(final Configuration conf, final Lock startLock, final Condition startCondition, final AtomicBoolean startedServing, final AtomicBoolean startedBackGroundThreads) {
        Thread t = new Thread(){

            @Override
            public void run() {
                startLock.lock();
                try {
                    JvmPauseMonitor pauseMonitor = new JvmPauseMonitor(conf);
                    pauseMonitor.start();
                }
                catch (Throwable t) {
                    LOG.warn("Could not initiate the JvmPauseMonitor thread. GCs and Pauses may not be warned upon.", t);
                }
                try {
                    while (!startedServing.get()) {
                        startCondition.await();
                    }
                    LeaderElectionContext context = new LeaderElectionContext.ContextBuilder(conf).setHMSHandler(thriftServer.getHandler()).servHost(HiveMetaStore.getServerHostName()).setTType(LeaderElectionContext.TTYPE.ALWAYS_TASKS).addListener(new HouseKeepingTasks(conf, false)).setTType(LeaderElectionContext.TTYPE.HOUSEKEEPING).addListener(new CMClearer(conf)).addListener(new StatsUpdaterTask(conf)).addListener(new CompactorTasks(conf, false)).addListener(new CompactorPMF()).addListener(new HouseKeepingTasks(conf, true)).setTType(LeaderElectionContext.TTYPE.WORKER).addListener(new CompactorTasks(conf, true), MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_METASTORE_RUNWORKER_IN).equals("metastore")).build();
                    if (shutdownHookMgr != null) {
                        shutdownHookMgr.addShutdownHook(() -> context.close(), 0);
                    }
                    context.start();
                }
                catch (Throwable e) {
                    LOG.error("Failure when starting the leader tasks, Compaction or Housekeeping tasks may not happen", e);
                }
                finally {
                    startLock.unlock();
                }
                if (startedBackGroundThreads != null) {
                    startedBackGroundThreads.set(true);
                }
            }
        };
        t.setDaemon(true);
        t.setName("Metastore threads starter thread");
        t.start();
    }

    private static void startupShutdownMessage(Class<?> clazz, String[] args, Logger LOG) {
        String hostname = HiveMetaStore.getHostname();
        String classname = clazz.getSimpleName();
        LOG.info(HiveMetaStore.toStartupShutdownString("STARTUP_MSG: ", new String[]{"Starting " + classname, "  host = " + hostname, "  args = " + Arrays.asList(args), "  version = " + MetastoreVersionInfo.getVersion(), "  classpath = " + System.getProperty("java.class.path"), "  build = " + MetastoreVersionInfo.getUrl() + " -r " + MetastoreVersionInfo.getRevision() + "; compiled by '" + MetastoreVersionInfo.getUser() + "' on " + MetastoreVersionInfo.getDate()}));
    }

    private static String toStartupShutdownString(String prefix, String[] msg) {
        StringBuilder b = new StringBuilder(prefix);
        b.append("\n/************************************************************");
        for (String s : msg) {
            b.append("\n").append(prefix).append(s);
        }
        b.append("\n************************************************************/");
        return b.toString();
    }

    private static String getHostname() {
        try {
            return "" + InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            return "" + uhe;
        }
    }

    static {
        zooKeeperHelper = null;
        msHost = null;
        propertyServer = null;
    }

    private static interface ThriftServer {
        public void start() throws Throwable;

        public boolean isRunning();

        public IHMSHandler getHandler();
    }

    public static class HiveMetastoreCli
    extends CommonCliOptions {
        private int port;

        HiveMetastoreCli(Configuration configuration) {
            super("hivemetastore", true);
            this.port = MetastoreConf.getIntVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERVER_PORT);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"port");
            OptionBuilder.withDescription((String)("Hive Metastore port number, default:" + this.port));
            this.OPTIONS.addOption(OptionBuilder.create((char)'p'));
        }

        @Override
        public void parse(String[] args) {
            super.parse(args);
            args = this.commandLine.getArgs();
            if (args.length > 0) {
                System.err.println("This usage has been deprecated, consider using the new command line syntax (run with -h to see usage information)");
                this.port = Integer.parseInt(args[0]);
            }
            if (this.commandLine.hasOption('p')) {
                this.port = Integer.parseInt(this.commandLine.getOptionValue('p'));
            } else {
                String metastorePort = System.getenv("METASTORE_PORT");
                if (metastorePort != null) {
                    this.port = Integer.parseInt(metastorePort);
                }
            }
        }

        public int getPort() {
            return this.port;
        }
    }
}

