/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import com.facebook.fb303.FacebookBase;
import com.facebook.fb303.fb_status;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Striped;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.regex.Pattern;
import javax.jdo.JDOException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.AcidConstants;
import org.apache.hadoop.hive.common.AcidMetaDataFile;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.metastore.AcidEventListener;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.ExceptionHandler;
import org.apache.hadoop.hive.metastore.FileMetadataManager;
import org.apache.hadoop.hive.metastore.HMSHandlerContext;
import org.apache.hadoop.hive.metastore.HMSMetricsListener;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.IMetaStoreMetadataTransformer;
import org.apache.hadoop.hive.metastore.MetaStoreEndFunctionContext;
import org.apache.hadoop.hive.metastore.MetaStoreEndFunctionListener;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.MetaStoreInit;
import org.apache.hadoop.hive.metastore.MetaStoreInitContext;
import org.apache.hadoop.hive.metastore.MetaStoreInitListener;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.SessionPropertiesListener;
import org.apache.hadoop.hive.metastore.StorageSchemaReader;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.TransactionalValidationListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AbortCompactResponse;
import org.apache.hadoop.hive.metastore.api.AbortCompactionRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddCheckConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDefaultConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AddForeignKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddNotNullConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddPackageRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsResult;
import org.apache.hadoop.hive.metastore.api.AddPrimaryKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddUniqueConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.AlterCatalogRequest;
import org.apache.hadoop.hive.metastore.api.AlterDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.AlterDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.AlterISchemaRequest;
import org.apache.hadoop.hive.metastore.api.AlterPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AlterPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.AlterTableRequest;
import org.apache.hadoop.hive.metastore.api.AlterTableResponse;
import org.apache.hadoop.hive.metastore.api.AppendPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.ClientCapabilities;
import org.apache.hadoop.hive.metastore.api.ClientCapability;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleResponse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.CompactionMetricsDataRequest;
import org.apache.hadoop.hive.metastore.api.CompactionMetricsDataStruct;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CreateCatalogRequest;
import org.apache.hadoop.hive.metastore.api.CreateDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.CreateDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DatabaseType;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.DropCatalogRequest;
import org.apache.hadoop.hive.metastore.api.DropConstraintRequest;
import org.apache.hadoop.hive.metastore.api.DropDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.DropDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.DropPackageRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsExpr;
import org.apache.hadoop.hive.metastore.api.DropPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsResult;
import org.apache.hadoop.hive.metastore.api.DropTableRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.ExtendedTableInfo;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsResp;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsRqst;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventRequestData;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.ForeignKeysResponse;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetAllWriteEventInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetCatalogRequest;
import org.apache.hadoop.hive.metastore.api.GetCatalogResponse;
import org.apache.hadoop.hive.metastore.api.GetCatalogsResponse;
import org.apache.hadoop.hive.metastore.api.GetDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.GetDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.GetFieldsRequest;
import org.apache.hadoop.hive.metastore.api.GetFieldsResponse;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprResult;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsRequest;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetPackageRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByFilterRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.GetReplicationMetricsRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.GetRuntimeStatsRequest;
import org.apache.hadoop.hive.metastore.api.GetSchemaRequest;
import org.apache.hadoop.hive.metastore.api.GetSchemaResponse;
import org.apache.hadoop.hive.metastore.api.GetSerdeRequest;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetTableResult;
import org.apache.hadoop.hive.metastore.api.GetTablesExtRequest;
import org.apache.hadoop.hive.metastore.api.GetTablesExtRequestFields;
import org.apache.hadoop.hive.metastore.api.GetTablesRequest;
import org.apache.hadoop.hive.metastore.api.GetTablesResult;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.ISchemaName;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.ListPackageRequest;
import org.apache.hadoop.hive.metastore.api.ListStoredProcedureRequest;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MapSchemaVersionToSerdeRequest;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MaxAllocatedTableWriteIdRequest;
import org.apache.hadoop.hive.metastore.api.MaxAllocatedTableWriteIdResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.OptionalCompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.Package;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsSpecByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsResult;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.PropertyGetRequest;
import org.apache.hadoop.hive.metastore.api.PropertyGetResponse;
import org.apache.hadoop.hive.metastore.api.PropertySetRequest;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.RenamePartitionRequest;
import org.apache.hadoop.hive.metastore.api.RenamePartitionResponse;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.api.ReplicationMetricList;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLAllTableConstraints;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.ScheduledQuery;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollResponse;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryProgressInfo;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionDescriptor;
import org.apache.hadoop.hive.metastore.api.SeedTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.SeedTxnIdRequest;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsResponse;
import org.apache.hadoop.hive.metastore.api.SetSchemaVersionStateRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StoredProcedure;
import org.apache.hadoop.hive.metastore.api.StoredProcedureRequest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableStatsResult;
import org.apache.hadoop.hive.metastore.api.TruncateTableRequest;
import org.apache.hadoop.hive.metastore.api.TruncateTableResponse;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.api.UpdateTransactionalStatsRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterPoolResponse;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMAlterTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterTriggerResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateOrDropTriggerToPoolMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrDropTriggerToPoolMappingResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateOrUpdateMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrUpdateMappingResponse;
import org.apache.hadoop.hive.metastore.api.WMCreatePoolRequest;
import org.apache.hadoop.hive.metastore.api.WMCreatePoolResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateTriggerResponse;
import org.apache.hadoop.hive.metastore.api.WMDropMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMDropMappingResponse;
import org.apache.hadoop.hive.metastore.api.WMDropPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMDropPoolResponse;
import org.apache.hadoop.hive.metastore.api.WMDropResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMDropResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMDropTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMDropTriggerResponse;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMGetActiveResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetActiveResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMGetAllResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetAllResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMGetResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMGetTriggersForResourePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetTriggersForResourePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogBatchRequest;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogBatchResponse;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogRequest;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogResponse;
import org.apache.hadoop.hive.metastore.client.builder.GetPartitionsArgs;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.dataconnector.DataConnectorProviderFactory;
import org.apache.hadoop.hive.metastore.events.AbortTxnEvent;
import org.apache.hadoop.hive.metastore.events.AcidWriteEvent;
import org.apache.hadoop.hive.metastore.events.AddCheckConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AddDefaultConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AddForeignKeyEvent;
import org.apache.hadoop.hive.metastore.events.AddNotNullConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AddPrimaryKeyEvent;
import org.apache.hadoop.hive.metastore.events.AddSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.AddUniqueConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AllocWriteIdEvent;
import org.apache.hadoop.hive.metastore.events.AlterCatalogEvent;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterISchemaEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.BatchAcidWriteEvent;
import org.apache.hadoop.hive.metastore.events.CommitCompactionEvent;
import org.apache.hadoop.hive.metastore.events.CommitTxnEvent;
import org.apache.hadoop.hive.metastore.events.ConfigChangeEvent;
import org.apache.hadoop.hive.metastore.events.CreateCatalogEvent;
import org.apache.hadoop.hive.metastore.events.CreateDataConnectorEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateFunctionEvent;
import org.apache.hadoop.hive.metastore.events.CreateISchemaEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DeletePartitionColumnStatEvent;
import org.apache.hadoop.hive.metastore.events.DeleteTableColumnStatEvent;
import org.apache.hadoop.hive.metastore.events.DropCatalogEvent;
import org.apache.hadoop.hive.metastore.events.DropConstraintEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropFunctionEvent;
import org.apache.hadoop.hive.metastore.events.DropISchemaEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.InsertEvent;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.events.OpenTxnEvent;
import org.apache.hadoop.hive.metastore.events.PreAddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAddSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterCatalogEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterDataConnectorEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterISchemaEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreAuthorizationCallEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateCatalogEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateDataConnectorEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateFunctionEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateISchemaEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreDropCatalogEvent;
import org.apache.hadoop.hive.metastore.events.PreDropDataConnectorEvent;
import org.apache.hadoop.hive.metastore.events.PreDropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreDropFunctionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropISchemaEvent;
import org.apache.hadoop.hive.metastore.events.PreDropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.events.PreLoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.events.PreReadCatalogEvent;
import org.apache.hadoop.hive.metastore.events.PreReadDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreReadISchemaEvent;
import org.apache.hadoop.hive.metastore.events.PreReadTableEvent;
import org.apache.hadoop.hive.metastore.events.PreReadhSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.ReloadEvent;
import org.apache.hadoop.hive.metastore.events.UpdatePartitionColumnStatEvent;
import org.apache.hadoop.hive.metastore.events.UpdateTableColumnStatEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.metrics.PerfLogger;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.properties.PropertyException;
import org.apache.hadoop.hive.metastore.properties.PropertyManager;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;
import org.apache.hadoop.hive.metastore.txn.CompactionMetricsDataConverter;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.FilterUtils;
import org.apache.hadoop.hive.metastore.utils.HdfsUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.MetastoreVersionInfo;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMSHandler
extends FacebookBase
implements IHMSHandler {
    public static final Logger LOG = LoggerFactory.getLogger(HMSHandler.class);
    private final Configuration conf;
    private static String currentUrl;
    private FileMetadataManager fileMetadataManager;
    private PartitionExpressionProxy expressionProxy;
    private StorageSchemaReader storageSchemaReader;
    private IMetaStoreMetadataTransformer transformer;
    private static DataConnectorProviderFactory dataconnectorFactory;
    public static final String PARTITION_NUMBER_EXCEED_LIMIT_MSG = "Number of partitions scanned (=%d) on table '%s' exceeds limit (=%d). This is controlled on the metastore server by %s.";
    public static final String ADMIN = "admin";
    public static final String PUBLIC = "public";
    static final String NO_FILTER_STRING = "";
    static final int UNLIMITED_MAX_PARTITIONS = -1;
    static final int LOG_SAMPLE_PARTITIONS_MAX_SIZE = 4;
    static final int LOG_SAMPLE_PARTITIONS_HALF_SIZE = 2;
    static final String LOG_SAMPLE_PARTITIONS_SEPARATOR = ",";
    private Warehouse wh;
    private static Striped<Lock> tablelocks;
    private static ExecutorService threadPool;
    static final Logger auditLog;
    private AlterHandler alterHandler;
    private List<MetaStorePreEventListener> preListeners;
    private List<MetaStoreEventListener> listeners;
    private List<TransactionalMetaStoreEventListener> transactionalListeners;
    private List<MetaStoreEndFunctionListener> endFunctionListeners;
    private List<MetaStoreInitListener> initListeners;
    private MetaStoreFilterHook filterHook;
    private boolean isServerFilterEnabled = false;
    private Pattern partitionValidationPattern;
    private final boolean isInTest;

    public static RawStore getRawStore() {
        return HMSHandlerContext.getRawStore().orElse(null);
    }

    static void cleanupHandlerContext() {
        AtomicBoolean cleanedRawStore = new AtomicBoolean(false);
        try {
            HMSHandlerContext.getRawStore().ifPresent(rs -> {
                HMSHandler.logAndAudit("Cleaning up thread local RawStore...");
                rs.shutdown();
                cleanedRawStore.set(true);
            });
        }
        finally {
            HMSHandlerContext.getHMSHandler().ifPresent(HMSHandler::notifyMetaListenersOnShutDown);
            if (cleanedRawStore.get()) {
                HMSHandler.logAndAudit("Done cleaning up thread local RawStore");
            }
            HMSHandlerContext.clear();
        }
    }

    private static void logAuditEvent(String cmd) {
        UserGroupInformation ugi;
        if (cmd == null) {
            return;
        }
        try {
            ugi = SecurityUtils.getUGI();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String address = HMSHandler.getIPAddress();
        if (address == null) {
            address = "unknown-ip-addr";
        }
        auditLog.info("ugi={}\tip={}\tcmd={}\t", new Object[]{ugi.getUserName(), address, cmd});
    }

    public static String getIPAddress() {
        if (HiveMetaStore.useSasl) {
            if (HiveMetaStore.saslServer != null && HiveMetaStore.saslServer.getRemoteAddress() != null) {
                return HiveMetaStore.saslServer.getRemoteAddress().getHostAddress();
            }
        } else {
            return HMSHandler.getThreadLocalIpAddress();
        }
        return null;
    }

    private void notifyMetaListeners(String key, String oldValue, String newValue) throws MetaException {
        for (MetaStoreEventListener listener : this.listeners) {
            listener.onConfigChange(new ConfigChangeEvent(this, key, oldValue, newValue));
        }
        if (this.transactionalListeners.size() > 0) {
            ConfigChangeEvent cce = new ConfigChangeEvent(this, key, oldValue, newValue);
            for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                metaStoreEventListener.onConfigChange(cce);
            }
        }
    }

    private void notifyMetaListenersOnShutDown() {
        try {
            Map<String, String> modifiedConf = HMSHandlerContext.getModifiedConfig();
            Configuration conf = HMSHandlerContext.getConfiguration().orElseThrow(() -> new MetaException("Unexpected: modifiedConf is non-null but conf is null"));
            for (Map.Entry<String, String> entry : modifiedConf.entrySet()) {
                String key = entry.getKey();
                String currVal = entry.getValue();
                String oldVal = conf.get(key);
                if (Objects.equals(oldVal, currVal)) continue;
                this.notifyMetaListeners(key, oldVal, currVal);
            }
            HMSHandler.logAndAudit("Meta listeners shutdown notification completed.");
        }
        catch (MetaException e) {
            LOG.error("Failed to notify meta listeners on shutdown: ", (Throwable)e);
        }
    }

    static void setThreadLocalIpAddress(String ipAddress) {
        HMSHandlerContext.setIpAddress(ipAddress);
    }

    static String getThreadLocalIpAddress() {
        return HMSHandlerContext.getIpAddress().orElse(null);
    }

    @VisibleForTesting
    PartitionExpressionProxy getExpressionProxy() {
        return this.expressionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HMSHandler(String name, Configuration conf) {
        super(name);
        this.conf = conf;
        this.isInTest = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST);
        if (threadPool != null) return;
        Class<HMSHandler> clazz = HMSHandler.class;
        synchronized (HMSHandler.class) {
            if (threadPool != null) return;
            int numThreads = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.FS_HANDLER_THREADS_COUNT);
            threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HMSHandler #%d").build());
            int numTableLocks = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_NUM_STRIPED_TABLE_LOCKS);
            tablelocks = Striped.lock((int)numTableLocks);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Deprecated
    public Configuration getHiveConf() {
        return this.conf;
    }

    @Override
    public List<TransactionalMetaStoreEventListener> getTransactionalListeners() {
        return this.transactionalListeners;
    }

    @Override
    public List<MetaStoreEventListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws MetaException {
        Metrics.initialize(this.conf);
        this.initListeners = MetaStoreServerUtils.getMetaStoreListeners(MetaStoreInitListener.class, this.conf, MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.INIT_HOOKS));
        for (MetaStoreInitListener metaStoreInitListener : this.initListeners) {
            MetaStoreInitContext context = new MetaStoreInitContext();
            metaStoreInitListener.onInit(context);
        }
        String alterHandlerName = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ALTER_HANDLER);
        this.alterHandler = (AlterHandler)ReflectionUtils.newInstance((Class)JavaUtils.getClass((String)alterHandlerName, AlterHandler.class), (Configuration)this.conf);
        this.wh = new Warehouse(this.conf);
        Class<HMSHandler> clazz = HMSHandler.class;
        synchronized (HMSHandler.class) {
            boolean bl;
            if (currentUrl == null || !currentUrl.equals(MetaStoreInit.getConnectionURL(this.conf))) {
                this.createDefaultDB();
                this.createDefaultRoles();
                this.addAdminUsers();
                currentUrl = MetaStoreInit.getConnectionURL(this.conf);
                this.updateMetrics();
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            this.preListeners = MetaStoreServerUtils.getMetaStoreListeners(MetaStorePreEventListener.class, this.conf, MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PRE_EVENT_LISTENERS));
            this.preListeners.add(0, new TransactionalValidationListener(this.conf));
            this.listeners = MetaStoreServerUtils.getMetaStoreListeners(MetaStoreEventListener.class, this.conf, MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_LISTENERS));
            this.listeners.add(new SessionPropertiesListener(this.conf));
            this.transactionalListeners = new ArrayList(){
                {
                    this.add(new AcidEventListener(HMSHandler.this.conf));
                }
            };
            this.transactionalListeners.addAll(MetaStoreServerUtils.getMetaStoreListeners(TransactionalMetaStoreEventListener.class, this.conf, MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRANSACTIONAL_EVENT_LISTENERS)));
            if (Metrics.getRegistry() != null) {
                this.listeners.add(new HMSMetricsListener(this.conf));
            }
            boolean bl2 = false;
            for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                if (!metaStoreEventListener.doesAddEventsToNotificationLogTable()) continue;
                bl = true;
                break;
            }
            if (this.conf.getBoolean(MetastoreConf.ConfVars.METASTORE_CACHE_CAN_USE_EVENT.getVarname(), false) && !bl) {
                throw new MetaException("CahcedStore can not use events for invalidation as there is no  TransactionalMetaStoreEventListener to add events to notification table");
            }
            this.endFunctionListeners = MetaStoreServerUtils.getMetaStoreListeners(MetaStoreEndFunctionListener.class, this.conf, MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.END_FUNCTION_LISTENERS));
            String partitionValidationRegex = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN);
            if (partitionValidationRegex != null && !partitionValidationRegex.isEmpty()) {
                this.partitionValidationPattern = Pattern.compile(partitionValidationRegex);
            }
            this.expressionProxy = PartFilterExprUtil.createExpressionProxy(this.conf);
            this.fileMetadataManager = new FileMetadataManager(this.getMS(), this.conf);
            this.isServerFilterEnabled = this.getIfServerFilterenabled();
            this.filterHook = this.isServerFilterEnabled ? this.loadFilterHooks() : null;
            String string = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_METADATA_TRANSFORMER_CLASS);
            if (string != null && !string.trim().isEmpty()) {
                try {
                    this.transformer = (IMetaStoreMetadataTransformer)JavaUtils.newInstance((Class)JavaUtils.getClass((String)string.trim(), IMetaStoreMetadataTransformer.class), (Class[])new Class[]{IHMSHandler.class}, (Object[])new Object[]{this});
                }
                catch (Exception e) {
                    LOG.error("Unable to create instance of class " + string, (Throwable)e);
                    throw new IllegalArgumentException(e);
                }
            }
            dataconnectorFactory = DataConnectorProviderFactory.getInstance(this);
            return;
        }
    }

    private boolean getIfServerFilterenabled() throws MetaException {
        boolean isEnabled = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_SERVER_FILTER_ENABLED);
        if (!isEnabled) {
            LOG.info("HMS server filtering is disabled by configuration");
            return false;
        }
        String filterHookClassName = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.FILTER_HOOK);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)filterHookClassName)) {
            throw new MetaException("HMS server filtering is enabled but no filter hook is configured");
        }
        if (filterHookClassName.trim().equalsIgnoreCase(DefaultMetaStoreFilterHookImpl.class.getName())) {
            throw new MetaException("HMS server filtering is enabled but the filter hook is DefaultMetaStoreFilterHookImpl, which does no filtering");
        }
        LOG.info("HMS server filtering is enabled. The filter class is " + filterHookClassName);
        return true;
    }

    private MetaStoreFilterHook loadFilterHooks() throws IllegalStateException {
        String errorMsg = "Unable to load filter hook at HMS server. ";
        String filterHookClassName = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.FILTER_HOOK);
        Preconditions.checkState((!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)filterHookClassName) ? 1 : 0) != 0);
        try {
            return (MetaStoreFilterHook)Class.forName(filterHookClassName.trim(), true, JavaUtils.getClassLoader()).getConstructor(Configuration.class).newInstance(this.conf);
        }
        catch (Exception e) {
            LOG.error(errorMsg, (Throwable)e);
            throw new IllegalStateException(errorMsg + e.getMessage(), e);
        }
    }

    private void authorizeTableForPartitionMetadata(String catName, String dbName, String tblName) throws NoSuchObjectException, MetaException {
        FilterUtils.checkDbAndTableFilters((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (String)catName, (String)dbName, (String)tblName);
    }

    public void setConf(Configuration conf) {
        HMSHandlerContext.setConfiguration(conf);
        HMSHandlerContext.getRawStore().ifPresent(ms -> ms.setConf(conf));
    }

    public Configuration getConf() {
        Configuration conf = HMSHandlerContext.getConfiguration().orElseGet(() -> {
            Configuration configuration = new Configuration(this.conf);
            HMSHandlerContext.setConfiguration(configuration);
            return configuration;
        });
        return conf;
    }

    @Override
    public Warehouse getWh() {
        return this.wh;
    }

    public void setMetaConf(String key, String value) throws MetaException {
        MetastoreConf.ConfVars confVar = MetastoreConf.getMetaConf((String)key);
        if (confVar == null) {
            throw new MetaException("Invalid configuration key " + key);
        }
        try {
            confVar.validate(value);
        }
        catch (IllegalArgumentException e) {
            throw new MetaException("Invalid configuration value " + value + " for key " + key + " by " + e.getMessage());
        }
        Configuration configuration = this.getConf();
        String oldValue = MetastoreConf.get((Configuration)configuration, (String)key);
        Map<String, String> modifiedConf = HMSHandlerContext.getModifiedConfig();
        if (!modifiedConf.containsKey(key)) {
            modifiedConf.put(key, oldValue);
        }
        if (!HMSHandlerContext.getHMSHandler().isPresent()) {
            HMSHandlerContext.setHMSHandler(this);
        }
        configuration.set(key, value);
        this.notifyMetaListeners(key, oldValue, value);
        if (MetastoreConf.ConfVars.TRY_DIRECT_SQL == confVar) {
            LOG.info("Direct SQL optimization = {}", (Object)value);
        }
    }

    public String getMetaConf(String key) throws MetaException {
        MetastoreConf.ConfVars confVar = MetastoreConf.getMetaConf((String)key);
        if (confVar == null) {
            throw new MetaException("Invalid configuration key " + key);
        }
        return this.getConf().get(key, confVar.getDefaultVal().toString());
    }

    @Override
    public RawStore getMS() throws MetaException {
        Configuration conf = this.getConf();
        return HMSHandler.getMSForConf(conf);
    }

    public static synchronized RawStore getMSForConf(Configuration conf) throws MetaException {
        RawStore ms = HMSHandler.getRawStore();
        if (ms == null) {
            ms = HMSHandler.newRawStoreForConf(conf);
            try {
                ms.verifySchema();
            }
            catch (MetaException e) {
                ms.shutdown();
                throw e;
            }
            HMSHandlerContext.setRawStore(ms);
            LOG.info("Created RawStore: {}", (Object)ms);
        }
        return ms;
    }

    @Override
    public TxnStore getTxnHandler() {
        return HMSHandlerContext.getTxnStore(this.conf);
    }

    static RawStore newRawStoreForConf(Configuration conf) throws MetaException {
        Configuration newConf = new Configuration(conf);
        String rawStoreClassName = MetastoreConf.getVar((Configuration)newConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.RAW_STORE_IMPL);
        LOG.info("Opening raw store with implementation class: {}", (Object)rawStoreClassName);
        return RawStoreProxy.getProxy(newConf, conf, rawStoreClassName);
    }

    @VisibleForTesting
    public static void createDefaultCatalog(RawStore ms, Warehouse wh) throws MetaException, InvalidOperationException {
        try {
            Catalog defaultCat = ms.getCatalog("hive");
            if (defaultCat != null && defaultCat.getLocationUri().equals("TBD")) {
                LOG.info("Setting location of default catalog, as it hasn't been done after upgrade");
                defaultCat.setLocationUri(wh.getWhRoot().toString());
                ms.alterCatalog(defaultCat.getName(), defaultCat);
            }
        }
        catch (NoSuchObjectException e) {
            Catalog cat = new Catalog("hive", wh.getWhRoot().toString());
            long time = System.currentTimeMillis() / 1000L;
            cat.setCreateTime((int)time);
            cat.setDescription("Default catalog, for Hive");
            ms.createCatalog(cat);
        }
    }

    private void createDefaultDB_core(RawStore ms) throws MetaException, InvalidObjectException {
        try {
            ms.getDatabase("hive", "default");
        }
        catch (NoSuchObjectException e) {
            LOG.info("Started creating a default database with name: default");
            Database db = new Database("default", "Default Hive database", this.wh.getDefaultDatabasePath("default", true).toString(), null);
            db.setOwnerName(PUBLIC);
            db.setOwnerType(PrincipalType.ROLE);
            db.setCatalogName("hive");
            long time = System.currentTimeMillis() / 1000L;
            db.setCreateTime((int)time);
            db.setType(DatabaseType.NATIVE);
            ms.createDatabase(db);
            LOG.info("Successfully created a default database with name: default");
        }
    }

    private void createDefaultDB() throws MetaException {
        try {
            RawStore ms = this.getMS();
            HMSHandler.createDefaultCatalog(ms, this.wh);
            this.createDefaultDB_core(ms);
        }
        catch (JDOException e) {
            LOG.warn("Retrying creating default database after error: " + e.getMessage(), (Throwable)e);
            try {
                RawStore ms = this.getMS();
                HMSHandler.createDefaultCatalog(ms, this.wh);
                this.createDefaultDB_core(ms);
            }
            catch (InvalidObjectException | InvalidOperationException e1) {
                throw new MetaException(e1.getMessage());
            }
        }
        catch (InvalidObjectException | InvalidOperationException e) {
            throw new MetaException(e.getMessage());
        }
    }

    private void createDefaultRoles() throws MetaException {
        try {
            this.createDefaultRoles_core();
        }
        catch (JDOException e) {
            LOG.warn("Retrying creating default roles after error: " + e.getMessage(), (Throwable)e);
            this.createDefaultRoles_core();
        }
    }

    private void createDefaultRoles_core() throws MetaException {
        RawStore ms = this.getMS();
        try {
            ms.addRole(ADMIN, ADMIN);
        }
        catch (InvalidObjectException e) {
            LOG.debug("admin role already exists", (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            LOG.warn("Unexpected exception while adding admin roles", (Throwable)e);
        }
        LOG.info("Added admin role in metastore");
        try {
            ms.addRole(PUBLIC, PUBLIC);
        }
        catch (InvalidObjectException e) {
            LOG.debug("public role already exists", (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            LOG.warn("Unexpected exception while adding public roles", (Throwable)e);
        }
        LOG.info("Added public role in metastore");
        PrivilegeBag privs = new PrivilegeBag();
        privs.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null), ADMIN, PrincipalType.ROLE, new PrivilegeGrantInfo("All", 0, ADMIN, PrincipalType.ROLE, true), "SQL"));
        try {
            ms.grantPrivileges(privs);
        }
        catch (InvalidObjectException e) {
            LOG.debug("Failed while granting global privs to admin", (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            LOG.warn("Failed while granting global privs to admin", (Throwable)e);
        }
    }

    private void addAdminUsers() throws MetaException {
        try {
            this.addAdminUsers_core();
        }
        catch (JDOException e) {
            LOG.warn("Retrying adding admin users after error: " + e.getMessage(), (Throwable)e);
            this.addAdminUsers_core();
        }
    }

    private void addAdminUsers_core() throws MetaException {
        Role adminRole;
        String userStr = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USERS_IN_ADMIN_ROLE, (String)NO_FILTER_STRING).trim();
        if (userStr.isEmpty()) {
            LOG.info("No user is added in admin role, since config is empty");
            return;
        }
        Iterator users = Splitter.on((String)LOG_SAMPLE_PARTITIONS_SEPARATOR).trimResults().omitEmptyStrings().split((CharSequence)userStr).iterator();
        if (!users.hasNext()) {
            LOG.info("No user is added in admin role, since config value " + userStr + " is in incorrect format. We accept comma separated list of users.");
            return;
        }
        RawStore ms = this.getMS();
        try {
            adminRole = ms.getRole(ADMIN);
        }
        catch (NoSuchObjectException e) {
            LOG.error("Failed to retrieve just added admin role", (Throwable)e);
            return;
        }
        while (users.hasNext()) {
            String userName = (String)users.next();
            try {
                ms.grantRole(adminRole, userName, PrincipalType.USER, ADMIN, PrincipalType.ROLE, true);
                LOG.info("Added " + userName + " to admin role");
            }
            catch (NoSuchObjectException e) {
                LOG.error("Failed to add " + userName + " in admin role", (Throwable)e);
            }
            catch (InvalidObjectException e) {
                LOG.debug(userName + " already in admin role", (Throwable)e);
            }
        }
    }

    private static void logAndAudit(String m) {
        LOG.debug(m);
        HMSHandler.logAuditEvent(m);
    }

    private String startFunction(String function, String extraLogInfo) {
        Counter counter;
        this.incrementCounter(function);
        HMSHandler.logAndAudit((HMSHandler.getThreadLocalIpAddress() == null ? NO_FILTER_STRING : "source:" + HMSHandler.getThreadLocalIpAddress() + " ") + function + extraLogInfo);
        Timer timer = Metrics.getOrCreateTimer("api_" + function);
        if (timer != null) {
            HMSHandlerContext.getTimerContexts().put(function, timer.time());
        }
        if ((counter = Metrics.getOrCreateCounter("active_calls_" + function)) != null) {
            counter.inc();
        }
        return function;
    }

    private String startFunction(String function) {
        return this.startFunction(function, NO_FILTER_STRING);
    }

    private void startTableFunction(String function, String catName, String db, String tbl) {
        this.startFunction(function, " : tbl=" + TableName.getQualified((String)catName, (String)db, (String)tbl));
    }

    private void startMultiTableFunction(String function, String db, List<String> tbls) {
        String tableNames = org.apache.commons.lang3.StringUtils.join(tbls, (String)LOG_SAMPLE_PARTITIONS_SEPARATOR);
        this.startFunction(function, " : db=" + db + " tbls=" + tableNames);
    }

    private void startPartitionFunction(String function, String cat, String db, String tbl, List<String> partVals) {
        this.startFunction(function, " : tbl=" + TableName.getQualified((String)cat, (String)db, (String)tbl) + this.samplePartitionValues(partVals));
    }

    private void startPartitionFunction(String function, String catName, String db, String tbl, Map<String, String> partName) {
        this.startFunction(function, " : tbl=" + TableName.getQualified((String)catName, (String)db, (String)tbl) + " partition=" + partName);
    }

    private void startPartitionFunction(String function, String catName, String db, String tbl, int maxParts) {
        this.startFunction(function, " : tbl=" + TableName.getQualified((String)catName, (String)db, (String)tbl) + ": Max partitions =" + maxParts);
    }

    private void startPartitionFunction(String function, String catName, String db, String tbl, int maxParts, List<String> partVals) {
        this.startFunction(function, " : tbl=" + TableName.getQualified((String)catName, (String)db, (String)tbl) + ": Max partitions =" + maxParts + this.samplePartitionValues(partVals));
    }

    private void startPartitionFunction(String function, String catName, String db, String tbl, int maxParts, String filter) {
        this.startFunction(function, " : tbl=" + TableName.getQualified((String)catName, (String)db, (String)tbl) + ": Filter=" + filter + ": Max partitions =" + maxParts);
    }

    private void startPartitionFunction(String function, String catName, String db, String tbl, int maxParts, String expression, String defaultPartitionName) {
        this.startFunction(function, " : tbl=" + TableName.getQualified((String)catName, (String)db, (String)tbl) + ": Expression=" + expression + ": Default partition name=" + defaultPartitionName + ": Max partitions=" + maxParts);
    }

    private String getGroupsCountAndUsername(String user_name, List<String> group_names) {
        return ". Number of groups= " + (group_names == null ? 0 : group_names.size()) + ", user name= " + user_name;
    }

    private String samplePartitionValues(List<String> partVals) {
        if (CollectionUtils.isEmpty(partVals)) {
            return ": Partitions = []";
        }
        StringBuilder sb = new StringBuilder(": Number of Partitions = " + partVals.size());
        sb.append(": Partitions = [");
        if (partVals.size() > 4) {
            sb.append(org.apache.commons.lang3.StringUtils.join(partVals.subList(0, 2), (String)LOG_SAMPLE_PARTITIONS_SEPARATOR));
            sb.append(" .... ");
            sb.append(org.apache.commons.lang3.StringUtils.join(partVals.subList(partVals.size() - 2, partVals.size()), (String)LOG_SAMPLE_PARTITIONS_SEPARATOR));
        } else {
            sb.append(org.apache.commons.lang3.StringUtils.join(partVals, (String)LOG_SAMPLE_PARTITIONS_SEPARATOR));
        }
        sb.append("]");
        return sb.toString();
    }

    private void endFunction(String function, boolean successful, Exception e) {
        this.endFunction(function, successful, e, null);
    }

    private void endFunction(String function, boolean successful, Exception e, String inputTableName) {
        this.endFunction(function, new MetaStoreEndFunctionContext(successful, e, inputTableName));
    }

    private void endFunction(String function, MetaStoreEndFunctionContext context) {
        Counter counter;
        Timer.Context timerContext = HMSHandlerContext.getTimerContexts().remove(function);
        if (timerContext != null) {
            long timeTaken = timerContext.stop();
            LOG.debug((HMSHandler.getThreadLocalIpAddress() == null ? NO_FILTER_STRING : "source:" + HMSHandler.getThreadLocalIpAddress() + " ") + function + "time taken(ns): " + timeTaken);
        }
        if ((counter = Metrics.getOrCreateCounter("active_calls_" + function)) != null) {
            counter.dec();
        }
        for (MetaStoreEndFunctionListener listener : this.endFunctionListeners) {
            listener.onEndFunction(function, context);
        }
    }

    public fb_status getStatus() {
        return fb_status.ALIVE;
    }

    public void shutdown() {
        HMSHandler.cleanupHandlerContext();
        PerfLogger.getPerfLogger(false).cleanupPerfLogMetrics();
    }

    public AbstractMap<String, Long> getCounters() {
        AbstractMap counters = super.getCounters();
        if (this.endFunctionListeners != null) {
            for (MetaStoreEndFunctionListener listener : this.endFunctionListeners) {
                listener.exportCounters(counters);
            }
        }
        return counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create_catalog(CreateCatalogRequest rqst) throws AlreadyExistsException, InvalidObjectException, MetaException {
        Catalog catalog = rqst.getCatalog();
        this.startFunction("create_catalog", ": " + catalog.toString());
        boolean success = false;
        Throwable ex = null;
        try {
            try {
                this.getMS().getCatalog(catalog.getName());
                throw new AlreadyExistsException("Catalog " + catalog.getName() + " already exists");
            }
            catch (NoSuchObjectException noSuchObjectException) {
                if (!MetaStoreUtils.validateName((String)catalog.getName(), null)) {
                    throw new InvalidObjectException(catalog.getName() + " is not a valid catalog name");
                }
                if (catalog.getLocationUri() == null) {
                    throw new InvalidObjectException("You must specify a path for the catalog");
                }
                RawStore ms = this.getMS();
                Path catPath = new Path(catalog.getLocationUri());
                boolean madeDir = false;
                Map<String, String> transactionalListenersResponses = Collections.emptyMap();
                try {
                    this.firePreEvent(new PreCreateCatalogEvent(this, catalog));
                    if (!this.wh.isDir(catPath)) {
                        if (!this.wh.mkdirs(catPath)) {
                            throw new MetaException("Unable to create catalog path " + catPath + ", failed to create catalog " + catalog.getName());
                        }
                        madeDir = true;
                    }
                    long time = System.currentTimeMillis() / 1000L;
                    catalog.setCreateTime((int)time);
                    ms.openTransaction();
                    ms.createCatalog(catalog);
                    Database db = new Database("default", "Default database for catalog " + catalog.getName(), catalog.getLocationUri(), Collections.emptyMap());
                    db.setCatalogName(catalog.getName());
                    this.create_database_core(ms, db);
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.CREATE_CATALOG, new CreateCatalogEvent(true, this, catalog));
                    }
                    success = ms.commitTransaction();
                }
                finally {
                    if (!success) {
                        ms.rollbackTransaction();
                        if (madeDir) {
                            this.wh.deleteDir(catPath, true, false, false);
                        }
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_CATALOG, new CreateCatalogEvent(success, this, catalog), null, transactionalListenersResponses, ms);
                    }
                }
                success = true;
                this.endFunction("create_catalog", success, (Exception)ex);
            }
        }
        catch (AlreadyExistsException | InvalidObjectException | MetaException e) {
            try {
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("create_catalog", success, (Exception)ex);
                throw throwable;
            }
        }
    }

    public void alter_catalog(AlterCatalogRequest rqst) throws TException {
        this.startFunction("alter_catalog " + rqst.getName());
        boolean success = false;
        Throwable ex = null;
        RawStore ms = this.getMS();
        Map<String, String> transactionalListenersResponses = Collections.emptyMap();
        GetCatalogResponse oldCat = null;
        try {
            oldCat = this.get_catalog(new GetCatalogRequest(rqst.getName()));
            assert (oldCat != null && oldCat.getCatalog() != null);
            this.firePreEvent(new PreAlterCatalogEvent(oldCat.getCatalog(), rqst.getNewCat(), this));
            ms.openTransaction();
            ms.alterCatalog(rqst.getName(), rqst.getNewCat());
            if (!this.transactionalListeners.isEmpty()) {
                transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_CATALOG, new AlterCatalogEvent(oldCat.getCatalog(), rqst.getNewCat(), true, this));
            }
            success = ms.commitTransaction();
        }
        catch (MetaException | NoSuchObjectException e) {
            ex = e;
            throw e;
        }
        finally {
            if (!success) {
                ms.rollbackTransaction();
            }
            if (null != oldCat && !this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_CATALOG, new AlterCatalogEvent(oldCat.getCatalog(), rqst.getNewCat(), success, this), null, transactionalListenersResponses, ms);
            }
            this.endFunction("alter_catalog", success, (Exception)ex);
        }
    }

    public GetCatalogResponse get_catalog(GetCatalogRequest rqst) throws NoSuchObjectException, TException {
        String catName = rqst.getName();
        this.startFunction("get_catalog", ": " + catName);
        Catalog cat = null;
        Throwable ex = null;
        try {
            cat = this.getMS().getCatalog(catName);
            this.firePreEvent(new PreReadCatalogEvent(this, cat));
            GetCatalogResponse getCatalogResponse = new GetCatalogResponse(cat);
            this.endFunction("get_catalog", cat != null, (Exception)ex);
            return getCatalogResponse;
        }
        catch (MetaException | NoSuchObjectException e) {
            try {
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_catalog", cat != null, (Exception)ex);
                throw throwable;
            }
        }
    }

    public GetCatalogsResponse get_catalogs() throws MetaException {
        this.startFunction("get_catalogs");
        List<String> ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getCatalogs();
            this.endFunction("get_catalog", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_catalog", ret != null, ex);
                throw throwable;
            }
        }
        return new GetCatalogsResponse(ret == null ? Collections.emptyList() : ret);
    }

    public void drop_catalog(DropCatalogRequest rqst) throws NoSuchObjectException, InvalidOperationException, MetaException {
        String catName = rqst.getName();
        this.startFunction("drop_catalog", ": " + catName);
        if ("hive".equalsIgnoreCase(catName)) {
            this.endFunction("drop_catalog", false, null);
            throw new MetaException("Can not drop hive catalog");
        }
        boolean success = false;
        Exception ex = null;
        try {
            this.dropCatalogCore(catName);
            success = true;
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(NoSuchObjectException.class, InvalidOperationException.class, MetaException.class).defaultMetaException();
        }
        finally {
            this.endFunction("drop_catalog", success, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropCatalogCore(String catName) throws MetaException, NoSuchObjectException, InvalidOperationException {
        boolean success = false;
        Catalog cat = null;
        Map<String, String> transactionalListenerResponses = Collections.emptyMap();
        RawStore ms = this.getMS();
        try {
            ms.openTransaction();
            cat = ms.getCatalog(catName);
            this.firePreEvent(new PreDropCatalogEvent(this, cat));
            List<String> allDbs = this.get_databases(MetaStoreUtils.prependNotNullCatToDbName((String)catName, null));
            if (allDbs != null && !allDbs.isEmpty()) {
                if (allDbs.size() == 1 && allDbs.get(0).equals("default")) {
                    try {
                        DropDatabaseRequest req = new DropDatabaseRequest();
                        req.setName("default");
                        req.setCatalogName(catName);
                        req.setDeleteData(true);
                        req.setCascade(false);
                        this.drop_database_core(ms, req);
                    }
                    catch (InvalidOperationException e) {
                        throw new InvalidOperationException("There are still objects in the default database for catalog " + catName);
                    }
                    catch (IOException | InvalidInputException | InvalidObjectException e) {
                        MetaException me = new MetaException("Error attempt to drop default database for catalog " + catName);
                        me.initCause(e);
                        throw me;
                    }
                } else {
                    throw new InvalidOperationException("There are non-default databases in the catalog " + catName + " so it cannot be dropped.");
                }
            }
            ms.dropCatalog(catName);
            if (!this.transactionalListeners.isEmpty()) {
                transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_CATALOG, new DropCatalogEvent(true, this, cat));
            }
            success = ms.commitTransaction();
        }
        finally {
            if (success) {
                this.wh.deleteDir(this.wh.getDnsPath(new Path(cat.getLocationUri())), false, false, false);
            } else {
                ms.rollbackTransaction();
            }
            if (!this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_CATALOG, new DropCatalogEvent(success, this, cat), null, transactionalListenerResponses, ms);
            }
        }
    }

    static boolean isDbReplicationTarget(Database db) {
        String dbCkptStatus = db.getParameters() == null ? null : (String)db.getParameters().get("hive.repl.ckpt.key");
        return dbCkptStatus != null && !dbCkptStatus.trim().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create_database_core(RawStore ms, final Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
        Map<String, String> transactionalListenersResponses;
        boolean isReplicated;
        boolean success;
        block52: {
            Path dbMgdPath;
            if (!MetaStoreUtils.validateName((String)db.getName(), (Configuration)this.conf)) {
                throw new InvalidObjectException(db.getName() + " is not a valid database name");
            }
            Catalog cat = null;
            try {
                cat = this.getMS().getCatalog(db.getCatalogName());
            }
            catch (NoSuchObjectException e) {
                LOG.error("No such catalog " + db.getCatalogName());
                throw new InvalidObjectException("No such catalog " + db.getCatalogName());
            }
            boolean skipAuthorization = false;
            String passedInURI = db.getLocationUri();
            String passedInManagedURI = db.getManagedLocationUri();
            if (passedInURI == null && passedInManagedURI == null) {
                skipAuthorization = true;
            }
            Path defaultDbExtPath = this.wh.getDefaultDatabasePath(db.getName(), true);
            Path defaultDbMgdPath = this.wh.getDefaultDatabasePath(db.getName(), false);
            final Path dbExtPath = passedInURI != null ? this.wh.getDnsPath(new Path(passedInURI)) : this.wh.determineDatabasePath(cat, db);
            Path path = dbMgdPath = passedInManagedURI != null ? this.wh.getDnsPath(new Path(passedInManagedURI)) : null;
            if (defaultDbExtPath.equals((Object)dbExtPath) && defaultDbMgdPath.equals((Object)dbMgdPath) && (dbMgdPath == null || dbMgdPath.equals((Object)defaultDbMgdPath))) {
                skipAuthorization = true;
            }
            if (skipAuthorization) {
                db.setLocationUri(null);
                db.setManagedLocationUri(null);
            } else {
                db.setLocationUri(dbExtPath.toString());
                if (dbMgdPath != null) {
                    db.setManagedLocationUri(dbMgdPath.toString());
                }
            }
            if (db.getOwnerName() == null) {
                try {
                    db.setOwnerName(SecurityUtils.getUGI().getShortUserName());
                }
                catch (Exception e) {
                    LOG.warn("Failed to get owner name for create database operation.", (Throwable)e);
                }
            }
            long time = System.currentTimeMillis() / 1000L;
            db.setCreateTime((int)time);
            success = false;
            boolean madeManagedDir = false;
            boolean madeExternalDir = false;
            isReplicated = HMSHandler.isDbReplicationTarget(db);
            transactionalListenersResponses = Collections.emptyMap();
            try {
                this.firePreEvent(new PreCreateDatabaseEvent(db, (IHMSHandler)this));
                if (skipAuthorization) {
                    db.setLocationUri(dbExtPath.toString());
                    if (dbMgdPath != null) {
                        db.setManagedLocationUri(dbMgdPath.toString());
                    }
                }
                if (db.getCatalogName() != null && !db.getCatalogName().equals("hive")) {
                    if (!this.wh.isDir(dbExtPath)) {
                        LOG.debug("Creating database path " + dbExtPath);
                        if (!this.wh.mkdirs(dbExtPath)) {
                            throw new MetaException("Unable to create database path " + dbExtPath + ", failed to create database " + db.getName());
                        }
                        madeExternalDir = true;
                    }
                } else {
                    if (dbMgdPath != null) {
                        try {
                            madeManagedDir = (Boolean)UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                                @Override
                                public Boolean run() throws MetaException {
                                    if (!HMSHandler.this.wh.isDir(dbMgdPath)) {
                                        LOG.info("Creating database path in managed directory " + dbMgdPath);
                                        if (!HMSHandler.this.wh.mkdirs(dbMgdPath)) {
                                            throw new MetaException("Unable to create database managed path " + dbMgdPath + ", failed to create database " + db.getName());
                                        }
                                        return true;
                                    }
                                    return false;
                                }
                            });
                            if (madeManagedDir) {
                                LOG.info("Created database path in managed directory " + dbMgdPath);
                            } else if (!this.isInTest || !HMSHandler.isDbReplicationTarget(db)) {
                                throw new MetaException("Unable to create database managed directory " + dbMgdPath + ", failed to create database " + db.getName());
                            }
                        }
                        catch (IOException | InterruptedException e) {
                            throw new MetaException("Unable to create database managed directory " + dbMgdPath + ", failed to create database " + db.getName() + ":" + e.getMessage());
                        }
                    }
                    if (dbExtPath != null) {
                        try {
                            madeExternalDir = (Boolean)UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                                @Override
                                public Boolean run() throws MetaException {
                                    if (!HMSHandler.this.wh.isDir(dbExtPath)) {
                                        LOG.info("Creating database path in external directory " + dbExtPath);
                                        return HMSHandler.this.wh.mkdirs(dbExtPath);
                                    }
                                    return false;
                                }
                            });
                            if (madeExternalDir) {
                                LOG.info("Created database path in external directory " + dbExtPath);
                            }
                            LOG.warn("Failed to create external path " + dbExtPath + " for database " + db.getName() + ". This may result in access not being allowed if the StorageBasedAuthorizationProvider is enabled");
                        }
                        catch (IOException | InterruptedException | UndeclaredThrowableException e) {
                            throw new MetaException("Failed to create external path " + dbExtPath + " for database " + db.getName() + ". This may result in access not being allowed if the StorageBasedAuthorizationProvider is enabled: " + e.getMessage());
                        }
                    } else {
                        LOG.info("Database external path won't be created since the external warehouse directory is not defined");
                    }
                }
                ms.openTransaction();
                ms.createDatabase(db);
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.CREATE_DATABASE, new CreateDatabaseEvent(db, true, this, isReplicated));
                }
                if (success = ms.commitTransaction()) break block52;
                ms.rollbackTransaction();
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                    if (db.getCatalogName() != null && !db.getCatalogName().equals("hive")) {
                        if (madeManagedDir && dbMgdPath != null) {
                            this.wh.deleteDir(dbMgdPath, true, db);
                        }
                    } else {
                        if (madeManagedDir && dbMgdPath != null) {
                            try {
                                UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(dbMgdPath, db){
                                    final /* synthetic */ Path val$dbMgdPath;
                                    final /* synthetic */ Database val$db;
                                    {
                                        this.val$dbMgdPath = path;
                                        this.val$db = database;
                                    }

                                    @Override
                                    public Void run() throws Exception {
                                        HMSHandler.this.wh.deleteDir(this.val$dbMgdPath, true, this.val$db);
                                        return null;
                                    }
                                });
                            }
                            catch (IOException | InterruptedException e) {
                                LOG.error("Couldn't delete managed directory " + dbMgdPath + " after it was created for database " + db.getName() + " " + e.getMessage());
                            }
                        }
                        if (madeExternalDir && dbExtPath != null) {
                            try {
                                UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(dbExtPath, db){
                                    final /* synthetic */ Path val$dbExtPath;
                                    final /* synthetic */ Database val$db;
                                    {
                                        this.val$dbExtPath = path;
                                        this.val$db = database;
                                    }

                                    @Override
                                    public Void run() throws Exception {
                                        HMSHandler.this.wh.deleteDir(this.val$dbExtPath, true, this.val$db);
                                        return null;
                                    }
                                });
                            }
                            catch (IOException | InterruptedException e) {
                                LOG.error("Couldn't delete external directory " + dbExtPath + " after it was created for database " + db.getName() + " " + e.getMessage());
                            }
                        }
                    }
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_DATABASE, new CreateDatabaseEvent(db, success, this, isReplicated), null, transactionalListenersResponses, ms);
                }
                throw throwable;
            }
            if (db.getCatalogName() != null && !db.getCatalogName().equals("hive")) {
                if (madeManagedDir && dbMgdPath != null) {
                    this.wh.deleteDir(dbMgdPath, true, db);
                }
            } else {
                if (madeManagedDir && dbMgdPath != null) {
                    try {
                        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (IOException | InterruptedException e) {
                        LOG.error("Couldn't delete managed directory " + dbMgdPath + " after it was created for database " + db.getName() + " " + e.getMessage());
                    }
                }
                if (madeExternalDir && dbExtPath != null) {
                    try {
                        UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (IOException | InterruptedException e) {
                        LOG.error("Couldn't delete external directory " + dbExtPath + " after it was created for database " + db.getName() + " " + e.getMessage());
                    }
                }
            }
        }
        if (!this.listeners.isEmpty()) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_DATABASE, new CreateDatabaseEvent(db, success, this, isReplicated), null, transactionalListenersResponses, ms);
        }
    }

    @Deprecated
    public void create_database(Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
        CreateDatabaseRequest req = new CreateDatabaseRequest(db.getName());
        req.setDescription(db.getDescription());
        req.setLocationUri(db.getLocationUri());
        req.setParameters(db.getParameters());
        req.setPrivileges(db.getPrivileges());
        req.setOwnerName(db.getOwnerName());
        req.setOwnerType(db.getOwnerType());
        req.setCatalogName(db.getCatalogName());
        req.setCreateTime(db.getCreateTime());
        req.setManagedLocationUri(db.getManagedLocationUri());
        req.setType(db.getType());
        req.setDataConnectorName(db.getConnector_name());
        req.setRemote_dbname(db.getRemote_dbname());
        this.create_database_req(req);
        db.setLocationUri(req.getLocationUri());
        db.setManagedLocationUri(req.getManagedLocationUri());
    }

    public void create_database_req(CreateDatabaseRequest createDatabaseRequest) throws AlreadyExistsException, InvalidObjectException, MetaException {
        this.startFunction("create_database_req", ": " + createDatabaseRequest.getDatabaseName());
        boolean success = false;
        Exception ex = null;
        if (!createDatabaseRequest.isSetCatalogName()) {
            createDatabaseRequest.setCatalogName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        }
        try {
            try {
                if (null != this.get_database_core(createDatabaseRequest.getCatalogName(), createDatabaseRequest.getDatabaseName())) {
                    throw new AlreadyExistsException("Database " + createDatabaseRequest.getDatabaseName() + " already exists");
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            Database db = new Database(createDatabaseRequest.getDatabaseName(), createDatabaseRequest.getDescription(), createDatabaseRequest.getLocationUri(), createDatabaseRequest.getParameters());
            if (createDatabaseRequest.isSetPrivileges()) {
                db.setPrivileges(createDatabaseRequest.getPrivileges());
            }
            if (createDatabaseRequest.isSetOwnerName()) {
                db.setOwnerName(createDatabaseRequest.getOwnerName());
            }
            if (createDatabaseRequest.isSetOwnerType()) {
                db.setOwnerType(createDatabaseRequest.getOwnerType());
            }
            db.setCatalogName(createDatabaseRequest.getCatalogName());
            if (createDatabaseRequest.isSetCreateTime()) {
                db.setCreateTime(createDatabaseRequest.getCreateTime());
            } else {
                db.setCreateTime((int)(System.currentTimeMillis() / 1000L));
            }
            if (createDatabaseRequest.isSetManagedLocationUri()) {
                db.setManagedLocationUri(createDatabaseRequest.getManagedLocationUri());
            }
            if (createDatabaseRequest.isSetType()) {
                db.setType(createDatabaseRequest.getType());
            }
            if (createDatabaseRequest.isSetDataConnectorName()) {
                db.setConnector_name(createDatabaseRequest.getDataConnectorName());
            }
            if (createDatabaseRequest.isSetRemote_dbname()) {
                db.setRemote_dbname(createDatabaseRequest.getRemote_dbname());
            }
            this.create_database_core(this.getMS(), db);
            createDatabaseRequest.setLocationUri(db.getLocationUri());
            createDatabaseRequest.setManagedLocationUri(db.getManagedLocationUri());
            success = true;
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class, AlreadyExistsException.class).defaultMetaException();
        }
        finally {
            this.endFunction("create_database_req", success, ex);
        }
    }

    @Deprecated
    public Database get_database(String name) throws NoSuchObjectException, MetaException {
        GetDatabaseRequest request = new GetDatabaseRequest();
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)name, (Configuration)this.conf);
        request.setName(parsedDbName[1]);
        if (parsedDbName[0] != null) {
            request.setCatalogName(parsedDbName[0]);
        }
        return this.get_database_req(request);
    }

    @Override
    public Database get_database_core(String catName, String name) throws NoSuchObjectException, MetaException {
        Database db = null;
        if (name == null) {
            throw new MetaException("Database name cannot be null.");
        }
        try {
            db = this.getMS().getDatabase(catName, name);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).defaultRuntimeException();
        }
        return db;
    }

    public Database get_database_req(GetDatabaseRequest request) throws NoSuchObjectException, MetaException {
        this.startFunction("get_database", ": " + request.getName());
        Database db = null;
        Exception ex = null;
        if (request.getName() == null) {
            throw new MetaException("Database name cannot be null.");
        }
        List processorCapabilities = request.getProcessorCapabilities();
        String processorId = request.getProcessorIdentifier();
        try {
            db = this.getMS().getDatabase(request.getCatalogName(), request.getName());
            this.firePreEvent(new PreReadDatabaseEvent(db, (IHMSHandler)this));
            if (this.transformer != null) {
                db = this.transformer.transformDatabase(db, processorCapabilities, processorId);
            }
            this.endFunction("get_database", db != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).defaultRuntimeException();
            }
            catch (Throwable throwable) {
                this.endFunction("get_database", db != null, ex);
                throw throwable;
            }
        }
        return db;
    }

    @Deprecated
    public void alter_database(String dbName, Database newDB) throws TException {
        AlterDatabaseRequest alterDbReq = new AlterDatabaseRequest(dbName, newDB);
        this.alter_database_req(alterDbReq);
    }

    public void alter_database_req(AlterDatabaseRequest alterDbReq) throws TException {
        this.startFunction("alter_database_req " + alterDbReq.getOldDbName());
        boolean success = false;
        Throwable ex = null;
        RawStore ms = this.getMS();
        Database oldDB = null;
        Database newDB = alterDbReq.getNewDb();
        String dbName = alterDbReq.getOldDbName();
        Map<String, String> transactionalListenersResponses = Collections.emptyMap();
        if (newDB.getLocationUri() != null) {
            newDB.setLocationUri(this.wh.getDnsPath(new Path(newDB.getLocationUri())).toString());
        }
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        boolean isReplicated = HMSHandler.isDbReplicationTarget(newDB);
        try {
            AlterDatabaseEvent event;
            oldDB = this.get_database_core(parsedDbName[0], parsedDbName[1]);
            if (oldDB == null) {
                throw new MetaException("Could not alter database \"" + parsedDbName[1] + "\". Could not retrieve old definition.");
            }
            if (this.isReplicationEventIdUpdate(oldDB, newDB)) {
                LinkedHashMap<String, String> oldParams = new LinkedHashMap<String, String>(newDB.getParameters());
                String currentNotificationLogID = Long.toString(ms.getCurrentNotificationEventId().getEventId());
                oldParams.put("repl.target.last.id", currentNotificationLogID);
                LOG.debug("Adding the {} property for database {} with event id {}", new Object[]{"repl.target.last.id", newDB.getName(), currentNotificationLogID});
                newDB.setParameters(oldParams);
            }
            this.firePreEvent(new PreAlterDatabaseEvent(oldDB, newDB, this));
            ms.openTransaction();
            ms.alterDatabase(parsedDbName[0], parsedDbName[1], newDB);
            if (!this.transactionalListeners.isEmpty() && !(event = new AlterDatabaseEvent(oldDB, newDB, true, this, isReplicated)).shouldSkipCapturing()) {
                transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_DATABASE, event);
            }
            success = ms.commitTransaction();
        }
        catch (MetaException | NoSuchObjectException e) {
            ex = e;
            throw e;
        }
        finally {
            AlterDatabaseEvent event;
            if (!success) {
                ms.rollbackTransaction();
            }
            if (null != oldDB && !this.listeners.isEmpty() && !(event = new AlterDatabaseEvent(oldDB, newDB, success, this, isReplicated)).shouldSkipCapturing()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_DATABASE, event, null, transactionalListenersResponses, ms);
            }
            this.endFunction("alter_database_req", success, (Exception)ex);
        }
    }

    private boolean isReplicationEventIdUpdate(Database oldDb, Database newDb) {
        Map oldDbProp = oldDb.getParameters();
        Map newDbProp = newDb.getParameters();
        if (newDbProp == null || newDbProp.isEmpty() || Boolean.parseBoolean((String)newDbProp.get("repl.resume.started"))) {
            return false;
        }
        String newReplId = (String)newDbProp.get("repl.last.id");
        String oldReplId = oldDbProp != null ? (String)oldDbProp.get("repl.last.id") : null;
        return newReplId != null && !newReplId.equalsIgnoreCase(oldReplId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drop_database_core(RawStore ms, DropDatabaseRequest req) throws NoSuchObjectException, InvalidOperationException, MetaException, IOException, InvalidObjectException, InvalidInputException {
        boolean isReplicated;
        Map<String, String> transactionalListenerResponses;
        ArrayList<Path> partitionPaths;
        ArrayList<Path> tablePaths;
        Database db;
        boolean success;
        block70: {
            block68: {
                block69: {
                    success = false;
                    db = null;
                    tablePaths = new ArrayList<Path>();
                    partitionPaths = new ArrayList<Path>();
                    transactionalListenerResponses = Collections.emptyMap();
                    if (req.getName() == null) {
                        throw new MetaException("Database name cannot be null.");
                    }
                    isReplicated = false;
                    ms.openTransaction();
                    db = ms.getDatabase(req.getCatalogName(), req.getName());
                    if (db.getType() != DatabaseType.REMOTE) break block68;
                    success = this.drop_remote_database_core(ms, db);
                    if (success) break block69;
                    ms.rollbackTransaction();
                }
                if (req.isDeleteData()) {
                    Boolean deleted;
                    Path path;
                    this.deletePartitionData(partitionPaths, false, db);
                    for (Path tablePath : tablePaths) {
                        this.deleteTableData(tablePath, false, db);
                    }
                    Database dbFinal = db;
                    Path path2 = path = dbFinal.getManagedLocationUri() != null ? new Path(dbFinal.getManagedLocationUri()) : this.wh.getDatabaseManagedPath(dbFinal);
                    if (req.isDeleteManagedDir()) {
                        try {
                            deleted = (Boolean)UserGroupInformation.getLoginUser().doAs(() -> this.wh.deleteDir(path, true, dbFinal));
                            if (!deleted.booleanValue()) {
                                LOG.error("Failed to delete database's managed warehouse directory: " + path);
                            }
                        }
                        catch (Exception e) {
                            LOG.error("Failed to delete database's managed warehouse directory: " + path + " " + e.getMessage());
                        }
                    }
                    try {
                        deleted = (Boolean)UserGroupInformation.getCurrentUser().doAs(() -> this.wh.deleteDir(new Path(dbFinal.getLocationUri()), true, dbFinal));
                        if (!deleted.booleanValue()) {
                            LOG.error("Failed to delete database external warehouse directory " + db.getLocationUri());
                        }
                    }
                    catch (IOException | InterruptedException | UndeclaredThrowableException e) {
                        LOG.error("Failed to delete the database external warehouse directory: " + db.getLocationUri() + " " + e.getMessage());
                    }
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_DATABASE, new DropDatabaseEvent(db, success, this, isReplicated), null, transactionalListenerResponses, ms);
                }
                return;
            }
            try {
                Path path;
                isReplicated = HMSHandler.isDbReplicationTarget(db);
                if (!this.isInTest && ReplChangeManager.isSourceOfReplication((Database)db)) {
                    throw new InvalidOperationException("can not drop a database which is a source of replication");
                }
                this.firePreEvent(new PreDropDatabaseEvent(db, (IHMSHandler)this));
                String catPrependedName = MetaStoreUtils.prependCatalogToDbName((String)req.getCatalogName(), (String)req.getName(), (Configuration)this.conf);
                HashSet<String> uniqueTableNames = new HashSet<String>(this.get_all_tables(catPrependedName));
                List<String> allFunctions = this.get_functions(catPrependedName, "*");
                ListStoredProcedureRequest request = new ListStoredProcedureRequest(req.getCatalogName());
                request.setDbName(req.getName());
                List<String> allProcedures = this.get_all_stored_procedures(request);
                ListPackageRequest pkgRequest = new ListPackageRequest(req.getCatalogName());
                pkgRequest.setDbName(req.getName());
                List<String> allPackages = this.get_all_packages(pkgRequest);
                if (!req.isCascade()) {
                    if (!uniqueTableNames.isEmpty()) {
                        throw new InvalidOperationException("Database " + db.getName() + " is not empty. One or more tables exist.");
                    }
                    if (!allFunctions.isEmpty()) {
                        throw new InvalidOperationException("Database " + db.getName() + " is not empty. One or more functions exist.");
                    }
                    if (!allProcedures.isEmpty()) {
                        throw new InvalidOperationException("Database " + db.getName() + " is not empty. One or more stored procedures exist.");
                    }
                    if (!allPackages.isEmpty()) {
                        throw new InvalidOperationException("Database " + db.getName() + " is not empty. One or more packages exist.");
                    }
                }
                if (!this.wh.isWritable(path = new Path(db.getLocationUri()).getParent())) {
                    throw new MetaException("Database not dropped since its external warehouse location " + path + " is not writable by " + SecurityUtils.getUser());
                }
                path = this.wh.getDatabaseManagedPath(db).getParent();
                if (!this.wh.isWritable(path)) {
                    throw new MetaException("Database not dropped since its managed warehouse location " + path + " is not writable by " + SecurityUtils.getUser());
                }
                Path databasePath = this.wh.getDnsPath(this.wh.getDatabasePath(db));
                for (String funcName : allFunctions) {
                    this.drop_function(catPrependedName, funcName);
                }
                for (String procName : allProcedures) {
                    this.drop_stored_procedure(new StoredProcedureRequest(req.getCatalogName(), req.getName(), procName));
                }
                for (String pkgName : allPackages) {
                    this.drop_package(new DropPackageRequest(req.getCatalogName(), req.getName(), pkgName));
                }
                int tableBatchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
                List<String> materializedViewNames = this.getTablesByTypeCore(req.getCatalogName(), req.getName(), ".*", TableType.MATERIALIZED_VIEW.toString());
                int startIndex = 0;
                while (startIndex < materializedViewNames.size()) {
                    List<Table> materializedViews;
                    int endIndex = Math.min(startIndex + tableBatchSize, materializedViewNames.size());
                    try {
                        materializedViews = ms.getTableObjectsByName(req.getCatalogName(), req.getName(), materializedViewNames.subList(startIndex, endIndex));
                    }
                    catch (UnknownDBException e) {
                        throw new MetaException(e.getMessage());
                    }
                    if (materializedViews != null && !materializedViews.isEmpty()) {
                        for (Table materializedView : materializedViews) {
                            boolean isSoftDelete = TxnUtils.isTableSoftDeleteEnabled(materializedView, req.isSoftDelete());
                            if (materializedView.getSd().getLocation() != null && !isSoftDelete) {
                                Path materializedViewPath = this.wh.getDnsPath(new Path(materializedView.getSd().getLocation()));
                                if (!FileUtils.isSubdirectory((String)databasePath.toString(), (String)materializedViewPath.toString()) || req.isSoftDelete()) {
                                    if (!this.wh.isWritable(materializedViewPath.getParent())) {
                                        throw new MetaException("Database metadata not deleted since table: " + materializedView.getTableName() + " has a parent location " + materializedViewPath.getParent() + " which is not writable by " + SecurityUtils.getUser());
                                    }
                                    tablePaths.add(materializedViewPath);
                                }
                            }
                            EnvironmentContext context = null;
                            if (isSoftDelete) {
                                context = new EnvironmentContext();
                                context.putToProperties("txnId", String.valueOf(req.getTxnId()));
                            }
                            this.drop_table_with_environment_context(req.getName(), materializedView.getTableName(), false, context);
                            uniqueTableNames.remove(materializedView.getTableName());
                        }
                    }
                    startIndex = endIndex;
                }
                ArrayList<String> allTables = new ArrayList<String>(uniqueTableNames);
                startIndex = 0;
                while (startIndex < allTables.size()) {
                    List<Table> tables;
                    int endIndex = Math.min(startIndex + tableBatchSize, allTables.size());
                    try {
                        tables = ms.getTableObjectsByName(req.getCatalogName(), req.getName(), allTables.subList(startIndex, endIndex));
                    }
                    catch (UnknownDBException e) {
                        throw new MetaException(e.getMessage());
                    }
                    if (tables != null && !tables.isEmpty()) {
                        for (Table table : tables) {
                            boolean isSoftDelete = TxnUtils.isTableSoftDeleteEnabled(table, req.isSoftDelete());
                            Path tablePath = null;
                            boolean tableDataShouldBeDeleted = this.checkTableDataShouldBeDeleted(table, req.isDeleteData()) && !isSoftDelete;
                            boolean isManagedTable = table.getTableType().equals(TableType.MANAGED_TABLE.toString());
                            if (table.getSd().getLocation() != null && tableDataShouldBeDeleted) {
                                tablePath = this.wh.getDnsPath(new Path(table.getSd().getLocation()));
                                if (!isManagedTable || req.isSoftDelete()) {
                                    if (!this.wh.isWritable(tablePath.getParent())) {
                                        throw new MetaException("Database metadata not deleted since table: " + table.getTableName() + " has a parent location " + tablePath.getParent() + " which is not writable by " + SecurityUtils.getUser());
                                    }
                                    tablePaths.add(tablePath);
                                }
                            }
                            partitionPaths.addAll(this.dropPartitionsAndGetLocations(ms, req.getCatalogName(), req.getName(), table.getTableName(), tablePath, tableDataShouldBeDeleted));
                            EnvironmentContext context = null;
                            if (isSoftDelete) {
                                context = new EnvironmentContext();
                                context.putToProperties("txnId", String.valueOf(req.getTxnId()));
                                req.setDeleteManagedDir(false);
                            }
                            this.drop_table_with_environment_context(MetaStoreUtils.prependCatalogToDbName((String)table.getCatName(), (String)table.getDbName(), (Configuration)this.conf), table.getTableName(), false, context, false);
                        }
                    }
                    startIndex = endIndex;
                }
                if (ms.dropDatabase(req.getCatalogName(), req.getName())) {
                    if (!this.transactionalListeners.isEmpty()) {
                        DropDatabaseEvent dropEvent = new DropDatabaseEvent(db, true, this, isReplicated);
                        EnvironmentContext context = null;
                        if (!req.isDeleteManagedDir()) {
                            context = new EnvironmentContext();
                            context.putToProperties("txnId", String.valueOf(req.getTxnId()));
                        }
                        dropEvent.setEnvironmentContext(context);
                        transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_DATABASE, dropEvent);
                    }
                    success = ms.commitTransaction();
                }
                if (success) break block70;
                ms.rollbackTransaction();
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                } else if (req.isDeleteData()) {
                    Boolean deleted;
                    Path path;
                    this.deletePartitionData(partitionPaths, false, db);
                    for (Path tablePath : tablePaths) {
                        this.deleteTableData(tablePath, false, db);
                    }
                    Database dbFinal = db;
                    Path path3 = path = dbFinal.getManagedLocationUri() != null ? new Path(dbFinal.getManagedLocationUri()) : this.wh.getDatabaseManagedPath(dbFinal);
                    if (req.isDeleteManagedDir()) {
                        try {
                            deleted = (Boolean)UserGroupInformation.getLoginUser().doAs(() -> this.wh.deleteDir(path, true, dbFinal));
                            if (!deleted.booleanValue()) {
                                LOG.error("Failed to delete database's managed warehouse directory: " + path);
                            }
                        }
                        catch (Exception e) {
                            LOG.error("Failed to delete database's managed warehouse directory: " + path + " " + e.getMessage());
                        }
                    }
                    try {
                        deleted = (Boolean)UserGroupInformation.getCurrentUser().doAs(() -> this.wh.deleteDir(new Path(dbFinal.getLocationUri()), true, dbFinal));
                        if (!deleted.booleanValue()) {
                            LOG.error("Failed to delete database external warehouse directory " + db.getLocationUri());
                        }
                    }
                    catch (IOException | InterruptedException | UndeclaredThrowableException e) {
                        LOG.error("Failed to delete the database external warehouse directory: " + db.getLocationUri() + " " + e.getMessage());
                    }
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_DATABASE, new DropDatabaseEvent(db, success, this, isReplicated), null, transactionalListenerResponses, ms);
                }
                throw throwable;
            }
        }
        if (req.isDeleteData()) {
            Boolean deleted;
            Path path;
            this.deletePartitionData(partitionPaths, false, db);
            for (Path tablePath : tablePaths) {
                this.deleteTableData(tablePath, false, db);
            }
            Database dbFinal = db;
            Path path4 = path = dbFinal.getManagedLocationUri() != null ? new Path(dbFinal.getManagedLocationUri()) : this.wh.getDatabaseManagedPath(dbFinal);
            if (req.isDeleteManagedDir()) {
                try {
                    deleted = (Boolean)UserGroupInformation.getLoginUser().doAs(() -> this.wh.deleteDir(path, true, dbFinal));
                    if (!deleted.booleanValue()) {
                        LOG.error("Failed to delete database's managed warehouse directory: " + path);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to delete database's managed warehouse directory: " + path + " " + e.getMessage());
                }
            }
            try {
                deleted = (Boolean)UserGroupInformation.getCurrentUser().doAs(() -> this.wh.deleteDir(new Path(dbFinal.getLocationUri()), true, dbFinal));
                if (!deleted.booleanValue()) {
                    LOG.error("Failed to delete database external warehouse directory " + db.getLocationUri());
                }
            }
            catch (IOException | InterruptedException | UndeclaredThrowableException e) {
                LOG.error("Failed to delete the database external warehouse directory: " + db.getLocationUri() + " " + e.getMessage());
            }
        }
        if (!this.listeners.isEmpty()) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_DATABASE, new DropDatabaseEvent(db, success, this, isReplicated), null, transactionalListenerResponses, ms);
        }
    }

    private boolean drop_remote_database_core(RawStore ms, Database db) throws MetaException, NoSuchObjectException {
        boolean success = false;
        this.firePreEvent(new PreDropDatabaseEvent(db, (IHMSHandler)this));
        if (ms.dropDatabase(db.getCatalogName(), db.getName())) {
            success = ms.commitTransaction();
        }
        return success;
    }

    @Deprecated
    public void drop_database(String dbName, boolean deleteData, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        DropDatabaseRequest req = new DropDatabaseRequest();
        req.setName(parsedDbName[1]);
        req.setCatalogName(parsedDbName[0]);
        req.setDeleteData(deleteData);
        req.setCascade(cascade);
        this.drop_database_req(req);
    }

    public void drop_database_req(DropDatabaseRequest req) throws NoSuchObjectException, InvalidOperationException, MetaException {
        this.startFunction("drop_database", ": " + req.getName());
        if ("hive".equalsIgnoreCase(req.getCatalogName()) && "default".equalsIgnoreCase(req.getName())) {
            this.endFunction("drop_database", false, null);
            throw new MetaException("Can not drop default database in catalog hive");
        }
        boolean success = false;
        Exception ex = null;
        try {
            this.drop_database_core(this.getMS(), req);
            success = true;
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(NoSuchObjectException.class, InvalidOperationException.class, MetaException.class).defaultMetaException();
        }
        finally {
            this.endFunction("drop_database", success, ex);
        }
    }

    public List<String> get_databases(String pattern) throws MetaException {
        this.startFunction("get_databases", ": " + pattern);
        String[] parsedDbNamed = MetaStoreUtils.parseDbName((String)pattern, (Configuration)this.conf);
        List ret = null;
        Exception ex = null;
        try {
            if (parsedDbNamed[1] == null) {
                ret = this.getMS().getAllDatabases(parsedDbNamed[0]);
                ret = FilterUtils.filterDbNamesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, ret);
            } else {
                ret = this.getMS().getDatabases(parsedDbNamed[0], parsedDbNamed[1]);
                ret = FilterUtils.filterDbNamesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (List)ret);
            }
            this.endFunction("get_databases", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_databases", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public List<String> get_all_databases() throws MetaException {
        return this.get_databases(MetaStoreUtils.prependCatalogToDbName(null, null, (Configuration)this.conf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create_dataconnector_core(RawStore ms, DataConnector connector) throws AlreadyExistsException, InvalidObjectException, MetaException {
        if (!MetaStoreUtils.validateName((String)connector.getName(), (Configuration)this.conf)) {
            throw new InvalidObjectException(connector.getName() + " is not a valid dataconnector name");
        }
        if (connector.getOwnerName() == null) {
            try {
                connector.setOwnerName(SecurityUtils.getUGI().getShortUserName());
            }
            catch (Exception e) {
                LOG.warn("Failed to get owner name for create dataconnector operation.", (Throwable)e);
            }
        }
        long time = System.currentTimeMillis() / 1000L;
        connector.setCreateTime((int)time);
        boolean success = false;
        Map<String, String> transactionalListenersResponses = Collections.emptyMap();
        try {
            this.firePreEvent(new PreCreateDataConnectorEvent(connector, (IHMSHandler)this));
            ms.openTransaction();
            ms.createDataConnector(connector);
            if (!this.transactionalListeners.isEmpty()) {
                transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.CREATE_DATACONNECTOR, new CreateDataConnectorEvent(connector, true, this));
            }
            success = ms.commitTransaction();
        }
        finally {
            if (!success) {
                ms.rollbackTransaction();
            }
            if (!this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_DATACONNECTOR, new CreateDataConnectorEvent(connector, success, this), null, transactionalListenersResponses, ms);
            }
        }
    }

    public void create_dataconnector_req(CreateDataConnectorRequest connectorReq) throws AlreadyExistsException, InvalidObjectException, MetaException {
        this.startFunction("create_dataconnector_req", ": " + connectorReq.toString());
        boolean success = false;
        Exception ex = null;
        try {
            DataConnector connector = connectorReq.getConnector();
            try {
                if (null != this.get_dataconnector_core(connector.getName())) {
                    throw new AlreadyExistsException("DataConnector " + connector.getName() + " already exists");
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            this.create_dataconnector_core(this.getMS(), connector);
            success = true;
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class, AlreadyExistsException.class).defaultMetaException();
        }
        finally {
            this.endFunction("create_dataconnector_req", success, ex);
        }
    }

    @Override
    public DataConnector get_dataconnector_core(String name) throws NoSuchObjectException, MetaException {
        DataConnector connector = null;
        if (name == null) {
            throw new MetaException("Data connector name cannot be null.");
        }
        try {
            connector = this.getMS().getDataConnector(name);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).defaultRuntimeException();
        }
        return connector;
    }

    public DataConnector get_dataconnector_req(GetDataConnectorRequest request) throws NoSuchObjectException, MetaException {
        this.startFunction("get_dataconnector", ": " + request.getConnectorName());
        DataConnector connector = null;
        Exception ex = null;
        try {
            connector = this.get_dataconnector_core(request.getConnectorName());
            this.endFunction("get_dataconnector", connector != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).defaultRuntimeException();
            }
            catch (Throwable throwable) {
                this.endFunction("get_dataconnector", connector != null, ex);
                throw throwable;
            }
        }
        return connector;
    }

    public void alter_dataconnector_req(AlterDataConnectorRequest alterReq) throws TException {
        boolean success = false;
        Throwable ex = null;
        RawStore ms = this.getMS();
        DataConnector oldDC = null;
        Map transactionalListenersResponses = Collections.emptyMap();
        String dcName = alterReq.getConnectorName();
        DataConnector newDC = alterReq.getNewConnector();
        this.startFunction("alter_dataconnector " + dcName);
        try {
            oldDC = this.get_dataconnector_core(dcName);
            if (oldDC == null) {
                throw new MetaException("Could not alter dataconnector \"" + dcName + "\". Could not retrieve old definition.");
            }
            this.firePreEvent(new PreAlterDataConnectorEvent(oldDC, newDC, this));
            ms.openTransaction();
            ms.alterDataConnector(dcName, newDC);
            DataConnectorProviderFactory.invalidateDataConnectorFromCache(dcName);
            success = ms.commitTransaction();
        }
        catch (MetaException | NoSuchObjectException e) {
            ex = e;
            throw e;
        }
        finally {
            if (!success) {
                ms.rollbackTransaction();
            }
            this.endFunction("alter_database", success, (Exception)ex);
        }
    }

    public List<String> get_dataconnectors() throws MetaException {
        this.startFunction("get_dataconnectors");
        List ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getAllDataConnectorNames();
            ret = FilterUtils.filterDataConnectorsIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, ret);
            this.endFunction("get_dataconnectors", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_dataconnectors", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop_dataconnector_req(DropDataConnectorRequest dropDcReq) throws NoSuchObjectException, InvalidOperationException, MetaException {
        boolean success = false;
        DataConnector connector = null;
        Exception ex = null;
        RawStore ms = this.getMS();
        String dcName = dropDcReq.getConnectorName();
        boolean ifNotExists = dropDcReq.isIfNotExists();
        boolean checkReferences = dropDcReq.isCheckReferences();
        this.startFunction("drop_dataconnector_req", ": " + dcName);
        try {
            connector = this.getMS().getDataConnector(dcName);
            DataConnectorProviderFactory.invalidateDataConnectorFromCache(dcName);
        }
        catch (NoSuchObjectException e) {
            if (!ifNotExists) {
                throw new NoSuchObjectException("DataConnector " + dcName + " doesn't exist");
            }
            return;
        }
        try {
            ms.openTransaction();
            this.firePreEvent(new PreDropDataConnectorEvent(connector, (IHMSHandler)this));
            if (!ms.dropDataConnector(dcName)) {
                throw new MetaException("Unable to drop dataconnector " + dcName);
            }
            success = ms.commitTransaction();
        }
        finally {
            if (!success) {
                ms.rollbackTransaction();
            }
            this.endFunction("drop_dataconnector", success, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create_type_core(RawStore ms, Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
        if (!MetaStoreUtils.validateName((String)type.getName(), null)) {
            throw new InvalidObjectException("Invalid type name");
        }
        boolean success = false;
        try {
            ms.openTransaction();
            if (this.is_type_exists(ms, type.getName())) {
                throw new AlreadyExistsException("Type " + type.getName() + " already exists");
            }
            ms.createType(type);
            success = ms.commitTransaction();
        }
        finally {
            if (!success) {
                ms.rollbackTransaction();
            }
        }
    }

    public boolean create_type(Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
        this.startFunction("create_type", ": " + type.toString());
        boolean success = false;
        Exception ex = null;
        try {
            this.create_type_core(this.getMS(), type);
            success = true;
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class, AlreadyExistsException.class).defaultMetaException();
        }
        finally {
            this.endFunction("create_type", success, ex);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type get_type(String name) throws MetaException, NoSuchObjectException {
        this.startFunction("get_type", ": " + name);
        Type ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getType(name);
            if (null == ret) {
                throw new NoSuchObjectException("Type \"" + name + "\" not found.");
            }
            this.endFunction("get_type", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.throwMetaException(e);
                this.endFunction("get_type", ret != null, ex);
            }
            catch (Throwable throwable) {
                this.endFunction("get_type", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    private boolean is_type_exists(RawStore ms, String typeName) throws MetaException {
        return ms.getType(typeName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop_type(String name) throws MetaException, NoSuchObjectException {
        this.startFunction("drop_type", ": " + name);
        boolean success = false;
        Exception ex = null;
        try {
            success = this.getMS().dropType(name);
        }
        catch (Exception e) {
            ex = e;
            ExceptionHandler.throwMetaException(e);
        }
        finally {
            this.endFunction("drop_type", success, ex);
        }
        return success;
    }

    public Map<String, Type> get_type_all(String name) throws MetaException {
        this.startFunction("get_type_all", ": " + name);
        this.endFunction("get_type_all", false, null);
        throw new MetaException("Not yet implemented");
    }

    public Table translate_table_dryrun(CreateTableRequest req) throws AlreadyExistsException, MetaException, InvalidObjectException, InvalidInputException {
        Table transformedTbl = null;
        Table tbl = req.getTable();
        List processorCapabilities = req.getProcessorCapabilities();
        String processorId = req.getProcessorIdentifier();
        if (!tbl.isSetCatName()) {
            tbl.setCatName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        }
        if (this.transformer != null) {
            transformedTbl = this.transformer.transformCreateTable(tbl, processorCapabilities, processorId);
        }
        return transformedTbl != null ? transformedTbl : tbl;
    }

    private void create_table_core(RawStore ms, Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        CreateTableRequest req = new CreateTableRequest(tbl);
        req.setEnvContext(envContext);
        this.create_table_core(ms, req);
    }

    private void create_table_core(RawStore ms, Table tbl, EnvironmentContext envContext, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints, List<String> processorCapabilities, String processorIdentifier) throws AlreadyExistsException, MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        CreateTableRequest req = new CreateTableRequest(tbl);
        if (envContext != null) {
            req.setEnvContext(envContext);
        }
        if (primaryKeys != null) {
            req.setPrimaryKeys(primaryKeys);
        }
        if (foreignKeys != null) {
            req.setForeignKeys(foreignKeys);
        }
        if (uniqueConstraints != null) {
            req.setUniqueConstraints(uniqueConstraints);
        }
        if (notNullConstraints != null) {
            req.setNotNullConstraints(notNullConstraints);
        }
        if (defaultConstraints != null) {
            req.setDefaultConstraints(defaultConstraints);
        }
        if (checkConstraints != null) {
            req.setCheckConstraints(checkConstraints);
        }
        if (processorCapabilities != null) {
            req.setProcessorCapabilities(processorCapabilities);
            req.setProcessorIdentifier(processorIdentifier);
        }
        this.create_table_core(ms, req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create_table_core(RawStore ms, CreateTableRequest req) throws AlreadyExistsException, MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        boolean isReplicated;
        boolean success;
        Map<String, String> transactionalListenerResponses;
        SQLAllTableConstraints constraints;
        EnvironmentContext envContext;
        Table tbl;
        ColumnStatistics colStats;
        block59: {
            SkewedInfo skew;
            String validate;
            Map params;
            Database db;
            colStats = null;
            tbl = req.getTable();
            envContext = req.getEnvContext();
            constraints = new SQLAllTableConstraints();
            constraints.setPrimaryKeys(req.getPrimaryKeys());
            constraints.setForeignKeys(req.getForeignKeys());
            constraints.setUniqueConstraints(req.getUniqueConstraints());
            constraints.setDefaultConstraints(req.getDefaultConstraints());
            constraints.setCheckConstraints(req.getCheckConstraints());
            constraints.setNotNullConstraints(req.getNotNullConstraints());
            List processorCapabilities = req.getProcessorCapabilities();
            String processorId = req.getProcessorIdentifier();
            if (tbl.getDbName() == null) {
                throw new MetaException("Null database name is not allowed");
            }
            if (!MetaStoreUtils.validateName((String)tbl.getTableName(), (Configuration)this.conf)) {
                throw new InvalidObjectException(tbl.getTableName() + " is not a valid object name");
            }
            if (!MetaStoreUtils.validateTblStorage((StorageDescriptor)tbl.getSd())) {
                throw new InvalidObjectException(tbl.getTableName() + " location must not be root path");
            }
            if (!tbl.isSetCatName()) {
                tbl.setCatName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
            }
            if ((db = this.get_database_core(tbl.getCatName(), tbl.getDbName())) != null && db.getType().equals((Object)DatabaseType.REMOTE)) {
                throw new MetaException("Create table in REMOTE database " + db.getName() + " is not allowed");
            }
            if (this.is_table_exists(ms, tbl.getCatName(), tbl.getDbName(), tbl.getTableName())) {
                throw new AlreadyExistsException("Table " + Warehouse.getCatalogQualifiedTableName((Table)tbl) + " already exists");
            }
            tbl.setDbName(StringUtils.normalizeIdentifier((String)tbl.getDbName()));
            tbl.setTableName(StringUtils.normalizeIdentifier((String)tbl.getTableName()));
            if (this.transformer != null) {
                tbl = this.transformer.transformCreateTable(tbl, processorCapabilities, processorId);
            }
            if ((params = tbl.getParameters()) != null) {
                params.remove("created_with_ctas");
                params.remove("created_with_ctlt");
                if (MetaStoreServerUtils.getBooleanEnvProp(envContext, "create_table_as_external") && TableType.MANAGED_TABLE.toString().equals(tbl.getTableType())) {
                    params.put("EXTERNAL", "TRUE");
                    tbl.setTableType(TableType.EXTERNAL_TABLE.toString());
                }
            }
            if (tbl.isSetColStats()) {
                colStats = tbl.getColStats();
                tbl.unsetColStats();
            }
            if ((validate = MetaStoreServerUtils.validateTblColumns(tbl.getSd().getCols())) != null) {
                throw new InvalidObjectException("Invalid column " + validate);
            }
            if (tbl.getPartitionKeys() != null && (validate = MetaStoreServerUtils.validateTblColumns(tbl.getPartitionKeys())) != null) {
                throw new InvalidObjectException("Invalid partition column " + validate);
            }
            if (tbl.isSetId()) {
                LOG.debug("Id shouldn't be set but table {}.{} has the Id set to {}. Id is ignored.", new Object[]{tbl.getDbName(), tbl.getTableName(), tbl.getId()});
                tbl.unsetId();
            }
            if ((skew = tbl.getSd().getSkewedInfo()) != null) {
                validate = MetaStoreServerUtils.validateSkewedColNames(skew.getSkewedColNames());
                if (validate != null) {
                    throw new InvalidObjectException("Invalid skew column " + validate);
                }
                validate = MetaStoreServerUtils.validateSkewedColNamesSubsetCol(skew.getSkewedColNames(), tbl.getSd().getCols());
                if (validate != null) {
                    throw new InvalidObjectException("Invalid skew column " + validate);
                }
            }
            transactionalListenerResponses = Collections.emptyMap();
            Path tblPath = null;
            success = false;
            boolean madeDir = false;
            isReplicated = false;
            try {
                ms.openTransaction();
                db = ms.getDatabase(tbl.getCatName(), tbl.getDbName());
                isReplicated = HMSHandler.isDbReplicationTarget(db);
                this.firePreEvent(new PreCreateTableEvent(tbl, db, this));
                if (!TableType.VIRTUAL_VIEW.toString().equals(tbl.getTableType())) {
                    if (tbl.getSd().getLocation() == null || tbl.getSd().getLocation().isEmpty()) {
                        tblPath = this.wh.getDefaultTablePath(db, tbl.getTableName() + this.getTableSuffix(tbl), MetaStoreUtils.isExternalTable((Table)tbl));
                    } else {
                        if (!MetaStoreUtils.isExternalTable((Table)tbl) && !MetaStoreUtils.isNonNativeTable((Table)tbl)) {
                            LOG.warn("Location: " + tbl.getSd().getLocation() + " specified for non-external table:" + tbl.getTableName());
                        }
                        if (!(tblPath = this.wh.getDnsPath(new Path(tbl.getSd().getLocation()))).getName().matches("(.*)\\.v\\d+")) {
                            tblPath = new Path(tblPath + this.getTableSuffix(tbl));
                        }
                    }
                    tbl.getSd().setLocation(tblPath.toString());
                }
                if (tblPath != null && !this.wh.isDir(tblPath)) {
                    if (!this.wh.mkdirs(tblPath)) {
                        throw new MetaException(tblPath + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                MetaStoreServerUtils.updateTableStatsForCreateTable(this.wh, db, tbl, envContext, this.conf, tblPath, madeDir);
                long time = System.currentTimeMillis() / 1000L;
                tbl.setCreateTime((int)time);
                if (tbl.getParameters() == null || tbl.getParameters().get("transient_lastDdlTime") == null) {
                    tbl.putToParameters("transient_lastDdlTime", Long.toString(time));
                }
                if (CollectionUtils.isEmpty((Collection)constraints.getPrimaryKeys()) && CollectionUtils.isEmpty((Collection)constraints.getForeignKeys()) && CollectionUtils.isEmpty((Collection)constraints.getUniqueConstraints()) && CollectionUtils.isEmpty((Collection)constraints.getNotNullConstraints()) && CollectionUtils.isEmpty((Collection)constraints.getDefaultConstraints()) && CollectionUtils.isEmpty((Collection)constraints.getCheckConstraints())) {
                    ms.createTable(tbl);
                } else {
                    String catName = tbl.getCatName();
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getPrimaryKeys()) && !((SQLPrimaryKey)constraints.getPrimaryKeys().get(0)).isSetCatName()) {
                        constraints.getPrimaryKeys().forEach(constraint -> constraint.setCatName(catName));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getForeignKeys()) && !((SQLForeignKey)constraints.getForeignKeys().get(0)).isSetCatName()) {
                        constraints.getForeignKeys().forEach(constraint -> constraint.setCatName(catName));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getUniqueConstraints()) && !((SQLUniqueConstraint)constraints.getUniqueConstraints().get(0)).isSetCatName()) {
                        constraints.getUniqueConstraints().forEach(constraint -> constraint.setCatName(catName));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getNotNullConstraints()) && !((SQLNotNullConstraint)constraints.getNotNullConstraints().get(0)).isSetCatName()) {
                        constraints.getNotNullConstraints().forEach(constraint -> constraint.setCatName(catName));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getDefaultConstraints()) && !((SQLDefaultConstraint)constraints.getDefaultConstraints().get(0)).isSetCatName()) {
                        constraints.getDefaultConstraints().forEach(constraint -> constraint.setCatName(catName));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getCheckConstraints()) && !((SQLCheckConstraint)constraints.getCheckConstraints().get(0)).isSetCatName()) {
                        constraints.getCheckConstraints().forEach(constraint -> constraint.setCatName(catName));
                    }
                    constraints = ms.createTableWithConstraints(tbl, constraints);
                }
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.CREATE_TABLE, new CreateTableEvent(tbl, true, this, isReplicated), envContext);
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getPrimaryKeys())) {
                        MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_PRIMARYKEY, new AddPrimaryKeyEvent(constraints.getPrimaryKeys(), true, this), envContext);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getForeignKeys())) {
                        MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_FOREIGNKEY, new AddForeignKeyEvent(constraints.getForeignKeys(), true, this), envContext);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getUniqueConstraints())) {
                        MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_UNIQUECONSTRAINT, new AddUniqueConstraintEvent(constraints.getUniqueConstraints(), true, this), envContext);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getNotNullConstraints())) {
                        MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_NOTNULLCONSTRAINT, new AddNotNullConstraintEvent(constraints.getNotNullConstraints(), true, this), envContext);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getCheckConstraints())) {
                        MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_CHECKCONSTRAINT, new AddCheckConstraintEvent(constraints.getCheckConstraints(), true, this), envContext);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getDefaultConstraints())) {
                        MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_DEFAULTCONSTRAINT, new AddDefaultConstraintEvent(constraints.getDefaultConstraints(), true, this), envContext);
                    }
                }
                if (success = ms.commitTransaction()) break block59;
                ms.rollbackTransaction();
                if (!madeDir) break block59;
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                    if (madeDir) {
                        this.wh.deleteDir(tblPath, true, false, ReplChangeManager.shouldEnableCm((Database)db, (Table)tbl));
                    }
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_TABLE, new CreateTableEvent(tbl, success, this, isReplicated), envContext, transactionalListenerResponses, ms);
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getPrimaryKeys())) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PRIMARYKEY, new AddPrimaryKeyEvent(constraints.getPrimaryKeys(), success, this), envContext);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getForeignKeys())) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_FOREIGNKEY, new AddForeignKeyEvent(constraints.getForeignKeys(), success, this), envContext);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getUniqueConstraints())) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_UNIQUECONSTRAINT, new AddUniqueConstraintEvent(constraints.getUniqueConstraints(), success, this), envContext);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getNotNullConstraints())) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_NOTNULLCONSTRAINT, new AddNotNullConstraintEvent(constraints.getNotNullConstraints(), success, this), envContext);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getDefaultConstraints())) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_DEFAULTCONSTRAINT, new AddDefaultConstraintEvent(constraints.getDefaultConstraints(), success, this), envContext);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)constraints.getCheckConstraints())) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_CHECKCONSTRAINT, new AddCheckConstraintEvent(constraints.getCheckConstraints(), success, this), envContext);
                    }
                }
                throw throwable;
            }
            this.wh.deleteDir(tblPath, true, false, ReplChangeManager.shouldEnableCm((Database)db, (Table)tbl));
        }
        if (!this.listeners.isEmpty()) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_TABLE, new CreateTableEvent(tbl, success, this, isReplicated), envContext, transactionalListenerResponses, ms);
            if (CollectionUtils.isNotEmpty((Collection)constraints.getPrimaryKeys())) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PRIMARYKEY, new AddPrimaryKeyEvent(constraints.getPrimaryKeys(), success, this), envContext);
            }
            if (CollectionUtils.isNotEmpty((Collection)constraints.getForeignKeys())) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_FOREIGNKEY, new AddForeignKeyEvent(constraints.getForeignKeys(), success, this), envContext);
            }
            if (CollectionUtils.isNotEmpty((Collection)constraints.getUniqueConstraints())) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_UNIQUECONSTRAINT, new AddUniqueConstraintEvent(constraints.getUniqueConstraints(), success, this), envContext);
            }
            if (CollectionUtils.isNotEmpty((Collection)constraints.getNotNullConstraints())) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_NOTNULLCONSTRAINT, new AddNotNullConstraintEvent(constraints.getNotNullConstraints(), success, this), envContext);
            }
            if (CollectionUtils.isNotEmpty((Collection)constraints.getDefaultConstraints())) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_DEFAULTCONSTRAINT, new AddDefaultConstraintEvent(constraints.getDefaultConstraints(), success, this), envContext);
            }
            if (CollectionUtils.isNotEmpty((Collection)constraints.getCheckConstraints())) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_CHECKCONSTRAINT, new AddCheckConstraintEvent(constraints.getCheckConstraints(), success, this), envContext);
            }
        }
        if (colStats != null) {
            long writeId = tbl.getWriteId();
            String validWriteIds = null;
            if (writeId > 0L) {
                ValidReaderWriteIdList validWriteIdList = new ValidReaderWriteIdList(TableName.getDbTable((String)tbl.getDbName(), (String)tbl.getTableName()), new long[0], new BitSet(), writeId);
                validWriteIds = validWriteIdList.toString();
            }
            this.updateTableColumnStatsInternal(colStats, validWriteIds, tbl.getWriteId());
        }
    }

    private String getTableSuffix(Table tbl) {
        return tbl.isSetTxnId() && tbl.getParameters() != null && Boolean.parseBoolean((String)tbl.getParameters().get("soft_delete")) ? ".v" + String.format("%07d", tbl.getTxnId()) : NO_FILTER_STRING;
    }

    @Deprecated
    public void create_table(Table tbl) throws AlreadyExistsException, MetaException, InvalidObjectException, InvalidInputException {
        CreateTableRequest createTableReq = new CreateTableRequest(tbl);
        this.create_table_req(createTableReq);
    }

    @Deprecated
    public void create_table_with_environment_context(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, MetaException, InvalidObjectException, InvalidInputException {
        this.startFunction("create_table_with_environment_context", ": " + tbl.getTableName());
        boolean success = false;
        Exception ex = null;
        try {
            CreateTableRequest createTableReq = new CreateTableRequest(tbl);
            if (envContext != null) {
                createTableReq.setEnvContext(envContext);
            }
            this.create_table_req(createTableReq);
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class).throwIfInstance(AlreadyExistsException.class, InvalidInputException.class).defaultMetaException();
        }
        finally {
            this.endFunction("create_table_with_environment_context", success, ex, tbl.getTableName());
        }
    }

    public void create_table_req(CreateTableRequest req) throws AlreadyExistsException, MetaException, InvalidObjectException, InvalidInputException {
        Table tbl = req.getTable();
        this.startFunction("create_table_req", ": " + tbl.toString());
        boolean success = false;
        Exception ex = null;
        try {
            this.create_table_core(this.getMS(), req);
            success = true;
        }
        catch (Exception e) {
            LOG.warn("create_table_req got ", (Throwable)e);
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class).throwIfInstance(AlreadyExistsException.class, InvalidInputException.class).convertIfInstance(NoSuchObjectException.class, InvalidObjectException.class).defaultMetaException();
        }
        finally {
            this.endFunction("create_table_req", success, ex, tbl.getTableName());
        }
    }

    @Deprecated
    public void create_table_with_constraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws AlreadyExistsException, MetaException, InvalidObjectException, InvalidInputException {
        this.startFunction("create_table_with_constraints", ": " + tbl.toString());
        boolean success = false;
        Exception ex = null;
        try {
            CreateTableRequest req = new CreateTableRequest(tbl);
            req.setPrimaryKeys(primaryKeys);
            req.setForeignKeys(foreignKeys);
            req.setUniqueConstraints(uniqueConstraints);
            req.setNotNullConstraints(notNullConstraints);
            req.setDefaultConstraints(defaultConstraints);
            req.setCheckConstraints(checkConstraints);
            this.create_table_req(req);
            success = true;
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class).throwIfInstance(AlreadyExistsException.class, InvalidInputException.class).defaultMetaException();
        }
        finally {
            this.endFunction("create_table_with_constraints", success, ex, tbl.getTableName());
        }
    }

    public void drop_constraint(DropConstraintRequest req) throws MetaException, InvalidObjectException {
        Exception ex;
        boolean success;
        String constraintName;
        block11: {
            String catName = req.isSetCatName() ? req.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
            String dbName = req.getDbname();
            String tableName = req.getTablename();
            constraintName = req.getConstraintname();
            this.startFunction("drop_constraint", ": " + constraintName);
            success = false;
            ex = null;
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                ms.dropConstraint(catName, dbName, tableName, constraintName);
                if (this.transactionalListeners.size() > 0) {
                    DropConstraintEvent dropConstraintEvent = new DropConstraintEvent(catName, dbName, tableName, constraintName, true, this);
                    for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                        metaStoreEventListener.onDropConstraint(dropConstraintEvent);
                    }
                }
                if (!(success = ms.commitTransaction())) {
                    ms.rollbackTransaction();
                    break block11;
                }
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).convertIfInstance(NoSuchObjectException.class, InvalidObjectException.class).defaultMetaException();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else {
                        for (MetaStoreEventListener listener : this.listeners) {
                            DropConstraintEvent dropConstraintEvent = new DropConstraintEvent(catName, dbName, tableName, constraintName, true, this);
                            listener.onDropConstraint(dropConstraintEvent);
                        }
                    }
                    this.endFunction("drop_constraint", success, ex, constraintName);
                    throw throwable;
                }
            }
            for (MetaStoreEventListener listener : this.listeners) {
                DropConstraintEvent dropConstraintEvent = new DropConstraintEvent(catName, dbName, tableName, constraintName, true, this);
                listener.onDropConstraint(dropConstraintEvent);
            }
        }
        this.endFunction("drop_constraint", success, ex, constraintName);
    }

    public void add_primary_key(AddPrimaryKeyRequest req) throws MetaException, InvalidObjectException {
        Exception ex;
        boolean success;
        String constraintName;
        block13: {
            List primaryKeyCols = req.getPrimaryKeyCols();
            constraintName = CollectionUtils.isNotEmpty((Collection)primaryKeyCols) ? ((SQLPrimaryKey)primaryKeyCols.get(0)).getPk_name() : "null";
            this.startFunction("add_primary_key", ": " + constraintName);
            success = false;
            ex = null;
            if (CollectionUtils.isNotEmpty((Collection)primaryKeyCols) && !((SQLPrimaryKey)primaryKeyCols.get(0)).isSetCatName()) {
                String defaultCat = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
                primaryKeyCols.forEach(pk -> pk.setCatName(defaultCat));
            }
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                List<SQLPrimaryKey> primaryKeys = ms.addPrimaryKeys(primaryKeyCols);
                if (this.transactionalListeners.size() > 0 && CollectionUtils.isNotEmpty(primaryKeys)) {
                    AddPrimaryKeyEvent addPrimaryKeyEvent = new AddPrimaryKeyEvent(primaryKeys, true, this);
                    for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                        metaStoreEventListener.onAddPrimaryKey(addPrimaryKeyEvent);
                    }
                }
                if (!(success = ms.commitTransaction())) {
                    ms.rollbackTransaction();
                    break block13;
                }
                if (primaryKeyCols == null || primaryKeyCols.size() <= 0) break block13;
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class).defaultMetaException();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else if (primaryKeyCols != null && primaryKeyCols.size() > 0) {
                        for (MetaStoreEventListener listener : this.listeners) {
                            AddPrimaryKeyEvent addPrimaryKeyEvent = new AddPrimaryKeyEvent(primaryKeyCols, true, this);
                            listener.onAddPrimaryKey(addPrimaryKeyEvent);
                        }
                    }
                    this.endFunction("add_primary_key", success, ex, constraintName);
                    throw throwable;
                }
            }
            for (MetaStoreEventListener listener : this.listeners) {
                AddPrimaryKeyEvent addPrimaryKeyEvent = new AddPrimaryKeyEvent(primaryKeyCols, true, this);
                listener.onAddPrimaryKey(addPrimaryKeyEvent);
            }
        }
        this.endFunction("add_primary_key", success, ex, constraintName);
    }

    public void add_foreign_key(AddForeignKeyRequest req) throws MetaException, InvalidObjectException {
        Exception ex;
        boolean success;
        String constraintName;
        List<SQLForeignKey> foreignKeys;
        block13: {
            foreignKeys = req.getForeignKeyCols();
            constraintName = CollectionUtils.isNotEmpty((Collection)foreignKeys) ? ((SQLForeignKey)foreignKeys.get(0)).getFk_name() : "null";
            this.startFunction("add_foreign_key", ": " + constraintName);
            success = false;
            ex = null;
            if (CollectionUtils.isNotEmpty((Collection)foreignKeys) && !((SQLForeignKey)foreignKeys.get(0)).isSetCatName()) {
                String defaultCat = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
                foreignKeys.forEach(pk -> pk.setCatName(defaultCat));
            }
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                foreignKeys = ms.addForeignKeys(foreignKeys);
                if (this.transactionalListeners.size() > 0 && CollectionUtils.isNotEmpty(foreignKeys)) {
                    AddForeignKeyEvent addForeignKeyEvent = new AddForeignKeyEvent(foreignKeys, true, this);
                    for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                        metaStoreEventListener.onAddForeignKey(addForeignKeyEvent);
                    }
                }
                if (success = ms.commitTransaction()) break block13;
                ms.rollbackTransaction();
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class).defaultMetaException();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else if (CollectionUtils.isNotEmpty((Collection)foreignKeys)) {
                        for (MetaStoreEventListener listener : this.listeners) {
                            AddForeignKeyEvent addForeignKeyEvent = new AddForeignKeyEvent(foreignKeys, true, this);
                            listener.onAddForeignKey(addForeignKeyEvent);
                        }
                    }
                    this.endFunction("add_foreign_key", success, ex, constraintName);
                    throw throwable;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(foreignKeys)) {
            for (MetaStoreEventListener listener : this.listeners) {
                AddForeignKeyEvent addForeignKeyEvent = new AddForeignKeyEvent(foreignKeys, true, this);
                listener.onAddForeignKey(addForeignKeyEvent);
            }
        }
        this.endFunction("add_foreign_key", success, ex, constraintName);
    }

    public void add_unique_constraint(AddUniqueConstraintRequest req) throws MetaException, InvalidObjectException {
        Exception ex;
        boolean success;
        String constraintName;
        List<SQLUniqueConstraint> uniqueConstraints;
        block13: {
            uniqueConstraints = req.getUniqueConstraintCols();
            constraintName = uniqueConstraints != null && uniqueConstraints.size() > 0 ? ((SQLUniqueConstraint)uniqueConstraints.get(0)).getUk_name() : "null";
            this.startFunction("add_unique_constraint", ": " + constraintName);
            success = false;
            ex = null;
            if (!uniqueConstraints.isEmpty() && !((SQLUniqueConstraint)uniqueConstraints.get(0)).isSetCatName()) {
                String defaultCat = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
                uniqueConstraints.forEach(pk -> pk.setCatName(defaultCat));
            }
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                uniqueConstraints = ms.addUniqueConstraints(uniqueConstraints);
                if (this.transactionalListeners.size() > 0 && CollectionUtils.isNotEmpty(uniqueConstraints)) {
                    AddUniqueConstraintEvent addUniqueConstraintEvent = new AddUniqueConstraintEvent(uniqueConstraints, true, this);
                    for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                        metaStoreEventListener.onAddUniqueConstraint(addUniqueConstraintEvent);
                    }
                }
                if (success = ms.commitTransaction()) break block13;
                ms.rollbackTransaction();
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class).defaultMetaException();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else if (CollectionUtils.isNotEmpty((Collection)uniqueConstraints)) {
                        for (MetaStoreEventListener listener : this.listeners) {
                            AddUniqueConstraintEvent addUniqueConstraintEvent = new AddUniqueConstraintEvent(uniqueConstraints, true, this);
                            listener.onAddUniqueConstraint(addUniqueConstraintEvent);
                        }
                    }
                    this.endFunction("add_unique_constraint", success, ex, constraintName);
                    throw throwable;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(uniqueConstraints)) {
            for (MetaStoreEventListener listener : this.listeners) {
                AddUniqueConstraintEvent addUniqueConstraintEvent = new AddUniqueConstraintEvent(uniqueConstraints, true, this);
                listener.onAddUniqueConstraint(addUniqueConstraintEvent);
            }
        }
        this.endFunction("add_unique_constraint", success, ex, constraintName);
    }

    public void add_not_null_constraint(AddNotNullConstraintRequest req) throws MetaException, InvalidObjectException {
        Exception ex;
        boolean success;
        String constraintName;
        List<SQLNotNullConstraint> notNullConstraints;
        block13: {
            notNullConstraints = req.getNotNullConstraintCols();
            constraintName = notNullConstraints != null && notNullConstraints.size() > 0 ? ((SQLNotNullConstraint)notNullConstraints.get(0)).getNn_name() : "null";
            this.startFunction("add_not_null_constraint", ": " + constraintName);
            success = false;
            ex = null;
            if (!notNullConstraints.isEmpty() && !((SQLNotNullConstraint)notNullConstraints.get(0)).isSetCatName()) {
                String defaultCat = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
                notNullConstraints.forEach(pk -> pk.setCatName(defaultCat));
            }
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                notNullConstraints = ms.addNotNullConstraints(notNullConstraints);
                if (this.transactionalListeners.size() > 0 && CollectionUtils.isNotEmpty(notNullConstraints)) {
                    AddNotNullConstraintEvent addNotNullConstraintEvent = new AddNotNullConstraintEvent(notNullConstraints, true, this);
                    for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                        metaStoreEventListener.onAddNotNullConstraint(addNotNullConstraintEvent);
                    }
                }
                if (success = ms.commitTransaction()) break block13;
                ms.rollbackTransaction();
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class).defaultMetaException();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else if (CollectionUtils.isNotEmpty((Collection)notNullConstraints)) {
                        for (MetaStoreEventListener listener : this.listeners) {
                            AddNotNullConstraintEvent addNotNullConstraintEvent = new AddNotNullConstraintEvent(notNullConstraints, true, this);
                            listener.onAddNotNullConstraint(addNotNullConstraintEvent);
                        }
                    }
                    this.endFunction("add_not_null_constraint", success, ex, constraintName);
                    throw throwable;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(notNullConstraints)) {
            for (MetaStoreEventListener listener : this.listeners) {
                AddNotNullConstraintEvent addNotNullConstraintEvent = new AddNotNullConstraintEvent(notNullConstraints, true, this);
                listener.onAddNotNullConstraint(addNotNullConstraintEvent);
            }
        }
        this.endFunction("add_not_null_constraint", success, ex, constraintName);
    }

    public void add_default_constraint(AddDefaultConstraintRequest req) throws MetaException, InvalidObjectException {
        Exception ex;
        boolean success;
        String constraintName;
        List<SQLDefaultConstraint> defaultConstraints;
        block13: {
            defaultConstraints = req.getDefaultConstraintCols();
            constraintName = CollectionUtils.isNotEmpty((Collection)defaultConstraints) ? ((SQLDefaultConstraint)defaultConstraints.get(0)).getDc_name() : "null";
            this.startFunction("add_default_constraint", ": " + constraintName);
            success = false;
            ex = null;
            if (!defaultConstraints.isEmpty() && !((SQLDefaultConstraint)defaultConstraints.get(0)).isSetCatName()) {
                String defaultCat = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
                defaultConstraints.forEach(pk -> pk.setCatName(defaultCat));
            }
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                defaultConstraints = ms.addDefaultConstraints(defaultConstraints);
                if (this.transactionalListeners.size() > 0 && CollectionUtils.isNotEmpty(defaultConstraints)) {
                    AddDefaultConstraintEvent addDefaultConstraintEvent = new AddDefaultConstraintEvent(defaultConstraints, true, this);
                    for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                        metaStoreEventListener.onAddDefaultConstraint(addDefaultConstraintEvent);
                    }
                }
                if (success = ms.commitTransaction()) break block13;
                ms.rollbackTransaction();
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class).defaultMetaException();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else if (CollectionUtils.isNotEmpty((Collection)defaultConstraints)) {
                        for (MetaStoreEventListener listener : this.listeners) {
                            AddDefaultConstraintEvent addDefaultConstraintEvent = new AddDefaultConstraintEvent(defaultConstraints, true, this);
                            listener.onAddDefaultConstraint(addDefaultConstraintEvent);
                        }
                    }
                    this.endFunction("add_default_constraint", success, ex, constraintName);
                    throw throwable;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(defaultConstraints)) {
            for (MetaStoreEventListener listener : this.listeners) {
                AddDefaultConstraintEvent addDefaultConstraintEvent = new AddDefaultConstraintEvent(defaultConstraints, true, this);
                listener.onAddDefaultConstraint(addDefaultConstraintEvent);
            }
        }
        this.endFunction("add_default_constraint", success, ex, constraintName);
    }

    public void add_check_constraint(AddCheckConstraintRequest req) throws MetaException, InvalidObjectException {
        Exception ex;
        boolean success;
        String constraintName;
        List<SQLCheckConstraint> checkConstraints;
        block13: {
            checkConstraints = req.getCheckConstraintCols();
            constraintName = CollectionUtils.isNotEmpty((Collection)checkConstraints) ? ((SQLCheckConstraint)checkConstraints.get(0)).getDc_name() : "null";
            this.startFunction("add_check_constraint", ": " + constraintName);
            success = false;
            ex = null;
            if (!checkConstraints.isEmpty() && !((SQLCheckConstraint)checkConstraints.get(0)).isSetCatName()) {
                String defaultCat = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
                checkConstraints.forEach(pk -> pk.setCatName(defaultCat));
            }
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                checkConstraints = ms.addCheckConstraints(checkConstraints);
                if (this.transactionalListeners.size() > 0 && CollectionUtils.isNotEmpty(checkConstraints)) {
                    AddCheckConstraintEvent addcheckConstraintEvent = new AddCheckConstraintEvent(checkConstraints, true, this);
                    for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                        metaStoreEventListener.onAddCheckConstraint(addcheckConstraintEvent);
                    }
                }
                if (success = ms.commitTransaction()) break block13;
                ms.rollbackTransaction();
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class).defaultMetaException();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else if (CollectionUtils.isNotEmpty((Collection)checkConstraints)) {
                        for (MetaStoreEventListener listener : this.listeners) {
                            AddCheckConstraintEvent addCheckConstraintEvent = new AddCheckConstraintEvent(checkConstraints, true, this);
                            listener.onAddCheckConstraint(addCheckConstraintEvent);
                        }
                    }
                    this.endFunction("add_check_constraint", success, ex, constraintName);
                    throw throwable;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(checkConstraints)) {
            for (MetaStoreEventListener listener : this.listeners) {
                AddCheckConstraintEvent addCheckConstraintEvent = new AddCheckConstraintEvent(checkConstraints, true, this);
                listener.onAddCheckConstraint(addCheckConstraintEvent);
            }
        }
        this.endFunction("add_check_constraint", success, ex, constraintName);
    }

    private boolean is_table_exists(RawStore ms, String catName, String dbname, String name) throws MetaException {
        return ms.getTable(catName, dbname, name, null) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean drop_table_core(RawStore ms, String catName, String dbname, String name, boolean deleteData, EnvironmentContext envContext, String indexName, boolean dropPartitions) throws TException, IOException {
        boolean success = false;
        boolean tableDataShouldBeDeleted = false;
        Path tblPath = null;
        List<Path> partPaths = null;
        Table tbl = null;
        boolean ifPurge = false;
        Map<String, String> transactionalListenerResponses = Collections.emptyMap();
        Database db = null;
        boolean isReplicated = false;
        try {
            ms.openTransaction();
            db = ms.getDatabase(catName, dbname);
            if (db.getType() == DatabaseType.REMOTE) {
                throw new MetaException("Drop table in REMOTE database " + db.getName() + " is not allowed");
            }
            isReplicated = HMSHandler.isDbReplicationTarget(db);
            GetTableRequest req = new GetTableRequest(dbname, name);
            req.setCatName(catName);
            tbl = this.get_table_core(req);
            if (tbl == null) {
                throw new NoSuchObjectException(name + " doesn't exist");
            }
            List<String> isPartOfMV = ms.isPartOfMaterializedView(catName, dbname, name);
            if (!isPartOfMV.isEmpty()) {
                throw new MetaException(String.format("Cannot drop table as it is used in the following materialized views %s%n", isPartOfMV));
            }
            if (tbl.getSd() == null) {
                throw new MetaException("Table metadata is corrupted");
            }
            ifPurge = HMSHandler.isMustPurge(envContext, tbl);
            this.firePreEvent(new PreDropTableEvent(tbl, deleteData, this));
            tableDataShouldBeDeleted = this.checkTableDataShouldBeDeleted(tbl, deleteData);
            if (tableDataShouldBeDeleted && tbl.getSd().getLocation() != null && !this.wh.isWritable((tblPath = new Path(tbl.getSd().getLocation())).getParent())) {
                String target = indexName == null ? "Table" : "Index table";
                throw new MetaException(target + " metadata not deleted since " + tblPath.getParent() + " is not writable by " + SecurityUtils.getUser());
            }
            if (dropPartitions) {
                partPaths = this.dropPartitionsAndGetLocations(ms, catName, dbname, name, tblPath, tableDataShouldBeDeleted);
            }
            ms.dropConstraint(catName, dbname, name, null, true);
            if (!ms.dropTable(catName, dbname, name)) {
                String tableName = TableName.getQualified((String)catName, (String)dbname, (String)name);
                throw new MetaException(indexName == null ? "Unable to drop table " + tableName : "Unable to drop index table " + tableName + " for index " + indexName);
            }
            if (!this.transactionalListeners.isEmpty()) {
                transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_TABLE, new DropTableEvent(tbl, true, deleteData, this, isReplicated), envContext);
            }
            if (!(success = ms.commitTransaction())) {
                ms.rollbackTransaction();
            } else if (tableDataShouldBeDeleted) {
                this.deletePartitionData(partPaths, ifPurge, ReplChangeManager.shouldEnableCm((Database)db, (Table)tbl));
                this.deleteTableData(tblPath, ifPurge, ReplChangeManager.shouldEnableCm((Database)db, (Table)tbl));
            }
            if (this.listeners.isEmpty()) return success;
        }
        catch (Throwable throwable) {
            if (!success) {
                ms.rollbackTransaction();
            } else if (tableDataShouldBeDeleted) {
                this.deletePartitionData(partPaths, ifPurge, ReplChangeManager.shouldEnableCm((Database)db, tbl));
                this.deleteTableData(tblPath, ifPurge, ReplChangeManager.shouldEnableCm((Database)db, tbl));
            }
            if (this.listeners.isEmpty()) throw throwable;
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_TABLE, new DropTableEvent(tbl, success, deleteData, this, isReplicated), envContext, transactionalListenerResponses, ms);
            throw throwable;
        }
        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_TABLE, new DropTableEvent(tbl, success, deleteData, this, isReplicated), envContext, transactionalListenerResponses, ms);
        return success;
    }

    private boolean checkTableDataShouldBeDeleted(Table tbl, boolean deleteData) {
        if (deleteData && MetaStoreUtils.isExternalTable((Table)tbl)) {
            return MetaStoreUtils.isExternalTablePurge((Table)tbl);
        }
        return deleteData;
    }

    private void deleteTableData(Path tablePath, boolean ifPurge, boolean shouldEnableCm) {
        if (tablePath != null) {
            this.deleteDataExcludeCmroot(tablePath, ifPurge, shouldEnableCm);
        }
    }

    private void deleteTableData(Path tablePath, boolean ifPurge, Database db) {
        if (tablePath != null) {
            try {
                this.wh.deleteDir(tablePath, true, ifPurge, db);
            }
            catch (Exception e) {
                LOG.error("Failed to delete table directory: " + tablePath + " " + e.getMessage());
            }
        }
    }

    private void deletePartitionData(List<Path> partPaths, boolean ifPurge, boolean shouldEnableCm) {
        if (partPaths != null && !partPaths.isEmpty()) {
            for (Path partPath : partPaths) {
                this.deleteDataExcludeCmroot(partPath, ifPurge, shouldEnableCm);
            }
        }
    }

    private void deletePartitionData(List<Path> partPaths, boolean ifPurge, Database db) {
        if (partPaths != null && !partPaths.isEmpty()) {
            for (Path partPath : partPaths) {
                try {
                    this.wh.deleteDir(partPath, true, ifPurge, db);
                }
                catch (Exception e) {
                    LOG.error("Failed to delete partition directory: " + partPath + " " + e.getMessage());
                }
            }
        }
    }

    private void deleteDataExcludeCmroot(Path path, boolean ifPurge, boolean shouldEnableCm) {
        try {
            if (shouldEnableCm) {
                FileStatus[] statuses;
                for (FileStatus status : statuses = path.getFileSystem(this.conf).listStatus(path, ReplChangeManager.CMROOT_PATH_FILTER)) {
                    this.wh.deleteDir(status.getPath(), true, ifPurge, shouldEnableCm);
                }
                FileStatus[] statusWithoutFilter = path.getFileSystem(this.conf).listStatus(path);
                if (statusWithoutFilter.length == 0) {
                    this.wh.deleteDir(path, true, ifPurge, shouldEnableCm);
                }
            } else {
                this.wh.deleteDir(path, true, ifPurge, shouldEnableCm);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to delete directory: " + path + " " + e.getMessage());
        }
    }

    private List<Path> dropPartitionsAndGetLocations(RawStore ms, String catName, String dbName, String tableName, Path tablePath, boolean checkLocation) throws MetaException, IOException, NoSuchObjectException {
        int batchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_OBJECTS_MAX);
        String tableDnsPath = null;
        if (tablePath != null) {
            tableDnsPath = this.wh.getDnsPath(tablePath).toString();
        }
        ArrayList<Path> partPaths = new ArrayList<Path>();
        while (true) {
            List<String> partNames;
            if (checkLocation) {
                Map<String, String> partitionLocations = ms.getPartitionLocations(catName, dbName, tableName, tableDnsPath, batchSize);
                partNames = new ArrayList<String>(partitionLocations.keySet());
                for (String partName : partNames) {
                    String pathString = partitionLocations.get(partName);
                    if (pathString == null) continue;
                    Path partPath = this.wh.getDnsPath(new Path(pathString));
                    if (tableDnsPath != null && FileUtils.isSubdirectory((String)tableDnsPath, (String)partPath.toString())) continue;
                    if (!this.wh.isWritable(partPath.getParent())) {
                        throw new MetaException("Table metadata not deleted since the partition " + partName + " has parent location " + partPath.getParent() + " which is not writable by " + SecurityUtils.getUser());
                    }
                    partPaths.add(partPath);
                }
            } else {
                partNames = ms.listPartitionNames(catName, dbName, tableName, (short)batchSize);
            }
            if (partNames == null || partNames.isEmpty()) {
                return partPaths;
            }
            for (MetaStoreEventListener listener : this.listeners) {
                if (!(listener instanceof HMSMetricsListener)) continue;
                for (String partName : partNames) {
                    listener.onDropPartition(null);
                }
            }
            ms.dropPartitions(catName, dbName, tableName, partNames);
        }
    }

    @Deprecated
    public void drop_table(String dbname, String name, boolean deleteData) throws NoSuchObjectException, MetaException {
        this.startFunction("drop_table", ": " + dbname + ":" + name);
        boolean success = false;
        Exception ex = null;
        try {
            String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbname, (Configuration)this.conf);
            DropTableRequest dropTableReq = new DropTableRequest(parsedDbName[1], name);
            dropTableReq.setDeleteData(deleteData);
            dropTableReq.setCatalogName(parsedDbName[0]);
            dropTableReq.setDropPartitions(true);
            this.drop_table_req(dropTableReq);
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).convertIfInstance(IOException.class, MetaException.class).defaultMetaException();
        }
        finally {
            this.endFunction("drop_table", success, ex, name);
        }
    }

    @Deprecated
    public void drop_table_with_environment_context(String dbname, String name, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException {
        this.startFunction("drop_table_with_environment_context", ": " + dbname + ":" + name);
        boolean success = false;
        Exception ex = null;
        try {
            String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbname, (Configuration)this.conf);
            DropTableRequest dropTableReq = new DropTableRequest(parsedDbName[1], name);
            dropTableReq.setDeleteData(deleteData);
            dropTableReq.setCatalogName(parsedDbName[0]);
            dropTableReq.setDropPartitions(true);
            dropTableReq.setEnvContext(envContext);
            this.drop_table_req(dropTableReq);
            success = true;
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).convertIfInstance(IOException.class, MetaException.class).defaultMetaException();
        }
        finally {
            this.endFunction("drop_table_with_environment_context", success, ex, name);
        }
    }

    private void drop_table_with_environment_context(String dbname, String name, boolean deleteData, EnvironmentContext envContext, boolean dropPartitions) throws MetaException, NoSuchObjectException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbname, (Configuration)this.conf);
        this.startTableFunction("drop_table", parsedDbName[0], parsedDbName[1], name);
        boolean success = false;
        Exception ex = null;
        try {
            success = this.drop_table_core(this.getMS(), parsedDbName[0], parsedDbName[1], name, deleteData, envContext, null, dropPartitions);
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).convertIfInstance(IOException.class, MetaException.class).defaultMetaException();
        }
        finally {
            this.endFunction("drop_table", success, ex, name);
        }
    }

    public void drop_table_req(DropTableRequest dropTableReq) throws MetaException, NoSuchObjectException {
        this.startFunction("drop_table_req", ": " + dropTableReq.getTableName());
        boolean success = false;
        Exception ex = null;
        try {
            success = this.drop_table_core(this.getMS(), dropTableReq.getCatalogName(), dropTableReq.getDbName(), dropTableReq.getTableName(), dropTableReq.isDeleteData(), dropTableReq.getEnvContext(), null, dropTableReq.isDropPartitions());
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).convertIfInstance(IOException.class, MetaException.class).defaultMetaException();
        }
        finally {
            this.endFunction("drop_table_req", success, ex, dropTableReq.getTableName());
        }
    }

    private void updateStatsForTruncate(Map<String, String> props, EnvironmentContext environmentContext) {
        if (null == props) {
            return;
        }
        for (String stat : StatsSetupConst.SUPPORTED_STATS) {
            String statVal = props.get(stat);
            if (statVal == null) continue;
            props.put(stat, "0");
        }
        StatsSetupConst.setBasicStatsState(props, (String)"true");
        environmentContext.putToProperties("STATS_GENERATED", "TASK");
        environmentContext.putToProperties("DO_NOT_POPULATE_QUICK_STATS", "true");
        StatsSetupConst.clearColumnStatsState(props);
    }

    private void alterPartitionForTruncate(RawStore ms, String catName, String dbName, String tableName, Table table, Partition partition, String validWriteIds, long writeId) throws Exception {
        EnvironmentContext environmentContext = new EnvironmentContext();
        this.updateStatsForTruncate(partition.getParameters(), environmentContext);
        if (!this.transactionalListeners.isEmpty()) {
            MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(partition, partition, table, true, true, writeId, this));
        }
        if (!this.listeners.isEmpty()) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(partition, partition, table, true, true, writeId, this));
        }
        if (writeId > 0L) {
            partition.setWriteId(writeId);
        }
        this.alterHandler.alterPartition(ms, this.wh, catName, dbName, tableName, null, partition, environmentContext, this, validWriteIds);
    }

    private void alterTableStatsForTruncate(RawStore ms, String catName, String dbName, String tableName, Table table, List<String> partNames, String validWriteIds, long writeId) throws Exception {
        if (partNames == null) {
            if (0 != table.getPartitionKeysSize()) {
                for (Partition partition : ms.getPartitions(catName, dbName, tableName, -1)) {
                    this.alterPartitionForTruncate(ms, catName, dbName, tableName, table, partition, validWriteIds, writeId);
                }
            } else {
                EnvironmentContext environmentContext = new EnvironmentContext();
                this.updateStatsForTruncate(table.getParameters(), environmentContext);
                boolean isReplicated = HMSHandler.isDbReplicationTarget(ms.getDatabase(catName, dbName));
                if (!this.transactionalListeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_TABLE, new AlterTableEvent(table, table, true, true, writeId, this, isReplicated));
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_TABLE, new AlterTableEvent(table, table, true, true, writeId, this, isReplicated));
                }
                if (writeId > 0L) {
                    table.setWriteId(writeId);
                }
                this.alterHandler.alterTable(ms, this.wh, catName, dbName, tableName, table, environmentContext, this, validWriteIds);
            }
        } else {
            for (Partition partition : ms.getPartitionsByNames(catName, dbName, tableName, partNames)) {
                this.alterPartitionForTruncate(ms, catName, dbName, tableName, table, partition, validWriteIds, writeId);
            }
        }
    }

    private List<Path> getLocationsForTruncate(RawStore ms, String catName, String dbName, String tableName, Table table, List<String> partNames) throws Exception {
        ArrayList<Path> locations = new ArrayList<Path>();
        if (partNames == null) {
            if (0 != table.getPartitionKeysSize()) {
                for (Partition partition : ms.getPartitions(catName, dbName, tableName, -1)) {
                    locations.add(new Path(partition.getSd().getLocation()));
                }
            } else {
                locations.add(new Path(table.getSd().getLocation()));
            }
        } else {
            for (Partition partition : ms.getPartitionsByNames(catName, dbName, tableName, partNames)) {
                locations.add(new Path(partition.getSd().getLocation()));
            }
        }
        return locations;
    }

    public CmRecycleResponse cm_recycle(CmRecycleRequest request) throws MetaException {
        this.wh.recycleDirToCmPath(new Path(request.getDataPath()), request.isPurge());
        return new CmRecycleResponse();
    }

    public void truncate_table(String dbName, String tableName, List<String> partNames) throws NoSuchObjectException, MetaException {
        TruncateTableRequest truncateTableReq = new TruncateTableRequest(dbName, tableName);
        truncateTableReq.setPartNames(partNames);
        this.truncate_table_req(truncateTableReq);
    }

    public TruncateTableResponse truncate_table_req(TruncateTableRequest req) throws NoSuchObjectException, MetaException {
        this.truncateTableInternal(req.getDbName(), req.getTableName(), req.getPartNames(), req.getValidWriteIdList(), req.getWriteId(), req.getEnvironmentContext());
        return new TruncateTableResponse();
    }

    private void truncateTableInternal(String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId, EnvironmentContext context) throws MetaException, NoSuchObjectException {
        boolean isSkipTrash = false;
        boolean needCmRecycle = false;
        try {
            String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
            Table tbl = this.get_table_core(parsedDbName[0], parsedDbName[1], tableName);
            boolean skipDataDeletion = Optional.ofNullable(context).map(EnvironmentContext::getProperties).map(prop -> (String)prop.get("truncateSkipDataDeletion")).map(Boolean::parseBoolean).orElse(false);
            if (TxnUtils.isTransactionalTable(tbl) || !skipDataDeletion) {
                if (!skipDataDeletion) {
                    isSkipTrash = MetaStoreUtils.isSkipTrash((Map)tbl.getParameters());
                    Database db = this.get_database_core(parsedDbName[0], parsedDbName[1]);
                    needCmRecycle = ReplChangeManager.shouldEnableCm((Database)db, (Table)tbl);
                }
                for (Path location : this.getLocationsForTruncate(this.getMS(), parsedDbName[0], parsedDbName[1], tableName, tbl, partNames)) {
                    if (!skipDataDeletion) {
                        this.truncateDataFiles(location, isSkipTrash, needCmRecycle);
                        continue;
                    }
                    HMSHandler.addTruncateBaseFile(location, writeId, this.conf, AcidMetaDataFile.DataFormat.TRUNCATED);
                }
            }
            this.alterTableStatsForTruncate(this.getMS(), parsedDbName[0], parsedDbName[1], tableName, tbl, partNames, validWriteIds, writeId);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).convertIfInstance(IOException.class, MetaException.class).defaultMetaException();
        }
    }

    static void addTruncateBaseFile(Path location, long writeId, Configuration conf, AcidMetaDataFile.DataFormat dataFormat) throws MetaException {
        if (location == null) {
            return;
        }
        Path basePath = new Path(location, AcidConstants.baseDir((long)writeId));
        try {
            FileSystem fs = location.getFileSystem(conf);
            fs.mkdirs(basePath);
            AcidMetaDataFile.writeToFile((FileSystem)fs, (Path)basePath, (AcidMetaDataFile.DataFormat)dataFormat);
        }
        catch (Exception e) {
            throw ExceptionHandler.newMetaException(e);
        }
    }

    private void truncateDataFiles(Path location, boolean isSkipTrash, boolean needCmRecycle) throws IOException, MetaException {
        FileSystem fs = location.getFileSystem(this.getConf());
        if (!HdfsUtils.isPathEncrypted((Configuration)this.getConf(), (URI)fs.getUri(), (Path)location) && !FileUtils.pathHasSnapshotSubDir((Path)location, (FileSystem)fs)) {
            HdfsUtils.HadoopFileStatus status = new HdfsUtils.HadoopFileStatus(this.getConf(), fs, location);
            FileStatus targetStatus = fs.getFileStatus(location);
            String targetGroup = targetStatus == null ? null : targetStatus.getGroup();
            this.wh.deleteDir(location, true, isSkipTrash, needCmRecycle);
            fs.mkdirs(location);
            HdfsUtils.setFullFileStatus((Configuration)this.getConf(), (HdfsUtils.HadoopFileStatus)status, (String)targetGroup, (FileSystem)fs, (Path)location, (boolean)false);
        } else {
            FileStatus[] statuses = fs.listStatus(location, FileUtils.HIDDEN_FILES_PATH_FILTER);
            if (statuses == null || statuses.length == 0) {
                return;
            }
            for (FileStatus status : statuses) {
                this.wh.deleteDir(status.getPath(), true, isSkipTrash, needCmRecycle);
            }
        }
    }

    public List<ExtendedTableInfo> get_tables_ext(GetTablesExtRequest req) throws MetaException {
        List<Object> tables = new ArrayList();
        ArrayList<ExtendedTableInfo> ret = new ArrayList<ExtendedTableInfo>();
        String catalog = req.getCatalog();
        String database = req.getDatabase();
        String pattern = req.getTableNamePattern();
        List processorCapabilities = req.getProcessorCapabilities();
        int limit = req.getLimit();
        String processorId = req.getProcessorIdentifier();
        List<Object> tObjects = new ArrayList();
        this.startTableFunction("get_tables_ext", catalog, database, pattern);
        Exception ex = null;
        try {
            tables = this.getMS().getTables(catalog, database, pattern, null, limit);
            LOG.debug("get_tables_ext:getTables() returned " + tables.size());
            tables = FilterUtils.filterTableNamesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (String)catalog, (String)database, tables);
            if (tables.size() > 0) {
                tObjects = this.getMS().getTableObjectsByName(catalog, database, tables);
                LOG.debug("get_tables_ext:getTableObjectsByName() returned " + tObjects.size());
                if (processorCapabilities == null || processorCapabilities.size() == 0 || processorCapabilities.contains("MANAGERAWMETADATA")) {
                    LOG.info("Skipping translation for processor with " + processorId);
                } else if (this.transformer != null) {
                    Map<Table, List<String>> retMap = this.transformer.transform(tObjects, processorCapabilities, processorId);
                    for (Map.Entry<Table, List<String>> entry : retMap.entrySet()) {
                        LOG.debug("Table " + entry.getKey().getTableName() + " requires " + Arrays.toString(entry.getValue().toArray()));
                        ret.add(this.convertTableToExtendedTable(entry.getKey(), entry.getValue(), req.getRequestedFields()));
                    }
                } else {
                    for (Table table : tObjects) {
                        ret.add(this.convertTableToExtendedTable(table, processorCapabilities, req.getRequestedFields()));
                    }
                }
            }
            this.endFunction("get_tables_ext", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_tables_ext", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    private ExtendedTableInfo convertTableToExtendedTable(Table table, List<String> processorCapabilities, int mask) {
        ExtendedTableInfo extTable = new ExtendedTableInfo(table.getTableName());
        if ((mask & GetTablesExtRequestFields.ACCESS_TYPE.getValue()) == GetTablesExtRequestFields.ACCESS_TYPE.getValue()) {
            extTable.setAccessType((int)table.getAccessType());
        }
        if ((mask & GetTablesExtRequestFields.PROCESSOR_CAPABILITIES.getValue()) == GetTablesExtRequestFields.PROCESSOR_CAPABILITIES.getValue()) {
            extTable.setRequiredReadCapabilities(table.getRequiredReadCapabilities());
            extTable.setRequiredWriteCapabilities(table.getRequiredWriteCapabilities());
        }
        return extTable;
    }

    public GetTableResult get_table_req(GetTableRequest req) throws MetaException, NoSuchObjectException {
        req.setCatName(req.isSetCatName() ? req.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        return new GetTableResult(this.getTableInternal(req));
    }

    private Table getTableInternal(GetTableRequest getTableRequest) throws MetaException, NoSuchObjectException {
        Preconditions.checkArgument((!getTableRequest.isGetColumnStats() || getTableRequest.getEngine() != null ? 1 : 0) != 0, (Object)"To retrieve column statistics with a table, engine parameter cannot be null");
        if (this.isInTest) {
            this.assertClientHasCapability(getTableRequest.getCapabilities(), ClientCapability.TEST_CAPABILITY, "Hive tests", "get_table_req");
        }
        Table t = null;
        this.startTableFunction("get_table", getTableRequest.getCatName(), getTableRequest.getDbName(), getTableRequest.getTblName());
        Throwable ex = null;
        try {
            t = this.get_table_core(getTableRequest);
            if (MetaStoreUtils.isInsertOnlyTableParam((Map)t.getParameters())) {
                this.assertClientHasCapability(getTableRequest.getCapabilities(), ClientCapability.INSERT_ONLY_TABLES, "insert-only tables", "get_table_req");
            }
            if (CollectionUtils.isEmpty((Collection)getTableRequest.getProcessorCapabilities()) || getTableRequest.getProcessorCapabilities().contains("MANAGERAWMETADATA")) {
                LOG.info("Skipping translation for processor with " + getTableRequest.getProcessorIdentifier());
            } else if (this.transformer != null) {
                ArrayList<Table> tList = new ArrayList<Table>();
                tList.add(t);
                Map<Table, List<String>> ret = this.transformer.transform(tList, getTableRequest.getProcessorCapabilities(), getTableRequest.getProcessorIdentifier());
                if (ret.size() > 1) {
                    LOG.warn("Unexpected resultset size:" + ret.size());
                    throw new MetaException("Unexpected result from metadata transformer:return list size is " + ret.size());
                }
                t = ret.keySet().iterator().next();
            }
            this.firePreEvent(new PreReadTableEvent(t, (IHMSHandler)this));
            this.endFunction("get_table", t != null, (Exception)ex, getTableRequest.getTblName());
        }
        catch (MetaException | NoSuchObjectException e) {
            try {
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_table", t != null, (Exception)ex, getTableRequest.getTblName());
                throw throwable;
            }
        }
        return t;
    }

    public List<TableMeta> get_table_meta(String dbnames, String tblNames, List<String> tblTypes) throws MetaException, NoSuchObjectException {
        List<TableMeta> t = null;
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbnames, (Configuration)this.conf);
        this.startTableFunction("get_table_metas", parsedDbName[0], parsedDbName[1], tblNames);
        Exception ex = null;
        try {
            t = this.getMS().getTableMeta(parsedDbName[0], parsedDbName[1], tblNames, tblTypes);
            t = FilterUtils.filterTableMetasIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, t);
            t = this.filterReadableTables(parsedDbName[0], t);
            this.endFunction("get_table_metas", t != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_table_metas", t != null, ex);
                throw throwable;
            }
        }
        return t;
    }

    @Override
    @Deprecated
    public Table get_table_core(String catName, String dbname, String name) throws MetaException, NoSuchObjectException {
        GetTableRequest getTableRequest = new GetTableRequest(dbname, name);
        getTableRequest.setCatName(catName);
        return this.get_table_core(getTableRequest);
    }

    @Override
    @Deprecated
    public Table get_table_core(String catName, String dbname, String name, String writeIdList) throws MetaException, NoSuchObjectException {
        GetTableRequest getTableRequest = new GetTableRequest(dbname, name);
        getTableRequest.setCatName(catName);
        getTableRequest.setValidWriteIdList(writeIdList);
        return this.get_table_core(getTableRequest);
    }

    @Override
    public Table get_table_core(GetTableRequest getTableRequest) throws MetaException, NoSuchObjectException {
        Preconditions.checkArgument((!getTableRequest.isGetColumnStats() || getTableRequest.getEngine() != null ? 1 : 0) != 0, (Object)"To retrieve column statistics with a table, engine parameter cannot be null");
        String catName = getTableRequest.getCatName();
        String dbName = getTableRequest.getDbName();
        String tblName = getTableRequest.getTblName();
        Database db = null;
        Table t = null;
        try {
            db = this.get_database_core(catName, dbName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (db != null && db.getType().equals((Object)DatabaseType.REMOTE)) {
            t = DataConnectorProviderFactory.getDataConnectorProvider(db).getTable(tblName);
            if (t == null) {
                throw new NoSuchObjectException(TableName.getQualified((String)catName, (String)dbName, (String)tblName) + " table not found");
            }
            t.setDbName(dbName);
            return t;
        }
        try {
            ColumnStatistics colStats;
            t = this.getMS().getTable(catName, dbName, tblName, getTableRequest.getValidWriteIdList(), getTableRequest.getId());
            if (t == null) {
                throw new NoSuchObjectException(TableName.getQualified((String)catName, (String)dbName, (String)tblName) + " table not found");
            }
            if (getTableRequest.isGetColumnStats() && (colStats = this.getMS().getTableColumnStatistics(catName, dbName, tblName, StatsSetupConst.getColumnsHavingStats((Map)t.getParameters()), getTableRequest.getEngine(), getTableRequest.getValidWriteIdList())) != null) {
                t.setColStats(colStats);
            }
        }
        catch (Exception e) {
            ExceptionHandler.throwMetaException(e);
        }
        return t;
    }

    public GetTablesResult get_table_objects_by_name_req(GetTablesRequest req) throws TException {
        String catName;
        String string = catName = req.isSetCatName() ? req.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        if (this.isDatabaseRemote(req.getDbName())) {
            return new GetTablesResult(this.getRemoteTableObjectsInternal(req.getDbName(), req.getTblNames(), req.getTablesPattern()));
        }
        return new GetTablesResult(this.getTableObjectsInternal(catName, req.getDbName(), req.getTblNames(), req.getCapabilities(), req.getProjectionSpec(), req.getTablesPattern()));
    }

    private List<Table> filterTablesByName(List<Table> tables, List<String> tableNames) {
        ArrayList<Table> filteredTables = new ArrayList<Table>();
        for (Table table : tables) {
            if (!tableNames.contains(table.getTableName())) continue;
            filteredTables.add(table);
        }
        return filteredTables;
    }

    private List<Table> getRemoteTableObjectsInternal(String dbname, List<String> tableNames, String pattern) throws MetaException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbname, (Configuration)this.conf);
        try {
            Database db = this.get_database_core(parsedDbName[0], parsedDbName[1]);
            List<Table> tables = DataConnectorProviderFactory.getDataConnectorProvider(db).getTables(null);
            if (tableNames != null) {
                tables = this.filterTablesByName(tables, tableNames);
            }
            for (Table table : tables) {
                table.setDbName(dbname);
            }
            return FilterUtils.filterTablesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, tables);
        }
        catch (Exception e) {
            LOG.warn("Unexpected exception while getting table(s) in remote database " + dbname, (Throwable)e);
            if (this.isInTest) {
                return new ArrayList<Table>();
            }
            throw ExceptionHandler.newMetaException(e);
        }
    }

    private List<Table> getTableObjectsInternal(String catName, String dbName, List<String> tableNames, ClientCapabilities capabilities, GetProjectionsSpec projectionsSpec, String tablePattern) throws MetaException, InvalidOperationException, UnknownDBException {
        if (this.isInTest) {
            this.assertClientHasCapability(capabilities, ClientCapability.TEST_CAPABILITY, "Hive tests", "get_table_objects_by_name_req");
        }
        if (projectionsSpec != null && !projectionsSpec.isSetFieldList() && (projectionsSpec.isSetIncludeParamKeyPattern() || projectionsSpec.isSetExcludeParamKeyPattern())) {
            throw new InvalidOperationException("Include and Exclude Param key are not supported.");
        }
        List<Object> tables = new ArrayList();
        this.startMultiTableFunction("get_multi_table", dbName, tableNames);
        Exception ex = null;
        int tableBatchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
        try {
            if (dbName == null || dbName.isEmpty()) {
                throw new UnknownDBException("DB name is null or empty");
            }
            RawStore ms = this.getMS();
            if (tablePattern != null) {
                tables = ms.getTableObjectsByName(catName, dbName, tableNames, projectionsSpec, tablePattern);
            } else {
                int n;
                if (tableNames == null) {
                    throw new InvalidOperationException(dbName + " cannot find null tables");
                }
                List<String> distinctTableNames = tableNames;
                if (distinctTableNames.size() > tableBatchSize) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String tableName : tableNames) {
                        arrayList.add(StringUtils.normalizeIdentifier((String)tableName));
                    }
                    distinctTableNames = new ArrayList<String>(new HashSet(arrayList));
                }
                boolean bl = false;
                while (n < distinctTableNames.size()) {
                    int endIndex = Math.min((int)(n + tableBatchSize), distinctTableNames.size());
                    tables.addAll(ms.getTableObjectsByName(catName, dbName, distinctTableNames.subList(n, endIndex), projectionsSpec, tablePattern));
                    n = endIndex;
                }
            }
            for (Table table : tables) {
                if (table.getParameters() == null || !MetaStoreUtils.isInsertOnlyTableParam((Map)table.getParameters())) continue;
                this.assertClientHasCapability(capabilities, ClientCapability.INSERT_ONLY_TABLES, "insert-only tables", "get_table_req");
            }
            this.endFunction("get_multi_table", (tables = FilterUtils.filterTablesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, tables)) != null, ex, org.apache.commons.lang3.StringUtils.join(tableNames, (String)LOG_SAMPLE_PARTITIONS_SEPARATOR));
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidOperationException.class, UnknownDBException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("get_multi_table", tables != null, ex, org.apache.commons.lang3.StringUtils.join(tableNames, (String)LOG_SAMPLE_PARTITIONS_SEPARATOR));
                throw throwable;
            }
        }
        return tables;
    }

    public Materialization get_materialization_invalidation_info(CreationMetadata cm, String validTxnList) throws MetaException {
        return this.getTxnHandler().getMaterializationInvalidationInfo(cm, validTxnList);
    }

    public void update_creation_metadata(String catName, String dbName, String tableName, CreationMetadata cm) throws MetaException {
        this.getMS().updateCreationMetadata(catName, dbName, tableName, cm);
    }

    private void assertClientHasCapability(ClientCapabilities client, ClientCapability value, String what, String call) throws MetaException {
        if (!this.doesClientHaveCapability(client, value)) {
            throw new MetaException("Your client does not appear to support " + what + ". To skip capability checks, please set " + MetastoreConf.ConfVars.CAPABILITY_CHECK.toString() + " to false. This setting can be set globally, or on the client for the current metastore session. Note that this may lead to incorrect results, data loss, undefined behavior, etc. if your client is actually incompatible. You can also specify custom client capabilities via " + call + " API.");
        }
    }

    private boolean doesClientHaveCapability(ClientCapabilities client, ClientCapability value) {
        if (!MetastoreConf.getBoolVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CAPABILITY_CHECK)) {
            return true;
        }
        return client != null && client.isSetValues() && client.getValues().contains(value);
    }

    public List<String> get_table_names_by_filter(String dbName, String filter, short maxTables) throws MetaException, InvalidOperationException, UnknownDBException {
        List tables = null;
        this.startFunction("get_table_names_by_filter", ": db = " + dbName + ", filter = " + filter);
        Exception ex = null;
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        try {
            if (parsedDbName[0] == null || parsedDbName[0].isEmpty() || parsedDbName[1] == null || parsedDbName[1].isEmpty()) {
                throw new UnknownDBException("DB name is null or empty");
            }
            if (filter == null) {
                throw new InvalidOperationException(filter + " cannot apply null filter");
            }
            tables = this.getMS().listTableNamesByFilter(parsedDbName[0], parsedDbName[1], filter, maxTables);
            this.endFunction("get_table_names_by_filter", (tables = FilterUtils.filterTableNamesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (String)parsedDbName[0], (String)parsedDbName[1], tables)) != null, ex, org.apache.commons.lang3.StringUtils.join((Iterable)tables, (String)LOG_SAMPLE_PARTITIONS_SEPARATOR));
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidOperationException.class, UnknownDBException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("get_table_names_by_filter", tables != null, ex, org.apache.commons.lang3.StringUtils.join(tables, (String)LOG_SAMPLE_PARTITIONS_SEPARATOR));
                throw throwable;
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Partition append_partition_common(RawStore ms, String catName, String dbName, String tableName, List<String> part_vals, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException, NoSuchObjectException {
        Map<String, String> transactionalListenerResponses;
        Table tbl;
        boolean success;
        Partition part;
        block16: {
            part = new Partition();
            success = false;
            boolean madeDir = false;
            Path partLocation = null;
            tbl = null;
            transactionalListenerResponses = Collections.emptyMap();
            Database db = null;
            try {
                Partition old_part;
                ms.openTransaction();
                part.setCatName(catName);
                part.setDbName(dbName);
                part.setTableName(tableName);
                part.setValues(part_vals);
                MetaStoreServerUtils.validatePartitionNameCharacters(part_vals, this.partitionValidationPattern);
                tbl = ms.getTable(part.getCatName(), part.getDbName(), part.getTableName(), null);
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                }
                if (tbl.getSd().getLocation() == null) {
                    throw new MetaException("Cannot append a partition to a view");
                }
                db = this.get_database_core(catName, dbName);
                this.firePreEvent(new PreAddPartitionEvent(tbl, part, (IHMSHandler)this));
                part.setSd(tbl.getSd().deepCopy());
                partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName((List)tbl.getPartitionKeys(), part_vals));
                part.getSd().setLocation(partLocation.toString());
                try {
                    old_part = ms.getPartition(part.getCatName(), part.getDbName(), part.getTableName(), part.getValues());
                }
                catch (NoSuchObjectException e) {
                    old_part = null;
                }
                if (old_part != null) {
                    throw new AlreadyExistsException("Partition already exists:" + part);
                }
                if (!this.wh.isDir(partLocation)) {
                    if (!this.wh.mkdirs(partLocation)) {
                        throw new MetaException(partLocation + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                long time = System.currentTimeMillis() / 1000L;
                part.setCreateTime((int)time);
                part.putToParameters("transient_lastDdlTime", Long.toString(time));
                if (this.canUpdateStats(tbl)) {
                    MetaStoreServerUtils.updatePartitionStatsFast(part, tbl, this.wh, madeDir, false, envContext, true);
                }
                if (ms.addPartition(part)) {
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, part, true, (IHMSHandler)this), envContext);
                    }
                    success = ms.commitTransaction();
                }
                if (success) break block16;
                ms.rollbackTransaction();
                if (!madeDir) break block16;
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                    if (madeDir) {
                        this.wh.deleteDir(partLocation, true, false, ReplChangeManager.shouldEnableCm(db, tbl));
                    }
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, part, success, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
                }
                throw throwable;
            }
            this.wh.deleteDir(partLocation, true, false, ReplChangeManager.shouldEnableCm((Database)db, (Table)tbl));
        }
        if (!this.listeners.isEmpty()) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, part, success, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
        }
        return part;
    }

    private void firePreEvent(PreEventContext event) throws MetaException {
        for (MetaStorePreEventListener listener : this.preListeners) {
            try {
                listener.onEvent(event);
            }
            catch (NoSuchObjectException e) {
                throw new MetaException(e.getMessage());
            }
            catch (InvalidOperationException e) {
                throw new MetaException(e.getMessage());
            }
        }
    }

    @Deprecated
    public Partition append_partition(String dbName, String tableName, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        AppendPartitionsRequest appendPartitionsReq = new AppendPartitionsRequest();
        appendPartitionsReq.setDbName(parsedDbName[1]);
        appendPartitionsReq.setTableName(tableName);
        appendPartitionsReq.setPartVals(part_vals);
        appendPartitionsReq.setCatalogName(parsedDbName[0]);
        return this.append_partition_req(appendPartitionsReq);
    }

    @Deprecated
    public Partition append_partition_with_environment_context(String dbName, String tableName, List<String> part_vals, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        this.startPartitionFunction("append_partition_with_environment_context", parsedDbName[0], parsedDbName[1], tableName, part_vals);
        Partition ret = null;
        Exception ex = null;
        try {
            AppendPartitionsRequest appendPartitionsReq = new AppendPartitionsRequest();
            appendPartitionsReq.setDbName(parsedDbName[1]);
            appendPartitionsReq.setTableName(tableName);
            appendPartitionsReq.setPartVals(part_vals);
            appendPartitionsReq.setCatalogName(parsedDbName[0]);
            appendPartitionsReq.setEnvironmentContext(envContext);
            ret = this.append_partition_req(appendPartitionsReq);
            this.endFunction("append_partition_with_environment_context", ret != null, ex, tableName);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class, AlreadyExistsException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("append_partition_with_environment_context", ret != null, ex, tableName);
                throw throwable;
            }
        }
        return ret;
    }

    public Partition append_partition_req(AppendPartitionsRequest appendPartitionsReq) throws InvalidObjectException, AlreadyExistsException, MetaException {
        List<String> part_vals = appendPartitionsReq.getPartVals();
        String dbName = appendPartitionsReq.getDbName();
        String catName = appendPartitionsReq.isSetCatalogName() ? appendPartitionsReq.getCatalogName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        String tableName = appendPartitionsReq.getTableName();
        String partName = appendPartitionsReq.getName();
        if (partName == null && (part_vals == null || part_vals.isEmpty())) {
            throw new MetaException("The partition values must not be null or empty.");
        }
        if (part_vals == null || part_vals.isEmpty()) {
            part_vals = this.getPartValsFromName(this.getMS(), catName, dbName, tableName, partName);
        }
        this.startPartitionFunction("append_partition_req", catName, dbName, tableName, part_vals);
        if (LOG.isDebugEnabled()) {
            for (String part : part_vals) {
                LOG.debug(part);
            }
        }
        Partition ret = null;
        Exception ex = null;
        try {
            ret = this.append_partition_common(this.getMS(), catName, dbName, tableName, part_vals, appendPartitionsReq.getEnvironmentContext());
            this.endFunction("append_partition_req", ret != null, ex, tableName);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class, AlreadyExistsException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("append_partition_req", ret != null, ex, tableName);
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Partition> add_partitions_core(RawStore ms, String catName, String dbName, String tblName, List<Partition> parts, boolean ifNotExists, boolean isSkipColSchemaForPartition, EnvironmentContext envContext) throws TException {
        if (dbName == null || tblName == null) {
            throw new MetaException("The database and table name cannot be null.");
        }
        boolean success = false;
        ConcurrentHashMap<PartValEqWrapperLite, Boolean> addedPartitions = new ConcurrentHashMap<PartValEqWrapperLite, Boolean>();
        ArrayList<Partition> newParts = new ArrayList<Partition>();
        ArrayList<Partition> existingParts = new ArrayList<Partition>();
        Table tbl = null;
        Map<String, String> transactionalListenerResponses = Collections.emptyMap();
        Database db = null;
        ArrayList<ColumnStatistics> partsColStats = new ArrayList<ColumnStatistics>(parts.size());
        ArrayList<Long> partsWriteIds = new ArrayList<Long>(parts.size());
        this.throwUnsupportedExceptionIfRemoteDB(dbName, "add_partitions");
        Lock tableLock = this.getTableLockFor(dbName, tblName);
        tableLock.lock();
        try {
            ms.openTransaction();
            tbl = ms.getTable(catName, dbName, tblName, null);
            if (tbl == null) {
                throw new InvalidObjectException("Unable to add partitions because " + TableName.getQualified((String)catName, (String)dbName, (String)tblName) + " does not exist");
            }
            MTable mTable = this.getMS().ensureGetMTable(catName, dbName, tblName);
            db = ms.getDatabase(catName, dbName);
            if (!parts.isEmpty()) {
                this.firePreEvent(new PreAddPartitionEvent(tbl, parts, (IHMSHandler)this));
            }
            HashSet<PartValEqWrapperLite> partsToAdd = new HashSet<PartValEqWrapperLite>(parts.size());
            ArrayList<Partition> partitionsToAdd = new ArrayList<Partition>(parts.size());
            List partitionKeys = tbl.getPartitionKeys();
            for (Partition part : parts) {
                if (isSkipColSchemaForPartition) {
                    part.getSd().setCols(tbl.getSd().getCols());
                }
                if (part.isSetColStats()) {
                    partsColStats.add(part.getColStats());
                    part.unsetColStats();
                    partsWriteIds.add(part.getWriteId());
                }
                if (this.validatePartition(part, catName, tblName, dbName, partsToAdd, ms, ifNotExists, partitionKeys)) {
                    partitionsToAdd.add(part);
                    continue;
                }
                existingParts.add(part);
            }
            newParts.addAll(this.createPartitionFolders(partitionsToAdd, tbl, addedPartitions, envContext));
            if (!newParts.isEmpty()) {
                ms.addPartitions(catName, dbName, tblName, newParts);
            }
            if (!this.transactionalListeners.isEmpty()) {
                transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, newParts, true, (IHMSHandler)this), envContext);
            }
            int cnt = 0;
            for (ColumnStatistics partColStats : partsColStats) {
                long writeId = (Long)partsWriteIds.get(cnt++);
                String validWriteIds = null;
                if (writeId > 0L) {
                    ValidReaderWriteIdList validWriteIdList = new ValidReaderWriteIdList(TableName.getDbTable((String)tbl.getDbName(), (String)tbl.getTableName()), new long[0], new BitSet(), writeId);
                    validWriteIds = validWriteIdList.toString();
                }
                this.updatePartitonColStatsInternal(tbl, mTable, partColStats, validWriteIds, writeId);
            }
            success = ms.commitTransaction();
        }
        catch (Throwable throwable) {
            try {
                if (!success) {
                    ms.rollbackTransaction();
                    this.cleanupPartitionFolders(addedPartitions, db);
                }
                if (this.listeners.isEmpty()) throw throwable;
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, newParts, success, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
                if (existingParts.isEmpty()) throw throwable;
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, existingParts, false, (IHMSHandler)this), envContext, null, ms);
                throw throwable;
            }
            finally {
                tableLock.unlock();
            }
        }
        try {
            if (!success) {
                ms.rollbackTransaction();
                this.cleanupPartitionFolders(addedPartitions, db);
            }
            if (this.listeners.isEmpty()) return newParts;
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, newParts, success, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
            if (existingParts.isEmpty()) return newParts;
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, existingParts, false, (IHMSHandler)this), envContext, null, ms);
            return newParts;
        }
        finally {
            tableLock.unlock();
        }
    }

    private Lock getTableLockFor(String dbName, String tblName) {
        return (Lock)tablelocks.get((Object)(dbName + "." + tblName));
    }

    private void cleanupPartitionFolders(Map<PartValEqWrapperLite, Boolean> addedPartitions, Database db) throws MetaException, IllegalArgumentException {
        for (Map.Entry<PartValEqWrapperLite, Boolean> e : addedPartitions.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            this.wh.deleteDir(new Path(e.getKey().location), true, db);
        }
    }

    private boolean validatePartition(Partition part, String catName, String tblName, String dbName, Set<PartValEqWrapperLite> partsToAdd, RawStore ms, boolean ifNotExists, List<FieldSchema> partitionKeys) throws MetaException, TException {
        if (part.getDbName() == null || part.getTableName() == null) {
            throw new MetaException("The database and table name must be set in the partition.");
        }
        if (!part.getTableName().equalsIgnoreCase(tblName) || !part.getDbName().equalsIgnoreCase(dbName)) {
            String errorMsg = String.format("Partition does not belong to target table %s. It belongs to the table %s.%s : %s", TableName.getQualified((String)catName, (String)dbName, (String)tblName), part.getDbName(), part.getTableName(), part.toString());
            throw new MetaException(errorMsg);
        }
        if (part.getValues() == null || part.getValues().isEmpty()) {
            throw new MetaException("The partition values cannot be null or empty.");
        }
        if (part.getValues().contains(null)) {
            throw new MetaException("Partition value cannot be null.");
        }
        boolean shouldAdd = this.startAddPartition(ms, part, partitionKeys, ifNotExists);
        if (!shouldAdd) {
            LOG.info("Not adding partition {} as it already exists", (Object)part);
            return false;
        }
        if (!partsToAdd.add(new PartValEqWrapperLite(part))) {
            throw new MetaException("Duplicate partitions in the list: " + part);
        }
        return true;
    }

    private List<Partition> createPartitionFolders(List<Partition> partitionsToAdd, Table table, Map<PartValEqWrapperLite, Boolean> addedPartitions, EnvironmentContext envContext) throws MetaException {
        UserGroupInformation ugi;
        AtomicBoolean failureOccurred = new AtomicBoolean(false);
        ArrayList<Future<Partition>> partFutures = new ArrayList<Future<Partition>>(partitionsToAdd.size());
        ConcurrentHashMap addedParts = new ConcurrentHashMap();
        try {
            ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Partition partition : partitionsToAdd) {
            this.initializePartitionParameters(table, partition);
            partFutures.add(threadPool.submit(() -> {
                if (failureOccurred.get()) {
                    return null;
                }
                ugi.doAs(() -> {
                    try {
                        boolean madeDir = this.createLocationForAddedPartition(table, partition);
                        addedParts.put(new PartValEqWrapperLite(partition), madeDir);
                        this.initializeAddedPartition(table, partition, madeDir, envContext);
                    }
                    catch (MetaException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                    return null;
                });
                return partition;
            }));
        }
        ArrayList<Partition> newParts = new ArrayList<Partition>(partitionsToAdd.size());
        String errorMessage = null;
        for (Future future : partFutures) {
            try {
                Partition part = (Partition)future.get();
                if (part == null || failureOccurred.get()) continue;
                newParts.add(part);
            }
            catch (ExecutionException e) {
                failureOccurred.compareAndSet(false, true);
                errorMessage = e.getMessage();
            }
            catch (InterruptedException e) {
                failureOccurred.compareAndSet(false, true);
                errorMessage = e.getMessage();
                Thread.currentThread().interrupt();
            }
        }
        addedPartitions.putAll(addedParts);
        if (failureOccurred.get()) {
            throw new MetaException(errorMessage);
        }
        return newParts;
    }

    public AddPartitionsResult add_partitions_req(AddPartitionsRequest request) throws TException {
        this.startFunction("add_partitions_req", ": db=" + request.getDbName() + " tab=" + request.getTblName());
        AddPartitionsResult result = new AddPartitionsResult();
        if (request.getParts().isEmpty()) {
            return result;
        }
        String catName = request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        String dbName = request.getDbName();
        String tblName = request.getTblName();
        this.startTableFunction("add_partitions_req", catName, dbName, tblName);
        Exception ex = null;
        try {
            if (!request.isSetCatName()) {
                request.setCatName(catName);
            }
            boolean isColSkippedForPartitions = request.isSkipColumnSchemaForPartition();
            request.getParts().forEach(p -> p.setCatName(catName));
            List<Partition> parts = this.add_partitions_core(this.getMS(), catName, dbName, tblName, request.getParts(), request.isIfNotExists(), request.isSkipColumnSchemaForPartition(), request.getEnvironmentContext());
            if (request.isNeedResult()) {
                if (isColSkippedForPartitions) {
                    if (!parts.isEmpty()) {
                        StorageDescriptor sd = parts.get(0).getSd().deepCopy();
                        result.setPartitionColSchema(sd.getCols());
                    }
                    parts.stream().forEach(partition -> partition.getSd().getCols().clear());
                }
                result.setPartitions(parts);
            }
            this.endFunction("add_partitions_req", ex == null, ex, tblName);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(TException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("add_partitions_req", ex == null, ex, tblName);
                throw throwable;
            }
        }
        return result;
    }

    @Deprecated
    public int add_partitions(List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
        if (parts == null) {
            throw new MetaException("Partition list cannot be null.");
        }
        if (parts.isEmpty()) {
            return 0;
        }
        String catName = parts.get(0).isSetCatName() ? parts.get(0).getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        String dbName = parts.get(0).getDbName();
        String tableName = parts.get(0).getTableName();
        this.startTableFunction("add_partitions", catName, dbName, tableName);
        Integer ret = null;
        Exception ex = null;
        try {
            if (!parts.get(0).isSetCatName()) {
                parts.forEach(p -> p.setCatName(catName));
            }
            AddPartitionsRequest addPartitionsReq = new AddPartitionsRequest();
            addPartitionsReq.setDbName(parts.get(0).getDbName());
            addPartitionsReq.setTblName(parts.get(0).getTableName());
            addPartitionsReq.setParts(parts);
            addPartitionsReq.setIfNotExists(false);
            if (parts.get(0).isSetCatName()) {
                addPartitionsReq.setCatName(parts.get(0).getCatName());
            }
            ret = this.add_partitions_req(addPartitionsReq).getPartitions().size();
            assert (ret.intValue() == parts.size());
            this.endFunction("add_partitions", ret != null, ex, tableName);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class, AlreadyExistsException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("add_partitions", ret != null, ex, tableName);
                throw throwable;
            }
        }
        return ret;
    }

    public int add_partitions_pspec(List<PartitionSpec> partSpecs) throws TException {
        if (partSpecs.isEmpty()) {
            return 0;
        }
        String catName = partSpecs.get(0).isSetCatName() ? partSpecs.get(0).getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        String dbName = partSpecs.get(0).getDbName();
        String tableName = partSpecs.get(0).getTableName();
        this.startTableFunction("add_partitions_pspec", catName, dbName, tableName);
        Integer ret = null;
        Exception ex = null;
        try {
            if (!partSpecs.get(0).isSetCatName()) {
                partSpecs.forEach(ps -> ps.setCatName(catName));
            }
            dbName = StringUtils.normalizeIdentifier((String)dbName);
            tableName = StringUtils.normalizeIdentifier((String)tableName);
            PartitionSpecProxy partitionSpecProxy = PartitionSpecProxy.Factory.get(partSpecs);
            PartitionSpecProxy.PartitionIterator partitionIterator = partitionSpecProxy.getPartitionIterator();
            ArrayList<Partition> partitionsToAdd = new ArrayList<Partition>(partitionSpecProxy.size());
            while (partitionIterator.hasNext()) {
                Partition part = partitionIterator.getCurrent();
                part.setDbName(StringUtils.normalizeIdentifier((String)part.getDbName()));
                part.setTableName(StringUtils.normalizeIdentifier((String)part.getTableName()));
                partitionsToAdd.add(part);
                partitionIterator.next();
            }
            ret = this.add_partitions_core(this.getMS(), catName, dbName, tableName, partitionsToAdd, false, false, null).size();
            this.endFunction("add_partitions_pspec", ret != null, ex, tableName);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class, AlreadyExistsException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("add_partitions_pspec", ret != null, ex, tableName);
                throw throwable;
            }
        }
        return ret;
    }

    private boolean startAddPartition(RawStore ms, Partition part, List<FieldSchema> partitionKeys, boolean ifNotExists) throws TException {
        MetaStoreServerUtils.validatePartitionNameCharacters(part.getValues(), this.partitionValidationPattern);
        boolean doesExist = ms.doesPartitionExist(part.getCatName(), part.getDbName(), part.getTableName(), partitionKeys, part.getValues());
        if (doesExist && !ifNotExists) {
            throw new AlreadyExistsException("Partition already exists: " + part);
        }
        return !doesExist;
    }

    private boolean createLocationForAddedPartition(Table tbl, Partition part) throws MetaException {
        Path partLocation = null;
        String partLocationStr = null;
        if (part.getSd() != null) {
            partLocationStr = part.getSd().getLocation();
        }
        if (partLocationStr == null || partLocationStr.isEmpty()) {
            if (tbl.getSd().getLocation() != null) {
                partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName((List)tbl.getPartitionKeys(), (List)part.getValues()));
            }
        } else {
            if (tbl.getSd().getLocation() == null) {
                throw new MetaException("Cannot specify location for a view partition");
            }
            partLocation = this.wh.getDnsPath(new Path(partLocationStr));
        }
        boolean result = false;
        if (partLocation != null) {
            part.getSd().setLocation(partLocation.toString());
            if (!this.wh.isDir(partLocation)) {
                if (!this.wh.mkdirs(partLocation)) {
                    throw new MetaException(partLocation + " is not a directory or unable to create one");
                }
                result = true;
            }
        }
        return result;
    }

    private boolean canUpdateStats(Table tbl) {
        Map tblParams = tbl.getParameters();
        boolean updateStatsTbl = true;
        if (tblParams != null && tblParams.containsKey("DO_NOT_UPDATE_STATS")) {
            boolean bl = updateStatsTbl = Boolean.valueOf((String)tblParams.get("DO_NOT_UPDATE_STATS")) == false;
        }
        return MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_AUTO_GATHER) && !MetaStoreUtils.isView((Table)tbl) && updateStatsTbl;
    }

    private void initializeAddedPartition(Table tbl, Partition part, boolean madeDir, EnvironmentContext environmentContext) throws MetaException {
        this.initializeAddedPartition(tbl, (PartitionSpecProxy.PartitionIterator)new PartitionSpecProxy.SimplePartitionWrapperIterator(part), madeDir, environmentContext);
    }

    private void initializeAddedPartition(Table tbl, PartitionSpecProxy.PartitionIterator part, boolean madeDir, EnvironmentContext environmentContext) throws MetaException {
        if (this.canUpdateStats(tbl)) {
            MetaStoreServerUtils.updatePartitionStatsFast(part, tbl, this.wh, madeDir, false, environmentContext, true);
        }
        long time = System.currentTimeMillis() / 1000L;
        part.setCreateTime((long)((int)time));
        if (part.getParameters() == null || part.getParameters().get("transient_lastDdlTime") == null) {
            part.putToParameters("transient_lastDdlTime", Long.toString(time));
        }
    }

    private void initializePartitionParameters(Table tbl, Partition part) throws MetaException {
        this.initializePartitionParameters(tbl, (PartitionSpecProxy.PartitionIterator)new PartitionSpecProxy.SimplePartitionWrapperIterator(part));
    }

    private void initializePartitionParameters(Table tbl, PartitionSpecProxy.PartitionIterator part) throws MetaException {
        Map tblParams = tbl.getParameters();
        String inheritProps = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PART_INHERIT_TBL_PROPS).trim();
        Set<String> inheritKeys = new HashSet<String>(Arrays.asList(inheritProps.split(LOG_SAMPLE_PARTITIONS_SEPARATOR)));
        if (inheritKeys.contains("*")) {
            inheritKeys = tblParams.keySet();
        }
        for (String key : inheritKeys) {
            String paramVal = (String)tblParams.get(key);
            if (null == paramVal) continue;
            part.putToParameters(key, paramVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Partition add_partition_core(RawStore ms, Partition part, EnvironmentContext envContext) throws TException {
        boolean success = false;
        Table tbl = null;
        Map<String, String> transactionalListenerResponses = Collections.emptyMap();
        if (!part.isSetCatName()) {
            part.setCatName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        }
        try {
            ms.openTransaction();
            tbl = ms.getTable(part.getCatName(), part.getDbName(), part.getTableName(), null);
            if (tbl == null) {
                throw new InvalidObjectException("Unable to add partition because table or database do not exist");
            }
            this.firePreEvent(new PreAddPartitionEvent(tbl, part, (IHMSHandler)this));
            if (part.getValues() == null || part.getValues().isEmpty()) {
                throw new MetaException("The partition values cannot be null or empty.");
            }
            boolean shouldAdd = this.startAddPartition(ms, part, tbl.getPartitionKeys(), false);
            assert (shouldAdd);
            boolean madeDir = this.createLocationForAddedPartition(tbl, part);
            try {
                this.initializeAddedPartition(tbl, part, madeDir, envContext);
                this.initializePartitionParameters(tbl, part);
                success = ms.addPartition(part);
            }
            finally {
                if (!success && madeDir) {
                    this.wh.deleteDir(new Path(part.getSd().getLocation()), true, false, ReplChangeManager.shouldEnableCm((Database)ms.getDatabase(part.getCatName(), part.getDbName()), (Table)tbl));
                }
            }
            success = false;
            if (!this.transactionalListeners.isEmpty()) {
                transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, Arrays.asList(part), true, (IHMSHandler)this), envContext);
            }
            if (!(success = ms.commitTransaction())) {
                ms.rollbackTransaction();
            }
            if (this.listeners.isEmpty()) return part;
        }
        catch (Throwable throwable) {
            if (!success) {
                ms.rollbackTransaction();
            }
            if (this.listeners.isEmpty()) throw throwable;
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, Arrays.asList(part), success, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
            throw throwable;
        }
        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, Arrays.asList(part), success, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
        return part;
    }

    @Deprecated
    public Partition add_partition(Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
        return this.add_partition_with_environment_context(part, null);
    }

    @Deprecated
    public Partition add_partition_with_environment_context(Partition part, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException {
        if (part == null) {
            throw new MetaException("Partition cannot be null.");
        }
        AddPartitionsRequest addPartitionsReq = new AddPartitionsRequest(part.getDbName(), part.getTableName(), new ArrayList<Partition>(Arrays.asList(part)), false);
        addPartitionsReq.setEnvironmentContext(envContext);
        try {
            return (Partition)this.add_partitions_req(addPartitionsReq).getPartitions().get(0);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidObjectException.class, AlreadyExistsException.class).defaultMetaException();
        }
    }

    public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceDbName, String sourceTableName, String destDbName, String destTableName) throws TException {
        this.exchange_partitions(partitionSpecs, sourceDbName, sourceTableName, destDbName, destTableName);
        return new Partition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDbName, String sourceTableName, String destDbName, String destTableName) throws TException {
        ArrayList<Partition> arrayList;
        ArrayList transactionalListenerResponsesForDropPartition;
        Map<String, String> transactionalListenerResponsesForAddPartition;
        ArrayList<Partition> destPartitions;
        List<Partition> partitionsToExchange;
        int i;
        Table sourceTable;
        Table destinationTable;
        RawStore ms;
        boolean success;
        block23: {
            Database destDb;
            Database srcDb;
            String[] parsedDestDbName = MetaStoreUtils.parseDbName((String)destDbName, (Configuration)this.conf);
            String[] parsedSourceDbName = MetaStoreUtils.parseDbName((String)sourceDbName, (Configuration)this.conf);
            if (partitionSpecs == null || parsedSourceDbName[1] == null || sourceTableName == null || parsedDestDbName[1] == null || destTableName == null) {
                throw new MetaException("The DB and table name for the source and destination tables, and the partition specs must not be null.");
            }
            if (!parsedDestDbName[0].equals(parsedSourceDbName[0])) {
                throw new MetaException("You cannot move a partition across catalogs");
            }
            success = false;
            boolean pathCreated = false;
            ms = this.getMS();
            ms.openTransaction();
            destinationTable = ms.getTable(parsedDestDbName[0], parsedDestDbName[1], destTableName, null);
            if (destinationTable == null) {
                throw new MetaException("The destination table " + TableName.getQualified((String)parsedDestDbName[0], (String)parsedDestDbName[1], (String)destTableName) + " not found");
            }
            sourceTable = ms.getTable(parsedSourceDbName[0], parsedSourceDbName[1], sourceTableName, null);
            if (sourceTable == null) {
                throw new MetaException("The source table " + TableName.getQualified((String)parsedSourceDbName[0], (String)parsedSourceDbName[1], (String)sourceTableName) + " not found");
            }
            List partVals = MetaStoreUtils.getPvals((List)sourceTable.getPartitionKeys(), partitionSpecs);
            ArrayList<String> partValsPresent = new ArrayList<String>();
            ArrayList<FieldSchema> partitionKeysPresent = new ArrayList<FieldSchema>();
            i = 0;
            for (FieldSchema fs : sourceTable.getPartitionKeys()) {
                String partVal = (String)partVals.get(i);
                if (partVal != null && !partVal.equals(NO_FILTER_STRING)) {
                    partValsPresent.add(partVal);
                    partitionKeysPresent.add(fs);
                }
                ++i;
            }
            partitionsToExchange = this.get_partitions_ps(sourceDbName, sourceTableName, partVals, (short)-1);
            if (partitionsToExchange == null || partitionsToExchange.isEmpty()) {
                throw new MetaException("No partition is found with the values " + partitionSpecs + " for the table " + sourceTableName);
            }
            boolean sameColumns = MetaStoreUtils.compareFieldColumns((List)sourceTable.getSd().getCols(), (List)destinationTable.getSd().getCols());
            boolean samePartitions = MetaStoreUtils.compareFieldColumns((List)sourceTable.getPartitionKeys(), (List)destinationTable.getPartitionKeys());
            if (!sameColumns || !samePartitions) {
                throw new MetaException("The tables have different schemas. Their partitions cannot be exchanged.");
            }
            Path sourcePath = new Path(sourceTable.getSd().getLocation(), Warehouse.makePartName(partitionKeysPresent, partValsPresent));
            Path destPath = new Path(destinationTable.getSd().getLocation(), Warehouse.makePartName(partitionKeysPresent, partValsPresent));
            destPartitions = new ArrayList<Partition>();
            transactionalListenerResponsesForAddPartition = Collections.emptyMap();
            transactionalListenerResponsesForDropPartition = Lists.newArrayListWithCapacity((int)partitionsToExchange.size());
            List<String> destPartitionNames = ms.listPartitionNames(parsedDestDbName[0], parsedDestDbName[1], destTableName, (short)-1);
            if (destPartitionNames != null && !destPartitionNames.isEmpty()) {
                for (Partition partition : partitionsToExchange) {
                    String partToExchangeName = Warehouse.makePartName((List)destinationTable.getPartitionKeys(), (List)partition.getValues());
                    if (!destPartitionNames.contains(partToExchangeName)) continue;
                    throw new MetaException("The partition " + (String)partToExchangeName + " already exists in the table " + destTableName);
                }
            }
            if (!HiveMetaStore.isRenameAllowed(srcDb = ms.getDatabase(parsedSourceDbName[0], parsedSourceDbName[1]), destDb = ms.getDatabase(parsedDestDbName[0], parsedDestDbName[1]))) {
                throw new MetaException("Exchange partition not allowed for " + TableName.getQualified((String)parsedSourceDbName[0], (String)parsedSourceDbName[1], (String)sourceTableName) + " Dest db : " + destDbName);
            }
            try {
                for (Partition partition : partitionsToExchange) {
                    Partition destPartition = new Partition(partition);
                    destPartition.setDbName(parsedDestDbName[1]);
                    destPartition.setTableName(destinationTable.getTableName());
                    Path destPartitionPath = new Path(destinationTable.getSd().getLocation(), Warehouse.makePartName((List)destinationTable.getPartitionKeys(), (List)partition.getValues()));
                    destPartition.getSd().setLocation(destPartitionPath.toString());
                    ms.addPartition(destPartition);
                    destPartitions.add(destPartition);
                    ms.dropPartition(parsedSourceDbName[0], partition.getDbName(), sourceTable.getTableName(), Warehouse.makePartName((List)sourceTable.getPartitionKeys(), (List)partition.getValues()));
                }
                Path destParentPath = destPath.getParent();
                if (!this.wh.isDir(destParentPath) && !this.wh.mkdirs(destParentPath)) {
                    throw new MetaException("Unable to create path " + destParentPath);
                }
                pathCreated = this.wh.renameDir(sourcePath, destPath, false);
                success = false;
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenerResponsesForAddPartition = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(destinationTable, destPartitions, true, (IHMSHandler)this));
                    for (Partition partition : partitionsToExchange) {
                        DropPartitionEvent dropPartitionEvent = new DropPartitionEvent(sourceTable, partition, true, true, (IHMSHandler)this);
                        transactionalListenerResponsesForDropPartition.add(MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_PARTITION, dropPartitionEvent));
                    }
                }
                success = ms.commitTransaction();
                arrayList = destPartitions;
                if (success && pathCreated) break block23;
                ms.rollbackTransaction();
                if (!pathCreated) break block23;
            }
            catch (Throwable throwable) {
                if (!success || !pathCreated) {
                    ms.rollbackTransaction();
                    if (pathCreated) {
                        this.wh.renameDir(destPath, sourcePath, false);
                    }
                }
                if (!this.listeners.isEmpty()) {
                    AddPartitionEvent addPartitionEvent = new AddPartitionEvent(destinationTable, destPartitions, success, (IHMSHandler)this);
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, addPartitionEvent, null, transactionalListenerResponsesForAddPartition, ms);
                    i = 0;
                    for (Partition partition : partitionsToExchange) {
                        DropPartitionEvent dropPartitionEvent = new DropPartitionEvent(sourceTable, partition, success, true, (IHMSHandler)this);
                        Map parameters = transactionalListenerResponsesForDropPartition.size() > i ? (Map)transactionalListenerResponsesForDropPartition.get(i) : null;
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, dropPartitionEvent, null, parameters, ms);
                        ++i;
                    }
                }
                throw throwable;
            }
            this.wh.renameDir(destPath, sourcePath, false);
        }
        if (!this.listeners.isEmpty()) {
            AddPartitionEvent addPartitionEvent = new AddPartitionEvent(destinationTable, destPartitions, success, (IHMSHandler)this);
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, addPartitionEvent, null, transactionalListenerResponsesForAddPartition, ms);
            i = 0;
            for (Partition partition : partitionsToExchange) {
                DropPartitionEvent dropPartitionEvent = new DropPartitionEvent(sourceTable, partition, success, true, (IHMSHandler)this);
                Map parameters = transactionalListenerResponsesForDropPartition.size() > i ? (Map)transactionalListenerResponsesForDropPartition.get(i) : null;
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, dropPartitionEvent, null, parameters, ms);
                ++i;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drop_partition_common(RawStore ms, String catName, String db_name, String tbl_name, List<String> part_vals, boolean deleteData, EnvironmentContext envContext) throws MetaException, NoSuchObjectException, IOException, InvalidObjectException, InvalidInputException {
        Map<String, String> transactionalListenerResponses;
        Partition part;
        Table tbl;
        boolean success;
        block22: {
            long writeId;
            Path partPath;
            block23: {
                partPath = null;
                boolean isArchived = false;
                Path archiveParentDir = null;
                success = false;
                tbl = null;
                part = null;
                boolean mustPurge = false;
                boolean tableDataShouldBeDeleted = false;
                writeId = 0L;
                transactionalListenerResponses = Collections.emptyMap();
                boolean needsCm = false;
                if (db_name == null) {
                    throw new MetaException("The DB name cannot be null.");
                }
                if (tbl_name == null) {
                    throw new MetaException("The table name cannot be null.");
                }
                if (part_vals == null) {
                    throw new MetaException("The partition values cannot be null.");
                }
                try {
                    ms.openTransaction();
                    part = ms.getPartition(catName, db_name, tbl_name, part_vals);
                    GetTableRequest request = new GetTableRequest(db_name, tbl_name);
                    request.setCatName(catName);
                    tbl = this.get_table_core(request);
                    this.firePreEvent(new PreDropPartitionEvent(tbl, part, deleteData, this));
                    tableDataShouldBeDeleted = this.checkTableDataShouldBeDeleted(tbl, deleteData);
                    mustPurge = HMSHandler.isMustPurge(envContext, tbl);
                    writeId = HMSHandler.getWriteId(envContext);
                    if (part == null) {
                        throw new NoSuchObjectException("Partition doesn't exist. " + part_vals);
                    }
                    isArchived = MetaStoreUtils.isArchived((Partition)part);
                    if (tableDataShouldBeDeleted && isArchived) {
                        archiveParentDir = MetaStoreUtils.getOriginalLocation((Partition)part);
                        this.verifyIsWritablePath(archiveParentDir);
                    }
                    if (tableDataShouldBeDeleted && part.getSd() != null && part.getSd().getLocation() != null) {
                        partPath = new Path(part.getSd().getLocation());
                        this.verifyIsWritablePath(partPath);
                    }
                    String partName = Warehouse.makePartName((List)tbl.getPartitionKeys(), part_vals);
                    ms.dropPartition(catName, db_name, tbl_name, partName);
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, part, true, deleteData, (IHMSHandler)this), envContext);
                    }
                    needsCm = ReplChangeManager.shouldEnableCm((Database)ms.getDatabase(catName, db_name), (Table)tbl);
                    success = ms.commitTransaction();
                    if (!success) {
                        ms.rollbackTransaction();
                        break block22;
                    }
                    if (!tableDataShouldBeDeleted || partPath == null && archiveParentDir == null) break block23;
                    LOG.info(mustPurge ? "dropPartition() will purge " + partPath + " directly, skipping trash." : "dropPartition() will move " + partPath + " to trash-directory.");
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else if (tableDataShouldBeDeleted && (partPath != null || archiveParentDir != null)) {
                        LOG.info(mustPurge ? "dropPartition() will purge " + partPath + " directly, skipping trash." : "dropPartition() will move " + partPath + " to trash-directory.");
                        if (isArchived) {
                            this.wh.deleteDir(archiveParentDir, true, mustPurge, needsCm);
                        } else {
                            this.wh.deleteDir(partPath, true, mustPurge, needsCm);
                            this.deleteParentRecursive(partPath.getParent(), part_vals.size() - 1, mustPurge, needsCm);
                        }
                    } else if (TxnUtils.isTransactionalTable(tbl) && writeId > 0L) {
                        HMSHandler.addTruncateBaseFile(partPath, writeId, this.conf, AcidMetaDataFile.DataFormat.DROPPED);
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, part, success, deleteData, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
                    }
                    throw throwable;
                }
                if (isArchived) {
                    this.wh.deleteDir(archiveParentDir, true, mustPurge, needsCm);
                } else {
                    this.wh.deleteDir(partPath, true, mustPurge, needsCm);
                    this.deleteParentRecursive(partPath.getParent(), part_vals.size() - 1, mustPurge, needsCm);
                }
                break block22;
            }
            if (TxnUtils.isTransactionalTable(tbl) && writeId > 0L) {
                HMSHandler.addTruncateBaseFile(partPath, writeId, this.conf, AcidMetaDataFile.DataFormat.DROPPED);
            }
        }
        if (!this.listeners.isEmpty()) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, part, success, deleteData, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
        }
        return true;
    }

    static boolean isMustPurge(EnvironmentContext envContext, Table tbl) {
        return envContext != null && envContext.getProperties() != null && Boolean.parseBoolean((String)envContext.getProperties().get("ifPurge")) || MetaStoreUtils.isSkipTrash((Map)tbl.getParameters());
    }

    static long getWriteId(EnvironmentContext context) {
        return Optional.ofNullable(context).map(EnvironmentContext::getProperties).map(prop -> (String)prop.get("writeId")).map(Long::parseLong).orElse(0L);
    }

    private void throwUnsupportedExceptionIfRemoteDB(String dbName, String operationName) throws MetaException {
        if (this.isDatabaseRemote(dbName)) {
            throw new MetaException("Operation " + operationName + " not supported for REMOTE database " + dbName);
        }
    }

    private boolean isDatabaseRemote(String name) {
        try {
            String[] parsedDbName = MetaStoreUtils.parseDbName((String)name, (Configuration)this.conf);
            Database db = this.get_database_core(parsedDbName[0], parsedDbName[1]);
            if (db != null && db.getType() != null && db.getType() == DatabaseType.REMOTE) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private void deleteParentRecursive(Path parent, int depth, boolean mustPurge, boolean needRecycle) throws IOException, MetaException {
        if (depth > 0 && parent != null && this.wh.isWritable(parent) && this.wh.isEmptyDir(parent)) {
            this.wh.deleteDir(parent, true, mustPurge, needRecycle);
            this.deleteParentRecursive(parent.getParent(), depth - 1, mustPurge, needRecycle);
        }
    }

    @Deprecated
    public boolean drop_partition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws TException {
        return this.drop_partition_with_environment_context(db_name, tbl_name, part_vals, deleteData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DropPartitionsResult drop_partitions_req(DropPartitionsRequest request) throws TException {
        DropPartitionsResult dropPartitionsResult;
        Map<String, String> transactionalListenerResponses;
        List<Object> parts;
        Table tbl;
        boolean success;
        EnvironmentContext envContext;
        boolean deleteData;
        RawStore ms;
        block42: {
            long writeId;
            block43: {
                ms = this.getMS();
                String dbName = request.getDbName();
                String tblName = request.getTblName();
                String catName = request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
                boolean ifExists = request.isSetIfExists() && request.isIfExists();
                deleteData = request.isSetDeleteData() && request.isDeleteData();
                boolean ignoreProtection = request.isSetIgnoreProtection() && request.isIgnoreProtection();
                boolean needResult = !request.isSetNeedResult() || request.isNeedResult();
                ArrayList<PathAndDepth> dirsToDelete = new ArrayList<PathAndDepth>();
                ArrayList<Path> archToDelete = new ArrayList<Path>();
                envContext = request.isSetEnvironmentContext() ? request.getEnvironmentContext() : null;
                success = false;
                tbl = null;
                parts = null;
                boolean mustPurge = false;
                boolean tableDataShouldBeDeleted = false;
                writeId = 0L;
                transactionalListenerResponses = null;
                boolean needsCm = false;
                try {
                    ms.openTransaction();
                    tbl = this.get_table_core(catName, dbName, tblName);
                    mustPurge = HMSHandler.isMustPurge(envContext, tbl);
                    tableDataShouldBeDeleted = this.checkTableDataShouldBeDeleted(tbl, deleteData);
                    writeId = HMSHandler.getWriteId(envContext);
                    boolean hasMissingParts = false;
                    RequestPartsSpec spec = request.getParts();
                    ArrayList<String> partNames = null;
                    if (spec.isSetExprs()) {
                        parts = new ArrayList(spec.getExprs().size());
                        Iterator iterator = spec.getExprs().iterator();
                        while (iterator.hasNext()) {
                            ArrayList<Partition> dropPartitionsResult2 = new ArrayList<Partition>();
                            DropPartitionsExpr expr = (DropPartitionsExpr)iterator.next();
                            boolean hasUnknown = ms.getPartitionsByExpr(catName, dbName, tblName, dropPartitionsResult2, new GetPartitionsArgs.GetPartitionsArgsBuilder().expr(expr.getExpr()).skipColumnSchemaForPartition(request.isSkipColumnSchemaForPartition()).build());
                            if (hasUnknown) {
                                throw new MetaException("Unexpected unknown partitions to drop");
                            }
                            if (!ignoreProtection && expr.isSetPartArchiveLevel()) {
                                for (Partition partition : parts) {
                                    if (!MetaStoreUtils.isArchived((Partition)partition) || MetaStoreUtils.getArchivingLevel((Partition)partition) >= expr.getPartArchiveLevel()) continue;
                                    throw new MetaException("Cannot drop a subset of partitions  in an archive, partition " + partition);
                                }
                            }
                            if (dropPartitionsResult2.isEmpty()) {
                                hasMissingParts = true;
                                if (!ifExists) break;
                            }
                            parts.addAll(dropPartitionsResult2);
                        }
                    } else if (spec.isSetNames()) {
                        partNames = spec.getNames();
                        parts = ms.getPartitionsByNames(catName, dbName, tblName, new GetPartitionsArgs.GetPartitionsArgsBuilder().partNames((List<String>)partNames).skipColumnSchemaForPartition(request.isSkipColumnSchemaForPartition()).build());
                        hasMissingParts = parts.size() != partNames.size();
                    } else {
                        throw new MetaException("Partition spec is not set");
                    }
                    if (hasMissingParts && !ifExists) {
                        throw new NoSuchObjectException("Some partitions to drop are missing");
                    }
                    ArrayList<String> colNames = null;
                    if (partNames == null) {
                        partNames = new ArrayList<String>(parts.size());
                        colNames = new ArrayList<String>(tbl.getPartitionKeys().size());
                        for (FieldSchema fieldSchema : tbl.getPartitionKeys()) {
                            colNames.add(fieldSchema.getName());
                        }
                    }
                    for (Partition partition : parts) {
                        this.firePreEvent(new PreDropPartitionEvent(tbl, partition, deleteData, this));
                        if (colNames != null) {
                            partNames.add(FileUtils.makePartName(colNames, (List)partition.getValues()));
                        }
                        if (tableDataShouldBeDeleted && MetaStoreUtils.isArchived((Partition)partition)) {
                            Path archiveParentDir = MetaStoreUtils.getOriginalLocation((Partition)partition);
                            this.verifyIsWritablePath(archiveParentDir);
                            archToDelete.add(archiveParentDir);
                        }
                        if (!tableDataShouldBeDeleted || partition.getSd() == null || partition.getSd().getLocation() == null) continue;
                        Path partPath = new Path(partition.getSd().getLocation());
                        this.verifyIsWritablePath(partPath);
                        dirsToDelete.add(new PathAndDepth(partPath, partition.getValues().size()));
                    }
                    ms.dropPartitions(catName, dbName, tblName, partNames);
                    if (!parts.isEmpty() && !this.transactionalListeners.isEmpty()) {
                        transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, parts, true, deleteData, (IHMSHandler)this), envContext);
                    }
                    success = ms.commitTransaction();
                    needsCm = ReplChangeManager.shouldEnableCm((Database)ms.getDatabase(catName, dbName), (Table)tbl);
                    DropPartitionsResult result = new DropPartitionsResult();
                    if (needResult) {
                        result.setPartitions(parts);
                    }
                    dropPartitionsResult = result;
                    if (!success) {
                        ms.rollbackTransaction();
                        break block42;
                    }
                    if (!tableDataShouldBeDeleted) break block43;
                    LOG.info(mustPurge ? "dropPartition() will purge partition-directories directly, skipping trash." : "dropPartition() will move partition-directories to trash-directory.");
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else if (tableDataShouldBeDeleted) {
                        LOG.info(mustPurge ? "dropPartition() will purge partition-directories directly, skipping trash." : "dropPartition() will move partition-directories to trash-directory.");
                        for (Path path : archToDelete) {
                            this.wh.deleteDir(path, true, mustPurge, needsCm);
                        }
                        PriorityQueue<PathAndDepth> parentsToDelete = new PriorityQueue<PathAndDepth>();
                        for (PathAndDepth p : dirsToDelete) {
                            this.wh.deleteDir(p.path, true, mustPurge, needsCm);
                            HMSHandler.addParentForDel(parentsToDelete, p);
                        }
                        HashSet<PathAndDepth> hashSet = new HashSet<PathAndDepth>();
                        while (!parentsToDelete.isEmpty()) {
                            try {
                                PathAndDepth p;
                                p = (PathAndDepth)parentsToDelete.poll();
                                if (hashSet.contains(p)) continue;
                                hashSet.add(p);
                                Path path = p.path;
                                if (!this.wh.isWritable(path) || !this.wh.isEmptyDir(path)) continue;
                                this.wh.deleteDir(path, true, mustPurge, needsCm);
                                HMSHandler.addParentForDel(parentsToDelete, p);
                            }
                            catch (IOException ex) {
                                LOG.warn("Error from recursive parent deletion", (Throwable)ex);
                                throw new MetaException("Failed to delete parent: " + ex.getMessage());
                            }
                        }
                    } else if (TxnUtils.isTransactionalTable(tbl) && writeId > 0L) {
                        for (Partition partition : parts) {
                            if (partition.getSd() == null || partition.getSd().getLocation() == null) continue;
                            Path partPath = new Path(partition.getSd().getLocation());
                            this.verifyIsWritablePath(partPath);
                            HMSHandler.addTruncateBaseFile(partPath, writeId, this.conf, AcidMetaDataFile.DataFormat.DROPPED);
                        }
                    }
                    if (parts != null && !parts.isEmpty() && !this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, (Iterable<Partition>)parts, success, deleteData, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
                    }
                    throw throwable;
                }
                for (Path path : archToDelete) {
                    this.wh.deleteDir(path, true, mustPurge, needsCm);
                }
                PriorityQueue<PathAndDepth> parentsToDelete = new PriorityQueue<PathAndDepth>();
                for (PathAndDepth pathAndDepth : dirsToDelete) {
                    this.wh.deleteDir(pathAndDepth.path, true, mustPurge, needsCm);
                    HMSHandler.addParentForDel(parentsToDelete, pathAndDepth);
                }
                HashSet<PathAndDepth> hashSet = new HashSet<PathAndDepth>();
                while (!parentsToDelete.isEmpty()) {
                    try {
                        PathAndDepth pathAndDepth = (PathAndDepth)parentsToDelete.poll();
                        if (hashSet.contains(pathAndDepth)) continue;
                        hashSet.add(pathAndDepth);
                        Path path = pathAndDepth.path;
                        if (!this.wh.isWritable(path) || !this.wh.isEmptyDir(path)) continue;
                        this.wh.deleteDir(path, true, mustPurge, needsCm);
                        HMSHandler.addParentForDel(parentsToDelete, pathAndDepth);
                    }
                    catch (IOException iOException) {
                        LOG.warn("Error from recursive parent deletion", (Throwable)iOException);
                        throw new MetaException("Failed to delete parent: " + iOException.getMessage());
                    }
                }
                break block42;
            }
            if (TxnUtils.isTransactionalTable(tbl) && writeId > 0L) {
                for (Partition partition : parts) {
                    if (partition.getSd() == null || partition.getSd().getLocation() == null) continue;
                    Path path = new Path(partition.getSd().getLocation());
                    this.verifyIsWritablePath(path);
                    HMSHandler.addTruncateBaseFile(path, writeId, this.conf, AcidMetaDataFile.DataFormat.DROPPED);
                }
            }
        }
        if (parts != null && !parts.isEmpty() && !this.listeners.isEmpty()) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, parts, success, deleteData, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
        }
        return dropPartitionsResult;
    }

    private static void addParentForDel(PriorityQueue<PathAndDepth> parentsToDelete, PathAndDepth p) {
        Path parent = p.path.getParent();
        if (parent != null && p.depth - 1 > 0) {
            parentsToDelete.add(new PathAndDepth(parent, p.depth - 1));
        }
    }

    private void verifyIsWritablePath(Path dir) throws MetaException {
        try {
            if (!this.wh.isWritable(dir.getParent())) {
                throw new MetaException("Table partition not deleted since " + dir.getParent() + " is not writable by " + SecurityUtils.getUser());
            }
        }
        catch (IOException ex) {
            LOG.warn("Error from isWritable", (Throwable)ex);
            throw new MetaException("Table partition not deleted since " + dir.getParent() + " access cannot be checked: " + ex.getMessage());
        }
    }

    @Deprecated
    public boolean drop_partition_with_environment_context(String db_name, String tbl_name, List<String> part_vals, boolean deleteData, EnvironmentContext envContext) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        DropPartitionRequest dropPartitionReq = new DropPartitionRequest(parsedDbName[1], tbl_name);
        dropPartitionReq.setCatName(parsedDbName[0]);
        dropPartitionReq.setPartVals(part_vals);
        dropPartitionReq.setDeleteData(deleteData);
        dropPartitionReq.setEnvironmentContext(envContext);
        return this.drop_partition_req(dropPartitionReq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop_partition_req(DropPartitionRequest dropPartitionReq) throws TException {
        String dbName = dropPartitionReq.getDbName();
        String catName = dropPartitionReq.getCatName();
        String tbl_name = dropPartitionReq.getTblName();
        List<String> part_vals = dropPartitionReq.getPartVals();
        boolean ret = false;
        Exception ex = null;
        try {
            if (part_vals == null || part_vals.isEmpty()) {
                part_vals = this.getPartValsFromName(this.getMS(), catName, dbName, tbl_name, dropPartitionReq.getPartName());
            }
            this.startPartitionFunction("drop_partition_req", catName, dbName, tbl_name, part_vals);
            LOG.info("Partition values:" + part_vals);
            ret = this.drop_partition_common(this.getMS(), catName, dbName, tbl_name, part_vals, dropPartitionReq.isDeleteData(), dropPartitionReq.getEnvironmentContext());
        }
        catch (Exception e) {
            ex = e;
            ExceptionHandler.handleException(e).convertIfInstance(InvalidObjectException.class, NoSuchObjectException.class);
            ExceptionHandler.rethrowException(e);
        }
        finally {
            this.endFunction("drop_partition_req", ret, ex, tbl_name);
        }
        return ret;
    }

    @Deprecated
    public Partition get_partition(String db_name, String tbl_name, List<String> part_vals) throws MetaException, NoSuchObjectException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.startPartitionFunction("get_partition", parsedDbName[0], parsedDbName[1], tbl_name, part_vals);
        Partition ret = null;
        Exception ex = null;
        try {
            GetPartitionRequest getPartitionRequest = new GetPartitionRequest(parsedDbName[1], tbl_name, part_vals);
            getPartitionRequest.setCatName(parsedDbName[0]);
            ret = this.get_partition_req(getPartitionRequest).getPartition();
            this.endFunction("get_partition", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("get_partition", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    private Partition get_partition_core(String db_name, String tbl_name, List<String> part_vals) throws MetaException, NoSuchObjectException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.startPartitionFunction("get_partition_core", parsedDbName[0], parsedDbName[1], tbl_name, part_vals);
        Partition ret = null;
        Exception ex = null;
        try {
            this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
            this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
            ret = this.getMS().getPartition(parsedDbName[0], parsedDbName[1], tbl_name, part_vals);
            ret = FilterUtils.filterPartitionIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (Partition)ret);
            this.endFunction("get_partition_core", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("get_partition_core", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    public GetPartitionResponse get_partition_req(GetPartitionRequest req) throws MetaException, NoSuchObjectException, TException {
        String dbName = MetaStoreUtils.prependCatalogToDbName((String)req.getCatName(), (String)req.getDbName(), (Configuration)this.conf);
        Partition p = this.get_partition_core(dbName, req.getTblName(), req.getPartVals());
        GetPartitionResponse res = new GetPartitionResponse();
        res.setPartition(p);
        return res;
    }

    private void fireReadTablePreEvent(final String catName, final String dbName, final String tblName) throws MetaException, NoSuchObjectException {
        if (this.preListeners.size() > 0) {
            Supplier tableSupplier = Suppliers.memoize((Supplier)new Supplier<Table>(){

                public Table get() {
                    try {
                        Table t = HMSHandler.this.getMS().getTable(catName, dbName, tblName, null);
                        if (t == null) {
                            throw new NoSuchObjectException(TableName.getQualified((String)catName, (String)dbName, (String)tblName) + " table not found");
                        }
                        return t;
                    }
                    catch (MetaException | NoSuchObjectException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.firePreEvent(new PreReadTableEvent((Supplier<Table>)tableSupplier, (IHMSHandler)this));
        }
    }

    private List<TableMeta> filterReadableTables(String catName, List<TableMeta> tableMetas) throws RuntimeException, NoSuchObjectException {
        ArrayList<TableMeta> finalT = new ArrayList<TableMeta>();
        HashMap<String, Boolean> databaseNames = new HashMap<String, Boolean>();
        for (TableMeta tableMeta : tableMetas) {
            String fullDbName = MetaStoreUtils.prependCatalogToDbName((String)catName, (String)tableMeta.getDbName(), (Configuration)this.conf);
            if (databaseNames.get(fullDbName) == null) {
                boolean isExecptionThrown = false;
                try {
                    this.fireReadDatabasePreEvent(fullDbName);
                }
                catch (MetaException e) {
                    isExecptionThrown = true;
                }
                databaseNames.put(fullDbName, isExecptionThrown);
            }
            if (((Boolean)databaseNames.get(fullDbName)).booleanValue()) continue;
            finalT.add(tableMeta);
        }
        return finalT;
    }

    private void fireReadDatabasePreEvent(String name) throws MetaException, RuntimeException, NoSuchObjectException {
        if (this.preListeners.size() > 0) {
            String[] parsedDbName = MetaStoreUtils.parseDbName((String)name, (Configuration)this.conf);
            Database db = null;
            try {
                db = this.get_database_core(parsedDbName[0], parsedDbName[1]);
                if (db == null) {
                    throw new NoSuchObjectException("Database: " + name + " not found");
                }
            }
            catch (MetaException | NoSuchObjectException e) {
                throw new RuntimeException(e);
            }
            this.firePreEvent(new PreReadDatabaseEvent(db, (IHMSHandler)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Partition get_partition_with_auth(String db_name, String tbl_name, List<String> part_vals, String user_name, List<String> group_names) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.startFunction("get_partition_with_auth", " : tbl=" + TableName.getQualified((String)parsedDbName[0], (String)parsedDbName[1], (String)tbl_name) + this.samplePartitionValues(part_vals) + this.getGroupsCountAndUsername(user_name, group_names));
        this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
        Partition ret = null;
        Exception ex = null;
        try {
            this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
            ret = this.getMS().getPartitionWithAuth(parsedDbName[0], parsedDbName[1], tbl_name, part_vals, user_name, group_names);
            ret = FilterUtils.filterPartitionIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (Partition)ret);
            this.endFunction("get_partition_with_auth", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.handleException(e).convertIfInstance(InvalidObjectException.class, NoSuchObjectException.class);
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_partition_with_auth", ret != null, ex, tbl_name);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partition_with_auth", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    @Deprecated
    public List<Partition> get_partitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException {
        return this.get_partitions(db_name, tbl_name, new GetPartitionsArgs.GetPartitionsArgsBuilder().max(max_parts).build());
    }

    private List<Partition> get_partitions(String db_name, String tbl_name, GetPartitionsArgs args) throws NoSuchObjectException, MetaException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        List ret = null;
        Exception ex = null;
        try {
            PartitionsRequest req = new PartitionsRequest(parsedDbName[1], tbl_name);
            req.setCatName(parsedDbName[0]);
            req.setMaxParts((short)args.getMax());
            req.setSkipColumnSchemaForPartition(false);
            req.setIncludeParamKeyPattern(args.getIncludeParamKeyPattern());
            req.setExcludeParamKeyPattern(args.getExcludeParamKeyPattern());
            ret = this.get_partitions_req(req).getPartitions();
        }
        catch (Exception e) {
            ex = e;
            ExceptionHandler.throwMetaException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Partition> get_partitions_core(String db_name, String tbl_name, GetPartitionsArgs args) throws NoSuchObjectException, MetaException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.startTableFunction("get_partitions_core", parsedDbName[0], parsedDbName[1], tbl_name);
        this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
        List ret = null;
        Exception ex = null;
        try {
            this.checkLimitNumberOfPartitionsByFilter(parsedDbName[0], parsedDbName[1], tbl_name, NO_FILTER_STRING, args.getMax());
            this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
            ret = this.getMS().getPartitions(parsedDbName[0], parsedDbName[1], tbl_name, args);
            ret = FilterUtils.filterPartitionsIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, ret);
            this.endFunction("get_partitions_core", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.throwMetaException(e);
                this.endFunction("get_partitions_core", ret != null, ex, tbl_name);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_core", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    public PartitionsResponse get_partitions_req(PartitionsRequest req) throws NoSuchObjectException, MetaException, TException {
        String dbName = MetaStoreUtils.prependCatalogToDbName((String)req.getCatName(), (String)req.getDbName(), (Configuration)this.conf);
        List<Partition> partitions = this.get_partitions_core(dbName, req.getTblName(), new GetPartitionsArgs.GetPartitionsArgsBuilder().max(req.getMaxParts()).includeParamKeyPattern(req.getIncludeParamKeyPattern()).excludeParamKeyPattern(req.getExcludeParamKeyPattern()).skipColumnSchemaForPartition(req.isSkipColumnSchemaForPartition()).build());
        PartitionsResponse res = new PartitionsResponse();
        res.setPartitions(partitions);
        return res;
    }

    @Deprecated
    public List<Partition> get_partitions_with_auth(String dbName, String tblName, short maxParts, String userName, List<String> groupNames) throws TException {
        return this.get_partitions_ps_with_auth(dbName, tblName, new GetPartitionsArgs.GetPartitionsArgsBuilder().max(maxParts).userName(userName).groupNames(groupNames).build());
    }

    private void checkLimitNumberOfPartitionsByFilter(String catName, String dbName, String tblName, String filterString, int requestMax) throws TException {
        if (this.exceedsPartitionFetchLimit(requestMax)) {
            this.checkLimitNumberOfPartitions(tblName, this.get_num_partitions_by_filter(MetaStoreUtils.prependCatalogToDbName((String)catName, (String)dbName, (Configuration)this.conf), tblName, filterString));
        }
    }

    private void checkLimitNumberOfPartitionsByPs(String catName, String dbName, String tblName, List<String> partVals, int requestMax) throws TException {
        if (this.exceedsPartitionFetchLimit(requestMax)) {
            this.checkLimitNumberOfPartitions(tblName, this.getNumPartitionsByPs(catName, dbName, tblName, partVals));
        }
    }

    private boolean exceedsPartitionFetchLimit(int count) {
        int partitionLimit = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST);
        return partitionLimit > -1 && (count < 0 || count > partitionLimit);
    }

    private void checkLimitNumberOfPartitions(String tblName, int numPartitions) throws MetaException {
        if (this.exceedsPartitionFetchLimit(numPartitions)) {
            int partitionLimit = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST);
            String configName = MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST.toString();
            throw new MetaException(String.format(PARTITION_NUMBER_EXCEED_LIMIT_MSG, numPartitions, tblName, partitionLimit, configName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<PartitionSpec> get_partitions_pspec(String db_name, String tbl_name, int max_parts) throws NoSuchObjectException, MetaException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        String catName = parsedDbName[0];
        String dbName = parsedDbName[1];
        String tableName = tbl_name.toLowerCase();
        this.startPartitionFunction("get_partitions_pspec", catName, dbName, tableName, max_parts);
        List<PartitionSpec> partitionSpecs = null;
        try {
            Table table = this.get_table_core(catName, dbName, tableName);
            List<Partition> partitions = this.get_partitions(db_name, tableName, new GetPartitionsArgs.GetPartitionsArgsBuilder().max(max_parts).build());
            if (HMSHandler.is_partition_spec_grouping_enabled(table)) {
                partitionSpecs = MetaStoreServerUtils.getPartitionspecsGroupedByStorageDescriptor(table, partitions);
            } else {
                PartitionSpec pSpec = new PartitionSpec();
                pSpec.setPartitionList(new PartitionListComposingSpec(partitions));
                pSpec.setCatName(StringUtils.normalizeIdentifier((String)catName));
                pSpec.setDbName(StringUtils.normalizeIdentifier((String)dbName));
                pSpec.setTableName(tableName);
                pSpec.setRootPath(table.getSd().getLocation());
                partitionSpecs = Arrays.asList(pSpec);
            }
            List<PartitionSpec> list = partitionSpecs;
            this.endFunction("get_partitions_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tbl_name);
            return list;
        }
        catch (Throwable throwable) {
            this.endFunction("get_partitions_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tbl_name);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetPartitionsResponse get_partitions_with_specs(GetPartitionsRequest request) throws MetaException, TException {
        String catName = null;
        if (request.isSetCatName()) {
            catName = request.getCatName();
        }
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)request.getDbName(), (Configuration)this.conf);
        String tableName = request.getTblName();
        if (catName == null) {
            catName = parsedDbName[0];
        }
        this.startTableFunction("get_partitions_with_specs", catName, parsedDbName[1], tableName);
        GetPartitionsResponse response = null;
        Exception ex = null;
        try {
            Table table = this.get_table_core(catName, parsedDbName[1], tableName);
            List<Partition> partitions = this.getMS().getPartitionSpecsByFilterAndProjection(table, request.getProjectionSpec(), request.getFilterSpec());
            List processorCapabilities = request.getProcessorCapabilities();
            String processorId = request.getProcessorIdentifier();
            if (processorCapabilities == null || processorCapabilities.size() == 0 || processorCapabilities.contains("MANAGERAWMETADATA")) {
                LOG.info("Skipping translation for processor with " + processorId);
            } else if (this.transformer != null) {
                partitions = this.transformer.transformPartitions(partitions, table, processorCapabilities, processorId);
            }
            List<PartitionSpec> partitionSpecs = MetaStoreServerUtils.getPartitionspecsGroupedByStorageDescriptor(table, partitions);
            response = new GetPartitionsResponse();
            response.setPartitionSpec(partitionSpecs);
            this.endFunction("get_partitions_with_specs", response != null, ex, tableName);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_partitions_with_specs", response != null, ex, tableName);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_with_specs", response != null, ex, tableName);
                throw throwable;
            }
        }
        return response;
    }

    private static boolean is_partition_spec_grouping_enabled(Table table) {
        Map parameters = table.getParameters();
        return parameters.containsKey("hive.hcatalog.partition.spec.grouping.enabled") && ((String)parameters.get("hive.hcatalog.partition.spec.grouping.enabled")).equalsIgnoreCase("true");
    }

    @Deprecated
    public List<String> get_partition_names(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.startPartitionFunction("get_partition_names", parsedDbName[0], parsedDbName[1], tbl_name, max_parts);
        this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
        List<String> ret = null;
        Exception ex = null;
        try {
            PartitionsRequest partitionReq = new PartitionsRequest(parsedDbName[1], tbl_name);
            partitionReq.setCatName(parsedDbName[0]);
            partitionReq.setMaxParts(max_parts);
            ret = this.fetch_partition_names_req(partitionReq);
            this.endFunction("get_partition_names", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partition_names", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    public List<String> fetch_partition_names_req(PartitionsRequest partitionReq) throws NoSuchObjectException, MetaException {
        String catName = partitionReq.getCatName();
        String dbName = partitionReq.getDbName();
        String tbl_name = partitionReq.getTblName();
        this.startTableFunction("fetch_partition_names_req", catName, dbName, tbl_name);
        this.fireReadTablePreEvent(catName, dbName, tbl_name);
        List ret = null;
        Exception ex = null;
        try {
            this.authorizeTableForPartitionMetadata(catName, dbName, tbl_name);
            ret = this.getMS().listPartitionNames(catName, dbName, tbl_name, partitionReq.getMaxParts());
            ret = FilterUtils.filterPartitionNamesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (String)catName, (String)dbName, (String)tbl_name, ret);
            this.endFunction("fetch_partition_names_req", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("fetch_partition_names_req", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    public PartitionValuesResponse get_partition_values(PartitionValuesRequest request) throws MetaException {
        String catName = request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        String dbName = request.getDbName();
        String tblName = request.getTblName();
        long maxParts = request.getMaxParts();
        String filter = request.isSetFilter() ? request.getFilter() : NO_FILTER_STRING;
        this.startPartitionFunction("get_partition_values", catName, dbName, tblName, (int)maxParts, filter);
        try {
            this.authorizeTableForPartitionMetadata(catName, dbName, tblName);
            ArrayList partCols = new ArrayList();
            partCols.add(request.getPartitionKeys().get(0));
            return this.getMS().listPartitionValues(catName, dbName, tblName, request.getPartitionKeys(), request.isApplyDistinct(), request.getFilter(), request.isAscending(), request.getPartitionOrder(), request.getMaxParts());
        }
        catch (NoSuchObjectException e) {
            LOG.error(String.format("Unable to get partition for %s.%s.%s", catName, dbName, tblName), (Throwable)e);
            throw new MetaException(e.getMessage());
        }
    }

    @Deprecated
    public void alter_partition(String db_name, String tbl_name, Partition new_part) throws TException {
        this.rename_partition(db_name, tbl_name, null, new_part);
    }

    @Deprecated
    public void alter_partition_with_environment_context(String dbName, String tableName, Partition newPartition, EnvironmentContext envContext) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        this.alter_partition_core(parsedDbName[0], parsedDbName[1], tableName, null, newPartition, envContext, null);
    }

    @Deprecated
    public void rename_partition(String db_name, String tbl_name, List<String> part_vals, Partition new_part) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.alter_partition_core(parsedDbName[0], parsedDbName[1], tbl_name, part_vals, new_part, null, null);
    }

    public RenamePartitionResponse rename_partition_req(RenamePartitionRequest req) throws TException {
        EnvironmentContext context = new EnvironmentContext();
        context.putToProperties("renamePartitionMakeCopy", String.valueOf(req.isClonePart()));
        context.putToProperties("txnId", String.valueOf(req.getTxnId()));
        this.alter_partition_core(req.getCatName(), req.getDbName(), req.getTableName(), req.getPartVals(), req.getNewPart(), context, req.getValidWriteIdList());
        return new RenamePartitionResponse();
    }

    private void alter_partition_core(String catName, String db_name, String tbl_name, List<String> part_vals, Partition new_part, EnvironmentContext envContext, String validWriteIds) throws TException {
        String newLocation;
        this.startTableFunction("alter_partition", catName, db_name, tbl_name);
        if (LOG.isInfoEnabled()) {
            LOG.info("New partition values:" + new_part.getValues());
            if (part_vals != null && part_vals.size() > 0) {
                LOG.info("Old Partition values:" + part_vals);
            }
        }
        if (new_part.getSd() != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(newLocation = new_part.getSd().getLocation()))) {
            Path tblPath = this.wh.getDnsPath(new Path(newLocation));
            new_part.getSd().setLocation(tblPath.toString());
        }
        if (!new_part.isSetCatName()) {
            new_part.setCatName(catName);
        }
        Partition oldPart = null;
        Exception ex = null;
        try {
            Table table = this.getMS().getTable(catName, db_name, tbl_name, null);
            this.firePreEvent(new PreAlterPartitionEvent(db_name, tbl_name, table, part_vals, new_part, this));
            if (part_vals != null && !part_vals.isEmpty()) {
                MetaStoreServerUtils.validatePartitionNameCharacters(new_part.getValues(), this.partitionValidationPattern);
            }
            oldPart = this.alterHandler.alterPartition(this.getMS(), this.wh, catName, db_name, tbl_name, part_vals, new_part, envContext, this, validWriteIds);
            if (!this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldPart, new_part, table, false, true, new_part.getWriteId(), this), envContext);
            }
            this.endFunction("alter_partition", oldPart != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidOperationException.class).convertIfInstance(InvalidObjectException.class, InvalidOperationException.class).convertIfInstance(AlreadyExistsException.class, InvalidOperationException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("alter_partition", oldPart != null, ex, tbl_name);
                throw throwable;
            }
        }
    }

    @Deprecated
    public void alter_partitions(String db_name, String tbl_name, List<Partition> new_parts) throws TException {
        String[] o = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        AlterPartitionsRequest req = new AlterPartitionsRequest(o[1], tbl_name, new_parts);
        req.setCatName(o[0]);
        this.alter_partitions_req(req);
    }

    public AlterPartitionsResponse alter_partitions_req(AlterPartitionsRequest req) throws TException {
        this.alter_partitions_with_environment_context(req.getCatName(), req.getDbName(), req.getTableName(), req.getPartitions(), req.getEnvironmentContext(), req.isSetValidWriteIdList() ? req.getValidWriteIdList() : null, req.isSetWriteId() ? req.getWriteId() : -1L);
        return new AlterPartitionsResponse();
    }

    @Deprecated
    public void alter_partitions_with_environment_context(String db_name, String tbl_name, List<Partition> new_parts, EnvironmentContext environmentContext) throws TException {
        String[] o = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        AlterPartitionsRequest req = new AlterPartitionsRequest(o[1], tbl_name, new_parts);
        req.setCatName(o[0]);
        req.setEnvironmentContext(environmentContext);
        this.alter_partitions_req(req);
    }

    private void alter_partitions_with_environment_context(String catName, String db_name, String tbl_name, List<Partition> new_parts, EnvironmentContext environmentContext, String writeIdList, long writeId) throws TException {
        if (environmentContext == null) {
            environmentContext = new EnvironmentContext();
        }
        if (catName == null) {
            catName = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        }
        this.startTableFunction("alter_partitions", catName, db_name, tbl_name);
        if (LOG.isInfoEnabled()) {
            for (Partition tmpPart : new_parts) {
                LOG.info("New partition values: catalog: {} database: {} table: {} partition: {}", new Object[]{catName, db_name, tbl_name, tmpPart.getValues()});
            }
        }
        List<Partition> oldParts = null;
        Exception ex = null;
        Lock tableLock = this.getTableLockFor(db_name, tbl_name);
        tableLock.lock();
        try {
            Table table = null;
            table = this.getMS().getTable(catName, db_name, tbl_name, null);
            for (Partition tmpPart : new_parts) {
                if (!tmpPart.isSetCatName()) {
                    tmpPart.setCatName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
                }
                if (tmpPart.getSd() != null && tmpPart.getSd().getCols() != null && tmpPart.getSd().getCols().isEmpty()) {
                    tmpPart.getSd().setCols(table.getSd().getCols());
                }
                this.firePreEvent(new PreAlterPartitionEvent(db_name, tbl_name, table, null, tmpPart, this));
            }
            oldParts = this.alterHandler.alterPartitions(this.getMS(), this.wh, catName, db_name, tbl_name, new_parts, environmentContext, writeIdList, writeId, this);
            Iterator<Partition> olditr = oldParts.iterator();
            for (Partition tmpPart : new_parts) {
                if (!olditr.hasNext()) {
                    throw new InvalidOperationException("failed to alterpartitions");
                }
                Partition oldTmpPart = olditr.next();
                if (this.listeners.isEmpty()) continue;
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldTmpPart, tmpPart, table, false, true, writeId, this));
            }
            tableLock.unlock();
            this.endFunction("alter_partitions", oldParts != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidOperationException.class).convertIfInstance(InvalidObjectException.class, InvalidOperationException.class).convertIfInstance(AlreadyExistsException.class, InvalidOperationException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                tableLock.unlock();
                this.endFunction("alter_partitions", oldParts != null, ex, tbl_name);
                throw throwable;
            }
        }
    }

    public String getVersion() throws TException {
        String version = MetastoreVersionInfo.getVersion();
        this.endFunction(this.startFunction("getVersion"), version != null, null);
        return version;
    }

    @Deprecated
    public void alter_table(String dbname, String name, Table newTable) throws InvalidOperationException, MetaException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbname, (Configuration)this.conf);
        AlterTableRequest req = new AlterTableRequest(parsedDbName[1], name, newTable);
        req.setCatName(parsedDbName[0]);
        this.alter_table_req(req);
    }

    @Deprecated
    public void alter_table_with_cascade(String dbname, String name, Table newTable, boolean cascade) throws InvalidOperationException, MetaException {
        EnvironmentContext envContext = null;
        if (cascade) {
            envContext = new EnvironmentContext();
            envContext.putToProperties("CASCADE", "true");
        }
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbname, (Configuration)this.conf);
        AlterTableRequest req = new AlterTableRequest(parsedDbName[1], name, newTable);
        req.setCatName(parsedDbName[0]);
        req.setEnvironmentContext(envContext);
        this.alter_table_req(req);
    }

    public AlterTableResponse alter_table_req(AlterTableRequest req) throws InvalidOperationException, MetaException {
        this.alter_table_core(req.getCatName(), req.getDbName(), req.getTableName(), req.getTable(), req.getEnvironmentContext(), req.getValidWriteIdList(), req.getProcessorCapabilities(), req.getProcessorIdentifier(), req.getExpectedParameterKey(), req.getExpectedParameterValue());
        return new AlterTableResponse();
    }

    @Deprecated
    public void alter_table_with_environment_context(String dbname, String name, Table newTable, EnvironmentContext envContext) throws InvalidOperationException, MetaException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbname, (Configuration)this.conf);
        AlterTableRequest req = new AlterTableRequest(parsedDbName[1], name, newTable);
        req.setCatName(parsedDbName[0]);
        req.setEnvironmentContext(envContext);
        this.alter_table_req(req);
    }

    private void alter_table_core(String catName, String dbname, String name, Table newTable, EnvironmentContext envContext, String validWriteIdList, List<String> processorCapabilities, String processorId, String expectedPropertyKey, String expectedPropertyValue) throws InvalidOperationException, MetaException {
        String newLocation;
        this.startFunction("alter_table", ": " + TableName.getQualified((String)catName, (String)dbname, (String)name) + " newtbl=" + newTable.getTableName());
        if (envContext == null) {
            envContext = new EnvironmentContext();
        }
        if (expectedPropertyKey != null) {
            envContext.putToProperties("expected_parameter_key", expectedPropertyKey);
        }
        if (expectedPropertyValue != null) {
            envContext.putToProperties("expected_parameter_value", expectedPropertyValue);
        }
        if (catName == null) {
            catName = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        }
        try {
            Database db = this.get_database_core(catName, dbname);
            if (db != null && db.getType().equals((Object)DatabaseType.REMOTE)) {
                throw new MetaException("Alter table in REMOTE database " + db.getName() + " is not allowed");
            }
        }
        catch (NoSuchObjectException e) {
            throw new InvalidOperationException("Alter table in REMOTE database is not allowed");
        }
        if (newTable.getParameters() == null || newTable.getParameters().get("transient_lastDdlTime") == null) {
            newTable.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
        }
        if (newTable.getSd() != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(newLocation = newTable.getSd().getLocation()))) {
            Path tblPath = this.wh.getDnsPath(new Path(newLocation));
            newTable.getSd().setLocation(tblPath.toString());
        }
        if (!newTable.isSetCatName()) {
            newTable.setCatName(catName);
        }
        boolean success = false;
        Exception ex = null;
        try {
            GetTableRequest request = new GetTableRequest(dbname, name);
            request.setCatName(catName);
            Table oldt = this.get_table_core(request);
            if (this.transformer != null) {
                newTable = this.transformer.transformAlterTable(oldt, newTable, processorCapabilities, processorId);
            }
            this.firePreEvent(new PreAlterTableEvent(oldt, newTable, this));
            this.alterHandler.alterTable(this.getMS(), this.wh, catName, dbname, name, newTable, envContext, this, validWriteIdList);
            success = true;
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, InvalidOperationException.class).convertIfInstance(NoSuchObjectException.class, InvalidOperationException.class).defaultMetaException();
        }
        finally {
            this.endFunction("alter_table", success, ex, name);
        }
    }

    public List<String> get_tables(String dbname, String pattern) throws MetaException {
        this.startFunction("get_tables", ": db=" + dbname + " pat=" + pattern);
        List<String> ret = null;
        Exception ex = null;
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbname, (Configuration)this.conf);
        try {
            if (this.isDatabaseRemote(dbname)) {
                Database db = this.get_database_core(parsedDbName[0], parsedDbName[1]);
                return DataConnectorProviderFactory.getDataConnectorProvider(db).getTableNames();
            }
        }
        catch (Exception e) {
            throw ExceptionHandler.newMetaException(e);
        }
        try {
            ret = this.getMS().getTables(parsedDbName[0], parsedDbName[1], pattern);
            if (ret != null && !ret.isEmpty()) {
                List<Object> tableInfo = new ArrayList();
                tableInfo = this.getMS().getTableObjectsByName(parsedDbName[0], parsedDbName[1], ret);
                tableInfo = FilterUtils.filterTablesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, tableInfo);
                ret = new ArrayList<String>();
                for (Table table : tableInfo) {
                    ret.add(table.getTableName());
                }
            }
            this.endFunction("get_tables", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_tables", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public List<String> get_tables_by_type(String dbname, String pattern, String tableType) throws MetaException {
        this.startFunction("get_tables_by_type", ": db=" + dbname + " pat=" + pattern + ",type=" + tableType);
        List ret = null;
        Exception ex = null;
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbname, (Configuration)this.conf);
        try {
            ret = this.getTablesByTypeCore(parsedDbName[0], parsedDbName[1], pattern, tableType);
            ret = FilterUtils.filterTableNamesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (String)parsedDbName[0], (String)parsedDbName[1], ret);
            this.endFunction("get_tables_by_type", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_tables_by_type", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    private List<String> getTablesByTypeCore(String catName, String dbname, String pattern, String tableType) throws MetaException {
        this.startFunction("getTablesByTypeCore", ": catName=" + catName + ": db=" + dbname + " pat=" + pattern + ",type=" + tableType);
        List<String> ret = null;
        Exception ex = null;
        Database db = null;
        try {
            db = this.get_database_core(catName, dbname);
            if (db != null && db.getType().equals((Object)DatabaseType.REMOTE)) {
                return DataConnectorProviderFactory.getDataConnectorProvider(db).getTableNames();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ret = this.getMS().getTables(catName, dbname, pattern, TableType.valueOf((String)tableType), -1);
            this.endFunction("getTablesByTypeCore", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("getTablesByTypeCore", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public List<Table> get_all_materialized_view_objects_for_rewriting() throws MetaException {
        this.startFunction("get_all_materialized_view_objects_for_rewriting");
        List<Table> ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getAllMaterializedViewObjectsForRewriting("hive");
            this.endFunction("get_all_materialized_view_objects_for_rewriting", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_all_materialized_view_objects_for_rewriting", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public List<String> get_materialized_views_for_rewriting(String dbname) throws MetaException {
        this.startFunction("get_materialized_views_for_rewriting", ": db=" + dbname);
        List<String> ret = null;
        Exception ex = null;
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbname, (Configuration)this.conf);
        try {
            ret = this.getMS().getMaterializedViewsForRewriting(parsedDbName[0], parsedDbName[1]);
            this.endFunction("get_materialized_views_for_rewriting", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_materialized_views_for_rewriting", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public List<String> get_all_tables(String dbname) throws MetaException {
        this.startFunction("get_all_tables", ": db=" + dbname);
        List ret = null;
        Exception ex = null;
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbname, (Configuration)this.conf);
        try {
            if (this.isDatabaseRemote(dbname)) {
                Database db = this.get_database_core(parsedDbName[0], parsedDbName[1]);
                return DataConnectorProviderFactory.getDataConnectorProvider(db).getTableNames();
            }
        }
        catch (Exception db) {
            // empty catch block
        }
        try {
            ret = this.getMS().getAllTables(parsedDbName[0], parsedDbName[1]);
            ret = FilterUtils.filterTableNamesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (String)parsedDbName[0], (String)parsedDbName[1], ret);
            this.endFunction("get_all_tables", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_all_tables", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    @Deprecated
    public List<FieldSchema> get_fields(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
        return this.get_fields_with_environment_context(db, tableName, null);
    }

    @Deprecated
    public List<FieldSchema> get_fields_with_environment_context(String db, String tableName, EnvironmentContext envContext) throws MetaException, UnknownTableException, UnknownDBException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db, (Configuration)this.conf);
        GetFieldsRequest req = new GetFieldsRequest(parsedDbName[1], tableName);
        req.setCatName(parsedDbName[0]);
        req.setEnvContext(envContext);
        return this.get_fields_req(req).getFields();
    }

    private List<FieldSchema> get_fields_with_environment_context_core(String db, String tableName, EnvironmentContext envContext) throws MetaException, UnknownTableException, UnknownDBException {
        this.startFunction("get_fields_with_environment_context_core", ": db=" + db + "tbl=" + tableName);
        String[] names = tableName.split("\\.");
        String base_table_name = names[0];
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db, (Configuration)this.conf);
        List ret = null;
        Exception ex = null;
        try {
            Table tbl;
            try {
                tbl = this.get_table_core(parsedDbName[0], parsedDbName[1], base_table_name);
                this.firePreEvent(new PreReadTableEvent(tbl, (IHMSHandler)this));
            }
            catch (NoSuchObjectException e) {
                throw new UnknownTableException(e.getMessage());
            }
            if (null == tbl.getSd().getSerdeInfo().getSerializationLib() || MetastoreConf.getStringCollection((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERDES_USING_METASTORE_FOR_SCHEMA).contains(tbl.getSd().getSerdeInfo().getSerializationLib())) {
                ret = tbl.getSd().getCols();
            } else {
                StorageSchemaReader schemaReader = this.getStorageSchemaReader();
                ret = schemaReader.readSchema(tbl, envContext, this.getConf());
            }
            this.endFunction("get_fields_with_environment_context_core", ret != null, ex, tableName);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(UnknownTableException.class, MetaException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("get_fields_with_environment_context_core", ret != null, ex, tableName);
                throw throwable;
            }
        }
        return ret;
    }

    public GetFieldsResponse get_fields_req(GetFieldsRequest req) throws MetaException, UnknownTableException, UnknownDBException {
        String dbName = MetaStoreUtils.prependCatalogToDbName((String)req.getCatName(), (String)req.getDbName(), (Configuration)this.conf);
        List<FieldSchema> fields = this.get_fields_with_environment_context_core(dbName, req.getTblName(), req.getEnvContext());
        GetFieldsResponse res = new GetFieldsResponse();
        res.setFields(fields);
        return res;
    }

    private StorageSchemaReader getStorageSchemaReader() throws MetaException {
        if (this.storageSchemaReader == null) {
            String className = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STORAGE_SCHEMA_READER_IMPL);
            Class readerClass = JavaUtils.getClass((String)className, StorageSchemaReader.class);
            try {
                this.storageSchemaReader = (StorageSchemaReader)readerClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error("Unable to instantiate class " + className, (Throwable)e);
                throw new MetaException(e.getMessage());
            }
        }
        return this.storageSchemaReader;
    }

    @Deprecated
    public List<FieldSchema> get_schema(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
        return this.get_schema_with_environment_context(db, tableName, null);
    }

    @Deprecated
    public List<FieldSchema> get_schema_with_environment_context(String db, String tableName, EnvironmentContext envContext) throws MetaException, UnknownTableException, UnknownDBException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db, (Configuration)this.conf);
        GetSchemaRequest req = new GetSchemaRequest(parsedDbName[1], tableName);
        req.setCatName(parsedDbName[0]);
        req.setEnvContext(envContext);
        return this.get_schema_req(req).getFields();
    }

    private List<FieldSchema> get_schema_with_environment_context_core(String db, String tableName, EnvironmentContext envContext) throws MetaException, UnknownTableException, UnknownDBException {
        this.startFunction("get_schema_with_environment_context_core", ": db=" + db + "tbl=" + tableName);
        boolean success = false;
        Exception ex = null;
        try {
            Table tbl;
            String[] names = tableName.split("\\.");
            String base_table_name = names[0];
            String[] parsedDbName = MetaStoreUtils.parseDbName((String)db, (Configuration)this.conf);
            try {
                tbl = this.get_table_core(parsedDbName[0], parsedDbName[1], base_table_name);
            }
            catch (NoSuchObjectException e) {
                throw new UnknownTableException(e.getMessage());
            }
            List<FieldSchema> fieldSchemas = this.get_fields_with_environment_context_core(db, base_table_name, envContext);
            if (tbl == null || fieldSchemas == null) {
                throw new UnknownTableException(tableName + " doesn't exist");
            }
            if (tbl.getPartitionKeys() != null) {
                fieldSchemas.addAll(tbl.getPartitionKeys());
            }
            success = true;
            List<FieldSchema> list = fieldSchemas;
            return list;
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(UnknownDBException.class, UnknownTableException.class, MetaException.class).defaultMetaException();
        }
        finally {
            this.endFunction("get_schema_with_environment_context_core", success, ex, tableName);
        }
    }

    public GetSchemaResponse get_schema_req(GetSchemaRequest req) throws MetaException, UnknownTableException, UnknownDBException {
        String dbName = MetaStoreUtils.prependCatalogToDbName((String)req.getCatName(), (String)req.getDbName(), (Configuration)this.conf);
        List<FieldSchema> fields = this.get_schema_with_environment_context_core(dbName, req.getTblName(), req.getEnvContext());
        GetSchemaResponse res = new GetSchemaResponse();
        res.setFields(fields);
        return res;
    }

    public String getCpuProfile(int profileDurationInSec) throws TException {
        return NO_FILTER_STRING;
    }

    public String get_config_value(String name, String defaultValue) throws TException {
        this.startFunction("get_config_value", ": name=" + name + " defaultValue=" + defaultValue);
        boolean success = false;
        Exception ex = null;
        try {
            if (name == null) {
                success = true;
                String string = defaultValue;
                return string;
            }
            if (!Pattern.matches("(hive|hdfs|mapred|metastore).*", name)) {
                throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
            }
            String toReturn = defaultValue;
            try {
                toReturn = MetastoreConf.get((Configuration)this.conf, (String)name);
                if (toReturn == null) {
                    toReturn = defaultValue;
                }
            }
            catch (RuntimeException e) {
                LOG.error("RuntimeException thrown in get_config_value - msg: " + e.getMessage() + " cause: " + e.getCause());
            }
            success = true;
            String string = toReturn;
            return string;
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).throwIfInstance(TException.class).defaultMetaException();
        }
        finally {
            this.endFunction("get_config_value", success, ex);
        }
    }

    public static List<String> getPartValsFromName(Table t, String partName) throws MetaException, InvalidObjectException {
        Preconditions.checkArgument((t != null ? 1 : 0) != 0, (Object)"Table can not be null");
        LinkedHashMap hm = Warehouse.makeSpecFromName((String)partName);
        ArrayList<String> partVals = new ArrayList<String>();
        for (FieldSchema field : t.getPartitionKeys()) {
            String key = field.getName();
            String val = (String)hm.get(key);
            if (val == null) {
                throw new InvalidObjectException("incomplete partition name - missing " + key);
            }
            partVals.add(val);
        }
        return partVals;
    }

    private List<String> getPartValsFromName(RawStore ms, String catName, String dbName, String tblName, String partName) throws MetaException, InvalidObjectException {
        Table t = ms.getTable(catName, dbName, tblName, null);
        if (t == null) {
            throw new InvalidObjectException(dbName + "." + tblName + " table not found");
        }
        return HMSHandler.getPartValsFromName(t, partName);
    }

    private Partition get_partition_by_name_core(RawStore ms, String catName, String db_name, String tbl_name, String part_name) throws TException {
        List<String> partVals;
        this.fireReadTablePreEvent(catName, db_name, tbl_name);
        try {
            partVals = this.getPartValsFromName(ms, catName, db_name, tbl_name, part_name);
        }
        catch (InvalidObjectException e) {
            throw new NoSuchObjectException(e.getMessage());
        }
        Partition p = ms.getPartition(catName, db_name, tbl_name, partVals);
        p = FilterUtils.filterPartitionIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (Partition)p);
        if (p == null) {
            throw new NoSuchObjectException(TableName.getQualified((String)catName, (String)db_name, (String)tbl_name) + " partition (" + part_name + ") not found");
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Partition get_partition_by_name(String db_name, String tbl_name, String part_name) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.startFunction("get_partition_by_name", ": tbl=" + TableName.getQualified((String)parsedDbName[0], (String)parsedDbName[1], (String)tbl_name) + " part=" + part_name);
        Partition ret = null;
        Exception ex = null;
        try {
            ret = this.get_partition_by_name_core(this.getMS(), parsedDbName[0], parsedDbName[1], tbl_name, part_name);
            ret = FilterUtils.filterPartitionIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (Partition)ret);
            this.endFunction("get_partition_by_name", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_partition_by_name", ret != null, ex, tbl_name);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partition_by_name", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    @Deprecated
    public Partition append_partition_by_name(String db_name, String tbl_name, String part_name) throws TException {
        return this.append_partition_by_name_with_environment_context(db_name, tbl_name, part_name, null);
    }

    @Deprecated
    public Partition append_partition_by_name_with_environment_context(String db_name, String tbl_name, String part_name, EnvironmentContext env_context) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        Partition ret = null;
        Exception ex = null;
        try {
            AppendPartitionsRequest appendPartitionRequest = new AppendPartitionsRequest();
            appendPartitionRequest.setDbName(parsedDbName[1]);
            appendPartitionRequest.setTableName(tbl_name);
            appendPartitionRequest.setName(part_name);
            appendPartitionRequest.setCatalogName(parsedDbName[0]);
            appendPartitionRequest.setEnvironmentContext(env_context);
            ret = this.append_partition_req(appendPartitionRequest);
            this.endFunction("append_partition_by_name", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(InvalidObjectException.class, AlreadyExistsException.class, MetaException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("append_partition_by_name", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    private boolean drop_partition_by_name_core(RawStore ms, String catName, String db_name, String tbl_name, String part_name, boolean deleteData, EnvironmentContext envContext) throws TException, IOException {
        List<String> partVals;
        try {
            partVals = this.getPartValsFromName(ms, catName, db_name, tbl_name, part_name);
        }
        catch (InvalidObjectException e) {
            throw new NoSuchObjectException(e.getMessage());
        }
        return this.drop_partition_common(ms, catName, db_name, tbl_name, partVals, deleteData, envContext);
    }

    @Deprecated
    public boolean drop_partition_by_name(String db_name, String tbl_name, String part_name, boolean deleteData) throws TException {
        return this.drop_partition_by_name_with_environment_context(db_name, tbl_name, part_name, deleteData, null);
    }

    @Deprecated
    public boolean drop_partition_by_name_with_environment_context(String db_name, String tbl_name, String part_name, boolean deleteData, EnvironmentContext envContext) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        DropPartitionRequest dropPartitionReq = new DropPartitionRequest(parsedDbName[1], tbl_name);
        dropPartitionReq.setCatName(parsedDbName[0]);
        dropPartitionReq.setPartName(part_name);
        dropPartitionReq.setDeleteData(deleteData);
        dropPartitionReq.setEnvironmentContext(envContext);
        return this.drop_partition_req(dropPartitionReq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<Partition> get_partitions_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.startPartitionFunction("get_partitions_ps", parsedDbName[0], parsedDbName[1], tbl_name, (int)max_parts, part_vals);
        List ret = null;
        Exception ex = null;
        try {
            this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
            ret = this.get_partitions_ps_with_auth(db_name, tbl_name, new GetPartitionsArgs.GetPartitionsArgsBuilder().part_vals(part_vals).max(max_parts).build());
            ret = FilterUtils.filterPartitionsIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, ret);
            this.endFunction("get_partitions_ps", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_partitions_ps", ret != null, ex, tbl_name);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_ps", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    @Deprecated
    public List<Partition> get_partitions_ps_with_auth(String db_name, String tbl_name, List<String> part_vals, short max_parts, String userName, List<String> groupNames) throws TException {
        return this.get_partitions_ps_with_auth(db_name, tbl_name, new GetPartitionsArgs.GetPartitionsArgsBuilder().part_vals(part_vals).max(max_parts).userName(userName).groupNames(groupNames).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Partition> get_partitions_ps_with_auth(String db_name, String tbl_name, GetPartitionsArgs args) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.startPartitionFunction("get_partitions_ps_with_auth", parsedDbName[0], parsedDbName[1], tbl_name, args.getPart_vals());
        this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
        List ret = null;
        Exception ex = null;
        try {
            if (args.getPart_vals() != null) {
                this.checkLimitNumberOfPartitionsByPs(parsedDbName[0], parsedDbName[1], tbl_name, args.getPart_vals(), args.getMax());
            } else {
                this.checkLimitNumberOfPartitionsByFilter(parsedDbName[0], parsedDbName[1], tbl_name, NO_FILTER_STRING, args.getMax());
            }
            this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
            ret = this.getMS().listPartitionsPsWithAuth(parsedDbName[0], parsedDbName[1], tbl_name, args);
            ret = FilterUtils.filterPartitionsIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, ret);
            this.endFunction("get_partitions_ps_with_auth", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.handleException(e).convertIfInstance(InvalidObjectException.class, MetaException.class);
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_partitions_ps_with_auth", ret != null, ex, tbl_name);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_ps_with_auth", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    public GetPartitionsPsWithAuthResponse get_partitions_ps_with_auth_req(GetPartitionsPsWithAuthRequest req) throws MetaException, NoSuchObjectException, TException {
        String dbName = MetaStoreUtils.prependCatalogToDbName((String)req.getCatName(), (String)req.getDbName(), (Configuration)this.conf);
        List<Partition> partitions = this.get_partitions_ps_with_auth(dbName, req.getTblName(), new GetPartitionsArgs.GetPartitionsArgsBuilder().part_vals(req.getPartVals()).max(req.getMaxParts()).userName(req.getUserName()).groupNames(req.getGroupNames()).skipColumnSchemaForPartition(req.isSkipColumnSchemaForPartition()).includeParamKeyPattern(req.getIncludeParamKeyPattern()).excludeParamKeyPattern(req.getExcludeParamKeyPattern()).partNames(req.getPartNames()).build());
        GetPartitionsPsWithAuthResponse res = new GetPartitionsPsWithAuthResponse();
        res.setPartitions(partitions);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<String> get_partition_names_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.startPartitionFunction("get_partitions_names_ps", parsedDbName[0], parsedDbName[1], tbl_name, (int)max_parts, part_vals);
        List ret = null;
        Exception ex = null;
        try {
            GetPartitionNamesPsRequest getPartitionNamesPsRequest = new GetPartitionNamesPsRequest(parsedDbName[1], tbl_name);
            getPartitionNamesPsRequest.setCatName(parsedDbName[0]);
            getPartitionNamesPsRequest.setPartValues(part_vals);
            getPartitionNamesPsRequest.setMaxParts(max_parts);
            ret = this.get_partition_names_ps_req(getPartitionNamesPsRequest).getNames();
            this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> get_partition_names_ps_core(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.startPartitionFunction("get_partitions_names_ps", parsedDbName[0], parsedDbName[1], tbl_name, part_vals);
        this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
        List ret = null;
        Exception ex = null;
        try {
            this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
            ret = this.getMS().listPartitionNamesPs(parsedDbName[0], parsedDbName[1], tbl_name, part_vals, max_parts);
            ret = FilterUtils.filterPartitionNamesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (String)parsedDbName[0], (String)parsedDbName[1], (String)tbl_name, ret);
            this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    public GetPartitionNamesPsResponse get_partition_names_ps_req(GetPartitionNamesPsRequest req) throws MetaException, NoSuchObjectException, TException {
        String dbName = MetaStoreUtils.prependCatalogToDbName((String)req.getCatName(), (String)req.getDbName(), (Configuration)this.conf);
        List<String> names = this.get_partition_names_ps_core(dbName, req.getTblName(), req.getPartValues(), req.getMaxParts());
        GetPartitionNamesPsResponse res = new GetPartitionNamesPsResponse();
        res.setNames(names);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> get_partition_names_req(PartitionsByExprRequest req) throws MetaException, NoSuchObjectException, TException {
        String catName = req.isSetCatName() ? req.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        String dbName = req.getDbName();
        String tblName = req.getTblName();
        this.startTableFunction("get_partition_names_req", catName, dbName, tblName);
        this.fireReadTablePreEvent(catName, dbName, tblName);
        List ret = null;
        Exception ex = null;
        try {
            this.authorizeTableForPartitionMetadata(catName, dbName, tblName);
            ret = this.getMS().listPartitionNames(catName, dbName, tblName, req.getDefaultPartitionName(), req.getExpr(), req.getOrder(), req.getMaxParts());
            ret = FilterUtils.filterPartitionNamesIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (String)catName, (String)dbName, (String)tblName, ret);
            this.endFunction("get_partition_names_req", ret != null, ex, tblName);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_partition_names_req", ret != null, ex, tblName);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partition_names_req", ret != null, ex, tblName);
                throw throwable;
            }
        }
        return ret;
    }

    public List<String> partition_name_to_vals(String part_name) throws TException {
        if (part_name.length() == 0) {
            return Collections.emptyList();
        }
        LinkedHashMap map = Warehouse.makeSpecFromName((String)part_name);
        return new ArrayList<String>(map.values());
    }

    public Map<String, String> partition_name_to_spec(String part_name) throws TException {
        if (part_name.length() == 0) {
            return new HashMap<String, String>();
        }
        return Warehouse.makeSpecFromName((String)part_name);
    }

    public static String lowerCaseConvertPartName(String partName) throws MetaException {
        if (partName == null) {
            return partName;
        }
        boolean isFirst = true;
        Map partSpec = Warehouse.makeEscSpecFromName((String)partName);
        String convertedPartName = new String();
        for (Map.Entry entry : partSpec.entrySet()) {
            String partColName = (String)entry.getKey();
            String partColVal = (String)entry.getValue();
            if (!isFirst) {
                convertedPartName = convertedPartName + "/";
            } else {
                isFirst = false;
            }
            convertedPartName = convertedPartName + partColName.toLowerCase() + "=" + partColVal;
        }
        return convertedPartName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ColumnStatistics get_table_column_statistics(String dbName, String tableName, String colName) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        parsedDbName[0] = parsedDbName[0].toLowerCase();
        parsedDbName[1] = parsedDbName[1].toLowerCase();
        tableName = tableName.toLowerCase();
        colName = colName.toLowerCase();
        this.startFunction("get_column_statistics_by_table", ": table=" + TableName.getQualified((String)parsedDbName[0], (String)parsedDbName[1], (String)tableName) + " column=" + colName);
        ColumnStatistics statsObj = null;
        try {
            statsObj = this.getMS().getTableColumnStatistics(parsedDbName[0], parsedDbName[1], tableName, Lists.newArrayList((Object[])new String[]{colName}), "hive", null);
            if (statsObj != null) assert (statsObj.getStatsObjSize() <= 1);
            ColumnStatistics columnStatistics = statsObj;
            this.endFunction("get_column_statistics_by_table", statsObj != null, null, tableName);
            return columnStatistics;
        }
        catch (Throwable throwable) {
            this.endFunction("get_column_statistics_by_table", statsObj != null, null, tableName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableStatsResult get_table_statistics_req(TableStatsRequest request) throws TException {
        String catName = request.isSetCatName() ? request.getCatName().toLowerCase() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        String dbName = request.getDbName().toLowerCase();
        String tblName = request.getTblName().toLowerCase();
        this.startFunction("get_table_statistics_req", ": table=" + TableName.getQualified((String)catName, (String)dbName, (String)tblName));
        TableStatsResult result = null;
        ArrayList<String> lowerCaseColNames = new ArrayList<String>(request.getColNames().size());
        for (String colName : request.getColNames()) {
            lowerCaseColNames.add(colName.toLowerCase());
        }
        try {
            ColumnStatistics cs = this.getMS().getTableColumnStatistics(catName, dbName, tblName, lowerCaseColNames, request.getEngine(), request.getValidWriteIdList());
            result = new TableStatsResult(cs == null || cs.getStatsObj() == null || cs.isSetIsStatsCompliant() && !cs.isIsStatsCompliant() ? Lists.newArrayList() : cs.getStatsObj());
            this.endFunction("get_table_statistics_req", result == null, null, tblName);
        }
        catch (Throwable throwable) {
            this.endFunction("get_table_statistics_req", result == null, null, tblName);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ColumnStatistics get_partition_column_statistics(String dbName, String tableName, String partName, String colName) throws TException {
        List<ColumnStatistics> list;
        ColumnStatistics statsObj;
        block4: {
            dbName = dbName.toLowerCase();
            String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
            tableName = tableName.toLowerCase();
            colName = colName.toLowerCase();
            String convertedPartName = HMSHandler.lowerCaseConvertPartName(partName);
            this.startFunction("get_column_statistics_by_partition", ": table=" + TableName.getQualified((String)parsedDbName[0], (String)parsedDbName[1], (String)tableName) + " partition=" + convertedPartName + " column=" + colName);
            statsObj = null;
            try {
                list = this.getMS().getPartitionColumnStatistics(parsedDbName[0], parsedDbName[1], tableName, Lists.newArrayList((Object[])new String[]{convertedPartName}), Lists.newArrayList((Object[])new String[]{colName}), "hive");
                if (!list.isEmpty()) break block4;
                ColumnStatistics columnStatistics = null;
                this.endFunction("get_column_statistics_by_partition", statsObj != null, null, tableName);
                return columnStatistics;
            }
            catch (Throwable throwable) {
                this.endFunction("get_column_statistics_by_partition", statsObj != null, null, tableName);
                throw throwable;
            }
        }
        if (list.size() != 1) {
            throw new MetaException(list.size() + " statistics for single column and partition");
        }
        statsObj = list.get(0);
        this.endFunction("get_column_statistics_by_partition", statsObj != null, null, tableName);
        return statsObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionsStatsResult get_partitions_statistics_req(PartitionsStatsRequest request) throws TException {
        String catName = request.isSetCatName() ? request.getCatName().toLowerCase() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        String dbName = request.getDbName().toLowerCase();
        String tblName = request.getTblName().toLowerCase();
        this.startPartitionFunction("get_partitions_statistics_req", catName, dbName, tblName, request.getPartNames());
        PartitionsStatsResult result = null;
        ArrayList<String> lowerCaseColNames = new ArrayList<String>(request.getColNames().size());
        for (Object colName : request.getColNames()) {
            lowerCaseColNames.add(((String)colName).toLowerCase());
        }
        ArrayList<String> lowerCasePartNames = new ArrayList<String>(request.getPartNames().size());
        for (String partName : request.getPartNames()) {
            lowerCasePartNames.add(HMSHandler.lowerCaseConvertPartName(partName));
        }
        try {
            List<ColumnStatistics> stats = this.getMS().getPartitionColumnStatistics(catName, dbName, tblName, lowerCasePartNames, lowerCaseColNames, request.getEngine(), request.isSetValidWriteIdList() ? request.getValidWriteIdList() : null);
            HashMap<String, List> map = new HashMap<String, List>();
            if (stats != null) {
                for (ColumnStatistics stat : stats) {
                    if (stat.isSetIsStatsCompliant() && !stat.isIsStatsCompliant()) continue;
                    map.put(stat.getStatsDesc().getPartName(), stat.getStatsObj());
                }
            }
            this.endFunction("get_partitions_statistics_req", (result = new PartitionsStatsResult(map)) == null, null, tblName);
        }
        catch (Throwable throwable) {
            this.endFunction("get_partitions_statistics_req", result == null, null, tblName);
            throw throwable;
        }
        return result;
    }

    public boolean update_table_column_statistics(ColumnStatistics colStats) throws TException {
        return this.updateTableColumnStatsInternal(colStats, null, -1L);
    }

    public SetPartitionsStatsResponse update_table_column_statistics_req(SetPartitionsStatsRequest req) throws NoSuchObjectException, InvalidObjectException, MetaException, InvalidInputException, TException {
        if (req.getColStatsSize() != 1) {
            throw new InvalidInputException("Only one stats object expected");
        }
        if (req.isNeedMerge()) {
            throw new InvalidInputException("Merge is not supported for non-aggregate stats");
        }
        ColumnStatistics colStats = (ColumnStatistics)req.getColStatsIterator().next();
        boolean ret = this.updateTableColumnStatsInternal(colStats, req.getValidWriteIdList(), req.getWriteId());
        return new SetPartitionsStatsResponse(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateTableColumnStatsInternal(ColumnStatistics colStats, String validWriteIds, long writeId) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        this.normalizeColStatsInput(colStats);
        this.startFunction("write_column_statistics", ":  table=" + TableName.getQualified((String)colStats.getStatsDesc().getCatName(), (String)colStats.getStatsDesc().getDbName(), (String)colStats.getStatsDesc().getTableName()));
        Map<String, String> parameters = null;
        this.getMS().openTransaction();
        boolean committed = false;
        try {
            parameters = this.getMS().updateTableColumnStatistics(colStats, validWriteIds, writeId);
            if (parameters != null) {
                Table tableObj = this.getMS().getTable(colStats.getStatsDesc().getCatName(), colStats.getStatsDesc().getDbName(), colStats.getStatsDesc().getTableName(), validWriteIds);
                if (this.transactionalListeners != null && !this.transactionalListeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.UPDATE_TABLE_COLUMN_STAT, new UpdateTableColumnStatEvent(colStats, tableObj, parameters, writeId, this));
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.UPDATE_TABLE_COLUMN_STAT, new UpdateTableColumnStatEvent(colStats, tableObj, parameters, writeId, this));
                }
            }
            if (!(committed = this.getMS().commitTransaction())) {
                this.getMS().rollbackTransaction();
            }
            this.endFunction("write_column_statistics", parameters != null, null, colStats.getStatsDesc().getTableName());
        }
        catch (Throwable throwable) {
            if (!committed) {
                this.getMS().rollbackTransaction();
            }
            this.endFunction("write_column_statistics", parameters != null, null, colStats.getStatsDesc().getTableName());
            throw throwable;
        }
        return parameters != null;
    }

    private void normalizeColStatsInput(ColumnStatistics colStats) throws MetaException {
        ColumnStatisticsDesc statsDesc;
        statsDesc.setCatName((statsDesc = colStats.getStatsDesc()).isSetCatName() ? statsDesc.getCatName().toLowerCase() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        statsDesc.setDbName(statsDesc.getDbName().toLowerCase());
        statsDesc.setTableName(statsDesc.getTableName().toLowerCase());
        statsDesc.setPartName(HMSHandler.lowerCaseConvertPartName(statsDesc.getPartName()));
        long time = System.currentTimeMillis() / 1000L;
        statsDesc.setLastAnalyzed(time);
        for (ColumnStatisticsObj statsObj : colStats.getStatsObj()) {
            statsObj.setColName(statsObj.getColName().toLowerCase());
            statsObj.setColType(statsObj.getColType().toLowerCase());
        }
        colStats.setStatsDesc(statsDesc);
        colStats.setStatsObj(colStats.getStatsObj());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updatePartitonColStatsInternal(Table tbl, MTable mTable, ColumnStatistics colStats, String validWriteIds, long writeId) throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        Map<String, String> parameters;
        this.normalizeColStatsInput(colStats);
        ColumnStatisticsDesc csd = colStats.getStatsDesc();
        String catName = csd.getCatName();
        String dbName = csd.getDbName();
        String tableName = csd.getTableName();
        this.startFunction("write_partition_column_statistics", ":  db=" + dbName + " table=" + tableName + " part=" + csd.getPartName());
        boolean ret = false;
        boolean committed = false;
        this.getMS().openTransaction();
        try {
            tbl = Optional.ofNullable(tbl).orElse(this.getTable(catName, dbName, tableName));
            mTable = Optional.ofNullable(mTable).orElse(this.getMS().ensureGetMTable(catName, dbName, tableName));
            List<String> partVals = HMSHandler.getPartValsFromName(tbl, csd.getPartName());
            parameters = this.getMS().updatePartitionColumnStatistics(tbl, mTable, colStats, partVals, validWriteIds, writeId);
            if (parameters != null) {
                if (this.transactionalListeners != null && !this.transactionalListeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.UPDATE_PARTITION_COLUMN_STAT, new UpdatePartitionColumnStatEvent(colStats, partVals, parameters, tbl, writeId, this));
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.UPDATE_PARTITION_COLUMN_STAT, new UpdatePartitionColumnStatEvent(colStats, partVals, parameters, tbl, writeId, this));
                }
            }
            if (!(committed = this.getMS().commitTransaction())) {
                this.getMS().rollbackTransaction();
            }
            this.endFunction("write_partition_column_statistics", ret, null, tableName);
        }
        catch (Throwable throwable) {
            if (!committed) {
                this.getMS().rollbackTransaction();
            }
            this.endFunction("write_partition_column_statistics", ret, null, tableName);
            throw throwable;
        }
        return parameters != null;
    }

    private void updatePartitionColStatsForOneBatch(Table tbl, Map<String, ColumnStatistics> statsMap, String validWriteIds, long writeId) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        Map<String, Map<String, String>> result = this.getMS().updatePartitionColumnStatisticsInBatch(statsMap, tbl, this.transactionalListeners, validWriteIds, writeId);
        if (result != null && result.size() != 0 && this.listeners != null) {
            for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
                Map<String, String> parameters = entry.getValue();
                ColumnStatistics colStats = statsMap.get(entry.getKey());
                List<String> partVals = HMSHandler.getPartValsFromName(tbl, colStats.getStatsDesc().getPartName());
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.UPDATE_PARTITION_COLUMN_STAT, new UpdatePartitionColumnStatEvent(colStats, partVals, parameters, tbl, writeId, this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updatePartitionColStatsInBatch(Table tbl, Map<String, ColumnStatistics> statsMap, String validWriteIds, long writeId) throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        if (statsMap.size() == 0) {
            return false;
        }
        String catalogName = tbl.getCatName();
        String dbName = tbl.getDbName();
        String tableName = tbl.getTableName();
        this.startFunction("updatePartitionColStatsInBatch", ":  db=" + dbName + " table=" + tableName);
        long start = System.currentTimeMillis();
        HashMap<String, ColumnStatistics> newStatsMap = new HashMap<String, ColumnStatistics>();
        long numStats = 0L;
        long numStatsMax = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.JDBC_MAX_BATCH_SIZE);
        try {
            for (Map.Entry<String, ColumnStatistics> entry : statsMap.entrySet()) {
                ColumnStatistics colStats = entry.getValue();
                this.normalizeColStatsInput(colStats);
                assert (catalogName.equalsIgnoreCase(colStats.getStatsDesc().getCatName()));
                assert (dbName.equalsIgnoreCase(colStats.getStatsDesc().getDbName()));
                assert (tableName.equalsIgnoreCase(colStats.getStatsDesc().getTableName()));
                newStatsMap.put(entry.getKey(), colStats);
                numStats += (long)colStats.getStatsObjSize();
                if ((long)newStatsMap.size() < numStatsMax) continue;
                this.updatePartitionColStatsForOneBatch(tbl, newStatsMap, validWriteIds, writeId);
                newStatsMap.clear();
                numStats = 0L;
            }
            if (numStats != 0L) {
                this.updatePartitionColStatsForOneBatch(tbl, newStatsMap, validWriteIds, writeId);
            }
        }
        finally {
            this.endFunction("updatePartitionColStatsInBatch", true, null, tableName);
            long end = System.currentTimeMillis();
            float sec = (float)(end - start) / 1000.0f;
            LOG.info("updatePartitionColStatsInBatch took " + sec + " seconds for " + statsMap.size() + " stats");
        }
        return true;
    }

    public boolean update_partition_column_statistics(ColumnStatistics colStats) throws TException {
        return this.updatePartitonColStatsInternal(null, null, colStats, null, -1L);
    }

    public SetPartitionsStatsResponse update_partition_column_statistics_req(SetPartitionsStatsRequest req) throws NoSuchObjectException, InvalidObjectException, MetaException, InvalidInputException, TException {
        if (req.getColStatsSize() != 1) {
            throw new InvalidInputException("Only one stats object expected");
        }
        if (req.isNeedMerge()) {
            throw new InvalidInputException("Merge is not supported for non-aggregate stats");
        }
        ColumnStatistics colStats = (ColumnStatistics)req.getColStatsIterator().next();
        boolean ret = this.updatePartitonColStatsInternal(null, null, colStats, req.getValidWriteIdList(), req.getWriteId());
        return new SetPartitionsStatsResponse(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete_partition_column_statistics(String dbName, String tableName, String partName, String colName, String engine) throws TException {
        dbName = dbName.toLowerCase();
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        tableName = tableName.toLowerCase();
        if (colName != null) {
            colName = colName.toLowerCase();
        }
        String convertedPartName = HMSHandler.lowerCaseConvertPartName(partName);
        this.startFunction("delete_column_statistics_by_partition", ": table=" + TableName.getQualified((String)parsedDbName[0], (String)parsedDbName[1], (String)tableName) + " partition=" + convertedPartName + " column=" + colName);
        boolean ret = false;
        boolean committed = false;
        this.getMS().openTransaction();
        try {
            List<String> partVals = this.getPartValsFromName(this.getMS(), parsedDbName[0], parsedDbName[1], tableName, convertedPartName);
            Table table = this.getMS().getTable(parsedDbName[0], parsedDbName[1], tableName);
            if (TxnUtils.isTransactionalTable(table)) {
                throw new MetaException("Cannot delete stats via this API for a transactional table");
            }
            ret = this.getMS().deletePartitionColumnStatistics(parsedDbName[0], parsedDbName[1], tableName, convertedPartName, partVals, colName, engine);
            if (ret) {
                if (this.transactionalListeners != null && !this.transactionalListeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DELETE_PARTITION_COLUMN_STAT, new DeletePartitionColumnStatEvent(parsedDbName[0], parsedDbName[1], tableName, convertedPartName, partVals, colName, engine, this));
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DELETE_PARTITION_COLUMN_STAT, new DeletePartitionColumnStatEvent(parsedDbName[0], parsedDbName[1], tableName, convertedPartName, partVals, colName, engine, this));
                }
            }
            if (!(committed = this.getMS().commitTransaction())) {
                this.getMS().rollbackTransaction();
            }
            this.endFunction("delete_column_statistics_by_partition", ret, null, tableName);
        }
        catch (Throwable throwable) {
            if (!committed) {
                this.getMS().rollbackTransaction();
            }
            this.endFunction("delete_column_statistics_by_partition", ret, null, tableName);
            throw throwable;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete_table_column_statistics(String dbName, String tableName, String colName, String engine) throws TException {
        dbName = dbName.toLowerCase();
        tableName = tableName.toLowerCase();
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        if (colName != null) {
            colName = colName.toLowerCase();
        }
        this.startFunction("delete_column_statistics_by_table", ": table=" + TableName.getQualified((String)parsedDbName[0], (String)parsedDbName[1], (String)tableName) + " column=" + colName);
        boolean ret = false;
        boolean committed = false;
        this.getMS().openTransaction();
        try {
            Table table = this.getMS().getTable(parsedDbName[0], parsedDbName[1], tableName);
            if (TxnUtils.isTransactionalTable(table)) {
                throw new MetaException("Cannot delete stats via this API for a transactional table");
            }
            ret = this.getMS().deleteTableColumnStatistics(parsedDbName[0], parsedDbName[1], tableName, colName, engine);
            if (ret) {
                if (this.transactionalListeners != null && !this.transactionalListeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DELETE_TABLE_COLUMN_STAT, new DeleteTableColumnStatEvent(parsedDbName[0], parsedDbName[1], tableName, colName, engine, this));
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DELETE_TABLE_COLUMN_STAT, new DeleteTableColumnStatEvent(parsedDbName[0], parsedDbName[1], tableName, colName, engine, this));
                }
            }
            if (!(committed = this.getMS().commitTransaction())) {
                this.getMS().rollbackTransaction();
            }
            this.endFunction("delete_column_statistics_by_table", ret, null, tableName);
        }
        catch (Throwable throwable) {
            if (!committed) {
                this.getMS().rollbackTransaction();
            }
            this.endFunction("delete_column_statistics_by_table", ret, null, tableName);
            throw throwable;
        }
        return ret;
    }

    public void update_transaction_statistics(UpdateTransactionalStatsRequest req) throws TException {
        this.getTxnHandler().updateTransactionStatistics(req);
    }

    @Deprecated
    public List<Partition> get_partitions_by_filter(String dbName, String tblName, String filter, short maxParts) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        return this.get_partitions_by_filter_internal(parsedDbName[0], parsedDbName[1], tblName, new GetPartitionsArgs.GetPartitionsArgsBuilder().filter(filter).max(maxParts).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Partition> get_partitions_by_filter_internal(String catName, String dbName, String tblName, GetPartitionsArgs args) throws TException {
        this.startTableFunction("get_partitions_by_filter", catName, dbName, tblName);
        this.fireReadTablePreEvent(catName, dbName, tblName);
        List<Partition> ret = null;
        Exception ex = null;
        RawStore rs = this.getMS();
        try {
            this.authorizeTableForPartitionMetadata(catName, dbName, tblName);
            if (this.exceedsPartitionFetchLimit(args.getMax())) {
                int max = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST) + 1;
                args = new GetPartitionsArgs.GetPartitionsArgsBuilder(args).max(max).build();
                List<String> partNames = rs.listPartitionNamesByFilter(catName, dbName, tblName, args);
                this.checkLimitNumberOfPartitions(tblName, partNames.size());
                ret = rs.getPartitionsByNames(catName, dbName, tblName, new GetPartitionsArgs.GetPartitionsArgsBuilder(args).partNames(partNames).build());
            } else {
                ret = rs.getPartitionsByFilter(catName, dbName, tblName, args);
            }
            ret = FilterUtils.filterPartitionsIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, ret);
            this.endFunction("get_partitions_by_filter", ret != null, ex, tblName);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_partitions_by_filter", ret != null, ex, tblName);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_by_filter", ret != null, ex, tblName);
                throw throwable;
            }
        }
        return ret;
    }

    public List<Partition> get_partitions_by_filter_req(GetPartitionsByFilterRequest req) throws TException {
        return this.get_partitions_by_filter_internal(req.getCatName(), req.getDbName(), req.getTblName(), new GetPartitionsArgs.GetPartitionsArgsBuilder().filter(req.getFilter()).max(req.getMaxParts()).skipColumnSchemaForPartition(req.isSkipColumnSchemaForPartition()).excludeParamKeyPattern(req.getExcludeParamKeyPattern()).includeParamKeyPattern(req.getIncludeParamKeyPattern()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<PartitionSpec> get_part_specs_by_filter(String dbName, String tblName, String filter, int maxParts) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        this.startPartitionFunction("get_partitions_by_filter_pspec", parsedDbName[0], parsedDbName[1], tblName, maxParts, filter);
        List<PartitionSpec> partitionSpecs = null;
        try {
            Table table = this.get_table_core(parsedDbName[0], parsedDbName[1], tblName);
            List<Partition> partitions = this.get_partitions_by_filter(dbName, tblName, filter, (short)maxParts);
            if (HMSHandler.is_partition_spec_grouping_enabled(table)) {
                partitionSpecs = MetaStoreServerUtils.getPartitionspecsGroupedByStorageDescriptor(table, partitions);
            } else {
                PartitionSpec pSpec = new PartitionSpec();
                pSpec.setPartitionList(new PartitionListComposingSpec(partitions));
                pSpec.setRootPath(table.getSd().getLocation());
                pSpec.setCatName(parsedDbName[0]);
                pSpec.setDbName(parsedDbName[1]);
                pSpec.setTableName(tblName);
                partitionSpecs = Arrays.asList(pSpec);
            }
            List<PartitionSpec> list = partitionSpecs;
            this.endFunction("get_partitions_by_filter_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tblName);
            return list;
        }
        catch (Throwable throwable) {
            this.endFunction("get_partitions_by_filter_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tblName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionsSpecByExprResult get_partitions_spec_by_expr(PartitionsByExprRequest req) throws TException {
        String dbName = req.getDbName();
        String tblName = req.getTblName();
        String catName = req.isSetCatName() ? req.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        this.startTableFunction("get_partitions_spec_by_expr", catName, dbName, tblName);
        this.fireReadTablePreEvent(catName, dbName, tblName);
        PartitionsSpecByExprResult ret = null;
        Exception ex = null;
        try {
            PartitionsByExprResult result = this.get_partitions_by_expr_internal(catName, dbName, tblName, new GetPartitionsArgs.GetPartitionsArgsBuilder().expr(req.getExpr()).max(req.getMaxParts()).defaultPartName(req.getDefaultPartitionName()).skipColumnSchemaForPartition(req.isSkipColumnSchemaForPartition()).includeParamKeyPattern(req.getIncludeParamKeyPattern()).excludeParamKeyPattern(req.getExcludeParamKeyPattern()).build());
            Table table = this.get_table_core(catName, dbName, tblName);
            List<PartitionSpec> partitionSpecs = MetaStoreServerUtils.getPartitionspecsGroupedByStorageDescriptor(table, result.getPartitions());
            ret = new PartitionsSpecByExprResult(partitionSpecs, result.isHasUnknownPartitions());
            this.endFunction("get_partitions_spec_by_expr", ret != null, ex, tblName);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_partitions_spec_by_expr", ret != null, ex, tblName);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_spec_by_expr", ret != null, ex, tblName);
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionsByExprResult get_partitions_by_expr(PartitionsByExprRequest req) throws TException {
        String dbName = req.getDbName();
        String tblName = req.getTblName();
        String catName = req.isSetCatName() ? req.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        String expr = req.isSetExpr() ? Arrays.toString(req.getExpr()) : NO_FILTER_STRING;
        String defaultPartitionName = req.isSetDefaultPartitionName() ? req.getDefaultPartitionName() : NO_FILTER_STRING;
        short maxParts = req.getMaxParts();
        this.startPartitionFunction("get_partitions_by_expr", catName, dbName, tblName, maxParts, expr, defaultPartitionName);
        this.fireReadTablePreEvent(catName, dbName, tblName);
        PartitionsByExprResult ret = null;
        Exception ex = null;
        try {
            ret = this.get_partitions_by_expr_internal(catName, dbName, tblName, new GetPartitionsArgs.GetPartitionsArgsBuilder().expr(req.getExpr()).defaultPartName(req.getDefaultPartitionName()).max(req.getMaxParts()).skipColumnSchemaForPartition(req.isSkipColumnSchemaForPartition()).excludeParamKeyPattern(req.getExcludeParamKeyPattern()).includeParamKeyPattern(req.getIncludeParamKeyPattern()).build());
            this.endFunction("get_partitions_by_expr", ret != null, ex, tblName);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_partitions_by_expr", ret != null, ex, tblName);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_by_expr", ret != null, ex, tblName);
                throw throwable;
            }
        }
        return ret;
    }

    private PartitionsByExprResult get_partitions_by_expr_internal(String catName, String dbName, String tblName, GetPartitionsArgs args) throws TException {
        List<Partition> partitions = new LinkedList<Partition>();
        boolean hasUnknownPartitions = false;
        RawStore rs = this.getMS();
        if (this.exceedsPartitionFetchLimit(args.getMax())) {
            int max = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST) + 1;
            List<String> partNames = rs.listPartitionNames(catName, dbName, tblName, args.getDefaultPartName(), args.getExpr(), null, max);
            this.checkLimitNumberOfPartitions(tblName, partNames.size());
            partitions = rs.getPartitionsByNames(catName, dbName, tblName, new GetPartitionsArgs.GetPartitionsArgsBuilder(args).partNames(partNames).build());
        } else {
            hasUnknownPartitions = rs.getPartitionsByExpr(catName, dbName, tblName, partitions, args);
        }
        return new PartitionsByExprResult(partitions, hasUnknownPartitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int get_num_partitions_by_filter(String dbName, String tblName, String filter) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        if (parsedDbName[1] == null || tblName == null) {
            throw new MetaException("The DB and table name cannot be null.");
        }
        this.startFunction("get_num_partitions_by_filter", " : tbl=" + TableName.getQualified((String)parsedDbName[0], (String)parsedDbName[1], (String)tblName) + " Filter=" + filter);
        int ret = -1;
        Exception ex = null;
        try {
            ret = this.getMS().getNumPartitionsByFilter(parsedDbName[0], parsedDbName[1], tblName, filter);
            this.endFunction("get_num_partitions_by_filter", ret != -1, ex, tblName);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_num_partitions_by_filter", ret != -1, ex, tblName);
            }
            catch (Throwable throwable) {
                this.endFunction("get_num_partitions_by_filter", ret != -1, ex, tblName);
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumPartitionsByPs(String catName, String dbName, String tblName, List<String> partVals) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        this.startTableFunction("getNumPartitionsByPs", parsedDbName[0], parsedDbName[1], tblName);
        int ret = -1;
        Exception ex = null;
        try {
            ret = this.getMS().getNumPartitionsByPs(catName, dbName, tblName, partVals);
            this.endFunction("getNumPartitionsByPs", ret != -1, ex, tblName);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("getNumPartitionsByPs", ret != -1, ex, tblName);
            }
            catch (Throwable throwable) {
                this.endFunction("getNumPartitionsByPs", ret != -1, ex, tblName);
                throw throwable;
            }
        }
        return ret;
    }

    @Deprecated
    public List<Partition> get_partitions_by_names(String dbName, String tblName, List<String> partNames) throws TException {
        return this.get_partitions_by_names(dbName, tblName, false, null, null, null, new GetPartitionsArgs.GetPartitionsArgsBuilder().partNames(partNames).build());
    }

    public GetPartitionsByNamesResult get_partitions_by_names_req(GetPartitionsByNamesRequest gpbnr) throws TException {
        List<Partition> partitions = this.get_partitions_by_names(gpbnr.getDb_name(), gpbnr.getTbl_name(), gpbnr.isSetGet_col_stats() && gpbnr.isGet_col_stats(), gpbnr.getEngine(), gpbnr.getProcessorCapabilities(), gpbnr.getProcessorIdentifier(), new GetPartitionsArgs.GetPartitionsArgsBuilder().partNames(gpbnr.getNames()).skipColumnSchemaForPartition(gpbnr.isSkipColumnSchemaForPartition()).excludeParamKeyPattern(gpbnr.getExcludeParamKeyPattern()).includeParamKeyPattern(gpbnr.getIncludeParamKeyPattern()).build());
        GetPartitionsByNamesResult result = new GetPartitionsByNamesResult(partitions);
        return result;
    }

    private List<Partition> get_partitions_by_names(String dbName, String tblName, boolean getColStats, String engine, List<String> processorCapabilities, String processorId, GetPartitionsArgs args) throws TException {
        String[] dbNameParts = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        String parsedCatName = dbNameParts[0];
        String parsedDbName = dbNameParts[1];
        List<Partition> ret = null;
        Table table = null;
        Exception ex = null;
        boolean success = false;
        this.startTableFunction("get_partitions_by_names", parsedCatName, parsedDbName, tblName);
        try {
            this.getMS().openTransaction();
            this.authorizeTableForPartitionMetadata(parsedCatName, parsedDbName, tblName);
            this.fireReadTablePreEvent(parsedCatName, parsedDbName, tblName);
            this.checkLimitNumberOfPartitions(tblName, args.getPartNames().size());
            ret = this.getMS().getPartitionsByNames(parsedCatName, parsedDbName, tblName, args);
            ret = FilterUtils.filterPartitionsIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, ret);
            table = this.getTable(parsedCatName, parsedDbName, tblName);
            if (getColStats) {
                for (Partition part : ret) {
                    ColumnStatistics partColStats;
                    String partName = Warehouse.makePartName((List)table.getPartitionKeys(), (List)part.getValues());
                    List<ColumnStatistics> partColStatsList = this.getMS().getPartitionColumnStatistics(parsedCatName, parsedDbName, tblName, Collections.singletonList(partName), StatsSetupConst.getColumnsHavingStats((Map)part.getParameters()), engine);
                    if (partColStatsList == null || partColStatsList.isEmpty() || (partColStats = partColStatsList.get(0)) == null) continue;
                    part.setColStats(partColStats);
                }
            }
            if (processorCapabilities == null || processorCapabilities.size() == 0 || processorCapabilities.contains("MANAGERAWMETADATA")) {
                LOG.info("Skipping translation for processor with " + processorId);
            } else if (this.transformer != null) {
                ret = this.transformer.transformPartitions(ret, table, processorCapabilities, processorId);
            }
            success = this.getMS().commitTransaction();
            if (!success) {
                this.getMS().rollbackTransaction();
            }
            this.endFunction("get_partitions_by_names", ret != null, ex, tblName);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class, InvalidObjectException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.getMS().rollbackTransaction();
                }
                this.endFunction("get_partitions_by_names", ret != null, ex, tblName);
                throw throwable;
            }
        }
        return ret;
    }

    private PropertyManager getPropertyManager(String ns) throws MetaException, NoSuchObjectException {
        PropertyStore propertyStore = this.getMS().getPropertyStore();
        PropertyManager mgr = PropertyManager.create((String)ns, (PropertyStore)propertyStore);
        return mgr;
    }

    public PropertyGetResponse get_properties(PropertyGetRequest req) throws TException {
        try {
            PropertyManager mgr = this.getPropertyManager(req.getNameSpace());
            Map selected = mgr.selectProperties(req.getMapPrefix(), req.getMapPredicate(), req.getMapSelection());
            PropertyGetResponse response = new PropertyGetResponse();
            TreeMap returned = new TreeMap();
            selected.forEach((k, v) -> returned.put(k, v.export()));
            response.setProperties(returned);
            return response;
        }
        catch (PropertyException exception) {
            throw ExceptionHandler.newMetaException((Exception)((Object)exception));
        }
    }

    public boolean set_properties(PropertySetRequest req) throws TException {
        try {
            PropertyManager mgr = this.getPropertyManager(req.getNameSpace());
            mgr.setProperties(req.getPropertyMap());
            mgr.commit();
            return true;
        }
        catch (PropertyException exception) {
            throw ExceptionHandler.newMetaException((Exception)((Object)exception));
        }
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws TException {
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        String catName = hiveObject.isSetCatName() ? hiveObject.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        HiveObjectType debug = hiveObject.getObjectType();
        if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
            String partName = this.getPartName(hiveObject);
            return this.get_column_privilege_set(catName, hiveObject.getDbName(), hiveObject.getObjectName(), partName, hiveObject.getColumnName(), userName, groupNames);
        }
        if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
            String partName = this.getPartName(hiveObject);
            return this.get_partition_privilege_set(catName, hiveObject.getDbName(), hiveObject.getObjectName(), partName, userName, groupNames);
        }
        if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
            return this.get_db_privilege_set(catName, hiveObject.getDbName(), userName, groupNames);
        }
        if (hiveObject.getObjectType() == HiveObjectType.DATACONNECTOR) {
            return this.get_connector_privilege_set(catName, hiveObject.getObjectName(), userName, groupNames);
        }
        if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
            return this.get_table_privilege_set(catName, hiveObject.getDbName(), hiveObject.getObjectName(), userName, groupNames);
        }
        if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
            return this.get_user_privilege_set(userName, groupNames);
        }
        return null;
    }

    private String getPartName(HiveObjectRef hiveObject) throws MetaException {
        String partName = null;
        List partValue = hiveObject.getPartValues();
        if (partValue != null && partValue.size() > 0) {
            try {
                String catName = hiveObject.isSetCatName() ? hiveObject.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
                Table table = this.get_table_core(catName, hiveObject.getDbName(), hiveObject.getObjectName());
                partName = Warehouse.makePartName((List)table.getPartitionKeys(), (List)partValue);
            }
            catch (NoSuchObjectException e) {
                throw new MetaException(e.getMessage());
            }
        }
        return partName;
    }

    private PrincipalPrivilegeSet get_column_privilege_set(String catName, String dbName, String tableName, String partName, String columnName, String userName, List<String> groupNames) throws TException {
        PrincipalPrivilegeSet ret;
        this.incrementCounter("get_column_privilege_set");
        try {
            ret = this.getMS().getColumnPrivilegeSet(catName, dbName, tableName, partName, columnName, userName, groupNames);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
        return ret;
    }

    private PrincipalPrivilegeSet get_db_privilege_set(String catName, String dbName, String userName, List<String> groupNames) throws TException {
        PrincipalPrivilegeSet ret;
        this.incrementCounter("get_db_privilege_set");
        try {
            ret = this.getMS().getDBPrivilegeSet(catName, dbName, userName, groupNames);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
        return ret;
    }

    private PrincipalPrivilegeSet get_connector_privilege_set(String catName, String connectorName, String userName, List<String> groupNames) throws TException {
        PrincipalPrivilegeSet ret;
        this.incrementCounter("get_connector_privilege_set");
        try {
            ret = this.getMS().getConnectorPrivilegeSet(catName, connectorName, userName, groupNames);
        }
        catch (MetaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    private PrincipalPrivilegeSet get_partition_privilege_set(String catName, String dbName, String tableName, String partName, String userName, List<String> groupNames) throws TException {
        PrincipalPrivilegeSet ret;
        this.incrementCounter("get_partition_privilege_set");
        try {
            ret = this.getMS().getPartitionPrivilegeSet(catName, dbName, tableName, partName, userName, groupNames);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
        return ret;
    }

    private PrincipalPrivilegeSet get_table_privilege_set(String catName, String dbName, String tableName, String userName, List<String> groupNames) throws TException {
        PrincipalPrivilegeSet ret;
        this.incrementCounter("get_table_privilege_set");
        try {
            ret = this.getMS().getTablePrivilegeSet(catName, dbName, tableName, userName, groupNames);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
        return ret;
    }

    public boolean grant_role(String roleName, String principalName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws TException {
        Boolean ret;
        this.incrementCounter("add_role_member");
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        if (PUBLIC.equals(roleName)) {
            throw new MetaException("No user can be added to public. Since all users implicitly belong to public role.");
        }
        try {
            RawStore ms = this.getMS();
            Role role = ms.getRole(roleName);
            if (principalType == PrincipalType.ROLE && this.isNewRoleAParent(principalName, roleName)) {
                throw new MetaException("Cannot grant role " + principalName + " to " + roleName + " as " + roleName + " already belongs to the role " + principalName + ". (no cycles allowed)");
            }
            ret = ms.grantRole(role, principalName, principalType, grantor, grantorType, grantOption);
        }
        catch (Exception e) {
            String exInfo = "Got exception: " + e.getClass().getName() + " " + e.getMessage();
            LOG.error(exInfo, (Throwable)e);
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).toMetaExceptionIfInstance(exInfo, InvalidObjectException.class, NoSuchObjectException.class).defaultTException();
        }
        return ret;
    }

    private boolean isNewRoleAParent(String newRole, String curRole) throws MetaException {
        if (newRole.equals(curRole)) {
            return true;
        }
        List<Role> parentRoleMaps = this.getMS().listRoles(curRole, PrincipalType.ROLE);
        for (Role parentRole : parentRoleMaps) {
            if (!this.isNewRoleAParent(newRole, parentRole.getRoleName())) continue;
            return true;
        }
        return false;
    }

    public List<Role> list_roles(String principalName, PrincipalType principalType) throws TException {
        this.incrementCounter("list_roles");
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        return this.getMS().listRoles(principalName, principalType);
    }

    public boolean create_role(Role role) throws TException {
        Boolean ret;
        this.incrementCounter("create_role");
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        if (PUBLIC.equals(role.getRoleName())) {
            throw new MetaException("public role implicitly exists. It can't be created.");
        }
        try {
            ret = this.getMS().addRole(role.getRoleName(), role.getOwnerName());
        }
        catch (Exception e) {
            String exInfo = "Got exception: " + e.getClass().getName() + " " + e.getMessage();
            LOG.error(exInfo, (Throwable)e);
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).toMetaExceptionIfInstance(exInfo, InvalidObjectException.class, NoSuchObjectException.class).defaultTException();
        }
        return ret;
    }

    public boolean drop_role(String roleName) throws TException {
        Boolean ret;
        this.incrementCounter("drop_role");
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        if (ADMIN.equals(roleName) || PUBLIC.equals(roleName)) {
            throw new MetaException("public,admin roles can't be dropped.");
        }
        try {
            ret = this.getMS().removeRole(roleName);
        }
        catch (Exception e) {
            String exInfo = "Got exception: " + e.getClass().getName() + " " + e.getMessage();
            LOG.error(exInfo, (Throwable)e);
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).toMetaExceptionIfInstance(exInfo, NoSuchObjectException.class).defaultTException();
        }
        return ret;
    }

    public List<String> get_role_names() throws TException {
        this.incrementCounter("get_role_names");
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        try {
            List<String> ret = this.getMS().listRoleNames();
            return ret;
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
    }

    public boolean grant_privileges(PrivilegeBag privileges) throws TException {
        Boolean ret;
        this.incrementCounter("grant_privileges");
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        try {
            ret = this.getMS().grantPrivileges(privileges);
        }
        catch (Exception e) {
            String exInfo = "Got exception: " + e.getClass().getName() + " " + e.getMessage();
            LOG.error(exInfo, (Throwable)e);
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).toMetaExceptionIfInstance(exInfo, InvalidObjectException.class, NoSuchObjectException.class).defaultTException();
        }
        return ret;
    }

    public boolean revoke_role(String roleName, String userName, PrincipalType principalType) throws TException {
        return this.revoke_role(roleName, userName, principalType, false);
    }

    private boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws TException {
        Boolean ret;
        this.incrementCounter("remove_role_member");
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        if (PUBLIC.equals(roleName)) {
            throw new MetaException("public role can't be revoked.");
        }
        try {
            RawStore ms = this.getMS();
            Role mRole = ms.getRole(roleName);
            ret = ms.revokeRole(mRole, userName, principalType, grantOption);
        }
        catch (Exception e) {
            String exInfo = "Got exception: " + e.getClass().getName() + " " + e.getMessage();
            LOG.error(exInfo, (Throwable)e);
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).toMetaExceptionIfInstance(exInfo, NoSuchObjectException.class).defaultTException();
        }
        return ret;
    }

    public GrantRevokeRoleResponse grant_revoke_role(GrantRevokeRoleRequest request) throws TException {
        GrantRevokeRoleResponse response = new GrantRevokeRoleResponse();
        boolean grantOption = false;
        if (request.isSetGrantOption()) {
            grantOption = request.isGrantOption();
        }
        switch (request.getRequestType()) {
            case GRANT: {
                boolean result = this.grant_role(request.getRoleName(), request.getPrincipalName(), request.getPrincipalType(), request.getGrantor(), request.getGrantorType(), grantOption);
                response.setSuccess(result);
                break;
            }
            case REVOKE: {
                boolean result = this.revoke_role(request.getRoleName(), request.getPrincipalName(), request.getPrincipalType(), grantOption);
                response.setSuccess(result);
                break;
            }
            default: {
                throw new MetaException("Unknown request type " + request.getRequestType());
            }
        }
        return response;
    }

    public GrantRevokePrivilegeResponse grant_revoke_privileges(GrantRevokePrivilegeRequest request) throws TException {
        GrantRevokePrivilegeResponse response = new GrantRevokePrivilegeResponse();
        switch (request.getRequestType()) {
            case GRANT: {
                boolean result = this.grant_privileges(request.getPrivileges());
                response.setSuccess(result);
                break;
            }
            case REVOKE: {
                boolean revokeGrantOption = false;
                if (request.isSetRevokeGrantOption()) {
                    revokeGrantOption = request.isRevokeGrantOption();
                }
                boolean result = this.revoke_privileges(request.getPrivileges(), revokeGrantOption);
                response.setSuccess(result);
                break;
            }
            default: {
                throw new MetaException("Unknown request type " + request.getRequestType());
            }
        }
        return response;
    }

    public GrantRevokePrivilegeResponse refresh_privileges(HiveObjectRef objToRefresh, String authorizer, GrantRevokePrivilegeRequest grantRequest) throws TException {
        this.incrementCounter("refresh_privileges");
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        GrantRevokePrivilegeResponse response = new GrantRevokePrivilegeResponse();
        try {
            boolean result = this.getMS().refreshPrivileges(objToRefresh, authorizer, grantRequest.getPrivileges());
            response.setSuccess(result);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
        return response;
    }

    public boolean revoke_privileges(PrivilegeBag privileges) throws TException {
        return this.revoke_privileges(privileges, false);
    }

    public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws TException {
        Boolean ret;
        this.incrementCounter("revoke_privileges");
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        try {
            ret = this.getMS().revokePrivileges(privileges, grantOption);
        }
        catch (Exception e) {
            String exInfo = "Got exception: " + e.getClass().getName() + " " + e.getMessage();
            LOG.error(exInfo, (Throwable)e);
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).toMetaExceptionIfInstance(exInfo, InvalidObjectException.class, NoSuchObjectException.class).defaultTException();
        }
        return ret;
    }

    private PrincipalPrivilegeSet get_user_privilege_set(String userName, List<String> groupNames) throws TException {
        PrincipalPrivilegeSet ret;
        this.incrementCounter("get_user_privilege_set");
        try {
            ret = this.getMS().getUserPrivilegeSet(userName, groupNames);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
        return ret;
    }

    public List<HiveObjectPrivilege> list_privileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObject) throws TException {
        String catName;
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        String string = catName = hiveObject.isSetCatName() ? hiveObject.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        if (hiveObject.getObjectType() == null) {
            return this.getAllPrivileges(principalName, principalType, catName);
        }
        if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
            return this.list_global_privileges(principalName, principalType);
        }
        if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
            return this.list_db_privileges(principalName, principalType, catName, hiveObject.getDbName());
        }
        if (hiveObject.getObjectType() == HiveObjectType.DATACONNECTOR) {
            return this.list_dc_privileges(principalName, principalType, hiveObject.getObjectName());
        }
        if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
            return this.list_table_privileges(principalName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName());
        }
        if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
            return this.list_partition_privileges(principalName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues());
        }
        if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
            if (hiveObject.getPartValues() == null || hiveObject.getPartValues().isEmpty()) {
                return this.list_table_column_privileges(principalName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getColumnName());
            }
            return this.list_partition_column_privileges(principalName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues(), hiveObject.getColumnName());
        }
        return null;
    }

    private List<HiveObjectPrivilege> getAllPrivileges(String principalName, PrincipalType principalType, String catName) throws TException {
        ArrayList<HiveObjectPrivilege> privs = new ArrayList<HiveObjectPrivilege>();
        privs.addAll(this.list_global_privileges(principalName, principalType));
        privs.addAll(this.list_db_privileges(principalName, principalType, catName, null));
        privs.addAll(this.list_dc_privileges(principalName, principalType, null));
        privs.addAll(this.list_table_privileges(principalName, principalType, catName, null, null));
        privs.addAll(this.list_partition_privileges(principalName, principalType, catName, null, null, null));
        privs.addAll(this.list_table_column_privileges(principalName, principalType, catName, null, null, null));
        privs.addAll(this.list_partition_column_privileges(principalName, principalType, catName, null, null, null, null));
        return privs;
    }

    private List<HiveObjectPrivilege> list_table_column_privileges(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, String columnName) throws TException {
        this.incrementCounter("list_table_column_privileges");
        try {
            if (dbName == null) {
                return this.getMS().listPrincipalTableColumnGrantsAll(principalName, principalType);
            }
            if (principalName == null) {
                return this.getMS().listTableColumnGrantsAll(catName, dbName, tableName, columnName);
            }
            return this.getMS().listPrincipalTableColumnGrants(principalName, principalType, catName, dbName, tableName, columnName);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
    }

    private List<HiveObjectPrivilege> list_partition_column_privileges(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, List<String> partValues, String columnName) throws TException {
        this.incrementCounter("list_partition_column_privileges");
        try {
            if (dbName == null) {
                return this.getMS().listPrincipalPartitionColumnGrantsAll(principalName, principalType);
            }
            Table tbl = this.get_table_core(catName, dbName, tableName);
            String partName = Warehouse.makePartName((List)tbl.getPartitionKeys(), partValues);
            if (principalName == null) {
                return this.getMS().listPartitionColumnGrantsAll(catName, dbName, tableName, partName, columnName);
            }
            return this.getMS().listPrincipalPartitionColumnGrants(principalName, principalType, catName, dbName, tableName, partValues, partName, columnName);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
    }

    private List<HiveObjectPrivilege> list_db_privileges(String principalName, PrincipalType principalType, String catName, String dbName) throws TException {
        this.incrementCounter("list_security_db_grant");
        try {
            if (dbName == null) {
                return this.getMS().listPrincipalDBGrantsAll(principalName, principalType);
            }
            if (principalName == null) {
                return this.getMS().listDBGrantsAll(catName, dbName);
            }
            return this.getMS().listPrincipalDBGrants(principalName, principalType, catName, dbName);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
    }

    private List<HiveObjectPrivilege> list_dc_privileges(String principalName, PrincipalType principalType, String dcName) throws TException {
        this.incrementCounter("list_security_dc_grant");
        try {
            if (dcName == null) {
                return this.getMS().listPrincipalDCGrantsAll(principalName, principalType);
            }
            if (principalName == null) {
                return this.getMS().listDCGrantsAll(dcName);
            }
            return this.getMS().listPrincipalDCGrants(principalName, principalType, dcName);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
    }

    private List<HiveObjectPrivilege> list_partition_privileges(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, List<String> partValues) throws TException {
        this.incrementCounter("list_security_partition_grant");
        try {
            if (dbName == null) {
                return this.getMS().listPrincipalPartitionGrantsAll(principalName, principalType);
            }
            Table tbl = this.get_table_core(catName, dbName, tableName);
            String partName = Warehouse.makePartName((List)tbl.getPartitionKeys(), partValues);
            if (principalName == null) {
                return this.getMS().listPartitionGrantsAll(catName, dbName, tableName, partName);
            }
            return this.getMS().listPrincipalPartitionGrants(principalName, principalType, catName, dbName, tableName, partValues, partName);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
    }

    private List<HiveObjectPrivilege> list_table_privileges(String principalName, PrincipalType principalType, String catName, String dbName, String tableName) throws TException {
        this.incrementCounter("list_security_table_grant");
        try {
            if (dbName == null) {
                return this.getMS().listPrincipalTableGrantsAll(principalName, principalType);
            }
            if (principalName == null) {
                return this.getMS().listTableGrantsAll(catName, dbName, tableName);
            }
            return this.getMS().listAllTableGrants(principalName, principalType, catName, dbName, tableName);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
    }

    private List<HiveObjectPrivilege> list_global_privileges(String principalName, PrincipalType principalType) throws TException {
        this.incrementCounter("list_security_user_grant");
        try {
            if (principalName == null) {
                return this.getMS().listGlobalGrantsAll();
            }
            return this.getMS().listPrincipalGlobalGrants(principalName, principalType);
        }
        catch (Exception e) {
            throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class).defaultRuntimeException();
        }
    }

    public void cancel_delegation_token(String token_str_form) throws TException {
        this.startFunction("cancel_delegation_token");
        boolean success = false;
        Exception ex = null;
        try {
            HiveMetaStore.cancelDelegationToken(token_str_form);
            success = true;
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.handleException(e).convertIfInstance(IOException.class, MetaException.class).defaultMetaException();
        }
        finally {
            this.endFunction("cancel_delegation_token", success, ex);
        }
    }

    public long renew_delegation_token(String token_str_form) throws TException {
        this.startFunction("renew_delegation_token");
        Long ret = null;
        Exception ex = null;
        try {
            ret = HiveMetaStore.renewDelegationToken(token_str_form);
            this.endFunction("renew_delegation_token", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).convertIfInstance(IOException.class, MetaException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("renew_delegation_token", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public String get_delegation_token(String token_owner, String renewer_kerberos_principal_name) throws TException {
        this.startFunction("get_delegation_token");
        String ret = null;
        Exception ex = null;
        try {
            ret = HiveMetaStore.getDelegationToken(token_owner, renewer_kerberos_principal_name, HMSHandler.getIPAddress());
            this.endFunction("get_delegation_token", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).convertIfInstance(IOException.class, MetaException.class).convertIfInstance(InterruptedException.class, MetaException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("get_delegation_token", ret != null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public boolean add_token(String token_identifier, String delegation_token) throws TException {
        this.startFunction("add_token", ": " + token_identifier);
        boolean ret = false;
        Exception ex = null;
        try {
            ret = this.getMS().addToken(token_identifier, delegation_token);
            this.endFunction("add_token", ret, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("add_token", ret, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public boolean remove_token(String token_identifier) throws TException {
        this.startFunction("remove_token", ": " + token_identifier);
        boolean ret = false;
        Exception ex = null;
        try {
            ret = this.getMS().removeToken(token_identifier);
            this.endFunction("remove_token", ret, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("remove_token", ret, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public String get_token(String token_identifier) throws TException {
        this.startFunction("get_token for", ": " + token_identifier);
        String ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getToken(token_identifier);
            this.endFunction("get_token", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_token", ret != null, ex);
                throw throwable;
            }
        }
        return ret == null ? NO_FILTER_STRING : ret;
    }

    public List<String> get_all_token_identifiers() throws TException {
        List<String> ret;
        this.startFunction("get_all_token_identifiers.");
        Exception ex = null;
        try {
            ret = this.getMS().getAllTokenIdentifiers();
            this.endFunction("get_all_token_identifiers.", ex == null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_all_token_identifiers.", ex == null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public int add_master_key(String key) throws TException {
        int ret;
        this.startFunction("add_master_key.");
        Exception ex = null;
        try {
            ret = this.getMS().addMasterKey(key);
            this.endFunction("add_master_key.", ex == null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("add_master_key.", ex == null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public void update_master_key(int seq_number, String key) throws TException {
        this.startFunction("update_master_key.");
        Exception ex = null;
        try {
            this.getMS().updateMasterKey(seq_number, key);
            this.endFunction("update_master_key.", ex == null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("update_master_key.", ex == null, ex);
                throw throwable;
            }
        }
    }

    public boolean remove_master_key(int key_seq) throws TException {
        boolean ret;
        this.startFunction("remove_master_key.");
        Exception ex = null;
        try {
            ret = this.getMS().removeMasterKey(key_seq);
            this.endFunction("remove_master_key.", ex == null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("remove_master_key.", ex == null, ex);
                throw throwable;
            }
        }
        return ret;
    }

    public List<String> get_master_keys() throws TException {
        this.startFunction("get_master_keys.");
        Exception ex = null;
        String[] ret = null;
        try {
            ret = this.getMS().getMasterKeys();
            this.endFunction("get_master_keys.", ret != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_master_keys.", ret != null, ex);
                throw throwable;
            }
        }
        return Arrays.asList(ret);
    }

    public void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partName, PartitionEventType evtType) throws TException {
        Table tbl = null;
        Exception ex = null;
        RawStore ms = this.getMS();
        boolean success = false;
        try {
            String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
            ms.openTransaction();
            this.startPartitionFunction("markPartitionForEvent", parsedDbName[0], parsedDbName[1], tbl_name, partName);
            this.firePreEvent(new PreLoadPartitionDoneEvent(parsedDbName[0], parsedDbName[1], tbl_name, partName, this));
            tbl = ms.markPartitionForEvent(parsedDbName[0], parsedDbName[1], tbl_name, partName, evtType);
            if (null == tbl) {
                throw new UnknownTableException("Table: " + tbl_name + " not found.");
            }
            if (this.transactionalListeners.size() > 0) {
                LoadPartitionDoneEvent lpde = new LoadPartitionDoneEvent(true, tbl, partName, this);
                for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                    metaStoreEventListener.onLoadPartitionDone(lpde);
                }
            }
            success = ms.commitTransaction();
            for (MetaStoreEventListener listener : this.listeners) {
                listener.onLoadPartitionDone(new LoadPartitionDoneEvent(true, tbl, partName, this));
            }
            if (!success) {
                ms.rollbackTransaction();
            }
            this.endFunction("markPartitionForEvent", tbl != null, ex, tbl_name);
        }
        catch (Exception original) {
            try {
                ex = original;
                LOG.error("Exception caught in mark partition event ", (Throwable)original);
                throw ExceptionHandler.handleException(original).throwIfInstance(UnknownTableException.class, InvalidPartitionException.class, MetaException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                }
                this.endFunction("markPartitionForEvent", tbl != null, ex, tbl_name);
                throw throwable;
            }
        }
    }

    public boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partName, PartitionEventType evtType) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)db_name, (Configuration)this.conf);
        this.startPartitionFunction("isPartitionMarkedForEvent", parsedDbName[0], parsedDbName[1], tbl_name, partName);
        Boolean ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().isPartitionMarkedForEvent(parsedDbName[0], parsedDbName[1], tbl_name, partName, evtType);
            this.endFunction("isPartitionMarkedForEvent", ret != null, ex, tbl_name);
        }
        catch (Exception original) {
            try {
                LOG.error("Exception caught for isPartitionMarkedForEvent ", (Throwable)original);
                ex = original;
                throw ExceptionHandler.handleException(original).throwIfInstance(UnknownTableException.class, InvalidPartitionException.class).throwIfInstance(UnknownPartitionException.class, MetaException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("isPartitionMarkedForEvent", ret != null, ex, tbl_name);
                throw throwable;
            }
        }
        return ret;
    }

    public List<String> set_ugi(String username, List<String> groupNames) throws TException {
        Collections.addAll(groupNames, username);
        return groupNames;
    }

    public boolean partition_name_has_valid_characters(List<String> part_vals, boolean throw_exception) throws TException {
        boolean ret;
        this.startFunction("partition_name_has_valid_characters");
        Exception ex = null;
        try {
            if (throw_exception) {
                MetaStoreServerUtils.validatePartitionNameCharacters(part_vals, this.partitionValidationPattern);
                ret = true;
            } else {
                ret = MetaStoreServerUtils.partitionNameHasValidCharacters(part_vals, this.partitionValidationPattern);
            }
        }
        catch (Exception e) {
            ex = e;
            throw ExceptionHandler.newMetaException(e);
        }
        finally {
            this.endFunction("partition_name_has_valid_characters", true, ex);
        }
        return ret;
    }

    private void validateFunctionInfo(Function func) throws InvalidObjectException, MetaException {
        if (func == null) {
            throw new MetaException("Function cannot be null.");
        }
        if (func.getFunctionName() == null) {
            throw new MetaException("Function name cannot be null.");
        }
        if (func.getDbName() == null) {
            throw new MetaException("Database name in Function cannot be null.");
        }
        if (!MetaStoreUtils.validateName((String)func.getFunctionName(), null)) {
            throw new InvalidObjectException(func.getFunctionName() + " is not a valid object name");
        }
        String className = func.getClassName();
        if (className == null) {
            throw new InvalidObjectException("Function class name cannot be null");
        }
        if (func.getOwnerType() == null) {
            throw new MetaException("Function owner type cannot be null.");
        }
        if (func.getFunctionType() == null) {
            throw new MetaException("Function type cannot be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create_function(Function func) throws TException {
        this.validateFunctionInfo(func);
        boolean success = false;
        RawStore ms = this.getMS();
        Map<String, String> transactionalListenerResponses = Collections.emptyMap();
        try {
            String catName;
            String string = catName = func.isSetCatName() ? func.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
            if (!func.isSetOwnerName()) {
                try {
                    func.setOwnerName(SecurityUtils.getUGI().getShortUserName());
                }
                catch (Exception ex) {
                    LOG.error("Cannot obtain username from the session to create a function", (Throwable)ex);
                    throw new TException((Throwable)ex);
                }
            }
            ms.openTransaction();
            Database db = ms.getDatabase(catName, func.getDbName());
            if (db == null) {
                throw new NoSuchObjectException("The database " + func.getDbName() + " does not exist");
            }
            if (db.getType() == DatabaseType.REMOTE) {
                throw new MetaException("Operation create_function not support for REMOTE database");
            }
            Function existingFunc = ms.getFunction(catName, func.getDbName(), func.getFunctionName());
            if (existingFunc != null) {
                throw new AlreadyExistsException("Function " + func.getFunctionName() + " already exists");
            }
            this.firePreEvent(new PreCreateFunctionEvent(func, (IHMSHandler)this));
            long time = System.currentTimeMillis() / 1000L;
            func.setCreateTime((int)time);
            ms.createFunction(func);
            if (!this.transactionalListeners.isEmpty()) {
                transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.CREATE_FUNCTION, new CreateFunctionEvent(func, true, this));
            }
            success = ms.commitTransaction();
        }
        finally {
            if (!success) {
                ms.rollbackTransaction();
            }
            if (!this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_FUNCTION, new CreateFunctionEvent(func, success, this), null, transactionalListenerResponses, ms);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop_function(String dbName, String funcName) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        if (funcName == null) {
            throw new MetaException("Function name cannot be null.");
        }
        boolean success = false;
        Function func = null;
        RawStore ms = this.getMS();
        Map<String, String> transactionalListenerResponses = Collections.emptyMap();
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        if (parsedDbName[1] == null) {
            throw new MetaException("Database name cannot be null.");
        }
        try {
            ms.openTransaction();
            func = ms.getFunction(parsedDbName[0], parsedDbName[1], funcName);
            if (func == null) {
                throw new NoSuchObjectException("Function " + funcName + " does not exist");
            }
            Boolean needsCm = ReplChangeManager.isSourceOfReplication((Database)this.get_database_core(parsedDbName[0], parsedDbName[1]));
            if (func.getResourceUris() != null && !func.getResourceUris().isEmpty()) {
                for (ResourceUri uri : func.getResourceUris()) {
                    if (!uri.getUri().toLowerCase().startsWith("hdfs:") || !needsCm.booleanValue()) continue;
                    this.wh.addToChangeManagement(new Path(uri.getUri()));
                }
            }
            this.firePreEvent(new PreDropFunctionEvent(func, (IHMSHandler)this));
            ms.dropFunction(parsedDbName[0], parsedDbName[1], funcName);
            if (this.transactionalListeners.size() > 0) {
                transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_FUNCTION, new DropFunctionEvent(func, true, this));
            }
            success = ms.commitTransaction();
        }
        finally {
            if (!success) {
                ms.rollbackTransaction();
            }
            if (this.listeners.size() > 0) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_FUNCTION, new DropFunctionEvent(func, success, this), null, transactionalListenerResponses, ms);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alter_function(String dbName, String funcName, Function newFunc) throws TException {
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        this.validateForAlterFunction(parsedDbName[1], funcName, newFunc);
        boolean success = false;
        RawStore ms = this.getMS();
        try {
            this.firePreEvent(new PreCreateFunctionEvent(newFunc, (IHMSHandler)this));
            ms.openTransaction();
            ms.alterFunction(parsedDbName[0], parsedDbName[1], funcName, newFunc);
            success = ms.commitTransaction();
        }
        catch (InvalidObjectException e) {
            ExceptionHandler.throwMetaException((Exception)((Object)e));
        }
        finally {
            if (!success) {
                ms.rollbackTransaction();
            }
        }
    }

    private void validateForAlterFunction(String dbName, String funcName, Function newFunc) throws MetaException {
        if (dbName == null || funcName == null) {
            throw new MetaException("Database and function name cannot be null.");
        }
        try {
            this.validateFunctionInfo(newFunc);
        }
        catch (InvalidObjectException e) {
            throw ExceptionHandler.newMetaException((Exception)((Object)e));
        }
    }

    public List<String> get_functions(String dbName, String pattern) throws MetaException {
        this.startFunction("get_functions", ": db=" + dbName + " pat=" + pattern);
        RawStore ms = this.getMS();
        Exception ex = null;
        List<String> funcNames = null;
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        try {
            funcNames = ms.getFunctions(parsedDbName[0], parsedDbName[1], pattern);
            this.endFunction("get_functions", funcNames != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_functions", funcNames != null, ex);
                throw throwable;
            }
        }
        return funcNames;
    }

    public GetAllFunctionsResponse get_all_functions() throws MetaException {
        GetAllFunctionsResponse response = new GetAllFunctionsResponse();
        this.startFunction("get_all_functions");
        RawStore ms = this.getMS();
        List<Function> allFunctions = null;
        Exception ex = null;
        try {
            allFunctions = ms.getAllFunctions("hive");
            this.endFunction("get_all_functions", allFunctions != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_all_functions", allFunctions != null, ex);
                throw throwable;
            }
        }
        response.setFunctions(allFunctions);
        return response;
    }

    public Function get_function(String dbName, String funcName) throws TException {
        if (dbName == null || funcName == null) {
            throw new MetaException("Database and function name cannot be null.");
        }
        this.startFunction("get_function", ": " + dbName + "." + funcName);
        RawStore ms = this.getMS();
        Function func = null;
        Exception ex = null;
        String[] parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf);
        try {
            func = ms.getFunction(parsedDbName[0], parsedDbName[1], funcName);
            if (func == null) {
                throw new NoSuchObjectException("Function " + dbName + "." + funcName + " does not exist");
            }
            this.endFunction("get_function", func != null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.handleException(e).throwIfInstance(NoSuchObjectException.class).defaultMetaException();
            }
            catch (Throwable throwable) {
                this.endFunction("get_function", func != null, ex);
                throw throwable;
            }
        }
        return func;
    }

    public GetOpenTxnsResponse get_open_txns() throws TException {
        return this.getTxnHandler().getOpenTxns();
    }

    public GetOpenTxnsResponse get_open_txns_req(GetOpenTxnsRequest getOpenTxnsRequest) throws TException {
        return this.getTxnHandler().getOpenTxns(getOpenTxnsRequest.getExcludeTxnTypes());
    }

    public GetOpenTxnsInfoResponse get_open_txns_info() throws TException {
        return this.getTxnHandler().getOpenTxnsInfo();
    }

    public OpenTxnsResponse open_txns(OpenTxnRequest rqst) throws TException {
        boolean isHiveReplTxn;
        OpenTxnsResponse response = this.getTxnHandler().openTxns(rqst);
        List txnIds = response.getTxn_ids();
        boolean bl = isHiveReplTxn = rqst.isSetReplPolicy() && TxnType.DEFAULT.equals((Object)rqst.getTxn_type());
        if (txnIds != null && this.listeners != null && !this.listeners.isEmpty() && !isHiveReplTxn) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.OPEN_TXN, new OpenTxnEvent((List<Long>)txnIds, (IHMSHandler)this));
        }
        return response;
    }

    public void abort_txn(AbortTxnRequest rqst) throws TException {
        boolean isHiveReplTxn;
        this.getTxnHandler().abortTxn(rqst);
        boolean bl = isHiveReplTxn = rqst.isSetReplPolicy() && TxnType.DEFAULT.equals((Object)rqst.getTxn_type());
        if (this.listeners != null && !this.listeners.isEmpty() && !isHiveReplTxn) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ABORT_TXN, new AbortTxnEvent((Long)rqst.getTxnid(), (IHMSHandler)this));
        }
    }

    public void abort_txns(AbortTxnsRequest rqst) throws TException {
        this.getTxnHandler().abortTxns(rqst);
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (Long txnId : rqst.getTxn_ids()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ABORT_TXN, new AbortTxnEvent(txnId, (IHMSHandler)this));
            }
        }
    }

    @Override
    public AbortCompactResponse abort_Compactions(AbortCompactionRequest rqst) throws TException {
        return this.getTxnHandler().abortCompactions(rqst);
    }

    public long get_latest_txnid_in_conflict(long txnId) throws MetaException {
        return this.getTxnHandler().getLatestTxnIdInConflict(txnId);
    }

    public void commit_txn(CommitTxnRequest rqst) throws TException {
        boolean isHiveReplTxn;
        boolean isReplayedReplTxn = TxnType.REPL_CREATED.equals((Object)rqst.getTxn_type());
        boolean bl = isHiveReplTxn = rqst.isSetReplPolicy() && TxnType.DEFAULT.equals((Object)rqst.getTxn_type());
        if (rqst.isSetWriteEventInfos() && isReplayedReplTxn) {
            assert (rqst.isSetReplPolicy());
            long targetTxnId = this.getTxnHandler().getTargetTxnId(rqst.getReplPolicy(), rqst.getTxnid());
            if (targetTxnId < 0L) {
                return;
            }
            for (WriteEventInfo writeEventInfo : rqst.getWriteEventInfos()) {
                String root;
                String[] filesAdded = ReplChangeManager.getListFromSeparatedString((String)writeEventInfo.getFiles());
                List partitionValue = null;
                Partition ptnObj = null;
                Table tbl = this.getTblObject(writeEventInfo.getDatabase(), writeEventInfo.getTable(), null);
                if (writeEventInfo.getPartition() != null && !writeEventInfo.getPartition().isEmpty()) {
                    partitionValue = Warehouse.getPartValuesFromPartName((String)writeEventInfo.getPartition());
                    ptnObj = this.getPartitionObj(writeEventInfo.getDatabase(), writeEventInfo.getTable(), partitionValue, tbl);
                    root = ptnObj.getSd().getLocation();
                } else {
                    root = tbl.getSd().getLocation();
                }
                InsertEventRequestData insertData = new InsertEventRequestData();
                insertData.setReplace(true);
                for (String file : filesAdded) {
                    String[] decodedPath = ReplChangeManager.decodeFileUri((String)file);
                    String name = new Path(decodedPath[0]).getName();
                    Path newPath = FileUtils.getTransformedPath((String)name, (String)decodedPath[3], (String)root);
                    insertData.addToFilesAdded(newPath.toUri().toString());
                    insertData.addToSubDirectoryList(decodedPath[3]);
                    try {
                        insertData.addToFilesAddedChecksum(ReplChangeManager.checksumFor((Path)newPath, (FileSystem)newPath.getFileSystem(this.conf)));
                    }
                    catch (IOException e) {
                        LOG.error("failed to get checksum for the file " + newPath + " with error: " + e.getMessage());
                        throw new TException(e.getMessage());
                    }
                }
                WriteNotificationLogRequest wnRqst = new WriteNotificationLogRequest(targetTxnId, writeEventInfo.getWriteId(), writeEventInfo.getDatabase(), writeEventInfo.getTable(), insertData);
                if (partitionValue != null) {
                    wnRqst.setPartitionVals(partitionValue);
                }
                this.addTxnWriteNotificationLog(tbl, ptnObj, wnRqst);
            }
        }
        this.getTxnHandler().commitTxn(rqst);
        if (this.listeners != null && !this.listeners.isEmpty() && !isHiveReplTxn) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.COMMIT_TXN, new CommitTxnEvent((Long)rqst.getTxnid(), (IHMSHandler)this));
            Optional<CompactionInfo> compactionInfo = this.getTxnHandler().getCompactionByTxnId(rqst.getTxnid());
            if (compactionInfo.isPresent()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.COMMIT_COMPACTION, new CommitCompactionEvent(rqst.getTxnid(), compactionInfo.get(), this));
            }
        }
    }

    public void repl_tbl_writeid_state(ReplTblWriteIdStateRequest rqst) throws TException {
        this.getTxnHandler().replTableWriteIdState(rqst);
    }

    public GetValidWriteIdsResponse get_valid_write_ids(GetValidWriteIdsRequest rqst) throws TException {
        return this.getTxnHandler().getValidWriteIds(rqst);
    }

    public void add_write_ids_to_min_history(long txnId, Map<String, Long> validWriteIds) throws TException {
        this.getTxnHandler().addWriteIdsToMinHistory(txnId, validWriteIds);
    }

    public void set_hadoop_jobid(String jobId, long cqId) throws MetaException {
        this.getTxnHandler().setHadoopJobId(jobId, cqId);
    }

    @Deprecated
    public OptionalCompactionInfoStruct find_next_compact(String workerId) throws MetaException {
        return CompactionInfo.compactionInfoToOptionalStruct(this.getTxnHandler().findNextToCompact(workerId));
    }

    public OptionalCompactionInfoStruct find_next_compact2(FindNextCompactRequest rqst) throws MetaException {
        return CompactionInfo.compactionInfoToOptionalStruct(this.getTxnHandler().findNextToCompact(rqst));
    }

    public void mark_cleaned(CompactionInfoStruct cr) throws MetaException {
        this.getTxnHandler().markCleaned(CompactionInfo.compactionStructToInfo(cr));
    }

    public void mark_compacted(CompactionInfoStruct cr) throws MetaException {
        this.getTxnHandler().markCompacted(CompactionInfo.compactionStructToInfo(cr));
    }

    public void mark_failed(CompactionInfoStruct cr) throws MetaException {
        this.getTxnHandler().markFailed(CompactionInfo.compactionStructToInfo(cr));
    }

    public void mark_refused(CompactionInfoStruct cr) throws MetaException {
        this.getTxnHandler().markRefused(CompactionInfo.compactionStructToInfo(cr));
    }

    public boolean update_compaction_metrics_data(CompactionMetricsDataStruct struct) throws MetaException, TException {
        return this.getTxnHandler().updateCompactionMetricsData(CompactionMetricsDataConverter.structToData(struct));
    }

    public void remove_compaction_metrics_data(CompactionMetricsDataRequest request) throws MetaException, TException {
        this.getTxnHandler().removeCompactionMetricsData(request.getDbName(), request.getTblName(), request.getPartitionName(), CompactionMetricsDataConverter.thriftCompactionMetricType2DbType(request.getType()));
    }

    public List<String> find_columns_with_stats(CompactionInfoStruct cr) throws MetaException {
        return this.getTxnHandler().findColumnsWithStats(CompactionInfo.compactionStructToInfo(cr));
    }

    public void update_compactor_state(CompactionInfoStruct cr, long highWaterMark) throws MetaException {
        this.getTxnHandler().updateCompactorState(CompactionInfo.compactionStructToInfo(cr), highWaterMark);
    }

    public GetLatestCommittedCompactionInfoResponse get_latest_committed_compaction_info(GetLatestCommittedCompactionInfoRequest rqst) throws MetaException {
        if (rqst.getDbname() == null || rqst.getTablename() == null) {
            throw new MetaException("Database name and table name cannot be null.");
        }
        GetLatestCommittedCompactionInfoResponse response = this.getTxnHandler().getLatestCommittedCompactionInfo(rqst);
        return FilterUtils.filterCommittedCompactionInfoStructIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (String)MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), (String)rqst.getDbname(), (String)rqst.getTablename(), (GetLatestCommittedCompactionInfoResponse)response);
    }

    public AllocateTableWriteIdsResponse allocate_table_write_ids(AllocateTableWriteIdsRequest rqst) throws TException {
        AllocateTableWriteIdsResponse response = this.getTxnHandler().allocateTableWriteIds(rqst);
        if (this.listeners != null && !this.listeners.isEmpty()) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALLOC_WRITE_ID, new AllocWriteIdEvent(response.getTxnToWriteIds(), rqst.getDbName(), rqst.getTableName(), this));
        }
        return response;
    }

    public MaxAllocatedTableWriteIdResponse get_max_allocated_table_write_id(MaxAllocatedTableWriteIdRequest rqst) throws MetaException {
        return this.getTxnHandler().getMaxAllocatedTableWrited(rqst);
    }

    public void seed_write_id(SeedTableWriteIdsRequest rqst) throws MetaException {
        this.getTxnHandler().seedWriteId(rqst);
    }

    public void seed_txn_id(SeedTxnIdRequest rqst) throws MetaException {
        this.getTxnHandler().seedTxnId(rqst);
    }

    private void addTxnWriteNotificationLog(Table tableObj, Partition ptnObj, WriteNotificationLogRequest rqst) throws MetaException {
        String partition = NO_FILTER_STRING;
        if (ptnObj != null) {
            partition = Warehouse.makePartName((List)tableObj.getPartitionKeys(), (List)rqst.getPartitionVals());
        }
        AcidWriteEvent event = new AcidWriteEvent(partition, tableObj, ptnObj, rqst);
        this.getTxnHandler().addWriteNotificationLog(event);
        if (this.listeners != null && !this.listeners.isEmpty()) {
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ACID_WRITE, event);
        }
    }

    private Table getTblObject(String db, String table, String catalog) throws MetaException, NoSuchObjectException {
        GetTableRequest req = new GetTableRequest(db, table);
        if (catalog != null) {
            req.setCatName(catalog);
        }
        req.setCapabilities(new ClientCapabilities((List)Lists.newArrayList((Object[])new ClientCapability[]{ClientCapability.TEST_CAPABILITY, ClientCapability.INSERT_ONLY_TABLES})));
        return this.get_table_req(req).getTable();
    }

    private Partition getPartitionObj(String db, String table, List<String> partitionVals, Table tableObj) throws MetaException, NoSuchObjectException {
        if (tableObj.isSetPartitionKeys() && !tableObj.getPartitionKeys().isEmpty()) {
            return this.get_partition(db, table, partitionVals);
        }
        return null;
    }

    public WriteNotificationLogResponse add_write_notification_log(WriteNotificationLogRequest rqst) throws TException {
        Table tableObj = this.getTblObject(rqst.getDb(), rqst.getTable(), null);
        Partition ptnObj = this.getPartitionObj(rqst.getDb(), rqst.getTable(), rqst.getPartitionVals(), tableObj);
        this.addTxnWriteNotificationLog(tableObj, ptnObj, rqst);
        return new WriteNotificationLogResponse();
    }

    public WriteNotificationLogBatchResponse add_write_notification_log_in_batch(WriteNotificationLogBatchRequest batchRequest) throws TException {
        List<Object> ptnObjList;
        if (batchRequest.getRequestList().size() == 0) {
            return new WriteNotificationLogBatchResponse();
        }
        Table tableObj = this.getTblObject(batchRequest.getDb(), batchRequest.getTable(), batchRequest.getCatalog());
        BatchAcidWriteEvent event = new BatchAcidWriteEvent();
        ArrayList<String> partNameList = new ArrayList<String>();
        HashMap<String, WriteNotificationLogRequest> rqstMap = new HashMap<String, WriteNotificationLogRequest>();
        if (tableObj.getPartitionKeys().size() != 0) {
            for (WriteNotificationLogRequest rqst : batchRequest.getRequestList()) {
                String partition = Warehouse.makePartName((List)tableObj.getPartitionKeys(), (List)rqst.getPartitionVals());
                partNameList.add(partition);
                rqstMap.put(partition, rqst);
            }
            ptnObjList = this.getMS().getPartitionsByNames(tableObj.getCatName(), tableObj.getDbName(), tableObj.getTableName(), partNameList);
        } else {
            ptnObjList = new ArrayList();
            for (WriteNotificationLogRequest ignored : batchRequest.getRequestList()) {
                ptnObjList.add(null);
            }
        }
        int idx = 0;
        for (Partition partObject : ptnObjList) {
            WriteNotificationLogRequest request;
            String partition = NO_FILTER_STRING;
            if (partObject != null) {
                partition = Warehouse.makePartName((List)tableObj.getPartitionKeys(), (List)partObject.getValues());
                request = (WriteNotificationLogRequest)rqstMap.get(partition);
            } else {
                request = (WriteNotificationLogRequest)batchRequest.getRequestList().get(idx++);
            }
            event.addNotification(partition, tableObj, partObject, request);
            if (this.listeners == null || this.listeners.isEmpty()) continue;
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.BATCH_ACID_WRITE, new BatchAcidWriteEvent(partition, tableObj, partObject, request));
        }
        this.getTxnHandler().addWriteNotificationLog(event);
        return new WriteNotificationLogBatchResponse();
    }

    public LockResponse lock(LockRequest rqst) throws TException {
        return this.getTxnHandler().lock(rqst);
    }

    public LockResponse check_lock(CheckLockRequest rqst) throws TException {
        return this.getTxnHandler().checkLock(rqst);
    }

    public void unlock(UnlockRequest rqst) throws TException {
        this.getTxnHandler().unlock(rqst);
    }

    public ShowLocksResponse show_locks(ShowLocksRequest rqst) throws TException {
        return this.getTxnHandler().showLocks(rqst);
    }

    public void heartbeat(HeartbeatRequest ids) throws TException {
        this.getTxnHandler().heartbeat(ids);
    }

    public HeartbeatTxnRangeResponse heartbeat_txn_range(HeartbeatTxnRangeRequest rqst) throws TException {
        return this.getTxnHandler().heartbeatTxnRange(rqst);
    }

    @Deprecated
    public void compact(CompactionRequest rqst) throws TException {
        this.compact2(rqst);
    }

    public CompactionResponse compact2(CompactionRequest rqst) throws TException {
        return this.getTxnHandler().compact(rqst);
    }

    public ShowCompactResponse show_compact(ShowCompactRequest rqst) throws TException {
        ShowCompactResponse response = this.getTxnHandler().showCompact(rqst);
        response.setCompacts(FilterUtils.filterCompactionsIfEnabled((boolean)this.isServerFilterEnabled, (MetaStoreFilterHook)this.filterHook, (String)MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), (List)response.getCompacts()));
        return response;
    }

    public boolean submit_for_cleanup(CompactionRequest rqst, long highestWriteId, long txnId) throws TException {
        return this.getTxnHandler().submitForCleanup(rqst, highestWriteId, txnId);
    }

    public void flushCache() throws TException {
        this.getMS().flushCache();
    }

    public void add_dynamic_partitions(AddDynamicPartitions rqst) throws TException {
        this.getTxnHandler().addDynamicPartitions(rqst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest request) throws TException {
        this.incrementCounter("get_principals_in_role");
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        Exception ex = null;
        GetPrincipalsInRoleResponse response = null;
        try {
            response = new GetPrincipalsInRoleResponse(this.getMS().listRoleMembers(request.getRoleName()));
            this.endFunction("get_principals_in_role", ex == null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_principals_in_role", ex == null, ex);
            }
            catch (Throwable throwable) {
                this.endFunction("get_principals_in_role", ex == null, ex);
                throw throwable;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest request) throws TException {
        this.incrementCounter("get_role_grants_for_principal");
        this.firePreEvent(new PreAuthorizationCallEvent(this));
        Exception ex = null;
        List<RolePrincipalGrant> roleMaps = null;
        try {
            roleMaps = this.getMS().listRolesWithGrants(request.getPrincipal_name(), request.getPrincipal_type());
            this.endFunction("get_role_grants_for_principal", ex == null, ex);
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.rethrowException(e);
                this.endFunction("get_role_grants_for_principal", ex == null, ex);
            }
            catch (Throwable throwable) {
                this.endFunction("get_role_grants_for_principal", ex == null, ex);
                throw throwable;
            }
        }
        return new GetRoleGrantsForPrincipalResponse(roleMaps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggrStats get_aggr_stats_for(PartitionsStatsRequest request) throws TException {
        String catName = request.isSetCatName() ? request.getCatName().toLowerCase() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        String dbName = request.getDbName().toLowerCase();
        String tblName = request.getTblName().toLowerCase();
        this.startFunction("get_aggr_stats_for", ": table=" + TableName.getQualified((String)catName, (String)dbName, (String)tblName));
        ArrayList<String> lowerCaseColNames = new ArrayList<String>(request.getColNames().size());
        for (Object colName : request.getColNames()) {
            lowerCaseColNames.add(((String)colName).toLowerCase());
        }
        ArrayList<String> lowerCasePartNames = new ArrayList<String>(request.getPartNames().size());
        for (String partName : request.getPartNames()) {
            lowerCasePartNames.add(HMSHandler.lowerCaseConvertPartName(partName));
        }
        AggrStats aggrStats = null;
        try {
            AggrStats aggrStats2 = aggrStats = this.getMS().get_aggr_stats_for(catName, dbName, tblName, lowerCasePartNames, lowerCaseColNames, request.getEngine(), request.getValidWriteIdList());
            this.endFunction("get_aggr_stats_for", aggrStats == null, null, request.getTblName());
            return aggrStats2;
        }
        catch (Throwable throwable) {
            this.endFunction("get_aggr_stats_for", aggrStats == null, null, request.getTblName());
            throw throwable;
        }
    }

    public boolean set_aggr_stats_for(SetPartitionsStatsRequest request) throws TException {
        boolean ret = true;
        List csNews = request.getColStats();
        if (csNews == null || csNews.isEmpty()) {
            return ret;
        }
        ColumnStatistics firstColStats = (ColumnStatistics)csNews.get(0);
        ColumnStatisticsDesc statsDesc = firstColStats.getStatsDesc();
        String catName = statsDesc.isSetCatName() ? statsDesc.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        String dbName = statsDesc.getDbName();
        String tableName = statsDesc.getTableName();
        ArrayList<String> colNames = new ArrayList<String>();
        for (Object obj : firstColStats.getStatsObj()) {
            colNames.add(obj.getColName());
        }
        if (statsDesc.isIsTblLevel()) {
            if (request.getColStatsSize() != 1) {
                throw new MetaException("Expecting only 1 ColumnStatistics for table's column stats, but find " + request.getColStatsSize());
            }
            if (request.isSetNeedMerge() && request.isNeedMerge()) {
                return this.updateTableColumnStatsWithMerge(catName, dbName, tableName, colNames, request);
            }
            return this.updateTableColumnStatsInternal(firstColStats, request.getValidWriteIdList(), request.getWriteId());
        }
        HashMap<String, ColumnStatistics> newStatsMap = new HashMap<String, ColumnStatistics>();
        for (ColumnStatistics csNew : csNews) {
            String partName = csNew.getStatsDesc().getPartName();
            if (newStatsMap.containsKey(partName)) {
                MetaStoreServerUtils.mergeColStats(csNew, (ColumnStatistics)newStatsMap.get(partName));
            }
            newStatsMap.put(partName, csNew);
        }
        if (request.isSetNeedMerge() && request.isNeedMerge()) {
            ret = this.updatePartColumnStatsWithMerge(catName, dbName, tableName, colNames, newStatsMap, request);
        } else {
            Table t = this.getTable(catName, dbName, tableName);
            MTable mTable = this.getMS().ensureGetMTable(catName, dbName, tableName);
            if (MetastoreConf.getBoolVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL)) {
                ret = this.updatePartitionColStatsInBatch(t, newStatsMap, request.getValidWriteIdList(), request.getWriteId());
            } else {
                for (Map.Entry entry : newStatsMap.entrySet()) {
                    ret = this.updatePartitonColStatsInternal(t, mTable, (ColumnStatistics)entry.getValue(), request.getValidWriteIdList(), request.getWriteId()) && ret;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updatePartColumnStatsWithMerge(String catName, String dbName, String tableName, List<String> colNames, Map<String, ColumnStatistics> newStatsMap, SetPartitionsStatsRequest request) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        RawStore ms = this.getMS();
        ms.openTransaction();
        boolean isCommitted = false;
        boolean result = false;
        try {
            ArrayList<String> partitionNames = new ArrayList<String>();
            partitionNames.addAll(newStatsMap.keySet());
            List<ColumnStatistics> csOlds = ms.getPartitionColumnStatistics(catName, dbName, tableName, partitionNames, colNames, request.getEngine(), request.getValidWriteIdList());
            if (newStatsMap.values().size() != csOlds.size()) {
                LOG.debug("Some of the partitions miss stats.");
            }
            HashMap<String, ColumnStatistics> oldStatsMap = new HashMap<String, ColumnStatistics>();
            for (ColumnStatistics csOld : csOlds) {
                oldStatsMap.put(csOld.getStatsDesc().getPartName(), csOld);
            }
            List<Partition> partitions = ms.getPartitionsByNames(catName, dbName, tableName, partitionNames);
            HashMap mapToPart = new HashMap();
            for (int index = 0; index < partitionNames.size(); ++index) {
                mapToPart.put(partitionNames.get(index), partitions.get(index));
            }
            Table t = this.getTable(catName, dbName, tableName);
            MTable mTable = this.getMS().ensureGetMTable(catName, dbName, tableName);
            HashMap<String, ColumnStatistics> statsMap = new HashMap<String, ColumnStatistics>();
            boolean useDirectSql = MetastoreConf.getBoolVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL);
            for (Map.Entry<String, ColumnStatistics> entry : newStatsMap.entrySet()) {
                ColumnStatistics csNew = entry.getValue();
                ColumnStatistics csOld = (ColumnStatistics)oldStatsMap.get(entry.getKey());
                boolean isInvalidTxnStats = csOld != null && csOld.isSetIsStatsCompliant() && !csOld.isIsStatsCompliant();
                Partition part = (Partition)mapToPart.get(entry.getKey());
                if (isInvalidTxnStats) {
                    csNew.setStatsObj((List)Lists.newArrayList());
                } else {
                    MetaStoreServerUtils.getMergableCols(csNew, part.getParameters());
                    if (csOld != null && csOld.getStatsObjSize() != 0 && !csNew.getStatsObj().isEmpty()) {
                        MetaStoreServerUtils.mergeColStats(csNew, csOld);
                    }
                }
                if (!csNew.getStatsObj().isEmpty()) {
                    if (useDirectSql) {
                        statsMap.put(csNew.getStatsDesc().getPartName(), csNew);
                        continue;
                    }
                    result = this.updatePartitonColStatsInternal(t, mTable, csNew, request.getValidWriteIdList(), request.getWriteId()) && result;
                    continue;
                }
                if (isInvalidTxnStats) {
                    part.setWriteId(request.getWriteId());
                    StatsSetupConst.clearColumnStatsState((Map)part.getParameters());
                    StatsSetupConst.setBasicStatsState((Map)part.getParameters(), (String)"false");
                    ms.alterPartition(catName, dbName, tableName, part.getValues(), part, request.getValidWriteIdList());
                    result = false;
                    continue;
                }
                LOG.debug("All the column stats " + csNew.getStatsDesc().getPartName() + " are not accurate to merge.");
            }
            ms.commitTransaction();
            isCommitted = true;
            if (!statsMap.isEmpty()) {
                this.updatePartitionColStatsInBatch(t, statsMap, request.getValidWriteIdList(), request.getWriteId());
            }
        }
        finally {
            if (!isCommitted) {
                ms.rollbackTransaction();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateTableColumnStatsWithMerge(String catName, String dbName, String tableName, List<String> colNames, SetPartitionsStatsRequest request) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        ColumnStatistics firstColStats = (ColumnStatistics)request.getColStats().get(0);
        RawStore ms = this.getMS();
        ms.openTransaction();
        boolean isCommitted = false;
        boolean result = false;
        try {
            Table t;
            boolean isInvalidTxnStats;
            ColumnStatistics csOld = ms.getTableColumnStatistics(catName, dbName, tableName, colNames, request.getEngine(), request.getValidWriteIdList());
            boolean bl = isInvalidTxnStats = csOld != null && csOld.isSetIsStatsCompliant() && !csOld.isIsStatsCompliant();
            if (isInvalidTxnStats) {
                firstColStats.setStatsObj((List)Lists.newArrayList());
            } else {
                t = this.getTable(catName, dbName, tableName);
                MetaStoreServerUtils.getMergableCols(firstColStats, t.getParameters());
                if (csOld != null && csOld.getStatsObjSize() != 0 && !firstColStats.getStatsObj().isEmpty()) {
                    MetaStoreServerUtils.mergeColStats(firstColStats, csOld);
                }
            }
            if (!firstColStats.getStatsObj().isEmpty()) {
                result = this.updateTableColumnStatsInternal(firstColStats, request.getValidWriteIdList(), request.getWriteId());
            } else if (isInvalidTxnStats) {
                t = this.getTable(catName, dbName, tableName);
                t.setWriteId(request.getWriteId());
                StatsSetupConst.clearColumnStatsState((Map)t.getParameters());
                StatsSetupConst.setBasicStatsState((Map)t.getParameters(), (String)"false");
                ms.alterTable(catName, dbName, tableName, t, request.getValidWriteIdList());
            } else {
                LOG.debug("All the column stats are not accurate to merge.");
                result = true;
            }
            ms.commitTransaction();
            isCommitted = true;
        }
        finally {
            if (!isCommitted) {
                ms.rollbackTransaction();
            }
        }
        return result;
    }

    private Table getTable(String catName, String dbName, String tableName) throws MetaException, InvalidObjectException {
        return this.getTable(catName, dbName, tableName, null);
    }

    private Table getTable(String catName, String dbName, String tableName, String writeIdList) throws MetaException, InvalidObjectException {
        Table t = this.getMS().getTable(catName, dbName, tableName, writeIdList);
        if (t == null) {
            throw new InvalidObjectException(TableName.getQualified((String)catName, (String)dbName, (String)tableName) + " table not found");
        }
        return t;
    }

    public NotificationEventResponse get_next_notification(NotificationEventRequest rqst) throws TException {
        this.authorizeProxyPrivilege();
        RawStore ms = this.getMS();
        return ms.getNextNotification(rqst);
    }

    public CurrentNotificationEventId get_current_notificationEventId() throws TException {
        this.authorizeProxyPrivilege();
        RawStore ms = this.getMS();
        return ms.getCurrentNotificationEventId();
    }

    public NotificationEventsCountResponse get_notification_events_count(NotificationEventsCountRequest rqst) throws TException {
        this.authorizeProxyPrivilege();
        RawStore ms = this.getMS();
        return ms.getNotificationEventsCount(rqst);
    }

    private void authorizeProxyPrivilege() throws TException {
        if (!HiveMetaStore.isMetaStoreRemote() || !MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_DB_NOTIFICATION_API_AUTH) || this.conf.getBoolean(MetastoreConf.ConfVars.HIVE_IN_TEST.getVarname(), false)) {
            return;
        }
        String user = null;
        try {
            user = SecurityUtils.getUGI().getShortUserName();
        }
        catch (Exception ex) {
            LOG.error("Cannot obtain username", (Throwable)ex);
            throw new TException((Throwable)ex);
        }
        if (!MetaStoreServerUtils.checkUserHasHostProxyPrivileges(user, this.conf, HMSHandler.getIPAddress())) {
            LOG.error("Not authorized to make the get_notification_events_count call. You can try to disable " + MetastoreConf.ConfVars.EVENT_DB_NOTIFICATION_API_AUTH.toString());
            throw new TException("User " + user + " is not allowed to perform this API call");
        }
    }

    public FireEventResponse fire_listener_event(FireEventRequest rqst) throws TException {
        switch ((FireEventRequestData._Fields)rqst.getData().getSetField()) {
            case INSERT_DATA: 
            case INSERT_DATAS: {
                String catName = rqst.isSetCatName() ? rqst.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
                String dbName = rqst.getDbName();
                String tblName = rqst.getTableName();
                boolean isSuccessful = rqst.isSuccessful();
                ArrayList<InsertEvent> events = new ArrayList<InsertEvent>();
                if (rqst.getData().isSetInsertData()) {
                    events.add(new InsertEvent(catName, dbName, tblName, rqst.getPartitionVals(), rqst.getData().getInsertData(), isSuccessful, this));
                } else {
                    for (Object insertData : rqst.getData().getInsertDatas()) {
                        if (!insertData.isSetPartitionVal()) {
                            throw new MetaException("Partition values must be set when firing multiple insert events");
                        }
                        events.add(new InsertEvent(catName, dbName, tblName, insertData.getPartitionVal(), (InsertEventRequestData)insertData, isSuccessful, this));
                    }
                }
                FireEventResponse response = new FireEventResponse();
                for (InsertEvent event : events) {
                    MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.INSERT, event);
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.INSERT, event);
                    if (event.getParameters() != null && event.getParameters().containsKey("DB_NOTIFICATION_EVENT_ID_KEY_NAME")) {
                        response.addToEventIds(Long.valueOf(event.getParameters().get("DB_NOTIFICATION_EVENT_ID_KEY_NAME")).longValue());
                        continue;
                    }
                    String msg = "Insert event id not generated for ";
                    if (event.getPartitionObj() != null) {
                        msg = msg + "partition " + Arrays.toString(event.getPartitionObj().getValues().toArray()) + " of ";
                    }
                    msg = msg + " of table " + event.getTableObj().getDbName() + "." + event.getTableObj().getTableName();
                    LOG.warn(msg);
                }
                return response;
            }
            case REFRESH_EVENT: {
                FireEventResponse response = new FireEventResponse();
                String catName = rqst.isSetCatName() ? rqst.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
                String dbName = rqst.getDbName();
                String tblName = rqst.getTableName();
                List partitionVals = rqst.getPartitionVals();
                Map tableParams = rqst.getTblParams();
                ReloadEvent event = new ReloadEvent(catName, dbName, tblName, partitionVals, rqst.isSuccessful(), rqst.getData().getRefreshEvent(), tableParams, this);
                MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.RELOAD, event);
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.RELOAD, event);
                if (event.getParameters() != null && event.getParameters().containsKey("DB_NOTIFICATION_EVENT_ID_KEY_NAME")) {
                    response.addToEventIds(Long.valueOf(event.getParameters().get("DB_NOTIFICATION_EVENT_ID_KEY_NAME")).longValue());
                } else {
                    String msg = "Reload event id not generated for ";
                    if (event.getPartitionObj() != null) {
                        msg = msg + "partition " + Arrays.toString(event.getPartitionObj().getValues().toArray()) + " of ";
                    }
                    msg = msg + " of table " + event.getTableObj().getDbName() + "." + event.getTableObj().getTableName();
                    LOG.warn(msg);
                }
                return response;
            }
        }
        throw new TException("Event type " + ((FireEventRequestData._Fields)rqst.getData().getSetField()).toString() + " not currently supported.");
    }

    public GetFileMetadataByExprResult get_file_metadata_by_expr(GetFileMetadataByExprRequest req) throws TException {
        GetFileMetadataByExprResult result = new GetFileMetadataByExprResult();
        RawStore ms = this.getMS();
        if (!ms.isFileMetadataSupported()) {
            result.setIsSupported(false);
            result.setMetadata(Collections.emptyMap());
            return result;
        }
        result.setIsSupported(true);
        List fileIds = req.getFileIds();
        boolean needMetadata = !req.isSetDoGetFooters() || req.isDoGetFooters();
        FileMetadataExprType type = req.isSetType() ? req.getType() : FileMetadataExprType.ORC_SARG;
        ByteBuffer[] metadatas = needMetadata ? new ByteBuffer[fileIds.size()] : null;
        ByteBuffer[] ppdResults = new ByteBuffer[fileIds.size()];
        boolean[] eliminated = new boolean[fileIds.size()];
        this.getMS().getFileMetadataByExpr(fileIds, type, req.getExpr(), metadatas, ppdResults, eliminated);
        for (int i = 0; i < fileIds.size(); ++i) {
            if (!eliminated[i] && ppdResults[i] == null) continue;
            MetadataPpdResult mpr = new MetadataPpdResult();
            ByteBuffer ppdResult = eliminated[i] ? null : this.handleReadOnlyBufferForThrift(ppdResults[i]);
            mpr.setIncludeBitset(ppdResult);
            if (needMetadata) {
                ByteBuffer metadata = eliminated[i] ? null : this.handleReadOnlyBufferForThrift(metadatas[i]);
                mpr.setMetadata(metadata);
            }
            result.putToMetadata(((Long)fileIds.get(i)).longValue(), mpr);
        }
        if (!result.isSetMetadata()) {
            result.setMetadata(Collections.emptyMap());
        }
        return result;
    }

    public GetFileMetadataResult get_file_metadata(GetFileMetadataRequest req) throws TException {
        GetFileMetadataResult result = new GetFileMetadataResult();
        RawStore ms = this.getMS();
        if (!ms.isFileMetadataSupported()) {
            result.setIsSupported(false);
            result.setMetadata(Collections.emptyMap());
            return result;
        }
        result.setIsSupported(true);
        List fileIds = req.getFileIds();
        ByteBuffer[] metadatas = ms.getFileMetadata(fileIds);
        assert (metadatas.length == fileIds.size());
        for (int i = 0; i < metadatas.length; ++i) {
            ByteBuffer bb = metadatas[i];
            if (bb == null) continue;
            bb = this.handleReadOnlyBufferForThrift(bb);
            result.putToMetadata(((Long)fileIds.get(i)).longValue(), bb);
        }
        if (!result.isSetMetadata()) {
            result.setMetadata(Collections.emptyMap());
        }
        return result;
    }

    private ByteBuffer handleReadOnlyBufferForThrift(ByteBuffer bb) {
        if (!bb.isReadOnly()) {
            return bb;
        }
        ByteBuffer copy = ByteBuffer.allocate(bb.capacity());
        copy.put(bb);
        copy.flip();
        return copy;
    }

    public PutFileMetadataResult put_file_metadata(PutFileMetadataRequest req) throws TException {
        RawStore ms = this.getMS();
        if (ms.isFileMetadataSupported()) {
            ms.putFileMetadata(req.getFileIds(), req.getMetadata(), req.getType());
        }
        return new PutFileMetadataResult();
    }

    public ClearFileMetadataResult clear_file_metadata(ClearFileMetadataRequest req) throws TException {
        this.getMS().putFileMetadata(req.getFileIds(), null, null);
        return new ClearFileMetadataResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheFileMetadataResult cache_file_metadata(CacheFileMetadataRequest req) throws TException {
        RawStore ms = this.getMS();
        if (!ms.isFileMetadataSupported()) {
            return new CacheFileMetadataResult(false);
        }
        String dbName = req.getDbName();
        String tblName = req.getTblName();
        String partName = req.isSetPartName() ? req.getPartName() : null;
        boolean isAllPart = req.isSetIsAllParts() && req.isIsAllParts();
        ms.openTransaction();
        boolean success = false;
        try {
            String tableInputFormat;
            Table tbl = ms.getTable(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName);
            if (tbl == null) {
                throw new NoSuchObjectException(dbName + "." + tblName + " not found");
            }
            boolean isPartitioned = tbl.isSetPartitionKeys() && tbl.getPartitionKeysSize() > 0;
            String string = tableInputFormat = tbl.isSetSd() ? tbl.getSd().getInputFormat() : null;
            if (!isPartitioned) {
                if (partName != null || isAllPart) {
                    throw new MetaException("Table is not partitioned");
                }
                if (!tbl.isSetSd() || !tbl.getSd().isSetLocation()) {
                    throw new MetaException("Table does not have storage location; this operation is not supported on views");
                }
                FileMetadataExprType type = this.expressionProxy.getMetadataType(tableInputFormat);
                if (type == null) {
                    throw new MetaException("The operation is not supported for " + tableInputFormat);
                }
                this.fileMetadataManager.queueCacheMetadata(tbl.getSd().getLocation(), type);
                success = true;
            } else {
                List<Object> partNames;
                if (partName != null) {
                    partNames = Lists.newArrayList((Object[])new String[]{partName});
                } else if (isAllPart) {
                    partNames = ms.listPartitionNames(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, (short)-1);
                } else {
                    throw new MetaException("Table is partitioned");
                }
                int batchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_OBJECTS_MAX);
                int index = 0;
                int successCount = 0;
                int failCount = 0;
                HashSet<String> failFormats = null;
                while (index < partNames.size()) {
                    int currentBatchSize = Math.min(batchSize, partNames.size() - index);
                    List<Object> nameBatch = partNames.subList(index, index + currentBatchSize);
                    index += currentBatchSize;
                    List<Partition> parts = ms.getPartitionsByNames(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, nameBatch);
                    for (Partition part : parts) {
                        if (!part.isSetSd() || !part.getSd().isSetLocation()) {
                            throw new MetaException("Partition does not have storage location; this operation is not supported on views");
                        }
                        String inputFormat = part.getSd().isSetInputFormat() ? part.getSd().getInputFormat() : tableInputFormat;
                        FileMetadataExprType type = this.expressionProxy.getMetadataType(inputFormat);
                        if (type == null) {
                            ++failCount;
                            if (failFormats == null) {
                                failFormats = new HashSet<String>();
                            }
                            failFormats.add(inputFormat);
                            continue;
                        }
                        ++successCount;
                        this.fileMetadataManager.queueCacheMetadata(part.getSd().getLocation(), type);
                    }
                }
                success = true;
                if (failCount > 0) {
                    String errorMsg = "The operation failed for " + failCount + " partitions and succeeded for " + successCount + " partitions; unsupported formats: ";
                    boolean isFirst = true;
                    for (String s : failFormats) {
                        if (!isFirst) {
                            errorMsg = errorMsg + ", ";
                        }
                        isFirst = false;
                        errorMsg = errorMsg + s;
                    }
                    throw new MetaException(errorMsg);
                }
            }
        }
        finally {
            if (success) {
                if (!ms.commitTransaction()) {
                    throw new MetaException("Failed to commit");
                }
            } else {
                ms.rollbackTransaction();
            }
        }
        return new CacheFileMetadataResult(true);
    }

    @VisibleForTesting
    void updateMetrics() throws MetaException {
        if (Metrics.getRegistry() != null) {
            LOG.info("Begin calculating metadata count metrics.");
            Metrics.getOrCreateGauge("total_count_dbs").set(this.getMS().getTableCount());
            Metrics.getOrCreateGauge("total_count_tables").set(this.getMS().getPartitionCount());
            Metrics.getOrCreateGauge("total_count_partitions").set(this.getMS().getDatabaseCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimaryKeysResponse get_primary_keys(PrimaryKeysRequest request) throws TException {
        request.setCatName(request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        this.startTableFunction("get_primary_keys", request.getCatName(), request.getDb_name(), request.getTbl_name());
        List<SQLPrimaryKey> ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getPrimaryKeys(request);
            this.endFunction("get_primary_keys", ret != null, ex, request.getTbl_name());
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.throwMetaException(e);
                this.endFunction("get_primary_keys", ret != null, ex, request.getTbl_name());
            }
            catch (Throwable throwable) {
                this.endFunction("get_primary_keys", ret != null, ex, request.getTbl_name());
                throw throwable;
            }
        }
        return new PrimaryKeysResponse(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForeignKeysResponse get_foreign_keys(ForeignKeysRequest request) throws TException {
        request.setCatName(request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        this.startFunction("get_foreign_keys", " : parentdb=" + request.getParent_db_name() + " parenttbl=" + request.getParent_tbl_name() + " foreigndb=" + request.getForeign_db_name() + " foreigntbl=" + request.getForeign_tbl_name());
        List<SQLForeignKey> ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getForeignKeys(request);
            this.endFunction("get_foreign_keys", ret != null, ex, request.getForeign_tbl_name());
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.throwMetaException(e);
                this.endFunction("get_foreign_keys", ret != null, ex, request.getForeign_tbl_name());
            }
            catch (Throwable throwable) {
                this.endFunction("get_foreign_keys", ret != null, ex, request.getForeign_tbl_name());
                throw throwable;
            }
        }
        return new ForeignKeysResponse(ret);
    }

    public UniqueConstraintsResponse get_unique_constraints(UniqueConstraintsRequest request) throws TException {
        request.setCatName(request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        this.startTableFunction("get_unique_constraints", request.getCatName(), request.getDb_name(), request.getTbl_name());
        List<SQLUniqueConstraint> ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getUniqueConstraints(request);
            this.endFunction("get_unique_constraints", ret != null, ex, request.getTbl_name());
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_unique_constraints", ret != null, ex, request.getTbl_name());
                throw throwable;
            }
        }
        return new UniqueConstraintsResponse(ret);
    }

    public NotNullConstraintsResponse get_not_null_constraints(NotNullConstraintsRequest request) throws TException {
        request.setCatName(request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        this.startTableFunction("get_not_null_constraints", request.getCatName(), request.getDb_name(), request.getTbl_name());
        List<SQLNotNullConstraint> ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getNotNullConstraints(request);
            this.endFunction("get_not_null_constraints", ret != null, ex, request.getTbl_name());
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_not_null_constraints", ret != null, ex, request.getTbl_name());
                throw throwable;
            }
        }
        return new NotNullConstraintsResponse(ret);
    }

    public DefaultConstraintsResponse get_default_constraints(DefaultConstraintsRequest request) throws TException {
        request.setCatName(request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        this.startTableFunction("get_default_constraints", request.getCatName(), request.getDb_name(), request.getTbl_name());
        List<SQLDefaultConstraint> ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getDefaultConstraints(request);
            this.endFunction("get_default_constraints", ret != null, ex, request.getTbl_name());
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_default_constraints", ret != null, ex, request.getTbl_name());
                throw throwable;
            }
        }
        return new DefaultConstraintsResponse(ret);
    }

    public CheckConstraintsResponse get_check_constraints(CheckConstraintsRequest request) throws TException {
        request.setCatName(request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        this.startTableFunction("get_check_constraints", request.getCatName(), request.getDb_name(), request.getTbl_name());
        List<SQLCheckConstraint> ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getCheckConstraints(request);
            this.endFunction("get_check_constraints", ret != null, ex, request.getTbl_name());
        }
        catch (Exception e) {
            try {
                ex = e;
                throw ExceptionHandler.newMetaException(e);
            }
            catch (Throwable throwable) {
                this.endFunction("get_check_constraints", ret != null, ex, request.getTbl_name());
                throw throwable;
            }
        }
        return new CheckConstraintsResponse(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllTableConstraintsResponse get_all_table_constraints(AllTableConstraintsRequest request) throws TException, MetaException, NoSuchObjectException {
        request.setCatName(request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        this.startTableFunction("get_all_table_constraints", request.getCatName(), request.getDbName(), request.getTblName());
        SQLAllTableConstraints ret = null;
        Exception ex = null;
        try {
            ret = this.getMS().getAllTableConstraints(request);
            this.endFunction("get_all_table_constraints", ret != null, ex, request.getTblName());
        }
        catch (Exception e) {
            try {
                ex = e;
                ExceptionHandler.throwMetaException(e);
                this.endFunction("get_all_table_constraints", ret != null, ex, request.getTblName());
            }
            catch (Throwable throwable) {
                this.endFunction("get_all_table_constraints", ret != null, ex, request.getTblName());
                throw throwable;
            }
        }
        return new AllTableConstraintsResponse(ret);
    }

    public String get_metastore_db_uuid() throws TException {
        try {
            return this.getMS().getMetastoreDbUuid();
        }
        catch (MetaException e) {
            LOG.error("Exception thrown while querying metastore db uuid", (Throwable)e);
            throw e;
        }
    }

    public WMCreateResourcePlanResponse create_resource_plan(WMCreateResourcePlanRequest request) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        int defaultPoolSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WM_DEFAULT_POOL_SIZE);
        WMResourcePlan plan = request.getResourcePlan();
        if (defaultPoolSize > 0 && plan.isSetQueryParallelism()) {
            defaultPoolSize = plan.getQueryParallelism();
        }
        try {
            this.getMS().createResourcePlan(plan, request.getCopyFrom(), defaultPoolSize);
            return new WMCreateResourcePlanResponse();
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to persist resource plan", (Throwable)e);
            throw e;
        }
    }

    public WMGetResourcePlanResponse get_resource_plan(WMGetResourcePlanRequest request) throws NoSuchObjectException, MetaException, TException {
        try {
            WMFullResourcePlan rp = this.getMS().getResourcePlan(request.getResourcePlanName(), request.getNs());
            WMGetResourcePlanResponse resp = new WMGetResourcePlanResponse();
            resp.setResourcePlan(rp);
            return resp;
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to retrieve resource plan", (Throwable)e);
            throw e;
        }
    }

    public WMGetAllResourcePlanResponse get_all_resource_plans(WMGetAllResourcePlanRequest request) throws MetaException, TException {
        try {
            WMGetAllResourcePlanResponse resp = new WMGetAllResourcePlanResponse();
            resp.setResourcePlans(this.getMS().getAllResourcePlans(request.getNs()));
            return resp;
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to retrieve resource plans", (Throwable)e);
            throw e;
        }
    }

    public WMAlterResourcePlanResponse alter_resource_plan(WMAlterResourcePlanRequest request) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try {
            if ((request.isIsEnableAndActivate() ? 1 : 0) + (request.isIsReplace() ? 1 : 0) + (request.isIsForceDeactivate() ? 1 : 0) > 1) {
                throw new MetaException("Invalid request; multiple flags are set");
            }
            WMAlterResourcePlanResponse response = new WMAlterResourcePlanResponse();
            WMFullResourcePlan fullPlanAfterAlter = this.getMS().alterResourcePlan(request.getResourcePlanName(), request.getNs(), request.getResourcePlan(), request.isIsEnableAndActivate(), request.isIsForceDeactivate(), request.isIsReplace());
            if (fullPlanAfterAlter != null) {
                response.setFullResourcePlan(fullPlanAfterAlter);
            }
            return response;
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to alter resource plan", (Throwable)e);
            throw e;
        }
    }

    public WMGetActiveResourcePlanResponse get_active_resource_plan(WMGetActiveResourcePlanRequest request) throws MetaException, TException {
        try {
            WMGetActiveResourcePlanResponse response = new WMGetActiveResourcePlanResponse();
            response.setResourcePlan(this.getMS().getActiveResourcePlan(request.getNs()));
            return response;
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to get active resource plan", (Throwable)e);
            throw e;
        }
    }

    public WMValidateResourcePlanResponse validate_resource_plan(WMValidateResourcePlanRequest request) throws NoSuchObjectException, MetaException, TException {
        try {
            return this.getMS().validateResourcePlan(request.getResourcePlanName(), request.getNs());
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to validate resource plan", (Throwable)e);
            throw e;
        }
    }

    public WMDropResourcePlanResponse drop_resource_plan(WMDropResourcePlanRequest request) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try {
            this.getMS().dropResourcePlan(request.getResourcePlanName(), request.getNs());
            return new WMDropResourcePlanResponse();
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to drop resource plan", (Throwable)e);
            throw e;
        }
    }

    public WMCreateTriggerResponse create_wm_trigger(WMCreateTriggerRequest request) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        try {
            this.getMS().createWMTrigger(request.getTrigger());
            return new WMCreateTriggerResponse();
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to create trigger", (Throwable)e);
            throw e;
        }
    }

    public WMAlterTriggerResponse alter_wm_trigger(WMAlterTriggerRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        try {
            this.getMS().alterWMTrigger(request.getTrigger());
            return new WMAlterTriggerResponse();
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to alter trigger", (Throwable)e);
            throw e;
        }
    }

    public WMDropTriggerResponse drop_wm_trigger(WMDropTriggerRequest request) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try {
            this.getMS().dropWMTrigger(request.getResourcePlanName(), request.getTriggerName(), request.getNs());
            return new WMDropTriggerResponse();
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to drop trigger.", (Throwable)e);
            throw e;
        }
    }

    public WMGetTriggersForResourePlanResponse get_triggers_for_resourceplan(WMGetTriggersForResourePlanRequest request) throws NoSuchObjectException, MetaException, TException {
        try {
            List<WMTrigger> triggers = this.getMS().getTriggersForResourcePlan(request.getResourcePlanName(), request.getNs());
            WMGetTriggersForResourePlanResponse response = new WMGetTriggersForResourePlanResponse();
            response.setTriggers(triggers);
            return response;
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to retrieve triggers plans", (Throwable)e);
            throw e;
        }
    }

    public WMAlterPoolResponse alter_wm_pool(WMAlterPoolRequest request) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        try {
            this.getMS().alterPool(request.getPool(), request.getPoolPath());
            return new WMAlterPoolResponse();
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to alter WMPool", (Throwable)e);
            throw e;
        }
    }

    public WMCreatePoolResponse create_wm_pool(WMCreatePoolRequest request) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        try {
            this.getMS().createPool(request.getPool());
            return new WMCreatePoolResponse();
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to create WMPool", (Throwable)e);
            throw e;
        }
    }

    public WMDropPoolResponse drop_wm_pool(WMDropPoolRequest request) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try {
            this.getMS().dropWMPool(request.getResourcePlanName(), request.getPoolPath(), request.getNs());
            return new WMDropPoolResponse();
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to drop WMPool", (Throwable)e);
            throw e;
        }
    }

    public WMCreateOrUpdateMappingResponse create_or_update_wm_mapping(WMCreateOrUpdateMappingRequest request) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        try {
            this.getMS().createOrUpdateWMMapping(request.getMapping(), request.isUpdate());
            return new WMCreateOrUpdateMappingResponse();
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to create or update WMMapping", (Throwable)e);
            throw e;
        }
    }

    public WMDropMappingResponse drop_wm_mapping(WMDropMappingRequest request) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try {
            this.getMS().dropWMMapping(request.getMapping());
            return new WMDropMappingResponse();
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to drop WMMapping", (Throwable)e);
            throw e;
        }
    }

    public WMCreateOrDropTriggerToPoolMappingResponse create_or_drop_wm_trigger_to_pool_mapping(WMCreateOrDropTriggerToPoolMappingRequest request) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        try {
            if (request.isDrop()) {
                this.getMS().dropWMTriggerToPoolMapping(request.getResourcePlanName(), request.getTriggerName(), request.getPoolPath(), request.getNs());
            } else {
                this.getMS().createWMTriggerToPoolMapping(request.getResourcePlanName(), request.getTriggerName(), request.getPoolPath(), request.getNs());
            }
            return new WMCreateOrDropTriggerToPoolMappingResponse();
        }
        catch (MetaException e) {
            LOG.error("Exception while trying to create or drop pool mappings", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create_ischema(ISchema schema) throws TException {
        this.startFunction("create_ischema", ": " + schema.getName());
        boolean success = false;
        Throwable ex = null;
        RawStore ms = this.getMS();
        try {
            this.firePreEvent(new PreCreateISchemaEvent(this, schema));
            Map<String, String> transactionalListenersResponses = Collections.emptyMap();
            ms.openTransaction();
            try {
                ms.createISchema(schema);
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.CREATE_ISCHEMA, new CreateISchemaEvent(true, this, schema));
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_ISCHEMA, new CreateISchemaEvent(success, this, schema), null, transactionalListenersResponses, ms);
                }
            }
            this.endFunction("create_ischema", success, (Exception)ex);
        }
        catch (AlreadyExistsException | MetaException e) {
            try {
                LOG.error("Caught exception creating schema", e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("create_ischema", success, (Exception)ex);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alter_ischema(AlterISchemaRequest rqst) throws TException {
        this.startFunction("alter_ischema", ": " + rqst);
        boolean success = false;
        Throwable ex = null;
        RawStore ms = this.getMS();
        try {
            ISchema oldSchema = ms.getISchema(rqst.getName());
            if (oldSchema == null) {
                throw new NoSuchObjectException("Could not find schema " + rqst.getName());
            }
            this.firePreEvent(new PreAlterISchemaEvent(this, oldSchema, rqst.getNewSchema()));
            Map<String, String> transactionalListenersResponses = Collections.emptyMap();
            ms.openTransaction();
            try {
                ms.alterISchema(rqst.getName(), rqst.getNewSchema());
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_ISCHEMA, new AlterISchemaEvent(true, this, oldSchema, rqst.getNewSchema()));
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_ISCHEMA, new AlterISchemaEvent(success, this, oldSchema, rqst.getNewSchema()), null, transactionalListenersResponses, ms);
                }
            }
            this.endFunction("alter_ischema", success, (Exception)ex);
        }
        catch (MetaException | NoSuchObjectException e) {
            try {
                LOG.error("Caught exception altering schema", e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("alter_ischema", success, (Exception)ex);
                throw throwable;
            }
        }
    }

    public ISchema get_ischema(ISchemaName schemaName) throws TException {
        this.startFunction("get_ischema", ": " + schemaName);
        MetaException ex = null;
        ISchema schema = null;
        try {
            schema = this.getMS().getISchema(schemaName);
            if (schema == null) {
                throw new NoSuchObjectException("No schema named " + schemaName + " exists");
            }
            this.firePreEvent(new PreReadISchemaEvent(this, schema));
            ISchema iSchema = schema;
            this.endFunction("get_ischema", schema != null, (Exception)((Object)ex));
            return iSchema;
        }
        catch (MetaException e) {
            try {
                LOG.error("Caught exception getting schema", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_ischema", schema != null, (Exception)((Object)ex));
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop_ischema(ISchemaName schemaName) throws TException {
        this.startFunction("drop_ischema", ": " + schemaName);
        Throwable ex = null;
        boolean success = false;
        RawStore ms = this.getMS();
        try {
            SchemaVersion latest = ms.getLatestSchemaVersion(schemaName);
            if (latest != null) {
                ex = new InvalidOperationException("Schema " + schemaName + " cannot be dropped, it has at least one valid version");
                throw (InvalidObjectException)ex;
            }
            ISchema schema = ms.getISchema(schemaName);
            this.firePreEvent(new PreDropISchemaEvent(this, schema));
            Map<String, String> transactionalListenersResponses = Collections.emptyMap();
            ms.openTransaction();
            try {
                ms.dropISchema(schemaName);
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_ISCHEMA, new DropISchemaEvent(true, this, schema));
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_ISCHEMA, new DropISchemaEvent(success, this, schema), null, transactionalListenersResponses, ms);
                }
            }
            this.endFunction("drop_ischema", success, (Exception)ex);
        }
        catch (MetaException | NoSuchObjectException e) {
            try {
                LOG.error("Caught exception dropping schema", e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("drop_ischema", success, (Exception)ex);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add_schema_version(SchemaVersion schemaVersion) throws TException {
        this.startFunction("add_schema_version", ": " + schemaVersion);
        boolean success = false;
        Throwable ex = null;
        RawStore ms = this.getMS();
        try {
            if (ms.getISchema(schemaVersion.getSchema()) == null) {
                throw new NoSuchObjectException("No schema named " + schemaVersion.getSchema());
            }
            this.firePreEvent(new PreAddSchemaVersionEvent(this, schemaVersion));
            Map<String, String> transactionalListenersResponses = Collections.emptyMap();
            ms.openTransaction();
            try {
                ms.addSchemaVersion(schemaVersion);
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_SCHEMA_VERSION, new AddSchemaVersionEvent(true, this, schemaVersion));
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_SCHEMA_VERSION, new AddSchemaVersionEvent(success, this, schemaVersion), null, transactionalListenersResponses, ms);
                }
            }
            this.endFunction("add_schema_version", success, (Exception)ex);
        }
        catch (AlreadyExistsException | MetaException e) {
            try {
                LOG.error("Caught exception adding schema version", e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("add_schema_version", success, (Exception)ex);
                throw throwable;
            }
        }
    }

    public SchemaVersion get_schema_version(SchemaVersionDescriptor version) throws TException {
        this.startFunction("get_schema_version", ": " + version);
        MetaException ex = null;
        SchemaVersion schemaVersion = null;
        try {
            schemaVersion = this.getMS().getSchemaVersion(version);
            if (schemaVersion == null) {
                throw new NoSuchObjectException("No schema version " + version + "exists");
            }
            this.firePreEvent(new PreReadhSchemaVersionEvent(this, Collections.singletonList(schemaVersion)));
            SchemaVersion schemaVersion2 = schemaVersion;
            this.endFunction("get_schema_version", schemaVersion != null, (Exception)((Object)ex));
            return schemaVersion2;
        }
        catch (MetaException e) {
            try {
                LOG.error("Caught exception getting schema version", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_schema_version", schemaVersion != null, (Exception)((Object)ex));
                throw throwable;
            }
        }
    }

    public SchemaVersion get_schema_latest_version(ISchemaName schemaName) throws TException {
        this.startFunction("get_latest_schema_version", ": " + schemaName);
        MetaException ex = null;
        SchemaVersion schemaVersion = null;
        try {
            schemaVersion = this.getMS().getLatestSchemaVersion(schemaName);
            if (schemaVersion == null) {
                throw new NoSuchObjectException("No versions of schema " + schemaName + "exist");
            }
            this.firePreEvent(new PreReadhSchemaVersionEvent(this, Collections.singletonList(schemaVersion)));
            SchemaVersion schemaVersion2 = schemaVersion;
            this.endFunction("get_latest_schema_version", schemaVersion != null, (Exception)((Object)ex));
            return schemaVersion2;
        }
        catch (MetaException e) {
            try {
                LOG.error("Caught exception getting latest schema version", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_latest_schema_version", schemaVersion != null, (Exception)((Object)ex));
                throw throwable;
            }
        }
    }

    public List<SchemaVersion> get_schema_all_versions(ISchemaName schemaName) throws TException {
        this.startFunction("get_all_schema_versions", ": " + schemaName);
        MetaException ex = null;
        List<SchemaVersion> schemaVersions = null;
        try {
            schemaVersions = this.getMS().getAllSchemaVersion(schemaName);
            if (schemaVersions == null) {
                throw new NoSuchObjectException("No versions of schema " + schemaName + "exist");
            }
            this.firePreEvent(new PreReadhSchemaVersionEvent(this, schemaVersions));
            List<SchemaVersion> list = schemaVersions;
            this.endFunction("get_all_schema_versions", schemaVersions != null, (Exception)((Object)ex));
            return list;
        }
        catch (MetaException e) {
            try {
                LOG.error("Caught exception getting all schema versions", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_all_schema_versions", schemaVersions != null, (Exception)((Object)ex));
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop_schema_version(SchemaVersionDescriptor version) throws TException {
        this.startFunction("drop_schema_version", ": " + version);
        Throwable ex = null;
        boolean success = false;
        RawStore ms = this.getMS();
        try {
            SchemaVersion schemaVersion = ms.getSchemaVersion(version);
            if (schemaVersion == null) {
                throw new NoSuchObjectException("No schema version " + version);
            }
            this.firePreEvent(new PreDropSchemaVersionEvent(this, schemaVersion));
            Map<String, String> transactionalListenersResponses = Collections.emptyMap();
            ms.openTransaction();
            try {
                ms.dropSchemaVersion(version);
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_SCHEMA_VERSION, new DropSchemaVersionEvent(true, this, schemaVersion));
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_SCHEMA_VERSION, new DropSchemaVersionEvent(success, this, schemaVersion), null, transactionalListenersResponses, ms);
                }
            }
            this.endFunction("drop_schema_version", success, (Exception)ex);
        }
        catch (MetaException | NoSuchObjectException e) {
            try {
                LOG.error("Caught exception dropping schema version", e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("drop_schema_version", success, (Exception)ex);
                throw throwable;
            }
        }
    }

    public FindSchemasByColsResp get_schemas_by_cols(FindSchemasByColsRqst rqst) throws TException {
        this.startFunction("get_schemas_by_cols");
        MetaException ex = null;
        List<SchemaVersion> schemaVersions = Collections.emptyList();
        try {
            schemaVersions = this.getMS().getSchemaVersionsByColumns(rqst.getColName(), rqst.getColNamespace(), rqst.getType());
            this.firePreEvent(new PreReadhSchemaVersionEvent(this, schemaVersions));
            ArrayList entries = new ArrayList(schemaVersions.size());
            schemaVersions.forEach(schemaVersion -> entries.add(new SchemaVersionDescriptor(schemaVersion.getSchema(), schemaVersion.getVersion())));
            FindSchemasByColsResp findSchemasByColsResp = new FindSchemasByColsResp(entries);
            this.endFunction("get_schemas_by_cols", !schemaVersions.isEmpty(), (Exception)((Object)ex));
            return findSchemasByColsResp;
        }
        catch (MetaException e) {
            try {
                LOG.error("Caught exception doing schema version query", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_schemas_by_cols", !schemaVersions.isEmpty(), (Exception)((Object)ex));
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map_schema_version_to_serde(MapSchemaVersionToSerdeRequest rqst) throws TException {
        this.startFunction("map_schema_version_to_serde, :" + rqst);
        boolean success = false;
        Throwable ex = null;
        RawStore ms = this.getMS();
        try {
            SchemaVersion oldSchemaVersion = ms.getSchemaVersion(rqst.getSchemaVersion());
            if (oldSchemaVersion == null) {
                throw new NoSuchObjectException("No schema version " + rqst.getSchemaVersion());
            }
            SerDeInfo serde = ms.getSerDeInfo(rqst.getSerdeName());
            if (serde == null) {
                throw new NoSuchObjectException("No SerDe named " + rqst.getSerdeName());
            }
            SchemaVersion newSchemaVersion = new SchemaVersion(oldSchemaVersion);
            newSchemaVersion.setSerDe(serde);
            this.firePreEvent(new PreAlterSchemaVersionEvent(this, oldSchemaVersion, newSchemaVersion));
            Map<String, String> transactionalListenersResponses = Collections.emptyMap();
            ms.openTransaction();
            try {
                ms.alterSchemaVersion(rqst.getSchemaVersion(), newSchemaVersion);
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_SCHEMA_VERSION, new AlterSchemaVersionEvent(true, this, oldSchemaVersion, newSchemaVersion));
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_SCHEMA_VERSION, new AlterSchemaVersionEvent(success, this, oldSchemaVersion, newSchemaVersion), null, transactionalListenersResponses, ms);
                }
            }
            this.endFunction("map_schema_version_to_serde", success, (Exception)ex);
        }
        catch (MetaException | NoSuchObjectException e) {
            try {
                LOG.error("Caught exception mapping schema version to serde", e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("map_schema_version_to_serde", success, (Exception)ex);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_schema_version_state(SetSchemaVersionStateRequest rqst) throws TException {
        this.startFunction("set_schema_version_state, :" + rqst);
        boolean success = false;
        Throwable ex = null;
        RawStore ms = this.getMS();
        try {
            SchemaVersion oldSchemaVersion = ms.getSchemaVersion(rqst.getSchemaVersion());
            if (oldSchemaVersion == null) {
                throw new NoSuchObjectException("No schema version " + rqst.getSchemaVersion());
            }
            SchemaVersion newSchemaVersion = new SchemaVersion(oldSchemaVersion);
            newSchemaVersion.setState(rqst.getState());
            this.firePreEvent(new PreAlterSchemaVersionEvent(this, oldSchemaVersion, newSchemaVersion));
            Map<String, String> transactionalListenersResponses = Collections.emptyMap();
            ms.openTransaction();
            try {
                ms.alterSchemaVersion(rqst.getSchemaVersion(), newSchemaVersion);
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_SCHEMA_VERSION, new AlterSchemaVersionEvent(true, this, oldSchemaVersion, newSchemaVersion));
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_SCHEMA_VERSION, new AlterSchemaVersionEvent(success, this, oldSchemaVersion, newSchemaVersion), null, transactionalListenersResponses, ms);
                }
            }
            this.endFunction("set_schema_version_state", success, (Exception)ex);
        }
        catch (MetaException | NoSuchObjectException e) {
            try {
                LOG.error("Caught exception changing schema version state", e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("set_schema_version_state", success, (Exception)ex);
                throw throwable;
            }
        }
    }

    public void add_serde(SerDeInfo serde) throws TException {
        this.startFunction("create_serde", ": " + serde.getName());
        Throwable ex = null;
        boolean success = false;
        RawStore ms = this.getMS();
        try {
            ms.openTransaction();
            ms.addSerde(serde);
            success = ms.commitTransaction();
        }
        catch (AlreadyExistsException | MetaException e) {
            LOG.error("Caught exception creating serde", e);
            ex = e;
            throw e;
        }
        finally {
            if (!success) {
                ms.rollbackTransaction();
            }
            this.endFunction("create_serde", success, (Exception)ex);
        }
    }

    public SerDeInfo get_serde(GetSerdeRequest rqst) throws TException {
        this.startFunction("get_serde", ": " + rqst);
        MetaException ex = null;
        SerDeInfo serde = null;
        try {
            serde = this.getMS().getSerDeInfo(rqst.getSerdeName());
            if (serde == null) {
                throw new NoSuchObjectException("No serde named " + rqst.getSerdeName() + " exists");
            }
            SerDeInfo serDeInfo = serde;
            this.endFunction("get_serde", serde != null, (Exception)((Object)ex));
            return serDeInfo;
        }
        catch (MetaException e) {
            try {
                LOG.error("Caught exception getting serde", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_serde", serde != null, (Exception)((Object)ex));
                throw throwable;
            }
        }
    }

    public LockResponse get_lock_materialization_rebuild(String dbName, String tableName, long txnId) throws TException {
        return this.getTxnHandler().lockMaterializationRebuild(dbName, tableName, txnId);
    }

    public boolean heartbeat_lock_materialization_rebuild(String dbName, String tableName, long txnId) throws TException {
        return this.getTxnHandler().heartbeatLockMaterializationRebuild(dbName, tableName, txnId);
    }

    public void add_runtime_stats(RuntimeStat stat) throws TException {
        this.startFunction("store_runtime_stats");
        Exception ex = null;
        boolean success = false;
        RawStore ms = this.getMS();
        try {
            ms.openTransaction();
            ms.addRuntimeStat(stat);
            success = ms.commitTransaction();
        }
        catch (Exception e) {
            LOG.error("Caught exception", (Throwable)e);
            ex = e;
            throw e;
        }
        finally {
            if (!success) {
                ms.rollbackTransaction();
            }
            this.endFunction("store_runtime_stats", success, ex);
        }
    }

    public List<RuntimeStat> get_runtime_stats(GetRuntimeStatsRequest rqst) throws TException {
        this.startFunction("get_runtime_stats");
        MetaException ex = null;
        try {
            List<RuntimeStat> res;
            List<RuntimeStat> list = res = this.getMS().getRuntimeStats(rqst.getMaxWeight(), rqst.getMaxCreateTime());
            this.endFunction("get_runtime_stats", ex == null, (Exception)((Object)ex));
            return list;
        }
        catch (MetaException e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_runtime_stats", ex == null, (Exception)((Object)ex));
                throw throwable;
            }
        }
    }

    public ScheduledQueryPollResponse scheduled_query_poll(ScheduledQueryPollRequest request) throws MetaException, TException {
        this.startFunction("scheduled_query_poll");
        Exception ex = null;
        try {
            RawStore ms = this.getMS();
            ScheduledQueryPollResponse scheduledQueryPollResponse = ms.scheduledQueryPoll(request);
            this.endFunction("scheduled_query_poll", ex == null, ex);
            return scheduledQueryPollResponse;
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("scheduled_query_poll", ex == null, ex);
                throw throwable;
            }
        }
    }

    public void scheduled_query_maintenance(ScheduledQueryMaintenanceRequest request) throws MetaException, TException {
        this.startFunction("scheduled_query_poll");
        Exception ex = null;
        try {
            RawStore ms = this.getMS();
            ms.scheduledQueryMaintenance(request);
            this.endFunction("scheduled_query_poll", ex == null, ex);
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("scheduled_query_poll", ex == null, ex);
                throw throwable;
            }
        }
    }

    public void scheduled_query_progress(ScheduledQueryProgressInfo info) throws MetaException, TException {
        this.startFunction("scheduled_query_poll");
        Exception ex = null;
        try {
            RawStore ms = this.getMS();
            ms.scheduledQueryProgress(info);
            this.endFunction("scheduled_query_poll", ex == null, ex);
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("scheduled_query_poll", ex == null, ex);
                throw throwable;
            }
        }
    }

    public ScheduledQuery get_scheduled_query(ScheduledQueryKey scheduleKey) throws TException {
        this.startFunction("get_scheduled_query");
        Exception ex = null;
        try {
            ScheduledQuery scheduledQuery = this.getMS().getScheduledQuery(scheduleKey);
            this.endFunction("get_scheduled_query", ex == null, ex);
            return scheduledQuery;
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_scheduled_query", ex == null, ex);
                throw throwable;
            }
        }
    }

    public void add_replication_metrics(ReplicationMetricList replicationMetricList) throws MetaException {
        this.startFunction("add_replication_metrics");
        Exception ex = null;
        try {
            this.getMS().addReplicationMetrics(replicationMetricList);
            this.endFunction("add_replication_metrics", ex == null, ex);
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("add_replication_metrics", ex == null, ex);
                throw throwable;
            }
        }
    }

    public ReplicationMetricList get_replication_metrics(GetReplicationMetricsRequest getReplicationMetricsRequest) throws MetaException {
        this.startFunction("get_replication_metrics");
        Exception ex = null;
        try {
            ReplicationMetricList replicationMetricList = this.getMS().getReplicationMetrics(getReplicationMetricsRequest);
            this.endFunction("get_replication_metrics", ex == null, ex);
            return replicationMetricList;
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_replication_metrics", ex == null, ex);
                throw throwable;
            }
        }
    }

    public void create_stored_procedure(StoredProcedure proc) throws NoSuchObjectException, MetaException {
        this.startFunction("create_stored_procedure");
        Exception ex = null;
        this.throwUnsupportedExceptionIfRemoteDB(proc.getDbName(), "create_stored_procedure");
        try {
            this.getMS().createOrUpdateStoredProcedure(proc);
            this.endFunction("create_stored_procedure", ex == null, ex);
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("create_stored_procedure", ex == null, ex);
                throw throwable;
            }
        }
    }

    public StoredProcedure get_stored_procedure(StoredProcedureRequest request) throws MetaException, NoSuchObjectException {
        this.startFunction("get_stored_procedure");
        Exception ex = null;
        try {
            StoredProcedure proc = this.getMS().getStoredProcedure(request.getCatName(), request.getDbName(), request.getProcName());
            if (proc == null) {
                throw new NoSuchObjectException("HPL/SQL StoredProcedure " + request.getDbName() + "." + request.getProcName() + " does not exist");
            }
            StoredProcedure storedProcedure = proc;
            this.endFunction("get_stored_procedure", ex == null, ex);
            return storedProcedure;
        }
        catch (Exception e) {
            try {
                if (!(e instanceof NoSuchObjectException)) {
                    LOG.error("Caught exception", (Throwable)e);
                }
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_stored_procedure", ex == null, ex);
                throw throwable;
            }
        }
    }

    public void drop_stored_procedure(StoredProcedureRequest request) throws MetaException {
        this.startFunction("drop_stored_procedure");
        Exception ex = null;
        try {
            this.getMS().dropStoredProcedure(request.getCatName(), request.getDbName(), request.getProcName());
            this.endFunction("drop_stored_procedure", ex == null, ex);
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("drop_stored_procedure", ex == null, ex);
                throw throwable;
            }
        }
    }

    public List<String> get_all_stored_procedures(ListStoredProcedureRequest request) throws MetaException {
        this.startFunction("get_all_stored_procedures");
        Exception ex = null;
        try {
            List<String> list = this.getMS().getAllStoredProcedures(request);
            this.endFunction("get_all_stored_procedures", ex == null, ex);
            return list;
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_all_stored_procedures", ex == null, ex);
                throw throwable;
            }
        }
    }

    public Package find_package(GetPackageRequest request) throws MetaException, NoSuchObjectException {
        this.startFunction("find_package");
        Exception ex = null;
        try {
            Package pkg = this.getMS().findPackage(request);
            if (pkg == null) {
                throw new NoSuchObjectException("HPL/SQL package " + request.getDbName() + "." + request.getPackageName() + " does not exist");
            }
            Package package_ = pkg;
            this.endFunction("find_package", ex == null, ex);
            return package_;
        }
        catch (Exception e) {
            try {
                if (!(e instanceof NoSuchObjectException)) {
                    LOG.error("Caught exception", (Throwable)e);
                }
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("find_package", ex == null, ex);
                throw throwable;
            }
        }
    }

    public void add_package(AddPackageRequest request) throws MetaException, NoSuchObjectException {
        this.startFunction("add_package");
        Exception ex = null;
        try {
            this.getMS().addPackage(request);
            this.endFunction("add_package", ex == null, ex);
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("add_package", ex == null, ex);
                throw throwable;
            }
        }
    }

    public List<String> get_all_packages(ListPackageRequest request) throws MetaException {
        this.startFunction("get_all_packages");
        Exception ex = null;
        try {
            List<String> list = this.getMS().listPackages(request);
            this.endFunction("get_all_packages", ex == null, ex);
            return list;
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_all_packages", ex == null, ex);
                throw throwable;
            }
        }
    }

    public void drop_package(DropPackageRequest request) throws MetaException {
        this.startFunction("drop_package");
        Exception ex = null;
        try {
            this.getMS().dropPackage(request);
            this.endFunction("drop_package", ex == null, ex);
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("drop_package", ex == null, ex);
                throw throwable;
            }
        }
    }

    public List<WriteEventInfo> get_all_write_event_info(GetAllWriteEventInfoRequest request) throws MetaException {
        this.startFunction("get_all_write_event_info");
        Exception ex = null;
        try {
            List<WriteEventInfo> writeEventInfoList = this.getMS().getAllWriteEventInfo(request.getTxnId(), request.getDbName(), request.getTableName());
            List<WriteEventInfo> list = writeEventInfoList == null ? Collections.emptyList() : writeEventInfoList;
            this.endFunction("get_all_write_event_info", ex == null, ex);
            return list;
        }
        catch (Exception e) {
            try {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.endFunction("get_all_write_event_info", ex == null, ex);
                throw throwable;
            }
        }
    }

    static {
        dataconnectorFactory = null;
        auditLog = LoggerFactory.getLogger((String)(HiveMetaStore.class.getName() + ".audit"));
    }

    private static class PathAndDepth
    implements Comparable<PathAndDepth> {
        final Path path;
        final int depth;

        public PathAndDepth(Path path, int depth) {
            this.path = path;
            this.depth = depth;
        }

        public int hashCode() {
            return Objects.hash(this.path.hashCode(), this.depth);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathAndDepth that = (PathAndDepth)o;
            return this.depth == that.depth && Objects.equals(this.path, that.path);
        }

        @Override
        public int compareTo(PathAndDepth o) {
            return o.depth - this.depth;
        }
    }

    private static class PartValEqWrapperLite {
        List<String> values;
        String location;

        PartValEqWrapperLite(Partition partition) {
            List list = this.values = partition.isSetValues() ? partition.getValues() : null;
            if (partition.getSd() != null) {
                this.location = partition.getSd().getLocation();
            }
        }

        public int hashCode() {
            return this.values == null ? 0 : this.values.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof PartValEqWrapperLite)) {
                return false;
            }
            List<String> lhsValues = this.values;
            List<String> rhsValues = ((PartValEqWrapperLite)obj).values;
            if (lhsValues == null || rhsValues == null) {
                return lhsValues == rhsValues;
            }
            if (lhsValues.size() != rhsValues.size()) {
                return false;
            }
            for (int i = 0; i < lhsValues.size(); ++i) {
                String lhsValue = lhsValues.get(i);
                String rhsValue = rhsValues.get(i);
                if ((lhsValue != null || rhsValue == null) && (lhsValue == null || lhsValue.equals(rhsValue))) continue;
                return false;
            }
            return true;
        }
    }
}

