/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.jdo.PersistenceManager;
import javax.jdo.Transaction;
import javax.jdo.datastore.JDOConnection;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.Batchable;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreDirectSql;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.MetastoreDirectSqlUtils;
import org.apache.hadoop.hive.metastore.QueryWrapper;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.UpdatePartitionColumnStatEvent;
import org.apache.hadoop.hive.metastore.events.UpdatePartitionColumnStatEventBatch;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.model.MColumnDescriptor;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MStringList;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectSqlUpdatePart {
    private static final Logger LOG = LoggerFactory.getLogger((String)DirectSqlUpdatePart.class.getName());
    private final PersistenceManager pm;
    private final Configuration conf;
    private final DatabaseProduct dbType;
    private final int maxBatchSize;
    private final SQLGenerator sqlGenerator;

    public DirectSqlUpdatePart(PersistenceManager pm, Configuration conf, DatabaseProduct dbType, int batchSize) {
        this.pm = pm;
        this.conf = conf;
        this.dbType = dbType;
        this.maxBatchSize = batchSize;
        this.sqlGenerator = new SQLGenerator(dbType, conf);
    }

    void closeDbConn(JDOConnection jdoConn) {
        try {
            if (jdoConn != null) {
                jdoConn.close();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to close db connection", (Throwable)e);
        }
    }

    static String quoteString(String input) {
        return "'" + input + "'";
    }

    private void populateInsertUpdateMap(Map<PartitionInfo, ColumnStatistics> statsPartInfoMap, Map<PartColNameInfo, MPartitionColumnStatistics> updateMap, Map<PartColNameInfo, MPartitionColumnStatistics> insertMap, Connection dbConn, Table tbl) throws SQLException, MetaException, NoSuchObjectException {
        StringBuilder prefix = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        ArrayList<String> queries = new ArrayList<String>();
        HashSet<PartColNameInfo> selectedParts = new HashSet<PartColNameInfo>();
        List<Long> partIdList = statsPartInfoMap.keySet().stream().map(e -> e.partitionId).collect(Collectors.toList());
        prefix.append("select \"PART_ID\", \"COLUMN_NAME\", \"ENGINE\" from \"PART_COL_STATS\" WHERE ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, partIdList, "\"PART_ID\"", true, false);
        try (Statement statement = dbConn.createStatement();){
            for (String query : queries) {
                LOG.debug("Execute query: " + query);
                ResultSet rs = statement.executeQuery(query);
                Throwable throwable = null;
                try {
                    while (rs.next()) {
                        selectedParts.add(new PartColNameInfo(rs.getLong(1), rs.getString(2), rs.getString(3)));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
        }
        for (Map.Entry<PartitionInfo, ColumnStatistics> entry : statsPartInfoMap.entrySet()) {
            PartitionInfo partitionInfo = entry.getKey();
            ColumnStatistics colStats = entry.getValue();
            long partId = partitionInfo.partitionId;
            ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
            if (!statsDesc.isSetCatName()) {
                statsDesc.setCatName(tbl.getCatName());
            }
            for (ColumnStatisticsObj statisticsObj : colStats.getStatsObj()) {
                PartColNameInfo temp = new PartColNameInfo(partId, statisticsObj.getColName(), colStats.getEngine());
                if (selectedParts.contains(temp)) {
                    updateMap.put(temp, StatObjectConverter.convertToMPartitionColumnStatistics(null, statsDesc, statisticsObj, colStats.getEngine()));
                    continue;
                }
                insertMap.put(temp, StatObjectConverter.convertToMPartitionColumnStatistics(null, statsDesc, statisticsObj, colStats.getEngine()));
            }
        }
    }

    private void updatePartColStatTable(Map<PartColNameInfo, MPartitionColumnStatistics> updateMap, Connection dbConn) throws SQLException, MetaException, NoSuchObjectException {
        HashMap<String, List> updates = new HashMap<String, List>();
        for (Map.Entry<PartColNameInfo, MPartitionColumnStatistics> entry : updateMap.entrySet()) {
            MPartitionColumnStatistics mPartitionColumnStatistics = entry.getValue();
            StringBuilder update = new StringBuilder("UPDATE \"PART_COL_STATS\" SET ").append(StatObjectConverter.getUpdatedColumnSql(mPartitionColumnStatistics)).append(" WHERE \"PART_ID\" = ? AND \"COLUMN_NAME\" = ? AND \"ENGINE\" = ?");
            updates.computeIfAbsent(update.toString(), k -> new ArrayList()).add(entry);
        }
        for (Map.Entry<PartColNameInfo, MPartitionColumnStatistics> entry : updates.entrySet()) {
            ArrayList<Long> partIds = new ArrayList<Long>();
            PreparedStatement pst = dbConn.prepareStatement((String)((Object)entry.getKey()));
            Throwable throwable = null;
            try {
                List entries = (List)((Object)entry.getValue());
                for (Map.Entry partStats : entries) {
                    PartColNameInfo partColNameInfo = (PartColNameInfo)partStats.getKey();
                    MPartitionColumnStatistics mPartitionColumnStatistics = (MPartitionColumnStatistics)partStats.getValue();
                    int colIdx = StatObjectConverter.initUpdatedColumnStatement(mPartitionColumnStatistics, pst);
                    pst.setLong(colIdx++, partColNameInfo.partitionId);
                    pst.setString(colIdx++, mPartitionColumnStatistics.getColName());
                    pst.setString(colIdx++, mPartitionColumnStatistics.getEngine());
                    partIds.add(partColNameInfo.partitionId);
                    pst.addBatch();
                    if (partIds.size() != this.maxBatchSize) continue;
                    LOG.debug("Execute updates on part: {}", partIds);
                    this.verifyUpdates(pst.executeBatch(), partIds);
                    partIds = new ArrayList();
                }
                if (partIds.isEmpty()) continue;
                LOG.debug("Execute updates on part: {}", partIds);
                this.verifyUpdates(pst.executeBatch(), partIds);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pst == null) continue;
                if (throwable != null) {
                    try {
                        pst.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pst.close();
            }
        }
    }

    private void verifyUpdates(int[] numUpdates, List<Long> partIds) throws MetaException {
        for (int i = 0; i < numUpdates.length; ++i) {
            if (numUpdates[i] == 1) continue;
            throw new MetaException("Invalid state of PART_COL_STATS for PART_ID " + partIds.get(i));
        }
    }

    private void insertIntoPartColStatTable(Map<PartColNameInfo, MPartitionColumnStatistics> insertMap, long maxCsId, Connection dbConn) throws SQLException, MetaException, NoSuchObjectException {
        int numRows = 0;
        String insert = "INSERT INTO \"PART_COL_STATS\" (\"CS_ID\", \"CAT_NAME\", \"DB_NAME\",\"TABLE_NAME\", \"PARTITION_NAME\", \"COLUMN_NAME\", \"COLUMN_TYPE\", \"PART_ID\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", \"BIT_VECTOR\" , \"HISTOGRAM\", \"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\", \"ENGINE\") values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement preparedStatement = dbConn.prepareStatement(insert);){
            for (Map.Entry<PartColNameInfo, MPartitionColumnStatistics> entry : insertMap.entrySet()) {
                PartColNameInfo partColNameInfo = entry.getKey();
                Long partId = partColNameInfo.partitionId;
                MPartitionColumnStatistics mPartitionColumnStatistics = entry.getValue();
                preparedStatement.setLong(1, maxCsId);
                preparedStatement.setString(2, mPartitionColumnStatistics.getCatName());
                preparedStatement.setString(3, mPartitionColumnStatistics.getDbName());
                preparedStatement.setString(4, mPartitionColumnStatistics.getTableName());
                preparedStatement.setString(5, mPartitionColumnStatistics.getPartitionName());
                preparedStatement.setString(6, mPartitionColumnStatistics.getColName());
                preparedStatement.setString(7, mPartitionColumnStatistics.getColType());
                preparedStatement.setLong(8, partId);
                preparedStatement.setObject(9, mPartitionColumnStatistics.getLongLowValue());
                preparedStatement.setObject(10, mPartitionColumnStatistics.getLongHighValue());
                preparedStatement.setObject(11, mPartitionColumnStatistics.getDoubleHighValue());
                preparedStatement.setObject(12, mPartitionColumnStatistics.getDoubleLowValue());
                preparedStatement.setString(13, mPartitionColumnStatistics.getDecimalLowValue());
                preparedStatement.setString(14, mPartitionColumnStatistics.getDecimalHighValue());
                preparedStatement.setObject(15, mPartitionColumnStatistics.getNumNulls());
                preparedStatement.setObject(16, mPartitionColumnStatistics.getNumDVs());
                preparedStatement.setObject(17, mPartitionColumnStatistics.getBitVector());
                preparedStatement.setBytes(18, mPartitionColumnStatistics.getHistogram());
                preparedStatement.setObject(19, mPartitionColumnStatistics.getAvgColLen());
                preparedStatement.setObject(20, mPartitionColumnStatistics.getMaxColLen());
                preparedStatement.setObject(21, mPartitionColumnStatistics.getNumTrues());
                preparedStatement.setObject(22, mPartitionColumnStatistics.getNumFalses());
                preparedStatement.setLong(23, mPartitionColumnStatistics.getLastAnalyzed());
                preparedStatement.setString(24, mPartitionColumnStatistics.getEngine());
                ++maxCsId;
                preparedStatement.addBatch();
                if (++numRows != this.maxBatchSize) continue;
                preparedStatement.executeBatch();
                numRows = 0;
            }
            if (numRows != 0) {
                preparedStatement.executeBatch();
            }
        }
    }

    private Map<Long, String> getParamValues(Connection dbConn, List<Long> partIdList) throws SQLException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        prefix.append("select \"PART_ID\", \"PARAM_VALUE\"  from \"PARTITION_PARAMS\" where  \"PARAM_KEY\" = 'COLUMN_STATS_ACCURATE'  and ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, partIdList, "\"PART_ID\"", true, false);
        HashMap<Long, String> partIdToParaMap = new HashMap<Long, String>();
        try (Statement statement = dbConn.createStatement();){
            for (String query : queries) {
                LOG.debug("Execute query: " + query);
                ResultSet rs = statement.executeQuery(query);
                Throwable throwable = null;
                try {
                    while (rs.next()) {
                        partIdToParaMap.put(rs.getLong(1), rs.getString(2));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
        }
        return partIdToParaMap;
    }

    private void updateWriteIdForPartitions(Connection dbConn, long writeId, List<Long> partIdList) throws SQLException {
        StringBuilder prefix = new StringBuilder();
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder suffix = new StringBuilder();
        prefix.append("UPDATE \"PARTITIONS\" set \"WRITE_ID\" = " + writeId + " where ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, partIdList, "\"PART_ID\"", false, false);
        try (Statement statement = dbConn.createStatement();){
            for (String query : queries) {
                LOG.debug("Execute update: " + query);
                statement.executeUpdate(query);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, Map<String, String>> updatePartitionParamTable(Connection dbConn, Map<PartitionInfo, ColumnStatistics> partitionInfoMap, String validWriteIds, long writeId, boolean isAcidTable) throws SQLException, MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<PartitionInfo, ColumnStatistics> getPartitionInfo(Connection dbConn, long tblId, Map<String, ColumnStatistics> partColStatsMap) throws SQLException, MetaException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        HashMap<PartitionInfo, ColumnStatistics> partitionInfoMap = new HashMap<PartitionInfo, ColumnStatistics>();
        List<String> partKeys = partColStatsMap.keySet().stream().map(e -> DirectSqlUpdatePart.quoteString(e)).collect(Collectors.toList());
        prefix.append("select \"PART_ID\", \"WRITE_ID\", \"PART_NAME\"  from \"PARTITIONS\" where ");
        suffix.append(" and  \"TBL_ID\" = " + tblId);
        TxnUtils.buildQueryWithINClauseStrings(this.conf, queries, prefix, suffix, partKeys, "\"PART_NAME\"", true, false);
        try (Statement statement = dbConn.createStatement();){
            for (String query : queries) {
                query = this.sqlGenerator.addForUpdateClause(query);
                LOG.debug("Execute query: " + query);
                ResultSet rs = statement.executeQuery(query);
                Throwable throwable = null;
                try {
                    while (rs.next()) {
                        PartitionInfo partitionInfo = new PartitionInfo(rs.getLong(1), rs.getLong(2), rs.getString(3));
                        partitionInfoMap.put(partitionInfo, partColStatsMap.get(rs.getString(3)));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
        }
        return partitionInfoMap;
    }

    private void setAnsiQuotes(Connection dbConn) throws SQLException {
        if (this.sqlGenerator.getDbProduct().isMYSQL()) {
            try (Statement stmt = dbConn.createStatement();){
                stmt.execute("SET @@session.sql_mode=ANSI_QUOTES");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>> updatePartitionColumnStatistics(Map<String, ColumnStatistics> partColStatsMap, Table tbl, long csId, String validWriteIds, long writeId, List<TransactionalMetaStoreEventListener> transactionalListeners) throws MetaException {
        Transaction tx = this.pm.currentTransaction();
        boolean doCommit = false;
        try {
            Map<String, Map<String, String>> result;
            this.dbType.lockInternal();
            if (!tx.isActive()) {
                tx.begin();
                doCommit = true;
            }
            JDOConnection jdoConn = null;
            try {
                jdoConn = this.pm.getDataStoreConnection();
                Connection dbConn = (Connection)jdoConn.getNativeConnection();
                this.setAnsiQuotes(dbConn);
                Map<PartitionInfo, ColumnStatistics> partitionInfoMap = this.getPartitionInfo(dbConn, tbl.getId(), partColStatsMap);
                result = this.updatePartitionParamTable(dbConn, partitionInfoMap, validWriteIds, writeId, TxnUtils.isAcidTable(tbl));
                HashMap<PartColNameInfo, MPartitionColumnStatistics> insertMap = new HashMap<PartColNameInfo, MPartitionColumnStatistics>();
                HashMap<PartColNameInfo, MPartitionColumnStatistics> updateMap = new HashMap<PartColNameInfo, MPartitionColumnStatistics>();
                this.populateInsertUpdateMap(partitionInfoMap, updateMap, insertMap, dbConn, tbl);
                LOG.info("Number of stats to insert  " + insertMap.size() + " update " + updateMap.size());
                if (insertMap.size() != 0) {
                    this.insertIntoPartColStatTable(insertMap, csId, dbConn);
                }
                if (updateMap.size() != 0) {
                    this.updatePartColStatTable(updateMap, dbConn);
                }
                if (transactionalListeners != null) {
                    UpdatePartitionColumnStatEventBatch eventBatch = new UpdatePartitionColumnStatEventBatch(null);
                    for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
                        Map<String, String> parameters = entry.getValue();
                        ColumnStatistics colStats = partColStatsMap.get(entry.getKey());
                        List<String> partVals = HMSHandler.getPartValsFromName(tbl, colStats.getStatsDesc().getPartName());
                        UpdatePartitionColumnStatEvent event = new UpdatePartitionColumnStatEvent(colStats, partVals, parameters, tbl, writeId, null);
                        eventBatch.addPartColStatEvent(event);
                    }
                    MetaStoreListenerNotifier.notifyEventWithDirectSql(transactionalListeners, EventMessage.EventType.UPDATE_PARTITION_COLUMN_STAT_BATCH, eventBatch, dbConn, this.sqlGenerator);
                }
            }
            finally {
                this.closeDbConn(jdoConn);
            }
            if (doCommit) {
                tx.commit();
            }
            Map<String, Map<String, String>> map = result;
            return map;
        }
        catch (Exception e) {
            LOG.error("Unable to update Column stats for  " + tbl.getTableName(), (Throwable)e);
            throw new MetaException("Unable to update Column stats for  " + tbl.getTableName() + " due to: " + e.getMessage());
        }
        finally {
            if (doCommit && tx.isActive()) {
                tx.rollback();
            }
            this.dbType.unlockInternal();
        }
    }

    /*
     * Exception decompiling
     */
    public long getNextCSIdForMPartitionColumnStatistics(long numStats) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void alterPartitions(Map<List<String>, Long> partValuesToId, Map<Long, Long> partIdToSdId, List<Partition> newParts) throws MetaException {
        ArrayList<Long> partIds = new ArrayList<Long>(newParts.size());
        HashMap<Long, Optional<Map<String, String>>> partParamsOpt = new HashMap<Long, Optional<Map<String, String>>>();
        HashMap<Long, StorageDescriptor> idToSd = new HashMap<Long, StorageDescriptor>();
        for (Partition newPart : newParts) {
            Long partId = partValuesToId.get(newPart.getValues());
            Long sdId = partIdToSdId.get(partId);
            partIds.add(partId);
            partParamsOpt.put(partId, Optional.ofNullable(newPart.getParameters()));
            idToSd.put(sdId, newPart.getSd());
        }
        this.updatePartitionsInBatch(partValuesToId, newParts);
        this.updateParamTableInBatch("\"PARTITION_PARAMS\"", "\"PART_ID\"", partIds, partParamsOpt);
        this.updateStorageDescriptorInBatch(idToSd);
    }

    private <T> List<Long> filterIdsByNonNullValue(List<Long> ids, Map<Long, T> map) {
        return ids.stream().filter(id -> map.get(id) != null).collect(Collectors.toList());
    }

    private void updateWithStatement(ThrowableConsumer<PreparedStatement> consumer, String query) throws MetaException {
        JDOConnection jdoConn = this.pm.getDataStoreConnection();
        boolean doTrace = LOG.isDebugEnabled();
        long start = doTrace ? System.nanoTime() : 0L;
        try (PreparedStatement statement = ((Connection)jdoConn.getNativeConnection()).prepareStatement(query);){
            consumer.accept(statement);
            MetastoreDirectSqlUtils.timingTrace(doTrace, query, start, doTrace ? System.nanoTime() : 0L);
        }
        catch (SQLException e) {
            LOG.error("Failed to execute update query: " + query, (Throwable)e);
            throw new MetaException("Unable to execute update due to: " + e.getMessage());
        }
        finally {
            this.closeDbConn(jdoConn);
        }
    }

    private void updatePartitionsInBatch(final Map<List<String>, Long> partValuesToId, List<Partition> newParts) throws MetaException {
        List<String> columns = Arrays.asList("\"CREATE_TIME\"", "\"LAST_ACCESS_TIME\"", "\"WRITE_ID\"");
        List<String> conditionKeys = Arrays.asList("\"PART_ID\"");
        String stmt = TxnUtils.createUpdatePreparedStmt("\"PARTITIONS\"", columns, conditionKeys);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 4);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, newParts, new Batchable<Partition, Void>(){

            @Override
            public List<Void> run(List<Partition> input) throws SQLException {
                for (Partition p : input) {
                    statement.setLong(1, p.getCreateTime());
                    statement.setLong(2, p.getLastAccessTime());
                    statement.setLong(3, p.getWriteId());
                    statement.setLong(4, (Long)partValuesToId.get(p.getValues()));
                    statement.addBatch();
                }
                statement.executeBatch();
                return null;
            }
        }), stmt);
    }

    private List<Long> getStringListId(List<Long> sdIds) throws MetaException {
        return Batchable.runBatched(this.maxBatchSize, sdIds, new Batchable<Long, Long>(){

            @Override
            public List<Long> run(List<Long> input) throws Exception {
                ArrayList<Long> result = new ArrayList<Long>();
                String idLists = MetaStoreDirectSql.getIdListForIn(input);
                String queryFromSkewedValues = "select \"STRING_LIST_ID_EID\" from \"SKEWED_VALUES\" where \"SD_ID_OID\" in (" + idLists + ")";
                try (QueryWrapper query = new QueryWrapper(DirectSqlUpdatePart.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryFromSkewedValues));){
                    List sqlResult = (List)MetastoreDirectSqlUtils.executeWithArray(query.getInnerQuery(), null, queryFromSkewedValues);
                    result.addAll(sqlResult);
                }
                String queryFromValueLoc = "select \"STRING_LIST_ID_KID\" from \"SKEWED_COL_VALUE_LOC_MAP\" where \"SD_ID\" in (" + idLists + ")";
                try (QueryWrapper query = new QueryWrapper(DirectSqlUpdatePart.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryFromValueLoc));){
                    List sqlResult = (List)MetastoreDirectSqlUtils.executeWithArray(query.getInnerQuery(), null, queryFromValueLoc);
                    result.addAll(sqlResult);
                }
                return result;
            }
        });
    }

    private void updateParamTableInBatch(String paramTable, String idColumn, List<Long> ids, Map<Long, Optional<Map<String, String>>> newParamsOpt) throws MetaException {
        Map<Long, Map<String, String>> oldParams = this.getParams(paramTable, idColumn, ids);
        ArrayList<Pair<Long, String>> paramsToDelete = new ArrayList<Pair<Long, String>>();
        ArrayList<Pair<Long, Pair<String, String>>> paramsToUpdate = new ArrayList<Pair<Long, Pair<String, String>>>();
        ArrayList<Pair<Long, Pair<String, String>>> paramsToAdd = new ArrayList<Pair<Long, Pair<String, String>>>();
        for (Long id : ids) {
            Map oldParam = oldParams.getOrDefault(id, new HashMap());
            Map newParam = newParamsOpt.get(id).orElseGet(HashMap::new);
            for (Map.Entry entry2 : oldParam.entrySet()) {
                String key = (String)entry2.getKey();
                String oldValue = (String)entry2.getValue();
                if (!newParam.containsKey(key)) {
                    paramsToDelete.add((Pair<Long, String>)Pair.of((Object)id, (Object)key));
                    continue;
                }
                if (oldValue.equals(newParam.get(key))) continue;
                paramsToUpdate.add((Pair<Long, Pair<String, String>>)Pair.of((Object)id, (Object)Pair.of((Object)key, newParam.get(key))));
            }
            List newlyParams = newParam.entrySet().stream().filter(entry -> !oldParam.containsKey(entry.getKey())).map(entry -> Pair.of((Object)id, (Object)Pair.of(entry.getKey(), entry.getValue()))).collect(Collectors.toList());
            paramsToAdd.addAll(newlyParams);
        }
        this.deleteParams(paramTable, idColumn, paramsToDelete);
        this.updateParams(paramTable, idColumn, paramsToUpdate);
        this.insertParams(paramTable, idColumn, paramsToAdd);
    }

    private Map<Long, Map<String, String>> getParams(final String paramTable, final String idName, List<Long> ids) throws MetaException {
        final HashMap<Long, Map<String, String>> idToParams = new HashMap<Long, Map<String, String>>();
        Batchable.runBatched(this.maxBatchSize, ids, new Batchable<Long, Object>(){

            @Override
            public List<Object> run(List<Long> input) throws MetaException {
                String idLists = MetaStoreDirectSql.getIdListForIn(input);
                String queryText = "select " + idName + ", \"PARAM_KEY\", \"PARAM_VALUE\" from " + paramTable + " where " + idName + " in (" + idLists + ")";
                try (QueryWrapper query = new QueryWrapper(DirectSqlUpdatePart.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
                    List sqlResult = (List)MetastoreDirectSqlUtils.executeWithArray(query.getInnerQuery(), null, queryText);
                    for (Object[] row : sqlResult) {
                        Long id = MetastoreDirectSqlUtils.extractSqlLong(row[0]);
                        String paramKey = MetastoreDirectSqlUtils.extractSqlClob(row[1]);
                        String paramVal = MetastoreDirectSqlUtils.extractSqlClob(row[2]);
                        idToParams.computeIfAbsent(id, key -> new HashMap()).put(paramKey, paramVal);
                    }
                }
                return null;
            }
        });
        return idToParams;
    }

    private void deleteParams(String paramTable, String idColumn, List<Pair<Long, String>> deleteIdKeys) throws MetaException {
        String deleteStmt = "delete from " + paramTable + " where " + idColumn + "=? and PARAM_KEY=?";
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 2);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, deleteIdKeys, new Batchable<Pair<Long, String>, Void>(){

            @Override
            public List<Void> run(List<Pair<Long, String>> input) throws SQLException {
                for (Pair<Long, String> pair : input) {
                    statement.setLong(1, (Long)pair.getLeft());
                    statement.setString(2, (String)pair.getRight());
                    statement.addBatch();
                }
                statement.executeBatch();
                return null;
            }
        }), deleteStmt);
    }

    private void updateParams(String paramTable, String idColumn, List<Pair<Long, Pair<String, String>>> updateIdAndParams) throws MetaException {
        List<String> columns = Arrays.asList("\"PARAM_VALUE\"");
        List<String> conditionKeys = Arrays.asList(idColumn, "\"PARAM_KEY\"");
        String stmt = TxnUtils.createUpdatePreparedStmt(paramTable, columns, conditionKeys);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 3);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, updateIdAndParams, new Batchable<Pair<Long, Pair<String, String>>, Object>(){

            @Override
            public List<Object> run(List<Pair<Long, Pair<String, String>>> input) throws SQLException {
                for (Pair<Long, Pair<String, String>> pair : input) {
                    statement.setString(1, (String)((Pair)pair.getRight()).getRight());
                    statement.setLong(2, (Long)pair.getLeft());
                    statement.setString(3, (String)((Pair)pair.getRight()).getLeft());
                    statement.addBatch();
                }
                statement.executeBatch();
                return null;
            }
        }), stmt);
    }

    private void insertParams(String paramTable, String idColumn, List<Pair<Long, Pair<String, String>>> addIdAndParams) throws MetaException {
        List<String> columns = Arrays.asList(idColumn, "\"PARAM_KEY\"", "\"PARAM_VALUE\"");
        String query = TxnUtils.createInsertPreparedStmt(paramTable, columns);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 3);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, addIdAndParams, new Batchable<Pair<Long, Pair<String, String>>, Void>(){

            @Override
            public List<Void> run(List<Pair<Long, Pair<String, String>>> input) throws SQLException {
                for (Pair<Long, Pair<String, String>> pair : input) {
                    statement.setLong(1, (Long)pair.getLeft());
                    statement.setString(2, (String)((Pair)pair.getRight()).getLeft());
                    statement.setString(3, (String)((Pair)pair.getRight()).getRight());
                    statement.addBatch();
                }
                statement.executeBatch();
                return null;
            }
        }), query);
    }

    private void updateStorageDescriptorInBatch(Map<Long, StorageDescriptor> idToSd) throws MetaException {
        final HashMap<Long, Long> sdIdToCdId = new HashMap<Long, Long>();
        final HashMap sdIdToSerdeId = new HashMap();
        final ArrayList<Long> cdIds = new ArrayList<Long>();
        List<Long> validSdIds = this.filterIdsByNonNullValue(new ArrayList<Long>(idToSd.keySet()), idToSd);
        Batchable.runBatched(this.maxBatchSize, validSdIds, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws Exception {
                String idLists = MetaStoreDirectSql.getIdListForIn(input);
                String queryText = "select \"SD_ID\", \"CD_ID\", \"SERDE_ID\" from \"SDS\" where \"SD_ID\" in (" + idLists + ")";
                try (QueryWrapper query = new QueryWrapper(DirectSqlUpdatePart.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
                    List sqlResult = (List)MetastoreDirectSqlUtils.executeWithArray(query.getInnerQuery(), null, queryText);
                    for (Object[] row : sqlResult) {
                        Long sdId = MetastoreDirectSqlUtils.extractSqlLong(row[0]);
                        Long cdId = MetastoreDirectSqlUtils.extractSqlLong(row[1]);
                        Long serdeId = MetastoreDirectSqlUtils.extractSqlLong(row[2]);
                        sdIdToCdId.put(sdId, cdId);
                        sdIdToSerdeId.put(sdId, serdeId);
                        cdIds.add(cdId);
                    }
                }
                return null;
            }
        });
        HashMap<Long, Optional<Map<String, String>>> sdParamsOpt = new HashMap<Long, Optional<Map<String, String>>>();
        HashMap<Long, List<String>> idToBucketCols = new HashMap<Long, List<String>>();
        HashMap<Long, List<Order>> idToSortCols = new HashMap<Long, List<Order>>();
        HashMap<Long, SkewedInfo> idToSkewedInfo = new HashMap<Long, SkewedInfo>();
        HashMap<Long, List<FieldSchema>> sdIdToNewColumns = new HashMap<Long, List<FieldSchema>>();
        ArrayList<Long> serdeIds = new ArrayList<Long>();
        HashMap<Long, SerDeInfo> serdeIdToSerde = new HashMap<Long, SerDeInfo>();
        HashMap<Long, Optional<Map<String, String>>> serdeParamsOpt = new HashMap<Long, Optional<Map<String, String>>>();
        for (Long sdId2 : validSdIds) {
            StorageDescriptor sd = idToSd.get(sdId2);
            sdParamsOpt.put(sdId2, Optional.ofNullable(sd.getParameters()));
            idToBucketCols.put(sdId2, sd.getBucketCols());
            idToSortCols.put(sdId2, sd.getSortCols());
            idToSkewedInfo.put(sdId2, sd.getSkewedInfo());
            sdIdToNewColumns.put(sdId2, sd.getCols());
            Long serdeId = (Long)sdIdToSerdeId.get(sdId2);
            serdeIds.add(serdeId);
            serdeIdToSerde.put(serdeId, sd.getSerdeInfo());
            serdeParamsOpt.put(serdeId, Optional.ofNullable(sd.getSerdeInfo().getParameters()));
        }
        this.updateParamTableInBatch("\"SD_PARAMS\"", "\"SD_ID\"", validSdIds, sdParamsOpt);
        this.updateBucketColsInBatch(idToBucketCols, validSdIds);
        this.updateSortColsInBatch(idToSortCols, validSdIds);
        this.updateSkewedInfoInBatch(idToSkewedInfo, validSdIds);
        Map<Long, Long> sdIdToNewCdId = this.updateCDInBatch(cdIds, validSdIds, sdIdToCdId, sdIdToNewColumns);
        this.updateSerdeInBatch(serdeIds, serdeIdToSerde);
        this.updateParamTableInBatch("\"SERDE_PARAMS\"", "\"SERDE_ID\"", serdeIds, serdeParamsOpt);
        List cdIdsMayDelete = sdIdToCdId.entrySet().stream().filter(entry -> sdIdToNewCdId.containsKey(entry.getKey())).map(entry -> (Long)entry.getValue()).collect(Collectors.toList());
        sdIdToCdId.replaceAll((sdId, cdId) -> sdIdToNewCdId.containsKey(sdId) ? (Long)sdIdToNewCdId.get(sdId) : cdId);
        this.updateSDInBatch(validSdIds, idToSd, sdIdToCdId);
        List<Long> usedIds = Batchable.runBatched(this.maxBatchSize, cdIdsMayDelete, new Batchable<Long, Long>(){

            @Override
            public List<Long> run(List<Long> input) throws Exception {
                String idLists = MetaStoreDirectSql.getIdListForIn(input);
                String queryText = "select \"CD_ID\" from \"SDS\" where \"CD_ID\" in ( " + idLists + ")";
                try (QueryWrapper query = new QueryWrapper(DirectSqlUpdatePart.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
                    List sqlResult = (List)MetastoreDirectSqlUtils.executeWithArray(query.getInnerQuery(), null, queryText);
                    ArrayList<Long> arrayList = new ArrayList<Long>(sqlResult);
                    return arrayList;
                }
            }
        });
        List<Long> unusedCdIds = cdIdsMayDelete.stream().filter(id -> !usedIds.contains(id)).collect(Collectors.toList());
        this.deleteCDInBatch(unusedCdIds);
    }

    private void updateSDInBatch(List<Long> ids, final Map<Long, StorageDescriptor> idToSd, final Map<Long, Long> idToCdId) throws MetaException {
        List<String> columns = Arrays.asList("\"CD_ID\"", "\"INPUT_FORMAT\"", "\"IS_COMPRESSED\"", "\"IS_STOREDASSUBDIRECTORIES\"", "\"LOCATION\"", "\"NUM_BUCKETS\"", "\"OUTPUT_FORMAT\"");
        List<String> conditionKeys = Arrays.asList("\"SD_ID\"");
        String stmt = TxnUtils.createUpdatePreparedStmt("\"SDS\"", columns, conditionKeys);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 8);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, ids, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws SQLException {
                for (Long sdId : input) {
                    StorageDescriptor sd = (StorageDescriptor)idToSd.get(sdId);
                    statement.setLong(1, (Long)idToCdId.get(sdId));
                    statement.setString(2, sd.getInputFormat());
                    statement.setObject(3, DirectSqlUpdatePart.this.dbType.getBoolean(sd.isCompressed()));
                    statement.setObject(4, DirectSqlUpdatePart.this.dbType.getBoolean(sd.isStoredAsSubDirectories()));
                    statement.setString(5, sd.getLocation());
                    statement.setInt(6, sd.getNumBuckets());
                    statement.setString(7, sd.getOutputFormat());
                    statement.setLong(8, sdId);
                    statement.addBatch();
                }
                statement.executeBatch();
                return null;
            }
        }), stmt);
    }

    private void updateBucketColsInBatch(final Map<Long, List<String>> sdIdToBucketCols, List<Long> sdIds) throws MetaException {
        Batchable.runBatched(this.maxBatchSize, sdIds, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws MetaException {
                String idLists = MetaStoreDirectSql.getIdListForIn(input);
                String queryText = "delete from \"BUCKETING_COLS\" where \"SD_ID\" in (" + idLists + ")";
                DirectSqlUpdatePart.this.updateWithStatement(PreparedStatement::executeUpdate, queryText);
                return null;
            }
        });
        List<String> columns = Arrays.asList("\"SD_ID\"", "\"INTEGER_IDX\"", "\"BUCKET_COL_NAME\"");
        String stmt = TxnUtils.createInsertPreparedStmt("\"BUCKETING_COLS\"", columns);
        List<Long> idWithBucketCols = this.filterIdsByNonNullValue(sdIds, sdIdToBucketCols);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 3);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, idWithBucketCols, new Batchable<Long, Object>(){

            @Override
            public List<Object> run(List<Long> input) throws SQLException {
                for (Long id : input) {
                    List bucketCols = (List)sdIdToBucketCols.get(id);
                    for (int i = 0; i < bucketCols.size(); ++i) {
                        statement.setLong(1, id);
                        statement.setInt(2, i);
                        statement.setString(3, (String)bucketCols.get(i));
                        statement.addBatch();
                    }
                }
                statement.executeBatch();
                return null;
            }
        }), stmt);
    }

    private void updateSortColsInBatch(final Map<Long, List<Order>> sdIdToSortCols, List<Long> sdIds) throws MetaException {
        Batchable.runBatched(this.maxBatchSize, sdIds, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws MetaException {
                String idLists = MetaStoreDirectSql.getIdListForIn(input);
                String queryText = "delete from \"SORT_COLS\" where \"SD_ID\" in (" + idLists + ")";
                DirectSqlUpdatePart.this.updateWithStatement(PreparedStatement::executeUpdate, queryText);
                return null;
            }
        });
        List<String> columns = Arrays.asList("\"SD_ID\"", "\"INTEGER_IDX\"", "\"COLUMN_NAME\"", "\"ORDER\"");
        String stmt = TxnUtils.createInsertPreparedStmt("\"SORT_COLS\"", columns);
        List<Long> idWithSortCols = this.filterIdsByNonNullValue(sdIds, sdIdToSortCols);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 4);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, idWithSortCols, new Batchable<Long, Object>(){

            @Override
            public List<Object> run(List<Long> input) throws SQLException {
                for (Long id : input) {
                    List bucketCols = (List)sdIdToSortCols.get(id);
                    for (int i = 0; i < bucketCols.size(); ++i) {
                        statement.setLong(1, id);
                        statement.setInt(2, i);
                        statement.setString(3, ((Order)bucketCols.get(i)).getCol());
                        statement.setInt(4, ((Order)bucketCols.get(i)).getOrder());
                        statement.addBatch();
                    }
                }
                statement.executeBatch();
                return null;
            }
        }), stmt);
    }

    private void updateSkewedInfoInBatch(Map<Long, SkewedInfo> sdIdToSkewedInfo, List<Long> sdIds) throws MetaException {
        List<Long> stringListId = this.getStringListId(sdIds);
        if (!stringListId.isEmpty()) {
            Batchable.runBatched(this.maxBatchSize, sdIds, new Batchable<Long, Void>(){

                @Override
                public List<Void> run(List<Long> input) throws Exception {
                    String idLists = MetaStoreDirectSql.getIdListForIn(input);
                    String deleteSkewValuesQuery = "delete from \"SKEWED_VALUES\" where \"SD_ID_OID\" in (" + idLists + ")";
                    DirectSqlUpdatePart.this.updateWithStatement(PreparedStatement::executeUpdate, deleteSkewValuesQuery);
                    String deleteSkewColValueLocMapQuery = "delete from \"SKEWED_COL_VALUE_LOC_MAP\" where \"SD_ID\" in (" + idLists + ")";
                    DirectSqlUpdatePart.this.updateWithStatement(PreparedStatement::executeUpdate, deleteSkewColValueLocMapQuery);
                    String deleteSkewColNamesQuery = "delete from \"SKEWED_COL_NAMES\" where \"SD_ID\" in (" + idLists + ")";
                    DirectSqlUpdatePart.this.updateWithStatement(PreparedStatement::executeUpdate, deleteSkewColNamesQuery);
                    return null;
                }
            });
            Batchable.runBatched(this.maxBatchSize, stringListId, new Batchable<Long, Void>(){

                @Override
                public List<Void> run(List<Long> input) throws MetaException {
                    String idLists = MetaStoreDirectSql.getIdListForIn(input);
                    String deleteStringListValuesQuery = "delete from \"SKEWED_STRING_LIST_VALUES\" where \"STRING_LIST_ID\" in (" + idLists + ")";
                    DirectSqlUpdatePart.this.updateWithStatement(PreparedStatement::executeUpdate, deleteStringListValuesQuery);
                    String deleteStringListQuery = "delete from \"SKEWED_STRING_LIST\" where \"STRING_LIST_ID\" in (" + idLists + ")";
                    DirectSqlUpdatePart.this.updateWithStatement(PreparedStatement::executeUpdate, deleteStringListQuery);
                    return null;
                }
            });
        }
        HashMap<Long, List<String>> idToSkewedColNames = new HashMap<Long, List<String>>();
        ArrayList<Long> newStringListId = new ArrayList<Long>();
        HashMap<Long, List<String>> stringListIdToValues = new HashMap<Long, List<String>>();
        HashMap<Long, List<Long>> sdIdToNewStringListId = new HashMap<Long, List<Long>>();
        HashMap<Long, List<Pair<Long, String>>> sdIdToValueLoc = new HashMap<Long, List<Pair<Long, String>>>();
        List<Long> idWithSkewedInfo = this.filterIdsByNonNullValue(sdIds, sdIdToSkewedInfo);
        for (Long sdId : idWithSkewedInfo) {
            Map skewedColValueLocationMaps;
            SkewedInfo skewedInfo = sdIdToSkewedInfo.get(sdId);
            idToSkewedColNames.put(sdId, skewedInfo.getSkewedColNames());
            List skewedColValues = skewedInfo.getSkewedColValues();
            if (skewedColValues != null) {
                for (List colValues : skewedColValues) {
                    Long nextStringListId = this.getDataStoreId(MStringList.class);
                    newStringListId.add(nextStringListId);
                    sdIdToNewStringListId.computeIfAbsent(sdId, k -> new ArrayList()).add(nextStringListId);
                    stringListIdToValues.put(nextStringListId, colValues);
                }
            }
            if ((skewedColValueLocationMaps = skewedInfo.getSkewedColValueLocationMaps()) == null) continue;
            for (Map.Entry entry : skewedColValueLocationMaps.entrySet()) {
                List colValues = (List)entry.getKey();
                String location = (String)entry.getValue();
                Long nextStringListId = this.getDataStoreId(MStringList.class);
                newStringListId.add(nextStringListId);
                stringListIdToValues.put(nextStringListId, colValues);
                sdIdToValueLoc.computeIfAbsent(sdId, k -> new ArrayList()).add(Pair.of((Object)nextStringListId, (Object)location));
            }
        }
        this.insertSkewedColNamesInBatch(idToSkewedColNames, sdIds);
        this.insertStringListInBatch(newStringListId);
        this.insertStringListValuesInBatch(stringListIdToValues, newStringListId);
        this.insertSkewedValuesInBatch(sdIdToNewStringListId, sdIds);
        this.insertSkewColValueLocInBatch(sdIdToValueLoc, sdIds);
    }

    private Long getDataStoreId(Class<?> modelClass) throws MetaException {
        ExecutionContext ec = ((JDOPersistenceManager)this.pm).getExecutionContext();
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(modelClass, ec.getClassLoaderResolver());
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return (Long)ec.getStoreManager().getValueGenerationStrategyValue(ec, cmd, -1);
        }
        throw new MetaException("Identity type is not datastore.");
    }

    private void insertSkewedColNamesInBatch(final Map<Long, List<String>> sdIdToSkewedColNames, List<Long> sdIds) throws MetaException {
        List<String> columns = Arrays.asList("\"SD_ID\"", "\"INTEGER_IDX\"", "\"SKEWED_COL_NAME\"");
        String stmt = TxnUtils.createInsertPreparedStmt("\"SKEWED_COL_NAMES\"", columns);
        List<Long> idWithSkewedCols = this.filterIdsByNonNullValue(sdIds, sdIdToSkewedColNames);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 3);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, idWithSkewedCols, new Batchable<Long, Object>(){

            @Override
            public List<Object> run(List<Long> input) throws SQLException {
                for (Long id : input) {
                    List skewedColNames = (List)sdIdToSkewedColNames.get(id);
                    for (int i = 0; i < skewedColNames.size(); ++i) {
                        statement.setLong(1, id);
                        statement.setInt(2, i);
                        statement.setString(3, (String)skewedColNames.get(i));
                        statement.addBatch();
                    }
                }
                statement.executeBatch();
                return null;
            }
        }), stmt);
    }

    private void insertStringListInBatch(List<Long> stringListIds) throws MetaException {
        List<String> columns = Arrays.asList("\"STRING_LIST_ID\"");
        String insertQuery = TxnUtils.createInsertPreparedStmt("\"SKEWED_STRING_LIST\"", columns);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 1);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, stringListIds, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws SQLException {
                for (Long id : input) {
                    statement.setLong(1, id);
                    statement.addBatch();
                }
                statement.executeBatch();
                return null;
            }
        }), insertQuery);
    }

    private void insertStringListValuesInBatch(final Map<Long, List<String>> stringListIdToValues, List<Long> stringListIds) throws MetaException {
        List<String> columns = Arrays.asList("\"STRING_LIST_ID\"", "\"INTEGER_IDX\"", "\"STRING_LIST_VALUE\"");
        String insertQuery = TxnUtils.createInsertPreparedStmt("\"SKEWED_STRING_LIST_VALUES\"", columns);
        List<Long> idWithStringList = this.filterIdsByNonNullValue(stringListIds, stringListIdToValues);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 3);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, idWithStringList, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws SQLException {
                for (Long stringListId : input) {
                    List values = (List)stringListIdToValues.get(stringListId);
                    for (int i = 0; i < values.size(); ++i) {
                        statement.setLong(1, stringListId);
                        statement.setInt(2, i);
                        statement.setString(3, (String)values.get(i));
                        statement.addBatch();
                    }
                }
                statement.executeBatch();
                return null;
            }
        }), insertQuery);
    }

    private void insertSkewedValuesInBatch(final Map<Long, List<Long>> sdIdToStringListId, List<Long> sdIds) throws MetaException {
        List<String> columns = Arrays.asList("\"SD_ID_OID\"", "\"INTEGER_IDX\"", "\"STRING_LIST_ID_EID\"");
        String insertQuery = TxnUtils.createInsertPreparedStmt("\"SKEWED_VALUES\"", columns);
        List<Long> idWithSkewedValues = this.filterIdsByNonNullValue(sdIds, sdIdToStringListId);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 3);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, idWithSkewedValues, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws Exception {
                for (Long sdId : input) {
                    List stringListIds = (List)sdIdToStringListId.get(sdId);
                    for (int i = 0; i < stringListIds.size(); ++i) {
                        statement.setLong(1, sdId);
                        statement.setInt(2, i);
                        statement.setLong(3, (Long)stringListIds.get(i));
                        statement.addBatch();
                    }
                }
                statement.executeBatch();
                return null;
            }
        }), insertQuery);
    }

    private void insertSkewColValueLocInBatch(final Map<Long, List<Pair<Long, String>>> sdIdToColValueLoc, List<Long> sdIds) throws MetaException {
        List<String> columns = Arrays.asList("\"SD_ID\"", "\"STRING_LIST_ID_KID\"", "\"LOCATION\"");
        String insertQuery = TxnUtils.createInsertPreparedStmt("\"SKEWED_COL_VALUE_LOC_MAP\"", columns);
        List<Long> idWithColValueLoc = this.filterIdsByNonNullValue(sdIds, sdIdToColValueLoc);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 3);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, idWithColValueLoc, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws Exception {
                for (Long sdId : input) {
                    List stringListIdAndLoc = (List)sdIdToColValueLoc.get(sdId);
                    for (Pair pair : stringListIdAndLoc) {
                        statement.setLong(1, sdId);
                        statement.setLong(2, (Long)pair.getLeft());
                        statement.setString(3, (String)pair.getRight());
                        statement.addBatch();
                    }
                }
                statement.executeBatch();
                return null;
            }
        }), insertQuery);
    }

    private Map<Long, Long> updateCDInBatch(List<Long> cdIds, List<Long> sdIds, Map<Long, Long> sdIdToCdId, Map<Long, List<FieldSchema>> sdIdToNewColumns) throws MetaException {
        final HashMap cdIdToColIdxPair = new HashMap();
        Batchable.runBatched(this.maxBatchSize, cdIds, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws Exception {
                String idLists = MetaStoreDirectSql.getIdListForIn(input);
                String queryText = "select \"CD_ID\", \"COMMENT\", \"COLUMN_NAME\", \"TYPE_NAME\", \"INTEGER_IDX\" from \"COLUMNS_V2\" where \"CD_ID\" in (" + idLists + ")";
                try (QueryWrapper query = new QueryWrapper(DirectSqlUpdatePart.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
                    List sqlResult = (List)MetastoreDirectSqlUtils.executeWithArray(query.getInnerQuery(), null, queryText);
                    for (Object[] row : sqlResult) {
                        Long id = MetastoreDirectSqlUtils.extractSqlLong(row[0]);
                        String comment = MetastoreDirectSqlUtils.extractSqlClob(row[1]);
                        String name = MetastoreDirectSqlUtils.extractSqlClob(row[2]);
                        String type = MetastoreDirectSqlUtils.extractSqlClob(row[3]);
                        int index = MetastoreDirectSqlUtils.extractSqlInt(row[4]);
                        FieldSchema field = new FieldSchema(name, type, comment);
                        cdIdToColIdxPair.computeIfAbsent(id, k -> new ArrayList()).add(Pair.of((Object)index, (Object)field));
                    }
                }
                return null;
            }
        });
        ArrayList<Long> newCdIds = new ArrayList<Long>();
        HashMap<Long, List<FieldSchema>> newCdIdToCols = new HashMap<Long, List<FieldSchema>>();
        HashMap<Long, Long> oldCdIdToNewCdId = new HashMap<Long, Long>();
        HashMap<Long, Long> sdIdToNewCdId = new HashMap<Long, Long>();
        HashMap<Long, List<Pair<Integer, Integer>>> oldCdIdToColIdxPairs = new HashMap<Long, List<Pair<Integer, Integer>>>();
        for (Long sdId : sdIds) {
            Long cdId = sdIdToCdId.get(sdId);
            List cols = (List)cdIdToColIdxPair.get(cdId);
            ArrayList<Object> oldCols = new ArrayList<Object>(Collections.nCopies(cols.size(), null));
            cols.forEach(pair -> {
                FieldSchema cfr_ignored_0 = (FieldSchema)oldCols.set((Integer)pair.getLeft(), pair.getRight());
            });
            List<FieldSchema> newCols = sdIdToNewColumns.get(sdId);
            if (oldCols != null && oldCols.equals(newCols) || oldCols == null || newCols == null) continue;
            Long newCdId = this.getDataStoreId(MColumnDescriptor.class);
            newCdIds.add(newCdId);
            newCdIdToCols.put(newCdId, newCols);
            oldCdIdToNewCdId.put(cdId, newCdId);
            sdIdToNewCdId.put(sdId, newCdId);
            for (int i = 0; i < oldCols.size(); ++i) {
                FieldSchema oldCol = (FieldSchema)oldCols.get(i);
                int newIdx = newCols.indexOf(oldCol);
                if (newIdx == -1) continue;
                oldCdIdToColIdxPairs.computeIfAbsent(cdId, k -> new ArrayList()).add(Pair.of((Object)i, (Object)newIdx));
            }
        }
        this.insertCDInBatch(newCdIds, newCdIdToCols);
        this.updateKeyConstraintsInBatch(oldCdIdToNewCdId, oldCdIdToColIdxPairs);
        return sdIdToNewCdId;
    }

    private void insertCDInBatch(List<Long> ids, final Map<Long, List<FieldSchema>> idToCols) throws MetaException {
        String insertCds = TxnUtils.createInsertPreparedStmt("\"CDS\"", Arrays.asList("\"CD_ID\""));
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 1);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, ids, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws SQLException {
                for (Long id : input) {
                    statement.setLong(1, id);
                    statement.addBatch();
                }
                statement.executeBatch();
                return null;
            }
        }), insertCds);
        List<String> columns = Arrays.asList("\"CD_ID\"", "\"COMMENT\"", "\"COLUMN_NAME\"", "\"TYPE_NAME\"", "\"INTEGER_IDX\"");
        String insertColumns = TxnUtils.createInsertPreparedStmt("\"COLUMNS_V2\"", columns);
        int maxRowsForCDs = this.dbType.getMaxRows(this.maxBatchSize, 5);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRowsForCDs, ids, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws Exception {
                for (Long id : input) {
                    List cols = (List)idToCols.get(id);
                    for (int i = 0; i < cols.size(); ++i) {
                        FieldSchema col = (FieldSchema)cols.get(i);
                        statement.setLong(1, id);
                        statement.setString(2, col.getComment());
                        statement.setString(3, col.getName());
                        statement.setString(4, col.getType());
                        statement.setInt(5, i);
                        statement.addBatch();
                    }
                }
                statement.executeBatch();
                return null;
            }
        }), insertColumns);
    }

    private void updateKeyConstraintsInBatch(final Map<Long, Long> oldCdIdToNewCdId, final Map<Long, List<Pair<Integer, Integer>>> oldCdIdToColIdxPairs) throws MetaException {
        ArrayList<Long> oldCdIds = new ArrayList<Long>(oldCdIdToNewCdId.keySet());
        String tableName = "\"KEY_CONSTRAINTS\"";
        List<String> parentColumns = Arrays.asList("\"PARENT_CD_ID\"", "\"PARENT_INTEGER_IDX\"");
        List<String> childColumns = Arrays.asList("\"CHILD_CD_ID\"", "\"CHILD_INTEGER_IDX\"");
        String updateParent = TxnUtils.createUpdatePreparedStmt(tableName, parentColumns, parentColumns);
        String updateChild = TxnUtils.createUpdatePreparedStmt(tableName, childColumns, childColumns);
        for (String updateStmt : new String[]{updateParent, updateChild}) {
            int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 4);
            this.updateWithStatement(statement -> Batchable.runBatched(maxRows, oldCdIds, new Batchable<Long, Void>(){

                @Override
                public List<Void> run(List<Long> input) throws SQLException {
                    for (Long oldId : input) {
                        if (!oldCdIdToColIdxPairs.containsKey(oldId)) continue;
                        Long newId = (Long)oldCdIdToNewCdId.get(oldId);
                        for (Pair idx : (List)oldCdIdToColIdxPairs.get(oldId)) {
                            statement.setLong(1, newId);
                            statement.setInt(2, (Integer)idx.getRight());
                            statement.setLong(3, oldId);
                            statement.setInt(4, (Integer)idx.getLeft());
                            statement.addBatch();
                        }
                    }
                    statement.executeBatch();
                    return null;
                }
            }), updateStmt);
        }
    }

    private void deleteCDInBatch(List<Long> cdIds) throws MetaException {
        Batchable.runBatched(this.maxBatchSize, cdIds, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws Exception {
                String idLists = MetaStoreDirectSql.getIdListForIn(input);
                String deleteConstraintsByCd = "delete from \"KEY_CONSTRAINTS\" where \"CHILD_CD_ID\" in (" + idLists + ") or \"PARENT_CD_ID\" in (" + idLists + ")";
                DirectSqlUpdatePart.this.updateWithStatement(PreparedStatement::executeUpdate, deleteConstraintsByCd);
                String deleteColumns = "delete from \"COLUMNS_V2\" where \"CD_ID\" in (" + idLists + ")";
                DirectSqlUpdatePart.this.updateWithStatement(PreparedStatement::executeUpdate, deleteColumns);
                String deleteCDs = "delete from \"CDS\" where \"CD_ID\" in (" + idLists + ")";
                DirectSqlUpdatePart.this.updateWithStatement(PreparedStatement::executeUpdate, deleteCDs);
                return null;
            }
        });
    }

    private void updateSerdeInBatch(List<Long> ids, final Map<Long, SerDeInfo> idToSerde) throws MetaException {
        List<String> columns = Arrays.asList("\"NAME\"", "\"SLIB\"");
        List<String> condKeys = Arrays.asList("\"SERDE_ID\"");
        String updateStmt = TxnUtils.createUpdatePreparedStmt("\"SERDES\"", columns, condKeys);
        List<Long> idWithSerde = this.filterIdsByNonNullValue(ids, idToSerde);
        int maxRows = this.dbType.getMaxRows(this.maxBatchSize, 3);
        this.updateWithStatement(statement -> Batchable.runBatched(maxRows, idWithSerde, new Batchable<Long, Void>(){

            @Override
            public List<Void> run(List<Long> input) throws SQLException {
                for (Long id : input) {
                    SerDeInfo serde = (SerDeInfo)idToSerde.get(id);
                    statement.setString(1, serde.getName());
                    statement.setString(2, serde.getSerializationLib());
                    statement.setLong(3, id);
                    statement.addBatch();
                }
                statement.executeBatch();
                return null;
            }
        }), updateStmt);
    }

    private static /* synthetic */ String lambda$updatePartitionParamTable$3(ColumnStatisticsObj e) {
        return e.getColName();
    }

    private static /* synthetic */ Long lambda$updatePartitionParamTable$2(PartitionInfo e) {
        return e.partitionId;
    }

    private static final class PartColNameInfo {
        long partitionId;
        String colName;
        String engine;

        public PartColNameInfo(long partitionId, String colName, String engine) {
            this.partitionId = partitionId;
            this.colName = colName;
            this.engine = engine;
        }

        public int hashCode() {
            return (int)this.partitionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof PartColNameInfo)) {
                return false;
            }
            PartColNameInfo other = (PartColNameInfo)o;
            if (this.partitionId != other.partitionId) {
                return false;
            }
            if (!this.colName.equalsIgnoreCase(other.colName)) {
                return false;
            }
            return Objects.equals(this.engine, other.engine);
        }
    }

    private static final class PartitionInfo {
        long partitionId;
        long writeId;
        String partitionName;

        public PartitionInfo(long partitionId, long writeId, String partitionName) {
            this.partitionId = partitionId;
            this.writeId = writeId;
            this.partitionName = partitionName;
        }

        public int hashCode() {
            return (int)this.partitionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof PartitionInfo)) {
                return false;
            }
            PartitionInfo other = (PartitionInfo)o;
            return this.partitionId == other.partitionId;
        }
    }

    private static interface ThrowableConsumer<T> {
        public void accept(T var1) throws SQLException, MetaException;
    }
}

