/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.TableSymbol;
import org.apache.flink.table.expressions.ValueLiteralExpression;

@Internal
class CallSyntaxUtils {
    static String asSerializableOperand(ResolvedExpression expression) {
        if (expression.getResolvedChildren().isEmpty()) {
            return expression.asSerializableString();
        }
        return String.format("(%s)", expression.asSerializableString());
    }

    static <T extends TableSymbol> T getSymbolLiteral(ResolvedExpression operands, Class<T> clazz) {
        return (T)((TableSymbol)((ValueLiteralExpression)operands).getValueAs(clazz).get());
    }

    private CallSyntaxUtils() {
    }
}

