/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.rules.LoptOptimizeJoinRule;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.rules.logical.FlinkBushyJoinReorderRule;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableFlinkJoinReorderRule;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.immutables.value.Value;

@Value.Enclosing
public class FlinkJoinReorderRule
extends RelRule<Config>
implements TransformationRule {
    public static final FlinkJoinReorderRule INSTANCE = Config.DEFAULT.toRule();
    private static final LoptOptimizeJoinRule LOPT_JOIN_REORDER = LoptOptimizeJoinRule.Config.DEFAULT.toRule();
    private static final FlinkBushyJoinReorderRule BUSHY_JOIN_REORDER = FlinkBushyJoinReorderRule.Config.DEFAULT.toRule();

    protected FlinkJoinReorderRule(Config config) {
        super(config);
    }

    @Deprecated
    public FlinkJoinReorderRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Deprecated
    public FlinkJoinReorderRule(RelFactories.JoinFactory joinFactory, RelFactories.ProjectFactory projectFactory, RelFactories.FilterFactory filterFactory) {
        this(RelBuilder.proto(joinFactory, projectFactory, filterFactory));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        int bushyTreeThreshold;
        MultiJoin multiJoinRel = (MultiJoin)call.rel(0);
        int numJoinInputs = multiJoinRel.getInputs().size();
        if (numJoinInputs <= (bushyTreeThreshold = ((Integer)ShortcutUtils.unwrapContext(multiJoinRel).getTableConfig().get(OptimizerConfigOptions.TABLE_OPTIMIZER_BUSHY_JOIN_REORDER_THRESHOLD)).intValue())) {
            BUSHY_JOIN_REORDER.onMatch(call);
        } else {
            LOPT_JOIN_REORDER.onMatch(call);
        }
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFlinkJoinReorderRule.Config.builder().build().withOperandSupplier(b -> b.operand(MultiJoin.class).anyInputs()).as(Config.class);

        @Override
        default public FlinkJoinReorderRule toRule() {
            return new FlinkJoinReorderRule(this);
        }
    }
}

