/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.common;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\u0001\u0003\u0003\u0003)\"AF\"p[6|g\u000e\u00155zg&\u001c\u0017\r\\#yG\"\fgnZ3\u000b\u0005\r!\u0011AB2p[6|gN\u0003\u0002\u0006\r\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\b\u0011\u0005)an\u001c3fg*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0004\u0001Y\u0001\u0003CA\f\u001f\u001b\u0005A\"BA\r\u001b\u0003\u0011\u0019wN]3\u000b\u0005ma\u0012a\u0001:fY*\u0011Q\u0004E\u0001\bG\u0006d7-\u001b;f\u0013\ty\u0002D\u0001\u0005Fq\u000eD\u0017M\\4f!\t\t#%D\u0001\u0005\u0013\t\u0019CA\u0001\tGY&t7\u000e\u00155zg&\u001c\u0017\r\u001c*fY\"AQ\u0005\u0001B\u0001B\u0003%a%A\u0004dYV\u001cH/\u001a:\u0011\u0005\u001dJS\"\u0001\u0015\u000b\u0005%a\u0012B\u0001\u0016)\u00055\u0011V\r\\(qi\u000ecWo\u001d;fe\"AA\u0006\u0001B\u0001B\u0003%Q&\u0001\u0005ue\u0006LGoU3u!\t9c&\u0003\u00020Q\tY!+\u001a7Ue\u0006LGoU3u\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014\u0001C5oaV$(+\u001a7\u0011\u0005M\"T\"\u0001\u000e\n\u0005UR\"a\u0002*fY:{G-\u001a\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005y!/\u001a7ESN$(/\u001b2vi&|g\u000e\u0005\u00024s%\u0011!H\u0007\u0002\u0010%\u0016dG)[:ue&\u0014W\u000f^5p]\")A\b\u0001C\u0001{\u00051A(\u001b8jiz\"RA\u0010!B\u0005\u000e\u0003\"a\u0010\u0001\u000e\u0003\tAQ!J\u001eA\u0002\u0019BQ\u0001L\u001eA\u00025BQ!M\u001eA\u0002IBQaN\u001eA\u0002aBQ!\u0012\u0001\u0005B\u0019\u000bqbY8naV$XmU3mM\u000e{7\u000f\u001e\u000b\u0004\u000f*s\u0005CA\u0014I\u0013\tI\u0005F\u0001\u0006SK2|\u0005\u000f^\"pgRDQa\u0003#A\u0002-\u0003\"a\n'\n\u00055C#!\u0004*fY>\u0003H\u000f\u00157b]:,'\u000fC\u0003P\t\u0002\u0007\u0001+\u0001\u0002ncB\u0011\u0011\u000bV\u0007\u0002%*\u00111KG\u0001\t[\u0016$\u0018\rZ1uC&\u0011QK\u0015\u0002\u0011%\u0016dW*\u001a;bI\u0006$\u0018-U;fefDQa\u0016\u0001\u0005Ba\u000bA\"\u001a=qY\u0006Lg\u000eV3s[N$\"!\u0017/\u0011\u0005MR\u0016BA.\u001b\u0005%\u0011V\r\\,sSR,'\u000fC\u0003^-\u0002\u0007\u0011,\u0001\u0002qo\")q\f\u0001C\u0005A\u0006!B-[:ue&\u0014W\u000f^5p]R{7\u000b\u001e:j]\u001e$\u0012!\u0019\t\u0003E.t!aY5\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019$\u0012A\u0002\u001fs_>$hHC\u0001i\u0003\u0015\u00198-\u00197b\u0013\tQw-\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016h\u0011\u0015y\u0007\u0001\"\u0005q\u0003]9W\r\u001e*fcVL'/\u001a3ESN$(/\u001b2vi&|g.F\u0001r!\r\u0011\u0018q\u0002\b\u0004g\u0006%ab\u0001;\u0002\u00069\u0019Q/a\u0001\u000f\u0007Y\f\tA\u0004\u0002x\u007f:\u0011\u0001P \b\u0003svt!A\u001f?\u000f\u0005\u0011\\\u0018\"A\n\n\u0005E\u0011\u0012BA\b\u0011\u0013\tia\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I1!a\u0002\u0007\u0003\u0011)\u00070Z2\n\t\u0005-\u0011QB\u0001\u000e\u0013:\u0004X\u000f\u001e)s_B,'\u000f^=\u000b\u0007\u0005\u001da!\u0003\u0003\u0002\u0012\u0005M!\u0001\u0006*fcVL'/\u001a3ESN$(/\u001b2vi&|gN\u0003\u0003\u0002\f\u00055\u0001")
public abstract class CommonPhysicalExchange
extends Exchange
implements FlinkPhysicalRel {
    private final RelDistribution relDistribution;

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return FlinkPhysicalRel.satisfyTraits$(this, requiredTraitSet);
    }

    @Override
    public ExecNode<?> translateToExecNode(boolean isCompiled) {
        return FlinkPhysicalRel.translateToExecNode$(this, isCompiled);
    }

    @Override
    public String getRelDetailedDescription() {
        return FlinkRelNode.getRelDetailedDescription$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionDetail);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, expressionDetail);
    }

    @Override
    public Enumeration.Value convertToExpressionDetail(SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.convertToExpressionDetail$(this, sqlExplainLevel);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost relOptCost;
        Double inputRows = mq.getRowCount(this.input);
        if (inputRows == null) {
            return null;
        }
        double inputSize = Predef$.MODULE$.Double2double(mq.getAverageRowSize(this.input)) * Predef$.MODULE$.Double2double(inputRows);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        RelDistribution.Type type = this.relDistribution.getType();
        if (((Object)((Object)RelDistribution.Type.SINGLETON)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.SINGLETON_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
        } else if (((Object)((Object)RelDistribution.Type.RANDOM_DISTRIBUTED)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.RANDOM_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
        } else if (((Object)((Object)RelDistribution.Type.RANGE_DISTRIBUTED)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.RANGE_PARTITION_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            double diskIoCost = inputSize;
            double networkCost = (double)2 * inputSize;
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, diskIoCost, networkCost, 0.0);
        } else if (((Object)((Object)RelDistribution.Type.BROADCAST_DISTRIBUTED)).equals((Object)type)) {
            int nParallelism = Math.max(1, (int)(inputSize / (double)FlinkCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE()));
            double cpuCost = (double)nParallelism * Predef$.MODULE$.Double2double(inputRows) * (double)FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST();
            double networkCost = (double)nParallelism * inputSize;
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, networkCost, 0.0);
        } else if (((Object)((Object)RelDistribution.Type.HASH_DISTRIBUTED)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.HASH_CPU_COST() * this.relDistribution.getKeys().size() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
        } else if (((Object)((Object)RelDistribution.Type.ANY)).equals((Object)type)) {
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), (double)FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST() * Predef$.MODULE$.Double2double(inputRows), 0.0, inputSize, 0.0);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(34).append("not support RelDistribution: ").append((Object)this.relDistribution.getType()).append(" now!").toString());
        }
        return relOptCost;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.input("input", this.getInput()).item("distribution", this.distributionToString());
    }

    private String distributionToString() {
        FlinkRelDistribution flinkRelDistribution = (FlinkRelDistribution)this.relDistribution;
        java.util.List<String> inputFieldNames = this.getInput().getRowType().getFieldNames();
        String exchangeName = this.relDistribution.getType().shortName;
        RelDistribution.Type type = this.relDistribution.getType();
        java.util.List list = ((Object)((Object)RelDistribution.Type.RANGE_DISTRIBUTED)).equals((Object)type) ? (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)flinkRelDistribution.getFieldCollations().get()).asScala()).map((Function1 & Serializable & scala.Serializable)fieldCollation -> {
            String name = (String)inputFieldNames.get(fieldCollation.getFieldIndex());
            return new StringBuilder(1).append(name).append(" ").append(fieldCollation.getDirection().shortString).toString();
        }, Buffer$.MODULE$.canBuildFrom())).asJava() : (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)flinkRelDistribution.getKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)inputFieldNames.get(Predef$.MODULE$.Integer2int(x$1)), Buffer$.MODULE$.canBuildFrom())).asJava();
        java.util.List fieldNames = list;
        return fieldNames.isEmpty() ? exchangeName : new StringBuilder(0).append(exchangeName).append(fieldNames).toString();
    }

    public InputProperty.RequiredDistribution getRequiredDistribution() {
        InputProperty.RequiredDistribution requiredDistribution;
        RelDistribution.Type type = this.relDistribution.getType();
        if (((Object)((Object)RelDistribution.Type.ANY)).equals((Object)type)) {
            requiredDistribution = InputProperty.ANY_DISTRIBUTION;
        } else if (((Object)((Object)RelDistribution.Type.BROADCAST_DISTRIBUTED)).equals((Object)type)) {
            requiredDistribution = InputProperty.BROADCAST_DISTRIBUTION;
        } else if (((Object)((Object)RelDistribution.Type.SINGLETON)).equals((Object)type)) {
            requiredDistribution = InputProperty.SINGLETON_DISTRIBUTION;
        } else if (((Object)((Object)RelDistribution.Type.HASH_DISTRIBUTED)).equals((Object)type)) {
            int[] keys = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.relDistribution.getKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
            requiredDistribution = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys)).isEmpty() ? InputProperty.SINGLETON_DISTRIBUTION : InputProperty.hashDistribution(keys);
        } else {
            throw new TableException(new StringBuilder(31).append("Unsupported distribution type: ").append((Object)this.relDistribution.getType()).toString());
        }
        return requiredDistribution;
    }

    public CommonPhysicalExchange(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, RelDistribution relDistribution) {
        this.relDistribution = relDistribution;
        super(cluster, traitSet, inputRel, relDistribution);
        FlinkRelNode.$init$(this);
        FlinkPhysicalRel.$init$(this);
    }
}

