/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.inference;

import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkOperatorBinding;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.inference.AbstractSqlCallContext;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class OperatorBindingCallContext
extends AbstractSqlCallContext {
    private final SqlOperatorBinding binding;
    private final List<DataType> argumentDataTypes;
    @Nullable
    private final DataType outputDataType;

    public OperatorBindingCallContext(DataTypeFactory dataTypeFactory, FunctionDefinition definition, SqlOperatorBinding sqlOperatorBinding, RelDataType returnRelDataType) {
        super(dataTypeFactory, definition, sqlOperatorBinding.getOperator().getNameAsId().toString(), sqlOperatorBinding.getGroupCount() > 0);
        this.binding = new FlinkOperatorBinding(sqlOperatorBinding);
        this.argumentDataTypes = new AbstractList<DataType>(){

            @Override
            public DataType get(int pos) {
                LogicalType logicalType = FlinkTypeFactory.toLogicalType(OperatorBindingCallContext.this.binding.getOperandType(pos));
                return TypeConversions.fromLogicalToDataType((LogicalType)logicalType);
            }

            @Override
            public int size() {
                return OperatorBindingCallContext.this.binding.getOperandCount();
            }
        };
        this.outputDataType = returnRelDataType != null ? TypeConversions.fromLogicalToDataType((LogicalType)FlinkTypeFactory.toLogicalType(returnRelDataType)) : null;
    }

    public boolean isArgumentLiteral(int pos) {
        return this.binding.isOperandLiteral(pos, false);
    }

    public boolean isArgumentNull(int pos) {
        return this.binding.isOperandNull(pos, false);
    }

    public <T> Optional<T> getArgumentValue(final int pos, Class<T> clazz) {
        if (this.isArgumentNull(pos)) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(OperatorBindingCallContext.getLiteralValueAs(new AbstractSqlCallContext.LiteralValueAccessor(){

                public <R> R getValueAs(Class<R> clazz) {
                    return OperatorBindingCallContext.this.binding.getOperandLiteralValue(pos, clazz);
                }
            }, clazz));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public List<DataType> getArgumentDataTypes() {
        return this.argumentDataTypes;
    }

    public Optional<DataType> getOutputDataType() {
        return Optional.ofNullable(this.outputDataType);
    }
}

