/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import java.util.Collections;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;

@Internal
class TryCastConverter
extends CustomizedConverter {
    TryCastConverter() {
    }

    @Override
    public RexNode convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        TryCastConverter.checkArgumentNumber(call, 2);
        FlinkTypeFactory typeFactory = context.getTypeFactory();
        RexNode child = context.toRexNode((Expression)call.getChildren().get(0));
        TypeLiteralExpression targetType = (TypeLiteralExpression)call.getChildren().get(1);
        RelDataType targetRelDataType = typeFactory.createTypeWithNullability(typeFactory.createFieldTypeFromLogicalType(targetType.getOutputDataType().getLogicalType()), true);
        return context.getRelBuilder().getRexBuilder().makeCall(targetRelDataType, FlinkSqlOperatorTable.TRY_CAST, Collections.singletonList(child));
    }
}

