/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.calls;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.util.MapDataUtil;
import org.apache.flink.table.data.utils.CastExecutor;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods$;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRule;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.ExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.functions.SqlFunctionUtils;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ScalarOperatorGens$ {
    public static ScalarOperatorGens$ MODULE$;

    static {
        new ScalarOperatorGens$();
    }

    public GeneratedExpression generateBinaryArithmeticOperator(CodeGeneratorContext ctx, String operator, LogicalType resultType, GeneratedExpression left, GeneratedExpression right) {
        Function1<String, String> function1;
        LogicalType logicalType = resultType;
        if (logicalType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)logicalType;
            return this.generateDecimalBinaryArithmeticOperator(ctx, operator, decimalType, left, right);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        String string = operator;
        if ("%".equals(string)) {
            Function1<String, String> function12;
            if (PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
                function12 = this.numericCasting(ctx, left.resultType(), resultType);
            } else {
                BigIntType castedType = TypeCheckUtils.isDecimal((LogicalType)left.resultType()) ? new BigIntType() : left.resultType();
                function12 = this.numericCasting(ctx, left.resultType(), (LogicalType)castedType);
            }
            function1 = function12;
        } else {
            function1 = this.numericCasting(ctx, left.resultType(), resultType);
        }
        Function1<String, String> leftCasting = function1;
        Function1<String, String> rightCasting = this.numericCasting(ctx, right.resultType(), resultType);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
        return this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(7).append("(").append(resultTypeTerm).append(") (").append(leftCasting.apply(leftTerm)).append(" ").append(operator).append(" ").append(rightCasting.apply(rightTerm)).append(")").toString());
    }

    private GeneratedExpression generateDecimalBinaryArithmeticOperator(CodeGeneratorContext ctx, String operator, DecimalType resultType, GeneratedExpression left, GeneratedExpression right) {
        scala.collection.immutable.Map methods = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"+"), (Object)"add"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-"), (Object)"subtract"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)"multiply"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/"), (Object)"divide"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"%"), (Object)"mod")}));
        return this.generateOperatorIfNotNull(ctx, (LogicalType)resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> {
            String method = (String)methods.apply((Object)operator);
            String leftCasted = (String)this.castToDec$1(left.resultType(), ctx, resultType).apply(leftTerm);
            String rightCasted = (String)this.castToDec$1(right.resultType(), ctx, resultType).apply(rightTerm);
            int precision = resultType.getPrecision();
            int scale = resultType.getScale();
            return new StringBuilder(9).append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".").append(method).append("(").append(leftCasted).append(", ").append(rightCasted).append(", ").append(precision).append(", ").append(scale).append(")").toString();
        });
    }

    public GeneratedExpression generateUnaryArithmeticOperator(CodeGeneratorContext ctx, String operator, LogicalType resultType, GeneratedExpression operand) {
        return this.generateUnaryOperatorIfNotNull(ctx, resultType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)operandTerm -> {
            String string;
            if (TypeCheckUtils.isDecimal((LogicalType)operand.resultType())) {
                String string2 = operator;
                String string3 = "-";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    string = new StringBuilder(9).append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".negate(").append((String)operandTerm).append(")").toString();
                    return string;
                }
            }
            if (TypeCheckUtils.isDecimal((LogicalType)operand.resultType())) {
                String string4 = operator;
                String string5 = "+";
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    string = String.valueOf(operandTerm);
                    return string;
                }
            }
            String typeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
            string = new StringBuilder(5).append("(").append(typeTerm).append(") ").append(operator).append("(").append((String)operandTerm).append(")").toString();
            return string;
        });
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateTemporalPlusMinus(CodeGeneratorContext ctx, boolean plus, LogicalType resultType, GeneratedExpression left, GeneratedExpression right) {
        block15: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        op = plus != false ? "+" : "-";
                                                        var15_7 = new Tuple2((Object)left.resultType().getTypeRoot(), (Object)right.resultType().getTypeRoot());
                                                        if (var15_7 == null) break block12;
                                                        var16_8 = (LogicalTypeRoot)var15_7._1();
                                                        var17_9 = (LogicalTypeRoot)var15_7._2();
                                                        if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var16_8) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var17_9)) break block12;
                                                        var13_10 = true;
                                                        break block13;
                                                    }
                                                    if (var15_7 == null) ** GOTO lbl-1000
                                                    var18_11 = (LogicalTypeRoot)var15_7._1();
                                                    var19_12 = (LogicalTypeRoot)var15_7._2();
                                                    if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var18_11) && LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var19_12)) {
                                                        var13_10 = true;
                                                    } else lbl-1000:
                                                    // 2 sources

                                                    {
                                                        var13_10 = false;
                                                    }
                                                }
                                                if (!var13_10) break block14;
                                                var6_13 = this.generateBinaryArithmeticOperator(ctx, op, left.resultType(), left, right);
                                                break block15;
                                            }
                                            if (var15_7 == null) break block16;
                                            var20_14 = (LogicalTypeRoot)var15_7._1();
                                            var21_15 = (LogicalTypeRoot)var15_7._2();
                                            if (!LogicalTypeRoot.DATE.equals(var20_14) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var21_15)) break block16;
                                            var22_16 = resultType.getTypeRoot();
                                            if (LogicalTypeRoot.DATE.equals(var22_16)) {
                                                var12_17 = this.generateOperatorIfNotNull(ctx, (LogicalType)new DateType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$1(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                                            } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var22_16)) {
                                                var12_17 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$2(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                                            } else {
                                                throw new MatchError((Object)var22_16);
                                            }
                                            var6_13 = var12_17;
                                            break block15;
                                        }
                                        if (var15_7 == null) break block17;
                                        var23_18 = (LogicalTypeRoot)var15_7._1();
                                        var24_19 = (LogicalTypeRoot)var15_7._2();
                                        if (!LogicalTypeRoot.DATE.equals(var23_18) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var24_19)) break block17;
                                        var6_13 = this.generateOperatorIfNotNull(ctx, (LogicalType)new DateType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$3(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                                        break block15;
                                    }
                                    if (var15_7 == null) break block18;
                                    var25_20 = (LogicalTypeRoot)var15_7._1();
                                    var26_21 = (LogicalTypeRoot)var15_7._2();
                                    if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var25_20) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var26_21)) break block18;
                                    var6_13 = this.generateOperatorIfNotNull(ctx, (LogicalType)new TimeType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$4(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                                    break block15;
                                }
                                if (var15_7 == null) break block19;
                                var27_22 = (LogicalTypeRoot)var15_7._1();
                                var28_23 = (LogicalTypeRoot)var15_7._2();
                                if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var27_22) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var28_23)) break block19;
                                var6_13 = this.generateOperatorIfNotNull(ctx, (LogicalType)new TimeType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$5(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)());
                                break block15;
                            }
                            if (var15_7 == null) break block20;
                            var29_24 = (LogicalTypeRoot)var15_7._1();
                            var30_25 = (LogicalTypeRoot)var15_7._2();
                            var11_26 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var29_24) != false ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var29_24) != false;
                            if (!var11_26 || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var30_25)) break block20;
                            var6_13 = this.generateOperatorIfNotNull(ctx, left.resultType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$6(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                            break block15;
                        }
                        if (var15_7 == null) break block21;
                        var31_27 = (LogicalTypeRoot)var15_7._1();
                        var32_28 = (LogicalTypeRoot)var15_7._2();
                        var10_29 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var31_27) != false ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var31_27) != false;
                        if (!var10_29 || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var32_28)) break block21;
                        var6_13 = this.generateOperatorIfNotNull(ctx, left.resultType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$7(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                        break block15;
                    }
                    if (var15_7 == null) break block22;
                    var33_30 = (LogicalTypeRoot)var15_7._1();
                    var34_31 = (LogicalTypeRoot)var15_7._2();
                    var9_32 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var33_30) != false ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var33_30) != false ? true : LogicalTypeRoot.DATE.equals(var33_30) != false);
                    if (!var9_32 || !(var8_33 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var34_31) != false ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var34_31) != false ? true : LogicalTypeRoot.DATE.equals(var34_31) != false)) || plus) break block22;
                    var35_34 = resultType.getTypeRoot();
                    if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var35_34)) {
                        var7_35 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$8(org.apache.flink.table.planner.codegen.GeneratedExpression org.apache.flink.table.planner.codegen.GeneratedExpression java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((GeneratedExpression)left, (GeneratedExpression)right));
                    } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var35_34)) {
                        var7_35 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$9(org.apache.flink.table.planner.codegen.GeneratedExpression org.apache.flink.table.planner.codegen.GeneratedExpression java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((GeneratedExpression)left, (GeneratedExpression)right, (String)op));
                    } else {
                        throw new MatchError((Object)var35_34);
                    }
                    var6_13 = var7_35;
                    break block15;
                }
                if (var15_7 == null) break block23;
                var36_36 = (LogicalTypeRoot)var15_7._1();
                t = (LogicalTypeRoot)var15_7._2();
                if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var36_36) || !t.getFamilies().contains(LogicalTypeFamily.DATETIME) || plus) break block23;
                var6_13 = this.generateTimestampLtzMinus(ctx, resultType, left, right);
                break block15;
            }
            if (var15_7 == null) ** GOTO lbl-1000
            t = (LogicalTypeRoot)var15_7._1();
            var39_39 = (LogicalTypeRoot)var15_7._2();
            if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var39_39) && t.getFamilies().contains(LogicalTypeFamily.DATETIME) && !plus) {
                var6_13 = this.generateTimestampLtzMinus(ctx, resultType, left, right);
            } else lbl-1000:
            // 2 sources

            {
                throw new CodeGenException("Unsupported temporal arithmetic.");
            }
        }
        return var6_13;
    }

    private GeneratedExpression generateTimestampLtzMinus(CodeGeneratorContext ctx, LogicalType resultType, GeneratedExpression left, GeneratedExpression right) {
        GeneratedExpression generatedExpression;
        LogicalTypeRoot logicalTypeRoot = resultType.getTypeRoot();
        if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
            generatedExpression = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(ll, rr) -> {
                block3: {
                    block2: {
                        Tuple2 tuple2 = new Tuple2((Object)left.resultType().getTypeRoot(), (Object)right.resultType().getTypeRoot());
                        if (tuple2 == null) break block2;
                        LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
                        LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._2();
                        if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot2)) break block3;
                    }
                    throw new CodeGenException("TIMESTAMP_LTZ only supports diff between the same type.");
                }
                String leftTerm = new StringBuilder(17).append((String)ll).append(".getMillisecond()").toString();
                String rightTerm = new StringBuilder(17).append((String)rr).append(".getMillisecond()").toString();
                String string = new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(leftTerm).append(", ").append(rightTerm).append(")").toString();
                return string;
            });
        } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
            generatedExpression = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(ll, rr) -> {
                block3: {
                    block2: {
                        Tuple2 tuple2 = new Tuple2((Object)left.resultType().getTypeRoot(), (Object)right.resultType().getTypeRoot());
                        if (tuple2 == null) break block2;
                        LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
                        LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._2();
                        if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot2)) break block3;
                    }
                    throw new CodeGenException("TIMESTAMP_LTZ only supports diff between the same type.");
                }
                String leftTerm = new StringBuilder(17).append((String)ll).append(".getMillisecond()").toString();
                String rightTerm = new StringBuilder(17).append((String)rr).append(".getMillisecond()").toString();
                String string = new StringBuilder(3).append(leftTerm).append(" - ").append(rightTerm).toString();
                return string;
            });
        } else {
            throw new CodeGenException("Unsupported temporal arithmetic.");
        }
        return generatedExpression;
    }

    public GeneratedExpression generateUnaryIntervalPlusMinus(CodeGeneratorContext ctx, boolean plus, LogicalType resultType, GeneratedExpression operand) {
        String operator = plus ? "+" : "-";
        return this.generateUnaryArithmeticOperator(ctx, operator, resultType, operand);
    }

    private void checkImplicitConversionValidity(GeneratedExpression left, GeneratedExpression right) {
        if (TypeCheckUtils.isNumeric((LogicalType)left.resultType()) && TypeCheckUtils.isCharacterString((LogicalType)right.resultType()) || TypeCheckUtils.isNumeric((LogicalType)right.resultType()) && TypeCheckUtils.isCharacterString((LogicalType)left.resultType())) {
            throw new ValidationException(new StringBuilder(59).append("implicit type conversion between ").append(String.valueOf(left.resultType().getTypeRoot())).append(" and ").append(String.valueOf(right.resultType().getTypeRoot())).append(" is not supported now").toString());
        }
    }

    private GeneratedExpression wrapExpressionIfNonEq(boolean isNonEq, GeneratedExpression equalsExpr, LogicalType resultType) {
        return isNonEq ? new GeneratedExpression(new StringBuilder(3).append("(!").append(equalsExpr.resultTerm()).append(")").toString(), equalsExpr.nullTerm(), equalsExpr.code(), resultType, GeneratedExpression$.MODULE$.apply$default$5()) : equalsExpr;
    }

    private GeneratedExpression generateEqualAndNonEqual(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right, String operator, LogicalType resultType) {
        GeneratedExpression generatedExpression;
        block19: {
            Tuple2 tuple2;
            boolean nonEq;
            while (true) {
                Tuple2 tuple22;
                boolean bl;
                this.checkImplicitConversionValidity(left, right);
                String string = operator;
                if ("==".equals(string)) {
                    bl = false;
                } else if ("!=".equals(string)) {
                    bl = true;
                } else {
                    throw new CodeGenException(new StringBuilder(34).append("Unsupported boolean comparison '").append(operator).append("'.").toString());
                }
                nonEq = bl;
                boolean canEqual = PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType());
                if (TypeCheckUtils.isCharacterString((LogicalType)left.resultType()) && TypeCheckUtils.isCharacterString((LogicalType)right.resultType())) {
                    generatedExpression = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(9).append((Object)(nonEq ? "!" : "")).append((String)leftTerm).append(".equals(").append((String)rightTerm).append(")").toString());
                    break block19;
                }
                if (TypeCheckUtils.isNumeric((LogicalType)left.resultType()) && TypeCheckUtils.isNumeric((LogicalType)right.resultType())) {
                    generatedExpression = this.generateComparison(ctx, operator, left, right, resultType);
                    break block19;
                }
                if (TypeCheckUtils.isArray((LogicalType)left.resultType()) && canEqual) {
                    generatedExpression = this.wrapExpressionIfNonEq(nonEq, this.generateArrayComparison(ctx, left, right, resultType), resultType);
                    break block19;
                }
                if (TypeCheckUtils.isMap((LogicalType)left.resultType()) && canEqual) {
                    MapType mapType = (MapType)left.resultType();
                    generatedExpression = this.wrapExpressionIfNonEq(nonEq, this.generateMapComparison(ctx, left, right, mapType.getKeyType(), mapType.getValueType(), resultType), resultType);
                    break block19;
                }
                if (TypeCheckUtils.isMultiset((LogicalType)left.resultType()) && canEqual) {
                    MultisetType multisetType = (MultisetType)left.resultType();
                    generatedExpression = this.wrapExpressionIfNonEq(nonEq, this.generateMapComparison(ctx, left, right, multisetType.getElementType(), (LogicalType)new IntType(false), resultType), resultType);
                    break block19;
                }
                if (TypeCheckUtils.isComparable((LogicalType)left.resultType()) && canEqual) {
                    generatedExpression = this.generateComparison(ctx, operator, left, right, resultType);
                    break block19;
                }
                if (TypeCheckUtils.isRaw((LogicalType)left.resultType()) && canEqual) {
                    Seq<String> seq = CodeGenUtils$.MODULE$.newNames(ctx, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                        throw new MatchError(seq);
                    }
                    String resultTerm = (String)((SeqLike)some.get()).apply(0);
                    String nullTerm = (String)((SeqLike)some.get()).apply(1);
                    Tuple2 tuple23 = new Tuple2((Object)resultTerm, (Object)nullTerm);
                    Tuple2 tuple24 = tuple23;
                    String resultTerm2 = (String)tuple24._1();
                    String nullTerm2 = (String)tuple24._2();
                    String genericSer = ctx.addReusableTypeSerializer(left.resultType());
                    String ser = new StringBuilder(21).append(genericSer).append(".getInnerSerializer()").toString();
                    String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(301).append("\n           |").append(left.code()).append("\n           |").append(right.code()).append("\n           |boolean ").append(nullTerm2).append(" = ").append(left.nullTerm()).append(" || ").append(right.nullTerm()).append(";\n           |boolean ").append(resultTerm2).append(" = ").append(CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType)).append(";\n           |if (!").append(nullTerm2).append(") {\n           |  ").append(left.resultTerm()).append(".ensureMaterialized(").append(ser).append(");\n           |  ").append(right.resultTerm()).append(".ensureMaterialized(").append(ser).append(");\n           |  ").append(resultTerm2).append(" =\n           |    ").append((Object)(nonEq ? "!" : "")).append(left.resultTerm()).append(".getBinarySection().\n           |    equals(").append(right.resultTerm()).append(".getBinarySection());\n           |}\n           |").toString())).stripMargin();
                    generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, code, resultType, GeneratedExpression$.MODULE$.apply$default$5());
                    break block19;
                }
                if ((!TypeCheckUtils.isTimePoint((LogicalType)left.resultType()) || !TypeCheckUtils.isCharacterString((LogicalType)right.resultType())) && (!TypeCheckUtils.isTimePoint((LogicalType)right.resultType()) || !TypeCheckUtils.isCharacterString((LogicalType)left.resultType()))) break;
                Tuple2 tuple25 = tuple22 = TypeCheckUtils.isTimePoint((LogicalType)left.resultType()) ? new Tuple2((Object)left, (Object)right) : new Tuple2((Object)right, (Object)left);
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                GeneratedExpression newLeft = (GeneratedExpression)tuple22._1();
                GeneratedExpression newRight = (GeneratedExpression)tuple22._2();
                Tuple2 tuple26 = new Tuple2((Object)newLeft, (Object)newRight);
                Tuple2 tuple27 = tuple26;
                GeneratedExpression newLeft2 = (GeneratedExpression)tuple27._1();
                GeneratedExpression newRight2 = (GeneratedExpression)tuple27._2();
                right = newRight2.literal() ? this.generateCastLiteral(ctx, newRight2, newLeft2.resultType()) : this.generateCast(ctx, newRight2, newLeft2.resultType(), true);
                left = newLeft2;
            }
            if (TypeCheckUtils.isReference((LogicalType)left.resultType())) {
                tuple2 = new Tuple2((Object)left, (Object)right);
            } else if (TypeCheckUtils.isReference((LogicalType)right.resultType())) {
                tuple2 = new Tuple2((Object)right, (Object)left);
            } else {
                throw new CodeGenException(new StringBuilder(25).append("Incomparable types: ").append(left.resultType()).append(" and ").append(String.valueOf(right.resultType())).toString());
            }
            Tuple2 tuple28 = tuple2;
            if (tuple28 == null) {
                throw new MatchError((Object)tuple28);
            }
            GeneratedExpression newLeft = (GeneratedExpression)tuple28._1();
            GeneratedExpression newRight = (GeneratedExpression)tuple28._2();
            Tuple2 tuple29 = new Tuple2((Object)newLeft, (Object)newRight);
            Tuple2 tuple210 = tuple29;
            GeneratedExpression newLeft3 = (GeneratedExpression)tuple210._1();
            GeneratedExpression newRight3 = (GeneratedExpression)tuple210._2();
            generatedExpression = this.generateOperatorIfNotNull(ctx, resultType, newLeft3, newRight3, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(9).append((Object)(nonEq ? "!" : "")).append((String)leftTerm).append(".equals(").append((String)rightTerm).append(")").toString());
        }
        return generatedExpression;
    }

    public GeneratedExpression generateEquals(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right, LogicalType resultType) {
        return this.generateEqualAndNonEqual(ctx, left, right, "==", resultType);
    }

    public GeneratedExpression generateNotEquals(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right, LogicalType resultType) {
        return this.generateEqualAndNonEqual(ctx, left, right, "!=", resultType);
    }

    public GeneratedExpression generateIsDistinctFrom(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right, LogicalType resultType) {
        return this.generateAnd(ctx, this.generateOr(ctx, this.generateIsNotNull(ctx, left, (LogicalType)new BooleanType(false)), this.generateIsNotNull(ctx, right, (LogicalType)new BooleanType(false)), resultType), this.generateIsNotTrue(this.generateEquals(ctx, left, right, resultType), (LogicalType)new BooleanType(false)), resultType);
    }

    public GeneratedExpression generateIsNotDistinctFrom(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right, LogicalType resultType) {
        return this.generateOr(ctx, this.generateAnd(ctx, this.generateIsNull(ctx, left, (LogicalType)new BooleanType(false)), this.generateIsNull(ctx, right, (LogicalType)new BooleanType(false)), resultType), this.generateIsTrue(this.generateEquals(ctx, left, right, resultType), (LogicalType)new BooleanType(false)), resultType);
    }

    public GeneratedExpression generateComparison(CodeGeneratorContext ctx, String operator, GeneratedExpression left, GeneratedExpression right, LogicalType resultType) {
        Function2 & Serializable & scala.Serializable intersect;
        boolean bl = this.generateOperatorIfNotNull$default$5();
        if (TypeCheckUtils.isDecimal((LogicalType)left.resultType()) || TypeCheckUtils.isDecimal((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(15).append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".compare(").append((String)leftTerm).append(", ").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
        } else if (TypeCheckUtils.isNumeric((LogicalType)left.resultType()) && TypeCheckUtils.isNumeric((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(2).append((String)leftTerm).append(" ").append(operator).append(" ").append((String)rightTerm).toString();
        } else if (TypeCheckUtils.isTimestamp((LogicalType)left.resultType()) && TypeCheckUtils.isTimestamp((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(15).append((String)leftTerm).append(".compareTo(").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
        } else if (TypeCheckUtils.isTimestampWithLocalZone((LogicalType)left.resultType()) && TypeCheckUtils.isTimestampWithLocalZone((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(15).append((String)leftTerm).append(".compareTo(").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
        } else if (TypeCheckUtils.isTemporal((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(2).append((String)leftTerm).append(" ").append(operator).append(" ").append((String)rightTerm).toString();
        } else if (TypeCheckUtils.isBoolean((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            Function2 & Serializable & scala.Serializable intersect2;
            String string = operator;
            boolean bl2 = "==".equals(string) ? true : "!=".equals(string);
            if (bl2) {
                intersect2 = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(2).append((String)leftTerm).append(" ").append(operator).append(" ").append((String)rightTerm).toString();
            } else {
                boolean bl3 = ">".equals(string) ? true : ("<".equals(string) ? true : ("<=".equals(string) ? true : ">=".equals(string)));
                if (bl3) {
                    intersect2 = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(32).append("java.lang.Boolean.compare(").append((String)leftTerm).append(", ").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
                } else {
                    throw new CodeGenException(new StringBuilder(34).append("Unsupported boolean comparison '").append(operator).append("'.").toString());
                }
            }
            intersect = intersect2;
        } else if (TypeCheckUtils.isBinaryString((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            String utilName = SqlFunctionUtils.class.getCanonicalName();
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(24).append(utilName).append(".byteArrayCompare(").append((String)leftTerm).append(", ").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
        } else if (TypeCheckUtils.isComparable((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(52).append("((").append((String)leftTerm).append(" == null) ? ((").append((String)rightTerm).append(" == null) ? 0 : -1) : ((").append((String)rightTerm).append(" == null) ? ").append(new StringBuilder(23).append("1 : (").append((String)leftTerm).append(".compareTo(").append((String)rightTerm).append(")))) ").append(operator).append(" 0").toString()).toString();
        } else {
            throw new CodeGenException(new StringBuilder(25).append("Incomparable types: ").append(left.resultType()).append(" and ").append(String.valueOf(right.resultType())).toString());
        }
        return this.generateOperatorIfNotNull(ctx, resultType, left, right, bl, (Function2<String, String, String>)intersect);
    }

    public GeneratedExpression generateIsNull(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType resultType) {
        GeneratedExpression generatedExpression;
        if (operand.resultType().isNullable()) {
            generatedExpression = new GeneratedExpression(operand.nullTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), resultType, GeneratedExpression$.MODULE$.apply$default$5());
        } else if (TypeCheckUtils.isReference((LogicalType)operand.resultType())) {
            String resultTerm = CodeGenUtils$.MODULE$.newName(ctx, "isNull");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n           |").append(operand.code()).append("\n           |boolean ").append(resultTerm).append(" = ").append(operand.resultTerm()).append(" == null;\n           |").toString())).stripMargin();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, resultType, GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = new GeneratedExpression("false", GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), resultType, GeneratedExpression$.MODULE$.apply$default$5());
        }
        return generatedExpression;
    }

    public GeneratedExpression generateIsNotNull(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType resultType) {
        GeneratedExpression generatedExpression;
        if (operand.resultType().isNullable()) {
            String resultTerm = CodeGenUtils$.MODULE$.newName(ctx, "result");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(52).append("\n           |").append(operand.code()).append("\n           |boolean ").append(resultTerm).append(" = !").append(operand.nullTerm()).append(";\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, resultType, GeneratedExpression$.MODULE$.apply$default$5());
        } else if (TypeCheckUtils.isReference((LogicalType)operand.resultType())) {
            String resultTerm = CodeGenUtils$.MODULE$.newName(ctx, "result");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n           |").append(operand.code()).append("\n           |boolean ").append(resultTerm).append(" = ").append(operand.resultTerm()).append(" != null;\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, resultType, GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = new GeneratedExpression("true", GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), resultType, GeneratedExpression$.MODULE$.apply$default$5());
        }
        return generatedExpression;
    }

    public GeneratedExpression generateAnd(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right, LogicalType resultType) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames(ctx, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(767).append("\n         |").append(left.code()).append("\n         |\n         |boolean ").append(resultTerm2).append(" = false;\n         |boolean ").append(nullTerm2).append(" = false;\n         |if (!").append(left.nullTerm()).append(" && !").append(left.resultTerm()).append(") {\n         |  // left expr is false, skip right expr\n         |} else {\n         |  ").append(right.code()).append("\n         |\n         |  if (!").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = ").append(left.resultTerm()).append(" && ").append(right.resultTerm()).append(";\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && ").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && !").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && ").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && !").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |}\n       ").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateOr(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right, LogicalType resultType) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames(ctx, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(765).append("\n         |").append(left.code()).append("\n         |\n         |boolean ").append(resultTerm2).append(" = true;\n         |boolean ").append(nullTerm2).append(" = false;\n         |if (!").append(left.nullTerm()).append(" && ").append(left.resultTerm()).append(") {\n         |  // left expr is true, skip right expr\n         |} else {\n         |  ").append(right.code()).append("\n         |\n         |  if (!").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = ").append(left.resultTerm()).append(" || ").append(right.resultTerm()).append(";\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && ").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = true;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && !").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && ").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = true;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && !").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |}\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateNot(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType resultType) {
        return this.generateUnaryOperatorIfNotNull(ctx, resultType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(3).append("!(").append((String)operandTerm).append(")").toString());
    }

    public GeneratedExpression generateIsTrue(GeneratedExpression operand, LogicalType resultType) {
        return new GeneratedExpression(operand.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsNotTrue(GeneratedExpression operand, LogicalType resultType) {
        return new GeneratedExpression(new StringBuilder(3).append("(!").append(operand.resultTerm()).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsFalse(GeneratedExpression operand, LogicalType resultType) {
        return new GeneratedExpression(new StringBuilder(8).append("(!").append(operand.resultTerm()).append(" && !").append(operand.nullTerm()).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsNotFalse(GeneratedExpression operand, LogicalType resultType) {
        return new GeneratedExpression(new StringBuilder(6).append("(").append(operand.resultTerm()).append(" || ").append(operand.nullTerm()).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateReinterpret(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType targetType) {
        block6: {
            block21: {
                block23: {
                    block24: {
                        block22: {
                            block20: {
                                block19: {
                                    block18: {
                                        block8: {
                                            block17: {
                                                block16: {
                                                    block15: {
                                                        block14: {
                                                            block13: {
                                                                block12: {
                                                                    block11: {
                                                                        block10: {
                                                                            block9: {
                                                                                block7: {
                                                                                    block5: {
                                                                                        var6_4 = new Tuple2((Object)operand.resultType().getTypeRoot(), (Object)targetType.getTypeRoot());
                                                                                        if (var6_4 == null || !PlannerTypeUtils.isInteroperable((LogicalType)operand.resultType(), (LogicalType)targetType)) break block5;
                                                                                        x$20 = targetType;
                                                                                        x$21 = operand.copy$default$1();
                                                                                        x$22 = operand.copy$default$2();
                                                                                        x$23 = operand.copy$default$3();
                                                                                        x$24 = operand.copy$default$5();
                                                                                        var4_10 = operand.copy(x$21, x$22, x$23, x$20, x$24);
                                                                                        break block6;
                                                                                    }
                                                                                    if (var6_4 == null) break block7;
                                                                                    var12_11 = (LogicalTypeRoot)var6_4._1();
                                                                                    var13_12 = (LogicalTypeRoot)var6_4._2();
                                                                                    if (!LogicalTypeRoot.DATE.equals(var12_11) || !LogicalTypeRoot.INTEGER.equals(var13_12)) break block7;
                                                                                    var5_13 = true;
                                                                                    break block8;
                                                                                }
                                                                                if (var6_4 == null) break block9;
                                                                                var14_14 = (LogicalTypeRoot)var6_4._1();
                                                                                var15_15 = (LogicalTypeRoot)var6_4._2();
                                                                                if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var14_14) || !LogicalTypeRoot.INTEGER.equals(var15_15)) break block9;
                                                                                var5_13 = true;
                                                                                break block8;
                                                                            }
                                                                            if (var6_4 == null) break block10;
                                                                            var16_16 = (LogicalTypeRoot)var6_4._1();
                                                                            var17_17 = (LogicalTypeRoot)var6_4._2();
                                                                            if (!LogicalTypeRoot.INTEGER.equals(var16_16) || !LogicalTypeRoot.DATE.equals(var17_17)) break block10;
                                                                            var5_13 = true;
                                                                            break block8;
                                                                        }
                                                                        if (var6_4 == null) break block11;
                                                                        var18_18 = (LogicalTypeRoot)var6_4._1();
                                                                        var19_19 = (LogicalTypeRoot)var6_4._2();
                                                                        if (!LogicalTypeRoot.INTEGER.equals(var18_18) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var19_19)) break block11;
                                                                        var5_13 = true;
                                                                        break block8;
                                                                    }
                                                                    if (var6_4 == null) break block12;
                                                                    var20_20 = (LogicalTypeRoot)var6_4._1();
                                                                    var21_21 = (LogicalTypeRoot)var6_4._2();
                                                                    if (!LogicalTypeRoot.INTEGER.equals(var20_20) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var21_21)) break block12;
                                                                    var5_13 = true;
                                                                    break block8;
                                                                }
                                                                if (var6_4 == null) break block13;
                                                                var22_22 = (LogicalTypeRoot)var6_4._1();
                                                                var23_23 = (LogicalTypeRoot)var6_4._2();
                                                                if (!LogicalTypeRoot.BIGINT.equals(var22_22) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var23_23)) break block13;
                                                                var5_13 = true;
                                                                break block8;
                                                            }
                                                            if (var6_4 == null) break block14;
                                                            var24_24 = (LogicalTypeRoot)var6_4._1();
                                                            var25_25 = (LogicalTypeRoot)var6_4._2();
                                                            if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var24_24) || !LogicalTypeRoot.INTEGER.equals(var25_25)) break block14;
                                                            var5_13 = true;
                                                            break block8;
                                                        }
                                                        if (var6_4 == null) break block15;
                                                        var26_26 = (LogicalTypeRoot)var6_4._1();
                                                        var27_27 = (LogicalTypeRoot)var6_4._2();
                                                        if (!LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var26_26) || !LogicalTypeRoot.BIGINT.equals(var27_27)) break block15;
                                                        var5_13 = true;
                                                        break block8;
                                                    }
                                                    if (var6_4 == null) break block16;
                                                    var28_28 = (LogicalTypeRoot)var6_4._1();
                                                    var29_29 = (LogicalTypeRoot)var6_4._2();
                                                    if (!LogicalTypeRoot.DATE.equals(var28_28) || !LogicalTypeRoot.BIGINT.equals(var29_29)) break block16;
                                                    var5_13 = true;
                                                    break block8;
                                                }
                                                if (var6_4 == null) break block17;
                                                var30_30 = (LogicalTypeRoot)var6_4._1();
                                                var31_31 = (LogicalTypeRoot)var6_4._2();
                                                if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var30_30) || !LogicalTypeRoot.BIGINT.equals(var31_31)) break block17;
                                                var5_13 = true;
                                                break block8;
                                            }
                                            if (var6_4 == null) ** GOTO lbl-1000
                                            var32_32 = (LogicalTypeRoot)var6_4._1();
                                            var33_33 = (LogicalTypeRoot)var6_4._2();
                                            if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var32_32) && LogicalTypeRoot.BIGINT.equals(var33_33)) {
                                                var5_13 = true;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                var5_13 = false;
                                            }
                                        }
                                        if (!var5_13) break block18;
                                        var4_10 = this.internalExprCasting(operand, targetType);
                                        break block6;
                                    }
                                    if (var6_4 == null) break block19;
                                    var34_34 = (LogicalTypeRoot)var6_4._1();
                                    var35_35 = (LogicalTypeRoot)var6_4._2();
                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var34_34) || !LogicalTypeRoot.BIGINT.equals(var35_35)) break block19;
                                    var4_10 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateReinterpret$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                    break block6;
                                }
                                if (var6_4 == null) break block20;
                                var36_36 = (LogicalTypeRoot)var6_4._1();
                                var37_37 = (LogicalTypeRoot)var6_4._2();
                                if (!LogicalTypeRoot.BIGINT.equals(var36_36) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var37_37)) break block20;
                                var4_10 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateReinterpret$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                break block6;
                            }
                            if (var6_4 == null) break block21;
                            from = (LogicalTypeRoot)var6_4._1();
                            to = (LogicalTypeRoot)var6_4._2();
                            v0 = from;
                            var40_40 = to;
                            if (v0 != null) break block22;
                            if (var40_40 == null) break block23;
                            break block24;
                        }
                        if (v0.equals(var40_40)) break block23;
                    }
                    throw new CodeGenException(new StringBuilder(38).append("Unsupported reinterpret from '").append(from).append("' to '").append(to).append("'.").toString());
                }
                var4_10 = operand;
                break block6;
            }
            throw new MatchError((Object)var6_4);
        }
        return var4_10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneratedExpression generateCast(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType targetType, boolean nullOnFailure) {
        CastRule<?, ?> rule;
        ctx.addReusableHeaderComment(new StringBuilder(16).append("Using option '").append(ExecutionConfigOptions.TABLE_EXEC_LEGACY_CAST_BEHAVIOUR.key()).append("':").append(new StringBuilder(2).append("'").append(this.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$isLegacyCastBehaviourEnabled(ctx)).append("'").toString()).toString());
        ctx.addReusableHeaderComment(new StringBuilder(10).append("Timezone: ").append(ctx.tableConfig()).toString());
        CastRule<?, ?> castRule = rule = CastRuleProvider.resolve(operand.resultType(), targetType);
        if (castRule instanceof CodeGeneratorCastRule) {
            CodeGeneratorCastRule codeGeneratorCastRule = (CodeGeneratorCastRule)castRule;
            LogicalType inputType = operand.resultType().copy(true);
            CastCodeBlock castCodeBlock = codeGeneratorCastRule.generateCodeBlock(this.toCodegenCastContext(ctx), operand.resultTerm(), operand.nullTerm(), inputType, targetType);
            if (codeGeneratorCastRule.canFail(inputType, targetType) && nullOnFailure) {
                String resultTerm = ctx.addReusableLocalVariable(CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType), "castRuleResult");
                String nullTerm = ctx.addReusableLocalVariable("boolean", "castRuleResultIsNull");
                String castCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(302).append("\n               | // --- Cast section generated by ").append(CodeGenUtils$.MODULE$.className(codeGeneratorCastRule.getClass())).append("\n               | try {\n               |   ").append(castCodeBlock.getCode()).append("\n               |   ").append(resultTerm).append(" = ").append(castCodeBlock.getReturnTerm()).append(";\n               |   ").append(nullTerm).append(" = ").append(castCodeBlock.getIsNullTerm()).append(";\n               | } catch (").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(Throwable.class))).append(" e) {\n               |   ").append(resultTerm).append(" = ").append(CodeGenUtils$.MODULE$.primitiveDefaultValue(targetType)).append(";\n               |   ").append(nullTerm).append(" = true;\n               | }\n               | // --- End cast section\n               ").toString())).stripMargin();
                return new GeneratedExpression(resultTerm, nullTerm, new StringBuilder(1).append(operand.code()).append("\n").append(castCode).toString(), targetType.copy(nullOnFailure), GeneratedExpression$.MODULE$.apply$default$5());
            }
            String castCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(126).append("\n               | // --- Cast section generated by ").append(CodeGenUtils$.MODULE$.className(codeGeneratorCastRule.getClass())).append("\n               | ").append(castCodeBlock.getCode()).append("\n               | // --- End cast section\n               ").toString())).stripMargin();
            return new GeneratedExpression(castCodeBlock.getReturnTerm(), castCodeBlock.getIsNullTerm(), new StringBuilder(0).append(operand.code()).append(castCode).toString(), targetType, GeneratedExpression$.MODULE$.apply$default$5());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Tuple2 tuple2 = new Tuple2((Object)operand.resultType().getTypeRoot(), (Object)targetType.getTypeRoot());
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) && LogicalTypeRoot.DATE.equals(logicalTypeRoot2)) {
                if (!this.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$isLegacyCastBehaviourEnabled(ctx)) throw new CodeGenException(new StringBuilder(46).append("Only legacy cast behaviour supports cast from ").append(new StringBuilder(9).append("'").append(operand.resultType()).append("' to '").append(targetType).append("'.").toString()).toString());
                return this.internalExprCasting(operand, targetType);
            }
        }
        if (tuple2 != null && PlannerTypeUtils.isInteroperable((LogicalType)operand.resultType(), (LogicalType)targetType)) {
            LogicalType x$25 = targetType;
            String x$26 = operand.copy$default$1();
            String x$27 = operand.copy$default$2();
            String x$28 = operand.copy$default$3();
            Option<Object> x$29 = operand.copy$default$5();
            return operand.copy(x$26, x$27, x$28, x$25, x$29);
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        throw new CodeGenException(new StringBuilder(31).append("Unsupported cast from '").append(operand.resultType()).append("' to '").append(targetType).append("'.").toString());
    }

    public GeneratedExpression generateIfElse(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType resultType, int i) {
        GeneratedExpression generatedExpression;
        if (i == operands.size() - 1) {
            generatedExpression = this.generateCast(ctx, (GeneratedExpression)operands.apply(i), resultType, true);
        } else {
            CodeGenUtils$.MODULE$.requireBoolean((GeneratedExpression)operands.apply(i));
            GeneratedExpression condition = (GeneratedExpression)operands.apply(i);
            GeneratedExpression trueAction = this.generateCast(ctx, (GeneratedExpression)operands.apply(i + 1), resultType, true);
            GeneratedExpression falseAction = this.generateIfElse(ctx, operands, resultType, i + 2);
            Seq<String> seq = CodeGenUtils$.MODULE$.newNames(ctx, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError(seq);
            }
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            Tuple2 tuple22 = tuple2;
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType);
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(321).append("\n           |").append(condition.code()).append("\n           |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(defaultValue).append(";\n           |boolean ").append(nullTerm2).append(";\n           |if (").append(condition.resultTerm()).append(") {\n           |  ").append(trueAction.code()).append("\n           |  ").append(nullTerm2).append(" = ").append(trueAction.nullTerm()).append(";\n           |  if (!").append(nullTerm2).append(") {\n           |    ").append(resultTerm2).append(" = ").append(trueAction.resultTerm()).append(";\n           |  }\n           |}\n           |else {\n           |  ").append(falseAction.code()).append("\n           |  ").append(nullTerm2).append(" = ").append(falseAction.nullTerm()).append(";\n           |  if (!").append(nullTerm2).append(") {\n           |    ").append(resultTerm2).append(" = ").append(falseAction.resultTerm()).append(";\n           |  }\n           |}\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, resultType, GeneratedExpression$.MODULE$.apply$default$5());
        }
        return generatedExpression;
    }

    public int generateIfElse$default$4() {
        return 0;
    }

    public GeneratedExpression generateDot(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands) {
        if (operands.size() > 2) {
            throw new CodeGenException("A DOT operator with more than 2 operands is not supported yet.");
        }
        Preconditions.checkArgument((boolean)((GeneratedExpression)operands.apply(1)).literal());
        Preconditions.checkArgument((boolean)TypeCheckUtils.isCharacterString((LogicalType)((GeneratedExpression)operands.apply(1)).resultType()));
        Preconditions.checkArgument((boolean)(((GeneratedExpression)operands.head()).resultType() instanceof RowType));
        String fieldName = ((GeneratedExpression)operands.apply(1)).literalValue().get().toString();
        int fieldIdx = ((RowType)((GeneratedExpression)operands.head()).resultType()).getFieldIndex(fieldName);
        GeneratedExpression access = GenerateUtils$.MODULE$.generateFieldAccess(ctx, ((GeneratedExpression)operands.head()).resultType(), ((GeneratedExpression)operands.head()).resultTerm(), fieldIdx);
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames(ctx, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(access.resultType());
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(access.resultType());
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(199).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(resultTypeTerm).append(" ").append(resultTerm2).append(";\n         |boolean ").append(nullTerm2).append(";\n         |if (").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.nullTerm(), Seq$.MODULE$.canBuildFrom())).mkString(" || ")).append(") {\n         |  ").append(resultTerm2).append(" = ").append(defaultValue).append(";\n         |  ").append(nullTerm2).append(" = true;\n         |}\n         |else {\n         |  ").append(access.code()).append("\n         |  ").append(resultTerm2).append(" = ").append(access.resultTerm()).append(";\n         |  ").append(nullTerm2).append(" = ").append(access.nullTerm()).append(";\n         |}\n         |").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, resultCode, access.resultType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateRow(CodeGeneratorContext ctx, LogicalType rowType, Seq<GeneratedExpression> elements) {
        GeneratedExpression generatedExpression;
        List fieldTypes = LogicalTypeChecks.getFieldTypes((LogicalType)rowType);
        boolean isLiteral = elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal()));
        boolean isPrimitive = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScalarOperatorGens$.$anonfun$generateRow$2(x$1)));
        if (isLiteral) {
            generatedExpression = this.generateLiteralRow(ctx, rowType, elements);
        } else if (isPrimitive) {
            Seq mapped = (Seq)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                GeneratedExpression generatedExpression;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    GeneratedExpression element = (GeneratedExpression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (element.literal()) {
                        generatedExpression = element;
                    } else {
                        LogicalType tpe = (LogicalType)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).apply(idx);
                        String resultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(tpe);
                        generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.ALWAYS_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), tpe, (Option<Object>)new Some(null));
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                GeneratedExpression generatedExpression2 = generatedExpression;
                return generatedExpression2;
            }, Seq$.MODULE$.canBuildFrom());
            GeneratedExpression row = this.generateLiteralRow(ctx, rowType, (Seq<GeneratedExpression>)mapped);
            String code = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                GeneratedExpression element = (GeneratedExpression)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                LogicalType tpe = (LogicalType)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).apply(idx);
                String string = element.literal() ? "" : (tpe.isNullable() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(160).append("\n                   |").append(element.code()).append("\n                   |if (").append(element.nullTerm()).append(") {\n                   |  ").append(CodeGenUtils$.MODULE$.binaryRowSetNull(idx, row.resultTerm(), tpe)).append(";\n                   |} else {\n                   |  ").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, row.resultTerm(), tpe, element.resultTerm())).append(";\n                   |}\n           ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(55).append("\n                   |").append(element.code()).append("\n                   |").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, row.resultTerm(), tpe, element.resultTerm())).append(";\n           ").toString())).stripMargin());
                return string;
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
            generatedExpression = new GeneratedExpression(row.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), code, rowType, GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = this.generateNonLiteralRow(ctx, rowType, elements);
        }
        return generatedExpression;
    }

    private GeneratedExpression generateLiteralRow(CodeGeneratorContext ctx, LogicalType rowType, Seq<GeneratedExpression> elements) {
        Preconditions.checkArgument((boolean)elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal())));
        GeneratedExpression expr = this.generateNonLiteralRow(ctx, rowType, elements);
        ctx.addReusableInitStatement(expr.code());
        return new GeneratedExpression(expr.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), rowType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private GeneratedExpression generateNonLiteralRow(CodeGeneratorContext ctx, LogicalType rowType, Seq<GeneratedExpression> elements) {
        List fieldTypes = LogicalTypeChecks.getFieldTypes((LogicalType)rowType);
        String rowTerm = CodeGenUtils$.MODULE$.newName(ctx, "row");
        String writerTerm = CodeGenUtils$.MODULE$.newName(ctx, "writer");
        String writerCls = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(BinaryRowWriter.class));
        String writeCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression element = (GeneratedExpression)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            LogicalType tpe = (LogicalType)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).apply(idx);
            String string = tpe.isNullable() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(136).append("\n               |").append(element.code()).append("\n               |if (").append(element.nullTerm()).append(") {\n               |  ").append(CodeGenUtils$.MODULE$.binaryWriterWriteNull(idx, writerTerm, tpe)).append(";\n               |} else {\n               |  ").append(CodeGenUtils$.MODULE$.binaryWriterWriteField(ctx, idx, element.resultTerm(), writerTerm, tpe)).append(";\n               |}\n           ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(47).append("\n               |").append(element.code()).append("\n               |").append(CodeGenUtils$.MODULE$.binaryWriterWriteField(ctx, idx, element.resultTerm(), writerTerm, tpe)).append(";\n           ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n         |").append(writerTerm).append(".reset();\n         |").append(writeCode).append("\n         |").append(writerTerm).append(".complete();\n       ").toString())).stripMargin();
        ctx.addReusableMember(new StringBuilder(11).append(CodeGenUtils$.MODULE$.BINARY_ROW()).append(" ").append(rowTerm).append(" = new ").append(CodeGenUtils$.MODULE$.BINARY_ROW()).append("(").append(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).length()).append(");").toString());
        ctx.addReusableMember(new StringBuilder(11).append(writerCls).append(" ").append(writerTerm).append(" = new ").append(writerCls).append("(").append(rowTerm).append(");").toString());
        return new GeneratedExpression(rowTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, rowType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArray(CodeGeneratorContext ctx, LogicalType resultType, Seq<GeneratedExpression> elements) {
        GeneratedExpression generatedExpression;
        Preconditions.checkArgument((boolean)(resultType instanceof ArrayType));
        ArrayType arrayType = (ArrayType)resultType;
        LogicalType elementType = arrayType.getElementType();
        boolean isLiteral = elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal()));
        boolean isPrimitive = PlannerTypeUtils.isPrimitive((LogicalType)elementType);
        if (isLiteral) {
            generatedExpression = this.generateLiteralArray(ctx, arrayType, elements);
        } else if (isPrimitive) {
            Seq mapped = (Seq)elements.map((Function1 & Serializable & scala.Serializable)element -> {
                GeneratedExpression generatedExpression;
                if (element.literal()) {
                    generatedExpression = element;
                } else {
                    String resultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType);
                    generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.ALWAYS_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), elementType, (Option<Object>)new Some(null));
                }
                return generatedExpression;
            }, Seq$.MODULE$.canBuildFrom());
            GeneratedExpression array = this.generateLiteralArray(ctx, arrayType, (Seq<GeneratedExpression>)mapped);
            String code = this.generatePrimitiveArrayUpdateCode(array.resultTerm(), elementType, elements);
            generatedExpression = new GeneratedExpression(array.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), code, (LogicalType)arrayType, GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = this.generateNonLiteralArray(ctx, arrayType, elements);
        }
        return generatedExpression;
    }

    private String generatePrimitiveArrayUpdateCode(String arrayTerm, LogicalType elementType, Seq<GeneratedExpression> elements) {
        return ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression element = (GeneratedExpression)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            String string = element.literal() ? "" : (elementType.isNullable() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(138).append("\n               |").append(element.code()).append("\n               |if (").append(element.nullTerm()).append(") {\n               |  ").append(CodeGenUtils$.MODULE$.binaryArraySetNull(idx, arrayTerm, elementType)).append(";\n               |} else {\n               |  ").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, arrayTerm, elementType, element.resultTerm())).append(";\n               |}\n             ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n               |").append(element.code()).append("\n               |").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, arrayTerm, elementType, element.resultTerm())).append(";\n             ").toString())).stripMargin());
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private GeneratedExpression generateLiteralArray(CodeGeneratorContext ctx, ArrayType arrayType, Seq<GeneratedExpression> elements) {
        Preconditions.checkArgument((boolean)elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal())));
        GeneratedExpression expr = this.generateNonLiteralArray(ctx, arrayType, elements);
        ctx.addReusableInitStatement(expr.code());
        return new GeneratedExpression(expr.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), (LogicalType)arrayType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private GeneratedExpression generateNonLiteralArray(CodeGeneratorContext ctx, ArrayType arrayType, Seq<GeneratedExpression> elements) {
        LogicalType elementType = arrayType.getElementType();
        String arrayTerm = CodeGenUtils$.MODULE$.newName(ctx, "array");
        String writerTerm = CodeGenUtils$.MODULE$.newName(ctx, "writer");
        String writerCls = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(BinaryArrayWriter.class));
        int elementSize = BinaryArrayData.calculateFixLengthPartSize((LogicalType)elementType);
        String writeCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression element = (GeneratedExpression)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(123).append("\n             |").append(element.code()).append("\n             |if (").append(element.nullTerm()).append(") {\n             |  ").append(CodeGenUtils$.MODULE$.binaryArraySetNull(idx, writerTerm, elementType)).append(";\n             |} else {\n             |  ").append(CodeGenUtils$.MODULE$.binaryWriterWriteField(ctx, idx, element.resultTerm(), writerTerm, elementType)).append(";\n             |}\n          ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n         |").append(writerTerm).append(".reset();\n         |").append(writeCode).append("\n         |").append(writerTerm).append(".complete();\n         ").toString())).stripMargin();
        String memberStmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(56).append("\n         |").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(arrayTerm).append(" = new ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append("();\n         |").append(writerCls).append(" ").append(writerTerm).append(" = new ").append(writerCls).append("(").append(arrayTerm).append(", ").append(elements.length()).append(", ").append(elementSize).append(");\n       ").toString())).stripMargin();
        ctx.addReusableMember(memberStmt);
        return new GeneratedExpression(arrayTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, (LogicalType)arrayType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArrayElementAt(CodeGeneratorContext ctx, GeneratedExpression array, GeneratedExpression index) {
        int n;
        Some some;
        Object v;
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames(ctx, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some2.get()).apply(0);
        String nullTerm = (String)((SeqLike)some2.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        LogicalType componentInfo = ((ArrayType)array.resultType()).getElementType();
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(componentInfo);
        String defaultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(componentInfo);
        Option<Object> option = index.literalValue();
        if (option instanceof Some && (v = (some = (Some)option).value()) instanceof Integer && (n = BoxesRunTime.unboxToInt((Object)v)) < 1) {
            throw new ValidationException(new StringBuilder(59).append("Array element access needs an index starting at 1 but was ").append(n).append(".").toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        String idxStr = new StringBuilder(4).append(index.resultTerm()).append(" - 1").toString();
        String arrayIsNull = new StringBuilder(11).append(array.resultTerm()).append(".isNullAt(").append(idxStr).append(")").toString();
        String arrayGet = CodeGenUtils$.MODULE$.rowFieldReadAccess(idxStr, array.resultTerm(), componentInfo);
        String arrayAccessCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n         |").append(array.code()).append("\n         |").append(index.code()).append("\n         |boolean ").append(nullTerm2).append(" = ").append(array.nullTerm()).append(" || ").append(index.nullTerm()).append(" ||\n         |   ").append(idxStr).append(" < 0 || ").append(idxStr).append(" >= ").append(array.resultTerm()).append(".size() || ").append(arrayIsNull).append(";\n         |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(nullTerm2).append(" ? ").append(defaultTerm).append(" : ").append(arrayGet).append(";\n         |").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, arrayAccessCode, componentInfo, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArrayElement(CodeGeneratorContext ctx, GeneratedExpression array) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames(ctx, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        LogicalType resultType = ((ArrayType)array.resultType()).getElementType();
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType);
        String arrayLengthCode = new StringBuilder(14).append(array.nullTerm()).append(" ? 0 : ").append(array.resultTerm()).append(".size()").toString();
        String arrayGet = CodeGenUtils$.MODULE$.rowFieldReadAccess(0, array.resultTerm(), resultType);
        String arrayAccessCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(368).append("\n         |").append(array.code()).append("\n         |boolean ").append(nullTerm2).append(";\n         |").append(resultTypeTerm).append(" ").append(resultTerm2).append(";\n         |switch (").append(arrayLengthCode).append(") {\n         |  case 0:\n         |    ").append(nullTerm2).append(" = true;\n         |    ").append(resultTerm2).append(" = ").append(defaultValue).append(";\n         |    break;\n         |  case 1:\n         |    ").append(nullTerm2).append(" = ").append(array.resultTerm()).append(".isNullAt(0);\n         |    ").append(resultTerm2).append(" = ").append(nullTerm2).append(" ? ").append(defaultValue).append(" : ").append(arrayGet).append(";\n         |    break;\n         |  default:\n         |    throw new RuntimeException(\"Array has more than one element.\");\n         |}\n         |").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, arrayAccessCode, resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArrayCardinality(CodeGeneratorContext ctx, GeneratedExpression array, LogicalType resultType) {
        return this.generateUnaryOperatorIfNotNull(ctx, resultType, array, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$12 -> new StringBuilder(7).append(array.resultTerm()).append(".size()").toString());
    }

    public GeneratedExpression generateGreatestLeast(CodeGeneratorContext ctx, LogicalType resultType, Seq<GeneratedExpression> elements, boolean greatest) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames(ctx, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "tmpResult", "cur", "nullTerm"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) {
            throw new MatchError(seq);
        }
        String result = (String)((SeqLike)some.get()).apply(0);
        String tmpResult = (String)((SeqLike)some.get()).apply(1);
        String cur = (String)((SeqLike)some.get()).apply(2);
        String nullTerm = (String)((SeqLike)some.get()).apply(3);
        Tuple4 tuple4 = new Tuple4((Object)result, (Object)tmpResult, (Object)cur, (Object)nullTerm);
        Tuple4 tuple42 = tuple4;
        String result2 = (String)tuple42._1();
        String tmpResult2 = (String)tuple42._2();
        String cur2 = (String)tuple42._3();
        String nullTerm2 = (String)tuple42._4();
        Option widerType = JavaScalaConversionUtil$.MODULE$.toScala(LogicalTypeMerging.findCommonType((List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)elements.map((Function1 & Serializable & scala.Serializable)element -> element.resultType(), Seq$.MODULE$.canBuildFrom())))).orElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new CodeGenException(new StringBuilder(32).append("Unable to find common type for ").append(elements).append(".").toString());
        });
        String boxedResultTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType((LogicalType)widerType.get());
        String primitiveResultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType((LogicalType)widerType.get());
        String elementsCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression element = (GeneratedExpression)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(380).append("\n             | ").append(element.code()).append("\n             | ").append((Object)(index == 0 ? new StringBuilder(4).append(tmpResult2).append(" = ").append(this.castIfNumeric$1((GeneratedExpression)elements.head(), ctx, widerType)).append(";").toString() : "")).append("\n             | if (!").append(nullTerm2).append(") {\n             |   ").append(boxedResultTypeTerm).append(" ").append(cur2).append(" = ").append(this.castIfNumeric$1(element, ctx, widerType)).append(";\n             |   if (").append(element.nullTerm()).append(") {\n             |     ").append(nullTerm2).append(" = true;\n             |   } else {\n             |     int compareResult = ").append(tmpResult2).append(".compareTo(").append(cur2).append(");\n             |     if ((").append(greatest).append(" && compareResult < 0) || (compareResult > 0 && !").append(greatest).append(")) {\n             |       ").append(tmpResult2).append(" = ").append(cur2).append(";\n             |     }\n             |   }\n             | }\n       ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(131).append("\n         | ").append(boxedResultTypeTerm).append(" ").append(tmpResult2).append(";\n         | ").append(primitiveResultTypeTerm).append(" ").append(result2).append(" = ").append(CodeGenUtils$.MODULE$.primitiveDefaultValue((LogicalType)widerType.get())).append(";\n         | boolean ").append(nullTerm2).append(" = false;\n         | ").append(elementsCode).append("\n         | if (!").append(nullTerm2).append(") {\n         |   ").append(result2).append(" = ").append(tmpResult2).append(";\n         | }\n       ").toString())).stripMargin();
        return new GeneratedExpression(result2, nullTerm2, code, resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public boolean generateGreatestLeast$default$4() {
        return true;
    }

    public GeneratedExpression generateMap(CodeGeneratorContext ctx, LogicalType resultType, Seq<GeneratedExpression> elements) {
        String string;
        Preconditions.checkArgument((boolean)(resultType instanceof MapType));
        MapType mapType = (MapType)resultType;
        String baseMap = CodeGenUtils$.MODULE$.newName(ctx, "map");
        Seq keyElements = ((MapLike)elements.grouped(2).map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Seq seq = x0$7;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            GeneratedExpression key = (GeneratedExpression)((SeqLike)some.get()).apply(0);
            GeneratedExpression value = (GeneratedExpression)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)key, (Object)value);
            return tuple2;
        }).toSeq().groupBy((Function1 & Serializable & scala.Serializable)x$14 -> (GeneratedExpression)x$14._1()).map((Function1 & Serializable & scala.Serializable)x$15 -> (Tuple2)((TraversableLike)x$15._2()).last(), Map$.MODULE$.canBuildFrom())).keys().toSeq();
        LogicalType keyType = mapType.getKeyType();
        GeneratedExpression keyExpr = this.generateArray(ctx, (LogicalType)new ArrayType(keyType), (Seq<GeneratedExpression>)keyElements);
        boolean isKeyFixLength = PlannerTypeUtils.isPrimitive((LogicalType)keyType);
        Seq valueElements = ((MapLike)elements.grouped(2).map((Function1 & Serializable & scala.Serializable)x0$8 -> {
            Seq seq = x0$8;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            GeneratedExpression key = (GeneratedExpression)((SeqLike)some.get()).apply(0);
            GeneratedExpression value = (GeneratedExpression)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)key, (Object)value);
            return tuple2;
        }).toSeq().groupBy((Function1 & Serializable & scala.Serializable)x$16 -> (GeneratedExpression)x$16._1()).map((Function1 & Serializable & scala.Serializable)x$17 -> (Tuple2)((TraversableLike)x$17._2()).last(), Map$.MODULE$.canBuildFrom())).values().toSeq();
        LogicalType valueType = mapType.getValueType();
        GeneratedExpression valueExpr = this.generateArray(ctx, (LogicalType)new ArrayType(valueType), (Seq<GeneratedExpression>)valueElements);
        boolean isValueFixLength = PlannerTypeUtils.isPrimitive((LogicalType)valueType);
        ctx.addReusableMember(new StringBuilder(9).append(CodeGenUtils$.MODULE$.MAP_DATA()).append(" ").append(baseMap).append(" = null;").toString());
        if (isKeyFixLength && isValueFixLength) {
            String binaryMap = CodeGenUtils$.MODULE$.newName(ctx, "binaryMap");
            ctx.addReusableMember(new StringBuilder(9).append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(" ").append(binaryMap).append(" = null;").toString());
            String init = new StringBuilder(16).append(binaryMap).append(" = ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(".valueOf(").append(keyExpr.resultTerm()).append(", ").append(valueExpr.resultTerm()).append(");").toString();
            ctx.addReusableInitStatement(init);
            String keyArrayTerm = CodeGenUtils$.MODULE$.newName(ctx, "keyArray");
            String valueArrayTerm = CodeGenUtils$.MODULE$.newName(ctx, "valueArray");
            String keyUpdate = this.generatePrimitiveArrayUpdateCode(keyArrayTerm, keyType, (Seq<GeneratedExpression>)keyElements);
            String valueUpdate = this.generatePrimitiveArrayUpdateCode(valueArrayTerm, valueType, (Seq<GeneratedExpression>)valueElements);
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(101).append("\n         |").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(keyArrayTerm).append(" = ").append(binaryMap).append(".keyArray();\n         |").append(keyUpdate).append("\n         |").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(valueArrayTerm).append(" = ").append(binaryMap).append(".valueArray();\n         |").append(valueUpdate).append("\n         |").append(baseMap).append(" = ").append(binaryMap).append(";\n       ").toString())).stripMargin();
        } else {
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(57).append("\n         |").append(keyExpr.code()).append("\n         |").append(valueExpr.code()).append("\n         |").append(baseMap).append(" = ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(".valueOf(").append(keyExpr.resultTerm()).append(", ").append(valueExpr.resultTerm()).append(");\n       ").toString())).stripMargin();
        }
        String code = string;
        return new GeneratedExpression(baseMap, GeneratedExpression$.MODULE$.NEVER_NULL(), code, resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateMapGet(CodeGeneratorContext ctx, GeneratedExpression map, GeneratedExpression key) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames(ctx, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String tmpKey = CodeGenUtils$.MODULE$.newName(ctx, "key");
        String length = CodeGenUtils$.MODULE$.newName(ctx, "length");
        String keys = CodeGenUtils$.MODULE$.newName(ctx, "keys");
        String values = CodeGenUtils$.MODULE$.newName(ctx, "values");
        String index = CodeGenUtils$.MODULE$.newName(ctx, "index");
        String found = CodeGenUtils$.MODULE$.newName(ctx, "found");
        String tmpValue = CodeGenUtils$.MODULE$.newName(ctx, "value");
        MapType mapType = (MapType)map.resultType();
        LogicalType keyType = mapType.getKeyType();
        LogicalType valueType = mapType.getValueType();
        String keyTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(keyType);
        String valueTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(valueType);
        String valueDefault = CodeGenUtils$.MODULE$.primitiveDefaultValue(valueType);
        String binaryMapTerm = CodeGenUtils$.MODULE$.newName(ctx, "binaryMap");
        String genericMapTerm = CodeGenUtils$.MODULE$.newName(ctx, "genericMap");
        String boxedValueTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(valueType);
        String mapTerm = map.resultTerm();
        GeneratedExpression equal = this.generateEquals(ctx, new GeneratedExpression(key.resultTerm(), key.nullTerm(), GeneratedExpression$.MODULE$.NO_CODE(), key.resultType(), key.literalValue()), new GeneratedExpression(tmpKey, GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), keyType, GeneratedExpression$.MODULE$.apply$default$5()), (LogicalType)new BooleanType(key.resultType().isNullable()));
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(995).append("\n         |if (").append(mapTerm).append(" instanceof ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(") {\n         |  ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(" ").append(binaryMapTerm).append(" = (").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(") ").append(mapTerm).append(";\n         |  final int ").append(length).append(" = ").append(binaryMapTerm).append(".size();\n         |  final ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(keys).append(" = ").append(binaryMapTerm).append(".keyArray();\n         |  final ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(values).append(" = ").append(binaryMapTerm).append(".valueArray();\n         |\n         |  int ").append(index).append(" = 0;\n         |  boolean ").append(found).append(" = false;\n         |  if (").append(key.nullTerm()).append(") {\n         |    while (").append(index).append(" < ").append(length).append(" && !").append(found).append(") {\n         |      if (").append(keys).append(".isNullAt(").append(index).append(")) {\n         |        ").append(found).append(" = true;\n         |      } else {\n         |        ").append(index).append("++;\n         |      }\n         |    }\n         |  } else {\n         |    while (").append(index).append(" < ").append(length).append(" && !").append(found).append(") {\n         |      final ").append(keyTypeTerm).append(" ").append(tmpKey).append(" = ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(index, keys, keyType)).append(";\n         |      ").append(equal.code()).append("\n         |      if (").append(equal.resultTerm()).append(") {\n         |        ").append(found).append(" = true;\n         |      } else {\n         |        ").append(index).append("++;\n         |      }\n         |    }\n         |  }\n         |\n         |  if (!").append(found).append(" || ").append(values).append(".isNullAt(").append(index).append(")) {\n         |    ").append(nullTerm2).append(" = true;\n         |  } else {\n         |    ").append(resultTerm2).append(" = ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(index, values, valueType)).append(";\n         |  }\n         |} else {\n         |  ").append(CodeGenUtils$.MODULE$.GENERIC_MAP()).append(" ").append(genericMapTerm).append(" = (").append(CodeGenUtils$.MODULE$.GENERIC_MAP()).append(") ").append(mapTerm).append(";\n         |  ").append(boxedValueTypeTerm).append(" ").append(tmpValue).append(" =\n         |    (").append(boxedValueTypeTerm).append(") ").append(genericMapTerm).append(".get((").append(keyTypeTerm).append(") ").append(key.resultTerm()).append(");\n         |  if (").append(tmpValue).append(" == null) {\n         |    ").append(nullTerm2).append(" = true;\n         |  } else {\n         |    ").append(resultTerm2).append(" = ").append(tmpValue).append(";\n         |  }\n         |}\n        ").toString())).stripMargin();
        String accessCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(119).append("\n         |").append(map.code()).append("\n         |").append(key.code()).append("\n         |boolean ").append(nullTerm2).append(" = (").append(map.nullTerm()).append(" || ").append(key.nullTerm()).append(");\n         |").append(valueTypeTerm).append(" ").append(resultTerm2).append(" = ").append(valueDefault).append(";\n         |if (!").append(nullTerm2).append(") {\n         | ").append(code).append("\n         |}\n        ").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, accessCode, valueType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateMapCardinality(CodeGeneratorContext ctx, GeneratedExpression map, LogicalType resultType) {
        return this.generateUnaryOperatorIfNotNull(ctx, resultType, map, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$19 -> new StringBuilder(7).append(map.resultTerm()).append(".size()").toString());
    }

    private GeneratedExpression generateCastLiteral(CodeGeneratorContext ctx, GeneratedExpression literalExpr, LogicalType resultType) {
        GeneratedExpression generatedExpression;
        Preconditions.checkArgument((boolean)literalExpr.literal());
        if (Predef$.MODULE$.Boolean2boolean(Boolean.valueOf(literalExpr.nullTerm()))) {
            return GenerateUtils$.MODULE$.generateNullLiteral(resultType);
        }
        CastExecutor<?, ?> castExecutor = CastRuleProvider.create(this.toCastContext(ctx), literalExpr.resultType(), resultType);
        if (castExecutor == null) {
            throw new CodeGenException(new StringBuilder(29).append("Unsupported casting from ").append(literalExpr.resultType()).append(" to ").append(resultType).toString());
        }
        try {
            Object result = castExecutor.cast(literalExpr.literalValue().get());
            String resultTerm = CodeGenUtils$.MODULE$.newName(ctx, "stringToTime");
            String declStmt = new StringBuilder(5).append(CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType)).append(" ").append(resultTerm).append(" = ").append(CodeGenUtils$.MODULE$.primitiveLiteralForType(result)).append(";").toString();
            ctx.addReusableMember(declStmt);
            generatedExpression = new GeneratedExpression(resultTerm, "false", "", resultType, (Option<Object>)new Some(result));
        }
        catch (Throwable e) {
            throw new ValidationException(new StringBuilder(28).append("Error when casting literal. ").append(e.getMessage()).toString(), e);
        }
        return generatedExpression;
    }

    private GeneratedExpression generateArrayComparison(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right, LogicalType resultType) {
        return GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, resultType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$4(), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$5(), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)args -> {
            String leftTerm = (String)args.head();
            String rightTerm = (String)args.apply(1);
            String resultTerm = CodeGenUtils$.MODULE$.newName(ctx, "compareResult");
            LogicalType elementType = ((ArrayType)left.resultType()).getElementType();
            String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
            String elementDefault = CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType);
            String leftElementTerm = CodeGenUtils$.MODULE$.newName(ctx, "leftElement");
            String leftElementNullTerm = CodeGenUtils$.MODULE$.newName(ctx, "leftElementIsNull");
            GeneratedExpression leftElementExpr = new GeneratedExpression(leftElementTerm, leftElementNullTerm, "", elementType, GeneratedExpression$.MODULE$.apply$default$5());
            String rightElementTerm = CodeGenUtils$.MODULE$.newName(ctx, "rightElement");
            String rightElementNullTerm = CodeGenUtils$.MODULE$.newName(ctx, "rightElementIsNull");
            GeneratedExpression rightElementExpr = new GeneratedExpression(rightElementTerm, rightElementNullTerm, "", elementType, GeneratedExpression$.MODULE$.apply$default$5());
            String indexTerm = CodeGenUtils$.MODULE$.newName(ctx, "index");
            GeneratedExpression elementEqualsExpr = MODULE$.generateEquals(ctx, leftElementExpr, rightElementExpr, (LogicalType)new BooleanType(elementType.isNullable()));
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(875).append("\n             |boolean ").append(resultTerm).append(";\n             |if (").append(leftTerm).append(" instanceof ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" && ").append(rightTerm).append(" instanceof ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(") {\n             |  ").append(resultTerm).append(" = ").append(leftTerm).append(".equals(").append(rightTerm).append(");\n             |} else {\n             |  if (").append(leftTerm).append(".size() == ").append(rightTerm).append(".size()) {\n             |    ").append(resultTerm).append(" = true;\n             |    for (int ").append(indexTerm).append(" = 0; ").append(indexTerm).append(" < ").append(leftTerm).append(".size(); ").append(indexTerm).append("++) {\n             |      ").append(elementCls).append(" ").append(leftElementTerm).append(" = ").append(elementDefault).append(";\n             |      boolean ").append(leftElementNullTerm).append(" = ").append(leftTerm).append(".isNullAt(").append(indexTerm).append(");\n             |      if (!").append(leftElementNullTerm).append(") {\n             |        ").append(leftElementTerm).append(" =\n             |          ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(indexTerm, leftTerm, elementType)).append(";\n             |      }\n             |\n             |      ").append(elementCls).append(" ").append(rightElementTerm).append(" = ").append(elementDefault).append(";\n             |      boolean ").append(rightElementNullTerm).append(" = ").append(rightTerm).append(".isNullAt(").append(indexTerm).append(");\n             |      if (!").append(rightElementNullTerm).append(") {\n             |        ").append(rightElementTerm).append(" =\n             |          ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(indexTerm, rightTerm, elementType)).append(";\n             |      }\n             |\n             |      ").append(elementEqualsExpr.code()).append("\n             |      if (!").append(elementEqualsExpr.resultTerm()).append(") {\n             |        ").append(resultTerm).append(" = false;\n             |        break;\n             |      }\n             |    }\n             |  } else {\n             |    ").append(resultTerm).append(" = false;\n             |  }\n             |}\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)resultTerm);
        });
    }

    private GeneratedExpression generateMapComparison(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right, LogicalType keyType, LogicalType valueType, LogicalType resultType) {
        return GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, resultType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$4(), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$5(), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)args -> {
            String leftTerm = (String)args.head();
            String rightTerm = (String)args.apply(1);
            String resultTerm = CodeGenUtils$.MODULE$.newName(ctx, "compareResult");
            String mapCls = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any())})));
            String keyCls = CodeGenUtils$.MODULE$.boxedTypeTermForType(keyType);
            String valueCls = CodeGenUtils$.MODULE$.boxedTypeTermForType(valueType);
            String leftMapTerm = CodeGenUtils$.MODULE$.newName(ctx, "leftMap");
            String leftKeyTerm = CodeGenUtils$.MODULE$.newName(ctx, "leftKey");
            String leftValueTerm = CodeGenUtils$.MODULE$.newName(ctx, "leftValue");
            String leftValueNullTerm = CodeGenUtils$.MODULE$.newName(ctx, "leftValueIsNull");
            GeneratedExpression leftValueExpr = new GeneratedExpression(leftValueTerm, leftValueNullTerm, "", valueType, GeneratedExpression$.MODULE$.apply$default$5());
            String rightMapTerm = CodeGenUtils$.MODULE$.newName(ctx, "rightMap");
            String rightValueTerm = CodeGenUtils$.MODULE$.newName(ctx, "rightValue");
            String rightValueNullTerm = CodeGenUtils$.MODULE$.newName(ctx, "rightValueIsNull");
            GeneratedExpression rightValueExpr = new GeneratedExpression(rightValueTerm, rightValueNullTerm, "", valueType, GeneratedExpression$.MODULE$.apply$default$5());
            String entryTerm = CodeGenUtils$.MODULE$.newName(ctx, "entry");
            String entryCls = Map.Entry.class.getCanonicalName();
            GeneratedExpression valueEqualsExpr = MODULE$.generateEquals(ctx, leftValueExpr, rightValueExpr, (LogicalType)new BooleanType(valueType.isNullable()));
            String internalTypeCls = LogicalType.class.getCanonicalName();
            String keyTypeTerm = ctx.addReusableObject(keyType, "keyType", internalTypeCls);
            String valueTypeTerm = ctx.addReusableObject(valueType, "valueType", internalTypeCls);
            String mapDataUtil = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(MapDataUtil.class));
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(862).append("\n             |boolean ").append(resultTerm).append(";\n             |if (").append(leftTerm).append(".size() == ").append(rightTerm).append(".size()) {\n             |  ").append(resultTerm).append(" = true;\n             |  ").append(mapCls).append(" ").append(leftMapTerm).append(" = ").append(mapDataUtil).append("\n             |      .convertToJavaMap(").append(leftTerm).append(", ").append(keyTypeTerm).append(", ").append(valueTypeTerm).append(");\n             |  ").append(mapCls).append(" ").append(rightMapTerm).append(" = ").append(mapDataUtil).append("\n             |      .convertToJavaMap(").append(rightTerm).append(", ").append(keyTypeTerm).append(", ").append(valueTypeTerm).append(");\n             |\n             |  for (").append(entryCls).append(" ").append(entryTerm).append(" : ").append(leftMapTerm).append(".entrySet()) {\n             |    ").append(keyCls).append(" ").append(leftKeyTerm).append(" = (").append(keyCls).append(") ").append(entryTerm).append(".getKey();\n             |    if (").append(rightMapTerm).append(".containsKey(").append(leftKeyTerm).append(")) {\n             |      ").append(valueCls).append(" ").append(leftValueTerm).append(" = (").append(valueCls).append(") ").append(entryTerm).append(".getValue();\n             |      ").append(valueCls).append(" ").append(rightValueTerm).append(" = (").append(valueCls).append(") ").append(rightMapTerm).append(".get(").append(leftKeyTerm).append(");\n             |      boolean ").append(leftValueNullTerm).append(" = (").append(leftValueTerm).append(" == null);\n             |      boolean ").append(rightValueNullTerm).append(" = (").append(rightValueTerm).append(" == null);\n             |\n             |      ").append(valueEqualsExpr.code()).append("\n             |      if (!").append(valueEqualsExpr.resultTerm()).append(") {\n             |        ").append(resultTerm).append(" = false;\n             |        break;\n             |      }\n             |    } else {\n             |      ").append(resultTerm).append(" = false;\n             |      break;\n             |    }\n             |  }\n             |} else {\n             |  ").append(resultTerm).append(" = false;\n             |}\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)resultTerm);
        });
    }

    private GeneratedExpression generateUnaryOperatorIfNotNull(CodeGeneratorContext ctx, LogicalType returnType, GeneratedExpression operand, boolean resultNullable, Function1<String, String> expr) {
        return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), resultNullable, GenerateUtils$.MODULE$.generateCallIfArgsNotNull$default$5(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)args -> (String)expr.apply(args.head()));
    }

    private boolean generateUnaryOperatorIfNotNull$default$4() {
        return false;
    }

    private GeneratedExpression generateOperatorIfNotNull(CodeGeneratorContext ctx, LogicalType returnType, GeneratedExpression left, GeneratedExpression right, boolean resultNullable, Function2<String, String, String> expr) {
        return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), resultNullable, GenerateUtils$.MODULE$.generateCallIfArgsNotNull$default$5(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)args -> (String)expr.apply(args.head(), args.apply(1)));
    }

    private boolean generateOperatorIfNotNull$default$5() {
        return false;
    }

    private GeneratedExpression internalExprCasting(GeneratedExpression expr, LogicalType targetType) {
        LogicalType x$30 = targetType;
        String x$31 = expr.copy$default$1();
        String x$32 = expr.copy$default$2();
        String x$33 = expr.copy$default$3();
        Option<Object> x$34 = expr.copy$default$5();
        return expr.copy(x$31, x$32, x$33, x$30, x$34);
    }

    private Function1<String, String> numericCasting(CodeGeneratorContext ctx, LogicalType operandType, LogicalType resultType) {
        Function1 & Serializable & scala.Serializable intersect;
        if (PlannerTypeUtils.isInteroperable((LogicalType)operandType, (LogicalType)resultType)) {
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> String.valueOf(operandTerm);
        } else {
            CastRule<?, ?> rule = CastRuleProvider.resolve(operandType, resultType);
            CastRule<?, ?> castRule = rule;
            if (!(castRule instanceof ExpressionCodeGeneratorCastRule)) {
                throw new CodeGenException(new StringBuilder(30).append("Unsupported casting from ").append(operandType).append(" to ").append(resultType).append(".").toString());
            }
            ExpressionCodeGeneratorCastRule expressionCodeGeneratorCastRule = (ExpressionCodeGeneratorCastRule)castRule;
            Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)operandTerm -> expressionCodeGeneratorCastRule.generateExpression(MODULE$.toCodegenCastContext(ctx), (String)operandTerm, operandType, resultType);
            intersect = intersect2;
        }
        return intersect;
    }

    public CodeGeneratorCastRule.Context toCodegenCastContext(CodeGeneratorContext ctx) {
        return new CodeGeneratorCastRule.Context(ctx){
            private final CodeGeneratorContext ctx$2;

            public boolean isPrinting() {
                return false;
            }

            public boolean legacyBehaviour() {
                return ScalarOperatorGens$.MODULE$.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$isLegacyCastBehaviourEnabled(this.ctx$2);
            }

            public String getSessionTimeZoneTerm() {
                return this.ctx$2.addReusableSessionTimeZone();
            }

            public String declareVariable(String ty, String variablePrefix) {
                return this.ctx$2.addReusableLocalVariable(ty, variablePrefix);
            }

            public String declareTypeSerializer(LogicalType ty) {
                return this.ctx$2.addReusableTypeSerializer(ty);
            }

            public String declareClassField(String ty, String field, String init) {
                this.ctx$2.addReusableMember(new StringBuilder(13).append("private ").append(ty).append(" ").append(field).append(" = ").append(init).append(";").toString());
                return field;
            }

            public CodeGeneratorContext getCodeGeneratorContext() {
                return this.ctx$2;
            }
            {
                this.ctx$2 = ctx$2;
            }
        };
    }

    public CastRule.Context toCastContext(CodeGeneratorContext ctx) {
        return new CastRule.Context(ctx){
            private final CodeGeneratorContext ctx$9;

            public boolean isPrinting() {
                return false;
            }

            public boolean legacyBehaviour() {
                return ScalarOperatorGens$.MODULE$.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$isLegacyCastBehaviourEnabled(this.ctx$9);
            }

            public ZoneId getSessionZoneId() {
                return TableConfigUtils.getLocalTimeZone(this.ctx$9.tableConfig());
            }

            public ClassLoader getClassLoader() {
                return this.ctx$9.classLoader();
            }

            public CodeGeneratorContext getCodeGeneratorContext() {
                return this.ctx$9;
            }
            {
                this.ctx$9 = ctx$9;
            }
        };
    }

    public boolean org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$isLegacyCastBehaviourEnabled(CodeGeneratorContext ctx) {
        return ((ExecutionConfigOptions.LegacyCastBehaviour)ctx.tableConfig().get(ExecutionConfigOptions.TABLE_EXEC_LEGACY_CAST_BEHAVIOUR)).isEnabled();
    }

    private final Function1 castToDec$1(LogicalType t, CodeGeneratorContext ctx$3, DecimalType resultType$2) {
        LogicalType logicalType = t;
        Function1<String, String> function1 = logicalType instanceof DecimalType ? operandTerm -> String.valueOf(operandTerm) : this.numericCasting(ctx$3, t, (LogicalType)resultType$2);
        return function1;
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$1(String op$1, String l, String r) {
        return new StringBuilder(35).append(l).append(" ").append(op$1).append(" (java.lang.Math.toIntExact(").append(r).append(" / ").append(86400000L).append("L))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$2(String op$1, String l, String r) {
        return new StringBuilder(26).append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis((").append(l).append(" * ").append(86400000L).append("L) ").append(op$1).append(" ").append(r).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$3(String op$1, String l, String r) {
        return new StringBuilder(6).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.ADD_MONTHS())).append("(").append(l).append(", ").append(op$1).append("(").append(r).append("))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$4(String op$1, String l, String r) {
        return new StringBuilder(36).append("java.lang.Math.toIntExact(((").append(l).append(" + ").append(86400000L).append("L) ").append(op$1).append(" (").append(new StringBuilder(38).append("java.lang.Math.toIntExact(").append(r).append(" % ").append(86400000L).append("L))) % ").append(86400000L).append("L)").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$5(String l, String r) {
        return String.valueOf(l);
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$6(String op$1, String l, String r) {
        String leftTerm = new StringBuilder(17).append(l).append(".getMillisecond()").toString();
        String nanoTerm = new StringBuilder(23).append(l).append(".getNanoOfMillisecond()").toString();
        return new StringBuilder(22).append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(leftTerm).append(" ").append(op$1).append(" ").append(r).append(", ").append(nanoTerm).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$7(String op$1, String l, String r) {
        String leftTerm = new StringBuilder(17).append(l).append(".getMillisecond()").toString();
        String nanoTerm = new StringBuilder(23).append(l).append(".getNanoOfMillisecond()").toString();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(100).append("\n                 |").append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(\n                 |  ").append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.ADD_MONTHS())).append("(").append(leftTerm).append(", ").append(op$1).append("(").append(r).append(")),\n                 |  ").append(nanoTerm).append(")\n             ").toString())).stripMargin();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$8(GeneratedExpression left$1, GeneratedExpression right$1, String ll, String rr) {
        Tuple2 tuple2 = new Tuple2((Object)left$1.resultType().getTypeRoot(), (Object)right$1.resultType().getTypeRoot());
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.DATE.equals(logicalTypeRoot2)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                return new StringBuilder(0).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append(new StringBuilder(8).append("(").append(leftTerm).append(", ").append(rr).append(" * ").append(86400000L).append("L)").toString()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot3 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.DATE.equals(logicalTypeRoot) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot3)) {
                String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
                return new StringBuilder(0).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append(new StringBuilder(8).append("(").append(ll).append(" * ").append(86400000L).append("L, ").append(rightTerm).append(")").toString()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot4 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot4)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
                return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(leftTerm).append(", ").append(rightTerm).append(")").toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot5 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot5)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(leftTerm).append(", ").append(rr).append(")").toString();
            }
        }
        if (tuple2 == null) return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(ll).append(", ").append(rr).append(")").toString();
        LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
        LogicalTypeRoot logicalTypeRoot6 = (LogicalTypeRoot)tuple2._2();
        if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(ll).append(", ").append(rr).append(")").toString();
        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot6)) return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(ll).append(", ").append(rr).append(")").toString();
        String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
        return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(ll).append(", ").append(rightTerm).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$9(GeneratedExpression left$1, GeneratedExpression right$1, String op$1, String ll, String rr) {
        Tuple2 tuple2 = new Tuple2((Object)left$1.resultType().getTypeRoot(), (Object)right$1.resultType().getTypeRoot());
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot2)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
                return new StringBuilder(2).append(leftTerm).append(" ").append(op$1).append(" ").append(rightTerm).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot3 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.DATE.equals(logicalTypeRoot) && LogicalTypeRoot.DATE.equals(logicalTypeRoot3)) {
                return new StringBuilder(14).append("(").append(ll).append(" * ").append(86400000L).append("L) ").append(op$1).append(" (").append(rr).append(" * ").append(86400000L).append("L)").toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot4 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.DATE.equals(logicalTypeRoot4)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                return new StringBuilder(8).append(leftTerm).append(" ").append(op$1).append(" (").append(rr).append(" * ").append(86400000L).append("L)").toString();
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
        LogicalTypeRoot logicalTypeRoot5 = (LogicalTypeRoot)tuple2._2();
        if (!LogicalTypeRoot.DATE.equals(logicalTypeRoot)) throw new MatchError((Object)tuple2);
        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot5)) throw new MatchError((Object)tuple2);
        String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
        return new StringBuilder(8).append("(").append(ll).append(" * ").append(86400000L).append("L) ").append(op$1).append(" ").append(rightTerm).toString();
    }

    public static final /* synthetic */ String $anonfun$generateReinterpret$1(String operandTerm) {
        return new StringBuilder(17).append(operandTerm).append(".getMillisecond()").toString();
    }

    public static final /* synthetic */ String $anonfun$generateReinterpret$2(String operandTerm) {
        return new StringBuilder(18).append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(operandTerm).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$generateRow$2(LogicalType x$1) {
        return PlannerTypeUtils.isPrimitive((LogicalType)x$1);
    }

    private final String castIfNumeric$1(GeneratedExpression t, CodeGeneratorContext ctx$1, Option widerType$1) {
        return TypeCheckUtils.isNumeric((LogicalType)((LogicalType)widerType$1.get())) ? String.valueOf(this.numericCasting(ctx$1, t.resultType(), (LogicalType)widerType$1.get()).apply((Object)t.resultTerm())) : String.valueOf(t.resultTerm());
    }

    private ScalarOperatorGens$() {
        MODULE$ = this;
    }
}

