/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;

public class SqlUnparseUtils {
    private SqlUnparseUtils() {
    }

    public static void unparseTableSchema(SqlWriter writer, int leftPrec, int rightPrec, SqlNodeList columnList, List<SqlTableConstraint> constraints, @Nullable SqlWatermark watermark) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.create("sds"), "(", ")");
        for (SqlNode column : columnList) {
            SqlUnparseUtils.printIndent(writer);
            column.unparse(writer, leftPrec, rightPrec);
        }
        if (constraints.size() > 0) {
            for (SqlTableConstraint constraint : constraints) {
                SqlUnparseUtils.printIndent(writer);
                constraint.unparse(writer, leftPrec, rightPrec);
            }
        }
        if (watermark != null) {
            SqlUnparseUtils.printIndent(writer);
            watermark.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(frame);
    }

    public static void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }
}

