/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.relational;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.examples.java.relational.util.WebLogData;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebLogAnalysis {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebLogAnalysis.class);

    public static void main(String[] args) throws Exception {
        LOGGER.warn("All Flink DataSet APIs are deprecated since Flink 1.18 and will be removed in a future Flink major version. You can still build your application in DataSet, but you should move to either the DataStream and/or Table API. This class is retained for testing purposes. See Also: https://cwiki.apache.org/confluence/pages/viewpage.action?pageId=158866741");
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        DataSet<Tuple2<String, String>> documents = WebLogAnalysis.getDocumentsDataSet(env, params);
        DataSet<Tuple3<Integer, String, Integer>> ranks = WebLogAnalysis.getRanksDataSet(env, params);
        DataSet<Tuple2<String, String>> visits = WebLogAnalysis.getVisitsDataSet(env, params);
        ProjectOperator filterDocs = documents.filter((FilterFunction)new FilterDocByKeyWords()).project(new int[]{0});
        FilterOperator filterRanks = ranks.filter((FilterFunction)new FilterByRank());
        ProjectOperator filterVisits = visits.filter((FilterFunction)new FilterVisitsByDate()).project(new int[]{0});
        JoinOperator.ProjectJoin joinDocsRanks = filterDocs.join((DataSet)filterRanks).where(new int[]{0}).equalTo(new int[]{1}).projectSecond(new int[]{0, 1, 2});
        CoGroupOperator result = joinDocsRanks.coGroup((DataSet)filterVisits).where(new int[]{1}).equalTo(new int[]{0}).with((CoGroupFunction)new AntiJoinVisits());
        if (params.has("output")) {
            result.writeAsCsv(params.get("output"), "\n", "|");
            env.execute("WebLogAnalysis Example");
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            result.print();
        }
    }

    private static DataSet<Tuple2<String, String>> getDocumentsDataSet(ExecutionEnvironment env, ParameterTool params) {
        if (params.has("documents")) {
            return env.readCsvFile(params.get("documents")).fieldDelimiter("|").types(String.class, String.class);
        }
        System.out.println("Executing WebLogAnalysis example with default documents data set.");
        System.out.println("Use --documents to specify file input.");
        return WebLogData.getDocumentDataSet(env);
    }

    private static DataSet<Tuple3<Integer, String, Integer>> getRanksDataSet(ExecutionEnvironment env, ParameterTool params) {
        if (params.has("ranks")) {
            return env.readCsvFile(params.get("ranks")).fieldDelimiter("|").types(Integer.class, String.class, Integer.class);
        }
        System.out.println("Executing WebLogAnalysis example with default ranks data set.");
        System.out.println("Use --ranks to specify file input.");
        return WebLogData.getRankDataSet(env);
    }

    private static DataSet<Tuple2<String, String>> getVisitsDataSet(ExecutionEnvironment env, ParameterTool params) {
        if (params.has("visits")) {
            return env.readCsvFile(params.get("visits")).fieldDelimiter("|").includeFields("011000000").types(String.class, String.class);
        }
        System.out.println("Executing WebLogAnalysis example with default visits data set.");
        System.out.println("Use --visits to specify file input.");
        return WebLogData.getVisitDataSet(env);
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"*"})
    public static class AntiJoinVisits
    implements CoGroupFunction<Tuple3<Integer, String, Integer>, Tuple1<String>, Tuple3<Integer, String, Integer>> {
        public void coGroup(Iterable<Tuple3<Integer, String, Integer>> ranks, Iterable<Tuple1<String>> visits, Collector<Tuple3<Integer, String, Integer>> out) {
            if (!visits.iterator().hasNext()) {
                for (Tuple3<Integer, String, Integer> next : ranks) {
                    out.collect(next);
                }
            }
        }
    }

    public static class FilterVisitsByDate
    implements FilterFunction<Tuple2<String, String>> {
        private static final int YEARFILTER = 2007;

        public boolean filter(Tuple2<String, String> value) throws Exception {
            String dateString = (String)value.f1;
            int year = Integer.parseInt(dateString.substring(0, 4));
            return year == 2007;
        }
    }

    public static class FilterByRank
    implements FilterFunction<Tuple3<Integer, String, Integer>> {
        private static final int RANKFILTER = 40;

        public boolean filter(Tuple3<Integer, String, Integer> value) throws Exception {
            return (Integer)value.f0 > 40;
        }
    }

    public static class FilterDocByKeyWords
    implements FilterFunction<Tuple2<String, String>> {
        private static final String[] KEYWORDS = new String[]{" editors ", " oscillations "};

        public boolean filter(Tuple2<String, String> value) throws Exception {
            String docText = (String)value.f1;
            for (String kw : KEYWORDS) {
                if (docText.contains(kw)) continue;
                return false;
            }
            return true;
        }
    }
}

