/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.statemachine.generator;

import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.connector.datagen.source.GeneratorFunction;
import org.apache.flink.streaming.examples.statemachine.event.Event;
import org.apache.flink.streaming.examples.statemachine.generator.EventsGenerator;
import org.apache.flink.util.Preconditions;

public class EventsGeneratorFunction
implements GeneratorFunction<Long, Event> {
    private final double errorProbability;
    transient EventsGenerator generator;
    private int min;
    private int max;

    public EventsGeneratorFunction(double errorProbability) {
        Preconditions.checkArgument((errorProbability >= 0.0 && errorProbability <= 1.0 ? 1 : 0) != 0, (Object)"error probability must be in [0.0, 1.0]");
        this.errorProbability = errorProbability;
    }

    @Override
    public void open(SourceReaderContext readerContext) throws Exception {
        int range = Integer.MAX_VALUE / readerContext.currentParallelism();
        this.min = range * readerContext.getIndexOfSubtask();
        this.max = this.min + range;
        this.generator = new EventsGenerator(this.errorProbability);
    }

    @Override
    public Event map(Long value) throws Exception {
        return this.generator.next(this.min, this.max);
    }
}

