/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.graph;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.examples.java.graph.util.ConnectedComponentsData;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedComponents {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectedComponents.class);

    public static void main(String ... args) throws Exception {
        LOGGER.warn("All Flink DataSet APIs are deprecated since Flink 1.18 and will be removed in a future Flink major version. You can still build your application in DataSet, but you should move to either the DataStream and/or Table API. This class is retained for testing purposes. See Also: https://cwiki.apache.org/confluence/pages/viewpage.action?pageId=158866741");
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        int maxIterations = params.getInt("iterations", 10);
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        DataSet<Long> vertices = ConnectedComponents.getVertexDataSet(env, params);
        FlatMapOperator edges = ConnectedComponents.getEdgeDataSet(env, params).flatMap((FlatMapFunction)new UndirectEdge());
        MapOperator verticesWithInitialId = vertices.map(new DuplicateValue());
        DeltaIteration iteration = verticesWithInitialId.iterateDelta((DataSet)verticesWithInitialId, maxIterations, new int[]{0});
        JoinOperator.EquiJoin changes = iteration.getWorkset().join((DataSet)edges).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new NeighborWithComponentIDJoin()).groupBy(new int[]{0}).aggregate(Aggregations.MIN, 1).join((DataSet)iteration.getSolutionSet()).where(new int[]{0}).equalTo(new int[]{0}).with((FlatJoinFunction)new ComponentIdFilter());
        DataSet result = iteration.closeWith((DataSet)changes, (DataSet)changes);
        if (params.has("output")) {
            result.writeAsCsv(params.get("output"), "\n", " ");
            env.execute("Connected Components Example");
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            result.print();
        }
    }

    private static DataSet<Long> getVertexDataSet(ExecutionEnvironment env, ParameterTool params) {
        if (params.has("vertices")) {
            return env.readCsvFile(params.get("vertices")).types(Long.class).map((MapFunction)new MapFunction<Tuple1<Long>, Long>(){

                public Long map(Tuple1<Long> value) {
                    return (Long)value.f0;
                }
            });
        }
        System.out.println("Executing Connected Components example with default vertices data set.");
        System.out.println("Use --vertices to specify file input.");
        return ConnectedComponentsData.getDefaultVertexDataSet(env);
    }

    private static DataSet<Tuple2<Long, Long>> getEdgeDataSet(ExecutionEnvironment env, ParameterTool params) {
        if (params.has("edges")) {
            return env.readCsvFile(params.get("edges")).fieldDelimiter(" ").types(Long.class, Long.class);
        }
        System.out.println("Executing Connected Components example with default edges data set.");
        System.out.println("Use --edges to specify file input.");
        return ConnectedComponentsData.getDefaultEdgeDataSet(env);
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"*"})
    public static final class ComponentIdFilter
    implements FlatJoinFunction<Tuple2<Long, Long>, Tuple2<Long, Long>, Tuple2<Long, Long>> {
        public void join(Tuple2<Long, Long> candidate, Tuple2<Long, Long> old, Collector<Tuple2<Long, Long>> out) {
            if ((Long)candidate.f1 < (Long)old.f1) {
                out.collect(candidate);
            }
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"f1->f1"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"f1->f0"})
    public static final class NeighborWithComponentIDJoin
    implements JoinFunction<Tuple2<Long, Long>, Tuple2<Long, Long>, Tuple2<Long, Long>> {
        public Tuple2<Long, Long> join(Tuple2<Long, Long> vertexWithComponent, Tuple2<Long, Long> edge) {
            return new Tuple2(edge.f1, vertexWithComponent.f1);
        }
    }

    public static final class UndirectEdge
    implements FlatMapFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        Tuple2<Long, Long> invertedEdge = new Tuple2();

        public void flatMap(Tuple2<Long, Long> edge, Collector<Tuple2<Long, Long>> out) {
            this.invertedEdge.f0 = edge.f1;
            this.invertedEdge.f1 = edge.f0;
            out.collect(edge);
            out.collect(this.invertedEdge);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0"})
    public static final class DuplicateValue<T>
    implements MapFunction<T, Tuple2<T, T>> {
        public Tuple2<T, T> map(T vertex) {
            return new Tuple2(vertex, vertex);
        }
    }
}

