/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.utils;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.fs.gs.org.apache.flink.runtime.util.HadoopConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtils.class);
    private static final String HADOOP_CONFIG_PREFIX = "fs.gs.";
    private static final String[] FLINK_CONFIG_PREFIXES = new String[]{"gs.", "fs.gs."};
    private static final String[][] MIRRORED_CONFIG_KEYS = new String[0][];
    private static final String FLINK_SHADING_PREFIX = "";
    private static final String HADOOP_OPTION_ENABLE_SERVICE_ACCOUNT = "google.cloud.auth.service.account.enable";
    private static final String HADOOP_OPTION_SERVICE_ACCOUNT_JSON_KEYFILE = "google.cloud.auth.service.account.json.keyfile";

    public static org.apache.hadoop.conf.Configuration getHadoopConfiguration(Configuration flinkConfig, ConfigContext configContext) {
        org.apache.hadoop.conf.Configuration hadoopConfig = new org.apache.hadoop.conf.Configuration();
        Optional<Object> hadoopConfigDir = Optional.ofNullable(flinkConfig.get(CoreOptions.FLINK_HADOOP_CONF_DIR));
        if (!hadoopConfigDir.isPresent()) {
            hadoopConfigDir = configContext.getenv("HADOOP_CONF_DIR");
        }
        hadoopConfigDir.ifPresent(configDir -> {
            LOGGER.info("Loading Hadoop config resources from {}", configDir);
            hadoopConfig.addResource(configContext.loadHadoopConfigFromDir((String)configDir));
        });
        HadoopConfigLoader hadoopConfigLoader = new HadoopConfigLoader(FLINK_CONFIG_PREFIXES, MIRRORED_CONFIG_KEYS, HADOOP_CONFIG_PREFIX, Collections.emptySet(), Collections.emptySet(), FLINK_SHADING_PREFIX);
        hadoopConfigLoader.setFlinkConfig(flinkConfig);
        org.apache.hadoop.conf.Configuration flinkHadoopConfig = hadoopConfigLoader.getOrLoadHadoopConfig();
        hadoopConfig.addResource(flinkHadoopConfig);
        hadoopConfig.reloadConfiguration();
        return hadoopConfig;
    }

    public static Optional<GoogleCredentials> getStorageCredentials(org.apache.hadoop.conf.Configuration hadoopConfig, ConfigContext configContext) {
        Optional<Object> credentialsPath = Optional.empty();
        boolean enableServiceAccount = hadoopConfig.getBoolean(HADOOP_OPTION_ENABLE_SERVICE_ACCOUNT, true);
        if (enableServiceAccount) {
            credentialsPath = configContext.getenv("GOOGLE_APPLICATION_CREDENTIALS");
            if (credentialsPath.isPresent()) {
                LOGGER.info("GSRecoverableWriter is using GOOGLE_APPLICATION_CREDENTIALS at {}", credentialsPath.get());
            } else {
                credentialsPath = Optional.ofNullable(hadoopConfig.get(HADOOP_OPTION_SERVICE_ACCOUNT_JSON_KEYFILE));
                credentialsPath.ifPresent(path -> LOGGER.info("GSRecoverableWriter is using credentials from Hadoop at {}", path));
            }
        }
        if (credentialsPath.isPresent()) {
            LOGGER.info("Creating GSRecoverableWriter using credentials from {}", credentialsPath.get());
            GoogleCredentials credentials = configContext.loadStorageCredentialsFromFile((String)credentialsPath.get());
            return Optional.of(credentials);
        }
        LOGGER.info("Creating GSRecoverableWriter using no credentials");
        return Optional.empty();
    }

    public static Optional<String> getGcsRootUrl(org.apache.hadoop.conf.Configuration hadoopConfig) {
        BiFunction<String, String, String> getterFn = (key, defaultValue) -> hadoopConfig.get((String)key);
        String value = GoogleHadoopFileSystemConfiguration.GCS_ROOT_URL.get(hadoopConfig, getterFn);
        return Optional.ofNullable(value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String stringifyHadoopConfig(org.apache.hadoop.conf.Configuration hadoopConfig) throws RuntimeException {
        try (StringWriter writer = new StringWriter();){
            org.apache.hadoop.conf.Configuration.dumpConfiguration(hadoopConfig, writer);
            String string = ((Object)writer).toString();
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static interface ConfigContext {
        public Optional<String> getenv(String var1);

        public org.apache.hadoop.conf.Configuration loadHadoopConfigFromDir(String var1);

        public GoogleCredentials loadStorageCredentialsFromFile(String var1);
    }
}

