/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponseException;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

public final class GoogleCloudStorageExceptions {
    private GoogleCloudStorageExceptions() {
    }

    public static FileNotFoundException createFileNotFoundException(String bucketName, String objectName, @Nullable IOException cause) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        FileNotFoundException fileNotFoundException = new FileNotFoundException(String.format("Item not found: '%s'. Note, it is possible that the live version is still available but the requested generation is deleted.", StringPaths.fromComponents(bucketName, Strings.nullToEmpty(objectName))));
        if (cause != null) {
            fileNotFoundException.initCause(cause);
        }
        return fileNotFoundException;
    }

    public static FileNotFoundException createFileNotFoundException(StorageResourceId resourceId, @Nullable IOException cause) {
        return GoogleCloudStorageExceptions.createFileNotFoundException(resourceId.getBucketName(), resourceId.getObjectName(), cause);
    }

    public static IOException createCompositeException(Collection<IOException> innerExceptions) {
        Preconditions.checkArgument(innerExceptions != null && !innerExceptions.isEmpty(), "innerExceptions (%s) must be not null and contain at least one element", innerExceptions);
        Iterator<IOException> innerExceptionIterator = innerExceptions.iterator();
        if (innerExceptions.size() == 1) {
            return innerExceptionIterator.next();
        }
        IOException combined = new IOException("Multiple IOExceptions.");
        while (innerExceptionIterator.hasNext()) {
            combined.addSuppressed(innerExceptionIterator.next());
        }
        return combined;
    }

    public static GoogleJsonResponseException createJsonResponseException(GoogleJsonError e, HttpHeaders responseHeaders) {
        if (e != null) {
            return new GoogleJsonResponseException(new HttpResponseException.Builder(e.getCode(), e.getMessage(), responseHeaders), e);
        }
        return null;
    }
}

