/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.token;

import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.security.token.DelegationTokenProvider;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractS3DelegationTokenProvider
implements DelegationTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractS3DelegationTokenProvider.class);
    private String region;
    private String accessKey;
    private String secretKey;

    public void init(Configuration configuration) {
        this.region = configuration.getString(String.format("%s.region", this.serviceConfigPrefix()), null);
        if (!StringUtils.isNullOrWhitespaceOnly((String)this.region)) {
            LOG.debug("Region: " + this.region);
        }
        this.accessKey = configuration.getString(String.format("%s.access-key", this.serviceConfigPrefix()), null);
        if (!StringUtils.isNullOrWhitespaceOnly((String)this.accessKey)) {
            LOG.debug("Access key: " + this.accessKey);
        }
        this.secretKey = configuration.getString(String.format("%s.secret-key", this.serviceConfigPrefix()), null);
        if (!StringUtils.isNullOrWhitespaceOnly((String)this.secretKey)) {
            LOG.debug("Secret key: ****** (sensitive information)");
        }
    }

    public boolean delegationTokensRequired() {
        if (StringUtils.isNullOrWhitespaceOnly((String)this.region) || StringUtils.isNullOrWhitespaceOnly((String)this.accessKey) || StringUtils.isNullOrWhitespaceOnly((String)this.secretKey)) {
            LOG.debug("Not obtaining session credentials because not all configurations are set");
            return false;
        }
        return true;
    }

    public DelegationTokenProvider.ObtainedDelegationTokens obtainDelegationTokens() throws Exception {
        LOG.info("Obtaining session credentials token with access key: {}", (Object)this.accessKey);
        AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(this.region)).withCredentials(new AWSStaticCredentialsProvider(new BasicAWSCredentials(this.accessKey, this.secretKey)))).build();
        GetSessionTokenResult sessionTokenResult = stsClient.getSessionToken();
        Credentials credentials = sessionTokenResult.getCredentials();
        LOG.info("Session credentials obtained successfully with access key: {} expiration: {}", (Object)credentials.getAccessKeyId(), (Object)credentials.getExpiration());
        return new DelegationTokenProvider.ObtainedDelegationTokens(InstantiationUtil.serializeObject((Object)credentials), Optional.of(credentials.getExpiration().getTime()));
    }
}

