/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util.corruptio;

import java.io.File;

public class CorruptibleIo {
    private static CorruptibleIo instance = new CorruptibleIo();
    private boolean corruptLog = false;
    private boolean corruptData = false;
    private int corruptLength;
    private int corruptOffset;

    private CorruptibleIo() {
    }

    public static CorruptibleIo getInstance() {
        return instance;
    }

    public void setLogCorruption(boolean corrupt) {
        this.corruptLog = corrupt;
    }

    public void setDataCorruption(boolean corrupt) {
        this.corruptData = corrupt;
    }

    public void setOffset(int off) {
        this.corruptOffset = off;
    }

    public void setLength(int len) {
        this.corruptLength = len;
    }

    public int getOffset() {
        return this.corruptOffset;
    }

    public int getLength() {
        return this.corruptLength;
    }

    public boolean isCorruptibleFile(File file) {
        String name = file.getName();
        String parentName = file.getParent();
        if (parentName.endsWith("log") && name.endsWith("dat")) {
            return this.corruptLog;
        }
        if (parentName.endsWith("seg0")) {
            return this.corruptData;
        }
        return false;
    }

    public byte[] corrupt(byte[] b, int off, int len) {
        if (this.corruptOffset >= off && this.corruptOffset + this.corruptLength < off + len) {
            for (int i = this.corruptOffset; i < this.corruptOffset + this.corruptLength; ++i) {
                b[i] = ~b[i];
            }
        } else {
            System.out.println("Not valid corrupt request :Write RequestOff=" + off + "size = " + len + "Corrupt RequestOff=" + this.corruptOffset + "size = " + this.corruptLength);
        }
        return b;
    }
}

