/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ErrorStreamTest
extends BaseJDBCTestCase {
    private static final String FILE_PROP = "derby.stream.error.file";
    private static final String METHOD_PROP = "derby.stream.error.method";
    private static final String FIELD_PROP = "derby.stream.error.field";
    private static final String STYLE_PROP = "derby.stream.error.style";
    private static final String ROLLING_FILE_STYLE = "rollingFile";
    private static final String ROLLING_FILE_COUNT_PROP = "derby.stream.error.rollingFile.count";
    private static final String ROLLING_FILE_LIMIT_PROP = "derby.stream.error.rollingFile.limit";
    private static final String ROLLING_FILE_PATTERN_PROP = "derby.stream.error.rollingFile.pattern";
    private static final String DERBY_0_LOG = "derby-0.log";
    private static final String DERBYLANGUAGELOG_QUERY_PLAN = "derby.language.logQueryPlan";
    private static final String LOGFILESDIR = "logfilesdir";
    private static int runNo = 0;
    private File fileStreamFile;
    private static OutputStream methodStream;
    private File methodStreamFile;
    public static OutputStream fieldStream;
    private File fieldStreamFile;
    private OutputStream errStream;
    private File errStreamFile;

    public ErrorStreamTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(ErrorStreamTest.class);
    }

    public void setUp() throws Exception {
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.openStreams();
    }

    @Override
    public void tearDown() throws Exception {
        ErrorStreamTest.resetProps();
        this.closeStreams();
        this.nullFields();
        super.tearDown();
    }

    public void testDefault() throws IOException, SQLException {
        File derbyLog = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "derby.log");
        this.bootDerby();
        ErrorStreamTest.assertIsExisting(derbyLog);
        ErrorStreamTest.assertNotDirectory(derbyLog);
        ErrorStreamTest.assertNotEmpty(derbyLog);
        ErrorStreamTest.println("Shutdown database");
        this.getTestConfiguration().shutdownDatabase();
        ErrorStreamTest.assertIsExisting(derbyLog);
        ErrorStreamTest.assertNotDirectory(derbyLog);
        ErrorStreamTest.assertNotEmpty(derbyLog);
        ErrorStreamTest.println("Shutdown engine");
        this.getTestConfiguration().shutdownEngine();
        boolean deleted = ErrorStreamTest.deleteFile(derbyLog);
        ErrorStreamTest.assertTrue((String)("File " + derbyLog + " could not be deleted"), (boolean)deleted);
    }

    public void testFile() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testWrongFile() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(new File(new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "foo"), ErrorStreamTest.makeStreamFilename("file"))));
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertNotEmpty(this.errStreamFile);
    }

    public void testMethod() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertNotEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testWrongMethod() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.nonExistingGetStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertNotEmpty(this.errStreamFile);
    }

    public void testField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertNotEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testWrongField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.nonExistingFieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertNotEmpty(this.errStreamFile);
    }

    public void testFileOverMethod() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testFileOverField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testFileOverMethodAndField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testMethodOverField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertNotEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testStyleRollingFile() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        File derby0log = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), DERBY_0_LOG);
        File derby0lck = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "derby-0.log.lck");
        this.bootDerby();
        ErrorStreamTest.assertIsExisting(derby0log);
        ErrorStreamTest.assertNotDirectory(derby0log);
        ErrorStreamTest.assertNotEmpty(derby0log);
        ErrorStreamTest.assertIsExisting(derby0lck);
        ErrorStreamTest.assertNotDirectory(derby0lck);
        ErrorStreamTest.assertIsEmpty(derby0lck);
        ErrorStreamTest.println("Shutdown database");
        this.getTestConfiguration().shutdownDatabase();
        ErrorStreamTest.assertIsExisting(derby0log);
        ErrorStreamTest.assertNotDirectory(derby0log);
        ErrorStreamTest.assertNotEmpty(derby0log);
        ErrorStreamTest.assertIsExisting(derby0lck);
        ErrorStreamTest.assertNotDirectory(derby0lck);
        ErrorStreamTest.assertIsEmpty(derby0lck);
        ErrorStreamTest.println("Shutdown engine");
        this.getTestConfiguration().shutdownEngine();
        ErrorStreamTest.assertNotExisting(derby0lck);
        boolean deleted = ErrorStreamTest.deleteFile(derby0log);
        ErrorStreamTest.assertTrue((String)("File " + derby0log + " could not be deleted"), (boolean)deleted);
    }

    public void testWrongStyle() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(STYLE_PROP, "unknownStyle");
        File derby0log = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), DERBY_0_LOG);
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(derby0log);
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertNotEmpty(this.errStreamFile);
    }

    public void testDefaultRollingDefaultConfig() throws IOException, SQLException {
        int i;
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        ErrorStreamTest.setSystemProperty(DERBYLANGUAGELOG_QUERY_PLAN, "true");
        this.bootDerby();
        for (i = 0; i < 3699; ++i) {
            this.checkAllConsistency(this.getConnection());
        }
        ErrorStreamTest.removeSystemProperty(DERBYLANGUAGELOG_QUERY_PLAN);
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        for (i = 0; i < 10; ++i) {
            File derbyLog = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "derby-" + i + ".log");
            ErrorStreamTest.assertIsExisting(derbyLog);
            ErrorStreamTest.assertNotDirectory(derbyLog);
            ErrorStreamTest.assertNotEmpty(derbyLog);
            if (i == 9) {
                ErrorStreamTest.assertFileSize(derbyLog, 1024000);
            }
            boolean deleted = ErrorStreamTest.deleteFile(derbyLog);
            ErrorStreamTest.assertTrue((String)("File " + derbyLog + " could not be deleted"), (boolean)deleted);
        }
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testDefaultRollingUserConfig() throws IOException, SQLException {
        int i;
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        ErrorStreamTest.setSystemProperty(ROLLING_FILE_PATTERN_PROP, "%d/db-%g.log");
        ErrorStreamTest.setSystemProperty(ROLLING_FILE_COUNT_PROP, "3");
        ErrorStreamTest.setSystemProperty(ROLLING_FILE_LIMIT_PROP, "10000");
        ErrorStreamTest.setSystemProperty(DERBYLANGUAGELOG_QUERY_PLAN, "true");
        this.bootDerby();
        for (i = 0; i < 10; ++i) {
            this.checkAllConsistency(this.getConnection());
        }
        ErrorStreamTest.removeSystemProperty(DERBYLANGUAGELOG_QUERY_PLAN);
        ErrorStreamTest.removeSystemProperty(ROLLING_FILE_PATTERN_PROP);
        ErrorStreamTest.removeSystemProperty(ROLLING_FILE_COUNT_PROP);
        ErrorStreamTest.removeSystemProperty(ROLLING_FILE_LIMIT_PROP);
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        for (i = 0; i < 3; ++i) {
            File derbyLog = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "db-" + i + ".log");
            ErrorStreamTest.assertIsExisting(derbyLog);
            ErrorStreamTest.assertNotDirectory(derbyLog);
            ErrorStreamTest.assertNotEmpty(derbyLog);
            if (i == 2) {
                ErrorStreamTest.assertFileSize(derbyLog, 10000);
            }
            boolean deleted = ErrorStreamTest.deleteFile(derbyLog);
            ErrorStreamTest.assertTrue((String)("File " + derbyLog + " could not be deleted"), (boolean)deleted);
        }
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testRollingFileStyleOverFile() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        File derby0log = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), DERBY_0_LOG);
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(derby0log);
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testRollingFileStyleOverMethod() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        File derby0log = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), DERBY_0_LOG);
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(derby0log);
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
        boolean deleted = ErrorStreamTest.deleteFile(derby0log);
        ErrorStreamTest.assertTrue((String)("File " + derby0log + " could not be deleted"), (boolean)deleted);
    }

    public void testRollingFileStyleOverField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        File derby0log = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), DERBY_0_LOG);
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(derby0log);
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
        boolean deleted = ErrorStreamTest.deleteFile(derby0log);
        ErrorStreamTest.assertTrue((String)("File " + derby0log + " could not be deleted"), (boolean)deleted);
    }

    public static OutputStream getStream() {
        return methodStream;
    }

    private static String makeStreamFilename(String type) {
        return type + "-" + runNo + ".log";
    }

    private void openStreams() throws IOException {
        String systemHome = ErrorStreamTest.getSystemProperty("derby.system.home");
        String logFilesHome = systemHome + File.separatorChar + LOGFILESDIR;
        ErrorStreamTest.makeDirIfNotExisting(systemHome);
        ErrorStreamTest.makeDirIfNotExisting(logFilesHome);
        ++runNo;
        this.methodStreamFile = new File(logFilesHome, ErrorStreamTest.makeStreamFilename("method"));
        this.fileStreamFile = new File(logFilesHome, ErrorStreamTest.makeStreamFilename("file"));
        this.fieldStreamFile = new File(logFilesHome, ErrorStreamTest.makeStreamFilename("field"));
        this.errStreamFile = new File(logFilesHome, ErrorStreamTest.makeStreamFilename("err"));
        methodStream = ErrorStreamTest.newFileOutputStream(this.methodStreamFile);
        fieldStream = ErrorStreamTest.newFileOutputStream(this.fieldStreamFile);
        this.errStream = ErrorStreamTest.newFileOutputStream(this.errStreamFile);
        ErrorStreamTest.setSystemErr(new PrintStream(this.errStream));
    }

    private void closeStreams() throws IOException {
        try {
            methodStream.close();
            fieldStream.close();
            this.errStream.close();
            ErrorStreamTest.setSystemErr(System.out);
        }
        catch (IOException e) {
            ErrorStreamTest.println("Could not close stream files");
            throw e;
        }
    }

    private static void assertNotDirectory(final File f) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    Assert.assertFalse((String)("assertNotDirectory failed: " + f.getCanonicalPath()), (boolean)f.isDirectory());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static void assertIsEmpty(File f) throws IOException {
        String path = ErrorStreamTest.getCanonicalPath(f);
        ErrorStreamTest.assertTrue((String)(path + " doesn't exist"), (boolean)PrivilegedFileOpsForTests.exists(f));
        ErrorStreamTest.assertEquals((String)(path + " is not empty"), (long)0L, (long)PrivilegedFileOpsForTests.length(f));
    }

    private static void assertNotEmpty(final File f) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    Assert.assertTrue((String)("assertNotEmpty failed: " + f.getCanonicalPath() + " does not exist."), (boolean)f.exists());
                    FileInputStream fis = new FileInputStream(f);
                    int result = fis.read();
                    fis.close();
                    Assert.assertTrue((String)("assertNotEmpty failed: " + f.getCanonicalPath() + " is empty."), (-1 != result ? 1 : 0) != 0);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static void assertFileSize(final File f, final int size) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    Assert.assertEquals((String)("assertFileEize failed for file " + f.getName() + ": "), (long)size, (long)f.length());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static void assertIsExisting(File f) throws IOException {
        String path = ErrorStreamTest.getCanonicalPath(f);
        ErrorStreamTest.assertTrue((String)(path + " doesn't exist"), (boolean)PrivilegedFileOpsForTests.exists(f));
    }

    private static void assertNotExisting(File f) throws IOException {
        String path = ErrorStreamTest.getCanonicalPath(f);
        ErrorStreamTest.assertFalse((String)(path + " exists"), (boolean)PrivilegedFileOpsForTests.exists(f));
    }

    private static boolean deleteFile(File f) {
        return PrivilegedFileOpsForTests.delete(f);
    }

    private static String getCanonicalPath(final File f) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    return f.getCanonicalPath();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static void makeDirIfNotExisting(final String filename) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                File f = new File(filename);
                if (!f.exists()) {
                    f.mkdir();
                }
                return null;
            }
        });
    }

    private static FileOutputStream newFileOutputStream(final File f) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(f);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    private static void resetProps() {
        ErrorStreamTest.removeSystemProperty(FILE_PROP);
        ErrorStreamTest.removeSystemProperty(METHOD_PROP);
        ErrorStreamTest.removeSystemProperty(FIELD_PROP);
        ErrorStreamTest.removeSystemProperty(STYLE_PROP);
    }

    private void deleteStreamFiles() {
        ErrorStreamTest.deleteFile(this.fileStreamFile);
        ErrorStreamTest.deleteFile(this.methodStreamFile);
        ErrorStreamTest.deleteFile(this.fieldStreamFile);
        ErrorStreamTest.deleteFile(this.errStreamFile);
    }

    private void nullFields() {
        this.fileStreamFile = null;
        this.methodStreamFile = null;
        this.fieldStreamFile = null;
        this.errStreamFile = null;
        methodStream = null;
        fieldStream = null;
        this.errStream = null;
    }

    private void bootDerby() throws SQLException {
        this.getConnection();
        this.getConnection().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runBareOverridable() throws Throwable {
        PrintStream out = System.out;
        TestConfiguration config = this.getTestConfiguration();
        boolean stopAfterFirstFail = config.stopAfterFirstFail();
        try {
            super.runBareOverridable();
        }
        catch (Throwable running) {
            PrintWriter stackOut = null;
            try {
                this.copyFileToFail(LOGFILESDIR);
                this.nullFields();
                this.deleteFile(LOGFILESDIR);
                this.copyFileToFail(DERBY_0_LOG);
                this.copyFileToFail("derby-0.log.lck");
                for (int i = 0; i < 3; ++i) {
                    this.copyFileToFail("db-" + i + ".log");
                    this.deleteFile("db-" + i + ".log");
                }
            }
            catch (IOException ioe) {
                BaseTestCase.printStackTrace(ioe);
                if (stackOut != null) {
                    stackOut.println("Copying derby.log or database failed:");
                    ioe.printStackTrace(stackOut);
                    stackOut.println();
                }
            }
            finally {
                if (stackOut != null) {
                    stackOut.close();
                }
                if (!stopAfterFirstFail) {
                    throw running;
                }
                running.printStackTrace(out);
                System.exit(1);
            }
        }
        finally {
            this.getTestConfiguration().shutdownEngine();
            File origLogFilesDir = new File("system", LOGFILESDIR);
            this.nullFields();
            ErrorStreamTest.removeDirectory(origLogFilesDir);
            this.deleteFile("derby-0.log.lck");
            this.deleteFile(DERBY_0_LOG);
            this.deleteFile("derby.log");
        }
    }

    private void copyFileToFail(String origFileName) throws IOException {
        String failPath = PrivilegedFileOpsForTests.getAbsolutePath(this.getFailureFolder());
        File origFile = new File("system", origFileName);
        File newFile = new File(failPath, origFileName);
        PrivilegedFileOpsForTests.copy(origFile, newFile);
    }

    private void deleteFile(String origFileName) throws IOException {
        File origFile = new File("system", origFileName);
        PrivilegedFileOpsForTests.delete(origFile);
    }
}

