/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class SuicideOfStreamingTest
extends BaseJDBCTestCase {
    public SuicideOfStreamingTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        Statement createTableSt = this.createStatement();
        createTableSt.execute("create table TEST_TABLE( TEST_COL blob( 65536 ))");
        createTableSt.close();
        PreparedStatement insertLobSt = this.prepareStatement("insert into TEST_TABLE (TEST_COL) values (?)");
        int lobLength = 65536;
        insertLobSt.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(lobLength), lobLength);
        insertLobSt.executeUpdate();
        insertLobSt.close();
        SuicideOfStreamingTest.setSystemProperty("derby.debug.suicideOfLayerBStreaming", "true");
    }

    @Override
    public void tearDown() throws Exception {
        SuicideOfStreamingTest.removeSystemProperty("derby.debug.suicideOfLayerBStreaming");
        super.tearDown();
    }

    public void testInterruptedReadOfLob() throws IOException, SQLException {
        PreparedStatement fetchLobSt = this.prepareStatement("select TEST_COL from TEST_TABLE");
        ResultSet rs = fetchLobSt.executeQuery();
        try {
            int c;
            rs.next();
            InputStream is = rs.getBinaryStream(1);
            while ((c = is.read()) > -1) {
            }
            SuicideOfStreamingTest.fail((String)"Reading stream should have raised exception.");
        }
        catch (SQLException sqle) {
            SuicideOfStreamingTest.assertSQLState("58009", sqle);
        }
        rs.close();
        fetchLobSt.close();
    }

    public static Test suite() {
        return new BaseTestSuite("SuicideOfStreamingTest <DISABLED IN INSANE MODE>");
    }
}

